CREATE TABLE `access_info` (
  `user_id` int(10) unsigned NOT NULL,
  `login_period` datetime NOT NULL,
  `logout_period` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `ad_pay` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `emp_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `pay_amount` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `ad_salary` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `emp_id` int(10) NOT NULL,
  `date` date NOT NULL,
  `advance_amount` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `admissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `pid` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `guardian` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `seat` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `bill` int(11) NOT NULL COMMENT 'ID of bills table',
  `status` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'admitted' COMMENT 'admitted or released',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `altra_doctor_payment` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `doctor_id` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `payment` decimal(8,2) NOT NULL,
  `trash` int(10) NOT NULL DEFAULT 0,
  UNIQUE KEY `id` (`id`),
  KEY `rf_pc_id` (`doctor_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `date` date NOT NULL,
  `patient_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `father_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `age` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `gender` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `religion` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `village` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `post_office` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `district` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `upazila` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `admission_date` date NOT NULL,
  `admission_time` time NOT NULL,
  `disease` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `doctor_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `clearance_date` date NOT NULL,
  `clearance_time` time NOT NULL,
  `bed_no` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `phone_no` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ref_doctor_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `op_relation` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `op_pa_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `op_age` int(7) NOT NULL,
  `op_village` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `op_post_office` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `op_district` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `op_upazila` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type_of_unconscious` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `name_of_operation` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `name_of_witness` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `father_name_of_witness` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `village_of_witness` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `witness_district` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `witness_upazila` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `witness_date` date NOT NULL,
  `name_of_consentant` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `father_name_of_consentant` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `village_of_consentant` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `consentant_district` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `consentant_upazila` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `consentant_date` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `bank` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `bank_name` varchar(252) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `bank_account` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `datetime` date NOT NULL,
  `bank_name` varchar(255) NOT NULL,
  `branch_name` varchar(255) NOT NULL,
  `holder_name` varchar(255) NOT NULL,
  `holder_contact` varchar(20) DEFAULT NULL,
  `account_number` varchar(100) NOT NULL,
  `init_balance` decimal(10,2) NOT NULL,
  `pre_balance` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8; 

CREATE TABLE `bank_name` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `bank_name` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `bills` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date DEFAULT NULL,
  `voucher` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `pid` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `details` longtext COLLATE utf8_unicode_ci NOT NULL,
  `subtotal` decimal(10,2) NOT NULL COMMENT 'Without  Vat amount',
  `vat` int(100) NOT NULL COMMENT 'Vat percentage',
  `vat_amount` decimal(10,2) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `less_type` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `grand_total` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  `due` decimal(10,2) NOT NULL,
  `last_paid` decimal(10,2) NOT NULL,
  `last_payment_date` date NOT NULL,
  `payment_status` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'pending',
  `refereed_doctor` varchar(120) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `date` (`date`),
  KEY `voucher` (`voucher`),
  KEY `pid` (`pid`),
  KEY `title` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=1012 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `bonus_structure` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eid` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `fields` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `percentage` decimal(10,2) NOT NULL,
  `remarks` text COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `brand` (
  `id` int(45) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `name` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `trash` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `category` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `brand` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `trash` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `closing` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `opening` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `income` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `cost` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `salary_cost` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `bank` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `hand_cash` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `opening_type` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'auto',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `commission_payment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `payment_date` date NOT NULL,
  `type` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `person_id` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `balance` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  `due` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `commissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `ref` varchar(45) COLLATE utf8_unicode_ci NOT NULL COMMENT 'expression [ registration:10 or pathology:15 ]. registration -> ID = 10 and pathology -> ID = 15',
  `person` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `person_id` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT 'doctors:ID or marketer:ID or pc:ID',
  `type` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `consultancies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `pid` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `doctor` varchar(45) COLLATE utf8_unicode_ci NOT NULL COMMENT 'ID of doctors table',
  `reference_name` int(100) NOT NULL,
  `room` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'any description for patient',
  `bill` int(11) NOT NULL COMMENT 'ID of bills table',
  `status` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'pending' COMMENT 'pending or complete',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`)
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `cost` (
  `id` int(100) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `cost_field` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  `amount` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `spend_by` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `trash` tinyint(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=188 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `cost_field` (
  `id` int(100) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `cost_field` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `trash` int(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `create_reports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL,
  `procedure_id` int(11) NOT NULL,
  `standard` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `condition` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `deduction_structure` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eid` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `fields` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `remarks` text COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `diagnosis` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `delivery` date NOT NULL COMMENT 'Date value',
  `pid` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Test name',
  `gender` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `reference_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `refereed_doctor` varchar(191) COLLATE utf8_unicode_ci DEFAULT NULL,
  `group` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Test group',
  `room` varchar(110) COLLATE utf8_unicode_ci NOT NULL,
  `result` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `alt_doctor_id` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `alt_doctor_fee` decimal(8,2) NOT NULL,
  `remarks` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Normal, High, Low etc',
  `amount` decimal(10,2) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `bill` int(11) NOT NULL,
  `status` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `refereed_doctor` (`refereed_doctor`),
  KEY `alt_doctor_id` (`alt_doctor_id`),
  KEY `bill` (`bill`)
) ENGINE=InnoDB AUTO_INCREMENT=2271 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `doctor_payment` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `doctor_id` int(100) NOT NULL,
  `total_paid` decimal(8,2) NOT NULL,
  `payment` decimal(8,2) NOT NULL,
  `less` decimal(8,2) NOT NULL,
  `due` decimal(8,2) NOT NULL,
  `trash` int(10) NOT NULL DEFAULT 0,
  UNIQUE KEY `id` (`id`),
  KEY `rf_pc_id` (`doctor_id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `doctors` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fullName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `designation` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `degree` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `specialised` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `hospital` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mobile` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `fee` decimal(8,2) NOT NULL DEFAULT 0.00,
  `commission` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `address` text COLLATE utf8_unicode_ci NOT NULL,
  `image` text COLLATE utf8_unicode_ci NOT NULL,
  `room_no` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `status` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `due_payment` (
  `id` int(45) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `time` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `voucher_number` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `total_amount` decimal(10,2) NOT NULL,
  `prev_paid` decimal(10,2) NOT NULL,
  `prev_due` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  `due` decimal(10,2) NOT NULL,
  `remission` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `emergencies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `pid` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci DEFAULT NULL,
  `bill` int(11) NOT NULL COMMENT 'ID of bills table',
  `status` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `employee` (
  `id` int(20) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `emp_id` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `father_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mother_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `joining_date` date NOT NULL,
  `gender` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `date_of_birth` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `nid_no` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mobile` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `present_address` text COLLATE utf8_unicode_ci NOT NULL,
  `permanent_address` text COLLATE utf8_unicode_ci NOT NULL,
  `designation` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `remarks` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `path` text COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `group_name` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `group_name` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `incentive_structure` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eid` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `fields` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `percentage` decimal(10,2) NOT NULL,
  `remarks` text COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `income` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `income_field` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `income_by` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `trash` tinyint(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `income_field` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `income_field` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `trash` int(10) NOT NULL DEFAULT 0,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `code` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `investigation` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `group` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `test_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `test_fee` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `room` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=204 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `journal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `ref` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT 'expression [ registration:10 or pathology:15 or pid:123456 ]. registration -> ID = 10 and pathology -> ID = 15 and pid = patient ID',
  `details` longtext COLLATE utf8_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `status` varchar(45) COLLATE utf8_unicode_ci NOT NULL COMMENT 'income or cost or liability or assets',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1054 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `marketer` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `create_at` date NOT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `mobile` varchar(24) COLLATE utf8_unicode_ci NOT NULL,
  `commission` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `address` text COLLATE utf8_unicode_ci NOT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  `img_url` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`) USING HASH
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `medicine` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_name` text COLLATE utf8_unicode_ci NOT NULL,
  `product_code` varchar(252) COLLATE utf8_unicode_ci NOT NULL,
  `product_cat` varchar(252) COLLATE utf8_unicode_ci NOT NULL,
  `subcategory` varchar(252) COLLATE utf8_unicode_ci NOT NULL,
  `purchase_price` decimal(10,2) NOT NULL,
  `sale_price` decimal(10,2) NOT NULL,
  `unit` varchar(252) COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(252) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6449 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `messages_date` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `messages_name` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `messages_mobile` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `messages_text` text COLLATE utf8_unicode_ci NOT NULL,
  `messages_condition` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `meta_info` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8_unicode_ci NOT NULL,
  `meta_status` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `opening_balance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `opening_amount` decimal(10,2) NOT NULL,
  `initial_invest` decimal(10,2) NOT NULL,
  `closing_amount` decimal(10,2) NOT NULL,
  `status` varchar(150) COLLATE utf8_unicode_ci NOT NULL COMMENT '1st : opening balance always on top',
  `trash` tinyint(2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=50 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `outstock` (
  `id` int(200) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `voucher_no` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `stock_voucher_no` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `reagent` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `quantity` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `patient_histories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` varchar(191) COLLATE utf8_unicode_ci NOT NULL,
  `test_id` int(11) NOT NULL,
  `test_name` varchar(191) COLLATE utf8_unicode_ci NOT NULL,
  `parameter_id` int(11) NOT NULL,
  `parameter` varchar(191) COLLATE utf8_unicode_ci NOT NULL,
  `standard` varchar(191) COLLATE utf8_unicode_ci NOT NULL,
  `value` varchar(191) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(191) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `patient_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `patient_name` varchar(191) COLLATE utf8_unicode_ci NOT NULL,
  `patient_pid` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `patients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `pid` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `guardian` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'JSON String. { ''relation'' : ''person name'' }',
  `gender` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `age` int(11) NOT NULL,
  `address` longtext COLLATE utf8_unicode_ci NOT NULL,
  `contact` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1002 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `pc` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fullName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mobile` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `commission` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `address` text COLLATE utf8_unicode_ci NOT NULL,
  `image` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `prescription` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prescription_id` varchar(11) COLLATE utf8_unicode_ci NOT NULL,
  `date` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `symptoms` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `diagnosis` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `patient_name` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `medicine` text COLLATE utf8_unicode_ci NOT NULL,
  `test` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `privileges` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `privilege_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `user_id` int(100) NOT NULL,
  `access` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `procedures` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL,
  `test_name` varchar(191) COLLATE utf8_unicode_ci NOT NULL,
  `parameter` varchar(191) COLLATE utf8_unicode_ci NOT NULL,
  `referral_value` varchar(191) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'with Condition',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `brand` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `category` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `model` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `subcategory` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `purchase_price` decimal(10,2) NOT NULL,
  `sale_price` decimal(10,2) NOT NULL,
  `unit` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `remarks` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `trash` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `purchase` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `voucher_no` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `category` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `subcategory` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `brand` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `code` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `product_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `purchase_price` decimal(10,2) NOT NULL,
  `quantity` int(10) unsigned NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `subtotal` decimal(10,2) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `total_discount` decimal(10,2) NOT NULL,
  `transport_cost` decimal(10,2) NOT NULL,
  `grand_total` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  `due` decimal(10,2) NOT NULL,
  `final_due` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `reagent` (
  `id` int(200) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `reagent` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `reagent_stock` (
  `id` int(200) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `voucher_no` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `reagent` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `quantity` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `expire_date` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `recharge_sms` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `amount` varchar(192) COLLATE utf8_unicode_ci NOT NULL,
  `sms` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `registrations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `pid` varchar(45) COLLATE utf8_unicode_ci NOT NULL COMMENT 'ID of patients. Connect to patients table. ',
  `type` varchar(45) COLLATE utf8_unicode_ci NOT NULL COMMENT 'admission or, consultancy or, emergency or, pathology',
  `status` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'pending' COMMENT 'pending or admitted or released or consultancy or emergency',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=86 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `remark` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `remark` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `remark_id` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `rf_pc_commission_payment` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `rf_pc_id` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `payment` decimal(8,2) NOT NULL,
  `trash` int(10) NOT NULL DEFAULT 0,
  UNIQUE KEY `id` (`id`),
  KEY `rf_pc_id` (`rf_pc_id`)
) ENGINE=MyISAM AUTO_INCREMENT=53 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `salary` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `emp_id` int(11) NOT NULL,
  `salary_amount` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `bonus` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `issue_date` date NOT NULL,
  `payment_year` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `payment_month` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `payment_type` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `bank_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `account_number` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `salary_records` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `eid` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `fields` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `amounts` decimal(10,2) NOT NULL,
  `remarks` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `salary_structure` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eid` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `basic` decimal(10,2) NOT NULL,
  `incentive` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'no',
  `deduction` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'no',
  `bonus` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'no',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `sale` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `time` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `voucher_number` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `category` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `code` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `model` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `product` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `quantity` int(10) unsigned NOT NULL,
  `subtotal` decimal(10,2) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `grand_total` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  `due` decimal(10,2) NOT NULL,
  `remission` decimal(10,2) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mobile` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `sessions` (
  `session_id` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `ip_address` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `user_agent` varchar(120) COLLATE utf8_unicode_ci NOT NULL,
  `last_activity` int(10) unsigned NOT NULL DEFAULT 0,
  `user_data` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`session_id`),
  KEY `last_activity_idx` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `sitemeta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `meta_type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `meta_value` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `sms_record` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `delivery_date` date NOT NULL,
  `delivery_time` time NOT NULL,
  `mobile` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `message` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `total_characters` varchar(4) COLLATE utf8_unicode_ci NOT NULL,
  `total_messages` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `delivery_report` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `stock` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `quantity` int(11) NOT NULL,
  `unit` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'pcs',
  `purchase_price` decimal(10,2) NOT NULL,
  `sell_price` decimal(10,2) NOT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` varchar(252) COLLATE utf8_unicode_ci NOT NULL,
  `test_group` varchar(252) COLLATE utf8_unicode_ci NOT NULL,
  `test_name` varchar(252) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `test_histories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL,
  `procedure_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `patient_voucher` varchar(191) COLLATE utf8_unicode_ci NOT NULL,
  `standerd` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `condition` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `report` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `remark` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `test_name` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `group_name` text COLLATE utf8_unicode_ci NOT NULL,
  `test_name` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=157 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `theme_setting` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `theme_color` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `background_pattern` text COLLATE utf8_unicode_ci NOT NULL,
  `login_background` text COLLATE utf8_unicode_ci NOT NULL,
  `google_map` text COLLATE utf8_unicode_ci NOT NULL,
  `footer` text COLLATE utf8_unicode_ci NOT NULL,
  `header` text COLLATE utf8_unicode_ci NOT NULL,
  `logo` text COLLATE utf8_unicode_ci NOT NULL,
  `menu_icon` text COLLATE utf8_unicode_ci NOT NULL,
  `social_icon` text COLLATE utf8_unicode_ci NOT NULL,
  `language` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `transaction` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_date` date NOT NULL,
  `bank` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `account_number` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `transaction_type` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `source` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `amount` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `transaction_by` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `remarks` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `users` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `opening` datetime NOT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `l_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `gender` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `birthday` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `maritial_status` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `position` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `about` text COLLATE utf8_unicode_ci NOT NULL,
  `website` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `facecbook` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `twitter` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `username` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `privilege` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `image` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `mobile` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `branch` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `vat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `percentage` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `vat_id` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 
 
INSERT INTO `access_info` ( `user_id`, `login_period`, `logout_period`) VALUES 
('28', '2018-07-12 10:53:45', '0000-00-00 00:00:00'), 
('28', '2018-07-16 17:56:38', '0000-00-00 00:00:00'), 
('28', '2018-07-19 12:57:39', '2018-07-19 12:59:13'), 
('28', '2018-07-19 12:59:15', '2018-07-19 13:00:42'), 
('28', '2018-07-19 13:00:54', '0000-00-00 00:00:00'), 
('28', '2018-07-19 14:11:12', '0000-00-00 00:00:00'), 
('28', '2018-07-19 15:20:26', '0000-00-00 00:00:00'), 
('28', '2018-07-19 16:38:19', '0000-00-00 00:00:00'), 
('28', '2018-07-19 17:00:05', '0000-00-00 00:00:00'), 
('28', '2018-07-19 17:05:58', '2018-07-19 17:48:08'), 
('28', '2018-07-19 17:10:18', '0000-00-00 00:00:00'), 
('28', '2018-07-19 17:30:31', '0000-00-00 00:00:00'), 
('28', '2018-07-19 17:34:26', '0000-00-00 00:00:00'), 
('28', '2018-07-19 17:48:49', '0000-00-00 00:00:00'), 
('28', '2018-07-19 17:50:30', '0000-00-00 00:00:00'), 
('28', '2018-07-19 17:59:24', '0000-00-00 00:00:00'), 
('28', '2018-07-19 18:52:34', '0000-00-00 00:00:00'), 
('28', '2018-07-22 10:22:45', '0000-00-00 00:00:00'), 
('28', '2018-07-22 18:37:41', '0000-00-00 00:00:00'), 
('28', '2018-07-23 11:04:26', '2018-07-23 16:03:39'), 
('29', '2018-07-23 16:03:42', '2018-07-23 16:14:27'), 
('29', '2018-07-23 16:14:29', '2018-07-23 16:19:13'), 
('28', '2018-07-23 16:16:44', '0000-00-00 00:00:00'), 
('26', '2018-07-23 16:19:37', '0000-00-00 00:00:00'), 
('29', '2018-08-01 18:21:00', '0000-00-00 00:00:00'), 
('29', '2018-08-08 16:25:19', '2018-08-08 16:25:40'), 
('29', '2018-08-08 16:25:47', '2018-08-08 16:26:22'), 
('29', '2018-08-08 16:26:29', '0000-00-00 00:00:00'), 
('29', '2018-08-09 10:07:10', '0000-00-00 00:00:00'), 
('29', '2018-08-09 10:08:30', '2018-08-09 10:39:10'), 
('29', '2018-08-11 10:43:22', '2018-08-11 13:58:53'), 
('29', '2018-08-11 13:58:58', '0000-00-00 00:00:00'), 
('29', '2018-08-13 10:26:45', '2018-08-13 10:35:29'), 
('29', '2018-08-13 10:28:49', '0000-00-00 00:00:00'), 
('29', '2018-08-13 10:36:06', '2018-08-13 15:53:06'), 
('29', '2018-08-13 13:32:18', '0000-00-00 00:00:00'), 
('29', '2018-08-14 10:39:15', '2018-08-14 10:39:42'), 
('29', '2018-08-14 10:39:51', '0000-00-00 00:00:00'), 
('29', '2018-09-04 19:20:58', '0000-00-00 00:00:00'), 
('29', '2018-09-04 19:26:33', '0000-00-00 00:00:00'), 
('29', '2018-09-05 10:25:29', '0000-00-00 00:00:00'), 
('29', '2018-09-07 17:53:21', '0000-00-00 00:00:00'), 
('29', '2018-11-19 11:51:12', '0000-00-00 00:00:00'), 
('29', '2018-11-19 16:53:09', '0000-00-00 00:00:00'), 
('29', '2018-12-02 18:38:55', '2018-12-02 18:39:53'), 
('29', '2018-12-02 18:40:02', '2018-12-02 18:42:57'), 
('29', '2018-12-04 11:16:31', '0000-00-00 00:00:00'), 
('29', '2018-12-04 14:03:50', '0000-00-00 00:00:00'), 
('29', '2018-12-06 15:13:36', '2018-12-06 15:34:02'), 
('29', '2018-12-06 18:21:13', '0000-00-00 00:00:00'), 
('29', '2018-12-06 19:49:04', '2018-12-06 19:57:25'), 
('29', '2018-12-10 10:42:03', '2018-12-10 10:48:03'), 
('29', '2018-12-14 11:14:21', '2018-12-14 11:20:59'), 
('29', '2018-12-17 16:59:04', '2018-12-17 17:22:24'), 
('29', '2018-12-18 13:34:21', '0000-00-00 00:00:00'), 
('29', '2018-12-18 13:38:08', '0000-00-00 00:00:00'), 
('29', '2018-12-18 14:19:39', '0000-00-00 00:00:00'), 
('29', '2018-12-18 14:24:10', '0000-00-00 00:00:00'), 
('29', '2018-12-18 14:25:22', '0000-00-00 00:00:00'), 
('29', '2018-12-18 14:37:38', '0000-00-00 00:00:00'), 
('29', '2018-12-18 16:37:24', '0000-00-00 00:00:00'), 
('29', '2018-12-18 16:42:25', '0000-00-00 00:00:00'), 
('29', '2018-12-18 17:27:28', '2018-12-18 17:34:24'), 
('29', '2018-12-19 09:13:50', '0000-00-00 00:00:00'), 
('29', '2018-12-19 09:30:03', '0000-00-00 00:00:00'), 
('29', '2018-12-19 09:43:49', '0000-00-00 00:00:00'), 
('29', '2018-12-19 09:45:24', '0000-00-00 00:00:00'), 
('29', '2018-12-19 11:02:56', '2018-12-19 11:51:34'), 
('29', '2018-12-19 11:31:57', '0000-00-00 00:00:00'), 
('29', '2018-12-19 17:25:50', '2018-12-19 17:26:24'), 
('26', '2018-12-19 17:26:39', '2018-12-19 17:26:55'), 
('26', '2018-12-19 17:27:09', '2018-12-19 17:28:21'), 
('29', '2018-12-19 17:28:30', '2018-12-19 17:31:23'), 
('26', '2018-12-19 17:31:37', '0000-00-00 00:00:00'), 
('30', '2018-12-19 17:39:33', '0000-00-00 00:00:00'), 
('29', '2018-12-19 17:41:53', '0000-00-00 00:00:00'), 
('29', '2018-12-23 15:39:23', '0000-00-00 00:00:00'), 
('29', '2018-12-23 15:59:45', '2018-12-23 16:04:07'), 
('29', '2018-12-24 12:50:58', '2018-12-24 12:57:27'), 
('30', '2018-12-25 12:19:33', '2018-12-25 12:20:33'), 
('30', '2018-12-25 12:20:49', '2018-12-25 12:21:11'), 
('28', '2018-12-25 12:21:36', '2018-12-25 12:21:57'), 
('28', '2018-12-25 12:22:25', '2018-12-25 12:23:21'), 
('31', '2018-12-25 12:23:30', '2018-12-25 12:32:42'), 
('28', '2018-12-25 14:33:05', '2018-12-25 14:34:39'), 
('32', '2018-12-25 14:34:45', '0000-00-00 00:00:00'), 
('32', '2018-12-26 10:53:27', '2018-12-26 11:06:16'), 
('33', '2018-12-26 11:06:23', '2018-12-26 11:06:48'), 
('32', '2018-12-26 11:07:07', '2018-12-26 11:08:09'), 
('34', '2018-12-26 11:08:14', '0000-00-00 00:00:00'), 
('34', '2018-12-26 11:09:41', '0000-00-00 00:00:00'), 
('34', '2018-12-26 12:21:00', '2018-12-26 12:27:09'), 
('34', '2018-12-27 13:22:52', '2018-12-27 13:35:44'), 
('34', '2018-12-27 13:28:53', '0000-00-00 00:00:00'), 
('36', '2018-12-27 14:46:55', '0000-00-00 00:00:00'), 
('36', '2018-12-27 19:13:15', '2018-12-27 19:14:36'), 
('37', '2018-12-27 19:14:41', '0000-00-00 00:00:00'), 
('37', '2018-12-27 19:15:37', '2018-12-27 19:20:45'), 
('37', '2018-12-29 12:46:26', '2018-12-29 12:46:42'), 
('37', '2018-12-29 12:50:57', '0000-00-00 00:00:00'), 
('37', '2018-12-29 13:09:26', '2018-12-29 13:15:20'), 
('37', '2019-01-09 13:44:31', '2019-01-09 15:01:14'), 
('37', '2019-01-16 16:01:41', '0000-00-00 00:00:00'), 
('37', '2019-01-16 17:04:35', '0000-00-00 00:00:00'), 
('37', '2019-01-16 19:24:01', '2019-01-16 19:25:43'), 
('37', '2019-01-21 09:30:37', '0000-00-00 00:00:00'), 
('37', '2019-01-21 17:42:50', '0000-00-00 00:00:00'), 
('37', '2019-01-22 10:23:26', '0000-00-00 00:00:00'), 
('37', '2019-01-22 12:09:15', '0000-00-00 00:00:00'), 
('37', '2019-01-22 17:17:17', '2019-01-22 17:48:35'), 
('37', '2019-01-23 09:31:38', '0000-00-00 00:00:00'), 
('37', '2019-01-28 15:09:06', '0000-00-00 00:00:00'), 
('37', '2019-02-17 10:32:51', '2019-02-17 10:39:44'), 
('37', '2019-02-17 17:24:21', '2019-02-17 17:56:14'), 
('37', '2019-02-18 09:23:40', '0000-00-00 00:00:00'), 
('37', '2019-02-18 09:26:20', '0000-00-00 00:00:00'), 
('37', '2019-02-21 11:30:29', '0000-00-00 00:00:00'), 
('37', '2019-03-13 14:30:02', '0000-00-00 00:00:00'), 
('37', '2019-03-13 14:34:21', '0000-00-00 00:00:00'), 
('37', '2019-03-20 10:15:21', '2019-03-20 10:29:25'), 
('37', '2019-05-05 07:36:31', '2019-05-05 07:49:19'), 
('37', '2019-05-05 10:46:47', '2019-05-05 11:02:15'), 
('37', '2019-05-05 11:03:21', '0000-00-00 00:00:00'), 
('37', '2019-06-23 19:09:48', '0000-00-00 00:00:00'), 
('37', '2019-06-23 19:15:36', '0000-00-00 00:00:00'), 
('37', '2019-07-21 18:47:46', '0000-00-00 00:00:00'), 
('37', '2019-08-05 20:10:17', '2019-08-05 20:10:35'), 
('37', '2019-08-06 11:28:56', '0000-00-00 00:00:00'), 
('37', '2019-08-07 17:53:33', '0000-00-00 00:00:00'), 
('37', '2019-08-08 17:49:28', '0000-00-00 00:00:00'), 
('37', '2019-08-14 19:31:59', '0000-00-00 00:00:00'), 
('37', '2019-08-16 18:59:17', '0000-00-00 00:00:00'), 
('37', '2019-08-31 11:36:33', '0000-00-00 00:00:00'), 
('37', '2019-08-31 11:58:05', '2019-08-31 12:52:33'), 
('38', '2019-08-31 12:52:55', '2019-08-31 12:53:42'), 
('37', '2019-08-31 12:54:00', '2019-08-31 12:59:16'), 
('38', '2019-08-31 12:59:33', '2019-08-31 13:00:28'), 
('37', '2019-08-31 13:00:49', '2019-08-31 13:05:35'), 
('38', '2019-08-31 13:13:31', '2019-08-31 13:16:22'), 
('38', '2019-08-31 14:00:02', '2019-08-31 14:05:29'), 
('39', '2019-08-31 17:49:25', '0000-00-00 00:00:00'), 
('39', '2019-08-31 17:50:29', '2019-08-31 17:57:51'), 
('40', '2019-08-31 17:58:10', '2019-08-31 18:17:55'), 
('38', '2019-08-31 18:19:08', '2019-08-31 18:19:52'), 
('40', '2019-08-31 18:20:05', '2019-08-31 18:25:10'), 
('38', '2019-08-31 18:25:25', '2019-08-31 18:26:07'), 
('40', '2019-08-31 18:26:28', '0000-00-00 00:00:00'), 
('40', '2019-09-03 14:22:00', '0000-00-00 00:00:00'), 
('38', '2019-09-14 17:30:11', '2019-09-14 17:34:02'), 
('41', '2019-09-16 11:27:55', '0000-00-00 00:00:00'), 
('41', '2019-09-16 11:28:50', '2019-09-16 11:40:47'), 
('42', '2019-09-16 11:41:03', '2019-09-16 11:47:41'), 
('38', '2019-09-16 11:47:56', '2019-09-16 11:59:20'), 
('38', '2019-09-16 11:59:37', '2019-09-16 12:30:54'), 
('42', '2019-09-16 12:31:07', '2019-09-16 12:32:19'), 
('38', '2019-09-16 12:33:23', '2019-09-16 13:15:10'), 
('42', '2019-09-16 13:16:18', '0000-00-00 00:00:00'), 
('43', '2020-06-20 15:04:00', '2020-06-20 15:05:00'), 
('43', '2020-06-20 15:08:50', '0000-00-00 00:00:00'), 
('43', '2020-06-20 15:11:01', '0000-00-00 00:00:00'), 
('43', '2020-06-20 15:11:56', '0000-00-00 00:00:00'), 
('43', '2020-06-20 15:32:57', '0000-00-00 00:00:00'), 
('43', '2020-06-20 16:15:51', '0000-00-00 00:00:00'), 
('43', '2020-06-20 17:54:10', '0000-00-00 00:00:00'), 
('43', '2020-06-20 17:55:05', '2020-06-20 18:14:08'), 
('43', '2020-06-20 18:42:43', '0000-00-00 00:00:00'), 
('43', '2020-06-20 18:43:24', '2020-06-20 18:45:54'), 
('43', '2020-06-21 00:14:33', '0000-00-00 00:00:00'), 
('43', '2020-06-21 10:26:57', '0000-00-00 00:00:00'), 
('43', '2020-06-21 10:45:47', '0000-00-00 00:00:00'), 
('43', '2020-06-21 11:25:16', '0000-00-00 00:00:00'), 
('43', '2020-06-21 11:26:57', '0000-00-00 00:00:00'), 
('43', '2020-06-21 14:39:37', '0000-00-00 00:00:00'), 
('43', '2020-06-21 14:56:00', '2020-06-21 16:33:43'), 
('43', '2020-06-21 17:41:48', '0000-00-00 00:00:00'), 
('43', '2020-06-21 18:11:00', '0000-00-00 00:00:00'), 
('43', '2020-06-22 09:11:07', '0000-00-00 00:00:00'), 
('43', '2020-06-22 11:18:50', '2020-06-22 11:25:33'), 
('43', '2020-06-22 11:26:28', '2020-06-22 11:37:17'), 
('43', '2020-06-22 12:57:32', '0000-00-00 00:00:00'), 
('43', '2020-06-22 13:00:31', '0000-00-00 00:00:00'), 
('43', '2020-06-22 14:05:34', '0000-00-00 00:00:00'), 
('43', '2020-06-22 14:18:05', '0000-00-00 00:00:00'), 
('44', '2020-06-22 20:47:09', '2020-06-22 20:47:21'), 
('44', '2020-06-22 20:48:13', '2020-06-22 20:48:45'), 
('45', '2020-06-22 21:33:42', '2020-06-22 21:34:25'), 
('45', '2020-06-22 21:34:38', '2020-06-22 21:39:34'), 
('45', '2020-06-23 00:22:45', '0000-00-00 00:00:00'), 
('45', '2020-06-23 00:54:15', '0000-00-00 00:00:00'), 
('45', '2020-06-23 02:06:23', '0000-00-00 00:00:00'), 
('45', '2020-06-23 09:23:21', '0000-00-00 00:00:00'), 
('45', '2020-06-23 10:06:51', '0000-00-00 00:00:00'), 
('45', '2020-06-23 10:09:18', '0000-00-00 00:00:00'), 
('45', '2020-06-23 11:10:36', '0000-00-00 00:00:00'), 
('45', '2020-06-23 11:12:14', '0000-00-00 00:00:00'), 
('45', '2020-06-23 11:39:56', '0000-00-00 00:00:00'), 
('45', '2020-06-23 18:39:12', '0000-00-00 00:00:00'), 
('45', '2020-06-23 18:50:36', '0000-00-00 00:00:00'), 
('45', '2020-06-23 19:41:41', '0000-00-00 00:00:00'), 
('45', '2020-06-23 19:44:35', '0000-00-00 00:00:00'), 
('45', '2020-06-24 15:21:16', '0000-00-00 00:00:00'), 
('45', '2020-06-24 15:22:04', '0000-00-00 00:00:00'), 
('45', '2020-06-25 09:43:10', '0000-00-00 00:00:00'), 
('45', '2020-06-25 10:17:43', '0000-00-00 00:00:00'), 
('45', '2020-06-25 18:17:31', '0000-00-00 00:00:00'), 
('45', '2020-06-25 18:25:27', '0000-00-00 00:00:00'), 
('45', '2020-06-27 11:15:04', '0000-00-00 00:00:00'), 
('45', '2020-06-27 12:32:04', '0000-00-00 00:00:00'), 
('45', '2020-06-28 09:10:24', '0000-00-00 00:00:00'), 
('45', '2020-06-28 10:30:52', '0000-00-00 00:00:00'), 
('45', '2020-06-28 16:22:23', '0000-00-00 00:00:00'), 
('45', '2020-06-28 18:06:29', '0000-00-00 00:00:00'), 
('45', '2020-06-29 10:37:16', '0000-00-00 00:00:00'), 
('45', '2020-06-29 14:33:35', '0000-00-00 00:00:00'), 
('45', '2020-06-29 20:13:19', '0000-00-00 00:00:00'), 
('45', '2020-06-29 20:38:33', '0000-00-00 00:00:00'), 
('45', '2020-06-30 10:11:50', '0000-00-00 00:00:00'), 
('45', '2020-06-30 10:22:30', '0000-00-00 00:00:00'), 
('45', '2020-06-30 11:30:59', '0000-00-00 00:00:00'), 
('45', '2020-06-30 11:42:54', '0000-00-00 00:00:00'), 
('45', '2020-06-30 12:23:50', '0000-00-00 00:00:00'), 
('45', '2020-06-30 12:48:20', '0000-00-00 00:00:00'), 
('45', '2020-06-30 12:54:18', '0000-00-00 00:00:00'), 
('45', '2020-06-30 13:56:14', '0000-00-00 00:00:00'), 
('45', '2020-06-30 14:00:47', '0000-00-00 00:00:00'), 
('45', '2020-06-30 14:20:21', '0000-00-00 00:00:00'), 
('45', '2020-06-30 18:22:18', '0000-00-00 00:00:00'), 
('45', '2020-06-30 19:29:08', '0000-00-00 00:00:00'), 
('45', '2020-06-30 20:41:54', '0000-00-00 00:00:00'), 
('45', '2020-07-01 09:28:55', '0000-00-00 00:00:00'), 
('45', '2020-07-01 10:37:42', '0000-00-00 00:00:00'), 
('45', '2020-07-01 10:40:49', '0000-00-00 00:00:00'), 
('45', '2020-07-01 10:41:03', '0000-00-00 00:00:00'), 
('45', '2020-07-01 10:43:48', '0000-00-00 00:00:00'), 
('45', '2020-07-01 10:48:36', '2020-07-01 11:07:01'), 
('45', '2020-07-01 11:07:10', '0000-00-00 00:00:00'), 
('45', '2020-07-01 11:07:13', '0000-00-00 00:00:00'), 
('45', '2020-07-01 12:42:30', '0000-00-00 00:00:00'), 
('45', '2020-07-01 13:16:45', '0000-00-00 00:00:00'), 
('45', '2020-07-01 15:42:06', '0000-00-00 00:00:00'), 
('45', '2020-07-01 17:32:49', '0000-00-00 00:00:00'), 
('45', '2020-07-01 17:54:54', '0000-00-00 00:00:00'), 
('45', '2020-07-01 17:55:37', '0000-00-00 00:00:00'), 
('45', '2020-07-01 18:40:04', '0000-00-00 00:00:00'), 
('45', '2020-07-02 10:04:24', '0000-00-00 00:00:00'), 
('45', '2020-07-02 11:15:22', '0000-00-00 00:00:00'), 
('45', '2020-07-02 11:26:45', '0000-00-00 00:00:00'), 
('45', '2020-07-02 13:32:19', '0000-00-00 00:00:00'), 
('45', '2020-07-02 14:22:50', '0000-00-00 00:00:00'), 
('45', '2020-07-02 17:14:54', '0000-00-00 00:00:00'), 
('45', '2020-07-02 18:21:07', '0000-00-00 00:00:00'), 
('45', '2020-07-02 18:27:19', '0000-00-00 00:00:00'), 
('45', '2020-07-02 18:37:09', '0000-00-00 00:00:00'), 
('45', '2020-07-02 18:54:08', '0000-00-00 00:00:00'), 
('45', '2020-07-02 18:59:33', '0000-00-00 00:00:00'), 
('45', '2020-07-02 19:05:03', '0000-00-00 00:00:00'), 
('45', '2020-07-02 20:34:15', '0000-00-00 00:00:00'), 
('45', '2020-07-03 11:01:49', '0000-00-00 00:00:00'), 
('45', '2020-07-03 13:15:54', '0000-00-00 00:00:00'), 
('45', '2020-07-03 13:20:16', '0000-00-00 00:00:00'), 
('45', '2020-07-03 13:26:29', '0000-00-00 00:00:00'), 
('45', '2020-07-03 13:50:10', '0000-00-00 00:00:00'), 
('45', '2020-07-03 14:18:35', '0000-00-00 00:00:00'), 
('45', '2020-07-03 14:46:52', '0000-00-00 00:00:00'), 
('45', '2020-07-03 14:52:32', '0000-00-00 00:00:00'), 
('45', '2020-07-03 17:39:32', '0000-00-00 00:00:00'), 
('45', '2020-07-03 18:49:03', '0000-00-00 00:00:00'), 
('45', '2020-07-04 10:09:19', '0000-00-00 00:00:00'), 
('45', '2020-07-04 20:26:35', '0000-00-00 00:00:00'), 
('45', '2020-07-05 11:35:17', '0000-00-00 00:00:00'), 
('45', '2020-07-05 14:54:33', '0000-00-00 00:00:00'), 
('45', '2020-07-05 15:16:45', '0000-00-00 00:00:00'), 
('45', '2020-07-05 15:58:49', '0000-00-00 00:00:00'), 
('45', '2020-07-05 16:26:19', '0000-00-00 00:00:00'), 
('45', '2020-07-05 16:35:18', '0000-00-00 00:00:00'), 
('45', '2020-07-05 16:42:26', '0000-00-00 00:00:00'), 
('45', '2020-07-05 18:00:07', '0000-00-00 00:00:00'), 
('45', '2020-07-05 18:35:14', '0000-00-00 00:00:00'), 
('45', '2020-07-05 18:41:03', '0000-00-00 00:00:00'), 
('45', '2020-07-05 19:50:36', '0000-00-00 00:00:00'), 
('45', '2020-07-05 20:31:48', '0000-00-00 00:00:00'), 
('45', '2020-07-05 20:40:37', '0000-00-00 00:00:00'), 
('45', '2020-07-05 21:09:11', '0000-00-00 00:00:00'), 
('45', '2020-07-05 21:24:58', '0000-00-00 00:00:00'), 
('45', '2020-07-06 10:46:56', '0000-00-00 00:00:00'), 
('45', '2020-07-06 11:49:16', '0000-00-00 00:00:00'), 
('45', '2020-07-06 12:46:55', '0000-00-00 00:00:00'), 
('45', '2020-07-06 12:57:11', '0000-00-00 00:00:00'), 
('45', '2020-07-06 13:00:31', '0000-00-00 00:00:00'), 
('45', '2020-07-06 13:05:39', '0000-00-00 00:00:00'), 
('45', '2020-07-06 14:52:57', '0000-00-00 00:00:00'), 
('45', '2020-07-06 15:25:21', '0000-00-00 00:00:00'), 
('45', '2020-07-06 16:02:09', '0000-00-00 00:00:00'), 
('45', '2020-07-06 17:23:50', '0000-00-00 00:00:00'), 
('45', '2020-07-06 17:30:25', '0000-00-00 00:00:00'), 
('45', '2020-07-06 17:40:23', '0000-00-00 00:00:00'), 
('45', '2020-07-06 18:08:34', '0000-00-00 00:00:00'), 
('45', '2020-07-06 18:08:49', '0000-00-00 00:00:00'), 
('45', '2020-07-06 20:05:40', '0000-00-00 00:00:00'), 
('45', '2020-07-06 20:09:16', '0000-00-00 00:00:00'), 
('45', '2020-07-06 20:15:25', '0000-00-00 00:00:00'), 
('45', '2020-07-06 20:36:22', '0000-00-00 00:00:00'), 
('45', '2020-07-06 21:08:33', '0000-00-00 00:00:00'), 
('45', '2020-07-07 09:28:52', '0000-00-00 00:00:00'), 
('45', '2020-07-07 09:34:14', '0000-00-00 00:00:00'), 
('45', '2020-07-07 10:35:34', '0000-00-00 00:00:00'), 
('45', '2020-07-07 10:40:03', '0000-00-00 00:00:00'), 
('45', '2020-07-07 11:50:41', '0000-00-00 00:00:00'), 
('45', '2020-07-07 12:05:16', '0000-00-00 00:00:00'), 
('45', '2020-07-07 12:20:43', '0000-00-00 00:00:00'), 
('45', '2020-07-07 12:31:07', '0000-00-00 00:00:00'), 
('45', '2020-07-07 12:53:45', '0000-00-00 00:00:00'), 
('45', '2020-07-07 13:46:10', '0000-00-00 00:00:00'), 
('45', '2020-07-07 16:11:46', '0000-00-00 00:00:00'), 
('45', '2020-07-07 18:02:39', '0000-00-00 00:00:00'), 
('45', '2020-07-07 18:13:41', '0000-00-00 00:00:00'), 
('45', '2020-07-08 09:13:29', '0000-00-00 00:00:00'), 
('45', '2020-07-08 10:13:52', '0000-00-00 00:00:00'), 
('45', '2020-07-08 10:26:47', '0000-00-00 00:00:00'), 
('45', '2020-07-08 10:41:55', '0000-00-00 00:00:00'), 
('45', '2020-07-08 11:12:38', '0000-00-00 00:00:00'), 
('45', '2020-07-08 13:09:52', '0000-00-00 00:00:00'), 
('45', '2020-07-08 14:29:31', '0000-00-00 00:00:00'), 
('45', '2020-07-08 16:05:22', '0000-00-00 00:00:00'), 
('45', '2020-07-08 19:36:10', '0000-00-00 00:00:00'), 
('45', '2020-07-09 10:52:44', '0000-00-00 00:00:00'), 
('45', '2020-07-09 14:13:09', '0000-00-00 00:00:00'), 
('45', '2020-07-09 14:30:05', '0000-00-00 00:00:00'), 
('45', '2020-07-09 15:30:39', '0000-00-00 00:00:00'), 
('45', '2020-07-09 15:31:34', '0000-00-00 00:00:00'), 
('45', '2020-07-09 16:05:32', '0000-00-00 00:00:00'), 
('45', '2020-07-09 16:21:14', '0000-00-00 00:00:00'), 
('45', '2020-07-09 17:38:18', '0000-00-00 00:00:00'), 
('45', '2020-07-09 19:09:21', '0000-00-00 00:00:00'), 
('45', '2020-07-09 19:11:26', '0000-00-00 00:00:00'), 
('45', '2020-07-09 19:16:44', '0000-00-00 00:00:00'), 
('45', '2020-07-09 19:21:48', '0000-00-00 00:00:00'), 
('45', '2020-07-09 19:42:53', '0000-00-00 00:00:00'), 
('45', '2020-07-10 09:25:18', '0000-00-00 00:00:00'), 
('45', '2020-07-10 11:41:36', '0000-00-00 00:00:00'), 
('45', '2020-07-10 11:47:06', '0000-00-00 00:00:00'), 
('45', '2020-07-10 12:36:29', '0000-00-00 00:00:00'), 
('45', '2020-07-10 12:48:11', '0000-00-00 00:00:00'), 
('45', '2020-07-10 13:19:18', '0000-00-00 00:00:00'), 
('45', '2020-07-10 16:35:22', '0000-00-00 00:00:00'), 
('45', '2020-07-10 16:43:24', '0000-00-00 00:00:00'), 
('45', '2020-07-10 16:59:33', '0000-00-00 00:00:00'), 
('45', '2020-07-10 18:33:30', '0000-00-00 00:00:00'), 
('45', '2020-07-10 18:39:51', '0000-00-00 00:00:00'), 
('45', '2020-07-10 18:45:42', '0000-00-00 00:00:00'), 
('45', '2020-07-10 18:50:23', '0000-00-00 00:00:00'), 
('45', '2020-07-11 16:28:28', '0000-00-00 00:00:00'), 
('45', '2020-07-11 16:38:55', '0000-00-00 00:00:00'), 
('45', '2020-07-12 09:52:20', '0000-00-00 00:00:00'), 
('45', '2020-07-13 15:05:02', '0000-00-00 00:00:00'), 
('45', '2020-07-13 15:16:55', '0000-00-00 00:00:00'), 
('45', '2020-07-13 15:21:23', '0000-00-00 00:00:00'), 
('45', '2020-07-13 15:26:38', '0000-00-00 00:00:00'), 
('45', '2020-07-13 16:17:03', '0000-00-00 00:00:00'), 
('45', '2020-07-13 19:57:18', '0000-00-00 00:00:00'), 
('45', '2020-07-14 11:10:04', '0000-00-00 00:00:00'), 
('45', '2020-07-14 11:15:38', '0000-00-00 00:00:00'), 
('45', '2020-07-14 11:21:17', '0000-00-00 00:00:00'), 
('45', '2020-07-14 13:51:25', '0000-00-00 00:00:00'), 
('45', '2020-07-14 14:02:23', '0000-00-00 00:00:00'), 
('45', '2020-07-14 18:27:54', '0000-00-00 00:00:00'), 
('45', '2020-07-14 19:20:33', '0000-00-00 00:00:00'), 
('45', '2020-07-15 10:36:47', '0000-00-00 00:00:00'), 
('45', '2020-07-15 11:43:32', '0000-00-00 00:00:00'), 
('45', '2020-07-15 12:03:20', '0000-00-00 00:00:00'), 
('45', '2020-07-15 14:25:07', '0000-00-00 00:00:00'), 
('45', '2020-07-15 14:41:43', '0000-00-00 00:00:00'), 
('45', '2020-07-15 16:04:58', '0000-00-00 00:00:00'), 
('45', '2020-07-16 09:24:20', '0000-00-00 00:00:00'), 
('45', '2020-07-16 14:04:39', '0000-00-00 00:00:00'), 
('45', '2020-07-16 15:13:00', '0000-00-00 00:00:00'), 
('45', '2020-07-16 16:16:25', '0000-00-00 00:00:00'), 
('45', '2020-07-16 16:28:14', '0000-00-00 00:00:00'), 
('45', '2020-07-16 18:24:36', '0000-00-00 00:00:00'), 
('45', '2020-07-16 19:14:47', '0000-00-00 00:00:00'), 
('45', '2020-07-16 19:40:07', '0000-00-00 00:00:00'), 
('45', '2020-07-17 10:08:18', '0000-00-00 00:00:00'), 
('45', '2020-07-17 11:14:46', '0000-00-00 00:00:00'), 
('45', '2020-07-17 14:00:27', '0000-00-00 00:00:00'), 
('45', '2020-07-17 16:20:48', '0000-00-00 00:00:00'), 
('45', '2020-07-17 18:40:25', '0000-00-00 00:00:00'), 
('45', '2020-07-17 20:51:15', '0000-00-00 00:00:00'), 
('45', '2020-07-18 17:28:57', '0000-00-00 00:00:00'), 
('45', '2020-07-18 19:01:37', '0000-00-00 00:00:00'), 
('45', '2020-07-19 10:38:10', '0000-00-00 00:00:00'), 
('45', '2020-07-19 11:59:10', '0000-00-00 00:00:00'), 
('45', '2020-07-19 12:58:37', '0000-00-00 00:00:00'), 
('45', '2020-07-19 15:24:28', '0000-00-00 00:00:00'), 
('45', '2020-07-19 15:32:30', '0000-00-00 00:00:00'), 
('45', '2020-07-19 16:20:31', '0000-00-00 00:00:00'), 
('45', '2020-07-19 16:24:12', '0000-00-00 00:00:00'), 
('45', '2020-07-20 10:38:01', '0000-00-00 00:00:00'), 
('45', '2020-07-20 11:17:36', '0000-00-00 00:00:00'), 
('45', '2020-07-20 13:46:44', '0000-00-00 00:00:00'), 
('45', '2020-07-20 13:51:44', '0000-00-00 00:00:00'), 
('45', '2020-07-20 15:02:50', '0000-00-00 00:00:00'), 
('45', '2020-07-20 15:46:42', '0000-00-00 00:00:00'), 
('45', '2020-07-20 15:50:04', '0000-00-00 00:00:00'), 
('45', '2020-07-20 16:05:59', '0000-00-00 00:00:00'), 
('45', '2020-07-20 16:08:49', '0000-00-00 00:00:00'), 
('45', '2020-07-20 16:13:01', '0000-00-00 00:00:00'), 
('45', '2020-07-20 16:28:53', '0000-00-00 00:00:00'), 
('45', '2020-07-20 18:26:57', '0000-00-00 00:00:00'), 
('45', '2020-07-20 18:57:15', '0000-00-00 00:00:00'), 
('45', '2020-07-21 10:36:23', '0000-00-00 00:00:00'), 
('45', '2020-07-21 11:57:13', '0000-00-00 00:00:00'), 
('45', '2020-07-21 12:14:25', '0000-00-00 00:00:00'), 
('45', '2020-07-21 12:30:49', '0000-00-00 00:00:00'), 
('45', '2020-07-21 13:40:17', '0000-00-00 00:00:00'), 
('45', '2020-07-21 15:47:44', '0000-00-00 00:00:00'), 
('45', '2020-07-21 16:22:39', '0000-00-00 00:00:00'), 
('45', '2020-07-21 16:25:04', '0000-00-00 00:00:00'), 
('45', '2020-07-21 16:35:19', '0000-00-00 00:00:00'), 
('45', '2020-07-21 16:36:43', '0000-00-00 00:00:00'), 
('45', '2020-07-21 16:48:38', '0000-00-00 00:00:00'), 
('45', '2020-07-21 16:52:36', '0000-00-00 00:00:00'), 
('45', '2020-07-21 17:09:05', '0000-00-00 00:00:00'), 
('45', '2020-07-21 19:15:13', '0000-00-00 00:00:00'), 
('45', '2020-07-21 19:34:40', '0000-00-00 00:00:00'), 
('45', '2020-07-22 10:45:01', '0000-00-00 00:00:00'), 
('45', '2020-07-22 13:49:15', '0000-00-00 00:00:00'), 
('45', '2020-07-22 14:24:20', '0000-00-00 00:00:00'), 
('45', '2020-07-22 16:21:07', '0000-00-00 00:00:00'), 
('45', '2020-07-22 17:09:53', '0000-00-00 00:00:00'), 
('45', '2020-07-22 17:53:45', '0000-00-00 00:00:00'), 
('45', '2020-07-22 18:29:20', '0000-00-00 00:00:00'), 
('45', '2020-07-22 18:33:02', '0000-00-00 00:00:00'), 
('45', '2020-07-22 18:59:41', '0000-00-00 00:00:00'), 
('45', '2020-07-22 19:00:18', '0000-00-00 00:00:00'), 
('45', '2020-07-22 19:52:25', '0000-00-00 00:00:00'), 
('45', '2020-07-23 08:43:56', '0000-00-00 00:00:00'), 
('45', '2020-07-23 10:19:05', '0000-00-00 00:00:00'), 
('45', '2020-07-23 11:30:33', '0000-00-00 00:00:00'), 
('45', '2020-07-23 11:32:13', '0000-00-00 00:00:00'), 
('45', '2020-07-23 13:52:53', '0000-00-00 00:00:00'), 
('45', '2020-07-23 13:59:55', '0000-00-00 00:00:00'), 
('45', '2020-07-23 14:17:05', '0000-00-00 00:00:00'), 
('45', '2020-07-23 15:53:26', '0000-00-00 00:00:00'), 
('45', '2020-07-24 10:37:03', '0000-00-00 00:00:00'), 
('45', '2020-07-24 10:48:58', '0000-00-00 00:00:00'), 
('45', '2020-07-24 11:20:10', '0000-00-00 00:00:00'), 
('45', '2020-07-24 12:09:52', '0000-00-00 00:00:00'), 
('45', '2020-07-24 13:35:58', '0000-00-00 00:00:00'), 
('45', '2020-07-24 14:08:05', '0000-00-00 00:00:00'), 
('45', '2020-07-24 14:08:40', '0000-00-00 00:00:00'), 
('45', '2020-07-24 14:57:44', '0000-00-00 00:00:00'), 
('45', '2020-07-24 15:45:58', '0000-00-00 00:00:00'), 
('45', '2020-07-24 17:20:01', '0000-00-00 00:00:00'), 
('45', '2020-07-24 18:24:32', '0000-00-00 00:00:00'), 
('45', '2020-07-25 11:08:32', '0000-00-00 00:00:00'), 
('45', '2020-07-25 11:33:59', '0000-00-00 00:00:00'), 
('45', '2020-07-25 13:39:26', '0000-00-00 00:00:00'), 
('45', '2020-07-25 15:29:18', '0000-00-00 00:00:00'), 
('45', '2020-07-25 17:16:35', '0000-00-00 00:00:00'), 
('45', '2020-07-25 19:41:53', '0000-00-00 00:00:00'), 
('45', '2020-07-26 10:02:24', '0000-00-00 00:00:00'), 
('45', '2020-07-26 12:11:23', '0000-00-00 00:00:00'), 
('45', '2020-07-26 14:33:44', '0000-00-00 00:00:00'), 
('45', '2020-07-26 14:37:42', '0000-00-00 00:00:00'), 
('45', '2020-07-26 14:38:55', '0000-00-00 00:00:00'), 
('45', '2020-07-26 15:34:33', '0000-00-00 00:00:00'), 
('45', '2020-07-26 15:52:06', '0000-00-00 00:00:00'), 
('45', '2020-07-26 19:21:58', '0000-00-00 00:00:00'), 
('45', '2020-07-26 20:02:36', '0000-00-00 00:00:00'), 
('45', '2020-07-26 20:09:27', '0000-00-00 00:00:00'), 
('45', '2020-07-27 12:58:49', '0000-00-00 00:00:00'), 
('45', '2020-07-27 13:28:40', '0000-00-00 00:00:00'), 
('45', '2020-07-27 13:57:06', '0000-00-00 00:00:00'), 
('45', '2020-07-27 16:22:13', '0000-00-00 00:00:00'), 
('45', '2020-07-28 10:16:54', '0000-00-00 00:00:00'), 
('45', '2020-07-28 16:30:11', '0000-00-00 00:00:00'), 
('45', '2020-07-28 17:08:00', '0000-00-00 00:00:00'), 
('45', '2020-07-28 18:00:23', '0000-00-00 00:00:00'), 
('45', '2020-07-29 13:05:27', '0000-00-00 00:00:00'), 
('45', '2020-07-29 15:55:12', '0000-00-00 00:00:00'), 
('45', '2020-07-29 16:09:03', '0000-00-00 00:00:00'), 
('45', '2020-07-29 16:50:57', '0000-00-00 00:00:00'), 
('45', '2020-07-29 18:39:36', '0000-00-00 00:00:00'), 
('45', '2020-07-29 18:57:43', '0000-00-00 00:00:00'), 
('45', '2020-07-29 19:26:55', '0000-00-00 00:00:00'), 
('45', '2020-07-29 20:21:48', '0000-00-00 00:00:00'), 
('45', '2020-07-29 20:38:59', '0000-00-00 00:00:00'), 
('45', '2020-07-30 09:29:46', '0000-00-00 00:00:00'), 
('45', '2020-07-30 10:03:37', '0000-00-00 00:00:00'), 
('45', '2020-07-30 13:01:25', '0000-00-00 00:00:00'), 
('45', '2020-07-30 13:39:20', '0000-00-00 00:00:00'), 
('45', '2020-07-30 16:52:13', '0000-00-00 00:00:00'), 
('45', '2020-07-30 16:55:17', '0000-00-00 00:00:00'), 
('45', '2020-07-30 18:19:44', '0000-00-00 00:00:00'), 
('45', '2020-07-30 19:12:44', '0000-00-00 00:00:00'), 
('45', '2020-07-31 10:16:42', '0000-00-00 00:00:00'), 
('45', '2020-08-03 10:45:05', '0000-00-00 00:00:00'), 
('45', '2020-08-03 10:51:35', '0000-00-00 00:00:00'), 
('45', '2020-08-03 17:04:14', '0000-00-00 00:00:00'), 
('45', '2020-08-03 17:13:11', '0000-00-00 00:00:00'), 
('45', '2020-08-04 10:32:27', '0000-00-00 00:00:00'), 
('45', '2020-08-04 15:40:53', '0000-00-00 00:00:00'), 
('45', '2020-08-04 16:14:04', '0000-00-00 00:00:00'), 
('45', '2020-08-04 16:58:53', '0000-00-00 00:00:00'), 
('45', '2020-08-04 17:08:11', '0000-00-00 00:00:00'), 
('45', '2020-08-04 17:09:38', '0000-00-00 00:00:00'), 
('45', '2020-08-04 17:13:11', '0000-00-00 00:00:00'), 
('45', '2020-08-04 17:16:16', '0000-00-00 00:00:00'), 
('45', '2020-08-04 18:01:33', '0000-00-00 00:00:00'), 
('45', '2020-08-04 19:11:15', '0000-00-00 00:00:00'), 
('45', '2020-08-04 19:25:23', '0000-00-00 00:00:00'), 
('45', '2020-08-04 19:51:23', '0000-00-00 00:00:00'), 
('45', '2020-08-04 20:01:54', '0000-00-00 00:00:00'), 
('45', '2020-08-05 09:25:48', '0000-00-00 00:00:00'), 
('45', '2020-08-05 15:11:20', '0000-00-00 00:00:00'), 
('45', '2020-08-06 09:22:17', '0000-00-00 00:00:00'), 
('45', '2020-08-06 16:56:35', '0000-00-00 00:00:00'), 
('45', '2020-08-06 17:12:25', '0000-00-00 00:00:00'), 
('45', '2020-08-06 17:15:30', '0000-00-00 00:00:00'), 
('45', '2020-08-06 17:18:34', '0000-00-00 00:00:00'), 
('45', '2020-08-07 10:31:52', '0000-00-00 00:00:00'), 
('45', '2020-08-07 13:11:44', '0000-00-00 00:00:00'), 
('45', '2020-08-07 16:59:28', '0000-00-00 00:00:00'), 
('45', '2020-08-08 01:59:35', '0000-00-00 00:00:00'), 
('45', '2020-08-08 02:12:05', '0000-00-00 00:00:00'), 
('45', '2020-08-08 09:30:23', '0000-00-00 00:00:00'), 
('45', '2020-08-08 11:26:29', '0000-00-00 00:00:00'), 
('45', '2020-08-08 15:27:22', '0000-00-00 00:00:00'), 
('45', '2020-08-08 16:22:38', '0000-00-00 00:00:00'), 
('45', '2020-08-08 17:00:33', '0000-00-00 00:00:00'), 
('45', '2020-08-08 19:34:57', '0000-00-00 00:00:00'), 
('45', '2020-08-09 09:41:51', '0000-00-00 00:00:00'), 
('45', '2020-08-09 09:42:22', '0000-00-00 00:00:00'), 
('45', '2020-08-09 09:47:29', '0000-00-00 00:00:00'), 
('45', '2020-08-09 10:39:45', '0000-00-00 00:00:00'), 
('45', '2020-08-09 11:22:45', '0000-00-00 00:00:00'), 
('45', '2020-08-09 11:27:53', '0000-00-00 00:00:00'), 
('45', '2020-08-09 11:32:45', '0000-00-00 00:00:00'), 
('45', '2020-08-09 12:40:07', '0000-00-00 00:00:00'), 
('45', '2020-08-09 12:41:47', '0000-00-00 00:00:00'), 
('45', '2020-08-09 12:58:42', '0000-00-00 00:00:00'), 
('45', '2020-08-10 09:26:08', '0000-00-00 00:00:00'), 
('45', '2020-08-10 10:05:51', '0000-00-00 00:00:00'), 
('45', '2020-08-10 10:54:48', '0000-00-00 00:00:00'), 
('45', '2020-08-10 14:38:31', '0000-00-00 00:00:00'), 
('45', '2020-08-10 16:10:15', '0000-00-00 00:00:00'), 
('45', '2020-08-10 18:38:04', '0000-00-00 00:00:00'), 
('45', '2020-08-11 09:08:13', '0000-00-00 00:00:00'), 
('45', '2020-08-11 10:33:00', '0000-00-00 00:00:00'), 
('45', '2020-08-11 11:13:07', '0000-00-00 00:00:00'), 
('45', '2020-08-11 12:24:21', '0000-00-00 00:00:00'), 
('45', '2020-08-11 16:13:00', '0000-00-00 00:00:00'), 
('45', '2020-08-11 17:24:23', '0000-00-00 00:00:00'), 
('45', '2020-08-12 11:15:23', '0000-00-00 00:00:00'), 
('45', '2020-08-12 14:27:22', '0000-00-00 00:00:00'), 
('45', '2020-08-12 14:37:41', '0000-00-00 00:00:00'), 
('45', '2020-08-12 18:13:55', '0000-00-00 00:00:00'), 
('45', '2020-08-13 10:01:08', '0000-00-00 00:00:00'), 
('45', '2020-08-13 10:25:41', '0000-00-00 00:00:00'), 
('45', '2020-08-13 11:47:32', '0000-00-00 00:00:00'), 
('45', '2020-08-13 16:13:06', '0000-00-00 00:00:00'), 
('45', '2020-08-13 16:31:54', '0000-00-00 00:00:00'), 
('45', '2020-08-13 19:15:06', '0000-00-00 00:00:00'), 
('45', '2020-08-14 16:37:48', '0000-00-00 00:00:00'), 
('45', '2020-08-14 21:34:58', '0000-00-00 00:00:00'), 
('45', '2020-08-15 09:38:32', '0000-00-00 00:00:00'), 
('45', '2020-08-15 10:17:43', '0000-00-00 00:00:00'), 
('45', '2020-08-15 11:43:30', '0000-00-00 00:00:00'), 
('45', '2020-08-15 14:44:36', '0000-00-00 00:00:00'), 
('45', '2020-08-15 16:40:12', '0000-00-00 00:00:00'), 
('45', '2020-08-15 19:14:14', '0000-00-00 00:00:00'), 
('45', '2020-08-15 19:28:40', '0000-00-00 00:00:00'), 
('45', '2020-08-16 10:56:19', '0000-00-00 00:00:00'), 
('45', '2020-08-16 12:32:31', '0000-00-00 00:00:00'), 
('45', '2020-08-16 17:00:05', '0000-00-00 00:00:00'), 
('45', '2020-08-16 17:42:13', '0000-00-00 00:00:00'), 
('45', '2020-08-16 17:52:18', '0000-00-00 00:00:00'), 
('45', '2020-08-16 17:55:49', '0000-00-00 00:00:00'), 
('45', '2020-08-16 18:12:53', '0000-00-00 00:00:00'), 
('45', '2020-08-16 18:26:06', '0000-00-00 00:00:00'), 
('45', '2020-08-16 18:26:37', '0000-00-00 00:00:00'), 
('45', '2020-08-16 18:56:16', '0000-00-00 00:00:00'), 
('45', '2020-08-16 19:18:21', '0000-00-00 00:00:00'), 
('45', '2020-08-17 10:50:52', '0000-00-00 00:00:00'), 
('45', '2020-08-17 13:01:25', '0000-00-00 00:00:00'), 
('45', '2020-08-17 14:59:35', '0000-00-00 00:00:00'), 
('45', '2020-08-17 16:11:55', '0000-00-00 00:00:00'), 
('45', '2020-08-17 19:23:20', '0000-00-00 00:00:00'), 
('45', '2020-08-17 19:37:38', '0000-00-00 00:00:00'), 
('45', '2020-08-17 19:44:06', '0000-00-00 00:00:00'), 
('45', '2020-08-18 09:09:11', '0000-00-00 00:00:00'), 
('45', '2020-08-18 09:21:28', '0000-00-00 00:00:00'), 
('45', '2020-08-18 12:08:05', '0000-00-00 00:00:00'), 
('45', '2020-08-18 12:11:35', '0000-00-00 00:00:00'), 
('45', '2020-08-18 12:13:54', '0000-00-00 00:00:00'), 
('45', '2020-08-18 12:15:46', '0000-00-00 00:00:00'), 
('45', '2020-08-18 12:18:30', '0000-00-00 00:00:00'), 
('45', '2020-08-18 12:20:34', '0000-00-00 00:00:00'), 
('45', '2020-08-18 15:14:47', '0000-00-00 00:00:00'), 
('45', '2020-08-18 15:25:53', '0000-00-00 00:00:00'), 
('45', '2020-08-18 15:28:27', '0000-00-00 00:00:00'), 
('45', '2020-08-18 15:43:29', '0000-00-00 00:00:00'), 
('45', '2020-08-18 15:58:41', '0000-00-00 00:00:00'), 
('45', '2020-08-18 16:02:47', '0000-00-00 00:00:00'), 
('45', '2020-08-18 16:06:03', '0000-00-00 00:00:00'), 
('45', '2020-08-18 16:09:49', '0000-00-00 00:00:00'), 
('45', '2020-08-18 16:13:43', '0000-00-00 00:00:00'), 
('45', '2020-08-18 16:16:06', '0000-00-00 00:00:00'), 
('45', '2020-08-18 17:31:46', '0000-00-00 00:00:00'), 
('45', '2020-08-19 09:19:44', '0000-00-00 00:00:00'), 
('45', '2020-08-19 10:17:08', '0000-00-00 00:00:00'), 
('45', '2020-08-19 10:52:26', '0000-00-00 00:00:00'), 
('45', '2020-08-19 13:56:17', '0000-00-00 00:00:00'), 
('45', '2020-08-19 16:32:49', '0000-00-00 00:00:00'), 
('45', '2020-08-19 16:41:28', '0000-00-00 00:00:00'), 
('45', '2020-08-19 17:06:35', '0000-00-00 00:00:00'), 
('45', '2020-08-19 17:28:44', '0000-00-00 00:00:00'), 
('45', '2020-08-19 17:29:57', '0000-00-00 00:00:00'), 
('45', '2020-08-19 20:02:37', '0000-00-00 00:00:00'), 
('45', '2020-08-20 11:01:51', '0000-00-00 00:00:00'), 
('45', '2020-08-20 15:55:26', '0000-00-00 00:00:00'), 
('45', '2020-08-20 16:56:44', '0000-00-00 00:00:00'), 
('45', '2020-08-21 10:53:44', '0000-00-00 00:00:00'), 
('45', '2020-08-21 11:46:13', '0000-00-00 00:00:00'), 
('45', '2020-08-21 12:00:41', '0000-00-00 00:00:00'), 
('45', '2020-08-22 09:53:46', '0000-00-00 00:00:00'), 
('45', '2020-08-22 10:34:58', '0000-00-00 00:00:00'), 
('45', '2020-08-22 10:35:51', '0000-00-00 00:00:00'), 
('45', '2020-08-22 20:30:06', '0000-00-00 00:00:00'), 
('45', '2020-08-23 10:13:36', '0000-00-00 00:00:00'), 
('45', '2020-08-23 13:31:24', '0000-00-00 00:00:00'), 
('45', '2020-08-23 13:32:52', '0000-00-00 00:00:00'), 
('45', '2020-08-23 13:34:55', '0000-00-00 00:00:00'), 
('45', '2020-08-23 13:37:10', '0000-00-00 00:00:00'), 
('45', '2020-08-23 14:12:35', '0000-00-00 00:00:00'), 
('45', '2020-08-23 14:21:39', '0000-00-00 00:00:00'), 
('45', '2020-08-23 14:57:22', '0000-00-00 00:00:00'), 
('45', '2020-08-23 15:05:23', '0000-00-00 00:00:00'), 
('45', '2020-08-23 15:25:31', '0000-00-00 00:00:00'), 
('45', '2020-08-23 16:35:31', '0000-00-00 00:00:00'), 
('45', '2020-08-23 17:03:06', '0000-00-00 00:00:00'), 
('45', '2020-08-23 17:12:53', '0000-00-00 00:00:00'), 
('45', '2020-08-23 18:37:36', '0000-00-00 00:00:00'), 
('45', '2020-08-23 19:51:26', '0000-00-00 00:00:00'), 
('45', '2020-08-24 10:14:04', '0000-00-00 00:00:00'), 
('45', '2020-08-24 14:12:34', '0000-00-00 00:00:00'), 
('45', '2020-08-24 14:37:40', '0000-00-00 00:00:00'), 
('45', '2020-08-24 14:38:37', '0000-00-00 00:00:00'), 
('45', '2020-08-24 16:35:02', '0000-00-00 00:00:00'), 
('45', '2020-08-24 18:37:24', '0000-00-00 00:00:00'), 
('45', '2020-08-24 19:11:47', '0000-00-00 00:00:00'), 
('45', '2020-08-24 19:41:57', '0000-00-00 00:00:00'), 
('45', '2020-08-25 09:41:27', '0000-00-00 00:00:00'), 
('45', '2020-08-25 12:15:49', '0000-00-00 00:00:00'), 
('45', '2020-08-25 12:17:29', '0000-00-00 00:00:00'), 
('45', '2020-08-25 19:20:09', '0000-00-00 00:00:00'), 
('45', '2020-08-25 19:25:37', '0000-00-00 00:00:00'), 
('45', '2020-08-26 09:46:14', '0000-00-00 00:00:00'), 
('45', '2020-08-26 10:00:50', '0000-00-00 00:00:00'), 
('45', '2020-08-26 10:04:19', '0000-00-00 00:00:00'), 
('45', '2020-08-26 10:46:10', '0000-00-00 00:00:00'), 
('45', '2020-08-26 12:31:30', '0000-00-00 00:00:00'), 
('45', '2020-08-26 12:34:55', '0000-00-00 00:00:00'), 
('45', '2020-08-26 14:39:46', '0000-00-00 00:00:00'), 
('45', '2020-08-26 15:03:37', '0000-00-00 00:00:00'), 
('45', '2020-08-26 15:06:38', '0000-00-00 00:00:00'), 
('45', '2020-08-26 15:52:18', '0000-00-00 00:00:00'), 
('45', '2020-08-26 16:16:07', '0000-00-00 00:00:00'), 
('45', '2020-08-27 09:32:03', '0000-00-00 00:00:00'), 
('45', '2020-08-27 11:06:39', '0000-00-00 00:00:00'), 
('45', '2020-08-27 17:19:38', '0000-00-00 00:00:00'), 
('45', '2020-08-27 17:36:59', '0000-00-00 00:00:00'), 
('45', '2020-08-27 17:56:52', '0000-00-00 00:00:00'), 
('45', '2020-08-27 17:59:00', '0000-00-00 00:00:00'), 
('45', '2020-08-27 18:42:22', '0000-00-00 00:00:00'), 
('45', '2020-08-27 20:02:52', '0000-00-00 00:00:00'), 
('45', '2020-08-28 08:40:40', '0000-00-00 00:00:00'), 
('45', '2020-08-28 08:57:59', '0000-00-00 00:00:00'), 
('45', '2020-08-28 10:06:09', '0000-00-00 00:00:00'), 
('45', '2020-08-28 11:24:41', '0000-00-00 00:00:00'), 
('45', '2020-08-29 12:15:57', '0000-00-00 00:00:00'), 
('45', '2020-08-29 14:14:39', '0000-00-00 00:00:00'), 
('45', '2020-08-29 14:52:29', '0000-00-00 00:00:00'), 
('45', '2020-08-29 15:05:34', '0000-00-00 00:00:00'), 
('45', '2020-08-29 15:37:42', '0000-00-00 00:00:00'), 
('45', '2020-08-29 16:07:30', '0000-00-00 00:00:00'), 
('45', '2020-08-29 16:26:20', '0000-00-00 00:00:00'), 
('45', '2020-08-29 17:10:10', '0000-00-00 00:00:00'), 
('45', '2020-08-29 17:38:32', '0000-00-00 00:00:00'), 
('45', '2020-08-29 19:12:57', '0000-00-00 00:00:00'), 
('45', '2020-08-29 20:12:44', '0000-00-00 00:00:00'), 
('45', '2020-08-29 21:12:53', '0000-00-00 00:00:00'), 
('45', '2020-08-29 21:15:54', '0000-00-00 00:00:00'), 
('45', '2020-08-30 10:53:53', '0000-00-00 00:00:00'), 
('45', '2020-08-30 14:13:30', '0000-00-00 00:00:00'), 
('45', '2020-08-30 14:15:14', '0000-00-00 00:00:00'), 
('45', '2020-08-30 14:58:11', '0000-00-00 00:00:00'), 
('45', '2020-08-30 15:38:48', '0000-00-00 00:00:00'), 
('45', '2020-08-30 16:01:23', '0000-00-00 00:00:00'), 
('45', '2020-08-30 16:03:11', '0000-00-00 00:00:00'), 
('45', '2020-08-30 19:33:30', '0000-00-00 00:00:00'), 
('45', '2020-08-30 21:02:10', '0000-00-00 00:00:00'), 
('45', '2020-08-31 09:26:48', '0000-00-00 00:00:00'), 
('45', '2020-08-31 09:31:24', '0000-00-00 00:00:00'), 
('45', '2020-08-31 09:39:11', '0000-00-00 00:00:00'), 
('45', '2020-08-31 10:54:46', '0000-00-00 00:00:00'), 
('45', '2020-08-31 11:27:14', '0000-00-00 00:00:00'), 
('45', '2020-08-31 13:15:08', '0000-00-00 00:00:00'), 
('45', '2020-08-31 15:47:48', '0000-00-00 00:00:00'), 
('45', '2020-08-31 16:39:37', '0000-00-00 00:00:00'), 
('45', '2020-08-31 19:39:52', '0000-00-00 00:00:00'), 
('45', '2020-08-31 20:05:15', '0000-00-00 00:00:00'), 
('45', '2020-08-31 20:13:08', '0000-00-00 00:00:00'), 
('45', '2020-09-01 11:14:21', '0000-00-00 00:00:00'), 
('45', '2020-09-01 12:08:19', '0000-00-00 00:00:00'), 
('45', '2020-09-01 13:52:56', '0000-00-00 00:00:00'), 
('45', '2020-09-01 14:15:03', '0000-00-00 00:00:00'), 
('45', '2020-09-01 14:28:53', '0000-00-00 00:00:00'), 
('45', '2020-09-01 14:53:34', '0000-00-00 00:00:00'), 
('45', '2020-09-01 16:19:40', '0000-00-00 00:00:00'), 
('45', '2020-09-01 17:01:40', '0000-00-00 00:00:00'), 
('45', '2020-09-01 17:17:09', '0000-00-00 00:00:00'), 
('45', '2020-09-01 17:38:29', '0000-00-00 00:00:00'), 
('45', '2020-09-01 17:41:16', '0000-00-00 00:00:00'), 
('45', '2020-09-01 19:13:59', '0000-00-00 00:00:00'), 
('45', '2020-09-01 19:32:48', '0000-00-00 00:00:00'), 
('45', '2020-09-02 10:07:21', '0000-00-00 00:00:00'), 
('45', '2020-09-02 14:12:24', '0000-00-00 00:00:00'), 
('45', '2020-09-02 14:36:18', '0000-00-00 00:00:00'), 
('45', '2020-09-02 14:37:26', '0000-00-00 00:00:00'), 
('45', '2020-09-02 15:23:35', '0000-00-00 00:00:00'), 
('45', '2020-09-02 18:15:11', '0000-00-00 00:00:00'), 
('45', '2020-09-02 18:55:54', '0000-00-00 00:00:00'), 
('45', '2020-09-02 19:11:48', '0000-00-00 00:00:00'), 
('45', '2020-09-02 20:17:41', '0000-00-00 00:00:00'), 
('45', '2020-09-02 20:54:15', '0000-00-00 00:00:00'), 
('45', '2020-09-02 21:08:34', '0000-00-00 00:00:00'), 
('45', '2020-09-03 09:48:40', '0000-00-00 00:00:00');  



 



 



INSERT INTO `admissions` ( `id`, `date`, `pid`, `guardian`, `seat`, `bill`, `status`) VALUES 
('1', '2018-07-10', '47857', 'Ipsam vel cumque sit dicta', '', '0', 'admitted'), 
('2', '2018-07-10', '47857', 'Ipsam vel cumque sit dicta', '', '0', 'admitted'), 
('3', '2018-07-10', '00001', 'Ad consectetur harum ', '', '0', 'admitted'), 
('4', '2018-07-12', '00002', '', '', '0', 'admitted');  



INSERT INTO `altra_doctor_payment` ( `id`, `date`, `doctor_id`, `payment`, `trash`) VALUES 
('4', '2020-07-22', '32', '23.00', '0'), 
('2', '2020-07-22', '17', '200.00', '0'), 
('3', '2020-07-22', '20', '5630.00', '0'), 
('7', '2020-09-01', '20', '150.00', '0');  



 



INSERT INTO `bank` ( `id`, `date`, `bank_name`) VALUES 
('16', '2020-09-01', 'Dbbl'), 
('17', '2020-09-01', 'RUPALI');  



INSERT INTO `bank_account` ( `id`, `datetime`, `bank_name`, `branch_name`, `holder_name`, `holder_contact`, `account_number`, `init_balance`, `pre_balance`) VALUES 
('18', '2020-09-01', 'Dbbl', 'muktagacha', 'rasel', '01723926073', '54654646546', '5000.00', '5000'), 
('19', '2020-09-01', 'RUPALI', 'MUKTAGACHA', 'RASEL', '01723926073', '12345678', '500.00', '500');  



INSERT INTO `bank_name` ( `id`, `date`, `bank_name`) VALUES 
('1', '2017-03-12', 'Sonali_Bank_Limited'), 
('2', '2017-03-12', 'Janata_Bank_Limited'), 
('3', '2017-03-12', 'Agrani_Bank_Limited'), 
('4', '2017-03-12', 'Rupali_Bank_Limited'), 
('5', '2017-03-12', 'AB_Bank_Limited'), 
('6', '2017-03-12', 'Jamuna_Bank_Limited'), 
('7', '2017-03-12', 'National_Bank_Limited'), 
('8', '2017-03-12', 'NCC_Bank_Limited'), 
('9', '2017-03-12', 'Prime_Bank_Limited'), 
('10', '2017-03-12', 'Standard_Bank_Limited'), 
('11', '2017-03-12', 'The_City_Bank_Limited'), 
('12', '2017-03-12', 'Trust_Bank_Limited'), 
('13', '2017-03-12', 'Islami_Bank_Bangladesh_Limited'), 
('14', '2017-03-12', 'The_City_Bank_Limited'), 
('15', '2017-03-12', 'Dutch_Bangla_Bank');  



INSERT INTO `bills` ( `id`, `date`, `voucher`, `pid`, `title`, `details`, `subtotal`, `vat`, `vat_amount`, `total`, `discount`, `less_type`, `grand_total`, `paid`, `due`, `last_paid`, `last_payment_date`, `payment_status`, `refereed_doctor`, `status`) VALUES 
('1', '2020-06-23', '2006230001', '0034', 'consultancy', '', '0.00', '0', '0.00', '600.00', '100.00', '', '500.00', '500.00', '0.00', '500.00', '2020-06-23', 'pending', '', ''), 
('3', '2020-06-23', '2006230003', '0036', 'consultancy', '', '0.00', '0', '0.00', '900.00', '5.00', '', '895.00', '800.00', '95.00', '800.00', '2020-06-23', 'pending', '', ''), 
('4', '2020-06-23', '2006230004', '0037', 'consultancy', '', '0.00', '0', '0.00', '900.00', '500.00', '', '400.00', '0.00', '400.00', '0.00', '2020-06-23', 'pending', '', ''), 
('6', '2020-06-24', '2006240006', '00003', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '0.00', '', '700.00', '0.00', '0.00', '0.00', '2020-07-06', 'pending', '', 'diagnosis'), 
('15', '2020-06-24', '2006240012', '0005', 'consultancy', '', '0.00', '0', '0.00', '600.00', '0.00', '', '600.00', '300.00', '300.00', '300.00', '2020-06-24', 'pending', '', ''), 
('18', '2020-06-25', '2006250018', '00005', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '300.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-06-25', 'pending', '', 'diagnosis'), 
('19', '2020-06-29', '2006290019', '0010', 'consultancy', '', '0.00', '0', '0.00', '600.00', '0.00', '', '600.00', '600.00', '0.00', '600.00', '2020-06-29', 'pending', '', ''), 
('20', '2020-06-30', '2006300020', '00006', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-06-30', 'pending', '', 'diagnosis'), 
('21', '2020-06-30', '2006300021', '00007', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-06-30', 'pending', '', 'diagnosis'), 
('22', '2020-06-30', '2006300022', '0013', 'consultancy', '', '0.00', '0', '0.00', '300.00', '0.00', '', '300.00', '300.00', '0.00', '300.00', '2020-06-30', 'pending', '', ''), 
('23', '2020-06-30', '2006300023', '0014', 'consultancy', '', '0.00', '0', '0.00', '300.00', '0.00', '', '300.00', '300.00', '0.00', '300.00', '2020-06-30', 'pending', '', ''), 
('24', '2020-06-30', '2006300024', '0015', 'consultancy', '', '0.00', '0', '0.00', '300.00', '0.00', '', '300.00', '300.00', '0.00', '300.00', '2020-06-30', 'pending', '', ''), 
('26', '2020-07-02', '2007020026', '0017', 'consultancy', '', '0.00', '0', '0.00', '300.00', '100.00', '', '200.00', '200.00', '0.00', '200.00', '2020-07-02', 'pending', '', ''), 
('27', '2020-07-02', '2007020027', '00009', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-07-02', 'pending', '', 'diagnosis'), 
('28', '2020-07-02', '2007020028', '0019', 'consultancy', '', '0.00', '0', '0.00', '300.00', '0.00', '', '300.00', '300.00', '0.00', '300.00', '2020-07-02', 'pending', '', ''), 
('29', '2020-07-02', '2007020029', '0020', 'consultancy', '', '0.00', '0', '0.00', '400.00', '0.00', '', '400.00', '50.00', '350.00', '50.00', '2020-07-02', 'pending', '', ''), 
('30', '2020-07-02', '2007020030', '00010', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '250.00', 'Flat', '1700.00', '1700.00', '0.00', '1700.00', '2020-07-02', 'pending', '', 'diagnosis'), 
('31', '2020-07-02', '2007020031', '00011', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', '? undefined:undefined ?', '400.00', '400.00', '0.00', '400.00', '2020-07-02', 'pending', '', 'diagnosis'), 
('33', '2020-07-02', '2007020033', '00013', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '600.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-07-02', 'pending', '', 'diagnosis'), 
('34', '2020-07-02', '2007020034', '00014', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-07-02', 'pending', '', 'diagnosis'), 
('35', '2020-07-02', '2007020035', '00015', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-07-02', 'pending', '', 'diagnosis'), 
('36', '2020-07-02', '2007020036', '00016', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '500.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-07-02', 'pending', '', 'diagnosis'), 
('37', '2020-07-02', '2007020037', '00017', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '200.00', 'Flat', '450.00', '450.00', '0.00', '450.00', '2020-07-02', 'pending', '', 'diagnosis'), 
('38', '2020-07-02', '2007020038', '00018', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-07-02', 'pending', '', 'diagnosis'), 
('39', '2020-07-02', '2007020039', '00019', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-02', 'pending', '', 'diagnosis'), 
('40', '2020-07-02', '2007020040', '00020', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '100.00', 'Flat', '550.00', '550.00', '0.00', '550.00', '2020-07-02', 'pending', '', 'diagnosis'), 
('41', '2020-07-02', '2007020041', '00021', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-07-02', 'pending', '', 'diagnosis'), 
('42', '2020-07-03', '2007030042', '00022', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '300.00', '100.00', '300.00', '2020-07-03', 'pending', '', 'diagnosis'), 
('43', '2020-07-03', '2007030043', '00023', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-07-03', 'pending', '', 'diagnosis'), 
('44', '2020-07-03', '2007030044', '00024', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '150.00', 'Flat', '1700.00', '1000.00', '700.00', '1000.00', '2020-07-03', 'pending', '', 'diagnosis'), 
('45', '2020-07-03', '2007030045', '00025', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '500.00', 'Flat', '1300.00', '1200.00', '100.00', '1200.00', '2020-07-03', 'pending', '', 'diagnosis'), 
('46', '2020-07-03', '2007030046', '00026', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '300.00', 'Flat', '1200.00', '1100.00', '100.00', '1100.00', '2020-07-03', 'pending', '', 'diagnosis'), 
('47', '2020-07-03', '2007030047', '00027', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '300.00', 'Flat', '1100.00', '200.00', '900.00', '200.00', '2020-07-03', 'pending', '', 'diagnosis'), 
('48', '2020-07-03', '2007030048', '00028', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '450.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-03', 'pending', '', 'diagnosis'), 
('49', '2020-07-03', '2007030049', '00029', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '1200.00', '0.00', '1200.00', '2020-07-03', 'pending', '', 'diagnosis'), 
('50', '2020-07-03', '2007030050', '00030', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-07-03', 'pending', '', 'diagnosis'), 
('51', '2020-07-03', '2007030051', '00031', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-07-03', 'pending', '', 'diagnosis'), 
('52', '2020-07-03', '2007030052', '00032', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '450.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-03', 'pending', '', 'diagnosis'), 
('53', '2020-07-03', '2007030053', '00033', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '200.00', 'Flat', '1400.00', '1200.00', '200.00', '1200.00', '2020-07-03', 'pending', '', 'diagnosis'), 
('54', '2020-07-03', '2007030054', '00034', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-07-03', 'pending', '', 'diagnosis'), 
('55', '2020-07-05', '2007050055', '00035', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '180.00', 'Flat', '120.00', '120.00', '0.00', '120.00', '2020-07-05', 'pending', '', 'diagnosis'), 
('56', '2020-07-05', '2007050056', '00036', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-07-05', 'pending', '', 'diagnosis'), 
('57', '2020-07-05', '2007050057', '00037', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '430.00', 'Flat', '220.00', '220.00', '0.00', '220.00', '2020-07-05', 'pending', '', 'diagnosis'), 
('58', '2020-07-05', '2007050058', '00038', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-05', 'pending', '', 'diagnosis'), 
('59', '2020-07-05', '2007050059', '00039', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-05', 'pending', '', 'diagnosis'), 
('60', '2020-07-05', '2007050060', '00040', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-05', 'pending', '', 'diagnosis'), 
('61', '2020-07-05', '2007050061', '00041', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-07-05', 'pending', '', 'diagnosis'), 
('63', '2020-07-05', '2007050063', '00043', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-05', 'pending', '', 'diagnosis'), 
('64', '2020-07-05', '2007050064', '00044', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-07-05', 'pending', '', 'diagnosis'), 
('66', '2020-07-05', '2007050066', '00046', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-05', 'pending', '', 'diagnosis'), 
('68', '2020-07-05', '2007050068', '00048', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '1050.00', 'Flat', '0.00', '1100.00', '-1100.00', '1100.00', '2020-07-05', 'pending', '', 'diagnosis'), 
('69', '2020-07-05', '2007050069', '00049', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '800.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-07-05', 'pending', '', 'diagnosis'), 
('70', '2020-07-05', '2007050070', '00050', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-07-05', 'pending', '', 'diagnosis'), 
('71', '2020-07-05', '2007050071', '00051', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '400.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-07-05', 'pending', '', 'diagnosis'), 
('72', '2020-07-05', '2007050072', '00052', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '850.00', 'Flat', '1100.00', '1100.00', '0.00', '1100.00', '2020-07-05', 'pending', '', 'diagnosis'), 
('73', '2020-07-05', '2007050073', '00053', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '450.00', 'Flat', '1500.00', '1500.00', '0.00', '1500.00', '2020-07-05', 'pending', '', 'diagnosis'), 
('74', '2020-07-05', '2007050074', '00054', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '800.00', 'Flat', '1100.00', '1100.00', '0.00', '1100.00', '2020-07-05', 'pending', '', 'diagnosis'), 
('75', '2020-07-06', '2007060075', '00055', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-07-06', 'pending', '', 'diagnosis'), 
('76', '2020-07-06', '2007060076', '00056', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '500.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-07-06', 'pending', '', 'diagnosis'), 
('77', '2020-07-06', '2007060077', '00057', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-06', 'pending', '', 'diagnosis'), 
('78', '2020-07-06', '2007060078', '00058', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-07-06', 'pending', '', 'diagnosis'), 
('80', '2020-07-06', '2007060080', '00060', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '450.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-06', 'pending', '', 'diagnosis'), 
('82', '2020-07-06', '2007060082', '00062', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '90.00', 'Flat', '60.00', '60.00', '0.00', '60.00', '2020-07-06', 'pending', '', 'diagnosis'), 
('87', '2020-07-06', '2007060083', '00067', 'diagnosis', 'diagnosis', '2150.00', '0', '0.00', '2150.00', '550.00', 'Flat', '1600.00', '1600.00', '0.00', '1600.00', '2020-07-06', 'pending', '', 'diagnosis'), 
('89', '2020-07-06', '2007060088', '00069', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-06', 'pending', '', 'diagnosis'), 
('90', '2020-07-06', '2007060090', '00070', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-06', 'pending', '', 'diagnosis'), 
('91', '2020-07-06', '2007060091', '00071', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '250.00', 'Flat', '1100.00', '1100.00', '0.00', '1100.00', '2020-07-06', 'pending', '', 'diagnosis'), 
('92', '2020-07-06', '2007060092', '00072', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '450.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-06', 'pending', '', 'diagnosis'), 
('93', '2020-07-06', '2007060093', '00073', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '450.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-06', 'pending', '', 'diagnosis'), 
('94', '2020-07-06', '2007060094', '00074', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-07-06', 'pending', '', 'diagnosis'), 
('95', '2020-07-07', '2007070095', '00075', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-07', 'pending', '', 'diagnosis'), 
('96', '2020-07-07', '2007070096', '00076', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-07', 'pending', '', 'diagnosis'), 
('97', '2020-07-07', '2007070097', '00077', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-07-07', 'pending', '', 'diagnosis'), 
('98', '2020-07-07', '2007070098', '00078', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '200.00', 'Flat', '450.00', '450.00', '0.00', '450.00', '2020-07-07', 'pending', '', 'diagnosis'), 
('99', '2020-07-07', '2007070099', '00079', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-07', 'pending', '', 'diagnosis'), 
('101', '2020-07-07', '2007070101', '00080', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '450.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-07', 'pending', '', 'diagnosis'), 
('102', '2020-07-07', '2007070102', '00081', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-07', 'pending', '', 'diagnosis'), 
('108', '2020-07-07', '2007070108', '00087', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '450.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-07', 'pending', '', 'diagnosis'), 
('110', '2020-07-07', '2007070110', '00089', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '350.00', 'Flat', '1400.00', '1300.00', '100.00', '1300.00', '2020-07-07', 'pending', '', 'diagnosis'), 
('111', '2020-07-07', '2007070111', '00090', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '450.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-07-07', 'pending', '', 'diagnosis'), 
('114', '2020-07-07', '2007070112', '00093', 'diagnosis', 'diagnosis', '2800.00', '0', '0.00', '2800.00', '800.00', 'Flat', '2000.00', '2000.00', '0.00', '2000.00', '2020-07-07', 'pending', '', 'diagnosis'), 
('115', '2020-07-07', '2007070115', '00094', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '200.00', 'Flat', '450.00', '450.00', '0.00', '450.00', '2020-07-07', 'pending', '', 'diagnosis'), 
('117', '2020-07-07', '2007070117', '00096', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '500.00', 'Flat', '1100.00', '1100.00', '0.00', '1100.00', '2020-07-07', 'pending', '', 'diagnosis'), 
('119', '2020-07-08', '2007080119', '00098', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-08', 'pending', '', 'diagnosis'), 
('120', '2020-07-08', '2007080120', '00099', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-08', 'pending', '', 'diagnosis'), 
('121', '2020-07-08', '2007080121', '00100', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-08', 'pending', '', 'diagnosis'), 
('122', '2020-07-08', '2007080122', '00101', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-08', 'pending', '', 'diagnosis'), 
('125', '2020-07-08', '2007080125', '00104', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-07-08', 'pending', '', 'diagnosis'), 
('126', '2020-07-08', '2007080126', '00105', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-08', 'pending', '', 'diagnosis'), 
('127', '2020-07-08', '2007080127', '00106', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-08', 'pending', '', 'diagnosis'), 
('129', '2020-07-08', '2007080129', '00108', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-07-08', 'pending', '', 'diagnosis'), 
('131', '2020-07-08', '2007080130', '00110', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '350.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-07-08', 'pending', '', 'diagnosis'), 
('132', '2020-07-08', '2007080132', '00111', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-08', 'pending', '', 'diagnosis'), 
('133', '2020-07-08', '2007080133', '00112', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '650.00', 'Flat', '1200.00', '1200.00', '0.00', '1200.00', '2020-07-08', 'pending', '', 'diagnosis'), 
('134', '2020-07-08', '2007080134', '00113', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '100.00', 'Flat', '1100.00', '1100.00', '0.00', '1100.00', '2020-07-08', 'pending', '', 'diagnosis'), 
('135', '2020-07-08', '2007080135', '00114', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-08', 'pending', '', 'diagnosis'), 
('136', '2020-07-08', '2007080136', '00115', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-08', 'pending', '', 'diagnosis'), 
('137', '2020-07-08', '2007080137', '00116', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-07-08', 'pending', '', 'diagnosis'), 
('138', '2020-07-08', '2007080138', '00117', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-08', 'pending', '', 'diagnosis'), 
('139', '2020-07-08', '2007080139', '00118', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-07-08', 'pending', '', 'diagnosis'), 
('140', '2020-07-08', '2007080140', '00119', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-08', 'pending', '', 'diagnosis'), 
('141', '2020-07-08', '2007080141', '00120', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '300.00', 'Flat', '800.00', '800.00', '0.00', '800.00', '2020-07-08', 'pending', '', 'diagnosis'), 
('144', '2020-07-09', '2007090144', '00121', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '400.00', 'Flat', '1200.00', '700.00', '500.00', '700.00', '2020-07-09', 'pending', '', 'diagnosis'), 
('145', '2020-07-09', '2007090145', '00122', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2100.00', '100.00', 'Flat', '2000.00', '2000.00', '0.00', '2000.00', '2020-07-09', 'pending', '', 'diagnosis'), 
('146', '2020-07-09', '2007090146', '00123', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '200.00', 'Flat', '450.00', '450.00', '0.00', '450.00', '2020-07-09', 'pending', '', 'diagnosis'), 
('147', '2020-07-09', '2007090147', '00124', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2100.00', '400.00', 'Flat', '1700.00', '1000.00', '700.00', '1000.00', '2020-07-09', 'pending', '', 'diagnosis'), 
('149', '2020-07-09', '2007090148', '00126', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-07-09', 'pending', '', 'diagnosis'), 
('153', '2020-07-09', '2007090150', '00128', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-07-09', 'pending', '', 'diagnosis'), 
('154', '2020-07-09', '2007090154', '00129', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-07-09', 'pending', '', 'diagnosis'), 
('155', '2020-07-09', '2007090155', '00130', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-07-09', 'pending', '', 'diagnosis'), 
('156', '2020-07-09', '2007090156', '00131', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '250.00', 'Flat', '2000.00', '1000.00', '1000.00', '1000.00', '2020-07-09', 'pending', '', 'diagnosis'), 
('157', '2020-07-10', '2007100157', '00132', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('158', '2020-07-10', '2007100158', '00133', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('159', '2020-07-10', '2007100159', '00134', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('160', '2020-07-10', '2007100160', '00135', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('161', '2020-07-10', '2007100161', '00136', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('162', '2020-07-10', '2007100162', '00137', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '500.00', '-100.00', '500.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('163', '2020-07-10', '2007100163', '00138', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('164', '2020-07-10', '2007100164', '00139', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('165', '2020-07-10', '2007100165', '00140', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '250.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('166', '2020-07-10', '2007100166', '00141', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '600.00', 'Flat', '1100.00', '1100.00', '0.00', '1100.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('167', '2020-07-10', '2007100167', '00142', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('168', '2020-07-10', '2007100168', '00143', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('169', '2020-07-10', '2007100169', '00144', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('170', '2020-07-10', '2007100170', '00145', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '300.00', 'Flat', '750.00', '750.00', '0.00', '750.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('171', '2020-07-10', '2007100171', '00146', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '150.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('172', '2020-07-10', '2007100172', '00147', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('173', '2020-07-10', '2007100173', '00148', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '150.00', 'Flat', '1500.00', '1500.00', '0.00', '1500.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('174', '2020-07-10', '2007100174', '00149', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('175', '2020-07-10', '2007100175', '00150', 'diagnosis', 'diagnosis', '0.00', '0', '0.00', '0.00', '0.00', 'Flat', '0.00', '300.00', '0.00', '300.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('176', '2020-07-10', '2007100176', '00151', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '50.00', 'Flat', '1400.00', '1400.00', '0.00', '1400.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('177', '2020-07-10', '2007100177', '00152', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '400.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('178', '2020-07-10', '2007100178', '00153', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '200.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('179', '2020-07-10', '2007100179', '00154', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('180', '2020-07-10', '2007100180', '00155', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '100.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-10', 'pending', '', 'diagnosis'), 
('181', '2020-07-12', '2007120181', '00156', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-07-12', 'pending', '', 'diagnosis'), 
('182', '2020-07-12', '2007120182', '00157', 'diagnosis', 'diagnosis', '2600.00', '0', '0.00', '2600.00', '400.00', 'Flat', '2200.00', '2200.00', '0.00', '2200.00', '2020-07-12', 'pending', '', 'diagnosis'), 
('183', '2020-07-12', '2007120183', '00158', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-12', 'pending', '', 'diagnosis'), 
('184', '2020-07-12', '2007120184', '00159', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '430.00', 'Flat', '220.00', '220.00', '0.00', '220.00', '2020-07-12', 'pending', '', 'diagnosis'), 
('185', '2020-07-12', '2007120185', '00160', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-12', 'pending', '', 'diagnosis'), 
('186', '2020-07-12', '2007120186', '00161', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-07-12', 'pending', '', 'diagnosis'), 
('187', '2020-07-12', '2007120187', '00162', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '200.00', 'Flat', '450.00', '450.00', '0.00', '450.00', '2020-07-12', 'pending', '', 'diagnosis'), 
('188', '2020-07-12', '2007120188', '00163', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '400.00', 'Flat', '1100.00', '1100.00', '0.00', '1100.00', '2020-07-12', 'pending', '', 'diagnosis'), 
('189', '2020-07-12', '2007120189', '00164', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '350.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-07-12', 'pending', '', 'diagnosis'), 
('190', '2020-07-12', '2007120190', '00165', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '50.00', 'Flat', '1300.00', '1400.00', '-100.00', '1400.00', '2020-07-12', 'pending', '', 'diagnosis'), 
('191', '2020-07-12', '2007120191', '00166', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-12', 'pending', '', 'diagnosis'), 
('192', '2020-07-12', '2007120192', '00167', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-12', 'pending', '', 'diagnosis'), 
('193', '2020-07-12', '2007120193', '00168', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '50.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-07-12', 'pending', '', 'diagnosis'), 
('194', '2020-07-12', '2007120194', '00169', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-07-12', 'pending', '', 'diagnosis'), 
('195', '2020-07-12', '2007120195', '00170', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '200.00', 'Flat', '450.00', '450.00', '0.00', '450.00', '2020-07-12', 'pending', '', 'diagnosis'), 
('196', '2020-07-13', '2007130196', '00171', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('197', '2020-07-13', '2007130197', '00172', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '450.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('198', '2020-07-13', '2007130198', '00173', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '450.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('199', '2020-07-13', '2007130199', '00174', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '350.00', 'Flat', '1400.00', '1400.00', '0.00', '1400.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('200', '2020-07-13', '2007130200', '00175', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '30.00', 'Flat', '120.00', '120.00', '0.00', '120.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('201', '2020-07-13', '2007130201', '00176', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '100.00', 'Flat', '1100.00', '1100.00', '0.00', '1100.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('202', '2020-07-13', '2007130202', '00177', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('203', '2020-07-13', '2007130203', '00178', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '150.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('204', '2020-07-13', '2007130204', '00179', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('205', '2020-07-13', '2007130205', '00180', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '300.00', 'Flat', '1200.00', '1200.00', '0.00', '1200.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('206', '2020-07-13', '2007130206', '00181', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '450.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('207', '2020-07-13', '2007130207', '00182', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('208', '2020-07-13', '2007130208', '00183', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '450.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('209', '2020-07-13', '2007130209', '00184', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('210', '2020-07-13', '2007130210', '00185', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('211', '2020-07-13', '2007130211', '00186', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '500.00', 'Flat', '1200.00', '1200.00', '0.00', '1200.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('212', '2020-07-13', '2007130212', '00187', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '90.00', 'Flat', '60.00', '60.00', '0.00', '60.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('213', '2020-07-13', '2007130213', '00188', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '150.00', 'Flat', '1100.00', '1100.00', '0.00', '1100.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('214', '2020-07-13', '2007130214', '00189', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '250.00', 'Flat', '1500.00', '1500.00', '0.00', '1500.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('215', '2020-07-13', '2007130215', '00190', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '800.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('216', '2020-07-13', '2007130216', '00191', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '500.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('217', '2020-07-13', '2007130217', '00192', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('218', '2020-07-13', '2007130218', '00193', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '200.00', '50.00', '200.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('219', '2020-07-13', '2007130219', '00194', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('220', '2020-07-13', '2007130220', '00195', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '150.00', 'Flat', '800.00', '800.00', '0.00', '800.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('221', '2020-07-13', '2007130221', '00196', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-07-13', 'pending', '', 'diagnosis'), 
('223', '2020-07-14', '2007140223', '00198', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-14', 'pending', '', 'diagnosis'), 
('224', '2020-07-14', '2007140224', '00199', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-07-14', 'pending', '', 'diagnosis'), 
('225', '2020-07-14', '2007140225', '00200', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '50.00', 'Flat', '600.00', '350.00', '250.00', '350.00', '2020-07-14', 'pending', '', 'diagnosis'), 
('226', '2020-07-14', '2007140226', '00201', 'diagnosis', 'diagnosis', '2200.00', '0', '0.00', '2200.00', '500.00', 'Flat', '1700.00', '1700.00', '0.00', '1700.00', '2020-07-14', 'pending', '', 'diagnosis'), 
('227', '2020-07-14', '2007140227', '00202', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '250.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-07-14', 'pending', '', 'diagnosis'), 
('228', '2020-07-14', '2007140228', '00203', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-07-14', 'pending', '', 'diagnosis'), 
('231', '2020-07-14', '2007140231', '00206', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '350.00', 'Flat', '1900.00', '1900.00', '0.00', '1900.00', '2020-07-14', 'pending', '', 'diagnosis'), 
('232', '2020-07-14', '2007140232', '00207', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '200.00', 'Flat', '1750.00', '800.00', '950.00', '800.00', '2020-07-14', 'pending', '', 'diagnosis'), 
('234', '2020-07-14', '2007140233', '00209', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '500.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-14', 'pending', '', 'diagnosis'), 
('235', '2020-07-14', '2007140235', '00210', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-07-14', 'pending', '', 'diagnosis'), 
('239', '2020-07-15', '2007150236', '00214', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-15', 'pending', '', 'diagnosis'), 
('240', '2020-07-15', '2007150240', '00215', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-07-15', 'pending', '', 'diagnosis'), 
('241', '2020-07-15', '2007150241', '00216', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '70.00', 'Flat', '80.00', '80.00', '0.00', '80.00', '2020-07-15', 'pending', '', 'diagnosis'), 
('242', '2020-07-15', '2007150242', '00217', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '10.00', 'Flat', '140.00', '140.00', '0.00', '140.00', '2020-07-15', 'pending', '', 'diagnosis'), 
('243', '2020-07-15', '2007150243', '00218', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '200.00', 'Flat', '450.00', '450.00', '0.00', '450.00', '2020-07-15', 'pending', '', 'diagnosis'), 
('244', '2020-07-15', '2007150244', '00219', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-15', 'pending', '', 'diagnosis'), 
('245', '2020-07-15', '2007150245', '00220', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '301.00', 'Flat', '599.00', '600.00', '-1.00', '600.00', '2020-07-15', 'pending', '', 'diagnosis'), 
('246', '2020-07-15', '2007150246', '00221', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '50.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-07-15', 'pending', '', 'diagnosis'), 
('247', '2020-07-15', '2007150247', '00222', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '350.00', 'Flat', '1500.00', '1500.00', '0.00', '1500.00', '2020-07-15', 'pending', '', 'diagnosis'), 
('248', '2020-07-15', '2007150248', '00223', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '500.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-07-15', 'pending', '', 'diagnosis'), 
('249', '2020-07-16', '2007160249', '00224', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '250.00', 'Flat', '1100.00', '1100.00', '0.00', '1100.00', '2020-07-16', 'pending', '', 'diagnosis'), 
('250', '2020-07-16', '2007160250', '00225', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-07-16', 'pending', '', 'diagnosis'), 
('251', '2020-07-16', '2007160251', '00226', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '70.00', 'Flat', '80.00', '80.00', '0.00', '80.00', '2020-07-16', 'pending', '', 'diagnosis'), 
('252', '2020-07-16', '2007160252', '00227', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '0.00', 'Flat', '2250.00', '2300.00', '-50.00', '2300.00', '2020-07-16', 'pending', '', 'diagnosis'), 
('253', '2020-07-16', '2007160253', '00228', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '700.00', '2020-07-16', 'pending', '', 'diagnosis'), 
('254', '2020-07-16', '2007160254', '00229', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '300.00', 'Flat', '800.00', '800.00', '0.00', '800.00', '2020-07-16', 'pending', '', 'diagnosis'), 
('255', '2020-07-16', '2007160255', '00230', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-16', 'pending', '', 'diagnosis'), 
('256', '2020-07-16', '2007160256', '00231', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '100.00', 'Flat', '700.00', '700.00', '0.00', '700.00', '2020-07-16', 'pending', '', 'diagnosis'), 
('257', '2020-07-16', '2007160257', '00232', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '0.00', 'Flat', '700.00', '700.00', '0.00', '700.00', '2020-07-16', 'pending', '', 'diagnosis'), 
('258', '2020-07-16', '2007160258', '00233', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '50.00', 'Flat', '1300.00', '1300.00', '0.00', '1300.00', '2020-07-16', 'pending', '', 'diagnosis'), 
('259', '2020-07-16', '2007160259', '00234', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-16', 'pending', '', 'diagnosis'), 
('260', '2020-07-16', '2007160260', '00235', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '750.00', '150.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-07-16', 'pending', '', 'diagnosis'), 
('261', '2020-07-16', '2007160261', '00236', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-07-16', 'pending', '', 'diagnosis'), 
('262', '2020-07-16', '2007160262', '00237', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '400.00', 'Flat', '450.00', '450.00', '0.00', '450.00', '2020-07-16', 'pending', '', 'diagnosis'), 
('263', '2020-07-16', '2007160263', '00238', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-16', 'pending', '', 'diagnosis'), 
('264', '2020-07-16', '2007160264', '00239', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '300.00', 'Flat', '1300.00', '1300.00', '0.00', '1300.00', '2020-07-16', 'pending', '', 'diagnosis'), 
('265', '2020-07-16', '2007160265', '00240', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-07-16', 'pending', '', 'diagnosis'), 
('266', '2020-07-16', '2007160266', '00241', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '150.00', 'Flat', '800.00', '800.00', '0.00', '800.00', '2020-07-16', 'pending', '', 'diagnosis'), 
('267', '2020-07-16', '2007160267', '00242', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-16', 'pending', '', 'diagnosis'), 
('268', '2020-07-17', '2007170268', '00243', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-17', 'pending', '', 'diagnosis'), 
('269', '2020-07-17', '2007170269', '00244', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '450.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-17', 'pending', '', 'diagnosis'), 
('270', '2020-07-17', '2007170270', '0261', 'consultancy', '', '0.00', '0', '0.00', '300.00', '0.00', '', '300.00', '300.00', '0.00', '300.00', '2020-07-17', 'pending', '', ''), 
('271', '2020-07-17', '2007170271', '00245', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-17', 'pending', '', 'diagnosis'), 
('272', '2020-07-17', '2007170272', '00246', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-07-17', 'pending', '', 'diagnosis'), 
('273', '2020-07-17', '2007170273', '00247', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '700.00', 'Flat', '1100.00', '1100.00', '0.00', '1100.00', '2020-07-17', 'pending', '', 'diagnosis'), 
('275', '2020-07-17', '2007170275', '00249', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '750.00', 'Flat', '1250.00', '1250.00', '0.00', '1250.00', '2020-07-17', 'pending', '', 'diagnosis'), 
('276', '2020-07-17', '2007170276', '00250', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '450.00', 'Flat', '1800.00', '1800.00', '0.00', '1800.00', '2020-07-17', 'pending', '', 'diagnosis'), 
('277', '2020-07-17', '2007170277', '00251', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '50.00', 'Flat', '1400.00', '1400.00', '0.00', '1400.00', '2020-07-17', 'pending', '', 'diagnosis'), 
('278', '2020-07-17', '2007170278', '00252', 'diagnosis', 'diagnosis', '2400.00', '0', '0.00', '2400.00', '500.00', 'Flat', '1900.00', '1900.00', '0.00', '1900.00', '2020-07-17', 'pending', '', 'diagnosis'), 
('279', '2020-07-17', '2007170279', '00253', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-17', 'pending', '', 'diagnosis'), 
('280', '2020-07-17', '2007170280', '00254', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '110.00', 'Flat', '40.00', '40.00', '0.00', '40.00', '2020-07-17', 'pending', '', 'diagnosis'), 
('281', '2020-07-17', '2007170281', '00255', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '200.00', 'Flat', '1400.00', '1400.00', '0.00', '1400.00', '2020-07-17', 'pending', '', 'diagnosis'), 
('282', '2020-07-18', '2007180282', '00256', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-18', 'pending', '', 'diagnosis'), 
('283', '2020-07-18', '2007180283', '00257', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '250.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-07-18', 'pending', '', 'diagnosis'), 
('284', '2020-07-18', '2007180284', '00258', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-07-18', 'pending', '', 'diagnosis'), 
('285', '2020-07-18', '2007180285', '00259', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-18', 'pending', '', 'diagnosis'), 
('286', '2020-07-18', '2007180286', '00260', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '800.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-18', 'pending', '', 'diagnosis'), 
('287', '2020-07-18', '2007180287', '00261', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '430.00', 'Flat', '220.00', '220.00', '0.00', '220.00', '2020-07-18', 'pending', '', 'diagnosis'), 
('288', '2020-07-18', '2007180288', '00262', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '350.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-18', 'pending', '', 'diagnosis'), 
('289', '2020-07-18', '2007180289', '00263', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-07-18', 'pending', '', 'diagnosis'), 
('290', '2020-07-18', '2007180290', '0281', 'consultancy', '', '0.00', '0', '0.00', '400.00', '0.00', '', '400.00', '400.00', '0.00', '400.00', '2020-07-18', 'pending', '', ''), 
('291', '2020-07-18', '2007180291', '0281', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '600.00', '600.00', '600.00', '2020-07-18', 'pending', '', 'diagnosis'), 
('292', '2020-07-18', '2007180292', '0283', 'consultancy', '', '0.00', '0', '0.00', '400.00', '0.00', '', '400.00', '400.00', '0.00', '400.00', '2020-07-18', 'pending', '', ''), 
('293', '2020-07-18', '2007180293', '00264', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-07-18', 'pending', '', 'diagnosis'), 
('295', '2020-07-19', '2007190295', '00266', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-07-19', 'pending', '', 'diagnosis'), 
('296', '2020-07-19', '2007190296', '00267', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-07-19', 'pending', '', 'diagnosis'), 
('297', '2020-07-19', '2007190297', '00268', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-07-19', 'pending', '', 'diagnosis'), 
('298', '2020-07-19', '2007190298', '00269', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '550.00', 'Flat', '1100.00', '1100.00', '0.00', '1100.00', '2020-07-19', 'pending', '', 'diagnosis'), 
('299', '2020-07-19', '2007190299', '00270', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '25.00', 'Flat', '125.00', '125.00', '0.00', '125.00', '2020-07-19', 'pending', '', 'diagnosis'), 
('300', '2020-07-19', '2007190300', '00271', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '25.00', 'Flat', '125.00', '125.00', '0.00', '125.00', '2020-07-19', 'pending', '', 'diagnosis'), 
('301', '2020-07-19', '2007190301', '00272', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '430.00', 'Flat', '220.00', '220.00', '0.00', '220.00', '2020-07-19', 'pending', '', 'diagnosis'), 
('302', '2020-07-19', '2007190302', '00273', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-19', 'pending', '', 'diagnosis'), 
('303', '2020-07-19', '2007190303', '00274', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-07-19', 'pending', '', 'diagnosis'), 
('304', '2020-07-19', '2007190304', '0295', 'consultancy', '', '0.00', '0', '0.00', '300.00', '0.00', '', '300.00', '300.00', '0.00', '300.00', '2020-07-19', 'pending', '', ''), 
('305', '2020-07-19', '2007190305', '00275', 'diagnosis', 'diagnosis', '2300.00', '0', '0.00', '2300.00', '300.00', 'Flat', '2000.00', '1000.00', '1000.00', '1000.00', '2020-07-19', 'pending', '', 'diagnosis'), 
('306', '2020-07-19', '2007190306', '00276', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '450.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-19', 'pending', '', 'diagnosis'), 
('307', '2020-07-19', '2007190307', '00277', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-19', 'pending', '', 'diagnosis'), 
('308', '2020-07-19', '2007190308', '00278', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-07-19', 'pending', '', 'diagnosis'), 
('309', '2020-07-19', '2007190309', '00279', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-19', 'pending', '', 'diagnosis'), 
('310', '2020-07-19', '2007190310', '00280', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '660.00', 'Flat', '340.00', '340.00', '0.00', '340.00', '2020-07-19', 'pending', '', 'diagnosis'), 
('311', '2020-07-19', '2007190311', '00281', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '350.00', 'Flat', '1900.00', '1900.00', '0.00', '1900.00', '2020-07-19', 'pending', '', 'diagnosis'), 
('312', '2020-07-19', '2007190312', '00282', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '500.00', 'Flat', '1100.00', '1100.00', '0.00', '1100.00', '2020-07-19', 'pending', '', 'diagnosis'), 
('313', '2020-07-19', '2007190313', '00283', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-07-19', 'pending', '', 'diagnosis'), 
('314', '2020-07-19', '2007190314', '00284', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '430.00', 'Flat', '220.00', '220.00', '0.00', '220.00', '2020-07-19', 'pending', '', 'diagnosis'), 
('315', '2020-07-19', '2007190315', '00285', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '600.00', 'Flat', '900.00', '500.00', '400.00', '500.00', '2020-07-19', 'pending', '', 'diagnosis'), 
('316', '2020-07-20', '2007200316', '00286', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-20', 'pending', '', 'diagnosis'), 
('317', '2020-07-20', '2007200317', '00287', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-07-20', 'pending', '', 'diagnosis'), 
('318', '2020-07-20', '2007200318', '00288', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-20', 'pending', '', 'diagnosis'), 
('319', '2020-07-20', '2007200319', '00289', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2500.00', '500.00', 'Flat', '2000.00', '1400.00', '600.00', '1400.00', '2020-07-20', 'pending', '', 'diagnosis'), 
('320', '2020-07-20', '2007200320', '00290', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-07-20', 'pending', '', 'diagnosis'), 
('321', '2020-07-20', '2007200321', '00291', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '3.00', 'Flat', '797.00', '500.00', '297.00', '500.00', '2020-07-20', 'pending', '', 'diagnosis'), 
('322', '2020-07-20', '2007200322', '00292', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-20', 'pending', '', 'diagnosis'), 
('325', '2020-07-20', '2007200323', '00295', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '5.00', 'Percentage', '380.00', '380.00', '0.00', '200.00', '2020-07-20', 'pending', '', 'diagnosis'), 
('326', '2020-07-20', '2007200326', '00296', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '50.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-07-20', 'pending', '', 'diagnosis'), 
('331', '2020-07-21', '2007210328', '00298', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '650.00', 'Flat', '550.00', '550.00', '0.00', '550.00', '2020-07-21', 'pending', '', 'diagnosis'), 
('332', '2020-07-21', '2007210332', '00299', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2450.00', '450.00', 'Flat', '2000.00', '2000.00', '0.00', '2000.00', '2020-07-21', 'pending', '', 'diagnosis'), 
('333', '2020-07-21', '2007210333', '00300', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-07-21', 'pending', '', 'diagnosis'), 
('334', '2020-07-21', '2007210334', '00301', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-21', 'pending', '', 'diagnosis'), 
('335', '2020-07-21', '2007210335', '00302', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-07-21', 'pending', '', 'diagnosis'), 
('336', '2020-07-21', '2007210336', '0327', 'consultancy', '', '0.00', '0', '0.00', '300.00', '100.00', '', '200.00', '200.00', '0.00', '200.00', '2020-07-21', 'pending', '', ''), 
('337', '2020-07-21', '2007210337', '00303', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-07-21', 'pending', '', 'diagnosis'), 
('338', '2020-07-21', '2007210338', '0329', 'consultancy', '', '0.00', '0', '0.00', '300.00', '0.00', '', '300.00', '300.00', '0.00', '300.00', '2020-07-21', 'pending', '', ''), 
('339', '2020-07-21', '2007210339', '0327', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '800.00', '0.00', '800.00', '2020-07-21', 'pending', '', 'diagnosis'), 
('340', '2020-07-21', '2007210340', '00304', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '700.00', '2020-07-21', 'pending', '', 'diagnosis'), 
('341', '2020-07-21', '2007210341', '00305', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-21', 'pending', '', 'diagnosis'), 
('342', '2020-07-22', '2007220342', '00306', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '350.00', '50.00', '50.00', '2020-07-22', 'pending', '', 'diagnosis'), 
('344', '2020-07-22', '2007220344', '00308', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-07-22', 'pending', '', 'diagnosis'), 
('345', '2020-07-22', '2007220345', '0336', 'consultancy', '', '0.00', '0', '0.00', '250.00', '0.00', '', '250.00', '250.00', '0.00', '250.00', '2020-07-22', 'pending', '', ''), 
('346', '2020-07-22', '2007220346', '00309', 'diagnosis', 'diagnosis', '2800.00', '0', '0.00', '2800.00', '0.00', 'Flat', '2800.00', '1204.00', '1596.00', '1204.00', '2020-07-22', 'pending', '', 'diagnosis'), 
('347', '2020-07-22', '2007220347', '00310', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '0.00', 'Flat', '1100.00', '200.00', '900.00', '200.00', '2020-07-22', 'pending', '', 'diagnosis'), 
('348', '2020-07-22', '2007220348', '00311', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-07-22', 'pending', '', 'diagnosis'), 
('349', '2020-07-22', '2007220349', '00312', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-22', 'pending', '', 'diagnosis'), 
('350', '2020-07-22', '2007220350', '00313', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-07-22', 'pending', '', 'diagnosis'), 
('351', '2020-07-22', '2007220351', '00314', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '100.00', 'Flat', '1100.00', '1000.00', '100.00', '1000.00', '2020-07-22', 'pending', '', 'diagnosis'), 
('352', '2020-07-22', '2007220352', '00315', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '100.00', 'Flat', '1400.00', '700.00', '700.00', '700.00', '2020-07-22', 'pending', '', 'diagnosis'), 
('353', '2020-07-22', '2007220353', '00316', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '0.00', 'Flat', '1250.00', '1000.00', '250.00', '1000.00', '2020-07-22', 'pending', '', 'diagnosis'), 
('358', '2020-07-22', '2007220358', '00319', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-07-22', 'pending', '', 'diagnosis'), 
('359', '2020-07-23', '2007230359', '00320', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-23', 'pending', '', 'diagnosis'), 
('361', '2020-07-23', '2007230361', '0352', 'consultancy', '', '0.00', '0', '0.00', '300.00', '0.00', '', '300.00', '300.00', '0.00', '300.00', '2020-07-23', 'pending', '', ''), 
('362', '2020-07-23', '2007230362', '0353', 'consultancy', '', '0.00', '0', '0.00', '300.00', '0.00', '', '300.00', '300.00', '0.00', '300.00', '2020-07-23', 'pending', '', ''), 
('363', '2020-07-23', '2007230363', '0352', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '400.00', 'Flat', '1500.00', '1500.00', '0.00', '1500.00', '2020-07-23', 'pending', '', 'diagnosis'), 
('364', '2020-07-23', '2007230364', '0355', 'consultancy', '', '0.00', '0', '0.00', '300.00', '100.00', '', '200.00', '200.00', '0.00', '200.00', '2020-07-23', 'pending', '', ''), 
('365', '2020-07-23', '2007230365', '0356', 'consultancy', '', '0.00', '0', '0.00', '300.00', '100.00', '', '200.00', '200.00', '0.00', '200.00', '2020-07-23', 'pending', '', ''), 
('366', '2020-07-23', '2007230366', '0357', 'consultancy', '', '0.00', '0', '0.00', '300.00', '100.00', '', '200.00', '200.00', '0.00', '200.00', '2020-07-23', 'pending', '', ''), 
('367', '2020-07-23', '2007230367', '0358', 'consultancy', '', '0.00', '0', '0.00', '300.00', '0.00', '', '300.00', '300.00', '0.00', '300.00', '2020-07-23', 'pending', '', ''), 
('368', '2020-07-23', '2007230368', '0353', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '350.00', 'Flat', '1400.00', '1400.00', '0.00', '1400.00', '2020-07-23', 'pending', '', 'diagnosis'), 
('369', '2020-07-23', '2007230369', '0358', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2100.00', '200.00', 'Flat', '1900.00', '1900.00', '0.00', '1900.00', '2020-07-23', 'pending', '', 'diagnosis'), 
('370', '2020-07-23', '2007230370', '0361', 'consultancy', '', '0.00', '0', '0.00', '500.00', '100.00', '', '400.00', '400.00', '0.00', '400.00', '2020-07-23', 'pending', '', ''), 
('371', '2020-07-23', '2007230371', '00321', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-23', 'pending', '', 'diagnosis'), 
('372', '2020-07-23', '2007230372', '0363', 'consultancy', '', '0.00', '0', '0.00', '300.00', '100.00', '', '200.00', '200.00', '0.00', '200.00', '2020-07-23', 'pending', '', ''), 
('373', '2020-07-23', '2007230373', '0363', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-23', 'pending', '', 'diagnosis'), 
('374', '2020-07-23', '2007230374', '0365', 'consultancy', '', '0.00', '0', '0.00', '0.00', '0.00', '', '0.00', '0.00', '0.00', '0.00', '2020-07-23', 'pending', '', ''), 
('375', '2020-07-23', '2007230374', '0365', 'consultancy', '', '0.00', '0', '0.00', '0.00', '0.00', '', '0.00', '0.00', '0.00', '0.00', '2020-07-23', 'pending', '', ''), 
('376', '2020-07-23', '2007230376', '0366', 'consultancy', '', '0.00', '0', '0.00', '500.00', '0.00', '', '500.00', '500.00', '0.00', '500.00', '2020-07-23', 'pending', '', ''), 
('377', '2020-07-23', '2007230377', '0367', 'consultancy', '', '0.00', '0', '0.00', '500.00', '0.00', '', '500.00', '500.00', '0.00', '500.00', '2020-07-23', 'pending', '', ''), 
('378', '2020-07-23', '2007230378', '0368', 'consultancy', '', '0.00', '0', '0.00', '500.00', '0.00', '', '500.00', '500.00', '0.00', '500.00', '2020-07-23', 'pending', '', ''), 
('380', '2020-07-23', '2007230379', '0368', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-23', 'pending', '', 'diagnosis'), 
('381', '2020-07-23', '2007230381', '0366', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '100.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-07-23', 'pending', '', 'diagnosis'), 
('382', '2020-07-23', '2007230382', '00322', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-07-23', 'pending', '', 'diagnosis'), 
('383', '2020-07-23', '2007230383', '00323', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '50.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-07-23', 'pending', '', 'diagnosis'), 
('384', '2020-07-23', '2007230384', '00324', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '3.00', 'Flat', '647.00', '350.00', '297.00', '350.00', '2020-07-23', 'pending', '', 'diagnosis'), 
('385', '2020-07-24', '2007240385', '00325', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '550.00', 'Flat', '700.00', '700.00', '0.00', '700.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('386', '2020-07-24', '2007240386', '00326', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '10.00', 'Flat', '140.00', '140.00', '0.00', '140.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('387', '2020-07-24', '2007240387', '00327', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2500.00', '100.00', 'Flat', '2400.00', '2400.00', '0.00', '1000.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('388', '2020-07-24', '2007240388', '00328', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('389', '2020-07-24', '2007240389', '00329', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '150.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('390', '2020-07-24', '2007240390', '00330', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '500.00', 'Flat', '700.00', '700.00', '0.00', '200.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('391', '2020-07-24', '2007240391', '00331', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '500.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('392', '2020-07-24', '2007240392', '00332', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '100.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('393', '2020-07-24', '2007240393', '00333', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('394', '2020-07-24', '2007240394', '00334', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('395', '2020-07-24', '2007240395', '00335', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '100.00', 'Flat', '1600.00', '1600.00', '0.00', '1600.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('396', '2020-07-24', '2007240396', '00336', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '50.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('397', '2020-07-24', '2007240397', '00337', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('398', '2020-07-24', '2007240398', '00338', 'diagnosis', 'diagnosis', '2300.00', '0', '0.00', '2300.00', '300.00', 'Flat', '2000.00', '2000.00', '0.00', '2000.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('399', '2020-07-24', '2007240399', '00339', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('400', '2020-07-24', '2007240400', '00340', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('401', '2020-07-24', '2007240401', '00341', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('402', '2020-07-24', '2007240402', '00342', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('403', '2020-07-24', '2007240403', '00343', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('404', '2020-07-24', '2007240404', '00344', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('405', '2020-07-24', '2007240405', '00345', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('406', '2020-07-24', '2007240406', '00346', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('407', '2020-07-24', '2007240407', '00347', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('408', '2020-07-24', '2007240408', '00348', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('409', '2020-07-24', '2007240409', '00349', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('410', '2020-07-24', '2007240410', '00350', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '700.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('411', '2020-07-24', '2007240411', '00351', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('412', '2020-07-24', '2007240412', '00352', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '100.00', 'Flat', '700.00', '700.00', '0.00', '700.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('413', '2020-07-24', '2007240413', '00353', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('414', '2020-07-24', '2007240414', '00354', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('415', '2020-07-24', '2007240415', '00355', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '250.00', 'Flat', '1700.00', '1700.00', '0.00', '1700.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('416', '2020-07-24', '2007240416', '00356', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '200.00', 'Flat', '450.00', '450.00', '0.00', '450.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('417', '2020-07-24', '2007240417', '00357', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '150.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('418', '2020-07-24', '2007240418', '00358', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-24', 'pending', '', 'diagnosis'), 
('419', '2020-07-25', '2007250419', '00359', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-07-25', 'pending', '', 'diagnosis'), 
('420', '2020-07-25', '2007250420', '00360', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-07-25', 'pending', '', 'diagnosis'), 
('421', '2020-07-25', '2007250421', '00361', 'diagnosis', 'diagnosis', '3200.00', '0', '0.00', '3200.00', '1400.00', 'Flat', '1800.00', '1800.00', '0.00', '2500.00', '2020-07-25', 'pending', '', 'diagnosis'), 
('422', '2020-07-25', '2007250422', '00362', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-25', 'pending', '', 'diagnosis'), 
('423', '2020-07-25', '2007250423', '00363', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '100.00', 'Flat', '700.00', '700.00', '0.00', '700.00', '2020-07-25', 'pending', '', 'diagnosis'), 
('424', '2020-07-25', '2007250424', '00364', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-25', 'pending', '', 'diagnosis'), 
('425', '2020-07-25', '2007250425', '0366', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '0.00', 'Flat', '700.00', '700.00', '0.00', '500.00', '2020-07-25', 'pending', '', 'diagnosis'), 
('426', '2020-07-25', '2007250426', '00365', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-25', 'pending', '', 'diagnosis'), 
('427', '2020-07-25', '2007250427', '00366', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '200.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-07-25', 'pending', '', 'diagnosis'), 
('428', '2020-07-25', '2007250428', '00367', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '50.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-07-25', 'pending', '', 'diagnosis'), 
('429', '2020-07-25', '2007250429', '00368', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '50.00', 'Flat', '900.00', '900.00', '0.00', '900.00', '2020-07-25', 'pending', '', 'diagnosis'), 
('430', '2020-07-25', '2007250430', '00369', 'diagnosis', 'diagnosis', '2800.00', '0', '0.00', '2800.00', '800.00', 'Flat', '2000.00', '2000.00', '0.00', '200.00', '2020-07-25', 'pending', '', 'diagnosis'), 
('431', '2020-07-25', '2007250431', '00370', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '400.00', 'Flat', '1600.00', '1600.00', '0.00', '1600.00', '2020-07-25', 'pending', '', 'diagnosis'), 
('432', '2020-07-25', '2007250432', '00371', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-25', 'pending', '', 'diagnosis'), 
('433', '2020-07-25', '2007250433', '00372', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-25', 'pending', '', 'diagnosis'), 
('434', '2020-07-25', '2007250434', '00373', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '100.00', 'Flat', '1500.00', '1500.00', '0.00', '1500.00', '2020-07-25', 'pending', '', 'diagnosis'), 
('435', '2020-07-26', '2007260435', '00374', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-07-26', 'pending', '', 'diagnosis'), 
('436', '2020-07-26', '2007260436', '00375', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '350.00', 'Flat', '1400.00', '1400.00', '0.00', '1400.00', '2020-07-26', 'pending', '', 'diagnosis'), 
('438', '2020-07-26', '2007260437', '00377', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-07-26', 'pending', '', 'diagnosis'), 
('439', '2020-07-26', '2007260439', '00378', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-26', 'pending', '', 'diagnosis'), 
('440', '2020-07-26', '2007260440', '00379', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-07-26', 'pending', '', 'diagnosis'), 
('441', '2020-07-26', '2007260441', '00380', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '450.00', 'Flat', '1300.00', '1300.00', '0.00', '500.00', '2020-07-26', 'pending', '', 'diagnosis'), 
('442', '2020-07-26', '2007260442', '00381', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-07-26', 'pending', '', 'diagnosis'), 
('443', '2020-07-26', '2007260443', '00382', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-26', 'pending', '', 'diagnosis'), 
('444', '2020-07-26', '2007260444', '00383', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-07-26', 'pending', '', 'diagnosis'), 
('445', '2020-07-26', '2007260445', '00384', 'diagnosis', 'diagnosis', '2600.00', '0', '0.00', '2600.00', '400.00', 'Flat', '2200.00', '2200.00', '0.00', '2000.00', '2020-07-26', 'pending', '', 'diagnosis'), 
('446', '2020-07-26', '2007260446', '00385', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '400.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-26', 'pending', '', 'diagnosis'), 
('447', '2020-07-26', '2007260447', '00386', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '100.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-07-26', 'pending', '', 'diagnosis'), 
('448', '2020-07-26', '2007260448', '00387', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-07-26', 'pending', '', 'diagnosis'), 
('449', '2020-07-26', '2007260449', '00388', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '3.00', '247.00', '3.00', '2020-07-26', 'pending', '', 'diagnosis'), 
('450', '2020-07-26', '2007260450', '00389', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-26', 'pending', '', 'diagnosis'), 
('451', '2020-07-27', '2007270451', '00390', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '250.00', 'Flat', '1100.00', '1100.00', '0.00', '1100.00', '2020-07-27', 'pending', '', 'diagnosis'), 
('452', '2020-07-27', '2007270452', '00391', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '450.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-07-27', 'pending', '', 'diagnosis'), 
('453', '2020-07-27', '2007270453', '00392', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-27', 'pending', '', 'diagnosis'), 
('454', '2020-07-27', '2007270454', '00393', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-07-27', 'pending', '', 'diagnosis'), 
('455', '2020-07-28', '2007280455', '00394', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '80.00', 'Flat', '70.00', '70.00', '0.00', '70.00', '2020-07-28', 'pending', '', 'diagnosis'), 
('456', '2020-07-28', '2007280456', '00395', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-07-28', 'pending', '', 'diagnosis'), 
('457', '2020-07-28', '2007280457', '00396', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-07-28', 'pending', '', 'diagnosis'), 
('458', '2020-07-28', '2007280458', '00397', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-07-28', 'pending', '', 'diagnosis'), 
('459', '2020-07-28', '2007280459', '00398', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '430.00', 'Flat', '220.00', '220.00', '0.00', '220.00', '2020-07-28', 'pending', '', 'diagnosis'), 
('460', '2020-07-28', '2007280460', '00399', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-28', 'pending', '', 'diagnosis'), 
('461', '2020-07-28', '2007280461', '00400', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-07-28', 'pending', '', 'diagnosis'), 
('462', '2020-07-28', '2007280462', '00401', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-28', 'pending', '', 'diagnosis'), 
('463', '2020-07-28', '2007280463', '00402', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '800.00', 'Flat', '800.00', '800.00', '0.00', '800.00', '2020-07-28', 'pending', '', 'diagnosis'), 
('464', '2020-07-28', '2007280464', '00403', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '300.00', 'Flat', '800.00', '800.00', '0.00', '800.00', '2020-07-28', 'pending', '', 'diagnosis'), 
('465', '2020-07-28', '2007280465', '00404', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-28', 'pending', '', 'diagnosis'), 
('466', '2020-07-28', '2007280466', '00405', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-28', 'pending', '', 'diagnosis'), 
('467', '2020-07-28', '2007280467', '00406', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-28', 'pending', '', 'diagnosis'), 
('468', '2020-07-28', '2007280468', '00407', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '400.00', 'Flat', '450.00', '450.00', '0.00', '450.00', '2020-07-28', 'pending', '', 'diagnosis'), 
('469', '2020-07-28', '2007280469', '00408', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '450.00', 'Flat', '800.00', '800.00', '0.00', '800.00', '2020-07-28', 'pending', '', 'diagnosis'), 
('470', '2020-07-29', '2007290470', '00409', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '150.00', 'Flat', '1800.00', '1800.00', '0.00', '1800.00', '2020-07-29', 'pending', '', 'diagnosis'), 
('471', '2020-07-29', '2007290471', '00410', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-07-29', 'pending', '', 'diagnosis'), 
('472', '2020-07-29', '2007290472', '00411', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '600.00', 'Flat', '1200.00', '1200.00', '0.00', '1200.00', '2020-07-29', 'pending', '', 'diagnosis'), 
('473', '2020-07-29', '2007290473', '00412', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-07-29', 'pending', '', 'diagnosis'), 
('474', '2020-07-29', '2007290474', '00413', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-07-29', 'pending', '', 'diagnosis'), 
('475', '2020-07-29', '2007290475', '00414', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-29', 'pending', '', 'diagnosis'), 
('476', '2020-07-29', '2007290476', '00415', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '700.00', '2020-07-29', 'pending', '', 'diagnosis'), 
('477', '2020-07-29', '2007290477', '00416', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '100.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-07-29', 'pending', '', 'diagnosis'), 
('478', '2020-07-29', '2007290478', '00417', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '450.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-29', 'pending', '', 'diagnosis'), 
('479', '2020-07-30', '2007300479', '00418', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-30', 'pending', '', 'diagnosis'), 
('480', '2020-07-30', '2007300480', '00419', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '500.00', 'Flat', '1500.00', '1500.00', '0.00', '1500.00', '2020-07-30', 'pending', '', 'diagnosis'), 
('481', '2020-07-30', '2007300481', '00420', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-07-30', 'pending', '', 'diagnosis'), 
('482', '2020-07-30', '2007300482', '00421', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-07-30', 'pending', '', 'diagnosis'), 
('483', '2020-07-30', '2007300483', '00422', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '250.00', 'Flat', '1800.00', '1500.00', '300.00', '500.00', '2020-07-30', 'pending', '', 'diagnosis'), 
('484', '2020-07-30', '2007300484', '00423', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '20.00', 'Flat', '230.00', '230.00', '0.00', '230.00', '2020-07-30', 'pending', '', 'diagnosis'), 
('485', '2020-07-30', '2007300485', '00424', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-07-30', 'pending', '', 'diagnosis'), 
('486', '2020-07-30', '2007300486', '00425', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-07-30', 'pending', '', 'diagnosis'), 
('487', '2020-07-31', '2007310487', '00426', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '250.00', 'Flat', '1200.00', '1200.00', '0.00', '1200.00', '2020-07-31', 'pending', '', 'diagnosis'), 
('488', '2020-07-31', '2007310488', '00427', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-07-31', 'pending', '', 'diagnosis'), 
('489', '2020-07-31', '2007310489', '00428', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '600.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-07-31', 'pending', '', 'diagnosis'), 
('490', '2020-07-31', '2007310490', '00429', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-07-31', 'pending', '', 'diagnosis'), 
('491', '2020-07-31', '2007310491', '00430', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '150.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-07-31', 'pending', '', 'diagnosis'), 
('492', '2020-07-31', '2007310492', '00431', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-07-31', 'pending', '', 'diagnosis'), 
('493', '2020-07-31', '2007310493', '00432', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '350.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-07-31', 'pending', '', 'diagnosis'), 
('494', '2020-07-31', '2007310494', '00433', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-07-31', 'pending', '', 'diagnosis'), 
('495', '2020-07-31', '2007310495', '00434', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '650.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-07-31', 'pending', '', 'diagnosis'), 
('496', '2020-07-31', '2007310496', '00435', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-07-31', 'pending', '', 'diagnosis'), 
('497', '2020-07-31', '2007310497', '00436', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-07-31', 'pending', '', 'diagnosis'), 
('498', '2020-08-03', '2008030498', '00437', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '700.00', 'Flat', '900.00', '900.00', '0.00', '900.00', '2020-08-03', 'pending', '', 'diagnosis'), 
('499', '2020-08-03', '2008030499', '00438', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '500.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-08-03', 'pending', '', 'diagnosis'), 
('500', '2020-08-03', '2008030500', '00439', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-03', 'pending', '', 'diagnosis'), 
('501', '2020-08-03', '2008030501', '00440', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-03', 'pending', '', 'diagnosis'), 
('502', '2020-08-03', '2008030502', '00441', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-03', 'pending', '', 'diagnosis'), 
('503', '2020-08-03', '2008030503', '00442', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-08-03', 'pending', '', 'diagnosis'), 
('504', '2020-08-03', '2008030504', '00443', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '350.00', 'Flat', '1100.00', '1100.00', '0.00', '1100.00', '2020-08-03', 'pending', '', 'diagnosis'), 
('505', '2020-08-03', '2008030505', '00444', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '500.00', 'Flat', '1300.00', '1000.00', '300.00', '1000.00', '2020-08-03', 'pending', '', 'diagnosis'), 
('506', '2020-08-03', '2008030506', '00445', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '250.00', 'Flat', '1600.00', '1600.00', '0.00', '1600.00', '2020-08-03', 'pending', '', 'diagnosis'), 
('507', '2020-08-03', '2008030507', '00446', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '300.00', 'Flat', '1400.00', '1400.00', '0.00', '1400.00', '2020-08-03', 'pending', '', 'diagnosis'), 
('508', '2020-08-03', '2008030508', '00447', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2450.00', '450.00', 'Flat', '2000.00', '2000.00', '0.00', '2000.00', '2020-08-03', 'pending', '', 'diagnosis'), 
('509', '2020-08-04', '2008040509', '00448', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '70.00', 'Flat', '80.00', '80.00', '0.00', '80.00', '2020-08-04', 'pending', '', 'diagnosis'), 
('510', '2020-08-04', '2008040510', '00449', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '500.00', 'Flat', '1100.00', '1100.00', '0.00', '1100.00', '2020-08-04', 'pending', '', 'diagnosis'), 
('511', '2020-08-04', '2008040511', '00450', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '450.00', 'Flat', '1200.00', '1200.00', '0.00', '1200.00', '2020-08-04', 'pending', '', 'diagnosis'), 
('512', '2020-08-04', '2008040512', '00451', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '300.00', 'Flat', '900.00', '900.00', '0.00', '900.00', '2020-08-04', 'pending', '', 'diagnosis'), 
('513', '2020-08-04', '2008040513', '00452', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-04', 'pending', '', 'diagnosis'), 
('514', '2020-08-04', '2008040514', '00453', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-04', 'pending', '', 'diagnosis'), 
('515', '2020-08-04', '2008040515', '00454', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-08-04', 'pending', '', 'diagnosis'), 
('516', '2020-08-04', '2008040516', '00455', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '0.00', 'Flat', '1750.00', '800.00', '950.00', '800.00', '2020-08-04', 'pending', '', 'diagnosis'), 
('517', '2020-08-04', '2008040517', '00456', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '300.00', 'Flat', '1200.00', '1200.00', '0.00', '1200.00', '2020-08-04', 'pending', '', 'diagnosis'), 
('518', '2020-08-04', '2008040518', '00457', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-04', 'pending', '', 'diagnosis'), 
('519', '2020-08-04', '2008040519', '00458', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '550.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-04', 'pending', '', 'diagnosis'), 
('520', '2020-08-04', '2008040520', '00459', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-08-04', 'pending', '', 'diagnosis'), 
('521', '2020-08-04', '2008040521', '00460', 'diagnosis', 'diagnosis', '2350.00', '0', '0.00', '2350.00', '350.00', 'Flat', '2000.00', '2000.00', '0.00', '2000.00', '2020-08-04', 'pending', '', 'diagnosis'), 
('522', '2020-08-04', '2008040522', '00461', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '210.00', 'Flat', '440.00', '440.00', '0.00', '440.00', '2020-08-04', 'pending', '', 'diagnosis'), 
('523', '2020-08-05', '2008050523', '00462', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '350.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-08-05', 'pending', '', 'diagnosis'), 
('524', '2020-08-05', '2008050524', '00463', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-08-05', 'pending', '', 'diagnosis'), 
('525', '2020-08-05', '2008050525', '00464', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-08-05', 'pending', '', 'diagnosis'), 
('526', '2020-08-05', '2008050526', '00465', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '550.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-08-05', 'pending', '', 'diagnosis'), 
('527', '2020-08-05', '2008050527', '00466', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-08-05', 'pending', '', 'diagnosis'), 
('528', '2020-08-05', '2008050528', '00467', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '100.00', 'Flat', '1200.00', '1200.00', '0.00', '1200.00', '2020-08-05', 'pending', '', 'diagnosis'), 
('529', '2020-08-05', '2008050529', '00468', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '400.00', 'Flat', '1200.00', '1200.00', '0.00', '1200.00', '2020-08-05', 'pending', '', 'diagnosis'), 
('530', '2020-08-05', '2008050530', '00469', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-05', 'pending', '', 'diagnosis'), 
('531', '2020-08-05', '2008050531', '00470', 'diagnosis', 'diagnosis', '2750.00', '0', '0.00', '2750.00', '250.00', 'Flat', '2500.00', '2500.00', '0.00', '2500.00', '2020-08-05', 'pending', '', 'diagnosis'), 
('532', '2020-08-05', '2008050532', '00471', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '200.00', 'Flat', '1500.00', '1500.00', '0.00', '1500.00', '2020-08-05', 'pending', '', 'diagnosis'), 
('533', '2020-08-05', '2008050533', '00472', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-05', 'pending', '', 'diagnosis'), 
('534', '2020-08-05', '2008050534', '00473', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-05', 'pending', '', 'diagnosis'), 
('535', '2020-08-05', '2008050535', '00474', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '450.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-05', 'pending', '', 'diagnosis'), 
('536', '2020-08-05', '2008050536', '00475', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '500.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-05', 'pending', '', 'diagnosis'), 
('537', '2020-08-05', '2008050537', '00476', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-08-05', 'pending', '', 'diagnosis'), 
('538', '2020-08-05', '2008050538', '00477', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '450.00', 'Flat', '1100.00', '1100.00', '0.00', '1100.00', '2020-08-05', 'pending', '', 'diagnosis'), 
('539', '2020-08-05', '2008050539', '00478', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '650.00', 'Flat', '900.00', '900.00', '0.00', '600.00', '2020-08-05', 'pending', '', 'diagnosis'), 
('540', '2020-08-05', '2008050540', '00479', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '100.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-08-05', 'pending', '', 'diagnosis'), 
('541', '2020-08-05', '2008050541', '00480', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-08-05', 'pending', '', 'diagnosis'), 
('542', '2020-08-06', '2008060542', '00481', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '150.00', '150.00', '150.00', '2020-08-06', 'pending', '', 'diagnosis'), 
('543', '2020-08-06', '2008060543', '00482', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '50.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-06', 'pending', '', 'diagnosis'), 
('544', '2020-08-06', '2008060544', '00483', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-06', 'pending', '', 'diagnosis'), 
('545', '2020-08-06', '2008060545', '00484', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-06', 'pending', '', 'diagnosis'), 
('546', '2020-08-06', '2008060546', '00485', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '350.00', 'Flat', '1300.00', '1300.00', '0.00', '1300.00', '2020-08-06', 'pending', '', 'diagnosis'), 
('547', '2020-08-06', '2008060547', '00486', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-06', 'pending', '', 'diagnosis'), 
('548', '2020-08-06', '2008060548', '00487', 'diagnosis', 'diagnosis', '2600.00', '0', '0.00', '2600.00', '400.00', 'Flat', '2200.00', '2000.00', '200.00', '1000.00', '2020-08-06', 'pending', '', 'diagnosis'), 
('549', '2020-08-06', '2008060549', '00488', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '450.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-06', 'pending', '', 'diagnosis'), 
('550', '2020-08-06', '2008060550', '00489', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '700.00', 'Flat', '900.00', '900.00', '0.00', '1000.00', '2020-08-06', 'pending', '', 'diagnosis'), 
('551', '2020-08-06', '2008060551', '00490', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-06', 'pending', '', 'diagnosis'), 
('552', '2020-08-06', '2008060552', '00491', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-06', 'pending', '', 'diagnosis'), 
('553', '2020-08-06', '2008060553', '00492', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-06', 'pending', '', 'diagnosis'), 
('554', '2020-08-06', '2008060554', '00493', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-06', 'pending', '', 'diagnosis'), 
('555', '2020-08-06', '2008060555', '00494', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-08-06', 'pending', '', 'diagnosis'), 
('556', '2020-08-06', '2008060556', '00495', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '350.00', 'Flat', '1450.00', '1150.00', '300.00', '1150.00', '2020-08-06', 'pending', '', 'diagnosis'), 
('557', '2020-08-06', '2008060557', '00496', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '250.00', 'Flat', '950.00', '950.00', '0.00', '950.00', '2020-08-06', 'pending', '', 'diagnosis'), 
('558', '2020-08-06', '2008060558', '00497', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-06', 'pending', '', 'diagnosis'), 
('559', '2020-08-06', '2008060559', '00498', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '0.00', 'Flat', '1100.00', '50.00', '1050.00', '50.00', '2020-08-06', 'pending', '', 'diagnosis'), 
('561', '2020-08-07', '2008070561', '00500', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('562', '2020-08-07', '2008070562', '00501', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('563', '2020-08-07', '2008070563', '00502', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('564', '2020-08-07', '2008070564', '00503', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('565', '2020-08-07', '2008070565', '00504', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('566', '2020-08-07', '2008070566', '00505', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('567', '2020-08-07', '2008070567', '00506', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('568', '2020-08-07', '2008070568', '00507', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '50.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('569', '2020-08-07', '2008070569', '00508', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('570', '2020-08-07', '2008070570', '00509', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '450.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('571', '2020-08-07', '2008070571', '00510', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '50.00', 'Flat', '1600.00', '1600.00', '0.00', '1600.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('572', '2020-08-07', '2008070572', '00511', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('573', '2020-08-07', '2008070573', '00512', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('574', '2020-08-07', '2008070574', '00513', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('575', '2020-08-07', '2008070575', '00514', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('576', '2020-08-07', '2008070576', '00515', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '250.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('577', '2020-08-07', '2008070577', '00516', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('578', '2020-08-07', '2008070578', '00517', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '450.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('579', '2020-08-07', '2008070579', '00518', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '1000.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('580', '2020-08-07', '2008070580', '00519', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '100.00', '450.00', '100.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('581', '2020-08-07', '2008070581', '00520', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('582', '2020-08-07', '2008070582', '00521', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('583', '2020-08-07', '2008070583', '00522', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('584', '2020-08-07', '2008070584', '00523', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('585', '2020-08-07', '2008070585', '00524', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '100.00', 'Flat', '150.00', '150.00', '0.00', '200.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('586', '2020-08-07', '2008070586', '00525', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '350.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('587', '2020-08-07', '2008070587', '00526', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '850.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('588', '2020-08-07', '2008070588', '00527', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('589', '2020-08-07', '2008070589', '00528', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('590', '2020-08-07', '2008070590', '00529', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '150.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('591', '2020-08-07', '2008070591', '00530', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('592', '2020-08-07', '2008070592', '00531', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '350.00', 'Flat', '800.00', '800.00', '0.00', '800.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('593', '2020-08-07', '2008070593', '00532', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '150.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('594', '2020-08-07', '2008070594', '00533', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-07', 'pending', '', 'diagnosis'), 
('595', '2020-08-08', '2008080595', '00534', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-08', 'pending', '', 'diagnosis'), 
('596', '2020-08-08', '2008080596', '00535', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-08', 'pending', '', 'diagnosis'), 
('597', '2020-08-08', '2008080597', '00536', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '200.00', 'Flat', '900.00', '900.00', '0.00', '900.00', '2020-08-08', 'pending', '', 'diagnosis'), 
('598', '2020-08-08', '2008080598', '00537', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-08-08', 'pending', '', 'diagnosis'), 
('599', '2020-08-08', '2008080599', '00538', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-08', 'pending', '', 'diagnosis'), 
('600', '2020-08-08', '2008080600', '00539', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-08-08', 'pending', '', 'diagnosis'), 
('601', '2020-08-08', '2008080601', '00540', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '400.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-08-08', 'pending', '', 'diagnosis'), 
('602', '2020-08-08', '2008080602', '00541', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '200.00', '2020-08-08', 'pending', '', 'diagnosis'), 
('603', '2020-08-08', '2008080603', '00542', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-08', 'pending', '', 'diagnosis'), 
('604', '2020-08-08', '2008080604', '00543', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-08', 'pending', '', 'diagnosis'), 
('605', '2020-08-08', '2008080605', '00544', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '200.00', '2020-08-08', 'pending', '', 'diagnosis'), 
('606', '2020-08-08', '2008080606', '00545', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '300.00', '2020-08-08', 'pending', '', 'diagnosis'), 
('607', '2020-08-08', '2008080607', '00546', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-08', 'pending', '', 'diagnosis'), 
('608', '2020-08-08', '2008080608', '00547', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-08', 'pending', '', 'diagnosis'), 
('609', '2020-08-08', '2008080609', '00548', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '450.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-08', 'pending', '', 'diagnosis'), 
('611', '2020-08-09', '2008090610', '00550', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '650.00', 'Flat', '700.00', '700.00', '0.00', '700.00', '2020-08-09', 'pending', '', 'diagnosis'), 
('612', '2020-08-09', '2008090612', '00551', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '650.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-08-09', 'pending', '', 'diagnosis'), 
('613', '2020-08-09', '2008090613', '00552', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-08-09', 'pending', '', 'diagnosis'), 
('614', '2020-08-09', '2008090614', '00553', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '100.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-08-09', 'pending', '', 'diagnosis'), 
('615', '2020-08-09', '2008090615', '00554', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '300.00', '2020-08-09', 'pending', '', 'diagnosis'), 
('616', '2020-08-09', '2008090616', '00555', 'diagnosis', 'diagnosis', '2350.00', '0', '0.00', '2350.00', '350.00', 'Flat', '2000.00', '2000.00', '0.00', '2000.00', '2020-08-09', 'pending', '', 'diagnosis'), 
('617', '2020-08-09', '2008090617', '00556', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '500.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-09', 'pending', '', 'diagnosis'), 
('618', '2020-08-09', '2008090618', '00557', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '350.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-09', 'pending', '', 'diagnosis'), 
('619', '2020-08-09', '2008090619', '00558', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '70.00', 'Flat', '80.00', '80.00', '0.00', '80.00', '2020-08-09', 'pending', '', 'diagnosis'), 
('620', '2020-08-09', '2008090620', '00559', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '200.00', 'Flat', '650.00', '650.00', '0.00', '650.00', '2020-08-09', 'pending', '', 'diagnosis'), 
('621', '2020-08-09', '2008090621', '00560', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '300.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-09', 'pending', '', 'diagnosis'), 
('622', '2020-08-09', '2008090622', '00561', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '150.00', 'Flat', '800.00', '800.00', '0.00', '800.00', '2020-08-09', 'pending', '', 'diagnosis'), 
('623', '2020-08-09', '2008090623', '00562', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '700.00', 'Flat', '550.00', '550.00', '0.00', '700.00', '2020-08-09', 'pending', '', 'diagnosis'), 
('624', '2020-08-09', '2008090624', '00563', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '350.00', 'Flat', '1600.00', '1600.00', '0.00', '1600.00', '2020-08-09', 'pending', '', 'diagnosis'), 
('625', '2020-08-09', '2008090625', '00564', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-09', 'pending', '', 'diagnosis'), 
('626', '2020-08-09', '2008090626', '00565', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-09', 'pending', '', 'diagnosis'), 
('627', '2020-08-09', '2008090627', '00566', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-09', 'pending', '', 'diagnosis'), 
('628', '2020-08-09', '2008090628', '00567', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '150.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-08-09', 'pending', '', 'diagnosis'), 
('629', '2020-08-09', '2008090629', '00568', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '250.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-08-09', 'pending', '', 'diagnosis'), 
('630', '2020-08-09', '2008090630', '00569', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-09', 'pending', '', 'diagnosis'), 
('631', '2020-08-09', '2008090631', '00570', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-09', 'pending', '', 'diagnosis'), 
('632', '2020-08-10', '2008100632', '00571', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '30.00', 'Flat', '120.00', '120.00', '0.00', '120.00', '2020-08-10', 'pending', '', 'diagnosis'), 
('633', '2020-08-10', '2008100633', '00572', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-10', 'pending', '', 'diagnosis'), 
('634', '2020-08-10', '2008100634', '00573', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-10', 'pending', '', 'diagnosis'), 
('635', '2020-08-10', '2008100635', '00574', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-10', 'pending', '', 'diagnosis'), 
('636', '2020-08-10', '2008100636', '00575', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-08-10', 'pending', '', 'diagnosis'), 
('637', '2020-08-10', '2008100637', '00576', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-10', 'pending', '', 'diagnosis'), 
('638', '2020-08-10', '2008100638', '00577', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '200.00', 'Flat', '1600.00', '1600.00', '0.00', '1600.00', '2020-08-10', 'pending', '', 'diagnosis'), 
('639', '2020-08-10', '2008100639', '00578', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-10', 'pending', '', 'diagnosis'), 
('640', '2020-08-10', '2008100640', '00579', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-08-10', 'pending', '', 'diagnosis'), 
('641', '2020-08-10', '2008100641', '00580', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '1000.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-10', 'pending', '', 'diagnosis'), 
('642', '2020-08-11', '2008110642', '00581', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-11', 'pending', '', 'diagnosis'), 
('643', '2020-08-11', '2008110643', '00582', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-11', 'pending', '', 'diagnosis'), 
('644', '2020-08-11', '2008110644', '00583', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-11', 'pending', '', 'diagnosis'), 
('645', '2020-08-11', '2008110645', '00584', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '200.00', 'Flat', '450.00', '450.00', '0.00', '450.00', '2020-08-11', 'pending', '', 'diagnosis'), 
('646', '2020-08-11', '2008110646', '00585', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-08-11', 'pending', '', 'diagnosis'), 
('647', '2020-08-11', '2008110647', '00586', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '150.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-08-11', 'pending', '', 'diagnosis'), 
('648', '2020-08-11', '2008110648', '00587', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '150.00', 'Flat', '1400.00', '1400.00', '0.00', '200.00', '2020-08-11', 'pending', '', 'diagnosis'), 
('649', '2020-08-11', '2008110649', '00588', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-11', 'pending', '', 'diagnosis'), 
('650', '2020-08-11', '2008110650', '00589', 'diagnosis', 'diagnosis', '2300.00', '0', '0.00', '2300.00', '800.00', 'Flat', '1500.00', '1500.00', '0.00', '800.00', '2020-08-11', 'pending', '', 'diagnosis'), 
('651', '2020-08-11', '2008110651', '00590', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-11', 'pending', '', 'diagnosis'), 
('652', '2020-08-11', '2008110652', '00591', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '500.00', 'Flat', '1500.00', '1500.00', '0.00', '1500.00', '2020-08-11', 'pending', '', 'diagnosis'), 
('653', '2020-08-11', '2008110653', '00592', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '50.00', 'Flat', '800.00', '800.00', '0.00', '800.00', '2020-08-11', 'pending', '', 'diagnosis'), 
('654', '2020-08-11', '2008110654', '00593', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '250.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-08-11', 'pending', '', 'diagnosis'), 
('655', '2020-08-11', '2008110655', '00594', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '400.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-08-11', 'pending', '', 'diagnosis'), 
('656', '2020-08-11', '2008110656', '00595', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-11', 'pending', '', 'diagnosis'), 
('657', '2020-08-11', '2008110657', '00596', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2450.00', '650.00', 'Flat', '1800.00', '1800.00', '0.00', '1000.00', '2020-08-11', 'pending', '', 'diagnosis'), 
('658', '2020-08-11', '2008110658', '00597', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '150.00', '2020-08-11', 'pending', '', 'diagnosis'), 
('659', '2020-08-11', '2008110659', '00598', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '200.00', 'Flat', '1500.00', '1500.00', '0.00', '500.00', '2020-08-11', 'pending', '', 'diagnosis'), 
('660', '2020-08-12', '2008120660', '00599', 'diagnosis', 'diagnosis', '2350.00', '0', '0.00', '2350.00', '350.00', 'Flat', '2000.00', '2000.00', '0.00', '2000.00', '2020-08-12', 'pending', '', 'diagnosis'), 
('661', '2020-08-12', '2008120661', '00600', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-12', 'pending', '', 'diagnosis'), 
('662', '2020-08-12', '2008120662', '00601', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-08-12', 'pending', '', 'diagnosis'), 
('663', '2020-08-12', '2008120663', '00602', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-08-12', 'pending', '', 'diagnosis'), 
('664', '2020-08-12', '2008120664', '00603', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '300.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-08-12', 'pending', '', 'diagnosis'), 
('665', '2020-08-12', '2008120665', '00604', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-12', 'pending', '', 'diagnosis'), 
('666', '2020-08-12', '2008120666', '00605', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-12', 'pending', '', 'diagnosis'), 
('667', '2020-08-12', '2008120667', '00606', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1300.00', '1300.00', '0.00', '100.00', '2020-08-12', 'pending', '', 'diagnosis'), 
('668', '2020-08-12', '2008120668', '00607', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-12', 'pending', '', 'diagnosis'), 
('669', '2020-08-13', '2008130669', '00608', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-13', 'pending', '', 'diagnosis'), 
('670', '2020-08-13', '2008130670', '00609', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-08-13', 'pending', '', 'diagnosis'), 
('671', '2020-08-13', '2008130671', '00610', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '100.00', 'Flat', '450.00', '450.00', '0.00', '450.00', '2020-08-13', 'pending', '', 'diagnosis'), 
('672', '2020-08-13', '2008130672', '00611', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-13', 'pending', '', 'diagnosis'), 
('673', '2020-08-13', '2008130673', '00612', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '550.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-13', 'pending', '', 'diagnosis'), 
('674', '2020-08-13', '2008130674', '00613', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-08-13', 'pending', '', 'diagnosis'), 
('675', '2020-08-13', '2008130675', '00614', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-13', 'pending', '', 'diagnosis'), 
('676', '2020-08-13', '2008130676', '00615', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-08-13', 'pending', '', 'diagnosis'), 
('677', '2020-08-13', '2008130677', '00616', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-13', 'pending', '', 'diagnosis'), 
('678', '2020-08-13', '2008130678', '00617', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-13', 'pending', '', 'diagnosis'), 
('679', '2020-08-13', '2008130678', '00617', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '500.00', '2020-08-13', 'pending', '', 'diagnosis'), 
('680', '2020-08-13', '2008130680', '00618', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2100.00', '500.00', 'Flat', '1600.00', '1600.00', '0.00', '1600.00', '2020-08-13', 'pending', '', 'diagnosis'), 
('681', '2020-08-13', '2008130681', '00619', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-13', 'pending', '', 'diagnosis'), 
('682', '2020-08-13', '2008130682', '00620', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-08-13', 'pending', '', 'diagnosis'), 
('683', '2020-08-13', '2008130683', '00621', 'diagnosis', 'diagnosis', '2200.00', '0', '0.00', '2200.00', '200.00', 'Flat', '2000.00', '2000.00', '0.00', '2000.00', '2020-08-13', 'pending', '', 'diagnosis'), 
('684', '2020-08-14', '2008140684', '00622', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '250.00', 'Flat', '1800.00', '1800.00', '0.00', '1800.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('685', '2020-08-14', '2008140685', '00623', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('686', '2020-08-14', '2008140686', '00624', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '0.00', 'Flat', '1500.00', '1500.00', '0.00', '1500.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('687', '2020-08-14', '2008140687', '00625', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '800.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('688', '2020-08-14', '2008140688', '00626', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '750.00', '350.00', 'Flat', '400.00', '400.00', '0.00', '200.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('689', '2020-08-14', '2008140689', '00627', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '300.00', 'Flat', '1200.00', '1200.00', '0.00', '1200.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('690', '2020-08-14', '2008140690', '00628', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('691', '2020-08-14', '2008140691', '00629', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('692', '2020-08-14', '2008140692', '00630', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('693', '2020-08-14', '2008140693', '00631', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '750.00', '500.00', 'Flat', '250.00', '250.00', '0.00', '500.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('694', '2020-08-14', '2008140694', '00632', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('695', '2020-08-14', '2008140695', '00633', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('696', '2020-08-14', '2008140696', '00634', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('697', '2020-08-14', '2008140697', '00635', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('698', '2020-08-14', '2008140698', '00636', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '800.00', 'Flat', '900.00', '900.00', '0.00', '500.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('699', '2020-08-14', '2008140699', '00637', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('700', '2020-08-14', '2008140700', '00638', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('701', '2020-08-14', '2008140701', '00639', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('702', '2020-08-14', '2008140702', '00640', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('703', '2020-08-14', '2008140703', '00641', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2100.00', '500.00', 'Flat', '1600.00', '1600.00', '0.00', '1600.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('705', '2020-08-14', '2008140704', '00643', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '800.00', 'Flat', '900.00', '900.00', '0.00', '900.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('706', '2020-08-14', '2008140706', '00644', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '150.00', 'Flat', '900.00', '900.00', '0.00', '900.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('707', '2020-08-14', '2008140707', '00645', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('708', '2020-08-14', '2008140708', '00646', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '200.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('709', '2020-08-14', '2008140709', '00647', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '0.00', '250.00', '0.00', '250.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('710', '2020-08-14', '2008140710', '00648', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('711', '2020-08-14', '2008140711', '00649', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '300.00', 'Flat', '1000.00', '1000.00', '0.00', '100.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('712', '2020-08-14', '2008140712', '00650', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('713', '2020-08-14', '2008140713', '00651', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '800.00', '2020-08-14', 'pending', '', 'diagnosis'), 
('714', '2020-08-15', '2008150714', '00652', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-15', 'pending', '', 'diagnosis'), 
('715', '2020-08-15', '2008150715', '00653', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-15', 'pending', '', 'diagnosis'), 
('716', '2020-08-15', '2008150716', '00654', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-15', 'pending', '', 'diagnosis'), 
('717', '2020-08-15', '2008150717', '00655', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-15', 'pending', '', 'diagnosis'), 
('718', '2020-08-15', '2008150718', '00656', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '500.00', 'Flat', '1500.00', '1500.00', '0.00', '500.00', '2020-08-15', 'pending', '', 'diagnosis'), 
('719', '2020-08-15', '2008150719', '00657', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '250.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-08-15', 'pending', '', 'diagnosis'), 
('720', '2020-08-15', '2008150720', '00658', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-08-15', 'pending', '', 'diagnosis'), 
('721', '2020-08-15', '2008150721', '00659', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '200.00', 'Flat', '1700.00', '1700.00', '0.00', '1700.00', '2020-08-15', 'pending', '', 'diagnosis'), 
('722', '2020-08-15', '2008150722', '00660', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '300.00', 'Flat', '1700.00', '1700.00', '0.00', '1700.00', '2020-08-15', 'pending', '', 'diagnosis'), 
('723', '2020-08-15', '2008150723', '00661', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-15', 'pending', '', 'diagnosis'), 
('724', '2020-08-15', '2008150724', '00662', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '650.00', 'Flat', '1400.00', '1400.00', '0.00', '1400.00', '2020-08-15', 'pending', '', 'diagnosis'), 
('725', '2020-08-15', '2008150725', '00663', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '700.00', '2020-08-15', 'pending', '', 'diagnosis'), 
('726', '2020-08-15', '2008150726', '00664', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '400.00', 'Flat', '1350.00', '1350.00', '0.00', '1350.00', '2020-08-15', 'pending', '', 'diagnosis'), 
('727', '2020-08-15', '2008150727', '00665', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '350.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-15', 'pending', '', 'diagnosis'), 
('728', '2020-08-15', '2008150728', '00666', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-15', 'pending', '', 'diagnosis'), 
('729', '2020-08-15', '2008150729', '00667', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-15', 'pending', '', 'diagnosis'), 
('730', '2020-08-15', '2008150730', '00668', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '600.00', 'Flat', '1100.00', '1100.00', '0.00', '500.00', '2020-08-15', 'pending', '', 'diagnosis'), 
('731', '2020-08-15', '2008150731', '00669', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '150.00', 'Flat', '900.00', '900.00', '0.00', '900.00', '2020-08-15', 'pending', '', 'diagnosis'), 
('732', '2020-08-16', '2008160732', '00670', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '300.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-08-16', 'pending', '', 'diagnosis'), 
('733', '2020-08-16', '2008160733', '00671', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-16', 'pending', '', 'diagnosis'), 
('734', '2020-08-16', '2008160734', '00672', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '350.00', 'Flat', '1200.00', '1200.00', '0.00', '1200.00', '2020-08-16', 'pending', '', 'diagnosis'), 
('735', '2020-08-16', '2008160735', '00673', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-16', 'pending', '', 'diagnosis'), 
('736', '2020-08-16', '2008160736', '00674', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-16', 'pending', '', 'diagnosis'), 
('737', '2020-08-16', '2008160737', '00675', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-08-16', 'pending', '', 'diagnosis'), 
('738', '2020-08-16', '2008160738', '00676', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '300.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-16', 'pending', '', 'diagnosis'), 
('739', '2020-08-16', '2008160739', '00677', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-08-16', 'pending', '', 'diagnosis'), 
('740', '2020-08-16', '2008160740', '00678', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-08-16', 'pending', '', 'diagnosis'), 
('741', '2020-08-16', '2008160741', '00679', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '30.00', 'Flat', '120.00', '120.00', '0.00', '120.00', '2020-08-16', 'pending', '', 'diagnosis'), 
('742', '2020-08-16', '2008160742', '00680', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2100.00', '650.00', 'Flat', '1450.00', '1450.00', '0.00', '1500.00', '2020-08-16', 'pending', '', 'diagnosis'), 
('743', '2020-08-16', '2008160743', '00681', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-16', 'pending', '', 'diagnosis'), 
('744', '2020-08-16', '2008160744', '00682', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-16', 'pending', '', 'diagnosis'), 
('745', '2020-08-17', '2008170745', '00683', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '200.00', 'Flat', '850.00', '850.00', '0.00', '850.00', '2020-08-17', 'pending', '', 'diagnosis'), 
('746', '2020-08-17', '2008170746', '00684', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-17', 'pending', '', 'diagnosis'), 
('747', '2020-08-17', '2008170747', '00685', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-08-17', 'pending', '', 'diagnosis'), 
('748', '2020-08-17', '2008170748', '00686', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '500.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-17', 'pending', '', 'diagnosis'), 
('749', '2020-08-17', '2008170749', '00687', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-17', 'pending', '', 'diagnosis'), 
('750', '2020-08-17', '2008170750', '00688', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '200.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-17', 'pending', '', 'diagnosis'), 
('751', '2020-08-17', '2008170751', '00689', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '850.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-17', 'pending', '', 'diagnosis'), 
('752', '2020-08-17', '2008170752', '00690', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-08-17', 'pending', '', 'diagnosis'), 
('753', '2020-08-17', '2008170753', '00691', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '500.00', 'Flat', '700.00', '700.00', '0.00', '100.00', '2020-08-17', 'pending', '', 'diagnosis'), 
('754', '2020-08-17', '2008170754', '00692', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-08-17', 'pending', '', 'diagnosis'), 
('755', '2020-08-17', '2008170755', '00693', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-17', 'pending', '', 'diagnosis'), 
('756', '2020-08-17', '2008170756', '00694', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-08-17', 'pending', '', 'diagnosis'), 
('757', '2020-08-17', '2008170757', '00695', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-17', 'pending', '', 'diagnosis'), 
('758', '2020-08-17', '2008170758', '00696', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '800.00', '2020-08-17', 'pending', '', 'diagnosis'), 
('759', '2020-08-18', '2008180759', '00697', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-18', 'pending', '', 'diagnosis'), 
('760', '2020-08-18', '2008180760', '00698', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-18', 'pending', '', 'diagnosis'), 
('761', '2020-08-18', '2008180761', '00699', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '0.00', 'Flat', '1650.00', '1000.00', '650.00', '1000.00', '2020-08-18', 'pending', '', 'diagnosis'), 
('762', '2020-08-18', '2008180762', '00700', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '350.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-18', 'pending', '', 'diagnosis'), 
('763', '2020-08-18', '2008180763', '00701', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '450.00', 'Flat', '1200.00', '1200.00', '0.00', '1200.00', '2020-08-18', 'pending', '', 'diagnosis'), 
('764', '2020-08-18', '2008180764', '00702', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-18', 'pending', '', 'diagnosis'), 
('765', '2020-08-18', '2008180765', '00703', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '90.00', 'Flat', '60.00', '60.00', '0.00', '60.00', '2020-08-18', 'pending', '', 'diagnosis'), 
('766', '2020-08-18', '2008180766', '00704', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-18', 'pending', '', 'diagnosis'), 
('767', '2020-08-18', '2008180767', '00705', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '200.00', 'Flat', '450.00', '450.00', '0.00', '450.00', '2020-08-18', 'pending', '', 'diagnosis'), 
('768', '2020-08-18', '2008180768', '00706', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '700.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-08-18', 'pending', '', 'diagnosis'), 
('769', '2020-08-18', '2008180769', '00707', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-18', 'pending', '', 'diagnosis'), 
('770', '2020-08-18', '2008180770', '00708', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-18', 'pending', '', 'diagnosis'), 
('771', '2020-08-19', '2008190771', '00709', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('772', '2020-08-19', '2008190772', '00710', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('773', '2020-08-19', '2008190773', '00711', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '350.00', 'Flat', '1400.00', '1400.00', '0.00', '1400.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('774', '2020-08-19', '2008190774', '00712', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('775', '2020-08-19', '2008190775', '00713', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('776', '2020-08-19', '2008190776', '00714', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('777', '2020-08-19', '2008190777', '00715', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '300.00', 'Flat', '550.00', '400.00', '150.00', '400.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('778', '2020-08-19', '2008190778', '00716', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('779', '2020-08-19', '2008190779', '00717', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '350.00', 'Flat', '200.00', '200.00', '0.00', '400.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('780', '2020-08-19', '2008190780', '00718', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('781', '2020-08-19', '2008190781', '00719', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('782', '2020-08-19', '2008190782', '00720', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('783', '2020-08-19', '2008190783', '00721', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '600.00', 'Flat', '1200.00', '600.00', '600.00', '500.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('784', '2020-08-19', '2008190784', '00722', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '350.00', 'Flat', '1500.00', '1500.00', '0.00', '1500.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('785', '2020-08-19', '2008190785', '00723', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '50.00', 'Flat', '1300.00', '1300.00', '0.00', '1300.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('786', '2020-08-19', '2008190786', '00724', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '250.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('787', '2020-08-19', '2008190787', '00725', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '550.00', 'Flat', '800.00', '800.00', '0.00', '800.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('788', '2020-08-19', '2008190788', '00726', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '0.00', 'Flat', '1150.00', '100.00', '1050.00', '100.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('789', '2020-08-19', '2008190789', '00727', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '250.00', 'Flat', '1200.00', '1200.00', '0.00', '1200.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('790', '2020-08-19', '2008190790', '00728', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('791', '2020-08-19', '2008190791', '00729', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '150.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('792', '2020-08-19', '2008190792', '00730', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '450.00', 'Flat', '1500.00', '1500.00', '0.00', '1500.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('793', '2020-08-19', '2008190793', '00731', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '0.00', 'Flat', '700.00', '10.00', '690.00', '10.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('794', '2020-08-19', '2008190794', '00732', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '200.00', '200.00', '200.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('795', '2020-08-19', '2008190795', '00733', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '200.00', '50.00', '200.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('796', '2020-08-19', '2008190796', '00734', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-19', 'pending', '', 'diagnosis'), 
('797', '2020-08-20', '2008200797', '00735', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-08-20', 'pending', '', 'diagnosis'), 
('798', '2020-08-20', '2008200798', '00736', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-20', 'pending', '', 'diagnosis'), 
('799', '2020-08-20', '2008200799', '00737', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-20', 'pending', '', 'diagnosis'), 
('800', '2020-02-03', '2008200800', '00738', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '150.00', 'Flat', '700.00', '700.00', '0.00', '700.00', '2020-02-03', 'pending', '', 'diagnosis'), 
('801', '2020-08-20', '2008200801', '00739', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-08-20', 'pending', '', 'diagnosis'), 
('802', '2020-08-20', '2008200802', '00740', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '250.00', 'Flat', '1100.00', '1100.00', '0.00', '1100.00', '2020-08-20', 'pending', '', 'diagnosis'), 
('803', '2020-08-20', '2008200803', '00741', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-20', 'pending', '', 'diagnosis'), 
('804', '2020-08-20', '2008200804', '00742', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-08-20', 'pending', '', 'diagnosis'), 
('805', '2020-08-20', '2008200805', '00743', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-20', 'pending', '', 'diagnosis'), 
('806', '2020-08-20', '2008200806', '00744', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '250.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-08-20', 'pending', '', 'diagnosis'), 
('807', '2020-08-20', '2008200807', '00745', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '250.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-08-20', 'pending', '', 'diagnosis'), 
('808', '2020-08-21', '2008210808', '00746', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('809', '2020-08-21', '2008210809', '00747', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('810', '2020-08-21', '2008210810', '00748', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '700.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('811', '2020-08-21', '2008210811', '00749', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('812', '2020-08-21', '2008210812', '00750', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('813', '2020-08-21', '2008210813', '00751', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('814', '2020-08-21', '2008210814', '00752', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '50.00', '50.00', '50.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('815', '2020-08-21', '2008210815', '00753', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('816', '2020-08-21', '2008210816', '00754', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '150.00', 'Flat', '800.00', '800.00', '0.00', '800.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('817', '2020-08-21', '2008210817', '00755', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('818', '2020-08-21', '2008210818', '00756', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '250.00', 'Flat', '1500.00', '1500.00', '0.00', '1000.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('819', '2020-08-21', '2008210819', '00757', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '100.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('820', '2020-08-21', '2008210820', '00758', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '200.00', 'Flat', '1100.00', '1100.00', '0.00', '1100.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('821', '2020-08-21', '2008210821', '00759', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('822', '2020-08-21', '2008210822', '00760', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('823', '2020-08-21', '2008210823', '00761', 'diagnosis', 'diagnosis', '2350.00', '0', '0.00', '2350.00', '350.00', 'Flat', '2000.00', '2000.00', '0.00', '500.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('824', '2020-08-21', '2008210824', '00762', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '750.00', '250.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('825', '2020-08-21', '2008210825', '00763', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('826', '2020-08-21', '2008210826', '00764', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('827', '2020-08-21', '2008210827', '00765', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '50.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('828', '2020-08-21', '2008210828', '00766', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '400.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('829', '2020-08-21', '2008210829', '00767', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '550.00', 'Flat', '700.00', '700.00', '0.00', '500.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('830', '2020-08-21', '2008210830', '00768', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '100.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('831', '2020-08-21', '2008210831', '00769', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '350.00', '300.00', '350.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('832', '2020-08-21', '2008210832', '00770', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '700.00', 'Flat', '700.00', '700.00', '0.00', '700.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('833', '2020-08-21', '2008210833', '00771', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('834', '2020-08-21', '2008210834', '00772', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('835', '2020-08-21', '2008210835', '00773', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('837', '2020-08-21', '2008210837', '00775', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '250.00', 'Flat', '1000.00', '1000.00', '0.00', '500.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('838', '2020-08-21', '2008210838', '00776', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('839', '2020-08-21', '2008210839', '00777', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('840', '2020-08-21', '2008210840', '00778', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '350.00', 'Flat', '700.00', '700.00', '0.00', '700.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('841', '2020-08-21', '2008210841', '00779', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '100.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('842', '2020-08-21', '2008210842', '00780', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '350.00', 'Flat', '1100.00', '1100.00', '0.00', '1100.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('843', '2020-08-21', '2008210843', '00781', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '360.00', '290.00', '360.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('844', '2020-08-21', '2008210844', '00782', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '200.00', 'Flat', '1400.00', '1400.00', '0.00', '1400.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('845', '2020-08-21', '2008210845', '00783', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '200.00', 'Flat', '900.00', '900.00', '0.00', '300.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('846', '2020-08-21', '2008210846', '00784', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-21', 'pending', '', 'diagnosis'), 
('847', '2020-08-22', '2008220847', '00785', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-22', 'pending', '', 'diagnosis'), 
('848', '2020-08-22', '2008220848', '00786', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-22', 'pending', '', 'diagnosis'), 
('849', '2020-08-22', '2008220849', '00787', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-22', 'pending', '', 'diagnosis'), 
('850', '2020-08-22', '2008220850', '00788', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '0.00', 'Flat', '1750.00', '1000.00', '750.00', '1000.00', '2020-08-22', 'pending', '', 'diagnosis'), 
('851', '2020-08-22', '2008220851', '00789', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '500.00', 'Flat', '1200.00', '1200.00', '0.00', '1200.00', '2020-08-22', 'pending', '', 'diagnosis'), 
('852', '2020-08-22', '2008220852', '00790', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '550.00', 'Flat', '1400.00', '1400.00', '0.00', '600.00', '2020-08-22', 'pending', '', 'diagnosis'), 
('853', '2020-08-22', '2008220853', '00791', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '750.00', 'Flat', '900.00', '900.00', '0.00', '900.00', '2020-08-22', 'pending', '', 'diagnosis'), 
('854', '2020-08-22', '2008220854', '00792', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '300.00', 'Flat', '900.00', '900.00', '0.00', '900.00', '2020-08-22', 'pending', '', 'diagnosis'), 
('855', '2020-08-22', '2008220855', '00793', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '600.00', 'Flat', '1100.00', '1200.00', '0.00', '1100.00', '2020-08-22', 'pending', '', 'diagnosis'), 
('856', '2020-08-22', '2008220856', '00794', 'diagnosis', 'diagnosis', '2350.00', '0', '0.00', '2350.00', '750.00', 'Flat', '1600.00', '1600.00', '0.00', '1600.00', '2020-08-22', 'pending', '', 'diagnosis'), 
('857', '2020-08-22', '2008220857', '00795', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-22', 'pending', '', 'diagnosis'), 
('858', '2020-08-22', '2008220858', '00796', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '400.00', 'Flat', '1200.00', '1200.00', '0.00', '1200.00', '2020-08-22', 'pending', '', 'diagnosis'), 
('860', '2020-08-23', '2008230859', '00798', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-08-23', 'pending', '', 'diagnosis'), 
('861', '2020-08-23', '2008230861', '00799', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-23', 'pending', '', 'diagnosis'), 
('862', '2020-08-23', '2008230862', '00800', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-23', 'pending', '', 'diagnosis'), 
('863', '2020-08-23', '2008230863', '00801', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-23', 'pending', '', 'diagnosis'), 
('864', '2020-08-23', '2008230864', '00802', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-08-23', 'pending', '', 'diagnosis'), 
('865', '2020-08-23', '2008230865', '00803', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-08-23', 'pending', '', 'diagnosis'), 
('866', '2020-08-23', '2008230866', '00804', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-23', 'pending', '', 'diagnosis'), 
('867', '2020-08-24', '2008240867', '00805', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '500.00', 'Flat', '1100.00', '800.00', '300.00', '800.00', '2020-08-24', 'pending', '', 'diagnosis'), 
('868', '2020-08-24', '2008240868', '00806', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-08-24', 'pending', '', 'diagnosis'), 
('869', '2020-08-24', '2008240869', '00807', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-24', 'pending', '', 'diagnosis'), 
('870', '2020-08-24', '2008240870', '00808', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-24', 'pending', '', 'diagnosis'), 
('871', '2020-08-24', '2008240871', '00809', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '200.00', 'Flat', '1600.00', '1600.00', '0.00', '1600.00', '2020-08-24', 'pending', '', 'diagnosis'), 
('872', '2020-08-24', '2008240872', '00810', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '800.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-08-24', 'pending', '', 'diagnosis'), 
('873', '2020-08-24', '2008240873', '00811', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-24', 'pending', '', 'diagnosis'), 
('874', '2020-08-24', '2008240874', '00812', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '300.00', 'Flat', '1700.00', '1700.00', '0.00', '1700.00', '2020-08-24', 'pending', '', 'diagnosis'), 
('875', '2020-08-24', '2008240875', '00813', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-08-24', 'pending', '', 'diagnosis'), 
('876', '2020-08-24', '2008240876', '00814', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '50.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-08-24', 'pending', '', 'diagnosis'), 
('877', '2020-08-24', '2008240877', '00815', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '800.00', '2020-08-24', 'pending', '', 'diagnosis'), 
('878', '2020-08-25', '2008250878', '00816', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '650.00', 'Flat', '700.00', '700.00', '0.00', '700.00', '2020-08-25', 'pending', '', 'diagnosis'), 
('879', '2020-08-25', '2008250879', '00817', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-25', 'pending', '', 'diagnosis'), 
('880', '2020-08-25', '2008250880', '00818', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-08-25', 'pending', '', 'diagnosis'), 
('881', '2020-08-25', '2008250881', '00819', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '500.00', 'Flat', '800.00', '800.00', '0.00', '800.00', '2020-08-25', 'pending', '', 'diagnosis'), 
('882', '2020-08-25', '2008250882', '00820', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-25', 'pending', '', 'diagnosis'), 
('883', '2020-08-25', '2008250883', '00821', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '500.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-08-25', 'pending', '', 'diagnosis'), 
('884', '2020-08-25', '2008250884', '00822', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-08-25', 'pending', '', 'diagnosis'), 
('885', '2020-08-25', '2008250885', '00823', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '550.00', 'Flat', '1200.00', '1200.00', '0.00', '1200.00', '2020-08-25', 'pending', '', 'diagnosis'), 
('886', '2020-08-25', '2008250886', '00824', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-25', 'pending', '', 'diagnosis'), 
('887', '2020-08-25', '2008250887', '00825', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '650.00', 'Flat', '900.00', '900.00', '0.00', '900.00', '2020-08-25', 'pending', '', 'diagnosis'), 
('888', '2020-08-25', '2008250888', '00826', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '450.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-08-25', 'pending', '', 'diagnosis'), 
('889', '2020-08-25', '2008250889', '00827', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-25', 'pending', '', 'diagnosis'), 
('890', '2020-08-25', '2008250890', '00828', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '0.00', 'Flat', '950.00', '500.00', '450.00', '500.00', '2020-08-25', 'pending', '', 'diagnosis'), 
('891', '2020-08-25', '2008250891', '00829', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-08-25', 'pending', '', 'diagnosis'), 
('892', '2020-08-25', '2008250892', '00830', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '800.00', '2020-08-25', 'pending', '', 'diagnosis'), 
('893', '2020-08-25', '2008250893', '00831', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-25', 'pending', '', 'diagnosis'), 
('894', '2020-08-26', '2008260894', '00832', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-26', 'pending', '', 'diagnosis'), 
('895', '2020-08-26', '2008260895', '00833', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-08-26', 'pending', '', 'diagnosis'), 
('896', '2020-08-26', '2008260895', '00833', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-08-26', 'pending', '', 'diagnosis'), 
('897', '2020-08-26', '2008260897', '00834', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-26', 'pending', '', 'diagnosis'), 
('898', '2020-08-26', '2008260898', '00835', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '0.00', 'Flat', '950.00', '500.00', '450.00', '500.00', '2020-08-26', 'pending', '', 'diagnosis'), 
('899', '2020-08-26', '2008260899', '00836', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '400.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-08-26', 'pending', '', 'diagnosis'), 
('900', '2020-08-26', '2008260900', '00837', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '300.00', 'Flat', '700.00', '700.00', '0.00', '700.00', '2020-08-26', 'pending', '', 'diagnosis'), 
('901', '2020-08-26', '2008260901', '00838', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-26', 'pending', '', 'diagnosis'), 
('902', '2020-08-26', '2008260902', '00839', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-26', 'pending', '', 'diagnosis'), 
('903', '2020-08-26', '2008260903', '00840', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-26', 'pending', '', 'diagnosis'), 
('904', '2020-08-26', '2008260904', '00841', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '100.00', 'Flat', '1150.00', '1150.00', '0.00', '1150.00', '2020-08-26', 'pending', '', 'diagnosis'), 
('905', '2020-08-26', '2008260905', '00842', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '300.00', 'Flat', '1050.00', '1050.00', '0.00', '1050.00', '2020-08-26', 'pending', '', 'diagnosis'), 
('906', '2020-08-26', '2008260906', '00843', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '350.00', 'Flat', '1450.00', '1450.00', '0.00', '1450.00', '2020-08-26', 'pending', '', 'diagnosis'), 
('907', '2020-08-26', '2008260907', '00844', 'diagnosis', 'diagnosis', '2300.00', '0', '0.00', '2300.00', '500.00', 'Flat', '1800.00', '1500.00', '300.00', '1500.00', '2020-08-26', 'pending', '', 'diagnosis'), 
('908', '2020-08-26', '2008260908', '00845', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '350.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-08-26', 'pending', '', 'diagnosis'), 
('909', '2020-08-26', '2008260909', '00846', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '450.00', 'Flat', '1500.00', '1500.00', '0.00', '1500.00', '2020-08-26', 'pending', '', 'diagnosis'), 
('910', '2020-08-26', '2008260910', '00847', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-26', 'pending', '', 'diagnosis'), 
('911', '2020-08-26', '2008260911', '00848', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '100.00', '50.00', '100.00', '2020-08-26', 'pending', '', 'diagnosis'), 
('912', '2020-08-27', '2008270912', '00849', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '450.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-27', 'pending', '', 'diagnosis'), 
('913', '2020-08-27', '2008270913', '00850', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '50.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-08-27', 'pending', '', 'diagnosis'), 
('914', '2020-08-27', '2008270914', '00851', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '150.00', 'Flat', '900.00', '900.00', '0.00', '900.00', '2020-08-27', 'pending', '', 'diagnosis'), 
('915', '2020-08-27', '2008270915', '00852', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '250.00', 'Flat', '1200.00', '1200.00', '0.00', '1200.00', '2020-08-27', 'pending', '', 'diagnosis'), 
('916', '2020-08-27', '2008270916', '00853', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-08-27', 'pending', '', 'diagnosis'), 
('917', '2020-08-27', '2008270917', '00854', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '550.00', 'Flat', '800.00', '800.00', '0.00', '800.00', '2020-08-27', 'pending', '', 'diagnosis'), 
('918', '2020-08-27', '2008270918', '00855', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '700.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-08-27', 'pending', '', 'diagnosis'), 
('919', '2020-08-27', '2008270919', '00856', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-27', 'pending', '', 'diagnosis'), 
('920', '2020-08-27', '2008270920', '00857', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-27', 'pending', '', 'diagnosis'), 
('921', '2020-08-27', '2008270921', '00858', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-08-27', 'pending', '', 'diagnosis'), 
('922', '2020-08-27', '2008270922', '00859', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-27', 'pending', '', 'diagnosis'), 
('923', '2020-08-27', '2008270923', '00860', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '0.00', 'Flat', '2000.00', '1000.00', '1000.00', '1000.00', '2020-08-27', 'pending', '', 'diagnosis'), 
('924', '2020-08-27', '2008270924', '00861', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '1050.00', 'Flat', '900.00', '900.00', '0.00', '900.00', '2020-08-27', 'pending', '', 'diagnosis'), 
('925', '2020-08-28', '2008280925', '00862', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-08-28', 'pending', '', 'diagnosis'), 
('926', '2020-08-28', '2008280926', '00863', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-08-28', 'pending', '', 'diagnosis'), 
('927', '2020-08-28', '2008280927', '00864', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '200.00', 'Flat', '1300.00', '1300.00', '0.00', '1300.00', '2020-08-28', 'pending', '', 'diagnosis'), 
('928', '2020-08-28', '2008280928', '00865', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '70.00', 'Flat', '180.00', '180.00', '0.00', '180.00', '2020-08-28', 'pending', '', 'diagnosis'), 
('929', '2020-08-28', '2008280929', '00866', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '600.00', 'Flat', '1300.00', '1300.00', '0.00', '1300.00', '2020-08-28', 'pending', '', 'diagnosis'), 
('930', '2020-08-28', '2008280930', '00867', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '400.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-08-28', 'pending', '', 'diagnosis'), 
('931', '2020-08-28', '2008280931', '00868', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '750.00', '250.00', 'Flat', '500.00', '500.00', '0.00', '600.00', '2020-08-28', 'pending', '', 'diagnosis'), 
('932', '2020-08-28', '2008280932', '00869', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '500.00', 'Flat', '900.00', '900.00', '0.00', '900.00', '2020-08-28', 'pending', '', 'diagnosis'), 
('933', '2020-08-28', '2008280933', '00870', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '200.00', 'Flat', '1600.00', '1000.00', '600.00', '1000.00', '2020-08-28', 'pending', '', 'diagnosis'), 
('934', '2020-08-28', '2008280934', '00871', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-28', 'pending', '', 'diagnosis'), 
('935', '2020-08-28', '2008280935', '00872', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '100.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-08-28', 'pending', '', 'diagnosis'), 
('936', '2020-08-28', '2008280936', '00873', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-28', 'pending', '', 'diagnosis'), 
('937', '2020-08-28', '2008280937', '00874', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '450.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-28', 'pending', '', 'diagnosis'), 
('938', '2020-08-28', '2008280938', '00875', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-08-28', 'pending', '', 'diagnosis'), 
('939', '2020-08-28', '2008280939', '00876', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-28', 'pending', '', 'diagnosis'), 
('940', '2020-08-28', '2008280940', '00877', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-08-28', 'pending', '', 'diagnosis'), 
('941', '2020-08-28', '2008280941', '00878', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '250.00', 'Flat', '900.00', '900.00', '0.00', '900.00', '2020-08-28', 'pending', '', 'diagnosis'), 
('942', '2020-08-28', '2008280942', '00879', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '250.00', 'Flat', '2000.00', '2000.00', '0.00', '2000.00', '2020-08-28', 'pending', '', 'diagnosis'), 
('943', '2020-08-28', '2008280943', '00880', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '800.00', '2020-08-28', 'pending', '', 'diagnosis'), 
('944', '2020-08-28', '2008280944', '00881', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '350.00', 'Flat', '450.00', '450.00', '0.00', '450.00', '2020-08-28', 'pending', '', 'diagnosis'), 
('945', '2020-08-28', '2008280945', '00882', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-28', 'pending', '', 'diagnosis'), 
('946', '2020-08-28', '2008280946', '00883', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '150.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-28', 'pending', '', 'diagnosis'), 
('947', '2020-08-29', '2008290947', '00884', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '250.00', 'Flat', '1800.00', '1800.00', '0.00', '1000.00', '2020-08-29', 'pending', '', 'diagnosis'), 
('948', '2020-08-29', '2008290948', '00885', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-29', 'pending', '', 'diagnosis'), 
('949', '2020-08-29', '2008290949', '00886', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '300.00', 'Flat', '1300.00', '1300.00', '0.00', '1300.00', '2020-08-29', 'pending', '', 'diagnosis'), 
('950', '2020-08-29', '2008290950', '00887', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '200.00', 'Flat', '1400.00', '1400.00', '0.00', '1400.00', '2020-08-29', 'pending', '', 'diagnosis'), 
('951', '2020-08-29', '2008290951', '00888', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2500.00', '1000.00', 'Flat', '1500.00', '1500.00', '0.00', '1700.00', '2020-08-29', 'pending', '', 'diagnosis'), 
('952', '2020-08-29', '2008290952', '00889', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-08-29', 'pending', '', 'diagnosis'), 
('954', '2020-08-29', '2008290954', '00891', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '200.00', 'Flat', '750.00', '750.00', '0.00', '750.00', '2020-08-29', 'pending', '', 'diagnosis'), 
('955', '2020-08-30', '2008300955', '00892', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-08-30', 'pending', '', 'diagnosis'), 
('956', '2020-08-30', '2008300956', '00893', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-08-30', 'pending', '', 'diagnosis'), 
('957', '2020-08-30', '2008300957', '00894', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-08-30', 'pending', '', 'diagnosis'), 
('958', '2020-08-30', '2008300958', '00895', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-30', 'pending', '', 'diagnosis'), 
('959', '2020-08-30', '2008300959', '00896', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-08-30', 'pending', '', 'diagnosis'), 
('961', '2020-08-30', '2008300961', '00898', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '550.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-08-30', 'pending', '', 'diagnosis'), 
('962', '2020-08-30', '2008300962', '00899', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-30', 'pending', '', 'diagnosis'), 
('963', '2020-08-30', '2008300963', '00900', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '0.00', 'Flat', '700.00', '700.00', '0.00', '700.00', '2020-08-30', 'pending', '', 'diagnosis'), 
('964', '2020-08-30', '2008300964', '00901', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-08-30', 'pending', '', 'diagnosis'), 
('965', '2020-08-30', '2008300965', '00902', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-30', 'pending', '', 'diagnosis'), 
('966', '2020-08-30', '2008300966', '00903', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-08-30', 'pending', '', 'diagnosis'), 
('967', '2020-08-30', '2008300967', '00904', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-08-30', 'pending', '', 'diagnosis'), 
('968', '2020-08-30', '2008300968', '00905', 'diagnosis', 'diagnosis', '2400.00', '0', '0.00', '2400.00', '350.00', 'Flat', '2050.00', '2050.00', '0.00', '2050.00', '2020-08-30', 'pending', '', 'diagnosis'), 
('969', '2020-08-31', '2008310969', '00906', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-08-31', 'pending', '', 'diagnosis'), 
('970', '2020-08-31', '2008310970', '00907', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '200.00', 'Flat', '450.00', '450.00', '0.00', '450.00', '2020-08-31', 'pending', '', 'diagnosis'), 
('971', '2020-08-31', '2008310971', '00908', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-31', 'pending', '', 'diagnosis'), 
('972', '2020-08-31', '2008310972', '00909', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2450.00', '450.00', 'Flat', '2000.00', '2000.00', '0.00', '2000.00', '2020-08-31', 'pending', '', 'diagnosis'), 
('973', '2020-08-31', '2008310973', '00910', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-31', 'pending', '', 'diagnosis'), 
('974', '2020-08-31', '2008310974', '00911', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '600.00', 'Flat', '900.00', '900.00', '0.00', '900.00', '2020-08-31', 'pending', '', 'diagnosis'), 
('975', '2020-08-31', '2008310975', '00912', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '500.00', '2020-08-31', 'pending', '', 'diagnosis'), 
('976', '2020-08-31', '2008310976', '00913', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-08-31', 'pending', '', 'diagnosis'), 
('978', '2020-09-01', '2009010977', '00915', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '0.00', 'Flat', '0.00', '1500.00', '0.00', '1500.00', '2020-09-01', 'pending', '', 'diagnosis'), 
('979', '2020-09-01', '2009010979', '00916', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '50.00', '2020-09-01', 'pending', '', 'diagnosis'), 
('980', '2020-09-01', '2009010980', '00917', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '550.00', 'Flat', '300.00', '300.00', '0.00', '300.00', '2020-09-01', 'pending', '', 'diagnosis'), 
('981', '2020-09-01', '2009010981', '00918', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '150.00', '2020-09-01', 'pending', '', 'diagnosis'), 
('982', '2020-09-02', '2009020982', '00919', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '800.00', 'Flat', '600.00', '600.00', '0.00', '600.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('983', '2020-09-02', '2009020983', '00920', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('984', '2020-09-02', '2009020984', '00921', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '350.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('985', '2020-09-02', '2009020985', '00922', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('986', '2020-09-02', '2009020986', '00923', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('987', '2020-09-02', '2009020987', '00924', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '600.00', 'Flat', '1000.00', '1000.00', '0.00', '1000.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('988', '2020-09-02', '2009020988', '00925', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '650.00', '0.00', '650.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('989', '2020-09-02', '2009020989', '00926', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '400.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('990', '2020-09-02', '2009020990', '00927', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '30.00', 'Flat', '120.00', '120.00', '0.00', '120.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('991', '2020-09-02', '2009020991', '00928', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('992', '2020-09-02', '2009020992', '00929', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('993', '2020-09-02', '2009020993', '00930', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '50.00', 'Flat', '2000.00', '2000.00', '0.00', '2000.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('994', '2020-09-02', '2009020994', '00931', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '400.00', 'Flat', '1400.00', '1400.00', '0.00', '1400.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('995', '2020-09-02', '2009020995', '00932', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '900.00', '0.00', '50.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('996', '2020-09-02', '2009020996', '00933', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('997', '2020-09-02', '2009020997', '00934', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('998', '2020-09-02', '2009020998', '00935', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '1050.00', 'Flat', '1200.00', '1200.00', '0.00', '1600.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('999', '2020-09-02', '2009020999', '00936', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '90.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('1000', '2020-09-02', '2009021000', '00937', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '50.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('1001', '2020-09-02', '2009021001', '00938', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('1002', '2020-09-02', '2009021002', '00939', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '46.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('1003', '2020-09-02', '2009021003', '00940', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('1004', '2020-09-02', '2009021004', '00941', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '600.00', 'Flat', '700.00', '700.00', '0.00', '700.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('1005', '2020-09-02', '2009021005', '00942', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '430.00', 'Flat', '220.00', '220.00', '0.00', '220.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('1006', '2020-09-02', '2009021006', '00943', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '80.00', 'Flat', '70.00', '70.00', '0.00', '70.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('1007', '2020-09-02', '2009021007', '00944', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '0.00', 'Flat', '250.00', '250.00', '0.00', '250.00', '2020-09-02', 'pending', '', 'diagnosis'), 
('1008', '2020-09-03', '2009031008', '00945', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '200.00', '2020-09-03', 'pending', '', 'diagnosis'), 
('1009', '2020-09-03', '2009031009', '00946', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '0.00', 'Flat', '1550.00', '1550.00', '0.00', '1550.00', '2020-09-03', 'pending', '', 'diagnosis'), 
('1010', '2020-09-03', '2009031010', '00947', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-09-03', 'pending', '', 'diagnosis'), 
('1011', '2020-09-03', '2009031011', '00948', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '100.00', '2020-09-03', 'pending', '', 'diagnosis');  



INSERT INTO `bonus_structure` ( `id`, `eid`, `fields`, `percentage`, `remarks`, `status`) VALUES 
('1', '0002', 'Festival ', '1.00', 'Statisfactory', ''), 
('2', '0003', 'Test', '50.00', '', '');  



INSERT INTO `brand` ( `id`, `date`, `name`, `trash`) VALUES 
('1', '2018-07-22', 'Square', '0'), 
('3', '2018-07-22', 'SKF', '0'), 
('4', '2018-07-22', 'ACME', '0');  



INSERT INTO `category` ( `id`, `date`, `category`, `slug`, `brand`, `type`, `trash`) VALUES 
('2', '2018-07-22', 'Dextrose Anhydrous BP', 'dextrose_anhydrous_bp', '', '', '0'), 
('3', '2018-07-22', 'Anhydrous', 'anhydrous', '', '', '0');  



 



INSERT INTO `commission_payment` ( `id`, `payment_date`, `type`, `person_id`, `balance`, `paid`, `due`) VALUES 
('1', '2018-08-08', '0', '0', '0.00', '0.00', '0.00'), 
('2', '2020-06-16', '0', '0', '0.00', '15000.00', '0.00'), 
('3', '2020-06-16', '0', '0', '0.00', '14000.00', '0.00'), 
('4', '2020-06-16', '0', '0', '0.00', '7.00', '0.00'), 
('5', '2020-06-16', '0', '0', '0.00', '0.00', '0.00');  



 



INSERT INTO `consultancies` ( `id`, `date`, `pid`, `doctor`, `reference_name`, `room`, `notes`, `bill`, `status`) VALUES 
('20', '2020-06-23', '0030', '13', '4', '25', '', '37', 'pending'), 
('23', '2020-06-23', '0036', '21', '4', '00', '', '3', 'pending'), 
('24', '2020-06-23', '0036', '20', '4', '20', '', '3', 'pending'), 
('25', '2020-06-23', '0037', '21', '4', '00', '', '4', 'pending'), 
('26', '2020-06-23', '0037', '20', '4', '202', '', '4', 'pending'), 
('30', '2020-06-24', '0005', '13', '4', '00', '', '15', 'pending'), 
('32', '2020-06-29', '0010', '21', '2', '00', '', '19', 'pending'), 
('33', '2020-06-30', '0013', '23', '2', '101', '', '22', 'pending'), 
('34', '2020-06-30', '0014', '20', '2', '202', '', '23', 'pending'), 
('35', '2020-06-30', '0015', '20', '2', '202', '', '24', 'pending'), 
('36', '2020-07-02', '0017', '23', '3', '101', '', '26', 'pending'), 
('37', '2020-07-02', '0019', '23', '3', '101', '', '28', 'pending'), 
('38', '2020-07-02', '0020', '19', '0', '101', '', '29', 'pending'), 
('41', '2020-07-17', '0261', '23', '20', '101', '', '270', 'pending'), 
('42', '2020-07-18', '0281', '31', '19', '101', '', '290', 'pending'), 
('43', '2020-07-18', '0283', '31', '19', '101', '', '292', 'pending'), 
('44', '2020-07-19', '0295', '23', '19', '101', '', '304', 'pending'), 
('55', '2020-07-21', '0327', '23', '19', '101', '', '336', 'pending'), 
('56', '2020-07-21', '0329', '23', '19', '101', '', '338', 'pending'), 
('57', '2020-07-22', '0336', '17', '2', '00', '', '345', 'pending'), 
('60', '2020-07-23', '0352', '23', '38', '101', '', '361', 'pending'), 
('61', '2020-07-23', '0353', '23', '19', '101', '', '362', 'pending'), 
('62', '2020-07-23', '0355', '23', '0', '101', '', '364', 'pending'), 
('63', '2020-07-23', '0356', '23', '19', '101', '', '365', 'pending'), 
('64', '2020-07-23', '0357', '23', '19', '101', '', '366', 'pending'), 
('65', '2020-07-23', '0358', '23', '39', '101', '', '367', 'pending'), 
('66', '2020-07-23', '0361', '29', '37', '144038', '', '370', 'pending'), 
('67', '2020-07-23', '0363', '23', '0', '101', '', '372', 'pending'), 
('68', '2020-07-23', '0366', '34', '37', '236', '', '376', 'pending'), 
('69', '2020-07-23', '0367', '29', '37', '144038', '', '377', 'pending'), 
('70', '2020-07-23', '0368', '34', '2', '236', '', '378', 'pending');  



INSERT INTO `cost` ( `id`, `date`, `cost_field`, `description`, `amount`, `spend_by`, `trash`) VALUES 
('1', '2020-07-05', '0015', '', '200', 'HARUN', '0'), 
('2', '2020-07-05', '0017', '', '50', 'RASEL', '0'), 
('3', '2020-07-05', '0018', '', '800', 'RASEL', '0'), 
('4', '2020-07-05', '0022', '', '50', 'AYESHA', '0'), 
('5', '2020-07-05', '0023', '2020-07-05', '250', 'RASEL', '0'), 
('6', '2020-07-05', '0024', 'RITAN', '00', 'AYESHA', '0'), 
('7', '2020-07-05', '0024', '', '600', 'AYESHA', '0'), 
('8', '2020-07-05', '0019', '', '960', 'RASEL', '0'), 
('9', '2020-07-05', '0020', '', '2400', 'aeysha', '0'), 
('10', '2020-07-05', '0014', '', '100', 'aeysha', '0'), 
('11', '2020-07-06', '0026', '', '100', 'R', '0'), 
('12', '2020-07-06', '0027', '', '80', 'HARUN', '0'), 
('13', '2020-07-06', '0028', '', '60', 'ATIQ', '0'), 
('14', '2020-07-06', '0029', 'X-RAY FILM.L .20  P /M 20P.YELLOW STICK. TPHA. HBSAG./JEL/X RAY FILM DENTAL 20P RASEL FORM1000TOTAL3000', '2000', 'A', '0'), 
('15', '2020-07-06', '0025', '', '300', 'A', '0'), 
('16', '2020-07-06', '0024', '', '1500', 'A', '0'), 
('17', '2020-07-06', '0020', '', '250', 'R', '0'), 
('18', '2020-07-06', '0023', '', '250', 'R', '0'), 
('19', '2020-07-06', '0019', '6P', '720', 'A', '0'), 
('21', '2020-07-07', '0020', 'HABIB KAMARAR BAZAR', '600', 'A', '0'), 
('22', '2020-07-07', '0019', '5P                11/3', '600', 'A', '0'), 
('23', '2020-07-07', '0032', 'SISHA STOR', '900', 'H', '0'), 
('24', '2020-07-07', '0033', '', '1000', '', '0'), 
('25', '2020-07-07', '0019', '3/7H.3P', '360', 'A', '0'), 
('26', '2020-07-07', '0024', '', '1500', 'A', '0'), 
('27', '2020-07-07', '0024', '', '300', 'A', '0'), 
('28', '2020-07-07', '0023', '', '250', 'R', '0'), 
('29', '2020-07-07', '0014', 'SHOPON', '300', 'A', '0'), 
('30', '2020-07-08', '0006', 'RASEL;', '120', 'A', '0'), 
('31', '2020-07-08', '0014', 'JOSIM+DAN=110', '110', 'A', '0'), 
('32', '2020-07-08', '0031', 'TCDC S.ELECTRORITE', '300', 'R', '0'), 
('33', '2020-07-08', '0014', 'HARUN ', '120', 'A', '0'), 
('34', '2020-07-08', '0014', 'SOPON +JOSHIM', '250', 'R', '0'), 
('35', '2020-07-08', '0020', 'SHIHABUL ISLAM', '250', 'A', '0'), 
('36', '2020-07-08', '0019', '6P', '720', 'A', '0'), 
('37', '2020-07-08', '0024', '', '1500', 'A', '0'), 
('38', '2020-07-08', '0025', '', '300', 'A', '0'), 
('39', '2020-07-08', '0023', '', '250', 'R', '0'), 
('40', '2020-07-08', '0014', 'RASEL', '200', 'R', '0'), 
('41', '2020-07-08', '0034', 'R ASEL 30', '230', 'A', '0'), 
('42', '2020-07-08', '0014', '', '30', 'A', '0'), 
('43', '2020-07-12', '0020', 'ALI VAI', '1000', 'R', '0'), 
('44', '2020-07-12', '0014', '', '5955', 'R', '0'), 
('45', '2020-07-13', '0019', '11/4H-  12P', '1440', 'A', '0'), 
('46', '2020-07-13', '0019', '2P', '240', 'A', '0'), 
('47', '2020-07-13', '0029', '', '2000', 'A', '0'), 
('48', '2020-07-13', '0020', 'FARUQ 500/JULSHAS 600SHAHIDA 200MORZINA50', '1350', 'R', '0'), 
('49', '2020-07-13', '0024', '', '1800', 'A', '0'), 
('50', '2020-07-13', '0023', '', '250', 'A', '0'), 
('51', '2020-07-13', '0014', '', '110', 'A', '0'), 
('52', '2020-07-13', '0006', '', '120', 'RASEL', '0'), 
('53', '2020-07-13', '0020', 'NIKASH', '1000', 'R', '0'), 
('54', '2020-07-13', '0014', 'RASEL450', '450', 'R', '0'), 
('56', '2020-07-14', '0019', 'MAKAM7P MADAM 2P', '1080', 'A', '0'), 
('57', '2020-07-14', '0025', '', '1800', 'A', '0'), 
('58', '2020-07-14', '0014', 'HARUN  MARKATING', '200', 'R', '0'), 
('59', '2020-07-14', '0020', 'MORZINA', '100', 'A', '0'), 
('60', '2020-07-14', '0023', '', '250', 'R', '0'), 
('61', '2020-07-14', '0014', 'HARUN  SELARY', '200', 'A', '0'), 
('62', '2020-07-14', '0014', 'DAN', '10', 'A', '0'), 
('63', '2020-07-15', '0014', '', '10', 'test', '0'), 
('64', '2020-07-16', '0020', '      nasrin +sufia              sadiya', '1300', 'R', '0'), 
('65', '2020-07-16', '0020', 'PASENT N SHOZIB /RFD=ROFIQUL KALIBARI ', '300', 'R', '0'), 
('66', '2020-07-16', '0014', 'totall cost', '6700', 'a', '0'), 
('67', '2020-07-17', '0022', '', '50', 'A', '0'), 
('68', '2020-07-17', '0035', '', '300', 'A', '0'), 
('69', '2020-07-17', '0036', '', '20', 'A', '0'), 
('70', '2020-07-17', '0037', '', '200', 'A', '0'), 
('71', '2020-07-17', '0038', '', '100', 'A', '0'), 
('72', '2020-07-17', '0031', '', '100', 'A', '0'), 
('73', '2020-07-17', '0019', '8P', '960', 'A', '0'), 
('74', '2020-07-17', '0029', '', '2000', 'A', '0'), 
('75', '2020-07-17', '0010', 'PAN CHA ', '30', 'A', '0'), 
('76', '2020-07-17', '0020', 'ZINNA800/CHONDON600/POLLOB500', '2600', 'A', '0'), 
('77', '2020-07-17', '0025', '', '1800', 'A', '0'), 
('78', '2020-07-17', '0023', '', '250', 'A', '0'), 
('79', '2020-07-19', '0025', '', '1800', 'a', '0'), 
('80', '2020-07-19', '0036', '', '1200', 'A', '0'), 
('81', '2020-07-19', '0035', '', '200', 'A', '0'), 
('82', '2020-07-19', '0006', '', '270', 'A', '0'), 
('83', '2020-07-19', '0019', '9P', '1080', 'A', '0'), 
('84', '2020-07-19', '0020', '', '600', 'A', '0'), 
('85', '2020-07-19', '0023', 'SIRINS 60', '310', 'A', '0'), 
('87', '2020-07-22', '0014', '', '200', 'test', '0'), 
('88', '2020-07-23', '0039', '2/L', '200', 'H', '0'), 
('89', '2020-07-24', '0027', '', '70', 'RASEL', '0'), 
('90', '2020-07-24', '0024', '', '1800', 'RASEL', '0'), 
('91', '2020-07-24', '0038', '', '350', 'RASEL', '0'), 
('92', '2020-07-24', '0040', '', '600', 'A', '0'), 
('93', '2020-07-24', '0029', '', '4000', 'AYESHA', '0'), 
('94', '2020-07-24', '0023', 'HARUN+ROFIKUL', '400', 'A', '0'), 
('95', '2020-07-24', '0019', 'HASIMUL 4P', '600', 'A', '0'), 
('96', '2020-07-24', '0019', 'MAKAM 6P', '750', 'A', '0'), 
('97', '2020-07-24', '0014', '', '640', 'A', '0'), 
('98', '2020-07-25', '0041', 'TSH.    HB1C ', '650', 'A', '0'), 
('99', '2020-07-25', '0036', 'CABUL= OLI+MASC=GLOVES', '1440', 'A', '0'), 
('100', '2020-08-03', '0019', 'makam11p', '1320', 'a', '0'), 
('101', '2020-08-03', '0020', 'kamal=300/sdurhab1000', '1300', 'a', '0'), 
('102', '2020-08-03', '0014', '', '1220', 'a', '0'), 
('103', '2020-08-04', '0036', '', '1100', 'R', '0'), 
('104', '2020-08-04', '0', 'TATAL COST 5360', '5360', 'AYESHA ', '1'), 
('105', '2020-08-04', '0014', 'TOTAL COST', '5360', 'A', '0'), 
('106', '2020-08-05', '0036', 'shahin rasel2500', '2500', 'a', '0'), 
('107', '2020-08-05', '0020', 'joshim=munaym', '2200', 'a', '0'), 
('108', '2020-08-05', '0020', 'rohul amin', '260', 'r', '0'), 
('109', '2020-08-05', '0019', 'hasimul+shapla7p', '1050', 'a', '0'), 
('110', '2020-08-05', '0024', '', '1800', 'a', '0'), 
('111', '2020-08-05', '0023', '', '250', 'R', '0'), 
('112', '2020-08-05', '0014', '', '55', 'A', '0'), 
('113', '2020-08-05', '0031', '', '850', 'A', '0'), 
('114', '2020-08-06', '0014', 'Talal Cost Tk', '7340', '', '0'), 
('115', '2020-08-07', '0014', '', '6700', 'a', '0'), 
('116', '2020-08-08', '0006', '', '10', '', '1'), 
('117', '2020-08-08', '0015', '', '200', 'R', '0'), 
('118', '2020-08-08', '0014', 'Tatal Cost', '5230', '', '0'), 
('119', '2020-08-09', '0014', 'Total Cost TK ;7155', '7155', '', '0'), 
('120', '2020-08-10', '0014', 'Tatal Cost Tk :', '3870', 'a', '0'), 
('121', '2020-08-11', '0014', 'Tatat Cost TK ;10160', '10160', '', '0'), 
('122', '2020-08-12', '0014', 'Tatal Cost Tk ;6000', '6000', '', '0'), 
('123', '2020-08-13', '0', 'Tatal Cost Tk ;6070', '6070', 'A', '1'), 
('124', '2020-08-13', '0014', 'Tatal Cost Tk :6070', '6070', 'A', '0'), 
('125', '2020-08-14', '0014', 'Talal Kost Taka :7100', '7100', 'a', '0'), 
('126', '2020-08-15', '0014', 'Total Tk :9590', '9590', 'a', '0'), 
('127', '2020-08-16', '0014', 'Tatal cost Tk:6200', '6200', 'a', '0'), 
('128', '2020-08-17', '0014', 'Tolal Cost Tk :4790', '4790', 'a', '0'), 
('129', '2020-08-18', '0014', '', '3580', 'a', '0'), 
('130', '2020-08-19', '0014', 'Tatal Tk :7285                                                                                                                  ', '7285', '', '0'), 
('131', '2020-08-20', '0037', 'H', '200', 'R', '0'), 
('132', '2020-08-20', '0014', '', '3400', 'a', '0'), 
('133', '2020-08-21', '0014', '', '8890', 'R', '0'), 
('134', '2020-08-21', '0014', '', '230', 'R', '0'), 
('135', '2020-08-22', '0014', '', '5970', 'R', '0'), 
('136', '2020-08-23', '0', '', '1230', 'T', '1'), 
('137', '2020-08-23', '0', '', '1230', 'T', '1'), 
('138', '2020-08-24', '0', '', '5090', 'T', '1'), 
('139', '2020-08-25', '0009', '', '10', '', '1'), 
('140', '2020-08-25', '0042', '', '20', 'r', '1'), 
('141', '2020-08-25', '0', '', '5550', 'T', '1'), 
('142', '2020-08-25', '0014', '', '5550', 'T', '0'), 
('143', '2020-08-26', '0014', '', '8230', 'T', '0'), 
('144', '2020-08-27', '0036', 'babul vai', '600', 'rasel', '0'), 
('145', '2020-08-27', '0019', '4P 3.30', '500', 'T', '1'), 
('146', '2020-08-27', '0014', '', '5100', 'T', '1'), 
('147', '2020-08-27', '0019', '5p 6h', '620', 't', '0'), 
('148', '2020-08-27', '0035', '', '400', 'r', '0'), 
('149', '2020-08-27', '0023', 's=t', '230', 't', '0'), 
('150', '2020-08-27', '0014', '', '100', 't', '0'), 
('151', '2020-08-27', '0024', '', '1800', 't', '0'), 
('152', '2020-08-28', '0020', '00864RAZIB RF/D.MUBAROK', '600', 'R', '1'), 
('153', '2020-08-28', '0040', 'THAMINA/ USG', '200', 'R', '0'), 
('154', '2020-08-28', '0040', 'PARUL', '200', 'R', '1'), 
('155', '2020-08-28', '0015', '', '130', 'T', '0'), 
('156', '2020-08-28', '0024', '', '1800', 'T', '0'), 
('157', '2020-08-28', '0023', 'S+T', '250', 'T', '0'), 
('158', '2020-08-28', '0014', '', '300', 'R', '0'), 
('159', '2020-08-28', '0038', '', '350', 'T', '0'), 
('160', '2020-08-28', '0014', '', '50', 't', '0'), 
('161', '2020-08-28', '0019', '', '1200', 't', '0'), 
('162', '2020-08-29', '0036', '', '250', 'R', '0'), 
('163', '2020-08-29', '0036', '', '250', '', '0'), 
('164', '2020-08-29', '0036', '', '1700', 'R', '0'), 
('165', '2020-08-29', '0019', '', '780', 'T', '0'), 
('166', '2020-08-29', '0024', '', '1800', 'T', '0'), 
('167', '2020-08-29', '0023', 'S+T', '230', 'T', '0'), 
('168', '2020-08-29', '0029', '', '1000', 'R', '0'), 
('169', '2020-08-30', '0024', '', '1800', 'T', '0'), 
('170', '2020-08-30', '0019', '', '910', 'T', '0'), 
('171', '2020-08-30', '0023', 'S+T', '230', 'T', '0'), 
('172', '2020-08-31', '0024', '', '1800', 'T', '0'), 
('173', '2020-08-31', '0036', '', '220', 'T', '0'), 
('174', '2020-08-31', '0023', 'S+T', '230', 'T', '0'), 
('175', '2020-08-31', '0019', '', '480', 'T', '0'), 
('176', '2020-09-01', '0036', '', '350', 'T', '0'), 
('177', '2020-09-01', '0019', '', '120', 'T', '0'), 
('178', '2020-09-01', '0023', 'S+T', '230', 'T', '0'), 
('179', '2020-09-02', '0028', '', '150', 't', '0'), 
('180', '2020-09-02', '0019', '', '1320', 'T', '0'), 
('181', '2020-09-02', '0037', '', '200', 't', '0'), 
('182', '2020-09-02', '0025', '', '1800', 't', '0'), 
('183', '2020-09-02', '0031', '', '500', 't', '0'), 
('184', '2020-09-02', '0036', '', '300', 't', '1'), 
('185', '2020-09-02', '0016', '', '105', 't', '0'), 
('186', '2020-09-02', '0023', 'S+T', '230', 't', '0'), 
('187', '2020-09-02', '0036', '', '1055', 't', '0');  



INSERT INTO `cost_field` ( `id`, `code`, `cost_field`, `trash`) VALUES 
('1', '0001', 'Maintenance', '0'), 
('2', '0002', 'Employee Salary', '0'), 
('4', '0004', 'Electricity Bill', '0'), 
('5', '0005', 'Internet Bill', '0'), 
('6', '0006', 'Mobile Bill', '0'), 
('7', '0007', 'House Rent', '0'), 
('8', '0008', 'Press and Print Bill 74', '0'), 
('9', '0009', 'Advertisement Bill', '0'), 
('10', '0010', 'Food Bill', '0'), 
('13', '0011', 'Employee salary', '0'), 
('14', '0014', 'Others', '0'), 
('15', '0015', 'SPCED', '0'), 
('16', '0016', 'PANI', '0'), 
('17', '0017', 'NASIMA CORMI ', '0'), 
('18', '0018', 'FIRE SERVICE ', '0'), 
('19', '0019', 'U S G .DOCTOR FISH', '0'), 
('20', '0020', 'R / F', '0'), 
('21', '0021', 'OTHERS', '0'), 
('22', '0022', 'DAN  BABOD', '0'), 
('23', '0023', 'AYESHA/TANJILA /SALARY', '0'), 
('24', '0024', 'SHOMITE DELY', '0'), 
('25', '0025', 'SHOMITIA WEEKLY', '0'), 
('26', '0026', 'KORMI', '0'), 
('27', '0027', 'T.BEG', '0'), 
('28', '0028', 'TISUE PAPER', '0'), 
('29', '0029', 'FARUK / SURGICAL', '0'), 
('30', '0030', 'FARUK / SURGICAL', '0'), 
('31', '0031', 'AL-KIDMA DC ', '0'), 
('32', '0032', 'GORI', '0'), 
('33', '0033', 'INTAR NAT BILL', '0'), 
('34', '0034', 'NIGHT GAT', '0'), 
('35', '0035', 'OLI', '0'), 
('36', '0036', 'RASEL', '0'), 
('37', '0037', 'MARKATIN BABOD', '0'), 
('38', '0038', 'SHADIA', '0'), 
('39', '0039', 'SPEED', '0'), 
('40', '0040', 'AD VISIT', '0'), 
('41', '0041', 'Aroggo DC', '0'), 
('42', '0042', 'test', '1'), 
('43', '0043', 'Mobile Recharche', '1');  



 



INSERT INTO `deduction_structure` ( `id`, `eid`, `fields`, `amount`, `remarks`, `status`) VALUES 
('1', '0002', 'Advanced Pay', '1000.00', '', ''), 
('2', '0002', 'Professional Tax ', '0.00', '', ''), 
('3', '0002', 'Loan', '0.00', '', ''), 
('4', '0002', 'Provisional Fund', '0.00', '', '');  



INSERT INTO `diagnosis` ( `id`, `date`, `delivery`, `pid`, `name`, `gender`, `reference_name`, `refereed_doctor`, `group`, `room`, `result`, `alt_doctor_id`, `alt_doctor_fee`, `remarks`, `amount`, `cost`, `bill`, `status`) VALUES 
('6', '2020-06-25', '2020-06-25', '00005', 'CBC', '', '2', '', 'HAEMATOLOGY', '101', '', '', '0.00', '', '400.00', '0.00', '18', 'pending'), 
('7', '2020-06-25', '2020-06-25', '00005', 'CBC', '', '2', '', 'HAEMATOLOGY', '101', '', '', '0.00', '', '400.00', '0.00', '18', 'pending'), 
('8', '2020-06-30', '2020-06-30', '00006', 'Sugar_2_HABF', '', '2', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '20', 'pending'), 
('9', '2020-06-30', '2020-06-30', '00007', 'PREGNANCY_PROFILE', '', '2', '19', 'USG_ULTRASONOGRAPHY', '202', '', '', '0.00', '', '650.00', '0.00', '21', 'pending'), 
('11', '2020-07-02', '2020-07-02', '00009', 'L/S_A/P', '', '3', '23', 'DIGITAL X-RAY', '204', '', '', '0.00', '', '250.00', '0.00', '27', 'pending'), 
('12', '2020-07-02', '2020-07-02', '00010', 'CBC', '', '7', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '30', 'pending'), 
('13', '2020-07-02', '2020-07-02', '00010', 'R.Sugar', '', '7', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '30', 'pending'), 
('14', '2020-07-02', '2020-07-02', '00010', 'Widal Test', '', '7', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '30', 'pending'), 
('15', '2020-07-02', '2020-07-02', '00010', 'Whole Abdomen', '', '7', '23', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '30', 'pending'), 
('16', '2020-07-02', '2020-07-02', '00010', 'R/E M/E', '', '7', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '30', 'pending'), 
('17', '2020-07-02', '2020-07-02', '00011', 'PREGNANCY_PROFILE', '', '3', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '31', 'pending'), 
('19', '2020-07-02', '2020-07-02', '00013', 'Pregnancy Profile', '', '3', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '', '0.00', '', '850.00', '0.00', '33', 'pending'), 
('20', '2020-07-02', '2020-07-02', '00014', 'DANTAL_X-RAY', '', '3', '24', 'DANTAL_X-RAY', '204', '', '', '0.00', '', '150.00', '0.00', '34', 'pending'), 
('21', '2020-07-02', '2020-07-02', '00015', 'S. Bilirubin', '', '3', '23', 'BIOCHEMISTRY', '101', '', '', '0.00', '', '250.00', '0.00', '35', 'pending'), 
('22', '2020-07-02', '2020-07-02', '00015', 'R/E M/E', '', '3', '23', 'URINE', '201', '', '', '0.00', '', '150.00', '0.00', '35', 'pending'), 
('23', '2020-07-02', '2020-07-02', '00016', 'Pregnancy Profile', '', '3', '23', 'DIGITAL ULTRASONOGRAPHY', '203', '', '', '0.00', '', '850.00', '0.00', '36', 'pending'), 
('24', '2020-07-02', '2020-07-02', '00017', 'PREGNANCY_PROFILE', '', '3', '23', 'USG_ULTRASONOGRAPHY', '202', '', '', '0.00', '', '650.00', '0.00', '37', 'pending'), 
('25', '2020-07-02', '2020-07-02', '00018', 'R.Sugar', '', '3', '23', 'BIOCHEMISTRY', '201', '', '', '0.00', '', '150.00', '0.00', '38', 'pending'), 
('26', '2020-07-02', '2020-07-02', '00018', 'Chest P/A View', '', '3', '23', 'DIGITAL X-RAY', '204', '', '', '0.00', '', '250.00', '0.00', '38', 'pending'), 
('27', '2020-07-02', '2020-07-02', '00019', 'R/E M/E', '', '3', '20', 'URINE', '201', '', '', '0.00', '', '150.00', '0.00', '39', 'pending'), 
('28', '2020-07-02', '2020-07-02', '00019', 'PREGNANCY_PROFILE', '', '3', '20', 'USG_ULTRASONOGRAPHY', '202', '', '', '0.00', '', '650.00', '0.00', '39', 'pending'), 
('29', '2020-07-02', '2020-07-02', '00020', 'PREGNANCY_PROFILE', '', '3', '23', 'USG_ULTRASONOGRAPHY', '202', '', '', '0.00', '', '650.00', '0.00', '40', 'pending'), 
('30', '2020-07-02', '2020-07-02', '00021', 'Skull B V / P.N.S', '', '3', '24', 'DIGITAL X-RAY', '204', '', '', '0.00', '', '250.00', '0.00', '41', 'pending'), 
('31', '2020-07-03', '2020-07-03', '00022', 'Widal Test', '', '3', '24', 'SEROLOGY', '201', '', '', '0.00', '', '400.00', '0.00', '42', 'pending'), 
('32', '2020-07-03', '2020-07-03', '00022', 'R/E M/E', '', '3', '24', 'URINE', '201', '', '', '0.00', '', '150.00', '0.00', '42', 'pending'), 
('33', '2020-07-03', '2020-07-03', '00023', 'PREGNANCY_PROFILE', '', '2', '24', 'USG_ULTRASONOGRAPHY', '202', '', '', '0.00', '', '650.00', '0.00', '43', 'pending'), 
('34', '2020-07-03', '2020-07-03', '00024', 'CBC', '', '2', '19', 'HAEMATOLOGY', '101', '', '', '0.00', '', '400.00', '0.00', '44', 'pending'), 
('35', '2020-07-03', '2020-07-03', '00024', 'R.Sugar', '', '2', '19', 'BIOCHEMISTRY', '201', '', '', '0.00', '', '150.00', '0.00', '44', 'pending'), 
('36', '2020-07-03', '2020-07-03', '00024', 'PREGNANCY_PROFILE', '', '2', '19', 'USG_ULTRASONOGRAPHY', '202', '', '', '0.00', '', '650.00', '0.00', '44', 'pending'), 
('37', '2020-07-03', '2020-07-03', '00024', 'Chest P/A View', '', '2', '19', 'DIGITAL X-RAY', '204', '', '', '0.00', '', '250.00', '0.00', '44', 'pending'), 
('38', '2020-07-03', '2020-07-03', '00024', 'S. Creatinine', '', '2', '19', 'BIOCHEMISTRY', '101', '', '', '0.00', '', '400.00', '0.00', '44', 'pending'), 
('39', '2020-07-03', '2020-07-03', '00025', 'ESR', '', '2', '23', 'HAEMATOLOGY', '201', '', '', '0.00', '', '150.00', '0.00', '45', 'pending'), 
('40', '2020-07-03', '2020-07-03', '00025', 'Widal Test', '', '2', '23', 'SEROLOGY', '201', '', '', '0.00', '', '400.00', '0.00', '45', 'pending'), 
('41', '2020-07-03', '2020-07-03', '00025', 'R/E M/E', '', '2', '23', 'URINE', '201', '', '', '0.00', '', '150.00', '0.00', '45', 'pending'), 
('42', '2020-07-03', '2020-07-03', '00025', 'Whole Abdomen', '', '2', '23', 'DIGITAL ULTRASONOGRAPHY', '203', '', '', '0.00', '', '850.00', '0.00', '45', 'pending'), 
('43', '2020-07-03', '2020-07-03', '00025', 'L/S_A/P', '', '2', '23', 'DIGITAL X-RAY', '204', '', '', '0.00', '', '250.00', '0.00', '45', 'pending'), 
('44', '2020-07-03', '2020-07-03', '00026', 'R.Sugar', '', '2', '19', 'BIOCHEMISTRY', '201', '', '', '0.00', '', '150.00', '0.00', '46', 'pending'), 
('45', '2020-07-03', '2020-07-03', '00026', 'ECG', '', '2', '19', 'ECG', '202', '', '', '0.00', '', '250.00', '0.00', '46', 'pending'), 
('46', '2020-07-03', '2020-07-03', '00026', 'Whole Abdomen', '', '2', '19', 'DIGITAL ULTRASONOGRAPHY', '203', '', '', '0.00', '', '850.00', '0.00', '46', 'pending'), 
('47', '2020-07-03', '2020-07-03', '00026', 'Chest P/A View', '', '2', '19', 'DIGITAL X-RAY', '204', '', '', '0.00', '', '250.00', '0.00', '46', 'pending'), 
('48', '2020-07-03', '2020-07-03', '00027', 'R.Sugar', '', '8', '19', 'BIOCHEMISTRY', '201', '', '', '0.00', '', '150.00', '0.00', '47', 'pending'), 
('49', '2020-07-03', '2020-07-03', '00027', 'S. Creatinine', '', '8', '19', 'BIOCHEMISTRY', '101', '', '', '0.00', '', '400.00', '0.00', '47', 'pending'), 
('50', '2020-07-03', '2020-07-03', '00027', 'Whole Abdomen', '', '8', '19', 'DIGITAL ULTRASONOGRAPHY', '203', '', '', '0.00', '', '850.00', '0.00', '47', 'pending'), 
('51', '2020-07-03', '2020-07-03', '00028', 'Pregnancy Profile', '', '2', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '', '0.00', '', '850.00', '0.00', '48', 'pending'), 
('52', '2020-07-03', '2020-07-03', '00029', 'ESR', '', '2', '19', 'HAEMATOLOGY', '201', '', '', '0.00', '', '150.00', '0.00', '49', 'pending'), 
('53', '2020-07-03', '2020-07-03', '00029', 'S. Creatinine', '', '2', '19', 'BIOCHEMISTRY', '101', '', '', '0.00', '', '400.00', '0.00', '49', 'pending'), 
('54', '2020-07-03', '2020-07-03', '00029', 'S.G.P.T.(ALT)', '', '2', '19', 'BIOCHEMISTRY', '101', '', '', '0.00', '', '400.00', '0.00', '49', 'pending'), 
('55', '2020-07-03', '2020-07-03', '00029', 'Chest P/A View', '', '2', '19', 'DIGITAL X-RAY', '204', '', '', '0.00', '', '250.00', '0.00', '49', 'pending'), 
('56', '2020-07-03', '2020-07-03', '00030', 'ESR', '', '2', '19', 'HAEMATOLOGY', '201', '', '', '0.00', '', '150.00', '0.00', '50', 'pending'), 
('57', '2020-07-03', '2020-07-03', '00030', 'R.Sugar', '', '2', '19', 'BIOCHEMISTRY', '201', '', '', '0.00', '', '150.00', '0.00', '50', 'pending'), 
('58', '2020-07-03', '2020-07-03', '00031', 'Chest P/A View', '', '2', '19', 'DIGITAL X-RAY', '204', '', '', '0.00', '', '250.00', '0.00', '51', 'pending'), 
('59', '2020-07-03', '2020-07-03', '00032', 'Whole Abdomen', '', '2', '19', 'DIGITAL ULTRASONOGRAPHY', '203', '', '', '0.00', '', '850.00', '0.00', '52', 'pending'), 
('60', '2020-07-03', '2020-07-03', '00033', 'ESR', '', '2', '19', 'HAEMATOLOGY', '201', '', '', '0.00', '', '150.00', '0.00', '53', 'pending'), 
('61', '2020-07-03', '2020-07-03', '00033', 'S. Creatinine', '', '2', '19', 'BIOCHEMISTRY', '101', '', '', '0.00', '', '400.00', '0.00', '53', 'pending'), 
('62', '2020-07-03', '2020-07-03', '00033', 'R/A Test', '', '2', '19', 'SEROLOGY', '201', '', '', '0.00', '', '400.00', '0.00', '53', 'pending'), 
('63', '2020-07-03', '2020-07-03', '00033', 'R/E M/E', '', '2', '19', 'URINE', '201', '', '', '0.00', '', '150.00', '0.00', '53', 'pending'), 
('64', '2020-07-03', '2020-07-03', '00033', 'ECG', '', '2', '19', 'ECG', '202', '', '', '0.00', '', '250.00', '0.00', '53', 'pending'), 
('65', '2020-07-03', '2020-07-03', '00033', 'Chest P/A View', '', '2', '19', 'DIGITAL X-RAY', '204', '', '', '0.00', '', '250.00', '0.00', '53', 'pending'), 
('66', '2020-07-03', '2020-07-03', '00034', 'R/E M/E', '', '2', '19', 'URINE', '201', '', '', '0.00', '', '150.00', '0.00', '54', 'pending'), 
('67', '2020-07-03', '2020-07-03', '00034', 'ESR', '', '2', '19', 'HAEMATOLOGY', '201', '', '', '0.00', '', '150.00', '0.00', '54', 'pending'), 
('68', '2020-07-05', '2020-07-05', '00035', 'F.SUGAR_/_SUGAR_2HABF_', '', '2', '0', 'BIOCHEMISTRY', '201', '', '', '0.00', '', '300.00', '0.00', '55', 'pending'), 
('69', '2020-07-05', '2020-07-05', '00036', 'R.Sugar', '', '2', '24', 'BIOCHEMISTRY', '201', '', '', '0.00', '', '150.00', '0.00', '56', 'pending'), 
('70', '2020-07-05', '2020-07-05', '00037', 'PREGNANCY_PROFILE', '', '15', '23', 'USG_ULTRASONOGRAPHY', '202', '', '', '0.00', '', '650.00', '0.00', '57', 'pending'), 
('71', '2020-07-05', '2020-07-05', '00038', 'Pregnancy Test', '', '2', '24', 'URINE', '201', '', '', '0.00', '', '150.00', '0.00', '58', 'pending'), 
('72', '2020-07-05', '2020-07-05', '00039', 'PREGNANCY_PROFILE', '', '10', '23', 'USG_ULTRASONOGRAPHY', '202', '', '', '0.00', '', '650.00', '0.00', '59', 'pending'), 
('73', '2020-07-05', '2020-07-05', '00040', 'URINE_R_/_E', '', '2', '25', 'URINE_R./E', '201', '', '', '0.00', '', '150.00', '0.00', '60', 'pending'), 
('74', '2020-07-05', '2020-07-05', '00040', 'ECG', '', '2', '25', 'ECG', '202', '', '', '0.00', '', '250.00', '0.00', '60', 'pending'), 
('75', '2020-07-05', '2020-07-05', '00041', 'DANTAL_X-RAY', '', '2', '24', 'DANTAL_X-RAY', '204', '', '', '0.00', '', '150.00', '0.00', '61', 'pending'), 
('83', '2020-07-05', '2020-07-05', '00043', 'R.Sugar', '', '2', '24', 'BIOCHEMISTRY', '201', '', '', '0.00', '', '150.00', '0.00', '63', 'pending'), 
('84', '2020-07-05', '2020-07-05', '00044', 'Chest P/A View', '', '2', '24', 'DIGITAL X-RAY', '204', '', '', '0.00', '', '250.00', '0.00', '64', 'pending'), 
('90', '2020-07-05', '2020-07-05', '00046', 'DANTAL_X-RAY', '', '2', '24', 'DANTAL_X-RAY', '204', '', '', '0.00', '', '150.00', '0.00', '66', 'pending'), 
('96', '2020-07-05', '2020-07-05', '00048', 'CBC', '', '14', '23', 'HAEMATOLOGY', '101', '', '', '0.00', '', '400.00', '0.00', '68', 'pending'), 
('97', '2020-07-05', '2020-07-05', '00048', 'S. Bilirubin', '', '14', '23', 'BIOCHEMISTRY', '101', '', '', '0.00', '', '250.00', '0.00', '68', 'pending'), 
('98', '2020-07-05', '2020-07-05', '00048', 'R/E M/E', '', '14', '23', 'URINE', '201', '', '', '0.00', '', '150.00', '0.00', '68', 'pending'), 
('99', '2020-07-05', '2020-07-05', '00048', 'Skull B V / P.N.S', '', '14', '23', 'DIGITAL X-RAY', '204', '', '', '0.00', '', '250.00', '0.00', '68', 'pending'), 
('100', '2020-07-05', '2020-07-05', '00049', 'CBC', '', '14', '23', 'HAEMATOLOGY', '101', '', '', '0.00', '', '400.00', '0.00', '69', 'pending'), 
('101', '2020-07-05', '2020-07-05', '00049', 'Widal Test', '', '14', '23', 'SEROLOGY', '201', '', '', '0.00', '', '400.00', '0.00', '69', 'pending'), 
('102', '2020-07-05', '2020-07-05', '00049', 'URINE_R_/_E', '', '14', '23', 'URINE_R./E', '201', '', '', '0.00', '', '150.00', '0.00', '69', 'pending'), 
('103', '2020-07-05', '2020-07-05', '00049', 'Whole Abdomen', '', '14', '23', 'DIGITAL ULTRASONOGRAPHY', '203', '', '', '0.00', '', '850.00', '0.00', '69', 'pending'), 
('104', '2020-07-05', '2020-07-05', '00050', 'DANTAL_X-RAY', '', '2', '24', 'DANTAL_X-RAY', '204', '', '', '0.00', '', '150.00', '0.00', '70', 'pending'), 
('105', '2020-07-05', '2020-07-05', '00051', 'URINE_R_/_E', '', '2', '23', 'URINE_R./E', '201', '', '', '0.00', '', '150.00', '0.00', '71', 'pending'), 
('106', '2020-07-05', '2020-07-05', '00051', 'Whole Abdomen', '', '2', '23', 'DIGITAL ULTRASONOGRAPHY', '203', '', '', '0.00', '', '850.00', '0.00', '71', 'pending'), 
('107', '2020-07-05', '2020-07-05', '00052', 'CBC', '', '2', '23', 'HAEMATOLOGY', '101', '', '', '0.00', '', '400.00', '0.00', '72', 'pending'), 
('108', '2020-07-05', '2020-07-05', '00052', 'RBS', '', '2', '23', 'BIOCHEMISTRY', '201', '', '', '0.00', '', '150.00', '0.00', '72', 'pending'), 
('109', '2020-07-05', '2020-07-05', '00052', 'S. Creatinine', '', '2', '23', 'BIOCHEMISTRY', '101', '', '', '0.00', '', '400.00', '0.00', '72', 'pending'), 
('110', '2020-07-05', '2020-07-05', '00052', 'URINE_R_/_E', '', '2', '23', 'URINE_R./E', '201', '', '', '0.00', '', '150.00', '0.00', '72', 'pending'), 
('111', '2020-07-05', '2020-07-05', '00052', 'Whole Abdomen', '', '2', '23', 'DIGITAL ULTRASONOGRAPHY', '203', '', '', '0.00', '', '850.00', '0.00', '72', 'pending'), 
('112', '2020-07-05', '2020-07-05', '00053', 'CBC', '', '2', '23', 'HAEMATOLOGY', '101', '', '', '0.00', '', '400.00', '0.00', '73', 'pending'), 
('113', '2020-07-05', '2020-07-05', '00053', 'R.Sugar', '', '2', '23', 'BIOCHEMISTRY', '201', '', '', '0.00', '', '150.00', '0.00', '73', 'pending'), 
('114', '2020-07-05', '2020-07-05', '00053', 'Widal Test', '', '2', '23', 'SEROLOGY', '201', '', '', '0.00', '', '400.00', '0.00', '73', 'pending'), 
('115', '2020-07-05', '2020-07-05', '00053', 'URINE_R_/_E', '', '2', '23', 'URINE_R./E', '201', '', '', '0.00', '', '150.00', '0.00', '73', 'pending'), 
('116', '2020-07-05', '2020-07-05', '00053', 'Whole Abdomen', '', '2', '23', 'DIGITAL ULTRASONOGRAPHY', '203', '', '', '0.00', '', '850.00', '0.00', '73', 'pending'), 
('117', '2020-07-05', '2020-07-05', '00054', 'CBC', '', '2', '23', 'HAEMATOLOGY', '101', '', '', '0.00', '', '400.00', '0.00', '74', 'pending'), 
('118', '2020-07-05', '2020-07-05', '00054', 'R.Sugar', '', '2', '23', 'BIOCHEMISTRY', '201', '', '', '0.00', '', '150.00', '0.00', '74', 'pending'), 
('119', '2020-07-05', '2020-07-05', '00054', 'ECG', '', '2', '23', 'ECG', '202', '', '', '0.00', '', '250.00', '0.00', '74', 'pending'), 
('120', '2020-07-05', '2020-07-05', '00054', 'Whole Abdomen', '', '2', '23', 'DIGITAL ULTRASONOGRAPHY', '203', '', '', '0.00', '', '850.00', '0.00', '74', 'pending'), 
('121', '2020-07-05', '2020-07-05', '00054', 'Chest P/A View', '', '2', '23', 'DIGITAL X-RAY', '204', '', '', '0.00', '', '250.00', '0.00', '74', 'pending'), 
('122', '2020-07-06', '2020-07-06', '00055', 'Chest P/A View', '', '20', '24', 'DIGITAL X-RAY', '204', '', '', '0.00', '', '250.00', '0.00', '75', 'pending'), 
('123', '2020-07-06', '2020-07-06', '00056', 'Whole Abdomen', '', '2', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '', '0.00', '', '850.00', '0.00', '76', 'pending'), 
('124', '2020-07-06', '2020-07-06', '00057', 'Pregnancy Test', '', '2', '24', 'URINE', '201', '', '', '0.00', '', '150.00', '0.00', '77', 'pending'), 
('125', '2020-07-06', '2020-07-06', '00058', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '', '0.00', '', '150.00', '0.00', '78', 'pending'), 
('132', '2020-07-06', '2020-07-06', '00060', 'Pregnancy Profile', '', '2', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '', '0.00', '', '850.00', '0.00', '80', 'pending'), 
('136', '2020-07-06', '2020-07-06', '00062', 'Sugar_2_HABF', '', '2', '24', 'BIOCHEMISTRY', '201', '', '', '0.00', '', '150.00', '0.00', '82', 'pending'), 
('151', '2020-07-06', '2020-07-06', '00067', 'Hb%_/ESR', '', '19', '23', 'HAEMATOLOGY', '201', '', '', '0.00', '', '300.00', '0.00', '87', 'pending'), 
('152', '2020-07-06', '2020-07-06', '00067', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '', '0.00', '', '150.00', '0.00', '87', 'pending'), 
('153', '2020-07-06', '2020-07-06', '00067', 'R/A Test', '', '19', '23', 'SEROLOGY', '201', '', '', '0.00', '', '400.00', '0.00', '87', 'pending'), 
('154', '2020-07-06', '2020-07-06', '00067', 'CRP', '', '19', '23', 'SEROLOGY', '201', '', '', '0.00', '', '650.00', '0.00', '87', 'pending'), 
('155', '2020-07-06', '2020-07-06', '00067', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '', '0.00', '', '650.00', '0.00', '87', 'pending'), 
('163', '2020-07-06', '2020-07-06', '00069', 'S. Bilirubin', '', '25', '24', 'BIOCHEMISTRY', '101', '', '', '0.00', '', '250.00', '0.00', '89', 'pending'), 
('164', '2020-07-06', '2020-07-06', '00069', 'Hbs Ag', '', '25', '24', 'SEROLOGY', '201', '', '', '0.00', '', '400.00', '0.00', '89', 'pending'), 
('165', '2020-07-06', '2020-07-06', '00070', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '', '0.00', '', '650.00', '0.00', '90', 'pending'), 
('166', '2020-07-06', '2020-07-06', '00071', '	Hb%_/ESR', '', '19', '23', 'HAEMATOLOGY', '201', '', '', '0.00', '', '300.00', '0.00', '91', 'pending'), 
('167', '2020-07-06', '2020-07-06', '00071', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '', '0.00', '', '150.00', '0.00', '91', 'pending'), 
('168', '2020-07-06', '2020-07-06', '00071', 'URINE_R_/_E', '', '19', '23', 'URINE_R./E', '201', '', '', '0.00', '', '150.00', '0.00', '91', 'pending'), 
('169', '2020-07-06', '2020-07-06', '00071', 'Lumbo-Sacral B.V', '', '19', '23', 'DIGITAL X-RAY', '204', '', '', '0.00', '', '500.00', '0.00', '91', 'pending'), 
('170', '2020-07-06', '2020-07-06', '00071', 'Chest P/A View', '', '19', '23', 'DIGITAL X-RAY', '204', '', '', '0.00', '', '250.00', '0.00', '91', 'pending'), 
('171', '2020-07-06', '2020-07-06', '00072', 'USG_F_/C', '', '20', '24', 'USG_COLOUR', '202', '', '', '0.00', '', '850.00', '0.00', '92', 'pending'), 
('172', '2020-07-06', '2020-07-06', '00073', 'USG_F_/C', '', '19', '24', 'USG_COLOUR', '202', '', '', '0.00', '', '850.00', '0.00', '93', 'pending'), 
('173', '2020-07-06', '2020-07-06', '00074', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '', '0.00', '', '150.00', '0.00', '94', 'pending'), 
('174', '2020-07-06', '2020-07-06', '00074', 'URINE_R_/_E', '', '19', '24', 'URINE_R./E', '201', '', '', '0.00', '', '150.00', '0.00', '94', 'pending'), 
('175', '2020-07-06', '2020-07-06', '00074', 'ECG', '', '19', '24', 'ECG', '202', '', '', '0.00', '', '250.00', '0.00', '94', 'pending'), 
('176', '2020-07-07', '2020-07-07', '00075', 'F.Sugar', '', '19', '24', 'BIOCHEMISTRY', '201', '', '', '0.00', '', '150.00', '0.00', '95', 'pending'), 
('177', '2020-07-07', '2020-07-07', '00076', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '', '0.00', '', '150.00', '0.00', '96', 'pending'), 
('178', '2020-07-07', '2020-07-07', '00077', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '', '0.00', '', '150.00', '0.00', '97', 'pending'), 
('179', '2020-07-07', '2020-07-07', '00078', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '', '0.00', '', '650.00', '0.00', '98', 'pending'), 
('180', '2020-07-07', '2020-07-07', '00079', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '', '0.00', '', '150.00', '0.00', '99', 'pending'), 
('183', '2020-07-07', '2020-07-07', '00080', 'Pregnancy Profile', '', '20', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '', '0.00', '', '850.00', '0.00', '101', 'pending'), 
('184', '2020-07-07', '2020-07-07', '00081', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '102', 'pending'), 
('195', '2020-07-07', '2020-07-07', '00087', 'USG_F_/C', '', '19', '24', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '108', 'pending'), 
('199', '2020-07-07', '2020-07-07', '00089', 'TPHA__T', '', '19', '23', 'SEROLOGY', '201', '', '17', '0.00', '', '400.00', '0.00', '110', 'pending'), 
('200', '2020-07-07', '2020-07-07', '00089', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '110', 'pending'), 
('201', '2020-07-07', '2020-07-07', '00089', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '110', 'pending'), 
('202', '2020-07-07', '2020-07-07', '00089', 'URINE_R_/_E', '', '19', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '110', 'pending'), 
('203', '2020-07-07', '2020-07-07', '00089', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '110', 'pending'), 
('204', '2020-07-07', '2020-07-07', '00090', 'PREGNANCY_PROFILE', '', '20', '23', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '111', 'pending'), 
('208', '2020-07-07', '2020-07-07', '00093', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '114', 'pending'), 
('209', '2020-07-07', '2020-07-07', '00093', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '114', 'pending'), 
('210', '2020-07-07', '2020-07-07', '00093', 'S.__ELECROLYTES', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '850.00', '0.00', '114', 'pending'), 
('211', '2020-07-07', '2020-07-07', '00093', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '114', 'pending'), 
('212', '2020-07-07', '2020-07-07', '00093', 'Whole Abdomen', '', '19', '23', 'DIGITAL ULTRASONOGRAPHY', '203', '', '17', '0.00', '', '850.00', '0.00', '114', 'pending'), 
('213', '2020-07-07', '2020-07-07', '00093', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '114', 'pending'), 
('214', '2020-07-07', '2020-07-07', '00094', 'PREGNANCY_PROFILE', '', '20', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '115', 'pending'), 
('217', '2020-07-07', '2020-07-07', '00096', 'Hb%', '', '20', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '117', 'pending'), 
('218', '2020-07-07', '2020-07-07', '00096', 'RBS', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '117', 'pending'), 
('219', '2020-07-07', '2020-07-07', '00096', 'URINE_R_/_E', '', '20', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '117', 'pending'), 
('220', '2020-07-07', '2020-07-07', '00096', 'ECG', '', '20', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '117', 'pending'), 
('221', '2020-07-07', '2020-07-07', '00096', 'U_S_G__W_/_A', '', '20', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '117', 'pending'), 
('222', '2020-07-07', '2020-07-07', '00096', 'Chest P/A View', '', '20', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '117', 'pending'), 
('224', '2020-07-08', '2020-07-08', '00098', 'F.SUGAR_/_SUGAR_2HABF_', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '300.00', '0.00', '119', 'pending'), 
('225', '2020-07-08', '2020-07-08', '00099', 'F.Sugar', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '120', 'pending'), 
('226', '2020-07-08', '2020-07-08', '00100', 'F.Sugar', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '121', 'pending'), 
('227', '2020-07-08', '2020-07-08', '00101', 'F.Sugar', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '122', 'pending'), 
('231', '2020-07-08', '2020-07-08', '00104', 'F.Sugar', '', '20', '26', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '125', 'pending'), 
('232', '2020-07-08', '2020-07-08', '00105', 'U_S_G__W_/_A', '', '20', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '126', 'pending'), 
('233', '2020-07-08', '2020-07-08', '00105', 'R/E M/E', '', '20', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '126', 'pending'), 
('234', '2020-07-08', '2020-07-08', '00106', 'R.Sugar', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '127', 'pending'), 
('236', '2020-07-08', '2020-07-08', '00108', 'SOFT_TISSUC_NECK', '', '20', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '129', 'pending'), 
('239', '2020-07-08', '2020-07-08', '00110', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '131', 'pending'), 
('240', '2020-07-08', '2020-07-08', '00110', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '131', 'pending'), 
('241', '2020-07-08', '2020-07-08', '00110', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '131', 'pending'), 
('242', '2020-07-08', '2020-07-08', '00111', 'PREGNANCY_PROFILE', '', '20', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '132', 'pending'), 
('243', '2020-07-08', '2020-07-08', '00112', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '133', 'pending'), 
('244', '2020-07-08', '2020-07-08', '00112', 'R.Sugar', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '133', 'pending'), 
('245', '2020-07-08', '2020-07-08', '00112', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '133', 'pending'), 
('246', '2020-07-08', '2020-07-08', '00112', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '133', 'pending'), 
('247', '2020-07-08', '2020-07-08', '00112', 'ECG', '', '19', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '133', 'pending'), 
('248', '2020-07-08', '2020-07-08', '00112', 'Chest P/A View', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '133', 'pending'), 
('249', '2020-07-08', '2020-07-08', '00113', 'CBC', '', '20', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '134', 'pending'), 
('250', '2020-07-08', '2020-07-08', '00113', 'R.Sugar', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '134', 'pending'), 
('251', '2020-07-08', '2020-07-08', '00113', 'URINE_R_/_E', '', '20', '24', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '134', 'pending'), 
('252', '2020-07-08', '2020-07-08', '00113', 'ECG', '', '20', '24', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '134', 'pending'), 
('253', '2020-07-08', '2020-07-08', '00113', 'Chest P/A View', '', '20', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '134', 'pending'), 
('254', '2020-07-08', '2020-07-08', '00114', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '135', 'pending'), 
('255', '2020-07-08', '2020-07-08', '00115', 'CBC', '', '20', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '136', 'pending'), 
('256', '2020-07-08', '2020-07-08', '00115', 'ECG', '', '20', '24', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '136', 'pending'), 
('257', '2020-07-08', '2020-07-08', '00116', 'CBC', '', '2', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '137', 'pending'), 
('258', '2020-07-08', '2020-07-08', '00116', 'RBS', '', '2', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '137', 'pending'), 
('259', '2020-07-08', '2020-07-08', '00116', 'Chest P/A View', '', '2', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '137', 'pending'), 
('260', '2020-07-08', '2020-07-08', '00117', 'Blood For Grouping', '', '20', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '138', 'pending'), 
('261', '2020-07-08', '2020-07-08', '00118', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '139', 'pending'), 
('262', '2020-07-08', '2020-07-08', '00119', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '140', 'pending'), 
('263', '2020-07-08', '2020-07-08', '00119', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '140', 'pending'), 
('264', '2020-07-08', '2020-07-08', '00119', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '140', 'pending'), 
('265', '2020-07-08', '2020-07-08', '00120', 'R/E M/E', '', '20', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '141', 'pending'), 
('266', '2020-07-08', '2020-07-08', '00120', 'RBS', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '141', 'pending'), 
('267', '2020-07-08', '2020-07-08', '00120', 'Hb%', '', '20', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '141', 'pending'), 
('268', '2020-07-08', '2020-07-08', '00120', 'PREGNANCY_PROFILE', '', '20', '23', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '141', 'pending'), 
('269', '2020-07-09', '2020-07-09', '00121', 'ECG', '', '19', '17', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '144', 'pending'), 
('270', '2020-07-09', '2020-07-09', '00121', 'ECG', '', '19', '17', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '144', 'pending'), 
('271', '2020-07-09', '2020-07-09', '00121', 'ECG', '', '19', '17', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '144', 'pending'), 
('272', '2020-07-09', '2020-07-09', '00122', 'CBC', '', '13', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '145', 'pending'), 
('273', '2020-07-09', '2020-07-09', '00122', 'RBS', '', '13', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '145', 'pending'), 
('274', '2020-07-09', '2020-07-09', '00122', 'S. Creatinine', '', '13', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '145', 'pending'), 
('275', '2020-07-09', '2020-07-09', '00122', 'URINE_R_/_E', '', '13', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '145', 'pending'), 
('276', '2020-07-09', '2020-07-09', '00122', 'Whole Abdomen', '', '13', '23', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '145', 'pending'), 
('277', '2020-07-09', '2020-07-09', '00122', 'Hb%', '', '13', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '145', 'pending'), 
('278', '2020-07-09', '2020-07-09', '00123', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '146', 'pending'), 
('279', '2020-07-09', '2020-07-09', '00124', 'CBC', '', '19', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '147', 'pending'), 
('280', '2020-07-09', '2020-07-09', '00124', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '147', 'pending'), 
('281', '2020-07-09', '2020-07-09', '00124', 'S. Creatinine', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '147', 'pending'), 
('282', '2020-07-09', '2020-07-09', '00124', 'ECG', '', '19', '24', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '147', 'pending'), 
('283', '2020-07-09', '2020-07-09', '00124', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '147', 'pending'), 
('284', '2020-07-09', '2020-07-09', '00124', 'Chest P/A View', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '147', 'pending'), 
('286', '2020-07-09', '2020-07-09', '00126', 'URINE_R_/_E', '', '19', '24', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '149', 'pending'), 
('291', '2020-07-09', '2020-07-09', '00128', 'U_S_G__W_/_A', '', '20', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '153', 'pending'), 
('292', '2020-07-09', '2020-07-09', '00128', 'RBS', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '153', 'pending'), 
('293', '2020-07-09', '2020-07-09', '00129', 'RBS', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '154', 'pending'), 
('294', '2020-07-09', '2020-07-09', '00130', 'Sugar_2_HABF', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '155', 'pending'), 
('295', '2020-07-09', '2020-07-09', '00131', 'CBC', '', '20', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '156', 'pending'), 
('296', '2020-07-09', '2020-07-09', '00131', '2Hour After 75 Gram, Glucose', '', '20', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '300.00', '0.00', '156', 'pending'), 
('297', '2020-07-09', '2020-07-09', '00131', 'Hbs Ag', '', '20', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '156', 'pending'), 
('298', '2020-07-09', '2020-07-09', '00131', 'Blood For Grouping', '', '20', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '156', 'pending'), 
('299', '2020-07-09', '2020-07-09', '00131', 'Whole Abdomen', '', '20', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '156', 'pending'), 
('300', '2020-07-09', '2020-07-09', '00131', 'URINE_R_/_E', '', '20', '24', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '156', 'pending'), 
('301', '2020-07-10', '2020-07-10', '00132', 'PREGNANCY_PROFILE', '', '20', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '157', 'pending'), 
('302', '2020-07-10', '2020-07-10', '00133', 'F.SUGAR_/_SUGAR_2HABF_', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '300.00', '0.00', '158', 'pending'), 
('303', '2020-07-10', '2020-07-10', '00134', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '159', 'pending'), 
('304', '2020-07-10', '2020-07-10', '00134', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '159', 'pending'), 
('305', '2020-07-10', '2020-07-10', '00134', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '159', 'pending'), 
('306', '2020-07-10', '2020-07-10', '00135', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '160', 'pending'), 
('307', '2020-07-10', '2020-07-10', '00135', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '160', 'pending'), 
('308', '2020-07-10', '2020-07-10', '00135', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '160', 'pending'), 
('309', '2020-07-10', '2020-07-10', '00136', 'U_S_G__W_/_A', '', '20', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '161', 'pending'), 
('310', '2020-07-10', '2020-07-10', '00137', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '162', 'pending'), 
('311', '2020-07-10', '2020-07-10', '00137', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '162', 'pending'), 
('312', '2020-07-10', '2020-07-10', '00138', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '163', 'pending'), 
('313', '2020-07-10', '2020-07-10', '00139', 'RBS', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '164', 'pending'), 
('314', '2020-07-10', '2020-07-10', '00140', 'Whole Abdomen', '', '19', '19', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '165', 'pending'), 
('315', '2020-07-10', '2020-07-10', '00141', 'CBC', '', '19', '19', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '166', 'pending'), 
('316', '2020-07-10', '2020-07-10', '00141', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '166', 'pending'), 
('317', '2020-07-10', '2020-07-10', '00141', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '166', 'pending'), 
('318', '2020-07-10', '2020-07-10', '00141', 'U_S_G__W_/_A', '', '19', '19', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '166', 'pending'), 
('319', '2020-07-10', '2020-07-10', '00141', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '166', 'pending'), 
('320', '2020-07-10', '2020-07-10', '00142', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '167', 'pending'), 
('321', '2020-07-10', '2020-07-10', '00143', 'URINE_R_/_E', '', '19', '24', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '168', 'pending'), 
('322', '2020-07-10', '2020-07-10', '00143', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '168', 'pending'), 
('323', '2020-07-10', '2020-07-10', '00144', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '169', 'pending'), 
('324', '2020-07-10', '2020-07-10', '00145', 'ESR', '', '20', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '170', 'pending'), 
('325', '2020-07-10', '2020-07-10', '00145', 'S.G.P.T.(ALT)', '', '20', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '170', 'pending'), 
('326', '2020-07-10', '2020-07-10', '00145', 'S. Bilirubin', '', '20', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '170', 'pending'), 
('327', '2020-07-10', '2020-07-10', '00145', 'Chest P/A View', '', '20', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '170', 'pending'), 
('328', '2020-07-10', '2020-07-10', '00146', 'ECG', '', '20', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '171', 'pending'), 
('329', '2020-07-10', '2020-07-10', '00147', 'M.T_MAN_TOUX)', '', '19', '19', 'M.T_MAN_TOUX)', '201', '', '0', '0.00', '', '400.00', '0.00', '172', 'pending'), 
('330', '2020-07-10', '2020-07-10', '00148', 'RBS', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '173', 'pending'), 
('331', '2020-07-10', '2020-07-10', '00148', 'URINE_R_/_E', '', '20', '24', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '173', 'pending'), 
('332', '2020-07-10', '2020-07-10', '00148', 'ECG', '', '20', '24', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '173', 'pending'), 
('333', '2020-07-10', '2020-07-10', '00148', 'Whole Abdomen', '', '20', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '173', 'pending'), 
('334', '2020-07-10', '2020-07-10', '00148', 'Chest P/A View', '', '20', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '173', 'pending'), 
('335', '2020-07-10', '2020-07-10', '00149', 'U_S_G__W_/_A', '', '19', '19', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '174', 'pending'), 
('336', '2020-07-10', '2020-07-10', '00150', 'U_S_G__W_/_A', '', '19', '19', '', '', '', '0', '0.00', '', '0.00', '0.00', '175', 'pending'), 
('337', '2020-07-10', '2020-07-10', '00151', 'S.G.P.T.(ALT)', '', '19', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '176', 'pending'), 
('338', '2020-07-10', '2020-07-10', '00151', 'S. Creatinine', '', '19', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '176', 'pending'), 
('339', '2020-07-10', '2020-07-10', '00151', 'U_S_G__W_/_A', '', '19', '19', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '176', 'pending'), 
('340', '2020-07-10', '2020-07-10', '00152', 'RBS', '', '20', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '177', 'pending'), 
('341', '2020-07-10', '2020-07-10', '00152', 'W_/_A', '', '20', '19', 'U_S_G_', '202', '', '0', '0.00', '', '750.00', '0.00', '177', 'pending'), 
('342', '2020-07-10', '2020-07-10', '00153', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '178', 'pending'), 
('343', '2020-07-10', '2020-07-10', '00153', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '178', 'pending'), 
('344', '2020-07-10', '2020-07-10', '00154', 'L/S_A/P', '', '20', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '179', 'pending'), 
('345', '2020-07-10', '2020-07-10', '00155', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '180', 'pending'), 
('346', '2020-07-10', '2020-07-10', '00155', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '180', 'pending'), 
('347', '2020-07-12', '2020-07-12', '00156', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '181', 'pending'), 
('348', '2020-07-12', '2020-07-12', '00157', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '182', 'pending'), 
('349', '2020-07-12', '2020-07-12', '00157', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '182', 'pending'), 
('350', '2020-07-12', '2020-07-12', '00157', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '182', 'pending'), 
('351', '2020-07-12', '2020-07-12', '00157', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '182', 'pending'), 
('352', '2020-07-12', '2020-07-12', '00157', 'Whole Abdomen', '', '19', '23', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '182', 'pending'), 
('353', '2020-07-12', '2020-07-12', '00157', 'ECG', '', '19', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '182', 'pending'), 
('354', '2020-07-12', '2020-07-12', '00157', 'URINE_R_/_E', '', '19', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '182', 'pending'), 
('355', '2020-07-12', '2020-07-12', '00158', 'PREGNANCY_PROFILE', '', '20', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '183', 'pending'), 
('356', '2020-07-12', '2020-07-12', '00159', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '184', 'pending'), 
('357', '2020-07-12', '2020-07-12', '00160', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '185', 'pending'), 
('358', '2020-07-12', '2020-07-12', '00161', 'X-RAY_LEFT_LEG_B/V', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '186', 'pending'), 
('359', '2020-07-12', '2020-07-12', '00162', 'PREGNANCY_PROFILE', '', '20', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '187', 'pending'), 
('360', '2020-07-12', '2020-07-12', '00163', 'CBC', '', '20', '25', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '188', 'pending'), 
('361', '2020-07-12', '2020-07-12', '00163', 'RBS', '', '20', '25', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '188', 'pending'), 
('362', '2020-07-12', '2020-07-12', '00163', 'Blood For Grouping', '', '20', '25', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '188', 'pending'), 
('363', '2020-07-12', '2020-07-12', '00163', 'URINE_R_/_E', '', '20', '25', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '188', 'pending'), 
('364', '2020-07-12', '2020-07-12', '00163', 'U_S_G__W_/_A', '', '20', '25', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '188', 'pending'), 
('365', '2020-07-12', '2020-07-12', '00164', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '189', 'pending'), 
('366', '2020-07-12', '2020-07-12', '00164', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '189', 'pending'), 
('367', '2020-07-12', '2020-07-12', '00164', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '189', 'pending'), 
('368', '2020-07-12', '2020-07-12', '00165', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '190', 'pending'), 
('369', '2020-07-12', '2020-07-12', '00165', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '190', 'pending'), 
('370', '2020-07-12', '2020-07-12', '00165', 'URINE_R_/_E', '', '19', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '190', 'pending'), 
('371', '2020-07-12', '2020-07-12', '00165', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '190', 'pending'), 
('372', '2020-07-12', '2020-07-12', '00166', 'PREGNANCY_PROFILE', '', '20', '23', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '191', 'pending'), 
('373', '2020-07-12', '2020-07-12', '00167', 'Pregnancy Test', '', '20', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '192', 'pending'), 
('374', '2020-07-12', '2020-07-12', '00168', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '193', 'pending'), 
('375', '2020-07-12', '2020-07-12', '00168', 'URINE_R_/_E', '', '19', '24', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '193', 'pending'), 
('376', '2020-07-12', '2020-07-12', '00169', 'Hb%', '', '19', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '194', 'pending'), 
('377', '2020-07-12', '2020-07-12', '00169', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '194', 'pending'), 
('378', '2020-07-12', '2020-07-12', '00170', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '195', 'pending'), 
('379', '2020-07-13', '2020-07-13', '00171', 'F.SUGAR_/_SUGAR_2HABF_', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '300.00', '0.00', '196', 'pending'), 
('380', '2020-07-13', '2020-07-13', '00172', 'USG_F_/C', '', '19', '24', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '197', 'pending'), 
('381', '2020-07-13', '2020-07-13', '00173', 'USG_F_/C', '', '20', '24', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '198', 'pending'), 
('382', '2020-07-13', '2020-07-13', '00174', 'CBC', '', '20', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '199', 'pending'), 
('383', '2020-07-13', '2020-07-13', '00174', 'R.Sugar', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '199', 'pending'), 
('384', '2020-07-13', '2020-07-13', '00174', 'S. Creatinine', '', '20', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '199', 'pending'), 
('385', '2020-07-13', '2020-07-13', '00174', 'URINE_R_/_E', '', '20', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '199', 'pending'), 
('386', '2020-07-13', '2020-07-13', '00174', 'U_S_G__W_/_A', '', '20', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '199', 'pending'), 
('387', '2020-07-13', '2020-07-13', '00175', 'Pregnancy Test', '', '20', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '200', 'pending'), 
('388', '2020-07-13', '2020-07-13', '00176', 'Hb%', '', '19', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '201', 'pending'), 
('389', '2020-07-13', '2020-07-13', '00176', 'ESR', '', '19', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '201', 'pending'), 
('390', '2020-07-13', '2020-07-13', '00176', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '201', 'pending'), 
('391', '2020-07-13', '2020-07-13', '00176', 'ECG', '', '19', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '201', 'pending'), 
('392', '2020-07-13', '2020-07-13', '00176', 'Chest P/A View', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '201', 'pending'), 
('393', '2020-07-13', '2020-07-13', '00177', 'Sugar_2_HABF', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '202', 'pending'), 
('394', '2020-07-13', '2020-07-13', '00178', 'Hb%', '', '19', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '203', 'pending'), 
('395', '2020-07-13', '2020-07-13', '00178', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '203', 'pending'), 
('396', '2020-07-13', '2020-07-13', '00179', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '204', 'pending'), 
('397', '2020-07-13', '2020-07-13', '00180', '	Hb%_/ESR', '', '19', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '205', 'pending'), 
('398', '2020-07-13', '2020-07-13', '00180', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '205', 'pending'), 
('399', '2020-07-13', '2020-07-13', '00180', 'Widal Test', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '205', 'pending'), 
('400', '2020-07-13', '2020-07-13', '00180', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '205', 'pending'), 
('401', '2020-07-13', '2020-07-13', '00181', 'Pregnancy Profile', '', '19', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '206', 'pending'), 
('402', '2020-07-13', '2020-07-13', '00182', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '207', 'pending'), 
('403', '2020-07-13', '2020-07-13', '00183', 'USG_F_/C', '', '20', '24', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '208', 'pending'), 
('404', '2020-07-13', '2020-07-13', '00184', 'Widal Test', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '209', 'pending'), 
('405', '2020-07-13', '2020-07-13', '00185', 'S. Creatinine', '', '20', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '210', 'pending'), 
('406', '2020-07-13', '2020-07-13', '00185', 'URINE_R_/_E', '', '20', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '210', 'pending'), 
('407', '2020-07-13', '2020-07-13', '00186', 'Hb%', '', '20', '20', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '211', 'pending'), 
('408', '2020-07-13', '2020-07-13', '00186', 'RBS', '', '20', '20', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '211', 'pending'), 
('409', '2020-07-13', '2020-07-13', '00186', 'V.D.R.L', '', '20', '20', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '211', 'pending'), 
('410', '2020-07-13', '2020-07-13', '00186', 'URINE_R_/_E', '', '20', '20', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '211', 'pending'), 
('411', '2020-07-13', '2020-07-13', '00186', 'USG_F_/C', '', '20', '20', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '211', 'pending'), 
('412', '2020-07-13', '2020-07-13', '00187', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '212', 'pending'), 
('413', '2020-07-13', '2020-07-13', '00188', '	Hb%_/ESR', '', '19', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '213', 'pending'), 
('414', '2020-07-13', '2020-07-13', '00188', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '213', 'pending'), 
('415', '2020-07-13', '2020-07-13', '00188', 'URINE_R_/_E', '', '19', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '213', 'pending'), 
('416', '2020-07-13', '2020-07-13', '00188', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '213', 'pending'), 
('417', '2020-07-13', '2020-07-13', '00189', 'CBC', '', '19', '20', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '214', 'pending'), 
('418', '2020-07-13', '2020-07-13', '00189', 'RBS', '', '19', '20', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '214', 'pending'), 
('419', '2020-07-13', '2020-07-13', '00189', 'V.D.R.L', '', '19', '20', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '214', 'pending'), 
('420', '2020-07-13', '2020-07-13', '00189', 'URINE_R_/_E', '', '19', '20', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '214', 'pending'), 
('421', '2020-07-13', '2020-07-13', '00189', 'U_S_G__W_/_A', '', '19', '20', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '214', 'pending'), 
('422', '2020-07-13', '2020-07-13', '00190', 'ESR', '', '20', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '215', 'pending'), 
('423', '2020-07-13', '2020-07-13', '00190', 'R.Sugar', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '215', 'pending'), 
('424', '2020-07-13', '2020-07-13', '00190', 'S. Creatinine', '', '20', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '215', 'pending'), 
('425', '2020-07-13', '2020-07-13', '00190', 'ECG', '', '20', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '215', 'pending'), 
('426', '2020-07-13', '2020-07-13', '00190', 'Chest P/A View', '', '20', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '215', 'pending'), 
('427', '2020-07-13', '2020-07-13', '00191', 'URINE_R_/_E', '', '19', '20', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '216', 'pending'), 
('428', '2020-07-13', '2020-07-13', '00191', 'USG_F_/C', '', '19', '20', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '216', 'pending'), 
('429', '2020-07-13', '2020-07-13', '00192', 'URINE_R_/_E', '', '19', '20', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '217', 'pending'), 
('430', '2020-07-13', '2020-07-13', '00192', 'U_S_G__W_/_A', '', '19', '20', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '217', 'pending'), 
('431', '2020-07-13', '2020-07-13', '00193', 'ECG', '', '19', '24', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '218', 'pending'), 
('432', '2020-07-13', '2020-07-13', '00194', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '219', 'pending'), 
('433', '2020-07-13', '2020-07-13', '00195', 'CBC', '', '19', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '220', 'pending'), 
('434', '2020-07-13', '2020-07-13', '00195', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '220', 'pending'), 
('435', '2020-07-13', '2020-07-13', '00195', 'Widal Test', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '220', 'pending'), 
('436', '2020-07-13', '2020-07-13', '00196', 'PREGNANCY_PROFILE', '', '10', '23', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '221', 'pending'), 
('444', '2020-07-14', '2020-07-14', '00198', 'F.Sugar', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '223', 'pending'), 
('445', '2020-07-14', '2020-07-14', '00199', 'PREGNANCY_PROFILE', '', '10', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '224', 'pending'), 
('446', '2020-07-14', '2020-07-14', '00200', 'PREGNANCY_PROFILE', '', '10', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '225', 'pending'), 
('447', '2020-07-14', '2020-07-14', '00201', 'CBC', '', '20', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '226', 'pending'), 
('448', '2020-07-14', '2020-07-14', '00201', 'RBS', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '226', 'pending'), 
('449', '2020-07-14', '2020-07-14', '00201', 'S. Creatinine', '', '20', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '226', 'pending'), 
('450', '2020-07-14', '2020-07-14', '00201', 'Whole Abdomen', '', '20', '23', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '226', 'pending'), 
('451', '2020-07-14', '2020-07-14', '00201', 'URINE_R_/_E', '', '20', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '226', 'pending'), 
('452', '2020-07-14', '2020-07-14', '00201', 'X-RAY_LEFT_LEG_B/V', '', '20', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '226', 'pending'), 
('453', '2020-07-14', '2020-07-14', '00202', 'Pregnancy Profile', '', '19', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '227', 'pending'), 
('454', '2020-07-14', '2020-07-14', '00203', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '228', 'pending'), 
('467', '2020-07-14', '2020-07-14', '00206', 'CBC', '', '20', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '231', 'pending'), 
('468', '2020-07-14', '2020-07-14', '00206', 'RBS', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '231', 'pending'), 
('469', '2020-07-14', '2020-07-14', '00206', 'Widal Test', '', '20', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '231', 'pending'), 
('470', '2020-07-14', '2020-07-14', '00206', 'URINE_R_/_E', '', '20', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '231', 'pending'), 
('471', '2020-07-14', '2020-07-14', '00206', 'ECG', '', '20', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '231', 'pending'), 
('472', '2020-07-14', '2020-07-14', '00206', 'U_S_G__W_/_A', '', '20', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '231', 'pending'), 
('473', '2020-07-14', '2020-07-14', '00206', 'Chest P/A View', '', '20', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '231', 'pending'), 
('474', '2020-07-14', '2020-07-14', '00207', 'CBC', '', '20', '20', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '232', 'pending'), 
('475', '2020-07-14', '2020-07-14', '00207', 'V.D.R.L', '', '20', '20', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '232', 'pending'), 
('476', '2020-07-14', '2020-07-14', '00207', 'URINE_R_/_E', '', '20', '20', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '232', 'pending'), 
('477', '2020-07-14', '2020-07-14', '00207', 'Pregnancy Test', '', '20', '20', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '232', 'pending'), 
('478', '2020-07-14', '2020-07-14', '00207', 'USG_F_/C', '', '20', '20', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '232', 'pending'), 
('481', '2020-07-14', '2020-07-14', '00209', 'ECG', '', '20', '24', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '234', 'pending'), 
('482', '2020-07-14', '2020-07-14', '00209', 'U_S_G__W_/_A', '', '20', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '234', 'pending'), 
('483', '2020-07-14', '2020-07-14', '00210', 'PREGNANCY_PROFILE', '', '20', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '235', 'pending'), 
('498', '2020-07-15', '2020-07-15', '00214', 'F.Sugar', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '239', 'pending'), 
('499', '2020-07-15', '2020-07-15', '00215', 'Sugar_2_HABF', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '240', 'pending'), 
('500', '2020-07-15', '2020-07-15', '00216', 'F.Sugar', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '241', 'pending'), 
('501', '2020-07-15', '2020-07-15', '00217', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '242', 'pending'), 
('502', '2020-07-15', '2020-07-15', '00218', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '243', 'pending'), 
('503', '2020-07-15', '2020-07-15', '00219', 'Sugar_2_HABF', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '244', 'pending'), 
('504', '2020-07-15', '2020-07-15', '00220', 'U_S_G__W_/_A', '', '20', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '245', 'pending'), 
('505', '2020-07-15', '2020-07-15', '00220', 'L/S_A/P', '', '20', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '245', 'pending'), 
('506', '2020-07-15', '2020-07-15', '00221', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '246', 'pending'), 
('507', '2020-07-15', '2020-07-15', '00221', 'X-RAY_LEFT_LEG_B/V', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '246', 'pending'), 
('508', '2020-07-15', '2020-07-15', '00221', 'Chest P/A View', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '246', 'pending'), 
('509', '2020-07-15', '2020-07-15', '00222', 'CBC', '', '10', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '247', 'pending'), 
('510', '2020-07-15', '2020-07-15', '00222', 'S. Creatinine', '', '10', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '247', 'pending'), 
('511', '2020-07-15', '2020-07-15', '00222', 'URINE_R_/_E', '', '10', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '247', 'pending'), 
('512', '2020-07-15', '2020-07-15', '00222', 'ECG', '', '10', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '247', 'pending'), 
('513', '2020-07-15', '2020-07-15', '00222', 'U_S_G__W_/_A', '', '10', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '247', 'pending'), 
('514', '2020-07-15', '2020-07-15', '00223', 'USG_F_/C', '', '10', '23', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '248', 'pending'), 
('515', '2020-07-16', '2020-07-16', '00224', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '249', 'pending'), 
('516', '2020-07-16', '2020-07-16', '00224', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '249', 'pending'), 
('517', '2020-07-16', '2020-07-16', '00224', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '249', 'pending'), 
('518', '2020-07-16', '2020-07-16', '00224', 'Chest P/A View', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '249', 'pending'), 
('519', '2020-07-16', '2020-07-16', '00224', 'URINE_R_/_E', '', '19', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '249', 'pending'), 
('520', '2020-07-16', '2020-07-16', '00225', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '250', 'pending'), 
('521', '2020-07-16', '2020-07-16', '00225', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '250', 'pending'), 
('522', '2020-07-16', '2020-07-16', '00226', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '251', 'pending'), 
('523', '2020-07-16', '2020-07-16', '00227', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '252', 'pending'), 
('524', '2020-07-16', '2020-07-16', '00227', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '252', 'pending'), 
('525', '2020-07-16', '2020-07-16', '00227', 'URINE_R_/_E', '', '19', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '252', 'pending'), 
('526', '2020-07-16', '2020-07-16', '00227', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '252', 'pending'), 
('527', '2020-07-16', '2020-07-16', '00227', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '252', 'pending'), 
('528', '2020-07-16', '2020-07-16', '00227', 'ECG', '', '19', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '252', 'pending'), 
('529', '2020-07-16', '2020-07-16', '00227', 'Chest P/A View', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '252', 'pending'), 
('530', '2020-07-16', '2020-07-16', '00228', 'PREGNANCY_PROFILE', '', '19', '26', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '253', 'pending'), 
('531', '2020-07-16', '2020-07-16', '00228', 'Hb%', '', '19', '26', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '253', 'pending'), 
('532', '2020-07-16', '2020-07-16', '00228', 'Blood For Grouping', '', '19', '26', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '253', 'pending'), 
('533', '2020-07-16', '2020-07-16', '00229', 'ESR', '', '20', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '254', 'pending'), 
('534', '2020-07-16', '2020-07-16', '00229', 'RBS', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '254', 'pending'), 
('535', '2020-07-16', '2020-07-16', '00229', 'Widal Test', '', '20', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '254', 'pending'), 
('536', '2020-07-16', '2020-07-16', '00229', 'URINE_R_/_E', '', '20', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '254', 'pending'), 
('537', '2020-07-16', '2020-07-16', '00229', 'Chest P/A View', '', '20', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '254', 'pending'), 
('538', '2020-07-16', '2020-07-16', '00230', 'PREGNANCY_PROFILE', '', '20', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '255', 'pending'), 
('539', '2020-07-16', '2020-07-16', '00231', 'CBC', '', '20', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '256', 'pending'), 
('540', '2020-07-16', '2020-07-16', '00231', 'URINE_R_/_E', '', '20', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '256', 'pending'), 
('541', '2020-07-16', '2020-07-16', '00231', 'L/S_A/P', '', '20', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '256', 'pending'), 
('542', '2020-07-16', '2020-07-16', '00232', 'ESR', '', '19', '25', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '257', 'pending'), 
('543', '2020-07-16', '2020-07-16', '00232', 'Widal Test', '', '19', '25', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '257', 'pending'), 
('544', '2020-07-16', '2020-07-16', '00232', 'URINE_R_/_E', '', '19', '25', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '257', 'pending'), 
('545', '2020-07-16', '2020-07-16', '00233', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '258', 'pending'), 
('546', '2020-07-16', '2020-07-16', '00233', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '258', 'pending'), 
('547', '2020-07-16', '2020-07-16', '00233', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '258', 'pending'), 
('548', '2020-07-16', '2020-07-16', '00233', 'URINE_R_/_E', '', '19', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '258', 'pending'), 
('549', '2020-07-16', '2020-07-16', '00233', 'Chest P/A View', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '258', 'pending'), 
('550', '2020-07-16', '2020-07-16', '00234', 'PREGNANCY_PROFILE', '', '29', '25', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '259', 'pending'), 
('551', '2020-07-16', '2020-07-16', '00235', 'W_/_A', '', '27', '28', 'U_S_G_', '202', '', '0', '0.00', '', '750.00', '0.00', '260', 'pending'), 
('552', '2020-07-16', '2020-07-16', '00236', 'PREGNANCY_PROFILE', '', '10', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '261', 'pending'), 
('553', '2020-07-16', '2020-07-16', '00237', 'USG_F_/C', '', '19', '24', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '262', 'pending'), 
('554', '2020-07-16', '2020-07-16', '00238', 'USG_F/C', '', '20', '24', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '263', 'pending'), 
('555', '2020-07-16', '2020-07-16', '00239', 'RBS', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '264', 'pending'), 
('556', '2020-07-16', '2020-07-16', '00239', 'S. Creatinine', '', '20', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '264', 'pending'), 
('557', '2020-07-16', '2020-07-16', '00239', 'URINE_R_/_E', '', '20', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '264', 'pending'), 
('558', '2020-07-16', '2020-07-16', '00239', 'U_S_G__W_/_A', '', '20', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '264', 'pending'), 
('559', '2020-07-16', '2020-07-16', '00239', 'Chest P/A View', '', '20', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '264', 'pending'), 
('560', '2020-07-16', '2020-07-16', '00240', 'Chest P/A View', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '265', 'pending'), 
('561', '2020-07-16', '2020-07-16', '00241', 'RBS', '', '27', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '266', 'pending'), 
('562', '2020-07-16', '2020-07-16', '00241', 'URINE_R_/_E', '', '27', '24', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '266', 'pending'), 
('563', '2020-07-16', '2020-07-16', '00241', 'U_S_G__W_/_A', '', '27', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '266', 'pending'), 
('564', '2020-07-16', '2020-07-16', '00242', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '267', 'pending'), 
('565', '2020-07-17', '2020-07-17', '00243', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '268', 'pending'), 
('566', '2020-07-17', '2020-07-17', '00244', 'USG_F_/C', '', '19', '24', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '269', 'pending'), 
('567', '2020-07-17', '2020-07-17', '00245', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '271', 'pending'), 
('568', '2020-07-17', '2020-07-17', '00246', 'S. Creatinine', '', '20', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '272', 'pending'), 
('569', '2020-07-17', '2020-07-17', '00247', 'CBC', '', '20', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '273', 'pending'), 
('570', '2020-07-17', '2020-07-17', '00247', 'MT Tuberculin Test', '', '20', '23', 'OTHERS', '201', '', '0', '0.00', '', '350.00', '0.00', '273', 'pending'), 
('571', '2020-07-17', '2020-07-17', '00247', 'URINE_R_/_E', '', '20', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '273', 'pending'), 
('572', '2020-07-17', '2020-07-17', '00247', 'U_S_G__W_/_A', '', '20', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '273', 'pending'), 
('573', '2020-07-17', '2020-07-17', '00247', 'Chest P/A View', '', '20', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '273', 'pending'), 
('581', '2020-07-17', '2020-07-17', '00249', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '275', 'pending'), 
('582', '2020-07-17', '2020-07-17', '00249', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '275', 'pending'), 
('583', '2020-07-17', '2020-07-17', '00249', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '275', 'pending'), 
('584', '2020-07-17', '2020-07-17', '00249', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '275', 'pending'), 
('585', '2020-07-17', '2020-07-17', '00249', 'URINE_R_/_E', '', '19', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '275', 'pending'), 
('586', '2020-07-17', '2020-07-17', '00249', 'L/S_A/P', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '275', 'pending'), 
('587', '2020-07-17', '2020-07-17', '00250', 'CBC', '', '32', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '276', 'pending'), 
('588', '2020-07-17', '2020-07-17', '00250', 'RBS', '', '32', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '276', 'pending'), 
('589', '2020-07-17', '2020-07-17', '00250', 'Widal Test', '', '32', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '276', 'pending'), 
('590', '2020-07-17', '2020-07-17', '00250', 'URINE_R_/_E', '', '32', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '276', 'pending'), 
('591', '2020-07-17', '2020-07-17', '00250', 'U_S_G__W_/_A', '', '32', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '276', 'pending'), 
('592', '2020-07-17', '2020-07-17', '00250', 'KNEE_JOIBT_B/V_FOOT_B/V', '', '32', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '276', 'pending'), 
('593', '2020-07-17', '2020-07-17', '00250', 'KNEE_JOIBT_B/V_FOOT_B/V', '', '32', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '276', 'pending'), 
('594', '2020-07-17', '2020-07-17', '00251', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '277', 'pending'), 
('595', '2020-07-17', '2020-07-17', '00251', 'S. Bilirubin', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '277', 'pending'), 
('596', '2020-07-17', '2020-07-17', '00251', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '277', 'pending'), 
('597', '2020-07-17', '2020-07-17', '00251', 'URINE_R_/_E', '', '19', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '277', 'pending'), 
('598', '2020-07-17', '2020-07-17', '00252', 'CBC', '', '31', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '278', 'pending'), 
('599', '2020-07-17', '2020-07-17', '00252', 'RBS', '', '31', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '278', 'pending'), 
('600', '2020-07-17', '2020-07-17', '00252', 'S. Creatinine', '', '31', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '278', 'pending'), 
('601', '2020-07-17', '2020-07-17', '00252', 'S Uric Acid', '', '31', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '650.00', '0.00', '278', 'pending'), 
('602', '2020-07-17', '2020-07-17', '00252', 'URINE_R_/_E', '', '31', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '278', 'pending'), 
('603', '2020-07-17', '2020-07-17', '00252', 'U_S_G__W_/_A', '', '31', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '278', 'pending'), 
('604', '2020-07-17', '2020-07-17', '00253', 'PREGNANCY_PROFILE', '', '20', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '279', 'pending'), 
('605', '2020-07-17', '2020-07-17', '00254', 'URINE_R_/_E', '', '19', '24', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '280', 'pending'), 
('606', '2020-07-17', '2020-07-17', '00255', 'CBC', '', '19', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '281', 'pending'), 
('607', '2020-07-17', '2020-07-17', '00255', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '281', 'pending'), 
('608', '2020-07-17', '2020-07-17', '00255', 'S. Creatinine', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '281', 'pending'), 
('609', '2020-07-17', '2020-07-17', '00255', 'URINE_R_/_E', '', '19', '24', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '281', 'pending'), 
('610', '2020-07-17', '2020-07-17', '00255', 'ECG', '', '19', '24', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '281', 'pending'), 
('611', '2020-07-17', '2020-07-17', '00255', 'Chest P/A View', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '281', 'pending'), 
('612', '2020-07-18', '2020-07-18', '00256', 'USG_F/C', '', '19', '24', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '282', 'pending'), 
('613', '2020-07-18', '2020-07-18', '00257', 'USG_F_/C', '', '19', '24', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '283', 'pending'), 
('614', '2020-07-18', '2020-07-18', '00258', 'Sugar_2_HABF', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '284', 'pending'), 
('615', '2020-07-18', '2020-07-18', '00259', 'USG_F/C', '', '32', '24', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '285', 'pending'), 
('616', '2020-07-18', '2020-07-18', '00260', 'Lipid Profile', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '1200.00', '0.00', '286', 'pending'), 
('617', '2020-07-18', '2020-07-18', '00261', 'PREGNANCY_PROFILE', '', '20', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '287', 'pending'), 
('618', '2020-07-18', '2020-07-18', '00262', 'USG_F_/C', '', '19', '24', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '288', 'pending'), 
('619', '2020-07-18', '2020-07-18', '00263', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '289', 'pending'), 
('620', '2020-07-18', '2020-07-18', '00263', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '289', 'pending'), 
('621', '2020-07-18', '2020-07-18', '0281', 'S. Creatinine', '', '19', '31', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '291', 'pending'), 
('622', '2020-07-18', '2020-07-18', '0281', 'URINE_R_/_E', '', '19', '31', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '291', 'pending'), 
('623', '2020-07-18', '2020-07-18', '0281', 'U_S_G__W_/_A', '', '19', '31', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '291', 'pending'), 
('624', '2020-07-18', '2020-07-18', '00264', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '293', 'pending'), 
('626', '2020-07-19', '2020-07-19', '00266', 'Hbs Ag', '', '20', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '295', 'pending'), 
('627', '2020-07-19', '2020-07-19', '00267', 'S. Creatinine', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '296', 'pending'), 
('628', '2020-07-19', '2020-07-19', '00268', 'Chest P/A View', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '297', 'pending'), 
('629', '2020-07-19', '2020-07-19', '00269', 'Hb%_/ESR', '', '20', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '298', 'pending'), 
('630', '2020-07-19', '2020-07-19', '00269', 'RBS', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '298', 'pending'), 
('631', '2020-07-19', '2020-07-19', '00269', 'Widal Test', '', '20', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '298', 'pending'), 
('632', '2020-07-19', '2020-07-19', '00269', 'U_S_G__W_/_A', '', '20', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '298', 'pending'), 
('633', '2020-07-19', '2020-07-19', '00269', 'URINE_R_/_E', '', '20', '24', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '298', 'pending'), 
('634', '2020-07-19', '2020-07-19', '00270', 'DANTAL_X-RAY', '', '20', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '299', 'pending'), 
('635', '2020-07-19', '2020-07-19', '00271', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '300', 'pending'), 
('636', '2020-07-19', '2020-07-19', '00272', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '301', 'pending'), 
('637', '2020-07-19', '2020-07-19', '00273', 'L/S_A/P', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '302', 'pending'), 
('638', '2020-07-19', '2020-07-19', '00273', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '302', 'pending'), 
('639', '2020-07-19', '2020-07-19', '00273', 'ESR', '', '19', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '302', 'pending'), 
('640', '2020-07-19', '2020-07-19', '00274', 'L/S_A/P', '', '20', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '303', 'pending'), 
('641', '2020-07-19', '2020-07-19', '00275', 'CBC', '', '20', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '305', 'pending'), 
('642', '2020-07-19', '2020-07-19', '00275', 'RBS', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '305', 'pending'), 
('643', '2020-07-19', '2020-07-19', '00275', 'Hbs Ag', '', '20', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '305', 'pending'), 
('644', '2020-07-19', '2020-07-19', '00275', 'V.D.R.L', '', '20', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '305', 'pending'), 
('645', '2020-07-19', '2020-07-19', '00275', 'Blood For Grouping', '', '20', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '305', 'pending'), 
('646', '2020-07-19', '2020-07-19', '00275', 'PREGNANCY_PROFILE', '', '20', '23', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '305', 'pending'), 
('647', '2020-07-19', '2020-07-19', '00275', 'URINE_R_/_E', '', '20', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '305', 'pending'), 
('648', '2020-07-19', '2020-07-19', '00276', 'Hb%', '', '19', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '306', 'pending'), 
('649', '2020-07-19', '2020-07-19', '00276', 'PREGNANCY_PROFILE', '', '19', '23', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '306', 'pending'), 
('650', '2020-07-19', '2020-07-19', '00276', 'URINE_R_/_E', '', '19', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '306', 'pending'), 
('651', '2020-07-19', '2020-07-19', '00277', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '307', 'pending'), 
('652', '2020-07-19', '2020-07-19', '00278', 'Chest P/A View', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '308', 'pending'), 
('653', '2020-07-19', '2020-07-19', '00279', 'PREGNANCY_PROFILE', '', '20', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '309', 'pending'), 
('654', '2020-07-19', '2020-07-19', '00280', 'L/A', '', '20', '24', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '310', 'pending'), 
('655', '2020-07-19', '2020-07-19', '00280', 'URINE_R_/_E', '', '20', '24', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '310', 'pending'), 
('656', '2020-07-19', '2020-07-19', '00281', 'ESR', '', '20', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '311', 'pending'), 
('657', '2020-07-19', '2020-07-19', '00281', 'RBS', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '311', 'pending'), 
('658', '2020-07-19', '2020-07-19', '00281', 'S. Bilirubin', '', '20', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '311', 'pending'), 
('659', '2020-07-19', '2020-07-19', '00281', 'Widal Test', '', '20', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '311', 'pending'), 
('660', '2020-07-19', '2020-07-19', '00281', 'CRP', '', '20', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '650.00', '0.00', '311', 'pending'), 
('661', '2020-07-19', '2020-07-19', '00281', 'U_S_G__W_/_A', '', '20', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '311', 'pending'), 
('662', '2020-07-19', '2020-07-19', '00282', 'ESR', '', '34', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '312', 'pending'), 
('663', '2020-07-19', '2020-07-19', '00282', 'RBS', '', '34', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '312', 'pending'), 
('664', '2020-07-19', '2020-07-19', '00282', 'U_S_G__W_/_A', '', '34', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '312', 'pending'), 
('665', '2020-07-19', '2020-07-19', '00282', 'URINE_R_/_E', '', '34', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '312', 'pending'), 
('666', '2020-07-19', '2020-07-19', '00282', 'Chest P/A View', '', '34', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '312', 'pending'), 
('667', '2020-07-19', '2020-07-19', '00282', 'ECG', '', '34', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '312', 'pending'), 
('668', '2020-07-19', '2020-07-19', '00283', '2Hour After 75 Gram, Glucose', '', '20', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '300.00', '0.00', '313', 'pending'), 
('669', '2020-07-19', '2020-07-19', '00284', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '314', 'pending'), 
('670', '2020-07-19', '2020-07-19', '00285', '2Hour After 75 Gram, Glucose', '', '20', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '300.00', '0.00', '315', 'pending'), 
('671', '2020-07-19', '2020-07-19', '00285', 'Lipid Profile', '', '20', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '1200.00', '0.00', '315', 'pending'), 
('672', '2020-07-20', '2020-07-20', '00286', 'Fasting/Randam', '', '20', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '150.00', '0.00', '316', 'pending'), 
('673', '2020-07-20', '2020-07-20', '00287', 'Chest P/A View                                                                                                                                                                                                                                                 ', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '317', 'pending'), 
('674', '2020-07-20', '2020-07-20', '00288', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '318', 'pending'), 
('675', '2020-07-20', '2020-07-20', '00289', 'CBC', '', '13', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '319', 'pending'), 
('676', '2020-07-20', '2020-07-20', '00289', 'RBS', '', '13', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '319', 'pending'), 
('677', '2020-07-20', '2020-07-20', '00289', 'Hbs Ag', '', '13', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '319', 'pending'), 
('678', '2020-07-20', '2020-07-20', '00289', 'V.D.R.L', '', '13', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '319', 'pending'), 
('679', '2020-07-20', '2020-07-20', '00289', 'Blood For Grouping', '', '13', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '319', 'pending'), 
('680', '2020-07-20', '2020-07-20', '00289', 'Pregnancy Profile', '', '13', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '319', 'pending'), 
('681', '2020-07-20', '2020-07-20', '00289', 'URINE_R_/_E', '', '13', '24', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '319', 'pending'), 
('682', '2020-07-20', '2020-07-20', '00290', 'CBC', '', '20', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '320', 'pending'), 
('683', '2020-07-20', '2020-07-20', '00290', 'RBS', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '320', 'pending'), 
('684', '2020-07-20', '2020-07-20', '00290', 'U_S_G__W_/_A', '', '20', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '320', 'pending'), 
('685', '2020-07-20', '2020-07-20', '00290', 'URINE_R_/_E', '', '20', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '320', 'pending'), 
('686', '2020-07-20', '2020-07-20', '00291', 'USG_F/C', '', '19', '24', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '321', 'pending'), 
('687', '2020-07-20', '2020-07-20', '00291', 'URINE_R_/_E', '', '19', '24', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '321', 'pending'), 
('688', '2020-07-20', '2020-07-20', '00292', 'USG_F/C', '', '19', '24', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '322', 'pending'), 
('689', '2020-07-20', '2020-07-20', '00292', 'URINE_R_/_E', '', '19', '24', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '322', 'pending'), 
('695', '2020-07-20', '2020-07-20', '00295', 'S. Creatinine', '', '3', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '325', 'pending'), 
('696', '2020-07-20', '2020-07-20', '00296', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '326', 'pending'), 
('697', '2020-07-20', '2020-07-20', '00296', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '326', 'pending'), 
('699', '2020-07-21', '2020-07-21', '00298', 'Blood For Grouping', '', '20', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '331', 'pending'), 
('700', '2020-07-21', '2020-07-21', '00298', 'V.D.R.L', '', '20', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '331', 'pending'), 
('701', '2020-07-21', '2020-07-21', '00298', 'PREGNANCY_PROFILE', '', '20', '23', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '331', 'pending'), 
('702', '2020-07-21', '2020-07-21', '00299', 'CBC', '', '20', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '332', 'pending'), 
('703', '2020-07-21', '2020-07-21', '00299', 'S. Bilirubinu', '', '20', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '332', 'pending'), 
('704', '2020-07-21', '2020-07-21', '00299', 'Whole Abdomen', '', '20', '23', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '332', 'pending'), 
('705', '2020-07-21', '2020-07-21', '00299', 'URINE_R_/_E', '', '20', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '332', 'pending'), 
('706', '2020-07-21', '2020-07-21', '00299', 'S.G.P.T.(ALT)', '', '20', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '332', 'pending'), 
('707', '2020-07-21', '2020-07-21', '00299', 'Hbe Ag', '', '20', '23', 'SEROLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '332', 'pending'), 
('708', '2020-07-21', '2020-07-21', '00300', 'Chest P/A View', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '333', 'pending'), 
('709', '2020-07-21', '2020-07-21', '00301', 'USG_F/C', '', '19', '24', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '334', 'pending'), 
('710', '2020-07-21', '2020-07-21', '00302', 'ESR', '', '19', '0', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '335', 'pending'), 
('711', '2020-07-21', '2020-07-21', '00302', 'Chest P/A View', '', '19', '0', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '335', 'pending'), 
('712', '2020-07-21', '2020-07-21', '00302', '', '', '19', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '335', 'pending'), 
('713', '2020-07-21', '2020-07-21', '00303', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '337', 'pending'), 
('714', '2020-07-21', '2020-07-21', '0327', '	Hb%_/ESR', '', '19', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '339', 'pending'), 
('715', '2020-07-21', '2020-07-21', '0327', 'Lumbo-Sacral B.V', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '500.00', '0.00', '339', 'pending'), 
('716', '2020-07-21', '2020-07-21', '00304', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '340', 'pending'), 
('717', '2020-07-21', '2020-07-21', '00304', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '340', 'pending'), 
('718', '2020-07-21', '2020-07-21', '00304', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '340', 'pending'), 
('719', '2020-07-21', '2020-07-21', '00305', 'Widal Test', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '341', 'pending'), 
('720', '2020-07-21', '2020-07-21', '00305', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '341', 'pending'), 
('721', '2020-07-22', '2020-07-22', '00306', 'CBC', '', '2', '17', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '342', 'pending'), 
('723', '2020-07-22', '2020-07-22', '00308', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '344', 'pending'), 
('724', '2020-07-22', '2020-07-22', '00309', 'Lipid Profile', '', '20', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '1200.00', '0.00', '346', 'pending'), 
('725', '2020-07-22', '2020-07-22', '00309', 'URINE_R_/_E', '', '20', '24', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '346', 'pending'), 
('726', '2020-07-22', '2020-07-22', '00309', 'U_S_G__W_/_A', '', '20', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '346', 'pending'), 
('727', '2020-07-22', '2020-07-22', '00309', 'CBC', '', '20', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '346', 'pending'), 
('728', '2020-07-22', '2020-07-22', '00309', 'RBS', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '346', 'pending'), 
('729', '2020-07-22', '2020-07-22', '00309', 'Chest P/A View', '', '20', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '346', 'pending'), 
('730', '2020-07-22', '2020-07-22', '00310', 'CBC', '', '20', '32', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '347', 'pending'), 
('731', '2020-07-22', '2020-07-22', '00310', 'RBS', '', '20', '32', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '347', 'pending'), 
('732', '2020-07-22', '2020-07-22', '00310', 'Hbs Ag', '', '20', '32', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '347', 'pending'), 
('733', '2020-07-22', '2020-07-22', '00310', 'Blood For Grouping', '', '20', '32', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '347', 'pending'), 
('734', '2020-07-22', '2020-07-22', '00311', 'PREGNANCY_PROFILE', '', '10', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '348', 'pending'), 
('735', '2020-07-22', '2020-07-22', '00312', 'RBS', '', '19', '33', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '349', 'pending'), 
('736', '2020-07-22', '2020-07-22', '00312', 'Chest P/A View', '', '19', '33', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '349', 'pending'), 
('737', '2020-07-22', '2020-07-22', '00312', 'ECG', '', '19', '33', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '349', 'pending'), 
('738', '2020-07-22', '2020-07-22', '00313', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '350', 'pending'), 
('739', '2020-07-22', '2020-07-22', '00314', 'CBC', '', '20', '32', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '351', 'pending'), 
('740', '2020-07-22', '2020-07-22', '00314', 'RBS', '', '20', '32', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '351', 'pending'), 
('741', '2020-07-22', '2020-07-22', '00314', 'PREGNANCY_PROFILE', '', '20', '32', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '351', 'pending'), 
('742', '2020-07-22', '2020-07-22', '00315', 'Hb%_/ESR', '', '19', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '352', 'pending'), 
('743', '2020-07-22', '2020-07-22', '00315', 'S. Bilirubin', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '352', 'pending'), 
('744', '2020-07-22', '2020-07-22', '00315', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '352', 'pending'), 
('745', '2020-07-22', '2020-07-22', '00315', 'URINE_R_/_E', '', '19', '23', 'URINE_R./E', '201', '', '0', '0.00', '', '150.00', '0.00', '352', 'pending'), 
('746', '2020-07-22', '2020-07-22', '00315', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '352', 'pending'), 
('747', '2020-07-22', '2020-07-22', '00316', 'CBC', '', '11', '24', 'HAEMATOLOGY', '101', '', '17', '200.00', '', '400.00', '0.00', '353', 'pending'), 
('748', '2020-07-22', '2020-07-22', '00316', 'USG_F_/C', '', '11', '24', 'USG_COLOUR', '202', '', '17', '200.00', '', '850.00', '0.00', '353', 'pending'), 
('755', '2020-07-22', '2020-07-22', '0347', 'Fasting/Randam', '', '37', '34', 'BIOCHEMISTRY', '101', '', '29', '200.00', '', '150.00', '0.00', '357', 'pending'), 
('756', '2020-07-22', '2020-07-22', '0347', 'USG_F_/C', '', '37', '34', 'USG_COLOUR', '202', '', '29', '200.00', '', '850.00', '0.00', '357', 'pending'), 
('757', '2020-07-22', '2020-07-22', '00319', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '358', 'pending'), 
('758', '2020-07-22', '2020-07-22', '00319', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '358', 'pending'), 
('759', '2020-07-23', '2020-07-23', '00320', '2Hour After 75 Gram, Glucose', '', '2', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '300.00', '0.00', '359', 'pending'), 
('760', '2020-07-23', '2020-07-23', '0352', 'CBC', '', '38', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '363', 'pending'), 
('761', '2020-07-23', '2020-07-23', '0352', 'RBS', '', '38', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '363', 'pending'), 
('762', '2020-07-23', '2020-07-23', '0352', 'V.D.R.L', '', '38', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '363', 'pending'), 
('763', '2020-07-23', '2020-07-23', '0352', 'Blood For Grouping', '', '38', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '363', 'pending'), 
('764', '2020-07-23', '2020-07-23', '0352', 'PREGNANCY_PROFILE', '', '38', '23', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '363', 'pending'), 
('765', '2020-07-23', '2020-07-23', '0352', 'R/E M/E', '', '38', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '363', 'pending'), 
('766', '2020-07-23', '2020-07-23', '0353', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '368', 'pending'), 
('767', '2020-07-23', '2020-07-23', '0353', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '368', 'pending'), 
('768', '2020-07-23', '2020-07-23', '0353', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '368', 'pending'), 
('769', '2020-07-23', '2020-07-23', '0353', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '368', 'pending'), 
('770', '2020-07-23', '2020-07-23', '0353', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '368', 'pending'), 
('771', '2020-07-23', '2020-07-23', '0358', 'CBC', '', '39', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '369', 'pending'), 
('772', '2020-07-23', '2020-07-23', '0358', 'RBS', '', '39', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '369', 'pending'), 
('773', '2020-07-23', '2020-07-23', '0358', 'S. Creatinine', '', '39', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '369', 'pending'), 
('774', '2020-07-23', '2020-07-23', '0358', 'W_/_A', '', '39', '23', 'U_S_G_', '202', '', '0', '0.00', '', '750.00', '0.00', '369', 'pending'), 
('775', '2020-07-23', '2020-07-23', '0358', 'R/E M/E', '', '39', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '369', 'pending'), 
('776', '2020-07-23', '2020-07-23', '0358', 'L/S_A/P', '', '39', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '369', 'pending'), 
('777', '2020-07-23', '2020-07-23', '00321', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '371', 'pending'), 
('778', '2020-07-23', '2020-07-23', '0363', 'RBS', '', '20', '21', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '373', 'pending'), 
('779', '2020-07-23', '2020-07-23', '0363', 'Left_Foot_B/V', '', '20', '21', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '373', 'pending'), 
('782', '2020-07-23', '2020-07-23', '0368', 'CBC', '', '10', '32', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '380', 'pending'), 
('783', '2020-07-23', '2020-07-23', '0368', 'G.T.T/P.P.B.S', '', '10', '32', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '0.00', '0.00', '380', 'pending'), 
('784', '2020-07-23', '2020-07-23', '0366', 'Reticulacytes Count', '', '37', '34', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '700.00', '0.00', '381', 'pending'), 
('785', '2020-07-23', '2020-07-23', '00322', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '382', 'pending'), 
('786', '2020-07-23', '2020-07-23', '00323', 'MT Tuberculin Test', '', '19', '24', 'OTHERS', '201', '', '0', '0.00', '', '350.00', '0.00', '383', 'pending'), 
('787', '2020-07-23', '2020-07-23', '00324', 'PREGNANCY_PROFILE', '', '10', '30', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '384', 'pending'), 
('788', '2020-07-24', '2020-07-24', '00325', '	Hb%_/ESR', '', '19', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '385', 'pending'), 
('789', '2020-07-24', '2020-07-24', '00325', 'Blood For Grouping', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '385', 'pending'), 
('790', '2020-07-24', '2020-07-24', '00325', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '385', 'pending'), 
('791', '2020-07-24', '2020-07-24', '00325', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '385', 'pending'), 
('792', '2020-07-24', '2020-07-24', '00326', 'E', '', '20', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '386', 'pending'), 
('793', '2020-07-24', '2020-07-24', '00327', 'CBC', '', '41', '19', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '387', 'pending'), 
('794', '2020-07-24', '2020-07-24', '00327', 'RBS', '', '41', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '387', 'pending'), 
('795', '2020-07-24', '2020-07-24', '00327', 'S.G.P.T.(ALT)', '', '41', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '387', 'pending'), 
('796', '2020-07-24', '2020-07-24', '00327', 'S. Creatinine', '', '41', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '387', 'pending'), 
('797', '2020-07-24', '2020-07-24', '00327', 'Chest P/A View', '', '41', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '387', 'pending'), 
('798', '2020-07-24', '2020-07-24', '00327', 'U_S_G__W_/_A', '', '41', '19', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '387', 'pending'), 
('799', '2020-07-24', '2020-07-24', '00327', 'Chest P/A View', '', '41', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '387', 'pending'), 
('800', '2020-07-24', '2020-07-24', '00328', 'PREGNANCY_PROFILE', '', '19', '30', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '388', 'pending'), 
('801', '2020-07-24', '2020-07-24', '00329', 'Chest P/A View', '', '20', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '389', 'pending'), 
('802', '2020-07-24', '2020-07-24', '00329', 'Chest P/A View', '', '20', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '389', 'pending'), 
('803', '2020-07-24', '2020-07-24', '00330', 'S. Creatinine', '', '20', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '390', 'pending'), 
('804', '2020-07-24', '2020-07-24', '00330', 'S.G.P.T.(ALT)', '', '20', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '390', 'pending'), 
('805', '2020-07-24', '2020-07-24', '00330', 'RBS', '', '20', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '390', 'pending'), 
('806', '2020-07-24', '2020-07-24', '00330', 'ECG', '', '20', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '390', 'pending'), 
('807', '2020-07-24', '2020-07-24', '00331', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '391', 'pending'), 
('808', '2020-07-24', '2020-07-24', '00331', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '391', 'pending'), 
('809', '2020-07-24', '2020-07-24', '00331', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '391', 'pending'), 
('810', '2020-07-24', '2020-07-24', '00331', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '391', 'pending'), 
('811', '2020-07-24', '2020-07-24', '00331', 'S. Creatinine', '', '19', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '391', 'pending'), 
('812', '2020-07-24', '2020-07-24', '00332', 'Hb%', '', '19', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '392', 'pending'), 
('813', '2020-07-24', '2020-07-24', '00332', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '392', 'pending'), 
('814', '2020-07-24', '2020-07-24', '00333', 'L/S_A/P', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '393', 'pending'), 
('815', '2020-07-24', '2020-07-24', '00334', 'PREGNANCY_PROFILE', '', '10', '30', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '394', 'pending'), 
('816', '2020-07-24', '2020-07-24', '00335', 'CBC', '', '19', '19', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '395', 'pending'), 
('817', '2020-07-24', '2020-07-24', '00335', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '395', 'pending'), 
('818', '2020-07-24', '2020-07-24', '00335', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '395', 'pending'), 
('819', '2020-07-24', '2020-07-24', '00335', 'U_S_G__W_/_A', '', '19', '19', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '395', 'pending'), 
('820', '2020-07-24', '2020-07-24', '00335', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '395', 'pending'), 
('821', '2020-07-24', '2020-07-24', '00336', 'ESR', '', '12', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '396', 'pending'), 
('822', '2020-07-24', '2020-07-24', '00336', 'X-RAY', '', '12', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '396', 'pending'), 
('823', '2020-07-24', '2020-07-24', '00336', 'X-RAY', '', '12', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '396', 'pending'), 
('824', '2020-07-24', '2020-07-24', '00336', 'X-RAY', '', '12', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '396', 'pending'), 
('825', '2020-07-24', '2020-07-24', '00336', 'RBS', '', '12', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '396', 'pending'), 
('826', '2020-07-24', '2020-07-24', '00337', 'R/E M/E', '', '19', '19', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '397', 'pending'), 
('827', '2020-07-24', '2020-07-24', '00337', 'V.D.R.L', '', '19', '19', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '397', 'pending'), 
('828', '2020-07-24', '2020-07-24', '00338', 'CBC', '', '19', '19', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '398', 'pending'), 
('829', '2020-07-24', '2020-07-24', '00338', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '398', 'pending'), 
('830', '2020-07-24', '2020-07-24', '00338', 'S. Creatinine', '', '19', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '398', 'pending'), 
('831', '2020-07-24', '2020-07-24', '00338', 'S.__ELECROLYTES', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '850.00', '0.00', '398', 'pending'), 
('832', '2020-07-24', '2020-07-24', '00338', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '398', 'pending'), 
('833', '2020-07-24', '2020-07-24', '00338', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '398', 'pending'), 
('834', '2020-07-24', '2020-07-24', '00339', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '399', 'pending'), 
('835', '2020-07-24', '2020-07-24', '00340', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '400', 'pending'), 
('836', '2020-07-24', '2020-07-24', '00341', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '401', 'pending'), 
('837', '2020-07-24', '2020-07-24', '00341', 'X-RAY', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '401', 'pending'), 
('838', '2020-07-24', '2020-07-24', '00342', 'X-RAY', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '402', 'pending'), 
('839', '2020-07-24', '2020-07-24', '00342', 'X-RAY', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '402', 'pending'), 
('840', '2020-07-24', '2020-07-24', '00342', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '402', 'pending'), 
('841', '2020-07-24', '2020-07-24', '00343', 'CBC', '', '19', '19', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '403', 'pending'), 
('842', '2020-07-24', '2020-07-24', '00343', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '403', 'pending'), 
('843', '2020-07-24', '2020-07-24', '00343', 'U_S_G__W_/_A', '', '19', '19', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '403', 'pending'), 
('844', '2020-07-24', '2020-07-24', '00344', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '404', 'pending'), 
('845', '2020-07-24', '2020-07-24', '00345', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '405', 'pending'), 
('846', '2020-07-24', '2020-07-24', '00345', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '405', 'pending'), 
('847', '2020-07-24', '2020-07-24', '00345', 'R/E M/E', '', '19', '19', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '405', 'pending'), 
('848', '2020-07-24', '2020-07-24', '00346', 'PREGNANCY_PROFILE', '', '10', '30', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '406', 'pending'), 
('849', '2020-07-24', '2020-07-24', '00347', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '407', 'pending'), 
('850', '2020-07-24', '2020-07-24', '00347', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '407', 'pending'), 
('851', '2020-07-24', '2020-07-24', '00347', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '407', 'pending'), 
('852', '2020-07-24', '2020-07-24', '00348', 'X-RAY', '', '20', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '408', 'pending'), 
('853', '2020-07-24', '2020-07-24', '00349', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '409', 'pending'), 
('854', '2020-07-24', '2020-07-24', '00349', 'X-RAY', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '409', 'pending'), 
('855', '2020-07-24', '2020-07-24', '00349', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '409', 'pending'), 
('856', '2020-07-24', '2020-07-24', '00350', 'A.S.O Titre', '', '19', '19', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '410', 'pending'), 
('857', '2020-07-24', '2020-07-24', '00350', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '410', 'pending'), 
('858', '2020-07-24', '2020-07-24', '00350', 'R/A Test', '', '19', '19', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '410', 'pending'), 
('859', '2020-07-24', '2020-07-24', '00351', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '411', 'pending'), 
('860', '2020-07-24', '2020-07-24', '00351', 'X-RAY', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '411', 'pending'), 
('861', '2020-07-24', '2020-07-24', '00352', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '412', 'pending'), 
('862', '2020-07-24', '2020-07-24', '00352', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '412', 'pending'), 
('863', '2020-07-24', '2020-07-24', '00352', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '412', 'pending'), 
('864', '2020-07-24', '2020-07-24', '00352', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '412', 'pending'), 
('865', '2020-07-24', '2020-07-24', '00353', 'ESR', '', '19', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '413', 'pending'), 
('866', '2020-07-24', '2020-07-24', '00354', 'ESR', '', '19', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '414', 'pending'), 
('867', '2020-07-24', '2020-07-24', '00354', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '414', 'pending'), 
('868', '2020-07-24', '2020-07-24', '00354', 'SOFT_TISSUC_NECK', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '414', 'pending'), 
('869', '2020-07-24', '2020-07-24', '00354', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '414', 'pending'), 
('870', '2020-07-24', '2020-07-24', '00355', 'CBC', '', '43', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '415', 'pending'), 
('871', '2020-07-24', '2020-07-24', '00355', 'S. Creatinine', '', '43', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '415', 'pending'), 
('872', '2020-07-24', '2020-07-24', '00355', 'ECG', '', '43', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '415', 'pending'), 
('873', '2020-07-24', '2020-07-24', '00355', 'W_/_A', '', '43', '23', 'U_S_G_', '202', '', '0', '0.00', '', '750.00', '0.00', '415', 'pending'), 
('874', '2020-07-24', '2020-07-24', '00355', 'R/E M/E', '', '43', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '415', 'pending'), 
('875', '2020-07-24', '2020-07-24', '00356', 'ECG', '', '20', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '416', 'pending'), 
('876', '2020-07-24', '2020-07-24', '00356', 'Chest P/A View', '', '20', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '416', 'pending'), 
('877', '2020-07-24', '2020-07-24', '00356', 'RBS', '', '20', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '416', 'pending'), 
('878', '2020-07-24', '2020-07-24', '00357', 'ECG', '', '20', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '417', 'pending'), 
('879', '2020-07-24', '2020-07-24', '00358', 'PREGNANCY_PROFILE', '', '10', '30', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '418', 'pending'), 
('880', '2020-07-25', '2020-07-25', '00359', 'CBC', '', '19', '25', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '419', 'pending'), 
('881', '2020-07-25', '2020-07-25', '00359', 'R/E M/E', '', '19', '25', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '419', 'pending'), 
('882', '2020-07-25', '2020-07-25', '00359', 'U_S_G__W_/_A', '', '19', '25', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '419', 'pending'), 
('883', '2020-07-25', '2020-07-25', '00360', 'ESR', '', '19', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '420', 'pending'), 
('884', '2020-07-25', '2020-07-25', '00360', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '420', 'pending'), 
('885', '2020-07-25', '2020-07-25', '00360', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '420', 'pending'), 
('886', '2020-07-25', '2020-07-25', '00360', 'X-RAY', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '420', 'pending'), 
('887', '2020-07-25', '2020-07-25', '00360', 'ECG', '', '19', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '420', 'pending'), 
('888', '2020-07-25', '2020-07-25', '00361', 'CBC', '', '20', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '421', 'pending'), 
('889', '2020-07-25', '2020-07-25', '00361', 'S. Creatinine', '', '20', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '421', 'pending'), 
('890', '2020-07-25', '2020-07-25', '00361', 'U_S_G__W_/_A', '', '20', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '421', 'pending'), 
('891', '2020-07-25', '2020-07-25', '00361', 'R/E M/E', '', '20', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '421', 'pending'), 
('892', '2020-07-25', '2020-07-25', '00361', 'S.TSH', '', '20', '23', 'HORMON', '201', '', '0', '0.00', '', '800.00', '0.00', '421', 'pending'), 
('893', '2020-07-25', '2020-07-25', '00361', 'S.TSH', '', '20', '23', 'HORMON', '201', '', '0', '0.00', '', '800.00', '0.00', '421', 'pending'), 
('894', '2020-07-25', '2020-07-25', '00362', 'PREGNANCY_PROFILE', '', '20', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '422', 'pending'), 
('895', '2020-07-25', '2020-07-25', '00363', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '423', 'pending'), 
('896', '2020-07-25', '2020-07-25', '00363', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '423', 'pending'), 
('897', '2020-07-25', '2020-07-25', '00364', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '424', 'pending'), 
('898', '2020-07-25', '2020-07-25', '0366', 'Reticulacytes Count', '', '37', '34', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '700.00', '0.00', '425', 'pending'), 
('899', '2020-07-25', '2020-07-25', '00365', 'Pregnancy Test', '', '19', '20', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '426', 'pending'), 
('900', '2020-07-25', '2020-07-25', '00366', 'Chest P/A View', '', '19', '31', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '427', 'pending'), 
('901', '2020-07-25', '2020-07-25', '00366', 'ECG', '', '19', '31', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '427', 'pending'), 
('902', '2020-07-25', '2020-07-25', '00367', 'Chest P/A View', '', '24', '31', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '428', 'pending'), 
('903', '2020-07-25', '2020-07-25', '00367', 'RBS', '', '24', '31', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '428', 'pending'), 
('904', '2020-07-25', '2020-07-25', '00367', 'ECG', '', '24', '31', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '428', 'pending'), 
('905', '2020-07-25', '2020-07-25', '00368', 'CBC', '', '19', '33', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '429', 'pending'), 
('906', '2020-07-25', '2020-07-25', '00368', 'RBS', '', '19', '33', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '429', 'pending'), 
('907', '2020-07-25', '2020-07-25', '00368', 'Skull B V / P.N.S', '', '19', '33', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '429', 'pending'), 
('908', '2020-07-25', '2020-07-25', '00368', 'R/E M/E', '', '19', '33', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '429', 'pending'), 
('909', '2020-07-25', '2020-07-25', '00369', '	Hb%_/ESR', '', '19', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '430', 'pending'), 
('910', '2020-07-25', '2020-07-25', '00369', 'HBA.1C', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '850.00', '0.00', '430', 'pending'), 
('911', '2020-07-25', '2020-07-25', '00369', 'ECG', '', '19', '24', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '430', 'pending'), 
('912', '2020-07-25', '2020-07-25', '00369', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '430', 'pending'), 
('913', '2020-07-25', '2020-07-25', '00369', 'Whole Abdomen', '', '19', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '430', 'pending'), 
('914', '2020-07-25', '2020-07-25', '00369', 'S. Creatinine', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '430', 'pending'), 
('915', '2020-07-25', '2020-07-25', '00370', 'CBC', '', '14', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '431', 'pending'), 
('916', '2020-07-25', '2020-07-25', '00370', 'S. Creatinine', '', '14', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '431', 'pending'), 
('917', '2020-07-25', '2020-07-25', '00370', 'R/A Test', '', '14', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '431', 'pending'), 
('918', '2020-07-25', '2020-07-25', '00370', 'U_S_G__W_/_A', '', '14', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '431', 'pending'), 
('919', '2020-07-25', '2020-07-25', '00370', 'R/E M/E', '', '14', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '431', 'pending'), 
('920', '2020-07-25', '2020-07-25', '00371', 'RB', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '432', 'pending'), 
('921', '2020-07-25', '2020-07-25', '00372', '	Hb%_/ESR', '', '20', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '433', 'pending'), 
('922', '2020-07-25', '2020-07-25', '00372', 'RBS', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '433', 'pending'), 
('923', '2020-07-25', '2020-07-25', '00372', 'Chest P/A View', '', '20', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '433', 'pending'), 
('924', '2020-07-25', '2020-07-25', '00372', '', '', '20', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '433', 'pending'), 
('925', '2020-07-25', '2020-07-25', '00373', '	Hb%_/ESR', '', '12', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '434', 'pending'), 
('926', '2020-07-25', '2020-07-25', '00373', 'RBS', '', '12', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '434', 'pending'), 
('927', '2020-07-25', '2020-07-25', '00373', 'MT Tuberculin Test', '', '12', '23', 'OTHERS', '201', '', '0', '0.00', '', '350.00', '0.00', '434', 'pending'), 
('928', '2020-07-25', '2020-07-25', '00373', 'U_S_G__W_/_A', '', '12', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '434', 'pending'), 
('929', '2020-07-25', '2020-07-25', '00373', 'R/E M/E', '', '12', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '434', 'pending'), 
('930', '2020-07-26', '2020-07-26', '00374', 'Fasting', '', '20', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '150.00', '0.00', '435', 'pending'), 
('931', '2020-07-26', '2020-07-26', '00375', '	Hb%_/ESR', '', '20', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '436', 'pending'), 
('932', '2020-07-26', '2020-07-26', '00375', 'R/E M/E', '', '20', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '436', 'pending'), 
('933', '2020-07-26', '2020-07-26', '00375', 'Chest P/A View', '', '20', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '436', 'pending'), 
('934', '2020-07-26', '2020-07-26', '00375', 'Widal Test', '', '20', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '436', 'pending'), 
('935', '2020-07-26', '2020-07-26', '00375', 'U_S_G__W_/_A', '', '20', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '436', 'pending'), 
('937', '2020-07-26', '2020-07-26', '00377', 'X-RAY', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '438', 'pending'), 
('938', '2020-07-26', '2020-07-26', '00377', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '438', 'pending'), 
('939', '2020-07-26', '2020-07-26', '00378', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '439', 'pending'), 
('940', '2020-07-26', '2020-07-26', '00379', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '440', 'pending'), 
('941', '2020-07-26', '2020-07-26', '00380', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '441', 'pending'), 
('942', '2020-07-26', '2020-07-26', '00380', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '441', 'pending'), 
('943', '2020-07-26', '2020-07-26', '00380', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '441', 'pending'), 
('944', '2020-07-26', '2020-07-26', '00380', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '441', 'pending'), 
('945', '2020-07-26', '2020-07-26', '00380', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '441', 'pending'), 
('946', '2020-07-26', '2020-07-26', '00380', 'X-RAY', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '441', 'pending'), 
('947', '2020-07-26', '2020-07-26', '00381', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '442', 'pending'), 
('948', '2020-07-26', '2020-07-26', '00381', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '442', 'pending'), 
('949', '2020-07-26', '2020-07-26', '00381', 'X-RAY', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '442', 'pending'), 
('950', '2020-07-26', '2020-07-26', '00382', 'PREGNANCY_PROFILE', '', '20', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '443', 'pending'), 
('951', '2020-07-26', '2020-07-26', '00383', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '444', 'pending'), 
('952', '2020-07-26', '2020-07-26', '00384', 'CBC', '', '20', '33', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '445', 'pending'), 
('953', '2020-07-26', '2020-07-26', '00384', 'TSH', '', '20', '33', 'HORMON', '201', '', '0', '0.00', '', '800.00', '0.00', '445', 'pending'), 
('954', '2020-07-26', '2020-07-26', '00384', 'RBS', '', '20', '33', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '445', 'pending'), 
('955', '2020-07-26', '2020-07-26', '00384', 'Whole Abdomen', '', '20', '33', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '445', 'pending'), 
('956', '2020-07-26', '2020-07-26', '00384', 'R/E M/E', '', '20', '33', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '445', 'pending'), 
('957', '2020-07-26', '2020-07-26', '00384', 'ECG', '', '20', '33', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '445', 'pending'), 
('958', '2020-07-26', '2020-07-26', '00385', 'Chest P/A View', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '446', 'pending'), 
('959', '2020-07-26', '2020-07-26', '00385', 'ECG', '', '19', '24', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '446', 'pending'), 
('960', '2020-07-26', '2020-07-26', '00385', 'CBC', '', '19', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '446', 'pending'), 
('961', '2020-07-26', '2020-07-26', '00386', 'Skull B V / P.N.S', '', '34', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '447', 'pending'), 
('962', '2020-07-26', '2020-07-26', '00386', 'ESR', '', '34', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '447', 'pending'), 
('963', '2020-07-26', '2020-07-26', '00386', 'RBS', '', '34', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '447', 'pending'), 
('964', '2020-07-26', '2020-07-26', '00386', 'R/E M/E', '', '34', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '447', 'pending'), 
('965', '2020-07-26', '2020-07-26', '00387', 'PREGNANCY_PROFILE', '', '10', '23', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '448', 'pending'), 
('966', '2020-07-26', '2020-07-26', '00388', 'S. Bilirubin', '', '9', '21', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '449', 'pending'), 
('967', '2020-07-26', '2020-07-26', '00388', 'Reducing Substasnces', '', '9', '21', 'STOOL', '101', '', '0', '0.00', '', '0.00', '0.00', '449', 'pending'), 
('968', '2020-07-26', '2020-07-26', '00389', 'CBC', '', '20', '25', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '450', 'pending'), 
('969', '2020-07-27', '2020-07-27', '00390', 'Hb%', '', '19', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '451', 'pending'), 
('970', '2020-07-27', '2020-07-27', '00390', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '451', 'pending'), 
('971', '2020-07-27', '2020-07-27', '00390', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '451', 'pending'), 
('972', '2020-07-27', '2020-07-27', '00390', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '451', 'pending'), 
('973', '2020-07-27', '2020-07-27', '00390', 'ECG', '', '19', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '451', 'pending'), 
('974', '2020-07-27', '2020-07-27', '00391', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '452', 'pending'), 
('975', '2020-07-27', '2020-07-27', '00391', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '452', 'pending'), 
('976', '2020-07-27', '2020-07-27', '00392', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '453', 'pending'), 
('977', '2020-07-27', '2020-07-27', '00393', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '454', 'pending'), 
('978', '2020-07-28', '2020-07-28', '00394', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '455', 'pending'), 
('979', '2020-07-28', '2020-07-28', '00395', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '456', 'pending'), 
('980', '2020-07-28', '2020-07-28', '00396', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '457', 'pending'), 
('981', '2020-07-28', '2020-07-28', '00397', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '458', 'pending'), 
('982', '2020-07-28', '2020-07-28', '00398', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '459', 'pending'), 
('983', '2020-07-28', '2020-07-28', '00399', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '460', 'pending'), 
('984', '2020-07-28', '2020-07-28', '00400', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '461', 'pending'), 
('985', '2020-07-28', '2020-07-28', '00401', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '462', 'pending'), 
('986', '2020-07-28', '2020-07-28', '00402', 'CBC', '', '19', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '463', 'pending'), 
('987', '2020-07-28', '2020-07-28', '00402', 'Widal Test', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '463', 'pending'), 
('988', '2020-07-28', '2020-07-28', '00402', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '463', 'pending'), 
('989', '2020-07-28', '2020-07-28', '00402', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '463', 'pending'), 
('990', '2020-07-28', '2020-07-28', '00403', 'PREGNANCY_PROFILE', '', '29', '25', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '464', 'pending'), 
('991', '2020-07-28', '2020-07-28', '00403', 'Hb%', '', '29', '25', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '464', 'pending'), 
('992', '2020-07-28', '2020-07-28', '00403', 'RBS', '', '29', '25', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '464', 'pending'), 
('993', '2020-07-28', '2020-07-28', '00403', 'Blood For Grouping', '', '29', '25', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '464', 'pending'), 
('994', '2020-07-28', '2020-07-28', '00404', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '465', 'pending'), 
('995', '2020-07-28', '2020-07-28', '00405', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '466', 'pending'), 
('996', '2020-07-28', '2020-07-28', '00405', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '466', 'pending'), 
('997', '2020-07-28', '2020-07-28', '00406', 'PREGNANCY_PROFILE', '', '20', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '467', 'pending'), 
('998', '2020-07-28', '2020-07-28', '00407', 'Hb%_/ESR', '', '20', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '468', 'pending'), 
('999', '2020-07-28', '2020-07-28', '00407', 'V.D.R.L', '', '20', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '468', 'pending'), 
('1000', '2020-07-28', '2020-07-28', '00407', 'RBS', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '468', 'pending'), 
('1001', '2020-07-28', '2020-07-28', '00408', 'Whole Abdomen', '', '19', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '469', 'pending'), 
('1002', '2020-07-28', '2020-07-28', '00408', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '469', 'pending'), 
('1003', '2020-07-28', '2020-07-28', '00408', 'ECG', '', '19', '24', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '469', 'pending'), 
('1004', '2020-07-29', '2020-07-29', '00409', '	Hb%_/ESR', '', '7', '32', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '470', 'pending'), 
('1005', '2020-07-29', '2020-07-29', '00409', 'Blood For Grouping', '', '7', '32', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '470', 'pending'), 
('1006', '2020-07-29', '2020-07-29', '00409', 'V.D.R.L', '', '7', '32', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '470', 'pending'), 
('1007', '2020-07-29', '2020-07-29', '00409', 'PREGNANCY_PROFILE', '', '7', '32', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '470', 'pending'), 
('1008', '2020-07-29', '2020-07-29', '00409', 'R/E M/E', '', '7', '32', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '470', 'pending'), 
('1009', '2020-07-29', '2020-07-29', '00409', 'Pregnancy Test', '', '7', '32', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '470', 'pending'), 
('1010', '2020-07-29', '2020-07-29', '00409', 'RBS', '', '7', '32', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '470', 'pending'), 
('1011', '2020-07-29', '2020-07-29', '00410', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '471', 'pending'), 
('1012', '2020-07-29', '2020-07-29', '00411', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '472', 'pending'), 
('1013', '2020-07-29', '2020-07-29', '00411', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '472', 'pending'), 
('1014', '2020-07-29', '2020-07-29', '00411', 'Whole Abdomen', '', '19', '23', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '472', 'pending'), 
('1015', '2020-07-29', '2020-07-29', '00411', 'ECG', '', '19', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '472', 'pending'), 
('1016', '2020-07-29', '2020-07-29', '00411', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '472', 'pending'), 
('1017', '2020-07-29', '2020-07-29', '00412', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '473', 'pending'), 
('1018', '2020-07-29', '2020-07-29', '00413', 'Chest P/A View', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '474', 'pending'), 
('1019', '2020-07-29', '2020-07-29', '00413', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '474', 'pending'), 
('1020', '2020-07-29', '2020-07-29', '00414', 'USG_F/C', '', '29', '25', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '475', 'pending'), 
('1021', '2020-07-29', '2020-07-29', '00415', 'Widal Test', '', '20', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '476', 'pending'), 
('1022', '2020-07-29', '2020-07-29', '00415', 'ESR', '', '20', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '476', 'pending'), 
('1023', '2020-07-29', '2020-07-29', '00415', 'RBS', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '476', 'pending'), 
('1024', '2020-07-29', '2020-07-29', '00415', 'Chest P/A View', '', '20', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '476', 'pending'), 
('1025', '2020-07-29', '2020-07-29', '00416', '	Hb%_/ESR', '', '20', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '477', 'pending'), 
('1026', '2020-07-29', '2020-07-29', '00416', 'R/E M/E', '', '20', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '477', 'pending'), 
('1027', '2020-07-29', '2020-07-29', '00416', 'Chest P/A View', '', '20', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '477', 'pending'), 
('1028', '2020-07-29', '2020-07-29', '00417', 'Whole Abdomen', '', '2', '23', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '478', 'pending'), 
('1029', '2020-07-30', '2020-07-30', '00418', 'Widal Test', '', '3', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '479', 'pending'), 
('1030', '2020-07-30', '2020-07-30', '00418', 'R/E M/E', '', '3', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '479', 'pending'), 
('1031', '2020-07-30', '2020-07-30', '00419', 'U_S_G__W_/_A', '', '20', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '480', 'pending'), 
('1032', '2020-07-30', '2020-07-30', '00419', 'ECG', '', '20', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '480', 'pending'), 
('1033', '2020-07-30', '2020-07-30', '00419', 'RBS', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '480', 'pending'), 
('1034', '2020-07-30', '2020-07-30', '00419', 'S. Creatinine', '', '20', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '480', 'pending'), 
('1035', '2020-07-30', '2020-07-30', '00419', 'ESR', '', '20', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '480', 'pending'), 
('1036', '2020-07-30', '2020-07-30', '00419', 'X-RAY', '', '20', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '480', 'pending'), 
('1037', '2020-07-30', '2020-07-30', '00419', 'R/E M/E', '', '20', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '480', 'pending'), 
('1038', '2020-07-30', '2020-07-30', '00420', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '481', 'pending'), 
('1039', '2020-07-30', '2020-07-30', '00420', 'ESR', '', '19', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '481', 'pending'), 
('1040', '2020-07-30', '2020-07-30', '00421', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '482', 'pending'), 
('1041', '2020-07-30', '2020-07-30', '00422', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '483', 'pending'), 
('1042', '2020-07-30', '2020-07-30', '00422', 'HBA.1C', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '850.00', '0.00', '483', 'pending'), 
('1043', '2020-07-30', '2020-07-30', '00422', 'X-RAY', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '483', 'pending'), 
('1044', '2020-07-30', '2020-07-30', '00422', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '483', 'pending'), 
('1045', '2020-07-30', '2020-07-30', '00422', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '483', 'pending'), 
('1046', '2020-07-30', '2020-07-30', '00423', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '484', 'pending'), 
('1047', '2020-07-30', '2020-07-30', '00424', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '485', 'pending'), 
('1048', '2020-07-30', '2020-07-30', '00425', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '486', 'pending'), 
('1049', '2020-07-31', '2020-07-31', '00426', 'CBC', '', '19', '19', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '487', 'pending'), 
('1050', '2020-07-31', '2020-07-31', '00426', 'CRP', '', '19', '19', 'SEROLOGY', '201', '', '0', '0.00', '', '650.00', '0.00', '487', 'pending'), 
('1051', '2020-07-31', '2020-07-31', '00426', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '487', 'pending'), 
('1052', '2020-07-31', '2020-07-31', '00426', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '487', 'pending'), 
('1053', '2020-07-31', '2020-07-31', '00427', 'S. Creatinine', '', '19', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '488', 'pending'), 
('1054', '2020-07-31', '2020-07-31', '00428', 'ESR', '', '19', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '489', 'pending'), 
('1055', '2020-07-31', '2020-07-31', '00428', 'S. Creatinine', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '489', 'pending'), 
('1056', '2020-07-31', '2020-07-31', '00428', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '489', 'pending'), 
('1057', '2020-07-31', '2020-07-31', '00429', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '490', 'pending'), 
('1058', '2020-07-31', '2020-07-31', '00430', 'ECG', '', '20', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '491', 'pending'), 
('1059', '2020-07-31', '2020-07-31', '00430', 'Chest P/A View', '', '20', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '491', 'pending'), 
('1060', '2020-07-31', '2020-07-31', '00431', 'L/S_A/P', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '492', 'pending'), 
('1061', '2020-07-31', '2020-07-31', '00432', 'ESR', '', '20', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '493', 'pending'), 
('1062', '2020-07-31', '2020-07-31', '00432', 'S. Creatinine', '', '20', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '493', 'pending'), 
('1063', '2020-07-31', '2020-07-31', '00432', 'RBS', '', '20', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '493', 'pending'), 
('1064', '2020-07-31', '2020-07-31', '00432', 'Chest P/A View', '', '20', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '493', 'pending'), 
('1065', '2020-07-31', '2020-07-31', '00433', 'USG_F/C', '', '19', '24', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '494', 'pending'), 
('1066', '2020-07-31', '2020-07-31', '00434', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '495', 'pending'), 
('1067', '2020-07-31', '2020-07-31', '00434', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '495', 'pending'), 
('1068', '2020-07-31', '2020-07-31', '00434', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '495', 'pending'), 
('1069', '2020-07-31', '2020-07-31', '00434', 'X-RAY', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '495', 'pending'), 
('1070', '2020-07-31', '2020-07-31', '00434', 'W/A', '', '19', '19', 'USG_COLOUR', '250', '', '0', '0.00', '', '850.00', '0.00', '495', 'pending'), 
('1071', '2020-07-31', '2020-07-31', '00435', 'U_S_G__W_/_A', '', '19', '19', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '496', 'pending'), 
('1072', '2020-07-31', '2020-07-31', '00436', 'Skull B V / P.N.S', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '497', 'pending'), 
('1073', '2020-08-03', '2020-08-03', '00437', 'V.D.R.L', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '498', 'pending'), 
('1074', '2020-08-03', '2020-08-03', '00437', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '498', 'pending'), 
('1075', '2020-08-03', '2020-08-03', '00437', 'PREGNANCY_PROFILE', '', '19', '23', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '498', 'pending'), 
('1076', '2020-08-03', '2020-08-03', '00437', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '498', 'pending'), 
('1077', '2020-08-03', '2020-08-03', '00438', 'L/A', '', '10', '30', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '499', 'pending'), 
('1078', '2020-08-03', '2020-08-03', '00439', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '500', 'pending'), 
('1079', '2020-08-03', '2020-08-03', '00440', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '501', 'pending'), 
('1080', '2020-08-03', '2020-08-03', '00441', 'PREGNANCY_PROFILE', '', '20', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '502', 'pending'), 
('1081', '2020-08-03', '2020-08-03', '00442', 'PREGNANCY_PROFILE', '', '10', '30', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '503', 'pending'), 
('1082', '2020-08-03', '2020-08-03', '00443', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '504', 'pending'), 
('1083', '2020-08-03', '2020-08-03', '00443', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '504', 'pending'), 
('1084', '2020-08-03', '2020-08-03', '00443', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '504', 'pending'), 
('1085', '2020-08-03', '2020-08-03', '00443', 'ECG', '', '19', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '504', 'pending'), 
('1086', '2020-08-03', '2020-08-03', '00443', 'Chest P/A View', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '504', 'pending'), 
('1087', '2020-08-03', '2020-08-03', '00444', 'CBC', '', '7', '32', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '505', 'pending'), 
('1088', '2020-08-03', '2020-08-03', '00444', 'V.D.R.L', '', '7', '32', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '505', 'pending'), 
('1089', '2020-08-03', '2020-08-03', '00444', 'R/E M/E', '', '7', '32', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '505', 'pending'), 
('1090', '2020-08-03', '2020-08-03', '00444', 'L/A', '', '7', '32', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '505', 'pending'), 
('1091', '2020-08-03', '2020-08-03', '00445', 'Hb%', '', '19', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '506', 'pending'), 
('1092', '2020-08-03', '2020-08-03', '00445', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '506', 'pending'), 
('1093', '2020-08-03', '2020-08-03', '00445', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '506', 'pending'), 
('1094', '2020-08-03', '2020-08-03', '00445', 'V.D.R.L', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '506', 'pending'), 
('1095', '2020-08-03', '2020-08-03', '00445', 'Blood For Grouping', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '506', 'pending'), 
('1096', '2020-08-03', '2020-08-03', '00445', 'USG_F_/C', '', '19', '23', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '506', 'pending'), 
('1097', '2020-08-03', '2020-08-03', '00446', 'S.__IGE', '', '19', '32', 'SEROLOGY', '201', '', '0', '0.00', '', '1000.00', '0.00', '507', 'pending'), 
('1098', '2020-08-03', '2020-08-03', '00446', 'S. Creatinine', '', '19', '32', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '507', 'pending'), 
('1099', '2020-08-03', '2020-08-03', '00446', 'R/E M/E', '', '19', '32', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '507', 'pending'), 
('1100', '2020-08-03', '2020-08-03', '00446', 'RBS', '', '19', '32', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '507', 'pending'), 
('1101', '2020-08-03', '2020-08-03', '00447', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '508', 'pending'), 
('1102', '2020-08-03', '2020-08-03', '00447', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '508', 'pending'), 
('1103', '2020-08-03', '2020-08-03', '00447', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '508', 'pending'), 
('1104', '2020-08-03', '2020-08-03', '00447', 'Whole Abdomen', '', '19', '23', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '508', 'pending'), 
('1105', '2020-08-03', '2020-08-03', '00447', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '508', 'pending'), 
('1106', '2020-08-03', '2020-08-03', '00447', 'Chest P/A View', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '508', 'pending'), 
('1107', '2020-08-03', '2020-08-03', '00447', 'ECG', '', '19', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '508', 'pending'), 
('1108', '2020-08-04', '2020-08-04', '00448', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '509', 'pending'), 
('1109', '2020-08-04', '2020-08-04', '00449', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '510', 'pending'), 
('1110', '2020-08-04', '2020-08-04', '00449', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '510', 'pending'), 
('1111', '2020-08-04', '2020-08-04', '00449', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '510', 'pending'), 
('1112', '2020-08-04', '2020-08-04', '00449', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '510', 'pending'), 
('1113', '2020-08-04', '2020-08-04', '00450', '	Hb%_/ESR', '', '19', '32', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '511', 'pending'), 
('1114', '2020-08-04', '2020-08-04', '00450', 'U_S_G__W_/_A', '', '19', '32', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '511', 'pending'), 
('1115', '2020-08-04', '2020-08-04', '00450', 'Pregnancy Test', '', '19', '32', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '511', 'pending'), 
('1116', '2020-08-04', '2020-08-04', '00450', 'R/E M/E', '', '19', '32', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '511', 'pending'), 
('1117', '2020-08-04', '2020-08-04', '00450', 'V.D.R.L', '', '19', '32', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '511', 'pending'), 
('1118', '2020-08-04', '2020-08-04', '00451', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '512', 'pending'), 
('1119', '2020-08-04', '2020-08-04', '00451', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '512', 'pending'), 
('1120', '2020-08-04', '2020-08-04', '00451', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '512', 'pending'), 
('1121', '2020-08-04', '2020-08-04', '00451', 'X-RAY', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '512', 'pending'), 
('1122', '2020-08-04', '2020-08-04', '00452', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '513', 'pending'), 
('1123', '2020-08-04', '2020-08-04', '00453', 'PREGNANCY_PROFILE', '', '19', '23', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '514', 'pending'), 
('1124', '2020-08-04', '2020-08-04', '00454', 'PREGNANCY_PROFILE', '', '10', '30', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '515', 'pending'), 
('1125', '2020-08-04', '2020-08-04', '00455', 'CBC', '', '19', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '516', 'pending'), 
('1126', '2020-08-04', '2020-08-04', '00455', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '516', 'pending'), 
('1127', '2020-08-04', '2020-08-04', '00455', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '516', 'pending'), 
('1128', '2020-08-04', '2020-08-04', '00455', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '516', 'pending'), 
('1129', '2020-08-04', '2020-08-04', '00455', 'S. Creatinine', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '516', 'pending'), 
('1130', '2020-08-04', '2020-08-04', '00456', 'Hb%_/ESR', '', '19', '32', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '517', 'pending'), 
('1131', '2020-08-04', '2020-08-04', '00456', 'Hbs Ag', '', '19', '32', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '517', 'pending'), 
('1132', '2020-08-04', '2020-08-04', '00456', 'PREGNANCY_PROFILE', '', '19', '32', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '517', 'pending'), 
('1133', '2020-08-04', '2020-08-04', '00456', 'R/E M/E', '', '19', '32', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '517', 'pending'), 
('1134', '2020-08-04', '2020-08-04', '00457', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '518', 'pending'), 
('1135', '2020-08-04', '2020-08-04', '00458', 'W/A', '', '19', '23', 'USG_COLOUR', '250', '', '0', '0.00', '', '850.00', '0.00', '519', 'pending'), 
('1136', '2020-08-04', '2020-08-04', '00459', 'S. Bilirubin', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '520', 'pending'), 
('1137', '2020-08-04', '2020-08-04', '00459', 'Hbs Ag', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '520', 'pending'), 
('1138', '2020-08-04', '2020-08-04', '00459', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '520', 'pending'), 
('1139', '2020-08-04', '2020-08-04', '00460', 'CBC', '', '12', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '521', 'pending'), 
('1140', '2020-08-04', '2020-08-04', '00460', 'RBS', '', '12', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '521', 'pending'), 
('1141', '2020-08-04', '2020-08-04', '00460', 'S. Creatinine', '', '12', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '521', 'pending'), 
('1142', '2020-08-04', '2020-08-04', '00460', 'Widal Test', '', '12', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '521', 'pending'), 
('1143', '2020-08-04', '2020-08-04', '00460', 'R/E M/E', '', '12', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '521', 'pending'), 
('1144', '2020-08-04', '2020-08-04', '00460', 'Whole Abdomen', '', '12', '23', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '521', 'pending'), 
('1145', '2020-08-04', '2020-08-04', '00461', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '522', 'pending'), 
('1146', '2020-08-05', '2020-08-05', '00462', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '523', 'pending'), 
('1147', '2020-08-05', '2020-08-05', '00462', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '523', 'pending'), 
('1148', '2020-08-05', '2020-08-05', '00462', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '523', 'pending'), 
('1149', '2020-08-05', '2020-08-05', '00463', 'S.__IGE', '', '23', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '1000.00', '0.00', '524', 'pending'), 
('1150', '2020-08-05', '2020-08-05', '00464', 'S.IGE', '', '23', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '1000.00', '0.00', '525', 'pending'), 
('1151', '2020-08-05', '2020-08-05', '00465', 'S.__IGE', '', '23', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '1000.00', '0.00', '526', 'pending'), 
('1152', '2020-08-05', '2020-08-05', '00465', 'RBS', '', '23', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '526', 'pending'), 
('1153', '2020-08-05', '2020-08-05', '00465', 'S. Creatinine', '', '23', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '526', 'pending'), 
('1154', '2020-08-05', '2020-08-05', '00466', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '527', 'pending'), 
('1155', '2020-08-05', '2020-08-05', '00467', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '528', 'pending'), 
('1156', '2020-08-05', '2020-08-05', '00467', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '528', 'pending'), 
('1157', '2020-08-05', '2020-08-05', '00467', 'R/E M/E', '', '19', '19', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '528', 'pending'), 
('1158', '2020-08-05', '2020-08-05', '00467', 'Whole Abdomen', '', '19', '19', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '528', 'pending'), 
('1159', '2020-08-05', '2020-08-05', '00468', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '529', 'pending'), 
('1160', '2020-08-05', '2020-08-05', '00468', 'CRP', '', '19', '19', 'SEROLOGY', '201', '', '0', '0.00', '', '650.00', '0.00', '529', 'pending'), 
('1161', '2020-08-05', '2020-08-05', '00468', 'Widal Test', '', '19', '19', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '529', 'pending'), 
('1162', '2020-08-05', '2020-08-05', '00468', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '529', 'pending'), 
('1163', '2020-08-05', '2020-08-05', '00468', 'R/E M/E', '', '19', '19', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '529', 'pending'), 
('1164', '2020-08-05', '2020-08-05', '00469', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '530', 'pending'), 
('1165', '2020-08-05', '2020-08-05', '00470', 'CBC', '', '45', '19', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '531', 'pending'), 
('1166', '2020-08-05', '2020-08-05', '00470', 'CRP', '', '45', '19', 'SEROLOGY', '201', '', '0', '0.00', '', '650.00', '0.00', '531', 'pending'), 
('1167', '2020-08-05', '2020-08-05', '00470', 'RBS', '', '45', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '531', 'pending'), 
('1168', '2020-08-05', '2020-08-05', '00470', 'S. Creatinine', '', '45', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '531', 'pending'), 
('1169', '2020-08-05', '2020-08-05', '00470', 'Chest P/A View', '', '45', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '531', 'pending'), 
('1170', '2020-08-05', '2020-08-05', '00470', 'L/S_A/P', '', '45', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '531', 'pending'), 
('1171', '2020-08-05', '2020-08-05', '00470', 'U_S_G__W_/_A', '', '45', '19', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '531', 'pending'), 
('1172', '2020-08-05', '2020-08-05', '00471', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '532', 'pending'), 
('1173', '2020-08-05', '2020-08-05', '00471', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '532', 'pending'), 
('1174', '2020-08-05', '2020-08-05', '00471', 'S. Creatinine', '', '19', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '532', 'pending'), 
('1175', '2020-08-05', '2020-08-05', '00471', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '532', 'pending'), 
('1176', '2020-08-05', '2020-08-05', '00471', 'U_S_G__W_/_A', '', '19', '19', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '532', 'pending'), 
('1177', '2020-08-05', '2020-08-05', '00472', 'CBC', '', '29', '25', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '533', 'pending'), 
('1178', '2020-08-05', '2020-08-05', '00472', 'R/E M/E', '', '29', '25', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '533', 'pending'), 
('1179', '2020-08-05', '2020-08-05', '00473', 'PREGNANCY_PROFILE', '', '20', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '534', 'pending'), 
('1180', '2020-08-05', '2020-08-05', '00474', 'Pregnancy Profile', '', '19', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '535', 'pending'), 
('1181', '2020-08-05', '2020-08-05', '00475', 'L/A', '', '19', '24', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '536', 'pending'), 
('1182', '2020-08-05', '2020-08-05', '00475', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '536', 'pending'), 
('1183', '2020-08-05', '2020-08-05', '00476', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '537', 'pending'), 
('1184', '2020-08-05', '2020-08-05', '00476', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '537', 'pending'), 
('1185', '2020-08-05', '2020-08-05', '00476', 'Hbs Ag', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '537', 'pending'), 
('1186', '2020-08-05', '2020-08-05', '00477', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '538', 'pending'), 
('1187', '2020-08-05', '2020-08-05', '00477', 'CRP', '', '19', '19', 'SEROLOGY', '201', '', '0', '0.00', '', '650.00', '0.00', '538', 'pending'), 
('1188', '2020-08-05', '2020-08-05', '00477', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '538', 'pending'), 
('1189', '2020-08-05', '2020-08-05', '00477', 'X-RAY', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '538', 'pending'), 
('1190', '2020-08-05', '2020-08-05', '00477', 'X-RAY', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '538', 'pending'), 
('1191', '2020-08-05', '2020-08-05', '00478', 'CBC', '', '19', '19', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '539', 'pending'), 
('1192', '2020-08-05', '2020-08-05', '00478', 'CRP', '', '19', '19', 'SEROLOGY', '201', '', '0', '0.00', '', '650.00', '0.00', '539', 'pending'), 
('1193', '2020-08-05', '2020-08-05', '00478', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '539', 'pending'), 
('1194', '2020-08-05', '2020-08-05', '00478', 'X-RAY', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '539', 'pending'), 
('1195', '2020-08-05', '2020-08-05', '00479', 'S. Bilirubin', '', '19', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '540', 'pending'), 
('1196', '2020-08-05', '2020-08-05', '00480', 'CBC', '', '20', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '541', 'pending'), 
('1197', '2020-08-06', '2020-08-06', '00481', '2Hour After 75 Gram, Glucose', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '300.00', '0.00', '542', 'pending'), 
('1198', '2020-08-06', '2020-08-06', '00482', '	Hb%_/ESR', '', '19', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '543', 'pending'), 
('1199', '2020-08-06', '2020-08-06', '00482', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '543', 'pending'), 
('1200', '2020-08-06', '2020-08-06', '00483', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '544', 'pending'), 
('1201', '2020-08-06', '2020-08-06', '00484', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '545', 'pending'), 
('1202', '2020-08-06', '2020-08-06', '00485', 'Pregnancy Profile', '', '19', '32', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '546', 'pending'), 
('1203', '2020-08-06', '2020-08-06', '00485', 'S.TSH', '', '19', '32', 'HORMON', '201', '', '0', '0.00', '', '800.00', '0.00', '546', 'pending'), 
('1204', '2020-08-06', '2020-08-06', '00486', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '547', 'pending'), 
('1205', '2020-08-06', '2020-08-06', '00487', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '548', 'pending'), 
('1206', '2020-08-06', '2020-08-06', '00487', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '548', 'pending'), 
('1207', '2020-08-06', '2020-08-06', '00487', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '548', 'pending'), 
('1208', '2020-08-06', '2020-08-06', '00487', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '548', 'pending'), 
('1209', '2020-08-06', '2020-08-06', '00487', 'Whole Abdomen', '', '19', '23', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '548', 'pending'), 
('1210', '2020-08-06', '2020-08-06', '00487', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '548', 'pending'), 
('1211', '2020-08-06', '2020-08-06', '00487', 'S. Bilirubin', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '548', 'pending'), 
('1212', '2020-08-06', '2020-08-06', '00488', 'L/A', '', '19', '24', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '549', 'pending'), 
('1213', '2020-08-06', '2020-08-06', '00489', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '550', 'pending'), 
('1214', '2020-08-06', '2020-08-06', '00489', 'CRP', '', '19', '19', 'SEROLOGY', '201', '', '0', '0.00', '', '650.00', '0.00', '550', 'pending'), 
('1215', '2020-08-06', '2020-08-06', '00489', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '550', 'pending'), 
('1216', '2020-08-06', '2020-08-06', '00489', 'DIGITAL__X-RAY_____EXPRESS', '', '19', '19', 'DIGITAL X-RAY', '', '', '0', '0.00', '', '400.00', '0.00', '550', 'pending'), 
('1217', '2020-08-06', '2020-08-06', '00489', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '550', 'pending'), 
('1218', '2020-08-06', '2020-08-06', '00490', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '551', 'pending'), 
('1219', '2020-08-06', '2020-08-06', '00490', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '551', 'pending'), 
('1220', '2020-08-06', '2020-08-06', '00490', 'DIGITAL_X-RAY_EXPRESS', '', '19', '19', 'DIGITAL_X-RAY_EXPRESS', '204', '', '0', '0.00', '', '400.00', '0.00', '551', 'pending'), 
('1221', '2020-08-06', '2020-08-06', '00491', 'DANTAL_X-RAY', '', '20', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '552', 'pending'), 
('1222', '2020-08-06', '2020-08-06', '00492', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '553', 'pending'), 
('1223', '2020-08-06', '2020-08-06', '00493', 'PREGNANCY_PROFILE', '', '20', '23', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '554', 'pending'), 
('1224', '2020-08-06', '2020-08-06', '00494', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '555', 'pending'), 
('1225', '2020-08-06', '2020-08-06', '00495', 'S.TSH-1000', '', '19', '23', 'HORMON', '201', '', '0', '0.00', '', '1000.00', '0.00', '556', 'pending'), 
('1226', '2020-08-06', '2020-08-06', '00495', 'FT4', '', '19', '23', 'HORMON', '201', '', '0', '0.00', '', '800.00', '0.00', '556', 'pending'), 
('1227', '2020-08-06', '2020-08-06', '00496', 'CBC', '', '19', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '557', 'pending'), 
('1228', '2020-08-06', '2020-08-06', '00496', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '557', 'pending'), 
('1229', '2020-08-06', '2020-08-06', '00496', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '557', 'pending'), 
('1230', '2020-08-06', '2020-08-06', '00497', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '558', 'pending'), 
('1231', '2020-08-06', '2020-08-06', '00498', 'S. Bilirubin', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '559', 'pending'), 
('1232', '2020-08-06', '2020-08-06', '00498', 'Whole Abdomen', '', '19', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '559', 'pending'), 
('1234', '2020-08-07', '2020-08-07', '00500', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '561', 'pending'), 
('1235', '2020-08-07', '2020-08-07', '00501', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '562', 'pending'), 
('1236', '2020-08-07', '2020-08-07', '00502', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '563', 'pending'), 
('1237', '2020-08-07', '2020-08-07', '00503', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '564', 'pending'), 
('1238', '2020-08-07', '2020-08-07', '00504', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '565', 'pending'), 
('1239', '2020-08-07', '2020-08-07', '00505', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '566', 'pending'), 
('1240', '2020-08-07', '2020-08-07', '00506', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '567', 'pending'), 
('1241', '2020-08-07', '2020-08-07', '00507', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '568', 'pending'), 
('1242', '2020-08-07', '2020-08-07', '00507', 'CRP', '', '19', '19', 'SEROLOGY', '201', '', '0', '0.00', '', '650.00', '0.00', '568', 'pending'), 
('1243', '2020-08-07', '2020-08-07', '00507', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '568', 'pending'), 
('1244', '2020-08-07', '2020-08-07', '00508', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '569', 'pending'), 
('1245', '2020-08-07', '2020-08-07', '00508', 'Lumbo-Sacral B.V', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '500.00', '0.00', '569', 'pending'), 
('1246', '2020-08-07', '2020-08-07', '00509', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '570', 'pending'), 
('1247', '2020-08-07', '2020-08-07', '00509', 'X-RAY', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '570', 'pending'), 
('1248', '2020-08-07', '2020-08-07', '00509', 'U_S_G__W_/_A', '', '19', '19', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '570', 'pending'), 
('1249', '2020-08-07', '2020-08-07', '00510', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '571', 'pending'), 
('1250', '2020-08-07', '2020-08-07', '00510', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '571', 'pending'), 
('1251', '2020-08-07', '2020-08-07', '00510', 'S. Creatinine', '', '19', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '571', 'pending'), 
('1252', '2020-08-07', '2020-08-07', '00510', 'Whole Abdomen', '', '19', '19', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '571', 'pending'), 
('1253', '2020-08-07', '2020-08-07', '00511', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '572', 'pending'), 
('1254', '2020-08-07', '2020-08-07', '00511', 'R/A Test', '', '19', '19', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '572', 'pending'), 
('1255', '2020-08-07', '2020-08-07', '00511', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '572', 'pending'), 
('1256', '2020-08-07', '2020-08-07', '00512', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '573', 'pending'), 
('1257', '2020-08-07', '2020-08-07', '00512', 'L/S_A/P', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '573', 'pending'), 
('1258', '2020-08-07', '2020-08-07', '00513', 'ESR', '', '20', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '574', 'pending'), 
('1259', '2020-08-07', '2020-08-07', '00513', 'ECG', '', '20', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '574', 'pending'), 
('1260', '2020-08-07', '2020-08-07', '00513', 'Chest P/A View', '', '20', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '574', 'pending'), 
('1261', '2020-08-07', '2020-08-07', '00514', 'U_S_G__W_/_A', '', '19', '19', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '575', 'pending'), 
('1262', '2020-08-07', '2020-08-07', '00515', 'S. Creatinine', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '576', 'pending'), 
('1263', '2020-08-07', '2020-08-07', '00515', 'S.__ELECROLYTES', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '850.00', '0.00', '576', 'pending'), 
('1264', '2020-08-07', '2020-08-07', '00516', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '577', 'pending'), 
('1265', '2020-08-07', '2020-08-07', '00517', 'R/E M/E', '', '20', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '578', 'pending'), 
('1266', '2020-08-07', '2020-08-07', '00517', 'U_S_G__W_/_A', '', '20', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '578', 'pending'), 
('1267', '2020-08-07', '2020-08-07', '00518', '	Hb%_/ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '579', 'pending'), 
('1268', '2020-08-07', '2020-08-07', '00518', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '579', 'pending'), 
('1269', '2020-08-07', '2020-08-07', '00518', 'S. Creatinine', '', '19', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '579', 'pending'), 
('1270', '2020-08-07', '2020-08-07', '00518', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '579', 'pending'), 
('1271', '2020-08-07', '2020-08-07', '00518', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '579', 'pending'), 
('1272', '2020-08-07', '2020-08-07', '00518', 'U_S_G__W_/_A', '', '19', '19', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '579', 'pending'), 
('1273', '2020-08-07', '2020-08-07', '00519', 'ESR', '', '20', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '580', 'pending'), 
('1274', '2020-08-07', '2020-08-07', '00519', 'RBS', '', '20', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '580', 'pending'), 
('1275', '2020-08-07', '2020-08-07', '00519', 'Chest P/A View', '', '20', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '580', 'pending'), 
('1276', '2020-08-07', '2020-08-07', '00520', 'R/E M/E', '', '20', '19', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '581', 'pending'), 
('1277', '2020-08-07', '2020-08-07', '00520', 'U_S_G__W_/_A', '', '20', '19', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '581', 'pending'), 
('1278', '2020-08-07', '2020-08-07', '00521', 'CBC', '', '19', '19', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '582', 'pending'), 
('1279', '2020-08-07', '2020-08-07', '00521', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '582', 'pending'), 
('1280', '2020-08-07', '2020-08-07', '00522', 'RBS', '', '20', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '583', 'pending'), 
('1281', '2020-08-07', '2020-08-07', '00522', 'S. Creatinine', '', '20', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '583', 'pending'), 
('1282', '2020-08-07', '2020-08-07', '00522', 'ECG', '', '20', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '583', 'pending'), 
('1283', '2020-08-07', '2020-08-07', '00523', 'X-RAY', '', '20', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '584', 'pending'), 
('1284', '2020-08-07', '2020-08-07', '00524', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '585', 'pending'), 
('1285', '2020-08-07', '2020-08-07', '00525', 'Hb%_/ESR', '', '20', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '586', 'pending'), 
('1286', '2020-08-07', '2020-08-07', '00525', 'RBS', '', '20', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '586', 'pending'), 
('1287', '2020-08-07', '2020-08-07', '00525', 'ECG', '', '20', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '586', 'pending'), 
('1288', '2020-08-07', '2020-08-07', '00525', 'L/S_A/P', '', '20', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '586', 'pending'), 
('1289', '2020-08-07', '2020-08-07', '00526', 'CRP', '', '19', '19', 'SEROLOGY', '201', '', '0', '0.00', '', '650.00', '0.00', '587', 'pending'), 
('1290', '2020-08-07', '2020-08-07', '00526', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '587', 'pending'), 
('1291', '2020-08-07', '2020-08-07', '00526', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '587', 'pending'), 
('1292', '2020-08-07', '2020-08-07', '00527', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '588', 'pending'), 
('1293', '2020-08-07', '2020-08-07', '00528', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '589', 'pending'), 
('1294', '2020-08-07', '2020-08-07', '00528', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '589', 'pending'), 
('1295', '2020-08-07', '2020-08-07', '00528', 'Whole Abdomen', '', '19', '19', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '589', 'pending'), 
('1296', '2020-08-07', '2020-08-07', '00529', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '590', 'pending'), 
('1297', '2020-08-07', '2020-08-07', '00530', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '591', 'pending'), 
('1298', '2020-08-07', '2020-08-07', '00530', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '591', 'pending'), 
('1299', '2020-08-07', '2020-08-07', '00530', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '591', 'pending'), 
('1300', '2020-08-07', '2020-08-07', '00531', 'R/E M/E', '', '19', '19', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '592', 'pending'), 
('1301', '2020-08-07', '2020-08-07', '00531', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '592', 'pending'), 
('1302', '2020-08-07', '2020-08-07', '00531', 'Whole Abdomen', '', '19', '19', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '592', 'pending'), 
('1303', '2020-08-07', '2020-08-07', '00532', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '593', 'pending'), 
('1304', '2020-08-07', '2020-08-07', '00533', 'ESR', '', '20', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '594', 'pending'), 
('1305', '2020-08-07', '2020-08-07', '00533', 'RBS', '', '20', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '594', 'pending'), 
('1306', '2020-08-08', '2020-08-08', '00534', 'F.SUGAR_/_SUGAR_2HABF_', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '300.00', '0.00', '595', 'pending'), 
('1307', '2020-08-08', '2020-08-08', '00535', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '596', 'pending'), 
('1308', '2020-08-08', '2020-08-08', '00536', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '597', 'pending'), 
('1309', '2020-08-08', '2020-08-08', '00536', 'Hb%', '', '19', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '597', 'pending'), 
('1310', '2020-08-08', '2020-08-08', '00536', 'Blood For Grouping', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '597', 'pending'), 
('1311', '2020-08-08', '2020-08-08', '00536', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '597', 'pending'), 
('1312', '2020-08-08', '2020-08-08', '00537', 'PREGNANCY_PROFILE', '', '10', '30', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '598', 'pending'), 
('1313', '2020-08-08', '2020-08-08', '00538', 'XRAY-LEFT_FOOT_B/V', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '599', 'pending'), 
('1314', '2020-08-08', '2020-08-08', '00538', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '599', 'pending'), 
('1315', '2020-08-08', '2020-08-08', '00539', 'Pregnancy Test', '', '19', '32', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '600', 'pending'), 
('1316', '2020-08-08', '2020-08-08', '00539', 'PREGNANCY_PROFILE', '', '19', '32', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '600', 'pending'), 
('1317', '2020-08-08', '2020-08-08', '00540', 'Whole Abdomen', '', '19', '28', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '601', 'pending'), 
('1318', '2020-08-08', '2020-08-08', '00540', 'R/E M/E', '', '19', '28', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '601', 'pending'), 
('1319', '2020-08-08', '2020-08-08', '00541', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '602', 'pending'), 
('1320', '2020-08-08', '2020-08-08', '00541', 'S. Creatinine                                                           ', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '602', 'pending'), 
('1321', '2020-08-08', '2020-08-08', '00542', 'PREGNANCY_PROFILE', '', '20', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '603', 'pending'), 
('1322', '2020-08-08', '2020-08-08', '00543', 'X-RAY_LEFT_LEG_B/V', '', '20', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '604', 'pending'), 
('1323', '2020-08-08', '2020-08-08', '00544', 'U_S_G__W_/_A', '', '29', '25', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '605', 'pending'), 
('1324', '2020-08-08', '2020-08-08', '00545', 'USG_F/C', '', '19', '24', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '606', 'pending'), 
('1325', '2020-08-08', '2020-08-08', '00546', 'USG_F/C', '', '19', '24', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '607', 'pending'), 
('1326', '2020-08-08', '2020-08-08', '00547', 'PREGNANCY_PROFILE', '', '20', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '608', 'pending'), 
('1327', '2020-08-08', '2020-08-08', '00548', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '609', 'pending'), 
('1329', '2020-08-09', '2020-08-09', '00550', 'CBC', '', '20', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '611', 'pending'), 
('1330', '2020-08-09', '2020-08-09', '00550', 'Widal Test', '', '20', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '611', 'pending'), 
('1331', '2020-08-09', '2020-08-09', '00550', 'S. Bilirubin', '', '20', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '611', 'pending'), 
('1332', '2020-08-09', '2020-08-09', '00550', 'RBS', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '611', 'pending'), 
('1333', '2020-08-09', '2020-08-09', '00550', 'R/E M/E', '', '20', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '611', 'pending'), 
('1334', '2020-08-09', '2020-08-09', '00551', 'RBS', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '612', 'pending'), 
('1335', '2020-08-09', '2020-08-09', '00551', 'Hb%_/ESR', '', '20', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '612', 'pending'), 
('1336', '2020-08-09', '2020-08-09', '00551', 'S. Creatinine', '', '20', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '612', 'pending'), 
('1337', '2020-08-09', '2020-08-09', '00551', 'U_S_G__W_/_A', '', '20', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '612', 'pending'), 
('1338', '2020-08-09', '2020-08-09', '00551', 'R/E M/E', '', '20', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '612', 'pending'), 
('1339', '2020-08-09', '2020-08-09', '00552', 'X-RAY', '', '20', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '613', 'pending'), 
('1340', '2020-08-09', '2020-08-09', '00553', 'S. Bilirubin', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '614', 'pending'), 
('1341', '2020-08-09', '2020-08-09', '00554', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '615', 'pending'), 
('1342', '2020-08-09', '2020-08-09', '00554', 'X-RAY', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '615', 'pending'), 
('1343', '2020-08-09', '2020-08-09', '00555', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '616', 'pending'), 
('1344', '2020-08-09', '2020-08-09', '00555', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '616', 'pending'), 
('1345', '2020-08-09', '2020-08-09', '00555', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '616', 'pending'), 
('1346', '2020-08-09', '2020-08-09', '00555', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '616', 'pending'), 
('1347', '2020-08-09', '2020-08-09', '00555', 'W_/_A', '', '19', '23', 'U_S_G_', '202', '', '0', '0.00', '', '750.00', '0.00', '616', 'pending'), 
('1348', '2020-08-09', '2020-08-09', '00555', 'Chest P/A View', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '616', 'pending'), 
('1349', '2020-08-09', '2020-08-09', '00555', 'X-RAY', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '616', 'pending'), 
('1350', '2020-08-09', '2020-08-09', '00556', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '617', 'pending'), 
('1351', '2020-08-09', '2020-08-09', '00556', 'PREGNANCY_PROFILE', '', '19', '23', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '617', 'pending'), 
('1352', '2020-08-09', '2020-08-09', '00557', 'Pregnancy Profile', '', '19', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '618', 'pending'), 
('1353', '2020-08-09', '2020-08-09', '00558', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '619', 'pending'), 
('1354', '2020-08-09', '2020-08-09', '00559', 'Pregnancy Profile', '', '20', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '620', 'pending'), 
('1355', '2020-08-09', '2020-08-09', '00560', 'CBC', '', '19', '20', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '621', 'pending'), 
('1356', '2020-08-09', '2020-08-09', '00560', 'Pregnancy Test', '', '19', '20', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '621', 'pending'), 
('1357', '2020-08-09', '2020-08-09', '00560', 'R/E M/E', '', '19', '20', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '621', 'pending'), 
('1358', '2020-08-09', '2020-08-09', '00561', 'PREGNANCY_PROFILE', '', '19', '20', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '622', 'pending'), 
('1359', '2020-08-09', '2020-08-09', '00561', 'R/E M/E', '', '19', '20', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '622', 'pending'), 
('1360', '2020-08-09', '2020-08-09', '00561', 'RBS', '', '19', '20', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '622', 'pending'), 
('1361', '2020-08-09', '2020-08-09', '00562', 'CBC', '', '19', '20', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '623', 'pending'), 
('1362', '2020-08-09', '2020-08-09', '00562', 'L/A', '', '19', '20', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '623', 'pending'), 
('1363', '2020-08-09', '2020-08-09', '00563', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '624', 'pending'), 
('1364', '2020-08-09', '2020-08-09', '00563', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '624', 'pending'), 
('1365', '2020-08-09', '2020-08-09', '00563', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '624', 'pending'), 
('1366', '2020-08-09', '2020-08-09', '00563', 'Whole Abdomen', '', '19', '23', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '624', 'pending'), 
('1367', '2020-08-09', '2020-08-09', '00563', 'DIGITAL__X-RAY_____EXPRESS', '', '19', '23', 'DIGITAL X-RAY', ' AL-KIDMA', '', '0', '0.00', '', '400.00', '0.00', '624', 'pending'), 
('1368', '2020-08-09', '2020-08-09', '00564', 'S. Creatinine', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '625', 'pending'), 
('1369', '2020-08-09', '2020-08-09', '00564', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '625', 'pending'), 
('1370', '2020-08-09', '2020-08-09', '00564', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '625', 'pending'), 
('1371', '2020-08-09', '2020-08-09', '00565', 'RBS', '', '19', '20', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '626', 'pending'), 
('1372', '2020-08-09', '2020-08-09', '00565', 'X-RAY', '', '19', '20', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '626', 'pending'), 
('1373', '2020-08-09', '2020-08-09', '00566', 'R/E M/E', '', '19', '20', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '627', 'pending'), 
('1374', '2020-08-09', '2020-08-09', '00566', 'RBS', '', '19', '20', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '627', 'pending'), 
('1375', '2020-08-09', '2020-08-09', '00567', 'L/A', '', '19', '20', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '628', 'pending'), 
('1376', '2020-08-09', '2020-08-09', '00567', 'Pregnancy Test', '', '19', '20', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '628', 'pending'), 
('1377', '2020-08-09', '2020-08-09', '00567', 'R/E M/E', '', '19', '20', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '628', 'pending'), 
('1378', '2020-08-09', '2020-08-09', '00568', 'Pregnancy Profile', '', '19', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '629', 'pending'), 
('1379', '2020-08-09', '2020-08-09', '00569', 'S. Bilirubin', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '630', 'pending'), 
('1380', '2020-08-09', '2020-08-09', '00570', 'R/E M/E', '', '20', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '631', 'pending'), 
('1381', '2020-08-10', '2020-08-10', '00571', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '632', 'pending'), 
('1382', '2020-08-10', '2020-08-10', '00572', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '633', 'pending'), 
('1383', '2020-08-10', '2020-08-10', '00573', 'Blood For Grouping', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '634', 'pending'), 
('1384', '2020-08-10', '2020-08-10', '00574', 'PREGNANCY_PROFILE', '', '19', '20', 'USG_ULTRASONOGRAPHY', '202', '', '20', '120.00', '', '650.00', '0.00', '635', 'pending'), 
('1385', '2020-08-10', '2020-08-10', '00575', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '636', 'pending'), 
('1386', '2020-08-10', '2020-08-10', '00576', 'DIGITAL_X-RAY_EXPRESS', '', '19', '23', 'DIGITAL_X-RAY_EXPRESS', '204', '', '0', '0.00', '', '400.00', '0.00', '637', 'pending'), 
('1387', '2020-08-10', '2020-08-10', '00576', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '637', 'pending'), 
('1388', '2020-08-10', '2020-08-10', '00577', 'USG_F_/C', '', '19', '32', 'USG_COLOUR', '202', '', '23', '120.00', '', '850.00', '0.00', '638', 'pending'), 
('1389', '2020-08-10', '2020-08-10', '00577', 'Hbs Ag', '', '19', '32', 'SEROLOGY', '201', '', '23', '120.00', '', '400.00', '0.00', '638', 'pending'), 
('1390', '2020-08-10', '2020-08-10', '00577', 'R/E M/E', '', '19', '32', 'URINE', '201', '', '23', '120.00', '', '150.00', '0.00', '638', 'pending'), 
('1391', '2020-08-10', '2020-08-10', '00577', 'V.D.R.L', '', '19', '32', 'SEROLOGY', '201', '', '23', '120.00', '', '400.00', '0.00', '638', 'pending'), 
('1392', '2020-08-10', '2020-08-10', '00578', 'USG_F/C', '', '19', '24', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '639', 'pending'), 
('1393', '2020-08-10', '2020-08-10', '00579', 'USG_F/C', '', '19', '24', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '640', 'pending'), 
('1394', '2020-08-10', '2020-08-10', '00580', 'Hb%_/ESR', '', '20', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '641', 'pending'), 
('1395', '2020-08-10', '2020-08-10', '00580', 'Widal Test', '', '20', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '641', 'pending'), 
('1396', '2020-08-10', '2020-08-10', '00580', 'R/E M/E', '', '20', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '641', 'pending'), 
('1397', '2020-08-10', '2020-08-10', '00580', 'PREGNANCY_PROFILE', '', '20', '23', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '641', 'pending'), 
('1398', '2020-08-11', '2020-08-11', '00581', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '642', 'pending'), 
('1399', '2020-08-11', '2020-08-11', '00582', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '643', 'pending'), 
('1400', '2020-08-11', '2020-08-11', '00583', 'R/E M/E', '', '20', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '644', 'pending'), 
('1401', '2020-08-11', '2020-08-11', '00584', 'S. Bilirubin', '', '20', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '645', 'pending'), 
('1402', '2020-08-11', '2020-08-11', '00584', 'Widal Test', '', '20', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '645', 'pending'), 
('1403', '2020-08-11', '2020-08-11', '00585', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '646', 'pending'), 
('1404', '2020-08-11', '2020-08-11', '00586', 'RBS', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '647', 'pending'), 
('1405', '2020-08-11', '2020-08-11', '00586', 'CUS', '', '20', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '647', 'pending'), 
('1406', '2020-08-11', '2020-08-11', '00587', 'CBC', '', '19', '32', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '648', 'pending'), 
('1407', '2020-08-11', '2020-08-11', '00587', 'RBS', '', '19', '32', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '648', 'pending'), 
('1408', '2020-08-11', '2020-08-11', '00587', 'R/E M/E', '', '19', '32', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '648', 'pending'), 
('1409', '2020-08-11', '2020-08-11', '00587', 'L/A', '', '19', '32', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '648', 'pending'), 
('1410', '2020-08-11', '2020-08-11', '00588', 'PREGNANCY_PROFILE', '', '19', '23', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '649', 'pending'), 
('1411', '2020-08-11', '2020-08-11', '00589', 'CBC', '', '20', '32', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '650', 'pending'), 
('1412', '2020-08-11', '2020-08-11', '00589', 'RBS', '', '20', '32', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '650', 'pending'), 
('1413', '2020-08-11', '2020-08-11', '00589', 'Blood For Grouping', '', '20', '32', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '650', 'pending'), 
('1414', '2020-08-11', '2020-08-11', '00589', 'Hbe Ag', '', '20', '32', 'SEROLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '650', 'pending'), 
('1415', '2020-08-11', '2020-08-11', '00589', 'V.D.R.L', '', '20', '32', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '650', 'pending'), 
('1416', '2020-08-11', '2020-08-11', '00589', 'R/E M/E', '', '20', '32', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '650', 'pending'), 
('1417', '2020-08-11', '2020-08-11', '00589', 'PREGNANCY_PROFILE', '', '20', '32', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '650', 'pending'), 
('1418', '2020-08-11', '2020-08-11', '00590', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '651', 'pending'), 
('1419', '2020-08-11', '2020-08-11', '00591', 'ECG', '', '19', '31', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '652', 'pending'), 
('1420', '2020-08-11', '2020-08-11', '00591', 'RBS', '', '19', '31', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '652', 'pending'), 
('1421', '2020-08-11', '2020-08-11', '00591', 'Lipid Profile', '', '19', '31', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '1200.00', '0.00', '652', 'pending'), 
('1422', '2020-08-11', '2020-08-11', '00591', 'DIGITAL__X-RAY_____EXPRESS', '', '19', '31', 'DIGITAL X-RAY', ' AL-KIDMA', '', '0', '0.00', '', '400.00', '0.00', '652', 'pending'), 
('1423', '2020-08-11', '2020-08-11', '00592', 'Pregnancy Profile', '', '19', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '653', 'pending'), 
('1424', '2020-08-11', '2020-08-11', '00593', 'USG_F/C', '', '20', '32', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '654', 'pending'), 
('1425', '2020-08-11', '2020-08-11', '00593', 'RBS', '', '20', '32', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '654', 'pending'), 
('1426', '2020-08-11', '2020-08-11', '00593', 'Hb%', '', '20', '32', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '654', 'pending'), 
('1427', '2020-08-11', '2020-08-11', '00593', 'R/E M/E', '', '20', '32', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '654', 'pending'), 
('1428', '2020-08-11', '2020-08-11', '00593', 'Blood For Grouping', '', '20', '32', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '654', 'pending'), 
('1429', '2020-08-11', '2020-08-11', '00594', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '655', 'pending'), 
('1430', '2020-08-11', '2020-08-11', '00595', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '656', 'pending'), 
('1431', '2020-08-11', '2020-08-11', '00596', 'PREGNANCY_PROFILE', '', '20', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '657', 'pending'), 
('1432', '2020-08-11', '2020-08-11', '00596', 'Hb%', '', '20', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '657', 'pending'), 
('1433', '2020-08-11', '2020-08-11', '00596', 'R/E M/E', '', '20', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '657', 'pending'), 
('1434', '2020-08-11', '2020-08-11', '00596', 'RBS', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '657', 'pending'), 
('1435', '2020-08-11', '2020-08-11', '00596', 'S. Creatinine', '', '20', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '657', 'pending'), 
('1436', '2020-08-11', '2020-08-11', '00596', 'Blood For Grouping', '', '20', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '657', 'pending'), 
('1437', '2020-08-11', '2020-08-11', '00596', 'V.D.R.L', '', '20', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '657', 'pending'), 
('1438', '2020-08-11', '2020-08-11', '00596', 'Hbe Ag', '', '20', '24', 'SEROLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '657', 'pending'), 
('1439', '2020-08-11', '2020-08-11', '00597', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '658', 'pending'), 
('1440', '2020-08-11', '2020-08-11', '00598', 'Hb%', '', '19', '32', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '659', 'pending'), 
('1441', '2020-08-11', '2020-08-11', '00598', 'Blood For Grouping', '', '19', '32', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '659', 'pending'), 
('1442', '2020-08-11', '2020-08-11', '00598', 'R/E M/E', '', '19', '32', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '659', 'pending'), 
('1443', '2020-08-11', '2020-08-11', '00598', 'Pregnancy Profile', '', '19', '32', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '659', 'pending'), 
('1444', '2020-08-11', '2020-08-11', '00598', 'Hbs Ag', '', '19', '32', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '659', 'pending'), 
('1445', '2020-08-12', '2020-08-12', '00599', 'CBC', '', '3', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '660', 'pending'), 
('1446', '2020-08-12', '2020-08-12', '00599', 'Widal Test', '', '3', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '660', 'pending'), 
('1447', '2020-08-12', '2020-08-12', '00599', 'RBS', '', '3', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '660', 'pending'), 
('1448', '2020-08-12', '2020-08-12', '00599', 'S. Creatinine', '', '3', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '660', 'pending'), 
('1449', '2020-08-12', '2020-08-12', '00599', 'R/E M/E', '', '3', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '660', 'pending'), 
('1450', '2020-08-12', '2020-08-12', '00599', 'Whole Abdomen', '', '3', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '660', 'pending'), 
('1451', '2020-08-12', '2020-08-12', '00600', 'PREGNANCY_PROFILE', '', '19', '23', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '661', 'pending'), 
('1452', '2020-08-12', '2020-08-12', '00601', 'PREGNANCY_PROFILE', '', '10', '30', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '662', 'pending'), 
('1453', '2020-08-12', '2020-08-12', '00602', 'RBS', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '663', 'pending'), 
('1454', '2020-08-12', '2020-08-12', '00603', 'Chest P/A View', '', '20', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '664', 'pending'), 
('1455', '2020-08-12', '2020-08-12', '00603', 'U_S_G__W_/_A', '', '20', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '664', 'pending'), 
('1456', '2020-08-12', '2020-08-12', '00604', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '665', 'pending'), 
('1457', '2020-08-12', '2020-08-12', '00604', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '665', 'pending'), 
('1458', '2020-08-12', '2020-08-12', '00605', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '666', 'pending'), 
('1459', '2020-08-12', '2020-08-12', '00606', 'CBC', '', '20', '19', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '667', 'pending'), 
('1460', '2020-08-12', '2020-08-12', '00606', 'R/E M/E', '', '20', '19', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '667', 'pending'), 
('1461', '2020-08-12', '2020-08-12', '00606', 'W_/_A', '', '20', '19', 'U_S_G_', '202', '', '0', '0.00', '', '750.00', '0.00', '667', 'pending'), 
('1462', '2020-08-12', '2020-08-12', '00607', 'DIGITAL_X-RAY_EXPRESS', '', '20', '19', 'DIGITAL_X-RAY_EXPRESS', '204', '', '0', '0.00', '', '400.00', '0.00', '668', 'pending'), 
('1463', '2020-08-13', '2020-08-13', '00608', 'F.SUGAR_/_SUGAR_2HABF_', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '300.00', '0.00', '669', 'pending'), 
('1464', '2020-08-13', '2020-08-13', '00608', 'S. Creatinine', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '669', 'pending'), 
('1465', '2020-08-13', '2020-08-13', '00609', 'ECG', '', '19', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '670', 'pending'), 
('1466', '2020-08-13', '2020-08-13', '00609', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '670', 'pending'), 
('1467', '2020-08-13', '2020-08-13', '00609', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '670', 'pending'), 
('1468', '2020-08-13', '2020-08-13', '00609', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '670', 'pending'), 
('1469', '2020-08-13', '2020-08-13', '00609', 'ESR', '', '19', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '670', 'pending'), 
('1470', '2020-08-13', '2020-08-13', '00610', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '671', 'pending'), 
('1471', '2020-08-13', '2020-08-13', '00610', 'DIGITAL_X-RAY_EXPRESS', '', '19', '24', 'DIGITAL_X-RAY_EXPRESS', '204', '', '0', '0.00', '', '400.00', '0.00', '671', 'pending'), 
('1472', '2020-08-13', '2020-08-13', '00611', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '672', 'pending'), 
('1473', '2020-08-13', '2020-08-13', '00612', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '673', 'pending'), 
('1474', '2020-08-13', '2020-08-13', '00612', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '673', 'pending'), 
('1475', '2020-08-13', '2020-08-13', '00613', 'PREGNANCY_PROFILE', '', '10', '30', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '674', 'pending'), 
('1476', '2020-08-13', '2020-08-13', '00614', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '675', 'pending'), 
('1477', '2020-08-13', '2020-08-13', '00615', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '676', 'pending'), 
('1478', '2020-08-13', '2020-08-13', '00616', 'Widal Test', '', '29', '25', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '677', 'pending'), 
('1479', '2020-08-13', '2020-08-13', '00616', 'R/E M/E', '', '29', '25', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '677', 'pending'), 
('1480', '2020-08-13', '2020-08-13', '00617', 'USG_F/C', '', '19', '24', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '678', 'pending'), 
('1481', '2020-08-13', '2020-08-13', '00617', 'USG_F/C', '', '19', '24', '', '', '', '0', '0.00', '', '0.00', '0.00', '679', 'pending'), 
('1482', '2020-08-13', '2020-08-13', '00618', 'V.D.R.L', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '680', 'pending'), 
('1483', '2020-08-13', '2020-08-13', '00618', 'Hb%', '', '19', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '680', 'pending'), 
('1484', '2020-08-13', '2020-08-13', '00618', 'Whole Abdomen', '', '19', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '680', 'pending'), 
('1485', '2020-08-13', '2020-08-13', '00618', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '680', 'pending'), 
('1486', '2020-08-13', '2020-08-13', '00618', 'S. Creatinine', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '680', 'pending'), 
('1487', '2020-08-13', '2020-08-13', '00618', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '680', 'pending'), 
('1488', '2020-08-13', '2020-08-13', '00619', 'DIGITAL__X-RAY_____EXPRESS', '', '19', '23', 'DIGITAL X-RAY', ' AL-KIDMA', '', '0', '0.00', '', '400.00', '0.00', '681', 'pending'), 
('1489', '2020-08-13', '2020-08-13', '00620', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '682', 'pending'), 
('1490', '2020-08-13', '2020-08-13', '00621', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '683', 'pending'), 
('1491', '2020-08-13', '2020-08-13', '00621', 'ECG', '', '19', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '683', 'pending'), 
('1492', '2020-08-13', '2020-08-13', '00621', 'Chest P/A View', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '683', 'pending'), 
('1493', '2020-08-13', '2020-08-13', '00621', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '683', 'pending'), 
('1494', '2020-08-13', '2020-08-13', '00621', 'TROPONIN_', '', '19', '23', 'IMONULOGY', '201', '', '0', '0.00', '', '1000.00', '0.00', '683', 'pending'), 
('1495', '2020-08-13', '2020-08-13', '00621', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '683', 'pending'), 
('1496', '2020-08-14', '2020-08-14', '00622', 'CBC', '', '19', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '684', 'pending'), 
('1497', '2020-08-14', '2020-08-14', '00622', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '684', 'pending'), 
('1498', '2020-08-14', '2020-08-14', '00622', 'S. Creatinine', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '684', 'pending'), 
('1499', '2020-08-14', '2020-08-14', '00622', 'Whole Abdomen', '', '19', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '684', 'pending'), 
('1500', '2020-08-14', '2020-08-14', '00622', 'ECG', '', '19', '24', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '684', 'pending'), 
('1501', '2020-08-14', '2020-08-14', '00623', 'Blood For Grouping', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '685', 'pending'), 
('1502', '2020-08-14', '2020-08-14', '00624', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '686', 'pending'), 
('1503', '2020-08-14', '2020-08-14', '00624', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '686', 'pending'), 
('1504', '2020-08-14', '2020-08-14', '00624', 'L/S_A/P', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '686', 'pending'), 
('1505', '2020-08-14', '2020-08-14', '00624', 'Whole Abdomen', '', '19', '19', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '686', 'pending'), 
('1506', '2020-08-14', '2020-08-14', '00625', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '687', 'pending'), 
('1507', '2020-08-14', '2020-08-14', '00625', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '687', 'pending'), 
('1508', '2020-08-14', '2020-08-14', '00625', 'W_/_A', '', '19', '19', 'U_S_G_', '202', '', '0', '0.00', '', '750.00', '0.00', '687', 'pending'), 
('1509', '2020-08-14', '2020-08-14', '00626', 'W_/_A', '', '19', '19', 'U_S_G_', '202', '', '0', '0.00', '', '750.00', '0.00', '688', 'pending'), 
('1510', '2020-08-14', '2020-08-14', '00627', 'Hb%', '', '19', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '689', 'pending'), 
('1511', '2020-08-14', '2020-08-14', '00627', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '689', 'pending'), 
('1512', '2020-08-14', '2020-08-14', '00627', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '689', 'pending'), 
('1513', '2020-08-14', '2020-08-14', '00627', 'PREGNANCY_PROFILE', '', '19', '23', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '689', 'pending'), 
('1514', '2020-08-14', '2020-08-14', '00627', 'V.D.R.L', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '689', 'pending'), 
('1515', '2020-08-14', '2020-08-14', '00628', 'S.G.P.T.(ALT)', '', '19', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '690', 'pending'), 
('1516', '2020-08-14', '2020-08-14', '00628', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '690', 'pending'), 
('1517', '2020-08-14', '2020-08-14', '00629', 'RBS', '', '20', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '691', 'pending'), 
('1518', '2020-08-14', '2020-08-14', '00629', 'ESR', '', '20', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '691', 'pending'), 
('1519', '2020-08-14', '2020-08-14', '00630', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '692', 'pending'), 
('1520', '2020-08-14', '2020-08-14', '00631', 'W_/_A', '', '6', '19', 'U_S_G_', '202', '', '0', '0.00', '', '750.00', '0.00', '693', 'pending'), 
('1521', '2020-08-14', '2020-08-14', '00632', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '694', 'pending'), 
('1522', '2020-08-14', '2020-08-14', '00632', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '694', 'pending'), 
('1523', '2020-08-14', '2020-08-14', '00633', 'U_S_G__W_/_A', '', '19', '19', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '695', 'pending'), 
('1524', '2020-08-14', '2020-08-14', '00634', 'U_S_G__W_/_A', '', '19', '19', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '696', 'pending'), 
('1525', '2020-08-14', '2020-08-14', '00635', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '697', 'pending'), 
('1526', '2020-08-14', '2020-08-14', '00636', 'Hbs Ag', '', '19', '19', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '698', 'pending'), 
('1527', '2020-08-14', '2020-08-14', '00636', 'V.D.R.L', '', '19', '19', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '698', 'pending'), 
('1528', '2020-08-14', '2020-08-14', '00636', 'R/E M/E', '', '19', '19', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '698', 'pending'), 
('1529', '2020-08-14', '2020-08-14', '00636', 'W_/_A', '', '19', '19', 'U_S_G_', '202', '', '0', '0.00', '', '750.00', '0.00', '698', 'pending'), 
('1530', '2020-08-14', '2020-08-14', '00637', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '699', 'pending'), 
('1531', '2020-08-14', '2020-08-14', '00638', 'ESR', '', '20', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '700', 'pending'), 
('1532', '2020-08-14', '2020-08-14', '00639', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '701', 'pending'), 
('1533', '2020-08-14', '2020-08-14', '00640', 'ESR', '', '20', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '702', 'pending'), 
('1534', '2020-08-14', '2020-08-14', '00640', 'S. Creatinine', '', '20', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '702', 'pending'), 
('1535', '2020-08-14', '2020-08-14', '00640', 'Chest P/A View', '', '20', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '702', 'pending'), 
('1536', '2020-08-14', '2020-08-14', '00641', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '703', 'pending'), 
('1537', '2020-08-14', '2020-08-14', '00641', 'Hb%', '', '19', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '703', 'pending'), 
('1538', '2020-08-14', '2020-08-14', '00641', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '703', 'pending'), 
('1539', '2020-08-14', '2020-08-14', '00641', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '703', 'pending'), 
('1540', '2020-08-14', '2020-08-14', '00641', 'S.TSH-1000', '', '19', '24', 'HORMON', '201', '', '0', '0.00', '', '1000.00', '0.00', '703', 'pending'), 
('1542', '2020-08-14', '2020-08-14', '00643', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '705', 'pending'), 
('1543', '2020-08-14', '2020-08-14', '00643', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '705', 'pending'), 
('1544', '2020-08-14', '2020-08-14', '00643', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '705', 'pending'), 
('1545', '2020-08-14', '2020-08-14', '00643', 'ECG', '', '19', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '705', 'pending'), 
('1546', '2020-08-14', '2020-08-14', '00643', 'W_/_A', '', '19', '23', 'U_S_G_', '202', '', '0', '0.00', '', '750.00', '0.00', '705', 'pending'), 
('1547', '2020-08-14', '2020-08-14', '00644', 'SOFT_TISSUC_NECK', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '706', 'pending'), 
('1548', '2020-08-14', '2020-08-14', '00644', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '706', 'pending'), 
('1549', '2020-08-14', '2020-08-14', '00644', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '706', 'pending'), 
('1550', '2020-08-14', '2020-08-14', '00644', 'ECG', '', '19', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '706', 'pending'), 
('1551', '2020-08-14', '2020-08-14', '00645', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '707', 'pending'), 
('1552', '2020-08-14', '2020-08-14', '00646', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '708', 'pending'), 
('1553', '2020-08-14', '2020-08-14', '00646', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '708', 'pending'), 
('1554', '2020-08-14', '2020-08-14', '00646', '', '', '19', '19', '', '', '', '0', '0.00', '', '0.00', '0.00', '708', 'pending'), 
('1555', '2020-08-14', '2020-08-14', '00647', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '709', 'pending'), 
('1556', '2020-08-14', '2020-08-14', '00648', 'ECG', '', '19', '24', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '710', 'pending'), 
('1557', '2020-08-14', '2020-08-14', '00648', 'RBAD', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '710', 'pending'), 
('1558', '2020-08-14', '2020-08-14', '00649', 'ESR', '', '20', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '711', 'pending'), 
('1559', '2020-08-14', '2020-08-14', '00649', 'CRP', '', '20', '19', 'SEROLOGY', '201', '', '0', '0.00', '', '650.00', '0.00', '711', 'pending'), 
('1560', '2020-08-14', '2020-08-14', '00649', 'Chest P/A View', '', '20', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '711', 'pending'), 
('1561', '2020-08-14', '2020-08-14', '00649', 'ECG', '', '20', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '711', 'pending'), 
('1562', '2020-08-14', '2020-08-14', '00650', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '712', 'pending'), 
('1563', '2020-08-14', '2020-08-14', '00650', 'ESR', '', '19', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '712', 'pending'), 
('1564', '2020-08-14', '2020-08-14', '00651', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '713', 'pending'), 
('1565', '2020-08-14', '2020-08-14', '00651', 'R/A Test', '', '19', '19', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '713', 'pending'), 
('1566', '2020-08-14', '2020-08-14', '00651', 'CRP', '', '19', '19', 'SEROLOGY', '201', '', '0', '0.00', '', '650.00', '0.00', '713', 'pending'), 
('1567', '2020-08-15', '2020-08-15', '00652', 'F.Sugar', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '714', 'pending'), 
('1568', '2020-08-15', '2020-08-15', '00652', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '714', 'pending'), 
('1569', '2020-08-15', '2020-08-15', '00653', '2Hour After 75 Gram, Glucose', '', '19', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '300.00', '0.00', '715', 'pending'), 
('1570', '2020-08-15', '2020-08-15', '00654', 'CBC', '', '19', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '716', 'pending'), 
('1571', '2020-08-15', '2020-08-15', '00654', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '716', 'pending'), 
('1572', '2020-08-15', '2020-08-15', '00655', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '717', 'pending'), 
('1573', '2020-08-15', '2020-08-15', '00656', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '718', 'pending'), 
('1574', '2020-08-15', '2020-08-15', '00656', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '718', 'pending'), 
('1575', '2020-08-15', '2020-08-15', '00656', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '718', 'pending'), 
('1576', '2020-08-15', '2020-08-15', '00656', 'CRP', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '650.00', '0.00', '718', 'pending'), 
('1577', '2020-08-15', '2020-08-15', '00656', 'DIGITAL__X-RAY_____EXPRESS', '', '19', '23', 'DIGITAL X-RAY', '', '', '0', '0.00', '', '400.00', '0.00', '718', 'pending'), 
('1578', '2020-08-15', '2020-08-15', '00657', 'Pregnancy Profile', '', '19', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '719', 'pending'), 
('1579', '2020-08-15', '2020-08-15', '00658', 'PREGNANCY_PROFILE', '', '10', '30', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '720', 'pending'), 
('1580', '2020-08-15', '2020-08-15', '00659', 'CBC', '', '20', '20', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '721', 'pending'), 
('1581', '2020-08-15', '2020-08-15', '00659', 'RBS', '', '20', '20', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '721', 'pending'), 
('1582', '2020-08-15', '2020-08-15', '00659', 'Blood For Grouping', '', '20', '20', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '721', 'pending'), 
('1583', '2020-08-15', '2020-08-15', '00659', 'Widal Test', '', '20', '20', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '721', 'pending'), 
('1584', '2020-08-15', '2020-08-15', '00659', 'R/E M/E', '', '20', '20', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '721', 'pending'), 
('1585', '2020-08-15', '2020-08-15', '00659', 'PREGNANCY_PROFILE', '', '20', '20', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '721', 'pending'), 
('1586', '2020-08-15', '2020-08-15', '00660', 'CBC', '', '19', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '722', 'pending'), 
('1587', '2020-08-15', '2020-08-15', '00660', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '722', 'pending'), 
('1588', '2020-08-15', '2020-08-15', '00660', 'S. Bilirubin', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '722', 'pending'), 
('1589', '2020-08-15', '2020-08-15', '00660', 'CRP', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '650.00', '0.00', '722', 'pending'), 
('1590', '2020-08-15', '2020-08-15', '00660', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '722', 'pending'), 
('1591', '2020-08-15', '2020-08-15', '00660', 'S. Creatinine', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '722', 'pending'), 
('1592', '2020-08-15', '2020-08-15', '00661', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '723', 'pending'), 
('1593', '2020-08-15', '2020-08-15', '00662', 'CBC', '', '19', '20', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '724', 'pending'), 
('1594', '2020-08-15', '2020-08-15', '00662', 'S. Creatinine', '', '19', '20', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '724', 'pending'), 
('1595', '2020-08-15', '2020-08-15', '00662', 'R/E M/E', '', '19', '20', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '724', 'pending'), 
('1596', '2020-08-15', '2020-08-15', '00662', 'KUB', '', '19', '20', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '724', 'pending'), 
('1597', '2020-08-15', '2020-08-15', '00662', 'X-RAY', '', '19', '20', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '724', 'pending'), 
('1598', '2020-08-15', '2020-08-15', '00663', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '725', 'pending'), 
('1599', '2020-08-15', '2020-08-15', '00663', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '725', 'pending'), 
('1600', '2020-08-15', '2020-08-15', '00663', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '725', 'pending'), 
('1601', '2020-08-15', '2020-08-15', '00664', 'CBC', '', '19', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '726', 'pending'), 
('1602', '2020-08-15', '2020-08-15', '00664', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '726', 'pending'), 
('1603', '2020-08-15', '2020-08-15', '00664', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '726', 'pending'), 
('1604', '2020-08-15', '2020-08-15', '00664', 'S. Creatinine', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '726', 'pending'), 
('1605', '2020-08-15', '2020-08-15', '00664', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '726', 'pending'), 
('1606', '2020-08-15', '2020-08-15', '00665', 'Pregnancy Profile', '', '19', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '727', 'pending'), 
('1607', '2020-08-15', '2020-08-15', '00666', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '728', 'pending'), 
('1608', '2020-08-15', '2020-08-15', '00666', 'Widal Test', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '728', 'pending'), 
('1609', '2020-08-15', '2020-08-15', '00667', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '729', 'pending'), 
('1610', '2020-08-15', '2020-08-15', '00667', 'ECG', '', '19', '24', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '729', 'pending'), 
('1611', '2020-08-15', '2020-08-15', '00668', 'CBC', '', '19', '31', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '730', 'pending'), 
('1612', '2020-08-15', '2020-08-15', '00668', 'W_/_A', '', '19', '31', 'U_S_G_', '202', '', '0', '0.00', '', '750.00', '0.00', '730', 'pending'), 
('1613', '2020-08-15', '2020-08-15', '00668', 'R/E M/E', '', '19', '31', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '730', 'pending'), 
('1614', '2020-08-15', '2020-08-15', '00668', 'Widal Test', '', '19', '31', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '730', 'pending'), 
('1615', '2020-08-15', '2020-08-15', '00669', 'CBC', '', '19', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '731', 'pending'), 
('1616', '2020-08-15', '2020-08-15', '00669', 'S. Bilirubin', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '731', 'pending'), 
('1617', '2020-08-15', '2020-08-15', '00669', 'Widal Test', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '731', 'pending'), 
('1618', '2020-08-16', '2020-08-16', '00670', 'ECG', '', '17', '24', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '732', 'pending'), 
('1619', '2020-08-16', '2020-08-16', '00670', 'U_S_G__W_/_A', '', '17', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '732', 'pending'), 
('1620', '2020-08-16', '2020-08-16', '00671', 'S. Creatinine', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '733', 'pending'), 
('1621', '2020-08-16', '2020-08-16', '00671', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '733', 'pending'), 
('1622', '2020-08-16', '2020-08-16', '00672', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '734', 'pending'), 
('1623', '2020-08-16', '2020-08-16', '00672', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '734', 'pending'), 
('1624', '2020-08-16', '2020-08-16', '00672', 'Whole Abdomen', '', '19', '23', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '734', 'pending'), 
('1625', '2020-08-16', '2020-08-16', '00672', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '734', 'pending'), 
('1626', '2020-08-16', '2020-08-16', '00673', 'ESR', '', '19', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '735', 'pending'), 
('1627', '2020-08-16', '2020-08-16', '00673', 'Widal Test', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '735', 'pending'), 
('1628', '2020-08-16', '2020-08-16', '00674', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '736', 'pending'), 
('1629', '2020-08-16', '2020-08-16', '00675', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '737', 'pending'), 
('1630', '2020-08-16', '2020-08-16', '00676', 'RBS', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '738', 'pending'), 
('1631', '2020-08-16', '2020-08-16', '00676', 'S. Creatinine', '', '20', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '738', 'pending'), 
('1632', '2020-08-16', '2020-08-16', '00676', 'R/E M/E', '', '20', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '738', 'pending'), 
('1633', '2020-08-16', '2020-08-16', '00677', 'U_S_G__W_/_A', '', '20', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '739', 'pending'), 
('1634', '2020-08-16', '2020-08-16', '00678', 'DIGITAL_X-RAY_EXPRESS', '', '19', '23', 'DIGITAL_X-RAY_EXPRESS', '204', '', '0', '0.00', '', '400.00', '0.00', '740', 'pending'), 
('1635', '2020-08-16', '2020-08-16', '00679', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '741', 'pending'), 
('1636', '2020-08-16', '2020-08-16', '00680', 'CBC', '', '20', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '742', 'pending'), 
('1637', '2020-08-16', '2020-08-16', '00680', 'CRP', '', '20', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '650.00', '0.00', '742', 'pending'), 
('1638', '2020-08-16', '2020-08-16', '00680', 'U_S_G__W_/_A', '', '20', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '742', 'pending'), 
('1639', '2020-08-16', '2020-08-16', '00680', 'DIGITAL_X-RAY_EXPRESS', '', '20', '23', 'DIGITAL_X-RAY_EXPRESS', '204', '', '0', '0.00', '', '400.00', '0.00', '742', 'pending'), 
('1640', '2020-08-16', '2020-08-16', '00681', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '743', 'pending'), 
('1641', '2020-08-16', '2020-08-16', '00681', 'Hb%', '', '19', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '743', 'pending'), 
('1642', '2020-08-16', '2020-08-16', '00682', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '744', 'pending'), 
('1643', '2020-08-17', '2020-08-17', '00683', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '745', 'pending'), 
('1644', '2020-08-17', '2020-08-17', '00683', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '745', 'pending'), 
('1645', '2020-08-17', '2020-08-17', '00683', 'SOFT_TISSUC_NECK', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '745', 'pending'), 
('1646', '2020-08-17', '2020-08-17', '00684', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '746', 'pending'), 
('1647', '2020-08-17', '2020-08-17', '00685', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '747', 'pending'), 
('1648', '2020-08-17', '2020-08-17', '00685', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '747', 'pending'), 
('1649', '2020-08-17', '2020-08-17', '00685', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '747', 'pending'), 
('1650', '2020-08-17', '2020-08-17', '00686', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '748', 'pending'), 
('1651', '2020-08-17', '2020-08-17', '00686', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '748', 'pending'), 
('1652', '2020-08-17', '2020-08-17', '00687', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '749', 'pending'), 
('1653', '2020-08-17', '2020-08-17', '00688', 'Hb%', '', '20', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '750', 'pending'), 
('1654', '2020-08-17', '2020-08-17', '00688', 'RBS', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '750', 'pending'), 
('1655', '2020-08-17', '2020-08-17', '00688', 'Blood For Grouping', '', '20', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '750', 'pending'), 
('1656', '2020-08-17', '2020-08-17', '00688', 'R/E M/E', '', '20', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '750', 'pending'), 
('1657', '2020-08-17', '2020-08-17', '00689', 'BT/CT', '', '19', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '900.00', '0.00', '751', 'pending'), 
('1658', '2020-08-17', '2020-08-17', '00689', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '751', 'pending'), 
('1659', '2020-08-17', '2020-08-17', '00690', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '752', 'pending'), 
('1660', '2020-08-17', '2020-08-17', '00691', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '753', 'pending'), 
('1661', '2020-08-17', '2020-08-17', '00691', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '753', 'pending'), 
('1662', '2020-08-17', '2020-08-17', '00691', 'M.T_MAN_TOUX)', '', '19', '23', 'M.T_MAN_TOUX)', '201', '', '0', '0.00', '', '400.00', '0.00', '753', 'pending'), 
('1663', '2020-08-17', '2020-08-17', '00691', 'Chest P/A View', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '753', 'pending'), 
('1664', '2020-08-17', '2020-08-17', '00692', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '754', 'pending'), 
('1665', '2020-08-17', '2020-08-17', '00693', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '755', 'pending'), 
('1666', '2020-08-17', '2020-08-17', '00694', 'PREGNANCY_PROFI', '', '10', '30', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '756', 'pending'), 
('1667', '2020-08-17', '2020-08-17', '00695', 'CBC', '', '34', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '757', 'pending'), 
('1668', '2020-08-17', '2020-08-17', '00695', 'RBS', '', '34', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '757', 'pending'), 
('1669', '2020-08-17', '2020-08-17', '00696', 'RBS', '', '28', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '758', 'pending'), 
('1670', '2020-08-17', '2020-08-17', '00696', 'R/E M/E', '', '28', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '758', 'pending'), 
('1671', '2020-08-17', '2020-08-17', '00696', 'W_/_A', '', '28', '24', 'U_S_G_', '202', '', '0', '0.00', '', '750.00', '0.00', '758', 'pending'), 
('1672', '2020-08-18', '2020-08-18', '00697', 'Fasting/Randam', '', '20', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '150.00', '0.00', '759', 'pending'), 
('1673', '2020-08-18', '2020-08-18', '00697', 'Sugar_2_HABF', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '759', 'pending'), 
('1674', '2020-08-18', '2020-08-18', '00698', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '760', 'pending'), 
('1675', '2020-08-18', '2020-08-18', '00698', 'CUS', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '760', 'pending'), 
('1676', '2020-08-18', '2020-08-18', '00699', 'L/A', '', '20', '23', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '761', 'pending'), 
('1677', '2020-08-18', '2020-08-18', '00699', 'R/E M/E', '', '20', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '761', 'pending'), 
('1678', '2020-08-18', '2020-08-18', '00699', 'Pregnancy Test', '', '20', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '761', 'pending'), 
('1679', '2020-08-18', '2020-08-18', '00699', 'Lumbo-Sacral B.V', '', '20', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '500.00', '0.00', '761', 'pending'), 
('1680', '2020-08-18', '2020-08-18', '00700', 'L/A', '', '20', '24', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '762', 'pending'), 
('1681', '2020-08-18', '2020-08-18', '00701', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '763', 'pending'), 
('1682', '2020-08-18', '2020-08-18', '00701', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '763', 'pending'), 
('1683', '2020-08-18', '2020-08-18', '00701', 'L/A', '', '19', '23', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '763', 'pending'), 
('1684', '2020-08-18', '2020-08-18', '00701', 'X-RAY', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '763', 'pending'), 
('1685', '2020-08-18', '2020-08-18', '00702', 'Blood For Grouping', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '764', 'pending'), 
('1686', '2020-08-18', '2020-08-18', '00703', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '765', 'pending'), 
('1687', '2020-08-18', '2020-08-18', '00704', 'RBS', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '766', 'pending'), 
('1688', '2020-08-18', '2020-08-18', '00705', 'USG_F/C', '', '19', '24', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '767', 'pending'), 
('1689', '2020-08-18', '2020-08-18', '00706', 'Hb%', '', '19', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '768', 'pending'), 
('1690', '2020-08-18', '2020-08-18', '00706', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '768', 'pending'), 
('1691', '2020-08-18', '2020-08-18', '00706', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '768', 'pending'), 
('1692', '2020-08-18', '2020-08-18', '00706', 'L/A', '', '19', '24', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '768', 'pending'), 
('1693', '2020-08-18', '2020-08-18', '00707', 'Sugar_2_HABF', '', '6', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '769', 'pending'), 
('1694', '2020-08-18', '2020-08-18', '00707', 'Sugar_2_HABF', '', '6', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '769', 'pending'), 
('1695', '2020-08-18', '2020-08-18', '00708', 'Blood For Grouping', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '770', 'pending'), 
('1696', '2020-08-19', '2020-08-19', '00709', 'Fasting/Randam', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '150.00', '0.00', '771', 'pending'), 
('1697', '2020-08-19', '2020-08-19', '00709', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '771', 'pending'), 
('1698', '2020-08-19', '2020-08-19', '00710', 'X-RAY Rt Fimar', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '772', 'pending'), 
('1699', '2020-08-19', '2020-08-19', '00711', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '773', 'pending'), 
('1700', '2020-08-19', '2020-08-19', '00711', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '773', 'pending'), 
('1701', '2020-08-19', '2020-08-19', '00711', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '773', 'pending'), 
('1702', '2020-08-19', '2020-08-19', '00711', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '773', 'pending'), 
('1703', '2020-08-19', '2020-08-19', '00711', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '773', 'pending'), 
('1704', '2020-08-19', '2020-08-19', '00712', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '774', 'pending'), 
('1705', '2020-08-19', '2020-08-19', '00713', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '775', 'pending'), 
('1706', '2020-08-19', '2020-08-19', '00714', 'Pregnancy Test', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '776', 'pending'), 
('1707', '2020-08-19', '2020-08-19', '00715', 'L/A', '', '19', '32', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '777', 'pending'), 
('1708', '2020-08-19', '2020-08-19', '00716', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '778', 'pending'), 
('1709', '2020-08-19', '2020-08-19', '00716', 'Skull B V / P.N.S', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '778', 'pending'), 
('1710', '2020-08-19', '2020-08-19', '00717', 'Widal Test', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '779', 'pending'), 
('1711', '2020-08-19', '2020-08-19', '00717', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '779', 'pending'), 
('1712', '2020-08-19', '2020-08-19', '00718', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '780', 'pending'), 
('1713', '2020-08-19', '2020-08-19', '00718', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '780', 'pending'), 
('1714', '2020-08-19', '2020-08-19', '00719', 'XRAY-LEFT_FOOT_B/V', '', '20', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '781', 'pending'), 
('1715', '2020-08-19', '2020-08-19', '00720', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '782', 'pending'), 
('1716', '2020-08-19', '2020-08-19', '00721', 'CBC', '', '19', '31', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '783', 'pending'), 
('1717', '2020-08-19', '2020-08-19', '00721', 'RBS', '', '19', '31', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '783', 'pending'), 
('1718', '2020-08-19', '2020-08-19', '00721', 'R/E M/E', '', '19', '31', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '783', 'pending'), 
('1719', '2020-08-19', '2020-08-19', '00721', 'ECG', '', '19', '31', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '783', 'pending'), 
('1720', '2020-08-19', '2020-08-19', '00721', 'W/A', '', '19', '31', 'USG_COLOUR', '250', '', '0', '0.00', '', '850.00', '0.00', '783', 'pending'), 
('1721', '2020-08-19', '2020-08-19', '00722', 'CBC', '', '19', '31', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '784', 'pending'), 
('1722', '2020-08-19', '2020-08-19', '00722', 'Widal Test', '', '19', '31', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '784', 'pending'), 
('1723', '2020-08-19', '2020-08-19', '00722', 'Skull B V / P.N.S', '', '19', '31', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '784', 'pending'), 
('1724', '2020-08-19', '2020-08-19', '00722', 'CRP', '', '19', '31', 'SEROLOGY', '201', '', '0', '0.00', '', '650.00', '0.00', '784', 'pending'), 
('1725', '2020-08-19', '2020-08-19', '00722', 'R/E M/E', '', '19', '31', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '784', 'pending'), 
('1726', '2020-08-19', '2020-08-19', '00723', 'ECG', '', '19', '31', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '785', 'pending'), 
('1727', '2020-08-19', '2020-08-19', '00723', 'Chest P/A View', '', '19', '31', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '785', 'pending'), 
('1728', '2020-08-19', '2020-08-19', '00723', 'W/A', '', '19', '31', 'USG_COLOUR', '250', '', '0', '0.00', '', '850.00', '0.00', '785', 'pending'), 
('1729', '2020-08-19', '2020-08-19', '00724', 'ECG', '', '19', '31', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '786', 'pending'), 
('1730', '2020-08-19', '2020-08-19', '00725', 'CBC', '', '20', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '787', 'pending'), 
('1731', '2020-08-19', '2020-08-19', '00725', 'S. Creatinine', '', '20', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '787', 'pending'), 
('1732', '2020-08-19', '2020-08-19', '00725', 'S.G.P.T.(ALT)', '', '20', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '787', 'pending'), 
('1733', '2020-08-19', '2020-08-19', '00725', 'R/E M/E', '', '20', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '787', 'pending'), 
('1734', '2020-08-19', '2020-08-19', '00726', 'W_/_A', '', '19', '31', 'U_S_G_', '202', '', '0', '0.00', '', '750.00', '0.00', '788', 'pending'), 
('1735', '2020-08-19', '2020-08-19', '00726', 'ECG', '', '19', '31', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '788', 'pending'), 
('1736', '2020-08-19', '2020-08-19', '00726', 'RBS', '', '19', '31', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '788', 'pending'), 
('1737', '2020-08-19', '2020-08-19', '00727', 'CBC', '', '34', '31', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '789', 'pending'), 
('1738', '2020-08-19', '2020-08-19', '00727', 'R/E M/E', '', '34', '31', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '789', 'pending'), 
('1739', '2020-08-19', '2020-08-19', '00727', 'ECG', '', '34', '31', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '789', 'pending'), 
('1740', '2020-08-19', '2020-08-19', '00727', 'U_S_G__W_/_A', '', '34', '31', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '789', 'pending'), 
('1741', '2020-08-19', '2020-08-19', '00728', 'Sugar_2_HABF', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '790', 'pending'), 
('1742', '2020-08-19', '2020-08-19', '00729', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '791', 'pending'), 
('1743', '2020-08-19', '2020-08-19', '00729', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '791', 'pending'), 
('1744', '2020-08-19', '2020-08-19', '00730', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '792', 'pending'), 
('1745', '2020-08-19', '2020-08-19', '00730', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '792', 'pending'), 
('1746', '2020-08-19', '2020-08-19', '00730', 'R/A Test', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '792', 'pending'), 
('1747', '2020-08-19', '2020-08-19', '00730', 'CRP', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '650.00', '0.00', '792', 'pending'), 
('1748', '2020-08-19', '2020-08-19', '00730', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '792', 'pending'), 
('1749', '2020-08-19', '2020-08-19', '00730', 'ECG', '', '19', '24', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '792', 'pending'), 
('1750', '2020-08-19', '2020-08-19', '00731', 'Reticulacytes Count', '', '46', '29', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '700.00', '0.00', '793', 'pending'), 
('1751', '2020-08-19', '2020-08-19', '00732', 'S. Creatinine', '', '46', '29', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '794', 'pending'), 
('1752', '2020-08-19', '2020-08-19', '00733', 'S. Bilirubin', '', '46', '29', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '795', 'pending'), 
('1753', '2020-08-19', '2020-08-19', '00734', 'Widal Test', '', '46', '29', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '796', 'pending'), 
('1754', '2020-08-20', '2020-08-20', '00735', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '797', 'pending'), 
('1755', '2020-08-20', '2020-08-20', '00735', 'X-RAY', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '797', 'pending'), 
('1756', '2020-08-20', '2020-08-20', '00736', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '798', 'pending'), 
('1757', '2020-08-20', '2020-08-20', '00736', 'Chest P/A View', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '798', 'pending'), 
('1758', '2020-08-20', '2020-08-20', '00737', 'F.SUGAR_/_SUGAR_2HABF_', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '300.00', '0.00', '799', 'pending'), 
('1759', '2020-02-03', '2020-02-03', '00738', 'Whole Abdomen', '', '19', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '800', 'pending'), 
('1760', '2020-08-20', '2020-08-20', '00739', 'XRAY-LEFT_FOOT_B/V', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '801', 'pending'), 
('1761', '2020-08-20', '2020-08-20', '00740', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '802', 'pending'), 
('1762', '2020-08-20', '2020-08-20', '00740', 'S. Creatinine', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '802', 'pending'), 
('1763', '2020-08-20', '2020-08-20', '00740', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '802', 'pending'), 
('1764', '2020-08-20', '2020-08-20', '00740', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '802', 'pending'), 
('1765', '2020-08-20', '2020-08-20', '00741', 'Pregnancy Test', '', '10', '30', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '803', 'pending'), 
('1766', '2020-08-20', '2020-08-20', '00741', 'USG_F/C', '', '10', '30', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '803', 'pending'), 
('1767', '2020-08-20', '2020-08-20', '00742', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '804', 'pending'), 
('1768', '2020-08-20', '2020-08-20', '00743', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '805', 'pending'), 
('1769', '2020-08-20', '2020-08-20', '00744', 'Pregnancy Profile', '', '20', '24', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '806', 'pending'), 
('1770', '2020-08-20', '2020-08-20', '00745', 'RBS', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '807', 'pending'), 
('1771', '2020-08-20', '2020-08-20', '00745', 'Hb%', '', '20', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '807', 'pending'), 
('1772', '2020-08-20', '2020-08-20', '00745', 'R/E M/E', '', '20', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '807', 'pending'), 
('1773', '2020-08-20', '2020-08-20', '00745', 'V.D.R.L', '', '20', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '807', 'pending'), 
('1774', '2020-08-21', '2020-08-21', '00746', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '808', 'pending'), 
('1775', '2020-08-21', '2020-08-21', '00747', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '809', 'pending'), 
('1776', '2020-08-21', '2020-08-21', '00748', 'ESR', '', '20', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '810', 'pending'), 
('1777', '2020-08-21', '2020-08-21', '00748', 'RBS', '', '20', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '810', 'pending'), 
('1778', '2020-08-21', '2020-08-21', '00748', 'U_S_G__W_/_A', '', '20', '19', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '810', 'pending'), 
('1779', '2020-08-21', '2020-08-21', '00748', 'Chest P/A View', '', '20', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '810', 'pending'), 
('1780', '2020-08-21', '2020-08-21', '00748', 'L/S_A/P', '', '20', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '810', 'pending'), 
('1781', '2020-08-21', '2020-08-21', '00748', 'ECG', '', '20', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '810', 'pending'), 
('1782', '2020-08-21', '2020-08-21', '00749', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '811', 'pending'), 
('1783', '2020-08-21', '2020-08-21', '00749', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '811', 'pending'), 
('1784', '2020-08-21', '2020-08-21', '00750', 'S. Creatinine', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '812', 'pending'), 
('1785', '2020-08-21', '2020-08-21', '00750', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '812', 'pending'), 
('1786', '2020-08-21', '2020-08-21', '00750', 'ESR', '', '19', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '812', 'pending'), 
('1787', '2020-08-21', '2020-08-21', '00751', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '813', 'pending'), 
('1788', '2020-08-21', '2020-08-21', '00752', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '814', 'pending'), 
('1789', '2020-08-21', '2020-08-21', '00753', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '815', 'pending'), 
('1790', '2020-08-21', '2020-08-21', '00754', 'CBC', '', '20', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '816', 'pending'), 
('1791', '2020-08-21', '2020-08-21', '00754', 'S. Creatinine', '', '20', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '816', 'pending'), 
('1792', '2020-08-21', '2020-08-21', '00754', 'RBS', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '816', 'pending'), 
('1793', '2020-08-21', '2020-08-21', '00755', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '817', 'pending'), 
('1794', '2020-08-21', '2020-08-21', '00755', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '817', 'pending'), 
('1795', '2020-08-21', '2020-08-21', '00756', 'PREGNANCY_PROFILE', '', '19', '32', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '818', 'pending'), 
('1796', '2020-08-21', '2020-08-21', '00756', 'RBS', '', '19', '32', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '818', 'pending'), 
('1797', '2020-08-21', '2020-08-21', '00756', 'Hbs Ag', '', '19', '32', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '818', 'pending'), 
('1798', '2020-08-21', '2020-08-21', '00756', 'Hb%', '', '19', '32', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '818', 'pending'), 
('1799', '2020-08-21', '2020-08-21', '00756', 'V.D.R.L', '', '19', '32', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '818', 'pending'), 
('1800', '2020-08-21', '2020-08-21', '00757', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '819', 'pending'), 
('1801', '2020-08-21', '2020-08-21', '00757', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '819', 'pending'), 
('1802', '2020-08-21', '2020-08-21', '00758', 'ESR', '', '45', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '820', 'pending'), 
('1803', '2020-08-21', '2020-08-21', '00758', 'CRP', '', '45', '19', 'SEROLOGY', '201', '', '0', '0.00', '', '650.00', '0.00', '820', 'pending'), 
('1804', '2020-08-21', '2020-08-21', '00758', 'X-RAY', '', '45', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '820', 'pending'), 
('1805', '2020-08-21', '2020-08-21', '00758', 'X-RAY', '', '45', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '820', 'pending'), 
('1806', '2020-08-21', '2020-08-21', '00759', 'PREGNANCY_PROFILE', '', '19', '19', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '821', 'pending'), 
('1807', '2020-08-21', '2020-08-21', '00760', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '822', 'pending'), 
('1808', '2020-08-21', '2020-08-21', '00761', 'CBC', '', '19', '19', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '823', 'pending'), 
('1809', '2020-08-21', '2020-08-21', '00761', 'R/E M/E', '', '19', '19', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '823', 'pending'), 
('1810', '2020-08-21', '2020-08-21', '00761', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '823', 'pending'), 
('1811', '2020-08-21', '2020-08-21', '00761', 'S. Creatinine', '', '19', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '823', 'pending'), 
('1812', '2020-08-21', '2020-08-21', '00761', 'S.__ELECROLYTES', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '850.00', '0.00', '823', 'pending'), 
('1813', '2020-08-21', '2020-08-21', '00761', 'S.G.P.T.(ALT)', '', '19', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '823', 'pending'), 
('1814', '2020-08-21', '2020-08-21', '00762', 'W_/_A', '', '19', '19', 'U_S_G_', '202', '', '0', '0.00', '', '750.00', '0.00', '824', 'pending'), 
('1815', '2020-08-21', '2020-08-21', '00763', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '825', 'pending'), 
('1816', '2020-08-21', '2020-08-21', '00763', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '825', 'pending'), 
('1817', '2020-08-21', '2020-08-21', '00764', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '826', 'pending'), 
('1818', '2020-08-21', '2020-08-21', '00764', 'X-RAY', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '826', 'pending'), 
('1819', '2020-08-21', '2020-08-21', '00765', 'S. Creatinine', '', '19', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '827', 'pending'), 
('1820', '2020-08-21', '2020-08-21', '00765', 'X-RAY', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '827', 'pending'), 
('1821', '2020-08-21', '2020-08-21', '00766', 'W_/_A', '', '19', '19', 'U_S_G_', '202', '', '0', '0.00', '', '750.00', '0.00', '828', 'pending'), 
('1822', '2020-08-21', '2020-08-21', '00766', 'R/E M/E', '', '19', '19', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '828', 'pending'), 
('1823', '2020-08-21', '2020-08-21', '00767', 'R/E M/E', '', '19', '19', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '829', 'pending'), 
('1824', '2020-08-21', '2020-08-21', '00767', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '829', 'pending'), 
('1825', '2020-08-21', '2020-08-21', '00767', 'Whole Abdomen', '', '19', '19', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '829', 'pending'), 
('1826', '2020-08-21', '2020-08-21', '00768', 'Chest_L/A_View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '830', 'pending'), 
('1827', '2020-08-21', '2020-08-21', '00768', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '830', 'pending'), 
('1828', '2020-08-21', '2020-08-21', '00768', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '830', 'pending'), 
('1829', '2020-08-21', '2020-08-21', '00768', 'R/E M/E', '', '19', '19', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '830', 'pending'), 
('1830', '2020-08-21', '2020-08-21', '00769', 'U_S_G__W_/_A', '', '19', '19', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '831', 'pending'), 
('1831', '2020-08-21', '2020-08-21', '00770', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '832', 'pending'), 
('1832', '2020-08-21', '2020-08-21', '00770', 'R/E M/E', '', '19', '19', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '832', 'pending'), 
('1833', '2020-08-21', '2020-08-21', '00770', 'Whole Abdomen', '', '19', '19', 'DIGITAL ULTRASONOGRAPHY', '203', '', '0', '0.00', '', '850.00', '0.00', '832', 'pending'), 
('1834', '2020-08-21', '2020-08-21', '00770', 'X-RAY', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '832', 'pending'), 
('1835', '2020-08-21', '2020-08-21', '00771', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '833', 'pending'), 
('1836', '2020-08-21', '2020-08-21', '00771', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '833', 'pending'), 
('1837', '2020-08-21', '2020-08-21', '00772', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '834', 'pending'), 
('1838', '2020-08-21', '2020-08-21', '00773', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '835', 'pending'), 
('1839', '2020-08-21', '2020-08-21', '00773', 'X-RAY', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '835', 'pending'), 
('1840', '2020-08-21', '2020-08-21', '00773', 'X-RAY', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '835', 'pending'), 
('1844', '2020-08-21', '2020-08-21', '00775', 'Hb%', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '837', 'pending'), 
('1845', '2020-08-21', '2020-08-21', '00775', 'S.__ELECROLYTES', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '850.00', '0.00', '837', 'pending'), 
('1846', '2020-08-21', '2020-08-21', '00775', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '837', 'pending'), 
('1847', '2020-08-21', '2020-08-21', '00776', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '838', 'pending'), 
('1848', '2020-08-21', '2020-08-21', '00776', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '838', 'pending'), 
('1849', '2020-08-21', '2020-08-21', '00777', 'U_S_G__W_/_A', '', '19', '19', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '839', 'pending'), 
('1850', '2020-08-21', '2020-08-21', '00778', 'W_/_A', '', '19', '19', 'U_S_G_', '202', '', '0', '0.00', '', '750.00', '0.00', '840', 'pending'), 
('1851', '2020-08-21', '2020-08-21', '00778', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '840', 'pending'), 
('1852', '2020-08-21', '2020-08-21', '00778', 'R/E M/E', '', '19', '19', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '840', 'pending'), 
('1853', '2020-08-21', '2020-08-21', '00779', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '841', 'pending'), 
('1854', '2020-08-21', '2020-08-21', '00780', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '842', 'pending'), 
('1855', '2020-08-21', '2020-08-21', '00780', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '842', 'pending'), 
('1856', '2020-08-21', '2020-08-21', '00780', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '842', 'pending'), 
('1857', '2020-08-21', '2020-08-21', '00780', 'W_/_A', '', '19', '23', 'U_S_G_', '202', '', '0', '0.00', '', '750.00', '0.00', '842', 'pending'), 
('1858', '2020-08-21', '2020-08-21', '00781', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '843', 'pending'), 
('1859', '2020-08-21', '2020-08-21', '00782', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '844', 'pending'), 
('1860', '2020-08-21', '2020-08-21', '00782', 'S. Creatinine', '', '19', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '844', 'pending'), 
('1861', '2020-08-21', '2020-08-21', '00782', 'U_S_G__W_/_A', '', '19', '19', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '844', 'pending'), 
('1862', '2020-08-21', '2020-08-21', '00782', 'R/E M/E', '', '19', '19', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '844', 'pending'), 
('1863', '2020-08-21', '2020-08-21', '00782', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '844', 'pending'), 
('1864', '2020-08-21', '2020-08-21', '00783', 'CBC', '', '19', '19', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '845', 'pending'), 
('1865', '2020-08-21', '2020-08-21', '00783', 'Hbs Ag', '', '19', '19', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '845', 'pending'), 
('1866', '2020-08-21', '2020-08-21', '00783', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '845', 'pending'), 
('1867', '2020-08-21', '2020-08-21', '00783', 'R/E M/E', '', '19', '19', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '845', 'pending'), 
('1868', '2020-08-21', '2020-08-21', '00784', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '846', 'pending'), 
('1869', '2020-08-21', '2020-08-21', '00784', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '846', 'pending'), 
('1870', '2020-08-21', '2020-08-21', '00784', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '846', 'pending'), 
('1871', '2020-08-21', '2020-08-21', '00784', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '846', 'pending'), 
('1872', '2020-08-22', '2020-08-22', '00785', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '847', 'pending'), 
('1873', '2020-08-22', '2020-08-22', '00786', 'Hb%', '', '20', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '848', 'pending'), 
('1874', '2020-08-22', '2020-08-22', '00787', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '849', 'pending'), 
('1875', '2020-08-22', '2020-08-22', '00788', 'Hb%_/ESR', '', '19', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '850', 'pending'), 
('1876', '2020-08-22', '2020-08-22', '00788', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '850', 'pending'), 
('1877', '2020-08-22', '2020-08-22', '00788', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '850', 'pending'), 
('1878', '2020-08-22', '2020-08-22', '00788', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '850', 'pending'), 
('1879', '2020-08-22', '2020-08-22', '00788', 'ECG', '', '19', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '850', 'pending'), 
('1880', '2020-08-22', '2020-08-22', '00789', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '851', 'pending'), 
('1881', '2020-08-22', '2020-08-22', '00789', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '851', 'pending'), 
('1882', '2020-08-22', '2020-08-22', '00789', 'Chest P/A View', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '851', 'pending'), 
('1883', '2020-08-22', '2020-08-22', '00789', 'X-RAY', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '851', 'pending'), 
('1884', '2020-08-22', '2020-08-22', '00789', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '851', 'pending'), 
('1885', '2020-08-22', '2020-08-22', '00790', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '852', 'pending'), 
('1886', '2020-08-22', '2020-08-22', '00790', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '852', 'pending'), 
('1887', '2020-08-22', '2020-08-22', '00790', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '852', 'pending'), 
('1888', '2020-08-22', '2020-08-22', '00790', 'W/A', '', '19', '23', 'USG_COLOUR', '250', '', '0', '0.00', '', '850.00', '0.00', '852', 'pending'), 
('1889', '2020-08-22', '2020-08-22', '00790', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '852', 'pending'), 
('1890', '2020-08-22', '2020-08-22', '00791', 'U_S_G__W_/_A', '', '20', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '853', 'pending'), 
('1891', '2020-08-22', '2020-08-22', '00791', 'R/E M/E', '', '20', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '853', 'pending'), 
('1892', '2020-08-22', '2020-08-22', '00791', '	Hb%_/ESR', '', '20', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '853', 'pending'), 
('1893', '2020-08-22', '2020-08-22', '00791', 'Widal Test', '', '20', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '853', 'pending'), 
('1894', '2020-08-22', '2020-08-22', '00791', 'RBS', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '853', 'pending'), 
('1895', '2020-08-22', '2020-08-22', '00792', 'RBS', '', '19', '31', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '854', 'pending'), 
('1896', '2020-08-22', '2020-08-22', '00792', 'R/E M/E', '', '19', '31', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '854', 'pending'), 
('1897', '2020-08-22', '2020-08-22', '00792', 'U_S_G__W_/_A', '', '19', '31', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '854', 'pending'), 
('1898', '2020-08-22', '2020-08-22', '00792', 'ECG', '', '19', '31', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '854', 'pending'), 
('1899', '2020-08-22', '2020-08-22', '00793', 'Lipid Profile', '', '19', '31', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '1200.00', '0.00', '855', 'pending'), 
('1900', '2020-08-22', '2020-08-22', '00793', 'ECG', '', '19', '31', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '855', 'pending'), 
('1901', '2020-08-22', '2020-08-22', '00793', 'Chest P/A View', '', '19', '31', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '855', 'pending'), 
('1902', '2020-08-22', '2020-08-22', '00794', 'Lipid Profile', '', '19', '31', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '1200.00', '0.00', '856', 'pending'), 
('1903', '2020-08-22', '2020-08-22', '00794', 'ECG', '', '19', '31', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '856', 'pending'), 
('1904', '2020-08-22', '2020-08-22', '00794', 'RBS', '', '19', '31', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '856', 'pending'), 
('1905', '2020-08-22', '2020-08-22', '00794', 'W_/_A', '', '19', '31', 'U_S_G_', '202', '', '0', '0.00', '', '750.00', '0.00', '856', 'pending'), 
('1906', '2020-08-22', '2020-08-22', '00795', 'X-RAY', '', '19', '31', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '857', 'pending'), 
('1907', '2020-08-22', '2020-08-22', '00796', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '858', 'pending'), 
('1908', '2020-08-22', '2020-08-22', '00796', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '858', 'pending'), 
('1909', '2020-08-22', '2020-08-22', '00796', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '858', 'pending'), 
('1910', '2020-08-22', '2020-08-22', '00796', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '858', 'pending'), 
('1911', '2020-08-22', '2020-08-22', '00796', 'ECG', '', '19', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '858', 'pending'), 
('1913', '2020-08-23', '2020-08-23', '00798', 'PREGNANCY_PROFILE', '', '20', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '860', 'pending'), 
('1914', '2020-08-23', '2020-08-23', '00799', 'PREGNANCY_PROFILE', '', '10', '30', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '861', 'pending'), 
('1915', '2020-08-23', '2020-08-23', '00799', 'R/E M/E', '', '10', '30', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '861', 'pending'), 
('1916', '2020-08-23', '2020-08-23', '00800', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '862', 'pending'), 
('1917', '2020-08-23', '2020-08-23', '00801', 'USG_F/C', '', '19', '30', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '863', 'pending'), 
('1918', '2020-08-23', '2020-08-23', '00801', 'R/E M/E', '', '19', '30', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '863', 'pending'), 
('1919', '2020-08-23', '2020-08-23', '00802', 'X-RAY', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '864', 'pending'), 
('1920', '2020-08-23', '2020-08-23', '00803', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '865', 'pending'), 
('1921', '2020-08-23', '2020-08-23', '00804', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '866', 'pending'), 
('1922', '2020-08-24', '2020-08-24', '00805', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '867', 'pending'), 
('1923', '2020-08-24', '2020-08-24', '00805', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '867', 'pending'), 
('1924', '2020-08-24', '2020-08-24', '00805', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '867', 'pending'), 
('1925', '2020-08-24', '2020-08-24', '00805', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '867', 'pending'), 
('1926', '2020-08-24', '2020-08-24', '00806', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '868', 'pending'), 
('1927', '2020-08-24', '2020-08-24', '00807', 'Blood For Grouping', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '869', 'pending'), 
('1928', '2020-08-24', '2020-08-24', '00808', 'Widal Test', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '870', 'pending'), 
('1929', '2020-08-24', '2020-08-24', '00808', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '870', 'pending'), 
('1930', '2020-08-24', '2020-08-24', '00808', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '870', 'pending'), 
('1931', '2020-08-24', '2020-08-24', '00809', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '871', 'pending'), 
('1932', '2020-08-24', '2020-08-24', '00809', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '871', 'pending'), 
('1933', '2020-08-24', '2020-08-24', '00809', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '871', 'pending'), 
('1934', '2020-08-24', '2020-08-24', '00809', 'W/A', '', '19', '23', 'USG_COLOUR', '250', '', '0', '0.00', '', '850.00', '0.00', '871', 'pending'), 
('1935', '2020-08-24', '2020-08-24', '00809', 'ECG', '', '19', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '871', 'pending'), 
('1936', '2020-08-24', '2020-08-24', '00810', 'CBC', '', '19', '32', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '872', 'pending'), 
('1937', '2020-08-24', '2020-08-24', '00810', 'S. Creatinine', '', '19', '32', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '872', 'pending'), 
('1938', '2020-08-24', '2020-08-24', '00810', 'R/E M/E', '', '19', '32', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '872', 'pending'), 
('1939', '2020-08-24', '2020-08-24', '00810', 'L/A', '', '19', '32', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '872', 'pending'), 
('1940', '2020-08-24', '2020-08-24', '00811', 'USG_F/C', '', '19', '24', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '873', 'pending'), 
('1941', '2020-08-24', '2020-08-24', '00812', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '874', 'pending'), 
('1942', '2020-08-24', '2020-08-24', '00812', 'ECG', '', '19', '23', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '874', 'pending'), 
('1943', '2020-08-24', '2020-08-24', '00812', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '874', 'pending'), 
('1944', '2020-08-24', '2020-08-24', '00812', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '874', 'pending'), 
('1945', '2020-08-24', '2020-08-24', '00812', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '874', 'pending'), 
('1946', '2020-08-24', '2020-08-24', '00812', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '874', 'pending'), 
('1947', '2020-08-24', '2020-08-24', '00813', 'DANTAL_X-RAY', '', '20', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '875', 'pending'), 
('1948', '2020-08-24', '2020-08-24', '00814', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '876', 'pending'), 
('1949', '2020-08-24', '2020-08-24', '00814', 'X-RAY', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '876', 'pending'), 
('1950', '2020-08-24', '2020-08-24', '00814', '', '', '19', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '876', 'pending'), 
('1951', '2020-08-24', '2020-08-24', '00815', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '877', 'pending'), 
('1952', '2020-08-24', '2020-08-24', '00815', 'S. Creatinine', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '877', 'pending'), 
('1953', '2020-08-24', '2020-08-24', '00815', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '877', 'pending'), 
('1954', '2020-08-24', '2020-08-24', '00815', 'Lumbo-Sacral B.V', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '500.00', '0.00', '877', 'pending'), 
('1955', '2020-08-25', '2020-08-25', '00816', 'CBC', '', '19', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '878', 'pending'), 
('1956', '2020-08-25', '2020-08-25', '00816', 'Widal Test', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '878', 'pending'), 
('1957', '2020-08-25', '2020-08-25', '00816', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '878', 'pending'), 
('1958', '2020-08-25', '2020-08-25', '00816', 'V.D.R.L', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '878', 'pending'), 
('1959', '2020-08-25', '2020-08-25', '00817', 'F.SUGAR_/_SUGAR_2HABF_', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '300.00', '0.00', '879', 'pending'), 
('1960', '2020-08-25', '2020-08-25', '00818', 'X-RAY', '', '20', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '880', 'pending'), 
('1961', '2020-08-25', '2020-08-25', '00819', 'L/A', '', '19', '24', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '881', 'pending'), 
('1962', '2020-08-25', '2020-08-25', '00819', 'Hb%', '', '19', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '881', 'pending'), 
('1963', '2020-08-25', '2020-08-25', '00819', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '881', 'pending'), 
('1964', '2020-08-25', '2020-08-25', '00819', 'Blood For Grouping', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '881', 'pending'), 
('1965', '2020-08-25', '2020-08-25', '00820', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '882', 'pending'), 
('1966', '2020-08-25', '2020-08-25', '00821', 'Hb%', '', '19', '32', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '883', 'pending'), 
('1967', '2020-08-25', '2020-08-25', '00821', 'R/E M/E', '', '19', '32', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '883', 'pending'), 
('1968', '2020-08-25', '2020-08-25', '00821', 'RBS', '', '19', '32', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '883', 'pending'), 
('1969', '2020-08-25', '2020-08-25', '00821', 'PREGNANCY_PROFILE', '', '19', '32', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '883', 'pending'), 
('1970', '2020-08-25', '2020-08-25', '00821', 'Hbe Ag', '', '19', '32', 'SEROLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '883', 'pending'), 
('1971', '2020-08-25', '2020-08-25', '00822', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '884', 'pending'), 
('1972', '2020-08-25', '2020-08-25', '00823', 'CBC', '', '19', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '885', 'pending'), 
('1973', '2020-08-25', '2020-08-25', '00823', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '885', 'pending'), 
('1974', '2020-08-25', '2020-08-25', '00823', 'S. Creatinine', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '885', 'pending'), 
('1975', '2020-08-25', '2020-08-25', '00823', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '885', 'pending'), 
('1976', '2020-08-25', '2020-08-25', '00823', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '885', 'pending'), 
('1977', '2020-08-25', '2020-08-25', '00824', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '886', 'pending'), 
('1978', '2020-08-25', '2020-08-25', '00825', 'CBC', '', '20', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '887', 'pending'), 
('1979', '2020-08-25', '2020-08-25', '00825', 'RBS', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '887', 'pending'), 
('1980', '2020-08-25', '2020-08-25', '00825', 'R/E M/E', '', '20', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '887', 'pending'), 
('1981', '2020-08-25', '2020-08-25', '00825', 'L/A', '', '20', '23', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '887', 'pending'), 
('1982', '2020-08-25', '2020-08-25', '00826', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '888', 'pending'), 
('1983', '2020-08-25', '2020-08-25', '00826', 'CRP', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '650.00', '0.00', '888', 'pending'), 
('1984', '2020-08-25', '2020-08-25', '00826', 'A.S.O Titre', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '888', 'pending'), 
('1985', '2020-08-25', '2020-08-25', '00827', 'USG_F/C', '', '19', '24', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '889', 'pending'), 
('1986', '2020-08-25', '2020-08-25', '00828', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '890', 'pending'), 
('1987', '2020-08-25', '2020-08-25', '00828', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '890', 'pending'), 
('1988', '2020-08-25', '2020-08-25', '00828', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '890', 'pending'), 
('1989', '2020-08-25', '2020-08-25', '00829', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '891', 'pending'), 
('1990', '2020-08-25', '2020-08-25', '00830', 'Hbs Ag', '', '34', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '892', 'pending'), 
('1991', '2020-08-25', '2020-08-25', '00830', 'Hb%', '', '34', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '892', 'pending'), 
('1992', '2020-08-25', '2020-08-25', '00830', 'PREGNANCY_PROFILE', '', '34', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '892', 'pending'), 
('1993', '2020-08-25', '2020-08-25', '00831', 'Blood For Grouping', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '893', 'pending'), 
('1994', '2020-08-26', '2020-08-26', '00832', 'F.SUGAR_/_SUGAR_2HABF_', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '300.00', '0.00', '894', 'pending'), 
('1995', '2020-08-26', '2020-08-26', '00833', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '895', 'pending'), 
('1996', '2020-08-26', '2020-08-26', '00833', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '896', 'pending'), 
('1997', '2020-08-26', '2020-08-26', '00834', 'ECG', '', '19', '24', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '897', 'pending'), 
('1998', '2020-08-26', '2020-08-26', '00835', 'S. Bilirubin', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '898', 'pending'), 
('1999', '2020-08-26', '2020-08-26', '00835', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '898', 'pending'), 
('2000', '2020-08-26', '2020-08-26', '00835', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '898', 'pending'), 
('2001', '2020-08-26', '2020-08-26', '00835', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '898', 'pending'), 
('2002', '2020-08-26', '2020-08-26', '00836', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '899', 'pending'), 
('2003', '2020-08-26', '2020-08-26', '00837', 'W/A', '', '27', '28', 'USG_COLOUR', '250', '', '0', '0.00', '', '850.00', '0.00', '900', 'pending'), 
('2004', '2020-08-26', '2020-08-26', '00837', 'R/E M/E', '', '27', '28', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '900', 'pending'), 
('2005', '2020-08-26', '2020-08-26', '00838', 'X-RAY', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '901', 'pending'), 
('2006', '2020-08-26', '2020-08-26', '00839', 'Chest P/A View', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '902', 'pending'), 
('2007', '2020-08-26', '2020-08-26', '00839', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '902', 'pending'), 
('2008', '2020-08-26', '2020-08-26', '00840', 'USG_F/C', '', '20', '24', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '903', 'pending'), 
('2009', '2020-08-26', '2020-08-26', '00841', 'Hb%', '', '19', '32', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '904', 'pending'), 
('2010', '2020-08-26', '2020-08-26', '00841', 'R/E M/E', '', '19', '32', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '904', 'pending'), 
('2011', '2020-08-26', '2020-08-26', '00841', 'Blood For Grouping', '', '19', '32', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '904', 'pending'), 
('2012', '2020-08-26', '2020-08-26', '00841', 'PREGNANCY_PROFILE', '', '19', '32', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '904', 'pending'), 
('2013', '2020-08-26', '2020-08-26', '00841', 'RBS', '', '19', '32', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '904', 'pending'), 
('2014', '2020-08-26', '2020-08-26', '00842', 'R/E M/E', '', '19', '32', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '905', 'pending'), 
('2015', '2020-08-26', '2020-08-26', '00842', 'RBS', '', '19', '32', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '905', 'pending'), 
('2016', '2020-08-26', '2020-08-26', '00842', 'V.D.R.L', '', '19', '32', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '905', 'pending'), 
('2017', '2020-08-26', '2020-08-26', '00842', 'PREGNANCY_PROFILE', '', '19', '32', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '905', 'pending'), 
('2018', '2020-08-26', '2020-08-26', '00843', 'ECG', '', '19', '31', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '906', 'pending'), 
('2019', '2020-08-26', '2020-08-26', '00843', 'Chest P/A View', '', '19', '31', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '906', 'pending'), 
('2020', '2020-08-26', '2020-08-26', '00843', 'RBS', '', '19', '31', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '906', 'pending'), 
('2021', '2020-08-26', '2020-08-26', '00843', 'S. Creatinine', '', '19', '31', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '906', 'pending'), 
('2022', '2020-08-26', '2020-08-26', '00843', 'W_/_A', '', '19', '31', 'U_S_G_', '202', '', '0', '0.00', '', '750.00', '0.00', '906', 'pending'), 
('2023', '2020-08-26', '2020-08-26', '00844', 'X-RAY', '', '19', '31', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '907', 'pending'), 
('2024', '2020-08-26', '2020-08-26', '00844', 'X-RAY', '', '19', '31', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '907', 'pending'), 
('2025', '2020-08-26', '2020-08-26', '00844', 'X-RAY', '', '19', '31', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '907', 'pending'), 
('2026', '2020-08-26', '2020-08-26', '00844', 'R/E M/E', '', '19', '31', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '907', 'pending'), 
('2027', '2020-08-26', '2020-08-26', '00844', 'RBS', '', '19', '31', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '907', 'pending'), 
('2028', '2020-08-26', '2020-08-26', '00844', 'W/A', '', '19', '31', 'USG_COLOUR', '250', '', '0', '0.00', '', '850.00', '0.00', '907', 'pending'), 
('2029', '2020-08-26', '2020-08-26', '00844', 'Widal Test', '', '19', '31', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '907', 'pending'), 
('2030', '2020-08-26', '2020-08-26', '00845', 'CBC', '', '19', '33', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '908', 'pending'), 
('2031', '2020-08-26', '2020-08-26', '00845', 'RBS', '', '19', '33', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '908', 'pending'), 
('2032', '2020-08-26', '2020-08-26', '00845', 'R/E M/E', '', '19', '33', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '908', 'pending'), 
('2033', '2020-08-26', '2020-08-26', '00846', 'CBC', '', '12', '32', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '909', 'pending'), 
('2034', '2020-08-26', '2020-08-26', '00846', 'Widal Test', '', '12', '32', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '909', 'pending'), 
('2035', '2020-08-26', '2020-08-26', '00846', 'RBS', '', '12', '32', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '909', 'pending'), 
('2036', '2020-08-26', '2020-08-26', '00846', 'L/A', '', '12', '32', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '909', 'pending'), 
('2037', '2020-08-26', '2020-08-26', '00846', 'R/E M/E', '', '12', '32', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '909', 'pending'), 
('2038', '2020-08-26', '2020-08-26', '00847', 'USG_F/C', '', '20', '24', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '910', 'pending'), 
('2039', '2020-08-26', '2020-08-26', '00848', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '911', 'pending'), 
('2040', '2020-08-27', '2020-08-27', '00849', 'CBC', '', '19', '24', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '912', 'pending'), 
('2041', '2020-08-27', '2020-08-27', '00849', 'Widal Test', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '912', 'pending'), 
('2042', '2020-08-27', '2020-08-27', '00849', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '912', 'pending'), 
('2043', '2020-08-27', '2020-08-27', '00850', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '913', 'pending'), 
('2044', '2020-08-27', '2020-08-27', '00850', 'S. Bilirubin', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '913', 'pending'), 
('2045', '2020-08-27', '2020-08-27', '00850', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '913', 'pending'), 
('2046', '2020-08-27', '2020-08-27', '00851', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '914', 'pending'), 
('2047', '2020-08-27', '2020-08-27', '00851', 'S. Bilirubin', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '914', 'pending'), 
('2048', '2020-08-27', '2020-08-27', '00851', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '914', 'pending'), 
('2049', '2020-08-27', '2020-08-27', '00852', '	Hb%_/ESR', '', '19', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '915', 'pending'), 
('2050', '2020-08-27', '2020-08-27', '00852', 'Chest P/A View', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '915', 'pending'), 
('2051', '2020-08-27', '2020-08-27', '00852', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '915', 'pending'), 
('2052', '2020-08-27', '2020-08-27', '00852', 'W_/_A', '', '19', '23', 'U_S_G_', '202', '', '0', '0.00', '', '750.00', '0.00', '915', 'pending'), 
('2053', '2020-08-27', '2020-08-27', '00853', 'XRAY-LEFT_WRIST_B/V', '', '20', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '916', 'pending'), 
('2054', '2020-08-27', '2020-08-27', '00854', 'USG_F/C', '', '10', '30', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '917', 'pending'), 
('2055', '2020-08-27', '2020-08-27', '00854', 'Blood For Grouping', '', '10', '30', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '917', 'pending'), 
('2056', '2020-08-27', '2020-08-27', '00854', 'Hb%', '', '10', '30', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '917', 'pending'), 
('2057', '2020-08-27', '2020-08-27', '00854', 'Hbe Ag', '', '10', '30', 'SEROLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '917', 'pending'), 
('2058', '2020-08-27', '2020-08-27', '00855', 'L/A', '', '19', '24', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '918', 'pending'), 
('2059', '2020-08-27', '2020-08-27', '00855', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '918', 'pending'), 
('2060', '2020-08-27', '2020-08-27', '00855', 'Hb%', '', '19', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '918', 'pending'), 
('2061', '2020-08-27', '2020-08-27', '00855', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '918', 'pending'), 
('2062', '2020-08-27', '2020-08-27', '00856', 'Pregnancy Test', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '919', 'pending'), 
('2063', '2020-08-27', '2020-08-27', '00857', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '920', 'pending'), 
('2064', '2020-08-27', '2020-08-27', '00858', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '921', 'pending'), 
('2065', '2020-08-27', '2020-08-27', '00859', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '922', 'pending'), 
('2066', '2020-08-27', '2020-08-27', '00859', 'ESR', '', '19', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '922', 'pending'), 
('2067', '2020-08-27', '2020-08-27', '00860', 'CBC', '', '34', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '923', 'pending'), 
('2068', '2020-08-27', '2020-08-27', '00860', 'RBS', '', '34', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '923', 'pending'), 
('2069', '2020-08-27', '2020-08-27', '00860', 'S. Creatinine', '', '34', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '923', 'pending'), 
('2070', '2020-08-27', '2020-08-27', '00860', 'S. Bilirubin', '', '34', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '923', 'pending'), 
('2071', '2020-08-27', '2020-08-27', '00860', 'Hbs Ag', '', '34', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '923', 'pending'), 
('2072', '2020-08-27', '2020-08-27', '00860', 'R/E M/E', '', '34', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '923', 'pending'), 
('2073', '2020-08-27', '2020-08-27', '00860', 'X-RAY', '', '34', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '923', 'pending'), 
('2074', '2020-08-27', '2020-08-27', '00861', 'CBC', '', '20', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '924', 'pending'), 
('2075', '2020-08-27', '2020-08-27', '00861', 'RBS', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '924', 'pending'), 
('2076', '2020-08-27', '2020-08-27', '00861', 'Widal Test', '', '20', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '924', 'pending'), 
('2077', '2020-08-27', '2020-08-27', '00861', 'W/A', '', '20', '23', 'USG_COLOUR', '250', '', '0', '0.00', '', '850.00', '0.00', '924', 'pending'), 
('2078', '2020-08-27', '2020-08-27', '00861', 'R/E M/E', '', '20', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '924', 'pending'), 
('2079', '2020-08-28', '2020-08-28', '00862', 'Fasting/Randam', '', '19', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '150.00', '0.00', '925', 'pending'), 
('2080', '2020-08-28', '2020-08-28', '00862', 'Sugar_2_HABF', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '925', 'pending'), 
('2081', '2020-08-28', '2020-08-28', '00863', 'Fasting/Randam', '', '20', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '150.00', '0.00', '926', 'pending'), 
('2082', '2020-08-28', '2020-08-28', '00864', 'CBC', '', '48', '19', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '927', 'pending'), 
('2083', '2020-08-28', '2020-08-28', '00864', 'P.N.S', '', '48', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '927', 'pending'), 
('2084', '2020-08-28', '2020-08-28', '00864', 'W/A', '', '48', '19', 'USG_COLOUR', '250', '', '0', '0.00', '', '850.00', '0.00', '927', 'pending'), 
('2085', '2020-08-28', '2020-08-28', '00865', 'Chest P/A View', '', '20', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '928', 'pending'), 
('2086', '2020-08-28', '2020-08-28', '00866', 'CBC', '', '48', '19', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '929', 'pending'), 
('2087', '2020-08-28', '2020-08-28', '00866', 'Chest P/A View', '', '48', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '929', 'pending'), 
('2088', '2020-08-28', '2020-08-28', '00866', 'W/A', '', '48', '19', 'USG_COLOUR', '250', '', '0', '0.00', '', '850.00', '0.00', '929', 'pending'), 
('2089', '2020-08-28', '2020-08-28', '00866', 'ECG', '', '48', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '929', 'pending'), 
('2090', '2020-08-28', '2020-08-28', '00866', 'RBS', '', '48', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '929', 'pending'), 
('2091', '2020-08-28', '2020-08-28', '00867', 'PREGNANCY_PROFILE', '', '20', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '930', 'pending'), 
('2092', '2020-08-28', '2020-08-28', '00868', 'W_/_A', '', '20', '19', 'U_S_G_', '202', '', '0', '0.00', '', '750.00', '0.00', '931', 'pending'), 
('2093', '2020-08-28', '2020-08-28', '00869', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '932', 'pending'), 
('2094', '2020-08-28', '2020-08-28', '00869', 'R/E M/E', '', '19', '19', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '932', 'pending'), 
('2095', '2020-08-28', '2020-08-28', '00869', 'L/S_A/P', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '932', 'pending'), 
('2096', '2020-08-28', '2020-08-28', '00869', 'W/A', '', '19', '19', 'USG_COLOUR', '250', '', '0', '0.00', '', '850.00', '0.00', '932', 'pending'), 
('2097', '2020-08-28', '2020-08-28', '00870', 'CBC', '', '19', '19', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '933', 'pending'), 
('2098', '2020-08-28', '2020-08-28', '00870', 'W/A', '', '19', '19', 'USG_COLOUR', '250', '', '0', '0.00', '', '850.00', '0.00', '933', 'pending'), 
('2099', '2020-08-28', '2020-08-28', '00870', 'R/E M/E', '', '19', '19', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '933', 'pending'), 
('2100', '2020-08-28', '2020-08-28', '00870', 'Chest P/A View', '', '19', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '933', 'pending'), 
('2101', '2020-08-28', '2020-08-28', '00870', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '933', 'pending'), 
('2102', '2020-08-28', '2020-08-28', '00871', 'R/E M/E', '', '48', '19', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '934', 'pending'), 
('2103', '2020-08-28', '2020-08-28', '00872', 'Chest_p/A_View', '', '20', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '935', 'pending'), 
('2104', '2020-08-28', '2020-08-28', '00873', 'R/E M/E', '', '20', '19', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '936', 'pending'), 
('2105', '2020-08-28', '2020-08-28', '00874', ' W/A', '', '20', '24', 'USG_COLOUR', '250', '', '0', '0.00', '', '850.00', '0.00', '937', 'pending'), 
('2106', '2020-08-28', '2020-08-28', '00875', 'S. Creatinine', '', '19', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '938', 'pending'), 
('2107', '2020-08-28', '2020-08-28', '00875', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '938', 'pending'), 
('2108', '2020-08-28', '2020-08-28', '00876', 'ESR', '', '20', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '939', 'pending'), 
('2109', '2020-08-28', '2020-08-28', '00876', 'S. Creatinine', '', '20', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '939', 'pending'), 
('2110', '2020-08-28', '2020-08-28', '00877', 'USG_F/C', '', '19', '24', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '940', 'pending'), 
('2111', '2020-08-28', '2020-08-28', '00878', 'RBS', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '941', 'pending'), 
('2112', '2020-08-28', '2020-08-28', '00878', 'S.__ELECROLYTES', '', '19', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '850.00', '0.00', '941', 'pending'), 
('2113', '2020-08-28', '2020-08-28', '00878', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '941', 'pending'), 
('2114', '2020-08-28', '2020-08-28', '00879', 'CBC', '', '20', '19', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '942', 'pending'), 
('2115', '2020-08-28', '2020-08-28', '00879', 'RBS', '', '20', '19', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '942', 'pending'), 
('2116', '2020-08-28', '2020-08-28', '00879', 'ECG', '', '20', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '942', 'pending'), 
('2117', '2020-08-28', '2020-08-28', '00879', 'Chest P/A View', '', '20', '19', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '942', 'pending'), 
('2118', '2020-08-28', '2020-08-28', '00879', 'R/E M/E', '', '20', '19', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '942', 'pending'), 
('2119', '2020-08-28', '2020-08-28', '00879', 'R/A Test', '', '20', '19', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '942', 'pending'), 
('2120', '2020-08-28', '2020-08-28', '00879', 'CRP', '', '20', '19', 'SEROLOGY', '201', '', '0', '0.00', '', '650.00', '0.00', '942', 'pending'), 
('2121', '2020-08-28', '2020-08-28', '00880', 'S. Creatinine', '', '19', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '943', 'pending'), 
('2122', '2020-08-28', '2020-08-28', '00880', 'S.G.P.T.(ALT)', '', '19', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '943', 'pending'), 
('2123', '2020-08-28', '2020-08-28', '00880', 'S. Bilirubin', '', '19', '19', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '943', 'pending'), 
('2124', '2020-08-28', '2020-08-28', '00880', 'ESR', '', '19', '19', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '943', 'pending'), 
('2125', '2020-08-28', '2020-08-28', '00881', 'U_S_G__W_/_A', '', '19', '19', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '944', 'pending'), 
('2126', '2020-08-28', '2020-08-28', '00881', 'R/E M/E', '', '19', '19', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '944', 'pending'), 
('2127', '2020-08-28', '2020-08-28', '00882', 'Blood For Grouping', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '945', 'pending'), 
('2128', '2020-08-28', '2020-08-28', '00883', 'ECG', '', '19', '19', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '946', 'pending'), 
('2129', '2020-08-29', '2020-08-29', '00884', 'CBC', '', '19', '33', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '947', 'pending'), 
('2130', '2020-08-29', '2020-08-29', '00884', 'RBS', '', '19', '33', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '947', 'pending'), 
('2131', '2020-08-29', '2020-08-29', '00884', 'S. Creatinine', '', '19', '33', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '947', 'pending'), 
('2132', '2020-08-29', '2020-08-29', '00884', 'S.__ELECROLYTES', '', '19', '33', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '850.00', '0.00', '947', 'pending'), 
('2133', '2020-08-29', '2020-08-29', '00884', 'Chest P/A View', '', '19', '33', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '947', 'pending'), 
('2134', '2020-08-29', '2020-08-29', '00885', 'USG_F/C', '', '19', '24', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '948', 'pending'), 
('2135', '2020-08-29', '2020-08-29', '00886', 'X-RAY', '', '19', '33', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '949', 'pending'), 
('2136', '2020-08-29', '2020-08-29', '00886', 'X-RAY', '', '19', '33', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '949', 'pending'), 
('2137', '2020-08-29', '2020-08-29', '00886', 'X-RAY', '', '19', '33', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '949', 'pending'), 
('2138', '2020-08-29', '2020-08-29', '00886', 'R/A Test', '', '19', '33', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '949', 'pending'), 
('2139', '2020-08-29', '2020-08-29', '00886', 'Hb%_/ESR', '', '19', '33', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '949', 'pending'), 
('2140', '2020-08-29', '2020-08-29', '00886', 'RBS', '', '19', '33', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '949', 'pending'), 
('2141', '2020-08-29', '2020-08-29', '00887', 'Chest P/A View', '', '20', '33', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '950', 'pending'), 
('2142', '2020-08-29', '2020-08-29', '00887', 'RBS', '', '20', '33', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '950', 'pending'), 
('2143', '2020-08-29', '2020-08-29', '00887', 'ECG', '', '20', '33', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '950', 'pending'), 
('2144', '2020-08-29', '2020-08-29', '00887', 'CBC', '', '20', '33', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '950', 'pending'), 
('2145', '2020-08-29', '2020-08-29', '00887', 'S. Creatinine', '', '20', '33', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '950', 'pending'), 
('2146', '2020-08-29', '2020-08-29', '00887', 'R/E M/E', '', '20', '33', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '950', 'pending'), 
('2147', '2020-08-29', '2020-08-29', '00888', 'X-RAY', '', '19', '33', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '951', 'pending'), 
('2148', '2020-08-29', '2020-08-29', '00888', 'X-RAY', '', '19', '33', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '951', 'pending'), 
('2149', '2020-08-29', '2020-08-29', '00888', 'X-RAY', '', '19', '33', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '951', 'pending'), 
('2150', '2020-08-29', '2020-08-29', '00888', 'X-RAY', '', '19', '33', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '951', 'pending'), 
('2151', '2020-08-29', '2020-08-29', '00888', 'CRP', '', '19', '33', 'SEROLOGY', '201', '', '0', '0.00', '', '650.00', '0.00', '951', 'pending'), 
('2152', '2020-08-29', '2020-08-29', '00888', 'R/A Test', '', '19', '33', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '951', 'pending'), 
('2153', '2020-08-29', '2020-08-29', '00888', 'RBS', '', '19', '33', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '951', 'pending'), 
('2154', '2020-08-29', '2020-08-29', '00888', '	Hb%_/ESR', '', '19', '33', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '951', 'pending'), 
('2155', '2020-08-29', '2020-08-29', '00889', 'Hbs Ag', '', '20', '32', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '952', 'pending'), 
('2156', '2020-08-29', '2020-08-29', '00889', 'Hb%', '', '20', '32', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '952', 'pending'), 
('2157', '2020-08-29', '2020-08-29', '00889', 'R/E M/E', '', '20', '32', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '952', 'pending'), 
('2158', '2020-08-29', '2020-08-29', '00889', 'PREGNANCY_PROFILE', '', '20', '32', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '952', 'pending'), 
('2160', '2020-08-29', '2020-08-29', '00891', 'CBC', '', '19', '21', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '954', 'pending'), 
('2161', '2020-08-29', '2020-08-29', '00891', 'Widal Test', '', '19', '21', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '954', 'pending'), 
('2162', '2020-08-29', '2020-08-29', '00891', 'R/E M/E', '', '19', '21', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '954', 'pending'), 
('2163', '2020-08-30', '2020-08-30', '00892', 'Sugar_2_HABF', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '955', 'pending'), 
('2164', '2020-08-30', '2020-08-30', '00893', 'Sugar_2_HABF', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '956', 'pending'), 
('2165', '2020-08-30', '2020-08-30', '00894', 'Sugar_2_HABF', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '957', 'pending'), 
('2166', '2020-08-30', '2020-08-30', '00895', 'Blood For Grouping', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '958', 'pending'), 
('2167', '2020-08-30', '2020-08-30', '00896', 'Hb%', '', '19', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '959', 'pending'), 
('2168', '2020-08-30', '2020-08-30', '00896', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '959', 'pending'), 
('2174', '2020-08-30', '2020-08-30', '00898', 'S. Bilirubin', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '961', 'pending'), 
('2175', '2020-08-30', '2020-08-30', '00898', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '961', 'pending'), 
('2176', '2020-08-30', '2020-08-30', '00898', 'S.Cholesterol', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '650.00', '0.00', '961', 'pending'), 
('2177', '2020-08-30', '2020-08-30', '00899', 'USG_F/C', '', '19', '24', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '962', 'pending'), 
('2178', '2020-08-30', '2020-08-30', '00900', 'Hb%_/ESR', '', '20', '33', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '963', 'pending'), 
('2179', '2020-08-30', '2020-08-30', '00900', 'RBS', '', '20', '33', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '963', 'pending'), 
('2180', '2020-08-30', '2020-08-30', '00900', 'Chest_P/A_View', '', '20', '33', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '963', 'pending'), 
('2181', '2020-08-30', '2020-08-30', '00901', 'USG_F/C', '', '10', '30', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '964', 'pending'), 
('2182', '2020-08-30', '2020-08-30', '00902', 'USG_F/C', '', '19', '24', 'USG', '202', '', '0', '0.00', '', '650.00', '0.00', '965', 'pending'), 
('2183', '2020-08-30', '2020-08-30', '00902', 'Blood For Grouping', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '965', 'pending'), 
('2184', '2020-08-30', '2020-08-30', '00903', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '966', 'pending'), 
('2185', '2020-08-30', '2020-08-30', '00904', 'X-RAY', '', '20', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '967', 'pending'), 
('2186', '2020-08-30', '2020-08-30', '00905', 'Hb%', '', '19', '32', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '968', 'pending'), 
('2187', '2020-08-30', '2020-08-30', '00905', 'Hbs Ag', '', '19', '32', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '968', 'pending'), 
('2188', '2020-08-30', '2020-08-30', '00905', 'L/A', '', '19', '32', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '968', 'pending'), 
('2189', '2020-08-30', '2020-08-30', '00905', 'R/E M/E', '', '19', '32', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '968', 'pending'), 
('2190', '2020-08-30', '2020-08-30', '00905', 'S.__ELECROLYTES', '', '19', '32', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '850.00', '0.00', '968', 'pending'), 
('2191', '2020-08-31', '2020-08-31', '00906', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '969', 'pending'), 
('2192', '2020-08-31', '2020-08-31', '00907', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '970', 'pending'), 
('2193', '2020-08-31', '2020-08-31', '00908', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '971', 'pending'), 
('2194', '2020-08-31', '2020-08-31', '00909', 'CBC', '', '41', '23', 'HAEMATOLOGY', '101', '', '23', '120.00', '', '400.00', '0.00', '972', 'pending'), 
('2195', '2020-08-31', '2020-08-31', '00909', 'RBS', '', '41', '23', 'BIOCHEMISTRY', '201', '', '23', '120.00', '', '150.00', '0.00', '972', 'pending'), 
('2196', '2020-08-31', '2020-08-31', '00909', 'S. Creatinine', '', '41', '23', 'BIOCHEMISTRY', '101', '', '23', '120.00', '', '400.00', '0.00', '972', 'pending'), 
('2197', '2020-08-31', '2020-08-31', '00909', 'Widal Test', '', '41', '23', 'SEROLOGY', '201', '', '23', '120.00', '', '400.00', '0.00', '972', 'pending'), 
('2198', '2020-08-31', '2020-08-31', '00909', 'W/A', '', '41', '23', 'USG_COLOUR', '250', '', '23', '120.00', '', '850.00', '0.00', '972', 'pending'), 
('2199', '2020-08-31', '2020-08-31', '00909', 'X-RAY', '', '41', '23', 'DIGITAL X-RAY', '204', '', '23', '120.00', '', '250.00', '0.00', '972', 'pending'), 
('2200', '2020-08-31', '2020-08-31', '00910', 'Hb%', '', '19', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '973', 'pending'), 
('2201', '2020-08-31', '2020-08-31', '00911', 'Hb%_/ESR', '', '19', '23', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '300.00', '0.00', '974', 'pending'), 
('2202', '2020-08-31', '2020-08-31', '00911', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '974', 'pending'), 
('2203', '2020-08-31', '2020-08-31', '00911', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '974', 'pending'), 
('2204', '2020-08-31', '2020-08-31', '00911', 'PREGNANCY_PROFILE', '', '19', '23', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '974', 'pending'), 
('2205', '2020-08-31', '2020-08-31', '00912', 'PREGNANCY_PROFILE', '', '20', '23', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '975', 'pending'), 
('2206', '2020-08-31', '2020-08-31', '00912', 'R/E M/E', '', '20', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '975', 'pending'), 
('2207', '2020-08-31', '2020-08-31', '00913', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '976', 'pending'), 
('2209', '2020-09-01', '2020-09-01', '00915', 'HBA.1C', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '850.00', '0.00', '978', 'pending'), 
('2210', '2020-09-01', '2020-09-01', '00915', 'RBS', '', '19', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '978', 'pending'), 
('2211', '2020-09-01', '2020-09-01', '00915', 'S. Creatinine', '', '19', '23', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '978', 'pending'), 
('2212', '2020-09-01', '2020-09-01', '00915', 'X-RAY', '', '19', '23', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '978', 'pending'), 
('2213', '2020-09-01', '2020-09-01', '00916', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '979', 'pending'), 
('2214', '2020-09-01', '2020-09-01', '00917', 'USG_F_/C', '', '19', '24', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '980', 'pending'), 
('2215', '2020-09-01', '2020-09-01', '00918', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '981', 'pending'), 
('2216', '2020-09-02', '2020-09-02', '00919', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '982', 'pending'), 
('2217', '2020-09-02', '2020-09-02', '00919', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '982', 'pending'), 
('2218', '2020-09-02', '2020-09-02', '00919', 'L/A', '', '19', '23', 'USG_COLOUR', '202', '', '0', '0.00', '', '850.00', '0.00', '982', 'pending'), 
('2219', '2020-09-02', '2020-09-02', '00920', 'PREGNANCY_PROFILE', '', '20', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '983', 'pending'), 
('2220', '2020-09-02', '2020-09-02', '00921', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '984', 'pending'), 
('2221', '2020-09-02', '2020-09-02', '00922', 'Sugar_2_HABF', '', '20', '23', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '985', 'pending'), 
('2222', '2020-09-02', '2020-09-02', '00923', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '986', 'pending'), 
('2223', '2020-09-02', '2020-09-02', '00924', 'CBC', '', '19', '23', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '987', 'pending'), 
('2224', '2020-09-02', '2020-09-02', '00924', 'Widal Test', '', '19', '23', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '987', 'pending'), 
('2225', '2020-09-02', '2020-09-02', '00924', 'U_S_G__W_/_A', '', '19', '23', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '987', 'pending'), 
('2226', '2020-09-02', '2020-09-02', '00924', 'R/E M/E', '', '19', '23', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '987', 'pending'), 
('2227', '2020-09-02', '2020-09-02', '00925', 'ECG', '', '19', '24', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '988', 'pending'), 
('2228', '2020-09-02', '2020-09-02', '00925', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '988', 'pending'), 
('2229', '2020-09-02', '2020-09-02', '00925', 'RBS', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '988', 'pending'), 
('2230', '2020-09-02', '2020-09-02', '00926', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '? string:0 ?', '0.00', '', '650.00', '0.00', '989', 'pending'), 
('2231', '2020-09-02', '2020-09-02', '00927', 'DANTAL_X-RAY', '', '19', '24', 'DANTAL_X-RAY', '204', '', '0', '0.00', '', '150.00', '0.00', '990', 'pending'), 
('2232', '2020-09-02', '2020-09-02', '00928', 'R/E M/E', '', '29', '25', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '991', 'pending'), 
('2233', '2020-09-02', '2020-09-02', '00929', 'X-RAY', '', '20', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '992', 'pending'), 
('2234', '2020-09-02', '2020-09-02', '00930', 'W/A', '', '19', '31', 'USG_COLOUR', '250', '', '0', '0.00', '', '850.00', '0.00', '993', 'pending'), 
('2235', '2020-09-02', '2020-09-02', '00930', 'S. Creatinine', '', '19', '31', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '993', 'pending'), 
('2236', '2020-09-02', '2020-09-02', '00930', 'R/E M/E', '', '19', '31', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '993', 'pending'), 
('2237', '2020-09-02', '2020-09-02', '00930', 'Chest P/A View', '', '19', '31', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '993', 'pending'), 
('2238', '2020-09-02', '2020-09-02', '00930', 'RBS', '', '19', '31', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '993', 'pending'), 
('2239', '2020-09-02', '2020-09-02', '00930', 'ECG', '', '19', '31', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '993', 'pending'), 
('2240', '2020-09-02', '2020-09-02', '00931', 'CBC', '', '19', '31', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '994', 'pending'), 
('2241', '2020-09-02', '2020-09-02', '00931', 'S. Creatinine', '', '19', '31', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '400.00', '0.00', '994', 'pending'), 
('2242', '2020-09-02', '2020-09-02', '00931', 'RBS', '', '19', '31', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '994', 'pending'), 
('2243', '2020-09-02', '2020-09-02', '00931', 'W/A', '', '19', '31', 'USG_COLOUR', '250', '', '0', '0.00', '', '850.00', '0.00', '994', 'pending'), 
('2244', '2020-09-02', '2020-09-02', '00932', 'CBC', '', '34', '31', 'HAEMATOLOGY', '101', '', '0', '0.00', '', '400.00', '0.00', '995', 'pending'), 
('2245', '2020-09-02', '2020-09-02', '00932', 'Chest P/A View', '', '34', '31', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '995', 'pending'), 
('2246', '2020-09-02', '2020-09-02', '00932', 'ECG', '', '34', '31', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '995', 'pending'), 
('2247', '2020-09-02', '2020-09-02', '00933', 'RBS', '', '20', '31', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '996', 'pending'), 
('2248', '2020-09-02', '2020-09-02', '00934', 'X-RAY', '', '19', '24', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '997', 'pending'), 
('2249', '2020-09-02', '2020-09-02', '00935', 'ECG', '', '19', '31', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '998', 'pending'), 
('2250', '2020-09-02', '2020-09-02', '00935', 'RBS', '', '19', '31', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '998', 'pending'), 
('2251', '2020-09-02', '2020-09-02', '00935', 'U_S_G__W_/_A', '', '19', '31', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '998', 'pending'), 
('2252', '2020-09-02', '2020-09-02', '00935', 'Lipid Profile', '', '19', '31', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '1200.00', '0.00', '998', 'pending'), 
('2253', '2020-09-02', '2020-09-02', '00936', 'Blood For Grouping', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '999', 'pending'), 
('2254', '2020-09-02', '2020-09-02', '00937', 'ECG', '', '34', '24', 'ECG', '202', '', '0', '0.00', '', '250.00', '0.00', '1000', 'pending'), 
('2255', '2020-09-02', '2020-09-02', '00937', 'RBS', '', '34', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '1000', 'pending'), 
('2256', '2020-09-02', '2020-09-02', '00938', 'Blood For Grouping', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '1001', 'pending'), 
('2257', '2020-09-02', '2020-09-02', '00939', 'Sugar_2_HABF', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '1002', 'pending'), 
('2258', '2020-09-02', '2020-09-02', '00940', 'R/E M/E', '', '19', '24', 'URINE', '201', '', '0', '0.00', '', '150.00', '0.00', '1003', 'pending'), 
('2259', '2020-09-02', '2020-09-02', '00941', 'S. Bilirubin', '', '19', '24', 'BIOCHEMISTRY', '101', '', '0', '0.00', '', '250.00', '0.00', '1004', 'pending'), 
('2260', '2020-09-02', '2020-09-02', '00941', 'Widal Test', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '400.00', '0.00', '1004', 'pending'), 
('2261', '2020-09-02', '2020-09-02', '00941', 'U_S_G__W_/_A', '', '19', '24', 'U_S_G____W_/_A', '202', '', '0', '0.00', '', '650.00', '0.00', '1004', 'pending'), 
('2262', '2020-09-02', '2020-09-02', '00942', 'PREGNANCY_PROFILE', '', '19', '24', 'USG_ULTRASONOGRAPHY', '202', '', '0', '0.00', '', '650.00', '0.00', '1005', 'pending'), 
('2263', '2020-09-02', '2020-09-02', '00943', 'Blood For Grouping', '', '19', '24', 'SEROLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '1006', 'pending'), 
('2264', '2020-09-02', '2020-09-02', '00944', 'Chest P/A View', '', '19', '21', 'DIGITAL X-RAY', '204', '', '0', '0.00', '', '250.00', '0.00', '1007', 'pending'), 
('2265', '2020-09-03', '2020-09-03', '00945', 'Hb%_HAEMATOLOGY', '', '19', '24', 'HAEMATOLOGY', '201', '', '0', '0.00', '', '150.00', '0.00', '1008', 'pending'), 
('2266', '2020-09-03', '2020-09-03', '00945', 'Sugar_2_HABF_BIOCHEMISTRY', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '150.00', '0.00', '1008', 'pending'), 
('2267', '2020-09-03', '2020-09-03', '00946', 'BT/CT_HAEMATOLOGY', '', '3', '21', 'HAEMATOLOGY', '101', '', '20', '200.00', '', '900.00', '0.00', '1009', 'pending'), 
('2268', '2020-09-03', '2020-09-03', '00946', 'W/A__Ultrasonography', '', '3', '21', '_Ultrasonography', '202', '', '20', '200.00', '', '650.00', '0.00', '1009', 'pending'), 
('2269', '2020-09-03', '2020-09-03', '00947', 'F.SUGAR_/_SUGAR_2HABF__BIOCHEMISTRY', '', '20', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '300.00', '0.00', '1010', 'pending'), 
('2270', '2020-09-03', '2020-09-03', '00948', 'F.SUGAR_/_SUGAR_2HABF__BIOCHEMISTRY', '', '19', '24', 'BIOCHEMISTRY', '201', '', '0', '0.00', '', '300.00', '0.00', '1011', 'pending');  



INSERT INTO `doctor_payment` ( `id`, `date`, `doctor_id`, `total_paid`, `payment`, `less`, `due`, `trash`) VALUES 
('11', '2020-07-21', '19', '140.00', '60.00', '80.00', '260.00', '0'), 
('10', '2020-07-21', '23', '220.00', '80.00', '40.00', '1180.00', '0'), 
('8', '2020-07-21', '23', '100.00', '100.00', '0.00', '1300.00', '0'), 
('12', '2020-07-21', '19', '340.00', '160.00', '40.00', '60.00', '0'), 
('13', '2020-07-22', '19', '350.00', '10.00', '0.00', '50.00', '0'), 
('14', '2020-07-22', '23', '240.00', '20.00', '0.00', '1660.00', '0'), 
('15', '2020-07-22', '23', '1240.00', '1000.00', '0.00', '660.00', '0'), 
('16', '2020-07-22', '34', '400.00', '400.00', '0.00', '0.00', '1');  



INSERT INTO `doctors` ( `id`, `fullName`, `designation`, `degree`, `specialised`, `hospital`, `mobile`, `phone`, `email`, `fee`, `commission`, `address`, `image`, `room_no`, `status`) VALUES 
('13', 'Utpal Kumar Pal', 'Professor', 'MBBS.BCS(health) MPhil, medical science', 'Medicine diabetology', 'Mymensingh medical college', '01716457373', '', '', '600.00', '00', 'Muktagacha', 'public/upload/doctors/doctor-1592855888.jpg', '00', '0'), 
('17', 'MD.Abul', 'Asst_Professor', 'L.M.F.', 'General', 'Village doctor', '8801724452861', '', '', '250.00', '5', 'Muktagacha', '', '00', '1'), 
('19', 'Hasimul Ahasan Suhag', 'Medical Officer', 'MBBS.BCS. (health)FCPS( final)MD(final)', 'Medicine. Cardiology', 'Sheikh mujib medical university (PG hospital)', '01949800600', '', '', '400.00', '00', 'Muktagacha', 'public/upload/doctors/doctor-1592854852.jpg', '101', '1'), 
('20', 'Moushumi Haq Moon', 'Asst_Professor', 'MBBS.BCS(health) FCPS( final)', 'Gynaecology and ops', 'Upazila health complex muktagacha', '01768860774', '', '', '300.00', '00', 'Muktagacha', '', '202', '1'), 
('21', 'Utpal Kumar Pal', 'Professor', 'MBBS.BCS(health) MPhil, medical science', 'Medicine diabetology', 'Mymensingh medical college', '01716457373', '', '', '600.00', '00', 'Muktagacha', 'public/upload/doctors/doctor-1592855888.jpg', '00', '1'), 
('22', 'Dr.developer', 'Labore rerum fugiat', 'Ut dolor ex laboris', 'Consequuntur culpa ', 'Ullam dolore officia', '32648136120', '32654789561', 'zanixe@mailinator.com', '7.00', '62', 'Sunt nisi dolores im', '', '52', '0'), 
('23', 'Dr.Makame Mahmud', 'Principal', 'MBBS,PGT', ' Medicine. Child. Skin and sex', 'SOMC', '01971631300', '', '', '300.00', '', 'ALAMIN DIAGNOSTIC COMPLEX MUKTAGACHA', '', '101', '1'), 
('24', 'Self', 'FF', '', 'FF', 'FF', '01723926073', '', '', '0.00', '', '', '', '', '1'), 
('25', 'RUHUL AMIN', 'PC', 'L M A F', 'GANARAL', 'MUK', '01936134450', '', '', '200.00', '', 'MUKTAGHA', '', '', '1'), 
('26', 'U H C  MUKLTAGACHA', 'U H C  MUKLTAGACHA', 'U H C  MUKLTAGACHA', 'U H C  MUKLTAGACHA', '', '', '', '', '0.00', '', 'U H C  MUKLTAGACHA', '', '', '1'), 
('27', 'VASKOR SAHA KOLLOL', 'MBBS(MD)', 'MBBS(MD)', 'GENERAL PRACTITIONER', 'MEDICARE', '01711338463', '', '', '300.00', '', 'MUKTAGACHA.', '', '', '1'), 
('28', 'SHIHABUL ISLAM (SHIHAB)', 'DMF', 'DMF', 'GANARAL', '', '01731179081', '', '', '0.00', '', 'MUKTAGACHA', 'public/upload/doctors/doctor-1594210730.jpg', '', '1'), 
('29', 'test07', 'Asst_Professor', 'ZZTVKI8Fcg', 'PDe4IuJg0N', 'AYvNmeuWvZ', '663468546434', '085430', 'e5ztq@3dkk.com', '500.00', '5', 'mOmP7vg4iN', '', '144038', '1'), 
('30', 'MORZINA', 'GANARAL', 'LMF/DMF', 'GANARAL', 'V', '01712944431', '', '', '202.00', '', 'MUKTAGACHA', 'public/upload/doctors/doctor-1594704641.jpg', '00', '1'), 
('31', 'MUKLASUR  ROHOMAN LITON', 'Asst_Professor', 'MBBS.BCS.FCPS', 'MEDICIN.', 'MMCH', '01738327384', '', '', '400.00', '', 'MMCH', 'public/upload/doctors/doctor-1595057474.JPG', '101', '1'), 
('32', 'Efatara Himu', 'MBBS', 'PGT', 'GYNEE', '', '01749376788', '', '', '300.00', '', 'MUKTAGACHA', 'public/upload/doctors/doctor-1595230078.jpg', '', '1'), 
('33', 'Mohsin Uddin', 'MBBS,PGT,CCD(Bardim)', '', 'Medecin ', '', '01673374144', '', '', '300.00', '', 'Muktagacha', '', '', '1'), 
('34', 'test Doctor', 'A P', 'M fil', 'Hard', 'NK', '01910252623', '01910874532', 'testd@7070.com', '500.00', '0', 'sd', '', '236', '1'), 
('35', 'PANKAJ KUMAR DAS', 'ASST.PROFESSOR', 'MBBS.DDV. (DU)', 'SKIN & VD  DEPARTMENT', 'Mymensingh medical college', '00000000000', '', '', '600.00', '', 'MUKTAGACHA', '', '', '1');  



INSERT INTO `due_payment` ( `id`, `date`, `time`, `voucher_number`, `total_amount`, `prev_paid`, `prev_due`, `paid`, `due`, `remission`) VALUES 
('1', '2020-07-06', '05:55:10 PM', '2006240006', '700.00', '100.00', '0.00', '600.00', '0.00', '0.00'), 
('2', '2020-07-07', '01:42:18 PM', '2007070112', '400.00', '300.00', '0.00', '100.00', '0.00', '0.00'), 
('3', '2020-07-07', '01:53:28 PM', '2007070112', '400.00', '300.00', '0.00', '90.00', '0.00', '0.00'), 
('4', '2020-07-22', '10:17:59 AM', '2007220342', '400.00', '300.00', '0.00', '50.00', '50.00', '0.00'), 
('5', '2020-07-22', '10:23:08 AM', '2007220343', '400.00', '120.00', '0.00', '200.00', '80.00', '0.00'), 
('6', '2020-07-22', '05:52:11 PM', '2007220357', '990.00', '100.00', '0.00', '800.00', '0.00', '0.00'), 
('7', '2020-07-25', '03:13:45 PM', '2007250425', '700.00', '200.00', '0.00', '500.00', '0.00', '0.00');  



 



INSERT INTO `employee` ( `id`, `date`, `emp_id`, `name`, `father_name`, `mother_name`, `email`, `joining_date`, `gender`, `date_of_birth`, `nid_no`, `mobile`, `present_address`, `permanent_address`, `designation`, `remarks`, `path`, `status`) VALUES 
('4', '2020-06-29', '0001', 'MD.Rajon Mia', ' Shahid ul Islam', ' Rajiya khatun', '', '0000-00-00', 'Male', '1994-06-28', '', '01778238145', '', 'khajuriya Karbawla muktachaga', '0', ' medical technologist', 'public/employee/employee_46663_0001.jpg', 'active'), 
('5', '2020-07-04', '0002', 'JOBEDA', 'SAIFUL ISLAM', 'SABINA', '', '2020-07-01', 'Female', '1970-01-01', ' ', '01718891417', 'CHORBOGURA.MUKTAGACHA', '', 'Security Gard', '', 'public/employee/employee_74966_0002.jpg', 'active'), 
('6', '2020-07-04', '0003', 'AYESHA', 'CHANMIA', 'ROMISA', '', '2016-01-01', 'Female', '2010-10-19', '', '01998215626', 'MUKTAGACHA', 'MUKTAGACHA', 'Accountant', '', 'public/employee/employee_38433_0003.jpg', 'active'), 
('7', '2020-07-04', '0004', 'HARUN', 'ABUL KALAM', 'AMINA', '', '2018-01-01', 'Male', '1980-01-01', '', '01718813819', 'MOKTAGACHA', 'MOKTAGACHA', 'Office Assistant', '', 'public/employee/employee_45854_0004.JPG', 'active'), 
('8', '2020-07-04', '0005', 'TANJILA', 'ABDUL HANNAN', '', '', '2020-01-01', 'Male', '1998-01-01', '', '01975359636', 'BAPKI MUKTAGACHA', 'BAPKI MUKTAGACHA', 'Office Assistant', '', 'public/employee/employee_37249_0005.jpg', 'active'), 
('9', '2020-07-06', '0006', 'ROFIKUL ISLAM', 'MOSLEM UDDIN', 'POSPPO', '', '0000-00-00', 'Male', '1990-01-01', '', '01903824613', 'MUKTAGACHA', 'MUKTAGACHA', 'Office Assistant', '', 'public/employee/employee_65425_0006.jpg', 'active');  



INSERT INTO `group_name` ( `id`, `group_name`) VALUES 
('1', 'HAEMATOLOGY'), 
('2', 'BIOCHEMISTRY'), 
('3', 'SEROLOGY'), 
('4', 'HORMON'), 
('5', 'URINE'), 
('6', 'STOOL'), 
('7', 'DIGITAL X-RAY'), 
('8', 'DIGITAL ULTRASONOGRAPHY'), 
('9', 'OTHERS'), 
('10', 'USG_ULTRASONOGRAPHY'), 
('11', 'DANTAL_X-RAY'), 
('12', 'ECG'), 
('13', 'URINE_R./E'), 
('14', 'U_S_G____W_/_A'), 
('15', 'U_S_G_'), 
('16', 'USG'), 
('17', 'USG_COLOUR'), 
('18', 'M.T_MAN_TUX)'), 
('19', 'M.T_MAN_TOUX)'), 
('20', 'Test'), 
('21', 'IMONULOGY'), 
('22', 'DIGITAL_X-RAY_EXPRESS'), 
('23', 'Digital_Ultrasonography'), 
('24', '_Ultrasonography');  



INSERT INTO `incentive_structure` ( `id`, `eid`, `fields`, `percentage`, `remarks`, `status`) VALUES 
('1', '0002', 'HRA', '1.00', '', ''), 
('2', '0002', 'DA', '1.00', '', ''), 
('3', '0002', 'TA', '0.00', '', ''), 
('4', '0002', 'CCA', '0.00', '', ''), 
('5', '0002', 'Medical', '1.00', '', ''), 
('6', '0003', 'HRA', '10.00', '', ''), 
('7', '0003', 'DA', '20.00', '', ''), 
('8', '0003', 'TA', '40.00', '', ''), 
('9', '0003', 'CCA', '15.00', '', ''), 
('10', '0003', 'Medical', '15.00', '', '');  



INSERT INTO `income` ( `id`, `date`, `income_field`, `description`, `amount`, `income_by`, `trash`) VALUES 
('4', '2020-06-16', '0003', 'test', '560.00', 'developer', '0'), 
('5', '2020-06-22', '0003', '', '100.00', '', '0'), 
('6', '2020-07-15', '0003', '', '10.00', '', '0'), 
('9', '2020-08-08', '0004', '', '10.00', '', '1');  



INSERT INTO `income_field` ( `id`, `code`, `income_field`, `trash`) VALUES 
('3', '0003', 'Others', '0'), 
('4', '0004', 'Rent', '0'), 
('5', '0005', 'Test', '1'), 
('6', '0006', 'Current Bill', '1');  



INSERT INTO `investigation` ( `id`, `date`, `group`, `test_name`, `name`, `test_fee`, `cost`, `room`) VALUES 
('1', '2018-12-06', 'HAEMATOLOGY', 'CBC_HAEMATOLOGY', 'CBC', '400', '0.00', '101'), 
('2', '2018-12-06', 'HAEMATOLOGY', 'Platelet Count_HAEMATOLOGY', 'Platelet Count', '700', '0.00', '101'), 
('3', '2018-12-06', 'HAEMATOLOGY', 'BT/CT_HAEMATOLOGY', 'BT/CT', '900', '0.00', '101'), 
('4', '2018-12-06', 'HAEMATOLOGY', 'PBF_HAEMATOLOGY', 'PBF', '500', '300.00', '101'), 
('5', '2018-12-06', 'HAEMATOLOGY', 'Reticulacytes Count_HAEMATOLOGY', 'Reticulacytes Count', '700', '300.00', '101'), 
('6', '2018-12-06', 'BIOCHEMISTRY', 'Fasting/Randam_BIOCHEMISTRY', 'Fasting/Randam', '150', '0.00', '101'), 
('7', '2018-12-06', 'BIOCHEMISTRY', '2Hour After 75 Gram, Glucose_BIOCHEMISTRY', '2Hour After 75 Gram, Glucose', '300', '0.00', '101'), 
('8', '2018-12-06', 'BIOCHEMISTRY', 'G.T.T/P.P.B.S_BIOCHEMISTRY', 'G.T.T/P.P.B.S', '0', '0.00', '101'), 
('9', '2018-12-06', 'BIOCHEMISTRY', 'S. Bilirubin_BIOCHEMISTRY', 'S. Bilirubin', '250', '0.00', '101'), 
('10', '2018-12-06', 'BIOCHEMISTRY', 'S.G.P.T.(ALT)_BIOCHEMISTRY', 'S.G.P.T.(ALT)', '400', '0.00', '101'), 
('11', '2018-12-06', 'BIOCHEMISTRY', 'S.G.O.T.(AST)_BIOCHEMISTRY', 'S.G.O.T.(AST)', '400', '0.00', '101'), 
('12', '2018-12-06', 'BIOCHEMISTRY', 'AIK Phos_BIOCHEMISTRY', 'AIK Phos', '0', '0.00', '101'), 
('13', '2018-12-06', 'BIOCHEMISTRY', 'S.Protin_BIOCHEMISTRY', 'S.Protin', '0', '0.00', '101'), 
('14', '2018-12-06', 'BIOCHEMISTRY', 'S.Albomin_BIOCHEMISTRY', 'S.Albomin', '0', '0.00', '101'), 
('16', '2018-12-06', 'BIOCHEMISTRY', 'S Uric Acid_BIOCHEMISTRY', 'S Uric Acid', '650', '0.00', '101'), 
('17', '2018-12-06', 'BIOCHEMISTRY', 'Urea Level/ Bun_BIOCHEMISTRY', 'Urea Level/ Bun', '0', '0.00', '101'), 
('18', '2018-12-06', 'BIOCHEMISTRY', 'S. Creatinine_BIOCHEMISTRY', 'S. Creatinine', '400', '0.00', '101'), 
('19', '2018-12-06', 'BIOCHEMISTRY', 'Lipid Profile_BIOCHEMISTRY', 'Lipid Profile', '1200', '0.00', '101'), 
('20', '2018-12-06', 'BIOCHEMISTRY', 'Prothombin Time_BIOCHEMISTRY', 'Prothombin Time', '0', '0.00', '101'), 
('21', '2018-12-06', 'SEROLOGY', 'Blood For Grouping_SEROLOGY', 'Blood For Grouping', '150', '0.00', '201'), 
('22', '2018-12-06', 'SEROLOGY', 'A.S.O Titre_SEROLOGY', 'A.S.O Titre', '400', '0.00', '201'), 
('23', '2018-12-06', 'SEROLOGY', 'R/A Test_SEROLOGY', 'R/A Test', '400', '0.00', '201'), 
('24', '2018-12-06', 'SEROLOGY', 'TPHA_SEROLOGY', 'TPHA', '0', '0.00', '101'), 
('25', '2018-12-06', 'SEROLOGY', 'V.D.R.L_SEROLOGY', 'V.D.R.L', '400', '0.00', '201'), 
('26', '2018-12-06', 'SEROLOGY', 'Widal Test_SEROLOGY', 'Widal Test', '400', '0.00', '201'), 
('27', '2018-12-06', 'SEROLOGY', 'Hbs Ag_SEROLOGY', 'Hbs Ag', '400', '0.00', '201'), 
('28', '2018-12-06', 'SEROLOGY', 'Hbe Ag_SEROLOGY', 'Hbe Ag', '400', '0.00', '101'), 
('29', '2018-12-06', 'SEROLOGY', 'Anti HCV_SEROLOGY', 'Anti HCV', '0', '0.00', '101'), 
('30', '2018-12-06', 'SEROLOGY', 'HIV_SEROLOGY', 'HIV', '0', '0.00', '101'), 
('31', '2018-12-06', 'SEROLOGY', 'CRP_SEROLOGY', 'CRP', '650', '0.00', '201'), 
('32', '2018-12-06', 'SEROLOGY', 'CFT For Failaria_SEROLOGY', 'CFT For Failaria', '0', '0.00', '101'), 
('33', '2018-12-06', 'HORMON', 'T3.T4.TSH_HORMON', 'T3.T4.TSH', '0', '0.00', '101'), 
('34', '2018-12-06', 'HORMON', 'S. Prolacten_HORMON', 'S. Prolacten', '0', '0.00', '101'), 
('35', '2018-12-06', 'URINE', 'R/E M/E_URINE', 'R/E M/E', '150', '0.00', '201'), 
('36', '2018-12-06', 'URINE', 'Pregnancy Test_URINE', 'Pregnancy Test', '150', '0.00', '201'), 
('37', '2018-12-06', 'STOOL', 'R/E M/E O BT_STOOL', 'R/E M/E O BT', '250', '0.00', '201'), 
('38', '2018-12-06', 'STOOL', 'Reducing Substasnces_STOOL', 'Reducing Substasnces', '0', '0.00', '101'), 
('39', '2018-12-06', 'STOOL', 'Others_STOOL', 'Others', '0', '0.00', '101'), 
('40', '2018-12-06', 'DIGITAL X-RAY', 'Chest P/A View_DIGITAL X-RAY', 'Chest P/A View', '250', '0.00', '204'), 
('41', '2018-12-06', 'DIGITAL X-RAY', 'Ba-Meal-Stomach & Duodenum_DIGITAL X-RAY', 'Ba-Meal-Stomach & Duodenum', '0', '0.00', '101'), 
('42', '2018-12-06', 'DIGITAL X-RAY', 'Ba-Swallow Oesophagus_DIGITAL X-RAY', 'Ba-Swallow Oesophagus', '0', '0.00', '101'), 
('43', '2018-12-06', 'DIGITAL X-RAY', 'K.U.B_DIGITAL X-RAY', 'K.U.B', '0', '0.00', '101'), 
('44', '2018-12-06', 'DIGITAL X-RAY', 'Skull B V / P.N.S_DIGITAL X-RAY', 'Skull B V / P.N.S', '250', '0.00', '204'), 
('45', '2018-12-06', 'DIGITAL X-RAY', 'Plain X-Ray Abdomen / C.P.D_DIGITAL X-RAY', 'Plain X-Ray Abdomen / C.P.D', '0', '0.00', '101'), 
('46', '2018-12-06', 'DIGITAL X-RAY', 'Cervical Spine B.V_DIGITAL X-RAY', 'Cervical Spine B.V', '500', '0.00', '204'), 
('47', '2018-12-06', 'DIGITAL X-RAY', 'Lumbo-Sacral B.V_DIGITAL X-RAY', 'Lumbo-Sacral B.V', '500', '0.00', '204'), 
('48', '2018-12-06', 'DIGITAL X-RAY', 'L/S_A/P_DIGITAL X-RAY', 'L/S_A/P', '250', '0.00', '204'), 
('59', '2018-12-06', 'OTHERS', 'Semen Analysis_OTHERS', 'Semen Analysis', '0', '0.00', '101'), 
('60', '2018-12-06', 'OTHERS', 'MT Tuberculin Test_OTHERS', 'MT Tuberculin Test', '350', '0.00', '201'), 
('61', '2018-12-06', 'OTHERS', 'Haxagon T.B_OTHERS', 'Haxagon T.B', '0', '0.00', '101'), 
('62', '2018-12-06', 'OTHERS', 'IGE T.B_OTHERS', 'IGE T.B', '0', '0.00', '101'), 
('63', '2018-12-06', 'OTHERS', 'IGG T.B_OTHERS', 'IGG T.B', '0', '0.00', '101'), 
('64', '2018-12-06', 'OTHERS', 'IGM T.B_OTHERS', 'IGM T.B', '0', '0.00', '101'), 
('65', '2018-12-06', 'OTHERS', 'H.V.S. G/S_OTHERS', 'H.V.S. G/S', '0', '0.00', '101'), 
('66', '2018-12-06', 'OTHERS', 'P/S G/S_OTHERS', 'P/S G/S', '0', '0.00', '101'), 
('67', '2018-12-06', 'OTHERS', 'Sputem For A.F.B_OTHERS', 'Sputem For A.F.B', '0', '0.00', '101'), 
('69', '2019-06-23', 'URINE', 'R/E M/E_URINE', 'R/E M/E', '150', '0.00', '201'), 
('70', '2020-06-20', 'HAEMATOLOGY', 'CBC_HAEMATOLOGY', 'CBC', '400', '1.00', '1'), 
('71', '2020-06-21', 'URINE', 'R/E M/E_URINE', 'R/E M/E', '150', '150.00', '01'), 
('72', '2020-06-21', 'HAEMATOLOGY', 'CBC_HAEMATOLOGY', 'CBC', '400', '0.00', '201'), 
('73', '2020-06-22', 'BIOCHEMISTRY', 'S.Protin_BIOCHEMISTRY', 'S.Protin', '300', '200.00', '205'), 
('74', '2020-06-22', 'BIOCHEMISTRY', 'S.G.O.T.(AST)_BIOCHEMISTRY', 'S.G.O.T.(AST)', '400', '0.00', '201'), 
('75', '2020-06-22', 'BIOCHEMISTRY', 'S. Creatinine_BIOCHEMISTRY', 'S. Creatinine', '400', '50.00', '102'), 
('79', '2020-06-30', 'BIOCHEMISTRY', 'Sugar_2_HABF_BIOCHEMISTRY', 'Sugar_2_HABF', '150', '0.00', '201'), 
('80', '2020-06-30', 'BIOCHEMISTRY', 'R.Sugar_BIOCHEMISTRY', 'R.Sugar', '150', '0.00', '201'), 
('81', '2020-06-30', 'BIOCHEMISTRY', 'F.Sugar_BIOCHEMISTRY', 'F.Sugar', '150', '0.00', '201'), 
('82', '2020-06-30', 'URINE', 'R/E M/E_URINE', 'R/E M/E', '150', '0.00', '201'), 
('83', '2020-06-30', 'URINE', 'Pregnancy Test_URINE', 'Pregnancy Test', '150', '0.00', '201'), 
('84', '2020-06-30', 'URINE', 'CUS_URINE', 'CUS', '150', '0.00', '201'), 
('85', '2020-06-30', 'SEROLOGY', 'Blood For Grouping_SEROLOGY', 'Blood For Grouping', '150', '0.00', '201'), 
('86', '2020-06-30', 'BIOCHEMISTRY', 'S. Creatinine_BIOCHEMISTRY', 'S. Creatinine', '400', '0.00', '201'), 
('87', '2020-06-30', 'BIOCHEMISTRY', 'S.G.P.T.(ALT)_BIOCHEMISTRY', 'S.G.P.T.(ALT)', '400', '0.00', '201'), 
('88', '2020-06-30', 'BIOCHEMISTRY', 'S.G.O.T.(AST)_BIOCHEMISTRY', 'S.G.O.T.(AST)', '400', '0.00', '201'), 
('89', '2020-06-30', 'BIOCHEMISTRY', 'S.Cholesterol_BIOCHEMISTRY', 'S.Cholesterol', '650', '0.00', '201'), 
('90', '2020-06-30', 'BIOCHEMISTRY', 'Lipid Profile_BIOCHEMISTRY', 'Lipid Profile', '1200', '0.00', '201'), 
('91', '2020-06-30', 'BIOCHEMISTRY', 'S Uric Acid_BIOCHEMISTRY', 'S Uric Acid', '650', '0.00', '201'), 
('92', '2020-06-30', 'SEROLOGY', 'Widal Test_SEROLOGY', 'Widal Test', '400', '0.00', '201'), 
('93', '2020-06-30', 'SEROLOGY', 'A.S.O Titre_SEROLOGY', 'A.S.O Titre', '400', '0.00', '201'), 
('94', '2020-06-30', 'SEROLOGY', 'R/A Test_SEROLOGY', 'R/A Test', '400', '0.00', '201'), 
('95', '2020-06-30', 'SEROLOGY', 'CRP_SEROLOGY', 'CRP', '650', '0.00', '201'), 
('96', '2020-06-30', 'SEROLOGY', 'V.D.R.L_SEROLOGY', 'V.D.R.L', '400', '0.00', '201'), 
('97', '2020-06-30', 'SEROLOGY', 'TPHA_SEROLOGY', 'TPHA', '400', '0.00', '201'), 
('98', '2020-06-30', 'OTHERS', 'MT Tuberculin Test_OTHERS', 'MT Tuberculin Test', '400', '0.00', '201'), 
('99', '2020-06-30', 'BIOCHEMISTRY', 'S. Bilirubin_BIOCHEMISTRY', 'S. Bilirubin', '250', '0.00', '201'), 
('100', '2020-06-30', 'SEROLOGY', 'Hbs Ag_SEROLOGY', 'Hbs Ag', '400', '0.00', '201'), 
('101', '2020-06-30', 'URINE', 'R/E M/E_URINE', 'R/E M/E', '150', '0.00', '201'), 
('102', '2020-06-30', 'URINE', 'Pregnancy Test_URINE', 'Pregnancy Test', '150', '0.00', '201'), 
('103', '2020-06-30', 'URINE', 'CUS_URINE', 'CUS', '150', '0.00', '201'), 
('104', '2020-06-30', 'STOOL', 'R/E M/E O BT_STOOL', 'R/E M/E O BT', '250', '0.00', '201'), 
('105', '2020-06-30', 'HAEMATOLOGY', 'CBC_HAEMATOLOGY', 'CBC', '450', '0.00', '201'), 
('106', '2020-06-30', 'DIGITAL X-RAY', 'Chest P/A View_DIGITAL X-RAY', 'Chest P/A View', '250', '0.00', '204'), 
('107', '2020-06-30', 'DIGITAL X-RAY', 'K.U.B_DIGITAL X-RAY', 'K.U.B', '250', '0.00', '204'), 
('108', '2020-06-30', 'DIGITAL X-RAY', 'Ba-Meal-Stomach & Duodenum_DIGITAL X-RAY', 'Ba-Meal-Stomach & Duodenum', '250', '0.00', '204'), 
('109', '2020-06-30', 'DIGITAL X-RAY', 'Ba-Swallow Oesophagus_DIGITAL X-RAY', 'Ba-Swallow Oesophagus', '250', '0.00', '204'), 
('110', '2020-06-30', 'DIGITAL X-RAY', 'K.U.B_DIGITAL X-RAY', 'K.U.B', '250', '0.00', '204'), 
('111', '2020-06-30', 'DIGITAL X-RAY', 'Skull B V / P.N.S_DIGITAL X-RAY', 'Skull B V / P.N.S', '250', '0.00', '204'), 
('112', '2020-06-30', 'DIGITAL X-RAY', 'Plain X-Ray Abdomen / C.P.D_DIGITAL X-RAY', 'Plain X-Ray Abdomen / C.P.D', '250', '0.00', '204'), 
('113', '2020-06-30', 'DIGITAL X-RAY', 'Cervical Spine B.V_DIGITAL X-RAY', 'Cervical Spine B.V', '250', '0.00', '204'), 
('114', '2020-06-30', 'DIGITAL X-RAY', 'Lumbo-Sacral B.V_DIGITAL X-RAY', 'Lumbo-Sacral B.V', '500', '0.00', '204'), 
('115', '2020-06-30', 'DIGITAL X-RAY', 'Others_DIGITAL X-RAY', 'Others', '250', '0.00', '204'), 
('116', '2020-06-30', 'DIGITAL X-RAY', 'K.U.B_DIGITAL X-RAY', 'K.U.B', '250', '0.00', '204'), 
('117', '2020-06-30', 'USG_ULTRASONOGRAPHY', 'PREGNANCY_PROFILE_USG_ULTRASONOGRAPHY', 'PREGNANCY_PROFILE', '650', '0.00', '202'), 
('118', '2020-07-02', 'SEROLOGY', 'Hbs Ag_SEROLOGY', 'Hbs Ag', '400', '0.00', '201'), 
('119', '2020-07-02', 'SEROLOGY', 'Hbe Ag_SEROLOGY', 'Hbe Ag', '400', '0.00', '201'), 
('120', '2020-07-02', 'HAEMATOLOGY', 'ESR_HAEMATOLOGY', 'ESR', '150', '0.00', '201'), 
('121', '2020-07-02', 'HAEMATOLOGY', 'Hb%_HAEMATOLOGY', 'Hb%', '150', '0.00', '201'), 
('122', '2020-07-02', 'BIOCHEMISTRY', 'R.Sugar_BIOCHEMISTRY', 'R.Sugar', '150', '0.00', '201'), 
('123', '2020-07-02', 'BIOCHEMISTRY', 'RBS_BIOCHEMISTRY', 'RBS', '150', '0.00', '201'), 
('124', '2020-07-02', 'BIOCHEMISTRY', 'F.Sugar_BIOCHEMISTRY', 'F.Sugar', '150', '0.00', '201'), 
('125', '2020-07-02', 'DANTAL_X-RAY', 'DANTAL_X-RAY_DANTAL_X-RAY', 'DANTAL_X-RAY', '150', '0.00', '204'), 
('126', '2020-07-02', 'BIOCHEMISTRY', 'S. Bilirubin_BIOCHEMISTRY', 'S. Bilirubin', '250', '0.00', '201'), 
('127', '2020-07-02', 'DIGITAL X-RAY', 'KNEE_JOIBT_B/V_FOOT_B/V_DIGITAL X-RAY', 'KNEE_JOIBT_B/V_FOOT_B/V', '250', '0.00', '204'), 
('128', '2020-07-02', 'DIGITAL X-RAY', 'Skull B V / P.N.S_DIGITAL X-RAY', 'Skull B V / P.N.S', '250', '0.00', '204'), 
('129', '2020-07-03', 'ECG', 'ECG_ECG', 'ECG', '250', '0.00', '202'), 
('130', '2020-07-05', 'BIOCHEMISTRY', 'F.SUGAR_/_SUGAR_2HABF__BIOCHEMISTRY', 'F.SUGAR_/_SUGAR_2HABF_', '300', '0.00', '201'), 
('131', '2020-07-05', 'URINE_R./E', 'URINE_R_/_E_URINE_R./E', 'URINE_R_/_E', '150', '0.00', '201'), 
('132', '2020-07-06', 'U_S_G____W_/_A', 'U_S_G__W_/_A_U_S_G____W_/_A', 'U_S_G__W_/_A', '650', '0.00', '202'), 
('133', '2020-07-06', 'U_S_G_', 'W_/_A_U_S_G_', 'W_/_A', '750', '0.00', '202'), 
('134', '2020-07-06', 'U_S_G____W_/_A', 'U_S_G__W_/_A_U_S_G____W_/_A', 'U_S_G__W_/_A', '750', '0.00', '202'), 
('135', '2020-07-06', 'HAEMATOLOGY', '	Hb%_/ESR_HAEMATOLOGY', '	Hb%_/ESR', '300', '0.00', '201'), 
('137', '2020-07-06', 'HAEMATOLOGY', '	Hb%_/ESR_HAEMATOLOGY', '	Hb%_/ESR', '300', '0.00', '201'), 
('138', '2020-07-06', 'HAEMATOLOGY', 'Hb%_/ESR_HAEMATOLOGY', 'Hb%_/ESR', '300', '0.00', '201'), 
('139', '2020-07-06', 'HAEMATOLOGY', 'Hb%_/ESR_HAEMATOLOGY', 'Hb%_/ESR', '300', '0.00', '201'), 
('140', '2020-07-06', 'USG_COLOUR', 'USG_F_/C_USG_COLOUR', 'USG_F_/C', '850', '0.00', '202'), 
('141', '2020-07-07', 'SEROLOGY', 'TPHA_SEROLOGY', 'TPHA', '400', '0.00', '201'), 
('142', '2020-07-07', 'SEROLOGY', 'TPHA_SEROLOGY', 'TPHA', '400', '0.00', '201'), 
('143', '2020-07-07', 'SEROLOGY', 'TPHA_SEROLOGY', 'TPHA', '400', '0.00', '201'), 
('144', '2020-07-07', 'SEROLOGY', 'TPHA__T_SEROLOGY', 'TPHA__T', '400', '0.00', '201'), 
('145', '2020-07-07', 'BIOCHEMISTRY', 'S.__ELECROLYTES_BIOCHEMISTRY', 'S.__ELECROLYTES', '850', '0.00', '201'), 
('146', '2020-07-07', 'HORMON', 'S.TSH_HORMON', 'S.TSH', '800', '0.00', '201'), 
('147', '2020-07-07', 'HORMON', 'TSH_HORMON', 'TSH', '800', '0.00', '201'), 
('148', '2020-07-08', 'DIGITAL X-RAY', 'SOFT_TISSUC_NECK_DIGITAL X-RAY', 'SOFT_TISSUC_NECK', '250', '0.00', '204'), 
('149', '2020-07-08', 'SEROLOGY', 'Blood For Grouping_SEROLOGY', 'Blood For Grouping', '150', '0.00', '201'), 
('150', '2020-07-10', 'M.T_MAN_TOUX)', 'M.T_MAN_TOUX)_M.T_MAN_TOUX)', 'M.T_MAN_TOUX)', '400', '0.00', '201'), 
('151', '2020-07-12', 'DIGITAL X-RAY', 'X-RAY_LEFT_LEG_B/V_DIGITAL X-RAY', 'X-RAY_LEFT_LEG_B/V', '250', '0.00', '204'), 
('152', '2020-07-14', 'Test', 'Test_Test', 'Test', '200', '190.00', '2010'), 
('153', '2020-07-14', 'USG_COLOUR', 'USG_F_/C_USG_COLOUR', 'USG_F_/C', '850', '0.00', '202'), 
('154', '2020-07-14', 'USG_COLOUR', 'L/A_USG_COLOUR', 'L/A', '850', '0.00', '202'), 
('155', '2020-07-14', 'USG_COLOUR', 'W/A_USG_COLOUR', 'W/A', '850', '0.00', '250'), 
('156', '2020-07-14', 'USG_COLOUR', 'KUB_USG_COLOUR', 'KUB', '850', '0.00', '202'), 
('159', '2020-07-16', 'DIGITAL X-RAY', 'Others_DIGITAL X-RAY', 'Others', '250', '0.00', '204'), 
('160', '2020-07-16', 'DIGITAL X-RAY', 'X-RAY_LEFT_LEG_B/V_DIGITAL X-RAY', 'X-RAY_LEFT_LEG_B/V', '250', '0.00', '204'), 
('161', '2020-07-19', 'BIOCHEMISTRY', '2Hour After 75 Gram, Glucose_BIOCHEMISTRY', '2Hour After 75 Gram, Glucose', '300', '0.00', '201'), 
('162', '2020-07-21', 'DIGITAL X-RAY', 'Lumbo-Sacral B.V_DIGITAL X-RAY', 'Lumbo-Sacral B.V', '550', '0.00', '204'), 
('163', '2020-07-22', 'IMONULOGY', 'TROPONIN__IMONULOGY', 'TROPONIN_', '1000', '0.00', '201'), 
('164', '2020-07-23', 'DIGITAL X-RAY', 'Left_Foot_B/V_DIGITAL X-RAY', 'Left_Foot_B/V', '250', '0.00', '204'), 
('165', '2020-07-24', 'DIGITAL X-RAY', 'Lumbo_Sacral_B/V_DIGITAL X-RAY', 'Lumbo_Sacral_B/V', '500', '0.00', '204'), 
('166', '2020-07-24', 'DIGITAL X-RAY', '_SERVICAL_SPINE_B/VIEW_DIGITAL X-RAY', '_SERVICAL_SPINE_B/VIEW', '250', '0.00', '204'), 
('167', '2020-07-24', 'DIGITAL X-RAY', 'X-RAY_DIGITAL X-RAY', 'X-RAY', '250', '0.00', '204'), 
('168', '2020-07-24', 'DIGITAL X-RAY', 'X-RAY_DIGITAL X-RAY', 'X-RAY', '500', '0.00', '204'), 
('169', '2020-07-24', 'DIGITAL X-RAY', 'PELVIS_A/P_DIGITAL X-RAY', 'PELVIS_A/P', '250', '0.00', '204'), 
('170', '2020-07-25', 'BIOCHEMISTRY', 'HBA.1C_BIOCHEMISTRY', 'HBA.1C', '850', '0.00', '201'), 
('171', '2020-08-03', 'SEROLOGY', 'S.__IGE_SEROLOGY', 'S.__IGE', '1000', '0.00', '201'), 
('172', '2020-08-03', 'SEROLOGY', 'S.IGE_SEROLOGY', 'S.IGE', '1000', '0.00', '201'), 
('173', '2020-08-05', 'DIGITAL X-RAY', 'DIGITAL__X-RAY_____EXPRESS_DIGITAL X-RAY', 'DIGITAL__X-RAY_____EXPRESS', '400', '0.00', ' AL-KIDMA'), 
('174', '2020-08-05', 'DIGITAL_X-RAY_EXPRESS', 'DIGITAL_X-RAY_EXPRESS_DIGITAL_X-RAY_EXPRESS', 'DIGITAL_X-RAY_EXPRESS', '400', '0.00', '204'), 
('175', '2020-08-06', 'HORMON', 'S.TSH-1000_HORMON', 'S.TSH-1000', '1000', '0.00', '201'), 
('176', '2020-08-06', 'HORMON', 'FT4_HORMON', 'FT4', '800', '0.00', '201'), 
('177', '2020-08-07', 'DIGITAL X-RAY', 'X-RAY-_ABDOMEN_A/P_DIGITAL X-RAY', 'X-RAY-_ABDOMEN_A/P', '250', '0.00', '204'), 
('178', '2020-08-08', 'DIGITAL X-RAY', 'XRAY-LEFT_FOOT_B/V_DIGITAL X-RAY', 'XRAY-LEFT_FOOT_B/V', '250', '0.00', '204'), 
('179', '2020-08-19', 'HAEMATOLOGY', 'CBC_HAEMATOLOGY', 'CBC', '400', '0.00', '201'), 
('180', '2020-08-19', 'HAEMATOLOGY', 'ESR_HAEMATOLOGY', 'ESR', '150', '0.00', '201'), 
('181', '2020-08-19', 'HAEMATOLOGY', 'Hb%_HAEMATOLOGY', 'Hb%', '150', '0.00', '201'), 
('182', '2020-08-20', 'DIGITAL X-RAY', 'Chest_L/A_View_DIGITAL X-RAY', 'Chest_L/A_View', '250', '0.00', '204'), 
('183', '2020-08-31', 'Digital_Ultrasonography', 'KUB_Digital_Ultrasonography', 'KUB', '850', '0.00', '202'), 
('184', '2020-08-31', 'Digital_Ultrasonography', 'W/A_Digital_Ultrasonography', 'W/A', '850', '0.00', '202'), 
('185', '2020-08-31', 'Digital_Ultrasonography', 'P/P_Digital_Ultrasonography', 'P/P', '850', '0.00', '202'), 
('186', '2020-08-31', 'Digital_Ultrasonography', 'KUB_Digital_Ultrasonography', 'KUB', '850', '0.00', '202'), 
('187', '2020-08-31', 'Digital_Ultrasonography', 'L/A_Digital_Ultrasonography', 'L/A', '', '850.00', '202'), 
('188', '2020-08-31', 'Digital_Ultrasonography', 'L/A_Digital_Ultrasonography', 'L/A', '850', '0.00', '202'), 
('189', '2020-08-31', '_Ultrasonography', 'W/A__Ultrasonography', 'W/A', '650', '0.00', '202'), 
('190', '2020-08-31', '_Ultrasonography', 'L/A__Ultrasonography', 'L/A', '650', '0.00', '202'), 
('191', '2020-08-31', '_Ultrasonography', 'KUB__Ultrasonography', 'KUB', '650', '0.00', '202'), 
('192', '2020-08-31', '_Ultrasonography', 'P/P__Ultrasonography', 'P/P', '650', '0.00', '202'), 
('193', '2020-08-31', '_Ultrasonography', 'F/C__Ultrasonography', 'F/C', '650', '0.00', '202'), 
('194', '2020-08-31', '_Ultrasonography', 'W/A__Ultrasonography', 'W/A', '650', '0.00', '202'), 
('195', '2020-08-31', '_Ultrasonography', 'W/A__Ultrasonography', 'W/A', '750', '0.00', '202'), 
('196', '2020-08-31', '_Ultrasonography', 'P/P__Ultrasonography', 'P/P', '650', '0.00', '202'), 
('197', '2020-08-31', '_Ultrasonography', 'F/C__Ultrasonography', 'F/C', '650', '0.00', '202'), 
('198', '2020-08-31', 'Digital_Ultrasonography', 'F/C_Digital_Ultrasonography', 'F/C', '850', '0.00', '202'), 
('199', '2020-08-31', '_Ultrasonography', 'KUB__Ultrasonography', 'KUB', '650', '0.00', '202'), 
('200', '2020-09-01', 'BIOCHEMISTRY', 'HBA.1C_BIOCHEMISTRY', 'HBA.1C', '1000', '0.00', '201'), 
('201', '2020-09-02', '_Ultrasonography', 'L/A__Ultrasonography', 'L/A', '650', '0.00', '202'), 
('202', '2020-09-02', '_Ultrasonography', 'L/A__Ultrasonography', 'L/A', '650', '0.00', '202');  



INSERT INTO `journal` ( `id`, `date`, `ref`, `details`, `amount`, `status`) VALUES 
('1', '2018-08-08', 'doctors:', 'commission', '0.00', 'cost'), 
('2', '2018-08-09', 'pid:00001', 'diagnosis', '100.00', 'income'), 
('3', '2018-08-11', 'pid:00001', 'diagnosis', '6000.00', 'income'), 
('4', '2018-08-11', 'pid:00002', 'diagnosis', '100.00', 'income'), 
('5', '2018-08-13', 'pid:00003', 'diagnosis', '6000.00', 'income'), 
('6', '2018-08-13', 'pid:00004', 'diagnosis', '75.00', 'income'), 
('7', '2018-09-04', 'pid:00005', 'diagnosis', '2000.00', 'income'), 
('8', '2018-12-18', 'pid:00006', 'diagnosis', '1500.00', 'income'), 
('9', '2018-12-25', '', 'consultancy', '0.00', 'income'), 
('10', '2018-12-25', '', 'consultancy', '0.00', 'income'), 
('11', '2018-12-25', '', 'consultancy', '0.00', 'income'), 
('12', '2019-06-23', 'pid:00007', 'diagnosis', '0.00', 'income'), 
('13', '2020-06-16', 'doctors:', 'commission', '15000.00', 'cost'), 
('14', '2020-06-16', 'doctors:', 'commission', '14000.00', 'cost'), 
('15', '2020-06-16', 'doctors:', 'commission', '7.00', 'cost'), 
('16', '2020-06-16', 'doctors:', 'commission', '0.00', 'cost'), 
('17', '2020-06-16', '', 'consultancy', '0.00', 'income'), 
('18', '2020-06-16', 'pid:00008', 'diagnosis', '0.00', 'income'), 
('19', '2020-06-20', 'pid:00009', 'diagnosis', '0.00', 'income'), 
('20', '2020-06-22', '', 'consultancy', '1000.00', 'income'), 
('21', '2020-06-22', 'pid:00010', 'diagnosis', '500.00', 'income'), 
('22', '2020-06-22', '', 'consultancy', '0.00', 'income'), 
('23', '2020-06-22', '', 'consultancy', '0.00', 'income'), 
('24', '2020-06-22', '', 'consultancy', '0.00', 'income'), 
('25', '2020-06-22', 'pid:00011', 'diagnosis', '1035.00', 'income'), 
('26', '2020-06-22', 'pid:00012', 'diagnosis', '500.00', 'income'), 
('27', '2020-06-22', 'pid:00013', 'diagnosis', '500.00', 'income'), 
('28', '2020-06-22', 'pid:00014', 'diagnosis', '0.00', 'income'), 
('29', '2020-06-22', 'pid:00015', 'diagnosis', '0.00', 'income'), 
('30', '2020-06-22', 'pid:00016', 'diagnosis', '1000.00', 'income'), 
('31', '2020-06-22', '', 'consultancy', '1000.00', 'income'), 
('32', '2020-06-22', '', 'consultancy', '0.00', 'income'), 
('33', '2020-06-22', '', 'consultancy', '1200.00', 'income'), 
('34', '2020-06-22', '', 'consultancy', '0.00', 'income'), 
('35', '2020-06-22', '', 'consultancy', '300.00', 'income'), 
('36', '2020-06-23', '', 'consultancy', '0.00', 'income'), 
('37', '2020-06-23', '', 'consultancy', '0.00', 'income'), 
('38', '2020-06-23', 'pid:00017', 'diagnosis', '0.00', 'income'), 
('39', '2020-06-23', '', 'consultancy', '0.00', 'income'), 
('40', '2020-06-23', '', 'consultancy', '0.00', 'income'), 
('41', '2020-06-23', '', 'consultancy', '500.00', 'income'), 
('42', '2020-06-23', '', 'consultancy', '500.00', 'income'), 
('43', '2020-06-23', '', 'consultancy', '500.00', 'income'), 
('44', '2020-06-23', '', 'consultancy', '400.00', 'income'), 
('45', '2020-06-23', '', 'consultancy', '800.00', 'income'), 
('46', '2020-06-23', '', 'consultancy', '0.00', 'income'), 
('47', '2020-06-23', 'pid:00001', 'diagnosis', '600.00', 'income'), 
('48', '2020-06-24', 'pid:00003', 'diagnosis', '100.00', 'income'), 
('49', '2020-06-24', 'pid:00004', 'diagnosis', '1.00', 'income'), 
('50', '2020-06-24', 'pid:00001', 'diagnosis', '1.00', 'income'), 
('51', '2020-06-24', 'pid:00001', 'diagnosis', '1.00', 'income'), 
('52', '2020-06-24', 'pid:00002', 'diagnosis', '1.00', 'income'), 
('53', '2020-06-24', 'pid:00003', 'diagnosis', '1.00', 'income'), 
('54', '2020-06-24', '', 'consultancy', '400.00', 'income'), 
('55', '2020-06-24', '', 'consultancy', '400.00', 'income'), 
('56', '2020-06-24', '', 'consultancy', '400.00', 'income'), 
('57', '2020-06-24', '', 'consultancy', '300.00', 'income'), 
('58', '2020-06-24', '', 'consultancy', '600.00', 'income'), 
('59', '2020-06-24', 'pid:00004', 'diagnosis', '360.00', 'income'), 
('60', '2020-06-25', 'pid:00005', 'diagnosis', '1000.00', 'income'), 
('61', '2020-06-29', '', 'consultancy', '600.00', 'income'), 
('62', '2020-06-30', 'pid:00006', 'diagnosis', '50.00', 'income'), 
('63', '2020-06-30', 'pid:00007', 'diagnosis', '400.00', 'income'), 
('64', '2020-06-30', '', 'consultancy', '300.00', 'income'), 
('65', '2020-06-30', '', 'consultancy', '300.00', 'income'), 
('66', '2020-06-30', '', 'consultancy', '300.00', 'income'), 
('67', '2020-07-02', 'pid:00008', 'diagnosis', '400.00', 'income'), 
('68', '2020-07-02', '', 'consultancy', '200.00', 'income'), 
('69', '2020-07-02', 'pid:00009', 'diagnosis', '200.00', 'income'), 
('70', '2020-07-02', '', 'consultancy', '300.00', 'income'), 
('71', '2020-07-02', '', 'consultancy', '50.00', 'income'), 
('72', '2020-07-02', 'pid:00010', 'diagnosis', '1700.00', 'income'), 
('73', '2020-07-02', 'pid:00011', 'diagnosis', '400.00', 'income'), 
('74', '2020-07-02', 'pid:00012', 'diagnosis', '600.00', 'income'), 
('75', '2020-07-02', 'pid:00013', 'diagnosis', '250.00', 'income'), 
('76', '2020-07-02', 'pid:00014', 'diagnosis', '150.00', 'income'), 
('77', '2020-07-02', 'pid:00015', 'diagnosis', '250.00', 'income'), 
('78', '2020-07-02', 'pid:00016', 'diagnosis', '350.00', 'income'), 
('79', '2020-07-02', 'pid:00017', 'diagnosis', '450.00', 'income'), 
('80', '2020-07-02', 'pid:00018', 'diagnosis', '250.00', 'income'), 
('81', '2020-07-02', 'pid:00019', 'diagnosis', '500.00', 'income'), 
('82', '2020-07-02', 'pid:00020', 'diagnosis', '550.00', 'income'), 
('83', '2020-07-02', 'pid:00021', 'diagnosis', '250.00', 'income'), 
('84', '2020-07-03', 'pid:00022', 'diagnosis', '300.00', 'income'), 
('85', '2020-07-03', 'pid:00023', 'diagnosis', '300.00', 'income'), 
('86', '2020-07-03', 'pid:00024', 'diagnosis', '1000.00', 'income'), 
('87', '2020-07-03', 'pid:00025', 'diagnosis', '1200.00', 'income'), 
('88', '2020-07-03', 'pid:00026', 'diagnosis', '1100.00', 'income'), 
('89', '2020-07-03', 'pid:00027', 'diagnosis', '200.00', 'income'), 
('90', '2020-07-03', 'pid:00028', 'diagnosis', '400.00', 'income'), 
('91', '2020-07-03', 'pid:00029', 'diagnosis', '1200.00', 'income'), 
('92', '2020-07-03', 'pid:00030', 'diagnosis', '300.00', 'income'), 
('93', '2020-07-03', 'pid:00031', 'diagnosis', '250.00', 'income'), 
('94', '2020-07-03', 'pid:00032', 'diagnosis', '400.00', 'income'), 
('95', '2020-07-03', 'pid:00033', 'diagnosis', '1200.00', 'income'), 
('96', '2020-07-03', 'pid:00034', 'diagnosis', '200.00', 'income'), 
('97', '2020-07-05', 'pid:00035', 'diagnosis', '120.00', 'income'), 
('98', '2020-07-05', 'pid:00036', 'diagnosis', '50.00', 'income'), 
('99', '2020-07-05', 'pid:00037', 'diagnosis', '220.00', 'income'), 
('100', '2020-07-05', 'pid:00038', 'diagnosis', '100.00', 'income'), 
('101', '2020-07-05', 'pid:00039', 'diagnosis', '400.00', 'income'), 
('102', '2020-07-05', 'pid:00040', 'diagnosis', '400.00', 'income'), 
('103', '2020-07-05', 'pid:00041', 'diagnosis', '150.00', 'income'), 
('104', '2020-07-05', 'pid:00042', 'diagnosis', '1900.00', 'income'), 
('105', '2020-07-05', 'pid:00043', 'diagnosis', '100.00', 'income'), 
('106', '2020-07-05', 'pid:00044', 'diagnosis', '250.00', 'income'), 
('107', '2020-07-05', 'pid:00045', 'diagnosis', '1500.00', 'income'), 
('108', '2020-07-05', 'pid:00046', 'diagnosis', '100.00', 'income'), 
('109', '2020-07-05', 'pid:00047', 'diagnosis', '1100.00', 'income'), 
('110', '2020-07-05', 'pid:00048', 'diagnosis', '1100.00', 'income'), 
('111', '2020-07-05', 'pid:00049', 'diagnosis', '1000.00', 'income'), 
('112', '2020-07-05', 'pid:00050', 'diagnosis', '150.00', 'income'), 
('113', '2020-07-05', 'pid:00051', 'diagnosis', '600.00', 'income'), 
('114', '2020-07-05', 'pid:00052', 'diagnosis', '1100.00', 'income'), 
('115', '2020-07-05', 'pid:00053', 'diagnosis', '1500.00', 'income'), 
('116', '2020-07-05', 'pid:00054', 'diagnosis', '1100.00', 'income'), 
('117', '2020-07-06', 'pid:00055', 'diagnosis', '250.00', 'income'), 
('118', '2020-07-06', 'pid:00056', 'diagnosis', '350.00', 'income'), 
('119', '2020-07-06', 'pid:00057', 'diagnosis', '100.00', 'income'), 
('120', '2020-07-06', 'pid:00058', 'diagnosis', '150.00', 'income'), 
('121', '2020-07-06', 'pid:00059', 'diagnosis', '1500.00', 'income'), 
('122', '2020-07-06', 'pid:00060', 'diagnosis', '400.00', 'income'), 
('123', '2020-07-06', 'pid:00061', 'diagnosis', '350.00', 'income'), 
('124', '2020-07-06', 'pid:00062', 'diagnosis', '60.00', 'income'), 
('125', '2020-07-06', 'pid:00063', 'diagnosis', '500.00', 'income'), 
('126', '2020-07-06', 'pid:00064', 'diagnosis', '400.00', 'income'), 
('127', '2020-07-06', 'pid:00065', 'diagnosis', '1600.00', 'income'), 
('128', '2020-07-06', 'pid:00066', 'diagnosis', '600.00', 'income'), 
('129', '2020-07-06', 'pid:00067', 'diagnosis', '1600.00', 'income'), 
('130', '2020-07-06', 'pid:00068', 'diagnosis', '2700.00', 'income'), 
('131', '2020-07-06', 'pid:00069', 'diagnosis', '500.00', 'income'), 
('132', '2020-07-06', 'pid:00070', 'diagnosis', '400.00', 'income'), 
('133', '2020-07-06', 'pid:00071', 'diagnosis', '1100.00', 'income'), 
('134', '2020-07-06', 'pid:00072', 'diagnosis', '400.00', 'income'), 
('135', '2020-07-06', 'pid:00073', 'diagnosis', '400.00', 'income'), 
('136', '2020-07-06', 'pid:00074', 'diagnosis', '350.00', 'income'), 
('137', '2020-07-07', 'pid:00075', 'diagnosis', '100.00', 'income'), 
('138', '2020-07-07', 'pid:00076', 'diagnosis', '100.00', 'income'), 
('139', '2020-07-07', 'pid:00077', 'diagnosis', '150.00', 'income'), 
('140', '2020-07-07', 'pid:00078', 'diagnosis', '450.00', 'income'), 
('141', '2020-07-07', 'pid:00079', 'diagnosis', '100.00', 'income'), 
('142', '2020-07-07', 'pid:00079', 'diagnosis', '1100.00', 'income'), 
('143', '2020-07-07', 'pid:00080', 'diagnosis', '400.00', 'income'), 
('144', '2020-07-07', 'pid:00081', 'diagnosis', '400.00', 'income'), 
('145', '2020-07-07', 'pid:00082', 'diagnosis', '500.00', 'income'), 
('146', '2020-07-07', 'pid:00083', 'diagnosis', '1000.00', 'income'), 
('147', '2020-07-07', 'pid:00084', 'diagnosis', '1100.00', 'income'), 
('148', '2020-07-07', 'pid:00085', 'diagnosis', '1100.00', 'income'), 
('149', '2020-07-07', 'pid:00086', 'diagnosis', '1300.00', 'income'), 
('150', '2020-07-07', 'pid:00087', 'diagnosis', '400.00', 'income'), 
('151', '2020-07-07', 'pid:00088', 'diagnosis', '1500.00', 'income'), 
('152', '2020-07-07', 'pid:00089', 'diagnosis', '1300.00', 'income'), 
('153', '2020-07-07', 'pid:00090', 'diagnosis', '200.00', 'income'), 
('154', '2020-07-07', 'pid:00091', 'diagnosis', '1100.00', 'income'), 
('155', '2020-07-07', 'pid:00092', 'diagnosis', '300.00', 'income'), 
('156', '2020-07-07', 'pid:00093', 'diagnosis', '2000.00', 'income'), 
('157', '2020-07-07', 'pid:00094', 'diagnosis', '450.00', 'income'), 
('158', '2020-07-07', 'pid:00095', 'diagnosis', '650.00', 'income'), 
('159', '2020-07-07', 'pid:00096', 'diagnosis', '1100.00', 'income'), 
('160', '2020-07-08', 'pid:00097', 'diagnosis', '400.00', 'income'), 
('161', '2020-07-08', 'pid:00098', 'diagnosis', '100.00', 'income'), 
('162', '2020-07-08', 'pid:00099', 'diagnosis', '100.00', 'income'), 
('163', '2020-07-08', 'pid:00100', 'diagnosis', '100.00', 'income'), 
('164', '2020-07-08', 'pid:00101', 'diagnosis', '100.00', 'income'), 
('165', '2020-07-08', 'pid:00102', 'diagnosis', '800.00', 'income'), 
('166', '2020-07-08', 'pid:00103', 'diagnosis', '850.00', 'income'), 
('167', '2020-07-08', 'pid:00104', 'diagnosis', '50.00', 'income'), 
('168', '2020-07-08', 'pid:00105', 'diagnosis', '500.00', 'income'), 
('169', '2020-07-08', 'pid:00106', 'diagnosis', '100.00', 'income'), 
('170', '2020-07-08', 'pid:00107', 'diagnosis', '400.00', 'income'), 
('171', '2020-07-08', 'pid:00108', 'diagnosis', '250.00', 'income'), 
('172', '2020-07-08', 'pid:00109', 'diagnosis', '1100.00', 'income'), 
('173', '2020-07-08', 'pid:00110', 'diagnosis', '600.00', 'income'), 
('174', '2020-07-08', 'pid:00111', 'diagnosis', '400.00', 'income'), 
('175', '2020-07-08', 'pid:00112', 'diagnosis', '1200.00', 'income'), 
('176', '2020-07-08', 'pid:00113', 'diagnosis', '1100.00', 'income'), 
('177', '2020-07-08', 'pid:00114', 'diagnosis', '400.00', 'income'), 
('178', '2020-07-08', 'pid:00115', 'diagnosis', '500.00', 'income'), 
('179', '2020-07-08', 'pid:00116', 'diagnosis', '600.00', 'income'), 
('180', '2020-07-08', 'pid:00117', 'diagnosis', '100.00', 'income'), 
('181', '2020-07-08', 'pid:00118', 'diagnosis', '350.00', 'income'), 
('182', '2020-07-08', 'pid:00119', 'diagnosis', '500.00', 'income'), 
('183', '2020-07-08', 'pid:00120', 'diagnosis', '800.00', 'income'), 
('184', '2020-07-09', '', 'consultancy', '400.00', 'income'), 
('185', '2020-07-09', '', 'consultancy', '400.00', 'income'), 
('186', '2020-07-09', 'pid:00121', 'diagnosis', '700.00', 'income'), 
('187', '2020-07-09', 'pid:00122', 'diagnosis', '2000.00', 'income'), 
('188', '2020-07-09', 'pid:00123', 'diagnosis', '450.00', 'income'), 
('189', '2020-07-09', 'pid:00124', 'diagnosis', '1000.00', 'income'), 
('190', '2020-07-09', 'pid:00125', 'diagnosis', '400.00', 'income'), 
('191', '2020-07-09', 'pid:00126', 'diagnosis', '150.00', 'income'), 
('192', '2020-07-09', 'pid:', 'diagnosis', '850.00', 'income'), 
('193', '2020-07-09', 'pid:00127', 'diagnosis', '1250.00', 'income'), 
('194', '2020-07-09', 'pid:0133', 'diagnosis', '900.00', 'income'), 
('195', '2020-07-09', 'pid:00128', 'diagnosis', '600.00', 'income'), 
('196', '2020-07-09', 'pid:00129', 'diagnosis', '50.00', 'income'), 
('197', '2020-07-09', 'pid:00130', 'diagnosis', '50.00', 'income'), 
('198', '2020-07-09', 'pid:00131', 'diagnosis', '1000.00', 'income'), 
('199', '2020-07-10', 'pid:00132', 'diagnosis', '400.00', 'income'), 
('200', '2020-07-10', 'pid:00133', 'diagnosis', '200.00', 'income'), 
('201', '2020-07-10', 'pid:00134', 'diagnosis', '500.00', 'income'), 
('202', '2020-07-10', 'pid:00135', 'diagnosis', '500.00', 'income'), 
('203', '2020-07-10', 'pid:00136', 'diagnosis', '350.00', 'income'), 
('204', '2020-07-10', 'pid:00137', 'diagnosis', '500.00', 'income'), 
('205', '2020-07-10', 'pid:00138', 'diagnosis', '50.00', 'income'), 
('206', '2020-07-10', 'pid:00139', 'diagnosis', '50.00', 'income'), 
('207', '2020-07-10', 'pid:00140', 'diagnosis', '600.00', 'income'), 
('208', '2020-07-10', 'pid:00141', 'diagnosis', '1100.00', 'income'), 
('209', '2020-07-10', 'pid:00142', 'diagnosis', '300.00', 'income'), 
('210', '2020-07-10', 'pid:00143', 'diagnosis', '600.00', 'income'), 
('211', '2020-07-10', 'pid:00144', 'diagnosis', '200.00', 'income'), 
('212', '2020-07-10', 'pid:00145', 'diagnosis', '750.00', 'income'), 
('213', '2020-07-10', 'pid:00146', 'diagnosis', '100.00', 'income'), 
('214', '2020-07-10', 'pid:00147', 'diagnosis', '300.00', 'income'), 
('215', '2020-07-10', 'pid:00148', 'diagnosis', '1500.00', 'income'), 
('216', '2020-07-10', 'pid:00149', 'diagnosis', '400.00', 'income'), 
('217', '2020-07-10', 'pid:00150', 'diagnosis', '300.00', 'income'), 
('218', '2020-07-10', 'pid:00151', 'diagnosis', '1400.00', 'income'), 
('219', '2020-07-10', 'pid:00152', 'diagnosis', '500.00', 'income'), 
('220', '2020-07-10', 'pid:00153', 'diagnosis', '300.00', 'income'), 
('221', '2020-07-10', 'pid:00154', 'diagnosis', '250.00', 'income'), 
('222', '2020-07-10', 'pid:00155', 'diagnosis', '400.00', 'income'), 
('223', '2020-07-12', 'pid:00156', 'diagnosis', '50.00', 'income'), 
('224', '2020-07-12', 'pid:00157', 'diagnosis', '2200.00', 'income'), 
('225', '2020-07-12', 'pid:00158', 'diagnosis', '400.00', 'income'), 
('226', '2020-07-12', 'pid:00159', 'diagnosis', '220.00', 'income'), 
('227', '2020-07-12', 'pid:00160', 'diagnosis', '100.00', 'income'), 
('228', '2020-07-12', 'pid:00161', 'diagnosis', '250.00', 'income'), 
('229', '2020-07-12', 'pid:00162', 'diagnosis', '450.00', 'income'), 
('230', '2020-07-12', 'pid:00163', 'diagnosis', '1100.00', 'income'), 
('231', '2020-07-12', 'pid:00164', 'diagnosis', '600.00', 'income'), 
('232', '2020-07-12', 'pid:00165', 'diagnosis', '1400.00', 'income'), 
('233', '2020-07-12', 'pid:00166', 'diagnosis', '400.00', 'income'), 
('234', '2020-07-12', 'pid:00167', 'diagnosis', '100.00', 'income'), 
('235', '2020-07-12', 'pid:00168', 'diagnosis', '250.00', 'income'), 
('236', '2020-07-12', 'pid:00169', 'diagnosis', '200.00', 'income'), 
('237', '2020-07-12', 'pid:00170', 'diagnosis', '450.00', 'income'), 
('238', '2020-07-13', 'pid:00171', 'diagnosis', '100.00', 'income'), 
('239', '2020-07-13', 'pid:00172', 'diagnosis', '400.00', 'income'), 
('240', '2020-07-13', 'pid:00173', 'diagnosis', '400.00', 'income'), 
('241', '2020-07-13', 'pid:00174', 'diagnosis', '1400.00', 'income'), 
('242', '2020-07-13', 'pid:00175', 'diagnosis', '120.00', 'income'), 
('243', '2020-07-13', 'pid:00176', 'diagnosis', '1100.00', 'income'), 
('244', '2020-07-13', 'pid:00177', 'diagnosis', '50.00', 'income'), 
('245', '2020-07-13', 'pid:00178', 'diagnosis', '150.00', 'income'), 
('246', '2020-07-13', 'pid:00179', 'diagnosis', '400.00', 'income'), 
('247', '2020-07-13', 'pid:00180', 'diagnosis', '1200.00', 'income'), 
('248', '2020-07-13', 'pid:00181', 'diagnosis', '400.00', 'income'), 
('249', '2020-07-13', 'pid:00182', 'diagnosis', '50.00', 'income'), 
('250', '2020-07-13', 'pid:00183', 'diagnosis', '400.00', 'income'), 
('251', '2020-07-13', 'pid:00184', 'diagnosis', '250.00', 'income'), 
('252', '2020-07-13', 'pid:00185', 'diagnosis', '350.00', 'income'), 
('253', '2020-07-13', 'pid:00186', 'diagnosis', '1200.00', 'income'), 
('254', '2020-07-13', 'pid:00187', 'diagnosis', '60.00', 'income'), 
('255', '2020-07-13', 'pid:00188', 'diagnosis', '1100.00', 'income'), 
('256', '2020-07-13', 'pid:00189', 'diagnosis', '1500.00', 'income'), 
('257', '2020-07-13', 'pid:00190', 'diagnosis', '800.00', 'income'), 
('258', '2020-07-13', 'pid:00191', 'diagnosis', '500.00', 'income'), 
('259', '2020-07-13', 'pid:00192', 'diagnosis', '500.00', 'income'), 
('260', '2020-07-13', 'pid:00193', 'diagnosis', '200.00', 'income'), 
('261', '2020-07-13', 'pid:00194', 'diagnosis', '500.00', 'income'), 
('262', '2020-07-13', 'pid:00195', 'diagnosis', '800.00', 'income'), 
('263', '2020-07-13', 'pid:00196', 'diagnosis', '350.00', 'income'), 
('264', '2020-07-14', 'pid:00197', 'diagnosis', '1900.00', 'income'), 
('265', '2020-07-14', 'pid:00198', 'diagnosis', '100.00', 'income'), 
('266', '2020-07-14', 'pid:00199', 'diagnosis', '350.00', 'income'), 
('267', '2020-07-14', 'pid:00200', 'diagnosis', '350.00', 'income'), 
('268', '2020-07-14', 'pid:00201', 'diagnosis', '1700.00', 'income'), 
('269', '2020-07-14', 'pid:00202', 'diagnosis', '600.00', 'income'), 
('270', '2020-07-14', 'pid:00203', 'diagnosis', '300.00', 'income'), 
('271', '2020-07-14', 'pid:00204', 'diagnosis', '4500.00', 'income'), 
('272', '2020-07-14', 'pid:00205', 'diagnosis', '500.00', 'income'), 
('273', '2020-07-14', 'pid:00206', 'diagnosis', '1900.00', 'income'), 
('274', '2020-07-14', 'pid:00207', 'diagnosis', '800.00', 'income'), 
('275', '2020-07-14', 'pid:00208', 'diagnosis', '400.00', 'income'), 
('276', '2020-07-14', 'pid:00209', 'diagnosis', '400.00', 'income'), 
('277', '2020-07-14', 'pid:00210', 'diagnosis', '350.00', 'income'), 
('278', '2020-07-15', 'pid:00211', 'diagnosis', '900.00', 'income'), 
('279', '2020-07-15', 'pid:00212', 'diagnosis', '3150.00', 'income'), 
('280', '2020-07-15', 'pid:00213', 'diagnosis', '500.00', 'income'), 
('281', '2020-07-15', 'pid:00214', 'diagnosis', '100.00', 'income'), 
('282', '2020-07-15', 'pid:00215', 'diagnosis', '50.00', 'income'), 
('283', '2020-07-15', 'pid:00216', 'diagnosis', '80.00', 'income'), 
('284', '2020-07-15', 'pid:00217', 'diagnosis', '140.00', 'income'), 
('285', '2020-07-15', 'pid:00218', 'diagnosis', '450.00', 'income'), 
('286', '2020-07-15', 'pid:00219', 'diagnosis', '100.00', 'income'), 
('287', '2020-07-15', 'pid:00220', 'diagnosis', '600.00', 'income'), 
('288', '2020-07-15', 'pid:00221', 'diagnosis', '600.00', 'income'), 
('289', '2020-07-15', 'pid:00222', 'diagnosis', '1500.00', 'income'), 
('290', '2020-07-15', 'pid:00223', 'diagnosis', '350.00', 'income'), 
('291', '2020-07-16', 'pid:00224', 'diagnosis', '1100.00', 'income'), 
('292', '2020-07-16', 'pid:00225', 'diagnosis', '300.00', 'income'), 
('293', '2020-07-16', 'pid:00226', 'diagnosis', '80.00', 'income'), 
('294', '2020-07-16', 'pid:00227', 'diagnosis', '2300.00', 'income'), 
('295', '2020-07-16', 'pid:00228', 'diagnosis', '700.00', 'income'), 
('296', '2020-07-16', 'pid:00229', 'diagnosis', '800.00', 'income'), 
('297', '2020-07-16', 'pid:00230', 'diagnosis', '500.00', 'income'), 
('298', '2020-07-16', 'pid:00231', 'diagnosis', '700.00', 'income'), 
('299', '2020-07-16', 'pid:00232', 'diagnosis', '700.00', 'income'), 
('300', '2020-07-16', 'pid:00233', 'diagnosis', '1300.00', 'income'), 
('301', '2020-07-16', 'pid:00234', 'diagnosis', '400.00', 'income'), 
('302', '2020-07-16', 'pid:00235', 'diagnosis', '600.00', 'income'), 
('303', '2020-07-16', 'pid:00236', 'diagnosis', '350.00', 'income'), 
('304', '2020-07-16', 'pid:00237', 'diagnosis', '450.00', 'income'), 
('305', '2020-07-16', 'pid:00238', 'diagnosis', '400.00', 'income'), 
('306', '2020-07-16', 'pid:00239', 'diagnosis', '1300.00', 'income'), 
('307', '2020-07-16', 'pid:00240', 'diagnosis', '200.00', 'income'), 
('308', '2020-07-16', 'pid:00241', 'diagnosis', '800.00', 'income'), 
('309', '2020-07-16', 'pid:00242', 'diagnosis', '500.00', 'income'), 
('310', '2020-07-17', 'pid:00243', 'diagnosis', '400.00', 'income'), 
('311', '2020-07-17', 'pid:00244', 'diagnosis', '400.00', 'income'), 
('312', '2020-07-17', '', 'consultancy', '300.00', 'income'), 
('313', '2020-07-17', 'pid:00245', 'diagnosis', '100.00', 'income'), 
('314', '2020-07-17', 'pid:00246', 'diagnosis', '300.00', 'income'), 
('315', '2020-07-17', 'pid:00247', 'diagnosis', '1100.00', 'income'), 
('316', '2020-07-17', 'pid:00248', 'diagnosis', '1000.00', 'income'), 
('317', '2020-07-17', 'pid:00249', 'diagnosis', '1250.00', 'income'), 
('318', '2020-07-17', 'pid:00250', 'diagnosis', '1800.00', 'income'), 
('319', '2020-07-17', 'pid:00251', 'diagnosis', '1400.00', 'income'), 
('320', '2020-07-17', 'pid:00252', 'diagnosis', '1900.00', 'income'), 
('321', '2020-07-17', 'pid:00253', 'diagnosis', '400.00', 'income'), 
('322', '2020-07-17', 'pid:00254', 'diagnosis', '40.00', 'income'), 
('323', '2020-07-17', 'pid:00255', 'diagnosis', '1400.00', 'income'), 
('324', '2020-07-18', 'pid:00256', 'diagnosis', '400.00', 'income'), 
('325', '2020-07-18', 'pid:00257', 'diagnosis', '600.00', 'income'), 
('326', '2020-07-18', 'pid:00258', 'diagnosis', '50.00', 'income'), 
('327', '2020-07-18', 'pid:00259', 'diagnosis', '400.00', 'income'), 
('328', '2020-07-18', 'pid:00260', 'diagnosis', '400.00', 'income'), 
('329', '2020-07-18', 'pid:00261', 'diagnosis', '220.00', 'income'), 
('330', '2020-07-18', 'pid:00262', 'diagnosis', '500.00', 'income'), 
('331', '2020-07-18', 'pid:00263', 'diagnosis', '350.00', 'income'), 
('332', '2020-07-18', '', 'consultancy', '400.00', 'income'), 
('333', '2020-07-18', 'pid:0281', 'diagnosis', '600.00', 'income'), 
('334', '2020-07-18', '', 'consultancy', '400.00', 'income'), 
('335', '2020-07-18', 'pid:00264', 'diagnosis', '50.00', 'income'), 
('336', '2020-07-19', 'pid:00265', 'diagnosis', '100.00', 'income'), 
('337', '2020-07-19', 'pid:00266', 'diagnosis', '300.00', 'income'), 
('338', '2020-07-19', 'pid:00267', 'diagnosis', '300.00', 'income'), 
('339', '2020-07-19', 'pid:00268', 'diagnosis', '200.00', 'income'), 
('340', '2020-07-19', 'pid:00269', 'diagnosis', '1100.00', 'income'), 
('341', '2020-07-19', 'pid:00270', 'diagnosis', '125.00', 'income'), 
('342', '2020-07-19', 'pid:00271', 'diagnosis', '125.00', 'income'), 
('343', '2020-07-19', 'pid:00272', 'diagnosis', '220.00', 'income'), 
('344', '2020-07-19', 'pid:00273', 'diagnosis', '500.00', 'income'), 
('345', '2020-07-19', 'pid:00274', 'diagnosis', '250.00', 'income'), 
('346', '2020-07-19', '', 'consultancy', '300.00', 'income'), 
('347', '2020-07-19', 'pid:00275', 'diagnosis', '1000.00', 'income'), 
('348', '2020-07-19', 'pid:00276', 'diagnosis', '500.00', 'income'), 
('349', '2020-07-19', 'pid:00277', 'diagnosis', '400.00', 'income'), 
('350', '2020-07-19', 'pid:00278', 'diagnosis', '200.00', 'income'), 
('351', '2020-07-19', 'pid:00279', 'diagnosis', '400.00', 'income'), 
('352', '2020-07-19', 'pid:00280', 'diagnosis', '340.00', 'income'), 
('353', '2020-07-19', 'pid:00281', 'diagnosis', '1900.00', 'income'), 
('354', '2020-07-19', 'pid:00282', 'diagnosis', '1100.00', 'income'), 
('355', '2020-07-19', 'pid:00283', 'diagnosis', '200.00', 'income'), 
('356', '2020-07-19', 'pid:00284', 'diagnosis', '220.00', 'income'), 
('357', '2020-07-19', 'pid:00285', 'diagnosis', '500.00', 'income'), 
('358', '2020-07-20', 'pid:00286', 'diagnosis', '100.00', 'income'), 
('359', '2020-07-20', 'pid:00287', 'diagnosis', '200.00', 'income'), 
('360', '2020-07-20', 'pid:00288', 'diagnosis', '100.00', 'income'), 
('361', '2020-07-20', 'pid:00289', 'diagnosis', '1400.00', 'income'), 
('362', '2020-07-20', 'pid:00290', 'diagnosis', '1000.00', 'income'), 
('363', '2020-07-20', 'pid:00291', 'diagnosis', '500.00', 'income'), 
('364', '2020-07-20', 'pid:00292', 'diagnosis', '500.00', 'income'), 
('365', '2020-07-20', 'pid:00293', 'diagnosis', '1000.00', 'income'), 
('366', '2020-07-20', 'pid:00294', 'diagnosis', '1090.00', 'income'), 
('367', '2020-07-20', 'pid:00295', 'diagnosis', '200.00', 'income'), 
('368', '2020-07-20', 'pid:00296', 'diagnosis', '250.00', 'income'), 
('369', '2020-07-21', 'pid:00297', 'diagnosis', '100.00', 'income'), 
('370', '2020-07-21', '', 'consultancy', '250.00', 'income'), 
('371', '2020-07-21', '', 'consultancy', '400.00', 'income'), 
('372', '2020-07-21', '', 'consultancy', '650.00', 'income'), 
('373', '2020-07-21', 'pid:00298', 'diagnosis', '550.00', 'income'), 
('374', '2020-07-21', 'pid:00299', 'diagnosis', '2000.00', 'income'), 
('375', '2020-07-21', 'pid:00300', 'diagnosis', '250.00', 'income'), 
('376', '2020-07-21', 'pid:00301', 'diagnosis', '400.00', 'income'), 
('377', '2020-07-21', 'pid:00302', 'diagnosis', '300.00', 'income'), 
('378', '2020-07-21', '', 'consultancy', '200.00', 'income'), 
('379', '2020-07-21', 'pid:00303', 'diagnosis', '50.00', 'income'), 
('380', '2020-07-21', '', 'consultancy', '300.00', 'income'), 
('381', '2020-07-21', 'pid:0327', 'diagnosis', '800.00', 'income'), 
('382', '2020-07-21', 'pid:00304', 'diagnosis', '700.00', 'income'), 
('383', '2020-07-21', 'pid:00305', 'diagnosis', '400.00', 'income'), 
('384', '2020-07-22', 'pid:00306', 'diagnosis', '300.00', 'income'), 
('385', '2020-07-21', 'pid:00307', 'diagnosis', '120.00', 'income'), 
('386', '2020-07-22', 'pid:00308', 'diagnosis', '50.00', 'income'), 
('387', '2020-07-22', '', 'consultancy', '250.00', 'income'), 
('388', '2020-07-22', 'pid:00309', 'diagnosis', '1204.00', 'income'), 
('389', '2020-07-22', 'pid:00310', 'diagnosis', '200.00', 'income'), 
('390', '2020-07-22', 'pid:00311', 'diagnosis', '350.00', 'income'), 
('391', '2020-07-22', 'pid:00312', 'diagnosis', '500.00', 'income'), 
('392', '2020-07-22', 'pid:00313', 'diagnosis', '150.00', 'income'), 
('393', '2020-07-22', 'pid:00314', 'diagnosis', '1000.00', 'income'), 
('394', '2020-07-22', 'pid:00315', 'diagnosis', '700.00', 'income'), 
('395', '2020-07-22', 'pid:00316', 'diagnosis', '1000.00', 'income'), 
('396', '2020-07-22', 'pid:00317', 'diagnosis', '1500.00', 'income'), 
('397', '2020-07-22', 'pid:00318', 'diagnosis', '2050.00', 'income'), 
('398', '2020-07-22', '', 'consultancy', '400.00', 'income'), 
('399', '2020-07-22', 'pid:0347', 'diagnosis', '100.00', 'income'), 
('400', '2020-07-22', 'pid:00319', 'diagnosis', '300.00', 'income'), 
('401', '2020-07-23', 'pid:00320', 'diagnosis', '100.00', 'income'), 
('402', '2020-07-23', '', 'consultancy', '303.00', 'income'), 
('403', '2020-07-23', '', 'consultancy', '300.00', 'income'), 
('404', '2020-07-23', '', 'consultancy', '300.00', 'income'), 
('405', '2020-07-23', 'pid:0352', 'diagnosis', '1500.00', 'income'), 
('406', '2020-07-23', '', 'consultancy', '200.00', 'income'), 
('407', '2020-07-23', '', 'consultancy', '200.00', 'income'), 
('408', '2020-07-23', '', 'consultancy', '200.00', 'income'), 
('409', '2020-07-23', '', 'consultancy', '300.00', 'income'), 
('410', '2020-07-23', 'pid:0353', 'diagnosis', '1400.00', 'income'), 
('411', '2020-07-23', 'pid:0358', 'diagnosis', '1900.00', 'income'), 
('412', '2020-07-23', '', 'consultancy', '400.00', 'income'), 
('413', '2020-07-23', 'pid:00321', 'diagnosis', '100.00', 'income'), 
('414', '2020-07-23', '', 'consultancy', '200.00', 'income'), 
('415', '2020-07-23', 'pid:0363', 'diagnosis', '400.00', 'income'), 
('416', '2020-07-23', '', 'consultancy', '0.00', 'income'), 
('417', '2020-07-23', '', 'consultancy', '0.00', 'income'), 
('418', '2020-07-23', '', 'consultancy', '500.00', 'income'), 
('419', '2020-07-23', '', 'consultancy', '500.00', 'income'), 
('420', '2020-07-23', '', 'consultancy', '500.00', 'income'), 
('421', '2020-07-23', 'pid:0368', 'diagnosis', '1100.00', 'income'), 
('422', '2020-07-23', 'pid:0368', 'diagnosis', '400.00', 'income'), 
('423', '2020-07-23', 'pid:0366', 'diagnosis', '600.00', 'income'), 
('424', '2020-07-23', 'pid:00322', 'diagnosis', '150.00', 'income'), 
('425', '2020-07-23', 'pid:00323', 'diagnosis', '300.00', 'income'), 
('426', '2020-07-23', 'pid:00324', 'diagnosis', '350.00', 'income'), 
('427', '2020-07-24', 'pid:00325', 'diagnosis', '700.00', 'income'), 
('428', '2020-07-24', 'pid:00326', 'diagnosis', '140.00', 'income'), 
('429', '2020-07-24', 'pid:00327', 'diagnosis', '1000.00', 'income'), 
('430', '2020-07-24', 'pid:00328', 'diagnosis', '400.00', 'income'), 
('431', '2020-07-24', 'pid:00329', 'diagnosis', '350.00', 'income'), 
('432', '2020-07-24', 'pid:00330', 'diagnosis', '200.00', 'income'), 
('433', '2020-07-24', 'pid:00331', 'diagnosis', '500.00', 'income'), 
('434', '2020-07-24', 'pid:00332', 'diagnosis', '100.00', 'income'), 
('435', '2020-07-24', 'pid:00333', 'diagnosis', '200.00', 'income'), 
('436', '2020-07-24', 'pid:00334', 'diagnosis', '350.00', 'income'), 
('437', '2020-07-24', 'pid:00335', 'diagnosis', '1600.00', 'income'), 
('438', '2020-07-24', 'pid:00336', 'diagnosis', '1000.00', 'income'), 
('439', '2020-07-24', 'pid:00337', 'diagnosis', '400.00', 'income'), 
('440', '2020-07-24', 'pid:00338', 'diagnosis', '2000.00', 'income'), 
('441', '2020-07-24', 'pid:00339', 'diagnosis', '100.00', 'income'), 
('442', '2020-07-24', 'pid:00340', 'diagnosis', '100.00', 'income'), 
('443', '2020-07-24', 'pid:00341', 'diagnosis', '400.00', 'income'), 
('444', '2020-07-24', 'pid:00342', 'diagnosis', '500.00', 'income'), 
('445', '2020-07-24', 'pid:00343', 'diagnosis', '1000.00', 'income'), 
('446', '2020-07-24', 'pid:00344', 'diagnosis', '50.00', 'income'), 
('447', '2020-07-24', 'pid:00345', 'diagnosis', '500.00', 'income'), 
('448', '2020-07-24', 'pid:00346', 'diagnosis', '400.00', 'income'), 
('449', '2020-07-24', 'pid:00347', 'diagnosis', '300.00', 'income'), 
('450', '2020-07-24', 'pid:00348', 'diagnosis', '250.00', 'income'), 
('451', '2020-07-24', 'pid:00349', 'diagnosis', '500.00', 'income'), 
('452', '2020-07-24', 'pid:00350', 'diagnosis', '700.00', 'income'), 
('453', '2020-07-24', 'pid:00351', 'diagnosis', '350.00', 'income'), 
('454', '2020-07-24', 'pid:00352', 'diagnosis', '700.00', 'income'), 
('455', '2020-07-24', 'pid:00353', 'diagnosis', '100.00', 'income'), 
('456', '2020-07-24', 'pid:00354', 'diagnosis', '600.00', 'income'), 
('457', '2020-07-24', 'pid:00355', 'diagnosis', '1700.00', 'income'), 
('458', '2020-07-24', 'pid:00356', 'diagnosis', '450.00', 'income'), 
('459', '2020-07-24', 'pid:00357', 'diagnosis', '100.00', 'income'), 
('460', '2020-07-24', 'pid:00358', 'diagnosis', '400.00', 'income'), 
('461', '2020-07-25', 'pid:00359', 'diagnosis', '1000.00', 'income'), 
('462', '2020-07-25', 'pid:00360', 'diagnosis', '1000.00', 'income'), 
('463', '2020-07-25', 'pid:00361', 'diagnosis', '2500.00', 'income'), 
('464', '2020-07-25', 'pid:00362', 'diagnosis', '400.00', 'income'), 
('465', '2020-07-25', 'pid:00363', 'diagnosis', '700.00', 'income'), 
('466', '2020-07-25', 'pid:00364', 'diagnosis', '400.00', 'income'), 
('467', '2020-07-25', 'pid:0366', 'diagnosis', '200.00', 'income'), 
('468', '2020-07-25', 'pid:00365', 'diagnosis', '100.00', 'income'), 
('469', '2020-07-25', 'pid:00366', 'diagnosis', '300.00', 'income'), 
('470', '2020-07-25', 'pid:00367', 'diagnosis', '600.00', 'income'), 
('471', '2020-07-25', 'pid:00368', 'diagnosis', '900.00', 'income'), 
('472', '2020-07-25', 'pid:00369', 'diagnosis', '200.00', 'income'), 
('473', '2020-07-25', 'pid:00370', 'diagnosis', '1600.00', 'income'), 
('474', '2020-07-25', 'pid:00371', 'diagnosis', '100.00', 'income'), 
('475', '2020-07-25', 'pid:00372', 'diagnosis', '500.00', 'income'), 
('476', '2020-07-25', 'pid:00373', 'diagnosis', '1500.00', 'income'), 
('477', '2020-07-26', 'pid:00374', 'diagnosis', '50.00', 'income'), 
('478', '2020-07-26', 'pid:00375', 'diagnosis', '1400.00', 'income'), 
('479', '2020-07-26', 'pid:00376', 'diagnosis', '200.00', 'income'), 
('480', '2020-07-26', 'pid:00377', 'diagnosis', '300.00', 'income'), 
('481', '2020-07-26', 'pid:00378', 'diagnosis', '400.00', 'income'), 
('482', '2020-07-26', 'pid:00379', 'diagnosis', '200.00', 'income'), 
('483', '2020-07-26', 'pid:00380', 'diagnosis', '500.00', 'income'), 
('484', '2020-07-26', 'pid:00381', 'diagnosis', '300.00', 'income'), 
('485', '2020-07-26', 'pid:00382', 'diagnosis', '400.00', 'income'), 
('486', '2020-07-26', 'pid:00383', 'diagnosis', '150.00', 'income'), 
('487', '2020-07-26', 'pid:00384', 'diagnosis', '2000.00', 'income'), 
('488', '2020-07-26', 'pid:00385', 'diagnosis', '500.00', 'income'), 
('489', '2020-07-26', 'pid:00386', 'diagnosis', '600.00', 'income'), 
('490', '2020-07-26', 'pid:00387', 'diagnosis', '300.00', 'income'), 
('491', '2020-07-26', 'pid:00388', 'diagnosis', '3.00', 'income'), 
('492', '2020-07-26', 'pid:00389', 'diagnosis', '400.00', 'income'), 
('493', '2020-07-27', 'pid:00390', 'diagnosis', '1100.00', 'income'), 
('494', '2020-07-27', 'pid:00391', 'diagnosis', '350.00', 'income'), 
('495', '2020-07-27', 'pid:00392', 'diagnosis', '400.00', 'income'), 
('496', '2020-07-27', 'pid:00393', 'diagnosis', '150.00', 'income'), 
('497', '2020-07-28', 'pid:00394', 'diagnosis', '70.00', 'income'), 
('498', '2020-07-28', 'pid:00395', 'diagnosis', '50.00', 'income'), 
('499', '2020-07-28', 'pid:00396', 'diagnosis', '200.00', 'income'), 
('500', '2020-07-28', 'pid:00397', 'diagnosis', '150.00', 'income'), 
('501', '2020-07-28', 'pid:00398', 'diagnosis', '220.00', 'income'), 
('502', '2020-07-28', 'pid:00399', 'diagnosis', '400.00', 'income'), 
('503', '2020-07-28', 'pid:00400', 'diagnosis', '200.00', 'income'), 
('504', '2020-07-28', 'pid:00401', 'diagnosis', '400.00', 'income'), 
('505', '2020-07-28', 'pid:00402', 'diagnosis', '800.00', 'income'), 
('506', '2020-07-28', 'pid:00403', 'diagnosis', '800.00', 'income'), 
('507', '2020-07-28', 'pid:00404', 'diagnosis', '400.00', 'income'), 
('508', '2020-07-28', 'pid:00405', 'diagnosis', '500.00', 'income'), 
('509', '2020-07-28', 'pid:00406', 'diagnosis', '400.00', 'income'), 
('510', '2020-07-28', 'pid:00407', 'diagnosis', '450.00', 'income'), 
('511', '2020-07-28', 'pid:00408', 'diagnosis', '800.00', 'income'), 
('512', '2020-07-29', 'pid:00409', 'diagnosis', '1800.00', 'income'), 
('513', '2020-07-29', 'pid:00410', 'diagnosis', '150.00', 'income'), 
('514', '2020-07-29', 'pid:00411', 'diagnosis', '1200.00', 'income'), 
('515', '2020-07-29', 'pid:00412', 'diagnosis', '150.00', 'income'), 
('516', '2020-07-29', 'pid:00413', 'diagnosis', '350.00', 'income'), 
('517', '2020-07-29', 'pid:00414', 'diagnosis', '400.00', 'income'), 
('518', '2020-07-29', 'pid:00415', 'diagnosis', '700.00', 'income'), 
('519', '2020-07-29', 'pid:00416', 'diagnosis', '600.00', 'income'), 
('520', '2020-07-29', 'pid:00417', 'diagnosis', '400.00', 'income'), 
('521', '2020-07-30', 'pid:00418', 'diagnosis', '500.00', 'income'), 
('522', '2020-07-30', 'pid:00419', 'diagnosis', '1500.00', 'income'), 
('523', '2020-07-30', 'pid:00420', 'diagnosis', '300.00', 'income'), 
('524', '2020-07-30', 'pid:00421', 'diagnosis', '400.00', 'income'), 
('525', '2020-07-30', 'pid:00422', 'diagnosis', '500.00', 'income'), 
('526', '2020-07-30', 'pid:00423', 'diagnosis', '230.00', 'income'), 
('527', '2020-07-30', 'pid:00424', 'diagnosis', '100.00', 'income'), 
('528', '2020-07-30', 'pid:00425', 'diagnosis', '150.00', 'income'), 
('529', '2020-07-31', 'pid:00426', 'diagnosis', '1200.00', 'income'), 
('530', '2020-07-31', 'pid:00427', 'diagnosis', '250.00', 'income'), 
('531', '2020-07-31', 'pid:00428', 'diagnosis', '600.00', 'income'), 
('532', '2020-07-31', 'pid:00429', 'diagnosis', '150.00', 'income'), 
('533', '2020-07-31', 'pid:00430', 'diagnosis', '350.00', 'income'), 
('534', '2020-07-31', 'pid:00431', 'diagnosis', '200.00', 'income'), 
('535', '2020-07-31', 'pid:00432', 'diagnosis', '600.00', 'income'), 
('536', '2020-07-31', 'pid:00433', 'diagnosis', '500.00', 'income'), 
('537', '2020-07-31', 'pid:00434', 'diagnosis', '1000.00', 'income'), 
('538', '2020-07-31', 'pid:00435', 'diagnosis', '300.00', 'income'), 
('539', '2020-07-31', 'pid:00436', 'diagnosis', '200.00', 'income'), 
('540', '2020-08-03', 'pid:00437', 'diagnosis', '900.00', 'income'), 
('541', '2020-08-03', 'pid:00438', 'diagnosis', '350.00', 'income'), 
('542', '2020-08-03', 'pid:00439', 'diagnosis', '400.00', 'income'), 
('543', '2020-08-03', 'pid:00440', 'diagnosis', '400.00', 'income'), 
('544', '2020-08-03', 'pid:00441', 'diagnosis', '400.00', 'income'), 
('545', '2020-08-03', 'pid:00442', 'diagnosis', '350.00', 'income'), 
('546', '2020-08-03', 'pid:00443', 'diagnosis', '1100.00', 'income'), 
('547', '2020-08-03', 'pid:00444', 'diagnosis', '1000.00', 'income'), 
('548', '2020-08-03', 'pid:00445', 'diagnosis', '1600.00', 'income'), 
('549', '2020-08-03', 'pid:00446', 'diagnosis', '1400.00', 'income'), 
('550', '2020-08-03', 'pid:00447', 'diagnosis', '2000.00', 'income'), 
('551', '2020-08-04', 'pid:00448', 'diagnosis', '80.00', 'income'), 
('552', '2020-08-04', 'pid:00449', 'diagnosis', '1100.00', 'income'), 
('553', '2020-08-04', 'pid:00450', 'diagnosis', '1200.00', 'income'), 
('554', '2020-08-04', 'pid:00451', 'diagnosis', '900.00', 'income'), 
('555', '2020-08-04', 'pid:00452', 'diagnosis', '300.00', 'income'), 
('556', '2020-08-04', 'pid:00453', 'diagnosis', '400.00', 'income'), 
('557', '2020-08-04', 'pid:00454', 'diagnosis', '350.00', 'income'), 
('558', '2020-08-04', 'pid:00455', 'diagnosis', '800.00', 'income'), 
('559', '2020-08-04', 'pid:00456', 'diagnosis', '1200.00', 'income'), 
('560', '2020-08-04', 'pid:00457', 'diagnosis', '300.00', 'income'), 
('561', '2020-08-04', 'pid:00458', 'diagnosis', '300.00', 'income'), 
('562', '2020-08-04', 'pid:00459', 'diagnosis', '600.00', 'income'), 
('563', '2020-08-04', 'pid:00460', 'diagnosis', '2000.00', 'income'), 
('564', '2020-08-04', 'pid:00461', 'diagnosis', '440.00', 'income'), 
('565', '2020-08-05', 'pid:00462', 'diagnosis', '600.00', 'income'), 
('566', '2020-08-05', 'pid:00463', 'diagnosis', '1000.00', 'income'), 
('567', '2020-08-05', 'pid:00464', 'diagnosis', '1000.00', 'income'), 
('568', '2020-08-05', 'pid:00465', 'diagnosis', '1000.00', 'income'), 
('569', '2020-08-05', 'pid:00466', 'diagnosis', '50.00', 'income'), 
('570', '2020-08-05', 'pid:00467', 'diagnosis', '1200.00', 'income'), 
('571', '2020-08-05', 'pid:00468', 'diagnosis', '1200.00', 'income'), 
('572', '2020-08-05', 'pid:00469', 'diagnosis', '100.00', 'income'), 
('573', '2020-08-05', 'pid:00470', 'diagnosis', '2500.00', 'income'), 
('574', '2020-08-05', 'pid:00471', 'diagnosis', '1500.00', 'income'), 
('575', '2020-08-05', 'pid:00472', 'diagnosis', '500.00', 'income'), 
('576', '2020-08-05', 'pid:00473', 'diagnosis', '400.00', 'income'), 
('577', '2020-08-05', 'pid:00474', 'diagnosis', '400.00', 'income'), 
('578', '2020-08-05', 'pid:00475', 'diagnosis', '500.00', 'income'), 
('579', '2020-08-05', 'pid:00476', 'diagnosis', '1000.00', 'income'), 
('580', '2020-08-05', 'pid:00477', 'diagnosis', '1100.00', 'income'), 
('581', '2020-08-05', 'pid:00478', 'diagnosis', '600.00', 'income'), 
('582', '2020-08-05', 'pid:00479', 'diagnosis', '150.00', 'income'), 
('583', '2020-08-05', 'pid:00480', 'diagnosis', '250.00', 'income'), 
('584', '2020-08-06', 'pid:00481', 'diagnosis', '150.00', 'income'), 
('585', '2020-08-06', 'pid:00482', 'diagnosis', '400.00', 'income'), 
('586', '2020-08-06', 'pid:00483', 'diagnosis', '100.00', 'income'), 
('587', '2020-08-06', 'pid:00484', 'diagnosis', '400.00', 'income'), 
('588', '2020-08-06', 'pid:00485', 'diagnosis', '1300.00', 'income'), 
('589', '2020-08-06', 'pid:00486', 'diagnosis', '200.00', 'income'), 
('590', '2020-08-06', 'pid:00487', 'diagnosis', '1000.00', 'income'), 
('591', '2020-08-06', 'pid:00488', 'diagnosis', '400.00', 'income'), 
('592', '2020-08-06', 'pid:00489', 'diagnosis', '1000.00', 'income'), 
('593', '2020-08-06', 'pid:00490', 'diagnosis', '500.00', 'income'), 
('594', '2020-08-06', 'pid:00491', 'diagnosis', '100.00', 'income'), 
('595', '2020-08-06', 'pid:00492', 'diagnosis', '400.00', 'income'), 
('596', '2020-08-06', 'pid:00493', 'diagnosis', '400.00', 'income'), 
('597', '2020-08-06', 'pid:00494', 'diagnosis', '150.00', 'income'), 
('598', '2020-08-06', 'pid:00495', 'diagnosis', '1150.00', 'income'), 
('599', '2020-08-06', 'pid:00496', 'diagnosis', '950.00', 'income'), 
('600', '2020-08-06', 'pid:00497', 'diagnosis', '400.00', 'income'), 
('601', '2020-08-06', 'pid:00498', 'diagnosis', '50.00', 'income'), 
('602', '2020-08-07', 'pid:00499', 'diagnosis', '400.00', 'income'), 
('603', '2020-08-07', 'pid:00500', 'diagnosis', '50.00', 'income'), 
('604', '2020-08-07', 'pid:00501', 'diagnosis', '50.00', 'income'), 
('605', '2020-08-07', 'pid:00502', 'diagnosis', '50.00', 'income'), 
('606', '2020-08-07', 'pid:00503', 'diagnosis', '50.00', 'income'), 
('607', '2020-08-07', 'pid:00504', 'diagnosis', '500.00', 'income'), 
('608', '2020-08-07', 'pid:00505', 'diagnosis', '500.00', 'income'), 
('609', '2020-08-07', 'pid:00506', 'diagnosis', '350.00', 'income'), 
('610', '2020-08-07', 'pid:00507', 'diagnosis', '1000.00', 'income'), 
('611', '2020-08-07', 'pid:00508', 'diagnosis', '500.00', 'income'), 
('612', '2020-08-07', 'pid:00509', 'diagnosis', '600.00', 'income'), 
('613', '2020-08-07', 'pid:00510', 'diagnosis', '1600.00', 'income'), 
('614', '2020-08-07', 'pid:00511', 'diagnosis', '500.00', 'income'), 
('615', '2020-08-07', 'pid:00512', 'diagnosis', '300.00', 'income'), 
('616', '2020-08-07', 'pid:00513', 'diagnosis', '400.00', 'income'), 
('617', '2020-08-07', 'pid:00514', 'diagnosis', '300.00', 'income'), 
('618', '2020-08-07', 'pid:00515', 'diagnosis', '1000.00', 'income'), 
('619', '2020-08-07', 'pid:00516', 'diagnosis', '300.00', 'income'), 
('620', '2020-08-07', 'pid:00517', 'diagnosis', '350.00', 'income'), 
('621', '2020-08-07', 'pid:00518', 'diagnosis', '1000.00', 'income'), 
('622', '2020-08-07', 'pid:00519', 'diagnosis', '100.00', 'income'), 
('623', '2020-08-07', 'pid:00520', 'diagnosis', '600.00', 'income'), 
('624', '2020-08-07', 'pid:00521', 'diagnosis', '500.00', 'income'), 
('625', '2020-08-07', 'pid:00522', 'diagnosis', '400.00', 'income'), 
('626', '2020-08-07', 'pid:00523', 'diagnosis', '200.00', 'income'), 
('627', '2020-08-07', 'pid:00524', 'diagnosis', '200.00', 'income'), 
('628', '2020-08-07', 'pid:00525', 'diagnosis', '600.00', 'income'), 
('629', '2020-08-07', 'pid:00526', 'diagnosis', '200.00', 'income'), 
('630', '2020-08-07', 'pid:00527', 'diagnosis', '100.00', 'income'), 
('631', '2020-08-07', 'pid:00528', 'diagnosis', '1000.00', 'income'), 
('632', '2020-08-07', 'pid:00529', 'diagnosis', '100.00', 'income'), 
('633', '2020-08-07', 'pid:00530', 'diagnosis', '400.00', 'income'), 
('634', '2020-08-07', 'pid:00531', 'diagnosis', '800.00', 'income'), 
('635', '2020-08-07', 'pid:00532', 'diagnosis', '100.00', 'income'), 
('636', '2020-08-07', 'pid:00533', 'diagnosis', '200.00', 'income'), 
('637', '2020-08-08', 'pid:00534', 'diagnosis', '100.00', 'income'), 
('638', '2020-08-08', 'pid:00535', 'diagnosis', '400.00', 'income'), 
('639', '2020-08-08', 'pid:00536', 'diagnosis', '900.00', 'income'), 
('640', '2020-08-08', 'pid:00537', 'diagnosis', '350.00', 'income'), 
('641', '2020-08-08', 'pid:00538', 'diagnosis', '300.00', 'income'), 
('642', '2020-08-08', 'pid:00539', 'diagnosis', '600.00', 'income'), 
('643', '2020-08-08', 'pid:00540', 'diagnosis', '600.00', 'income'), 
('644', '2020-08-08', 'pid:00541', 'diagnosis', '200.00', 'income'), 
('645', '2020-08-08', 'pid:00542', 'diagnosis', '300.00', 'income'), 
('646', '2020-08-08', 'pid:00543', 'diagnosis', '200.00', 'income'), 
('647', '2020-08-08', 'pid:00544', 'diagnosis', '200.00', 'income'), 
('648', '2020-08-08', 'pid:00545', 'diagnosis', '300.00', 'income'), 
('649', '2020-08-08', 'pid:00546', 'diagnosis', '300.00', 'income'), 
('650', '2020-08-08', 'pid:00547', 'diagnosis', '400.00', 'income'), 
('651', '2020-08-08', 'pid:00548', 'diagnosis', '200.00', 'income'), 
('652', '2020-08-08', 'pid:00549', 'diagnosis', '500.00', 'income'), 
('653', '2020-08-09', 'pid:00550', 'diagnosis', '700.00', 'income'), 
('654', '2020-08-09', 'pid:00551', 'diagnosis', '1000.00', 'income'), 
('655', '2020-08-09', 'pid:00552', 'diagnosis', '250.00', 'income'), 
('656', '2020-08-09', 'pid:00553', 'diagnosis', '150.00', 'income'), 
('657', '2020-08-09', 'pid:00554', 'diagnosis', '300.00', 'income'), 
('658', '2020-08-09', 'pid:00555', 'diagnosis', '2000.00', 'income'), 
('659', '2020-08-09', 'pid:00556', 'diagnosis', '300.00', 'income'), 
('660', '2020-08-09', 'pid:00557', 'diagnosis', '500.00', 'income'), 
('661', '2020-08-09', 'pid:00558', 'diagnosis', '80.00', 'income'), 
('662', '2020-08-09', 'pid:00559', 'diagnosis', '650.00', 'income'), 
('663', '2020-08-09', 'pid:00560', 'diagnosis', '400.00', 'income'), 
('664', '2020-08-09', 'pid:00561', 'diagnosis', '800.00', 'income'), 
('665', '2020-08-09', 'pid:00562', 'diagnosis', '700.00', 'income'), 
('666', '2020-08-09', 'pid:00563', 'diagnosis', '1600.00', 'income'), 
('667', '2020-08-09', 'pid:00564', 'diagnosis', '500.00', 'income'), 
('668', '2020-08-09', 'pid:00565', 'diagnosis', '300.00', 'income'), 
('669', '2020-08-09', 'pid:00566', 'diagnosis', '200.00', 'income'), 
('670', '2020-08-09', 'pid:00567', 'diagnosis', '1000.00', 'income'), 
('671', '2020-08-09', 'pid:00568', 'diagnosis', '600.00', 'income'), 
('672', '2020-08-09', 'pid:00569', 'diagnosis', '200.00', 'income'), 
('673', '2020-08-09', 'pid:00570', 'diagnosis', '100.00', 'income'), 
('674', '2020-08-10', 'pid:00571', 'diagnosis', '120.00', 'income'), 
('675', '2020-08-10', 'pid:00572', 'diagnosis', '100.00', 'income'), 
('676', '2020-08-10', 'pid:00573', 'diagnosis', '100.00', 'income'), 
('677', '2020-08-10', 'pid:00574', 'diagnosis', '400.00', 'income'), 
('678', '2020-08-10', 'pid:00575', 'diagnosis', '150.00', 'income'), 
('679', '2020-08-10', 'pid:00576', 'diagnosis', '500.00', 'income'), 
('680', '2020-08-10', 'pid:00577', 'diagnosis', '1600.00', 'income'), 
('681', '2020-08-10', 'pid:00578', 'diagnosis', '400.00', 'income'), 
('682', '2020-08-10', 'pid:00579', 'diagnosis', '350.00', 'income'), 
('683', '2020-08-10', 'pid:00580', 'diagnosis', '500.00', 'income'), 
('684', '2020-08-11', 'pid:00581', 'diagnosis', '100.00', 'income'), 
('685', '2020-08-11', 'pid:00582', 'diagnosis', '300.00', 'income'), 
('686', '2020-08-11', 'pid:00583', 'diagnosis', '100.00', 'income'), 
('687', '2020-08-11', 'pid:00584', 'diagnosis', '450.00', 'income'), 
('688', '2020-08-11', 'pid:00585', 'diagnosis', '250.00', 'income'), 
('689', '2020-08-11', 'pid:00586', 'diagnosis', '150.00', 'income'), 
('690', '2020-08-11', 'pid:00587', 'diagnosis', '200.00', 'income'), 
('691', '2020-08-11', 'pid:00588', 'diagnosis', '400.00', 'income'), 
('692', '2020-08-11', 'pid:00589', 'diagnosis', '800.00', 'income'), 
('693', '2020-08-11', 'pid:00590', 'diagnosis', '100.00', 'income'), 
('694', '2020-08-11', 'pid:00591', 'diagnosis', '1500.00', 'income'), 
('695', '2020-08-11', 'pid:00592', 'diagnosis', '800.00', 'income'), 
('696', '2020-08-11', 'pid:00593', 'diagnosis', '1000.00', 'income'), 
('697', '2020-08-11', 'pid:00594', 'diagnosis', '250.00', 'income'), 
('698', '2020-08-11', 'pid:00595', 'diagnosis', '400.00', 'income'), 
('699', '2020-08-11', 'pid:00596', 'diagnosis', '1000.00', 'income'), 
('700', '2020-08-11', 'pid:00597', 'diagnosis', '150.00', 'income'), 
('701', '2020-08-11', 'pid:00598', 'diagnosis', '500.00', 'income'), 
('702', '2020-08-12', 'pid:00599', 'diagnosis', '2000.00', 'income'), 
('703', '2020-08-12', 'pid:00600', 'diagnosis', '300.00', 'income'), 
('704', '2020-08-12', 'pid:00601', 'diagnosis', '350.00', 'income'), 
('705', '2020-08-12', 'pid:00602', 'diagnosis', '150.00', 'income'), 
('706', '2020-08-12', 'pid:00603', 'diagnosis', '600.00', 'income'), 
('707', '2020-08-12', 'pid:00604', 'diagnosis', '400.00', 'income'), 
('708', '2020-08-12', 'pid:00605', 'diagnosis', '200.00', 'income'), 
('709', '2020-08-12', 'pid:00606', 'diagnosis', '100.00', 'income'), 
('710', '2020-08-12', 'pid:00607', 'diagnosis', '400.00', 'income'), 
('711', '2020-08-13', 'pid:00608', 'diagnosis', '500.00', 'income'), 
('712', '2020-08-13', 'pid:00609', 'diagnosis', '1000.00', 'income'), 
('713', '2020-08-13', 'pid:00610', 'diagnosis', '450.00', 'income'), 
('714', '2020-08-13', 'pid:00611', 'diagnosis', '400.00', 'income'), 
('715', '2020-08-13', 'pid:00612', 'diagnosis', '500.00', 'income'), 
('716', '2020-08-13', 'pid:00613', 'diagnosis', '350.00', 'income'), 
('717', '2020-08-13', 'pid:00614', 'diagnosis', '500.00', 'income'), 
('718', '2020-08-13', 'pid:00615', 'diagnosis', '350.00', 'income'), 
('719', '2020-08-13', 'pid:00616', 'diagnosis', '500.00', 'income'), 
('720', '2020-08-13', 'pid:00617', 'diagnosis', '400.00', 'income'), 
('721', '2020-08-13', 'pid:00617', 'diagnosis', '500.00', 'income'), 
('722', '2020-08-13', 'pid:00618', 'diagnosis', '1600.00', 'income'), 
('723', '2020-08-13', 'pid:00619', 'diagnosis', '400.00', 'income'), 
('724', '2020-08-13', 'pid:00620', 'diagnosis', '250.00', 'income'), 
('725', '2020-08-13', 'pid:00621', 'diagnosis', '2000.00', 'income'), 
('726', '2020-08-14', 'pid:00622', 'diagnosis', '1800.00', 'income'), 
('727', '2020-08-14', 'pid:00623', 'diagnosis', '100.00', 'income'), 
('728', '2020-08-14', 'pid:00624', 'diagnosis', '1500.00', 'income'), 
('729', '2020-08-14', 'pid:00625', 'diagnosis', '800.00', 'income'), 
('730', '2020-08-14', 'pid:00626', 'diagnosis', '200.00', 'income'), 
('731', '2020-08-14', 'pid:00627', 'diagnosis', '1200.00', 'income'), 
('732', '2020-08-14', 'pid:00628', 'diagnosis', '500.00', 'income'), 
('733', '2020-08-14', 'pid:00629', 'diagnosis', '200.00', 'income'), 
('734', '2020-08-14', 'pid:00630', 'diagnosis', '100.00', 'income'), 
('735', '2020-08-14', 'pid:00631', 'diagnosis', '500.00', 'income'), 
('736', '2020-08-14', 'pid:00632', 'diagnosis', '400.00', 'income'), 
('737', '2020-08-14', 'pid:00633', 'diagnosis', '300.00', 'income'), 
('738', '2020-08-14', 'pid:00634', 'diagnosis', '300.00', 'income'), 
('739', '2020-08-14', 'pid:00635', 'diagnosis', '200.00', 'income'), 
('740', '2020-08-14', 'pid:00636', 'diagnosis', '500.00', 'income'), 
('741', '2020-08-14', 'pid:00637', 'diagnosis', '100.00', 'income'), 
('742', '2020-08-14', 'pid:00638', 'diagnosis', '100.00', 'income'), 
('743', '2020-08-14', 'pid:00639', 'diagnosis', '250.00', 'income'), 
('744', '2020-08-14', 'pid:00640', 'diagnosis', '400.00', 'income'), 
('745', '2020-08-14', 'pid:00641', 'diagnosis', '1600.00', 'income'), 
('746', '2020-08-14', 'pid:00642', 'diagnosis', '100.00', 'income'), 
('747', '2020-08-14', 'pid:00643', 'diagnosis', '900.00', 'income'), 
('748', '2020-08-14', 'pid:00644', 'diagnosis', '900.00', 'income'), 
('749', '2020-08-14', 'pid:00645', 'diagnosis', '200.00', 'income'), 
('750', '2020-08-14', 'pid:00646', 'diagnosis', '300.00', 'income'), 
('751', '2020-08-14', 'pid:00647', 'diagnosis', '250.00', 'income'), 
('752', '2020-08-14', 'pid:00648', 'diagnosis', '200.00', 'income'), 
('753', '2020-08-14', 'pid:00649', 'diagnosis', '100.00', 'income'), 
('754', '2020-08-14', 'pid:00650', 'diagnosis', '400.00', 'income'), 
('755', '2020-08-14', 'pid:00651', 'diagnosis', '800.00', 'income'), 
('756', '2020-08-15', 'pid:00652', 'diagnosis', '100.00', 'income'), 
('757', '2020-08-15', 'pid:00653', 'diagnosis', '200.00', 'income'), 
('758', '2020-08-15', 'pid:00654', 'diagnosis', '300.00', 'income'), 
('759', '2020-08-15', 'pid:00655', 'diagnosis', '300.00', 'income'), 
('760', '2020-08-15', 'pid:00656', 'diagnosis', '500.00', 'income'), 
('761', '2020-08-15', 'pid:00657', 'diagnosis', '600.00', 'income'), 
('762', '2020-08-15', 'pid:00658', 'diagnosis', '350.00', 'income'), 
('763', '2020-08-15', 'pid:00659', 'diagnosis', '1700.00', 'income'), 
('764', '2020-08-15', 'pid:00660', 'diagnosis', '1700.00', 'income'), 
('765', '2020-08-15', 'pid:00661', 'diagnosis', '400.00', 'income'), 
('766', '2020-08-15', 'pid:00662', 'diagnosis', '1400.00', 'income'), 
('767', '2020-08-15', 'pid:00663', 'diagnosis', '700.00', 'income'), 
('768', '2020-08-15', 'pid:00664', 'diagnosis', '1350.00', 'income'), 
('769', '2020-08-15', 'pid:00665', 'diagnosis', '500.00', 'income'), 
('770', '2020-08-15', 'pid:00666', 'diagnosis', '400.00', 'income'), 
('771', '2020-08-15', 'pid:00667', 'diagnosis', '200.00', 'income'), 
('772', '2020-08-15', 'pid:00668', 'diagnosis', '500.00', 'income'), 
('773', '2020-08-15', 'pid:00669', 'diagnosis', '900.00', 'income'), 
('774', '2020-08-16', 'pid:00670', 'diagnosis', '600.00', 'income'), 
('775', '2020-08-16', 'pid:00671', 'diagnosis', '300.00', 'income'), 
('776', '2020-08-16', 'pid:00672', 'diagnosis', '1200.00', 'income'), 
('777', '2020-08-16', 'pid:00673', 'diagnosis', '400.00', 'income'), 
('778', '2020-08-16', 'pid:00674', 'diagnosis', '100.00', 'income'), 
('779', '2020-08-16', 'pid:00675', 'diagnosis', '250.00', 'income'), 
('780', '2020-08-16', 'pid:00676', 'diagnosis', '400.00', 'income'), 
('781', '2020-08-16', 'pid:00677', 'diagnosis', '350.00', 'income'), 
('782', '2020-08-16', 'pid:00678', 'diagnosis', '350.00', 'income'), 
('783', '2020-08-16', 'pid:00679', 'diagnosis', '120.00', 'income'), 
('784', '2020-08-16', 'pid:00680', 'diagnosis', '1500.00', 'income'), 
('785', '2020-08-16', 'pid:00681', 'diagnosis', '300.00', 'income'), 
('786', '2020-08-16', 'pid:00682', 'diagnosis', '400.00', 'income'), 
('787', '2020-08-17', 'pid:00683', 'diagnosis', '850.00', 'income'), 
('788', '2020-08-17', 'pid:00684', 'diagnosis', '400.00', 'income'), 
('789', '2020-08-17', 'pid:00685', 'diagnosis', '1000.00', 'income'), 
('790', '2020-08-17', 'pid:00686', 'diagnosis', '300.00', 'income'), 
('791', '2020-08-17', 'pid:00687', 'diagnosis', '400.00', 'income'), 
('792', '2020-08-17', 'pid:00688', 'diagnosis', '400.00', 'income'), 
('793', '2020-08-17', 'pid:00689', 'diagnosis', '200.00', 'income'), 
('794', '2020-08-17', 'pid:00690', 'diagnosis', '250.00', 'income'), 
('795', '2020-08-17', 'pid:00691', 'diagnosis', '100.00', 'income'), 
('796', '2020-08-17', 'pid:00692', 'diagnosis', '50.00', 'income'), 
('797', '2020-08-17', 'pid:00693', 'diagnosis', '500.00', 'income'), 
('798', '2020-08-17', 'pid:00694', 'diagnosis', '350.00', 'income'), 
('799', '2020-08-17', 'pid:00695', 'diagnosis', '400.00', 'income'), 
('800', '2020-08-17', 'pid:00696', 'diagnosis', '800.00', 'income'), 
('801', '2020-08-18', 'pid:00697', 'diagnosis', '200.00', 'income'), 
('802', '2020-08-18', 'pid:00698', 'diagnosis', '100.00', 'income'), 
('803', '2020-08-18', 'pid:00699', 'diagnosis', '1000.00', 'income'), 
('804', '2020-08-18', 'pid:00700', 'diagnosis', '500.00', 'income'), 
('805', '2020-08-18', 'pid:00701', 'diagnosis', '1200.00', 'income'), 
('806', '2020-08-18', 'pid:00702', 'diagnosis', '100.00', 'income'), 
('807', '2020-08-18', 'pid:00703', 'diagnosis', '60.00', 'income'), 
('808', '2020-08-18', 'pid:00704', 'diagnosis', '100.00', 'income'), 
('809', '2020-08-18', 'pid:00705', 'diagnosis', '450.00', 'income'), 
('810', '2020-08-18', 'pid:00706', 'diagnosis', '600.00', 'income'), 
('811', '2020-08-18', 'pid:00707', 'diagnosis', '100.00', 'income'), 
('812', '2020-08-18', 'pid:00708', 'diagnosis', '100.00', 'income'), 
('813', '2020-08-19', 'pid:00709', 'diagnosis', '100.00', 'income'), 
('814', '2020-08-19', 'pid:00710', 'diagnosis', '250.00', 'income'), 
('815', '2020-08-19', 'pid:00711', 'diagnosis', '1400.00', 'income'), 
('816', '2020-08-19', 'pid:00712', 'diagnosis', '250.00', 'income'), 
('817', '2020-08-19', 'pid:00713', 'diagnosis', '500.00', 'income'), 
('818', '2020-08-19', 'pid:00714', 'diagnosis', '100.00', 'income'), 
('819', '2020-08-19', 'pid:00715', 'diagnosis', '400.00', 'income'), 
('820', '2020-08-19', 'pid:00716', 'diagnosis', '500.00', 'income'), 
('821', '2020-08-19', 'pid:00717', 'diagnosis', '400.00', 'income'), 
('822', '2020-08-19', 'pid:00718', 'diagnosis', '400.00', 'income'), 
('823', '2020-08-19', 'pid:00719', 'diagnosis', '250.00', 'income'), 
('824', '2020-08-19', 'pid:00720', 'diagnosis', '250.00', 'income'), 
('825', '2020-08-19', 'pid:00721', 'diagnosis', '500.00', 'income'), 
('826', '2020-08-19', 'pid:00722', 'diagnosis', '1500.00', 'income'), 
('827', '2020-08-19', 'pid:00723', 'diagnosis', '1300.00', 'income'), 
('828', '2020-08-19', 'pid:00724', 'diagnosis', '250.00', 'income'), 
('829', '2020-08-19', 'pid:00725', 'diagnosis', '800.00', 'income'), 
('830', '2020-08-19', 'pid:00726', 'diagnosis', '100.00', 'income'), 
('831', '2020-08-19', 'pid:00727', 'diagnosis', '1200.00', 'income'), 
('832', '2020-08-19', 'pid:00728', 'diagnosis', '50.00', 'income'), 
('833', '2020-08-19', 'pid:00729', 'diagnosis', '150.00', 'income'), 
('834', '2020-08-19', 'pid:00730', 'diagnosis', '1500.00', 'income'), 
('835', '2020-08-19', 'pid:00731', 'diagnosis', '10.00', 'income'), 
('836', '2020-08-19', 'pid:00732', 'diagnosis', '200.00', 'income'), 
('837', '2020-08-19', 'pid:00733', 'diagnosis', '200.00', 'income'), 
('838', '2020-08-19', 'pid:00734', 'diagnosis', '400.00', 'income'), 
('839', '2020-08-20', 'pid:00735', 'diagnosis', '350.00', 'income'), 
('840', '2020-08-20', 'pid:00736', 'diagnosis', '500.00', 'income'), 
('841', '2020-08-20', 'pid:00737', 'diagnosis', '300.00', 'income'), 
('842', '2020-02-03', 'pid:00738', 'diagnosis', '700.00', 'income'), 
('843', '2020-08-20', 'pid:00739', 'diagnosis', '250.00', 'income'), 
('844', '2020-08-20', 'pid:00740', 'diagnosis', '1100.00', 'income'), 
('845', '2020-08-20', 'pid:00741', 'diagnosis', '400.00', 'income'), 
('846', '2020-08-20', 'pid:00742', 'diagnosis', '150.00', 'income'), 
('847', '2020-08-20', 'pid:00743', 'diagnosis', '400.00', 'income'), 
('848', '2020-08-20', 'pid:00744', 'diagnosis', '600.00', 'income'), 
('849', '2020-08-20', 'pid:00745', 'diagnosis', '600.00', 'income'), 
('850', '2020-08-21', 'pid:00746', 'diagnosis', '50.00', 'income'), 
('851', '2020-08-21', 'pid:00747', 'diagnosis', '50.00', 'income'), 
('852', '2020-08-21', 'pid:00748', 'diagnosis', '1000.00', 'income'), 
('853', '2020-08-21', 'pid:00749', 'diagnosis', '100.00', 'income'), 
('854', '2020-08-21', 'pid:00750', 'diagnosis', '500.00', 'income'), 
('855', '2020-08-21', 'pid:00751', 'diagnosis', '200.00', 'income'), 
('856', '2020-08-21', 'pid:00752', 'diagnosis', '50.00', 'income'), 
('857', '2020-08-21', 'pid:00753', 'diagnosis', '100.00', 'income'), 
('858', '2020-08-21', 'pid:00754', 'diagnosis', '800.00', 'income'), 
('859', '2020-08-21', 'pid:00755', 'diagnosis', '300.00', 'income'), 
('860', '2020-08-21', 'pid:00756', 'diagnosis', '1000.00', 'income'), 
('861', '2020-08-21', 'pid:00757', 'diagnosis', '400.00', 'income'), 
('862', '2020-08-21', 'pid:00758', 'diagnosis', '1100.00', 'income'), 
('863', '2020-08-21', 'pid:00759', 'diagnosis', '300.00', 'income'), 
('864', '2020-08-21', 'pid:00760', 'diagnosis', '400.00', 'income'), 
('865', '2020-08-21', 'pid:00761', 'diagnosis', '500.00', 'income'), 
('866', '2020-08-21', 'pid:00762', 'diagnosis', '500.00', 'income'), 
('867', '2020-08-21', 'pid:00763', 'diagnosis', '300.00', 'income'), 
('868', '2020-08-21', 'pid:00764', 'diagnosis', '300.00', 'income'), 
('869', '2020-08-21', 'pid:00765', 'diagnosis', '600.00', 'income'), 
('870', '2020-08-21', 'pid:00766', 'diagnosis', '500.00', 'income'), 
('871', '2020-08-21', 'pid:00767', 'diagnosis', '500.00', 'income'), 
('872', '2020-08-21', 'pid:00768', 'diagnosis', '600.00', 'income'), 
('873', '2020-08-21', 'pid:00769', 'diagnosis', '350.00', 'income'), 
('874', '2020-08-21', 'pid:00770', 'diagnosis', '700.00', 'income'), 
('875', '2020-08-21', 'pid:00771', 'diagnosis', '500.00', 'income'), 
('876', '2020-08-21', 'pid:00772', 'diagnosis', '100.00', 'income'), 
('877', '2020-08-21', 'pid:00773', 'diagnosis', '500.00', 'income'), 
('878', '2020-08-21', 'pid:00774', 'diagnosis', '500.00', 'income'), 
('879', '2020-08-21', 'pid:00775', 'diagnosis', '500.00', 'income'), 
('880', '2020-08-21', 'pid:00776', 'diagnosis', '200.00', 'income'), 
('881', '2020-08-21', 'pid:00777', 'diagnosis', '350.00', 'income'), 
('882', '2020-08-21', 'pid:00778', 'diagnosis', '700.00', 'income'), 
('883', '2020-08-21', 'pid:00779', 'diagnosis', '100.00', 'income'), 
('884', '2020-08-21', 'pid:00780', 'diagnosis', '1100.00', 'income'), 
('885', '2020-08-21', 'pid:00781', 'diagnosis', '360.00', 'income'), 
('886', '2020-08-21', 'pid:00782', 'diagnosis', '1400.00', 'income'), 
('887', '2020-08-21', 'pid:00783', 'diagnosis', '300.00', 'income'), 
('888', '2020-08-21', 'pid:00784', 'diagnosis', '500.00', 'income'), 
('889', '2020-08-22', 'pid:00785', 'diagnosis', '100.00', 'income'), 
('890', '2020-08-22', 'pid:00786', 'diagnosis', '100.00', 'income'), 
('891', '2020-08-22', 'pid:00787', 'diagnosis', '400.00', 'income'), 
('892', '2020-08-22', 'pid:00788', 'diagnosis', '1000.00', 'income'), 
('893', '2020-08-22', 'pid:00789', 'diagnosis', '1200.00', 'income'), 
('894', '2020-08-22', 'pid:00790', 'diagnosis', '600.00', 'income'), 
('895', '2020-08-22', 'pid:00791', 'diagnosis', '900.00', 'income'), 
('896', '2020-08-22', 'pid:00792', 'diagnosis', '900.00', 'income'), 
('897', '2020-08-22', 'pid:00793', 'diagnosis', '1100.00', 'income'), 
('898', '2020-08-22', 'pid:00794', 'diagnosis', '1600.00', 'income'), 
('899', '2020-08-22', 'pid:00795', 'diagnosis', '200.00', 'income'), 
('900', '2020-08-22', 'pid:00796', 'diagnosis', '1200.00', 'income'), 
('901', '2020-08-23', 'pid:00797', 'diagnosis', '650.00', 'income'), 
('902', '2020-08-23', 'pid:00798', 'diagnosis', '300.00', 'income'), 
('903', '2020-08-23', 'pid:00799', 'diagnosis', '400.00', 'income'), 
('904', '2020-08-23', 'pid:00800', 'diagnosis', '200.00', 'income'), 
('905', '2020-08-23', 'pid:00801', 'diagnosis', '400.00', 'income'), 
('906', '2020-08-23', 'pid:00802', 'diagnosis', '250.00', 'income'), 
('907', '2020-08-23', 'pid:00803', 'diagnosis', '150.00', 'income'), 
('908', '2020-08-23', 'pid:00804', 'diagnosis', '100.00', 'income'), 
('909', '2020-08-24', 'pid:00805', 'diagnosis', '800.00', 'income'), 
('910', '2020-08-24', 'pid:00806', 'diagnosis', '50.00', 'income'), 
('911', '2020-08-24', 'pid:00807', 'diagnosis', '100.00', 'income'), 
('912', '2020-08-24', 'pid:00808', 'diagnosis', '500.00', 'income'), 
('913', '2020-08-24', 'pid:00809', 'diagnosis', '1600.00', 'income'), 
('914', '2020-08-24', 'pid:00810', 'diagnosis', '1000.00', 'income'), 
('915', '2020-08-24', 'pid:00811', 'diagnosis', '400.00', 'income'), 
('916', '2020-08-24', 'pid:00812', 'diagnosis', '1700.00', 'income'), 
('917', '2020-08-24', 'pid:00813', 'diagnosis', '150.00', 'income'), 
('918', '2020-08-24', 'pid:00814', 'diagnosis', '600.00', 'income'), 
('919', '2020-08-24', 'pid:00815', 'diagnosis', '800.00', 'income'), 
('920', '2020-08-25', 'pid:00816', 'diagnosis', '700.00', 'income'), 
('921', '2020-08-25', 'pid:00817', 'diagnosis', '100.00', 'income'), 
('922', '2020-08-25', 'pid:00818', 'diagnosis', '250.00', 'income'), 
('923', '2020-08-25', 'pid:00819', 'diagnosis', '800.00', 'income'), 
('924', '2020-08-25', 'pid:00820', 'diagnosis', '500.00', 'income'), 
('925', '2020-08-25', 'pid:00821', 'diagnosis', '1000.00', 'income'), 
('926', '2020-08-25', 'pid:00822', 'diagnosis', '350.00', 'income'), 
('927', '2020-08-25', 'pid:00823', 'diagnosis', '1200.00', 'income'), 
('928', '2020-08-25', 'pid:00824', 'diagnosis', '400.00', 'income'), 
('929', '2020-08-25', 'pid:00825', 'diagnosis', '900.00', 'income'), 
('930', '2020-08-25', 'pid:00826', 'diagnosis', '1000.00', 'income'), 
('931', '2020-08-25', 'pid:00827', 'diagnosis', '400.00', 'income'), 
('932', '2020-08-25', 'pid:00828', 'diagnosis', '500.00', 'income'), 
('933', '2020-08-25', 'pid:00829', 'diagnosis', '250.00', 'income'), 
('934', '2020-08-25', 'pid:00830', 'diagnosis', '800.00', 'income'), 
('935', '2020-08-25', 'pid:00831', 'diagnosis', '100.00', 'income'), 
('936', '2020-08-26', 'pid:00832', 'diagnosis', '200.00', 'income'), 
('937', '2020-08-26', 'pid:00833', 'diagnosis', '250.00', 'income'), 
('938', '2020-08-26', 'pid:00833', 'diagnosis', '250.00', 'income'), 
('939', '2020-08-26', 'pid:00834', 'diagnosis', '200.00', 'income'), 
('940', '2020-08-26', 'pid:00835', 'diagnosis', '500.00', 'income'), 
('941', '2020-08-26', 'pid:00836', 'diagnosis', '250.00', 'income'), 
('942', '2020-08-26', 'pid:00837', 'diagnosis', '700.00', 'income'), 
('943', '2020-08-26', 'pid:00838', 'diagnosis', '200.00', 'income'), 
('944', '2020-08-26', 'pid:00839', 'diagnosis', '400.00', 'income'), 
('945', '2020-08-26', 'pid:00840', 'diagnosis', '400.00', 'income'), 
('946', '2020-08-26', 'pid:00841', 'diagnosis', '1150.00', 'income'), 
('947', '2020-08-26', 'pid:00842', 'diagnosis', '1050.00', 'income'), 
('948', '2020-08-26', 'pid:00843', 'diagnosis', '1450.00', 'income'), 
('949', '2020-08-26', 'pid:00844', 'diagnosis', '1500.00', 'income'), 
('950', '2020-08-26', 'pid:00845', 'diagnosis', '350.00', 'income'), 
('951', '2020-08-26', 'pid:00846', 'diagnosis', '1500.00', 'income'), 
('952', '2020-08-26', 'pid:00847', 'diagnosis', '500.00', 'income'), 
('953', '2020-08-26', 'pid:00848', 'diagnosis', '100.00', 'income'), 
('954', '2020-08-27', 'pid:00849', 'diagnosis', '500.00', 'income'), 
('955', '2020-08-27', 'pid:00850', 'diagnosis', '1000.00', 'income'), 
('956', '2020-08-27', 'pid:00851', 'diagnosis', '900.00', 'income'), 
('957', '2020-08-27', 'pid:00852', 'diagnosis', '1200.00', 'income'), 
('958', '2020-08-27', 'pid:00853', 'diagnosis', '250.00', 'income'), 
('959', '2020-08-27', 'pid:00854', 'diagnosis', '800.00', 'income'), 
('960', '2020-08-27', 'pid:00855', 'diagnosis', '600.00', 'income'), 
('961', '2020-08-27', 'pid:00856', 'diagnosis', '100.00', 'income'), 
('962', '2020-08-27', 'pid:00857', 'diagnosis', '400.00', 'income'), 
('963', '2020-08-27', 'pid:00858', 'diagnosis', '150.00', 'income'), 
('964', '2020-08-27', 'pid:00859', 'diagnosis', '400.00', 'income'), 
('965', '2020-08-27', 'pid:00860', 'diagnosis', '1000.00', 'income'), 
('966', '2020-08-27', 'pid:00861', 'diagnosis', '900.00', 'income'), 
('967', '2020-08-28', 'pid:00862', 'diagnosis', '200.00', 'income'), 
('968', '2020-08-28', 'pid:00863', 'diagnosis', '50.00', 'income'), 
('969', '2020-08-28', 'pid:00864', 'diagnosis', '1300.00', 'income'), 
('970', '2020-08-28', 'pid:00865', 'diagnosis', '180.00', 'income'), 
('971', '2020-08-28', 'pid:00866', 'diagnosis', '1300.00', 'income'), 
('972', '2020-08-28', 'pid:00867', 'diagnosis', '250.00', 'income'), 
('973', '2020-08-28', 'pid:00868', 'diagnosis', '600.00', 'income'), 
('974', '2020-08-28', 'pid:00869', 'diagnosis', '900.00', 'income'), 
('975', '2020-08-28', 'pid:00870', 'diagnosis', '1000.00', 'income'), 
('976', '2020-08-28', 'pid:00871', 'diagnosis', '100.00', 'income'), 
('977', '2020-08-28', 'pid:00872', 'diagnosis', '150.00', 'income'), 
('978', '2020-08-28', 'pid:00873', 'diagnosis', '100.00', 'income'), 
('979', '2020-08-28', 'pid:00874', 'diagnosis', '400.00', 'income'), 
('980', '2020-08-28', 'pid:00875', 'diagnosis', '350.00', 'income'), 
('981', '2020-08-28', 'pid:00876', 'diagnosis', '400.00', 'income'), 
('982', '2020-08-28', 'pid:00877', 'diagnosis', '350.00', 'income'), 
('983', '2020-08-28', 'pid:00878', 'diagnosis', '900.00', 'income'), 
('984', '2020-08-28', 'pid:00879', 'diagnosis', '2000.00', 'income'), 
('985', '2020-08-28', 'pid:00880', 'diagnosis', '800.00', 'income'), 
('986', '2020-08-28', 'pid:00881', 'diagnosis', '450.00', 'income'), 
('987', '2020-08-28', 'pid:00882', 'diagnosis', '100.00', 'income'), 
('988', '2020-08-28', 'pid:00883', 'diagnosis', '100.00', 'income'), 
('989', '2020-08-29', 'pid:00884', 'diagnosis', '1000.00', 'income'), 
('990', '2020-08-29', 'pid:00885', 'diagnosis', '400.00', 'income'), 
('991', '2020-08-29', 'pid:00886', 'diagnosis', '1300.00', 'income'), 
('992', '2020-08-29', 'pid:00887', 'diagnosis', '1400.00', 'income'), 
('993', '2020-08-29', 'pid:00888', 'diagnosis', '1700.00', 'income'), 
('994', '2020-08-29', 'pid:00889', 'diagnosis', '1000.00', 'income'), 
('995', '2020-08-29', 'pid:00890', 'diagnosis', '250.00', 'income'), 
('996', '2020-08-29', 'pid:00891', 'diagnosis', '750.00', 'income'), 
('997', '2020-08-30', 'pid:00892', 'diagnosis', '50.00', 'income'), 
('998', '2020-08-30', 'pid:00893', 'diagnosis', '50.00', 'income'), 
('999', '2020-08-30', 'pid:00894', 'diagnosis', '50.00', 'income'), 
('1000', '2020-08-30', 'pid:00895', 'diagnosis', '100.00', 'income'), 
('1001', '2020-08-30', 'pid:00896', 'diagnosis', '600.00', 'income'), 
('1002', '2020-08-30', 'pid:00897', 'diagnosis', '1500.00', 'income'), 
('1003', '2020-08-30', 'pid:00898', 'diagnosis', '1000.00', 'income'), 
('1004', '2020-08-30', 'pid:00899', 'diagnosis', '400.00', 'income'), 
('1005', '2020-08-30', 'pid:00900', 'diagnosis', '700.00', 'income'), 
('1006', '2020-08-30', 'pid:00901', 'diagnosis', '400.00', 'income'), 
('1007', '2020-08-30', 'pid:00902', 'diagnosis', '500.00', 'income'), 
('1008', '2020-08-30', 'pid:00903', 'diagnosis', '50.00', 'income'), 
('1009', '2020-08-30', 'pid:00904', 'diagnosis', '250.00', 'income'), 
('1010', '2020-08-30', 'pid:00905', 'diagnosis', '2050.00', 'income'), 
('1011', '2020-08-31', 'pid:00906', 'diagnosis', '50.00', 'income'), 
('1012', '2020-08-31', 'pid:00907', 'diagnosis', '450.00', 'income'), 
('1013', '2020-08-31', 'pid:00908', 'diagnosis', '100.00', 'income'), 
('1014', '2020-08-31', 'pid:00909', 'diagnosis', '2000.00', 'income'), 
('1015', '2020-08-31', 'pid:00910', 'diagnosis', '100.00', 'income'), 
('1016', '2020-08-31', 'pid:00911', 'diagnosis', '900.00', 'income'), 
('1017', '2020-08-31', 'pid:00912', 'diagnosis', '500.00', 'income'), 
('1018', '2020-08-31', 'pid:00913', 'diagnosis', '100.00', 'income'), 
('1019', '2020-08-31', 'pid:00914', 'diagnosis', '150.00', 'income'), 
('1020', '2020-09-01', 'pid:00915', 'diagnosis', '1500.00', 'income'), 
('1021', '2020-09-01', 'pid:00916', 'diagnosis', '50.00', 'income'), 
('1022', '2020-09-01', 'pid:00917', 'diagnosis', '300.00', 'income'), 
('1023', '2020-09-01', 'pid:00918', 'diagnosis', '150.00', 'income'), 
('1024', '2020-09-02', 'pid:00919', 'diagnosis', '600.00', 'income'), 
('1025', '2020-09-02', 'pid:00920', 'diagnosis', '350.00', 'income'), 
('1026', '2020-09-02', 'pid:00921', 'diagnosis', '350.00', 'income'), 
('1027', '2020-09-02', 'pid:00922', 'diagnosis', '100.00', 'income'), 
('1028', '2020-09-02', 'pid:00923', 'diagnosis', '400.00', 'income'), 
('1029', '2020-09-02', 'pid:00924', 'diagnosis', '1000.00', 'income'), 
('1030', '2020-09-02', 'pid:00925', 'diagnosis', '650.00', 'income'), 
('1031', '2020-09-02', 'pid:00926', 'diagnosis', '400.00', 'income'), 
('1032', '2020-09-02', 'pid:00927', 'diagnosis', '120.00', 'income'), 
('1033', '2020-09-02', 'pid:00928', 'diagnosis', '100.00', 'income'), 
('1034', '2020-09-02', 'pid:00929', 'diagnosis', '250.00', 'income'), 
('1035', '2020-09-02', 'pid:00930', 'diagnosis', '2000.00', 'income'), 
('1036', '2020-09-02', 'pid:00931', 'diagnosis', '1400.00', 'income'), 
('1037', '2020-09-02', 'pid:00932', 'diagnosis', '50.00', 'income'), 
('1038', '2020-09-02', 'pid:00933', 'diagnosis', '100.00', 'income'), 
('1039', '2020-09-02', 'pid:00934', 'diagnosis', '250.00', 'income'), 
('1040', '2020-09-02', 'pid:00935', 'diagnosis', '1600.00', 'income'), 
('1041', '2020-09-02', 'pid:00936', 'diagnosis', '90.00', 'income'), 
('1042', '2020-09-02', 'pid:00937', 'diagnosis', '50.00', 'income'), 
('1043', '2020-09-02', 'pid:00938', 'diagnosis', '100.00', 'income'), 
('1044', '2020-09-02', 'pid:00939', 'diagnosis', '46.00', 'income'), 
('1045', '2020-09-02', 'pid:00940', 'diagnosis', '100.00', 'income'), 
('1046', '2020-09-02', 'pid:00941', 'diagnosis', '700.00', 'income'), 
('1047', '2020-09-02', 'pid:00942', 'diagnosis', '220.00', 'income'), 
('1048', '2020-09-02', 'pid:00943', 'diagnosis', '70.00', 'income'), 
('1049', '2020-09-02', 'pid:00944', 'diagnosis', '250.00', 'income'), 
('1050', '2020-09-03', 'pid:00945', 'diagnosis', '200.00', 'income'), 
('1051', '2020-09-03', 'pid:00946', 'diagnosis', '1550.00', 'income'), 
('1052', '2020-09-03', 'pid:00947', 'diagnosis', '100.00', 'income'), 
('1053', '2020-09-03', 'pid:00948', 'diagnosis', '100.00', 'income');  



INSERT INTO `marketer` ( `id`, `create_at`, `name`, `mobile`, `commission`, `address`, `trash`, `img_url`) VALUES 
('2', '2018-07-10', 'ALAMIN DC', '01723926073', '5', ' MUKTAGACHA  MYMENSINGH', '0', 'rm628k9etre_79a.png'), 
('3', '2018-07-10', 'munzu', '01739591081', '', 'majibari.muktagacha', '0', 'k0a28mr8_eetr11.png'), 
('4', '2020-06-23', 'Md.Developer', '01748022626', '40', 'MKWRkyqDQD', '1', 'k72_4ertam67e0r.jpg'), 
('6', '2020-07-02', 'Arif', '01710121415', '5', 'sdgs', '0', 'eem53a261k_trr4.jpg'), 
('7', '2020-07-02', 'MD.KAMAL', '01733162661', '00', 'MUKTAGACHA', '0', 'k71t53mr0ear9_e.jpg'), 
('8', '2020-07-03', 'MD.MANIK', '01911736314', '', 'MUKTAGACHA', '0', 'e1751_0reartk4m.jpg'), 
('9', '2020-07-03', 'CHAIRMAN', '01715373844', '', 'JANNAT MADICAL', '0', '9t5mrea6e3r2_4k.jpg'), 
('10', '2020-07-03', 'MORZINA', '01712944431', '', 'ATANIBAJAR', '0', '_r8rmte6ea341k0.JPG'), 
('11', '2020-07-03', 'SANAULLAH', '01911549384', '', 'MADHA HISAR.MUKTAGACHA', '0', '5at1r3e1e7m4_kr.jpg'), 
('12', '2020-07-03', 'RONJON', '01710544386', '', 'OSTODAR. BAZAR', '0', 'e916kr3_ear2tm2.jpg'), 
('13', '2020-07-03', 'ANWAR', '01718315284', '', 'DOCTOR BARI MUR', '0', '3t_m4e662krera2.jpg'), 
('14', '2020-07-05', 'NASIMA APA', '01766261860', '', 'RAMBOD ROPUR.MUKTAGHA', '0', 'kae8r7r_4365tem.jpg'), 
('15', '2020-07-05', 'MADICARE', '01718320355', '', 'MUKTAGACHA', '0', '550e5at_e2rmkr7.jpg'), 
('16', '2020-07-05', 'Md.Developer', '01983667657', '10', 'Test', '0', ''), 
('17', '2020-07-05', 'AJIT', '01913687218', '', 'OSTADAR ', '0', 'er219rkm27ea4_t.jpg'), 
('18', '2020-07-05', 'xyz', '163854', '', 'পডয', '1', ''), 
('19', '2020-07-05', 'SELF', '000000', '', 'AL AMIN DC', '0', ''), 
('20', '2020-07-05', 'SELF', '000000', '', 'AL AMIN DC', '0', 'm_er5a2ter95k26.jpg'), 
('21', '2020-07-05', 'HIRA BAI', '01727546606', '', 'MUKTHAGACHA', '0', '27e3_m6te2ra7kr.jpg'), 
('22', '2020-07-06', 'SOLAIMAN', '01731089897', '', 'JONKA BAZAR', '0', 'e83_21reta7m9rk.jpg'), 
('23', '2020-07-06', 'MUJAMMEL', '01729931115', '', 'JAGORONY ', '0', 'e_29ake5mr4t43r.jpg'), 
('24', '2020-07-06', 'ASIS', '01720207673', '', 'MUKTAGACHA', '0', 't1_3e6a1rme1kr3.JPG'), 
('25', '2020-07-06', 'SAIFUL ISLAM', '01925346020', '', 'BIDAGONS BAZAR', '0', ''), 
('26', '2020-07-07', 'HABIB', '01930136910', '', 'KAMARAR BAZAR', '0', '0r39tra9em6_6ek.jpg'), 
('27', '2020-07-08', 'SHIHABUL ISLAM ', '01731179081', '', 'MUKTAGACHA', '0', '2mrt6e_8ake40r4.JPG'), 
('28', '2020-07-10', 'ZAMAN', '01720990336', '', 'MUKTAGACHA', '0', ''), 
('29', '2020-07-16', 'RUHOL AMIN', '000', '', 'MUK', '0', 'ek5ram45_ret036.jpg'), 
('30', '2020-07-16', 'Kormi', '00', '', 'muktagacha', '0', ''), 
('31', '2020-07-17', 'shobus farmasi', '000', '', 'muk', '0', '6ee5_4rkt9r2ma5.JPG'), 
('32', '2020-07-17', 'ZINNA', '01921057099', '', 'MUKTAGACHA', '0', 'et4r0e47k5a9r_m.jpg'), 
('33', '2020-07-19', 'Muksadul', '01842297256', '', 'JAMAN CLINIC', '0', ''), 
('34', '2020-07-19', 'SHORAB', '01719601886', '', 'RAMVHODROPUR', '0', 't29r1kem5a_8e8r.jpg'), 
('35', '2020-07-21', 'Manik', '000', '', 'MUK', '0', ''), 
('36', '2020-07-21', 'Parul', '00', '', 'Muktagacha', '0', ''), 
('37', '2020-07-22', 'test rf/pc', '01740121415', '0', 'gh', '0', ''), 
('38', '2020-07-23', ' MD ALI', '01997532873', '', 'MUKTAGACHA', '0', ''), 
('39', '2020-07-23', 'NUROLHOQ', '01833673435', '', 'JOYBANGLA BAZAR.MUKTAGACHA', '0', ''), 
('40', '2020-07-24', 'DK.SHAHA', '00', '', 'MUKTAGACHA', '0', ''), 
('41', '2020-07-24', 'Malek', '01925914076', '', 'Khamar Bazar Muktagacha', '0', ''), 
('42', '2020-07-24', 'NIKAS', '01989015195', '', 'ATPAKYA MUKTAGACHA', '0', ''), 
('43', '2020-07-24', 'Orjon', '00', '', 'OSTODAR', '0', ''), 
('44', '2020-07-25', 'PANKAJ KUMAR DAS', '00000000', '', 'MUK', '0', ''), 
('45', '2020-08-05', 'JOSHIM', '01914925911', '', 'MUK', '0', ''), 
('46', '2020-08-19', 'Test RF', '01748022626', '', 'sdf', '0', ''), 
('47', '2020-08-20', 'DR.FIROZ aHMED', '01717838018', '', 'TECMO MUKTAGACHA HELP COMPLEX', '0', ''), 
('48', '2020-08-28', 'd.mubarok', '01710551810', '', 'muktagacha', '0', ''), 
('49', '2020-08-28', 'D.KISNO', '01729847887', '', 'PIYAR POR', '0', ''), 
('50', '2020-08-28', 'D;FAZLUR HAQUE', '01772162646', '', 'BONDOPOLISIA', '0', ''), 
('51', '2020-08-29', 'D.Musaraf', '01409674708', '', 'Biddagong Bajar', '0', ''), 
('52', '2020-08-29', 'Hira', '', '', 'Muk', '0', ''), 
('53', '2020-08-30', 'Mukul', '', '', 'MUKTACHA', '0', ''), 
('54', '2020-09-02', 'D.SULTANA', '01926243956', '', 'MUK', '0', '');  



INSERT INTO `medicine` ( `id`, `product_name`, `product_code`, `product_cat`, `subcategory`, `purchase_price`, `sale_price`, `unit`, `status`) VALUES 
('1', 'Acicox 100mg', '005-0264-064', 'Capsule', 'ACI Limited', '10.00', '5.00', '100 mg', '005-0264-064'), 
('2', 'Napa 100mg', '005-0264-064', 'Capsule', 'ACI Limited', '10.00', '5.00', '100 mg', '005-0264-064'), 
('3', 'Acicox   100 mg', '005-0264-064', 'Capsule', 'ACI Limited', '0.00', '0.00', '100 mg', 'Celecoxib'), 
('4', 'Avlomox   250 mg', '005-0181-023', 'Capsule', 'ACI Limited', '3.45', '0.00', '250 mg', 'Amoxicillin'), 
('5', 'Avlomox   500 mg', '005-0258-23', 'Capsule', 'ACI Limited', '6.12', '0.00', '500 mg', 'Amoxicillin'), 
('6', 'Avlosef   250 mg', '005-0129-023', 'Capsule', 'ACI Limited', '8.02', '0.00', '250 mg', 'Cephradine'), 
('7', 'Avlosef   500 mg', '005-0130-23', 'Capsule', 'ACI Limited', '15.05', '0.00', '500 mg', 'Cephradine'), 
('8', 'Avloxin   250 mg', '005-0254-23', 'Capsule', 'ACI Limited', '0.00', '0.00', '250 mg', 'Cephalexin'), 
('9', 'Avloxin   500 mg', '005-0255-23', 'Capsule', 'ACI Limited', '10.57', '0.00', '500 mg', 'Cephalexin'), 
('10', 'Castin   375 mg', '005-0405-31', 'Capsule', 'ACI Limited', '2.52', '0.00', '375 mg', 'Carbocisteine'), 
('11', 'Cedril   500 mg', '005-0320-23', 'Capsule', 'ACI Limited', '12.09', '0.00', '500 mg', 'Cefadroxil'), 
('12', 'Cefim   200 mg', '005-0296-23', 'Capsule', 'ACI Limited', '35.11', '0.00', '200 mg', 'Cefixime'), 
('13', 'Cefdox      100 mg', '005-0336-23', 'Capsule', 'ACI Limited', '22.13', '0.00', '100 mg', 'Cefpodoxime'), 
('14', 'Fluclox    250 mg', '005-0142-23', 'Capsule', 'ACI Limited', '5.79', '0.00', '250 mg', 'Flucloxacillin'), 
('15', 'Fluclox    500 mg', '005-0259-23', 'Capsule', 'ACI Limited', '10.57', '0.00', '500 mg', 'Flucloxacillin'), 
('16', 'Impedox    100 mg', '005-0123-23', 'Capsule', 'ACI Limited', '2.17', '0.00', '100 mg', 'Doxycycline'), 
('17', 'Impetet   250 mg', '005-0022-23', 'Capsule', 'ACI Limited', '0.00', '0.00', '250 mg', 'Oxytetracycline'), 
('18', 'Ketron  SR    100 mg', '005-0418-64', 'Capsule', 'ACI Limited', '7.05', '0.00', '100 mg', 'Ketoprofen'), 
('19', 'Ketron  SR    200 mg', '005-0419-64', 'Capsule', 'ACI Limited', '10.07', '0.00', '200 mg', 'Ketoprofen'), 
('20', 'Lanz   15 mg', '005-0339-67', 'Capsule', 'ACI Limited', '3.03', '0.00', '15 mg', 'Lansoprazole'), 
('21', 'Lanz   30 mg', '005-0340-67', 'Capsule', 'ACI Limited', '5.04', '0.00', '30 mg', 'Lansoprazole'), 
('22', 'Lipigem   300 mg', '005-0421-61', 'Capsule', 'ACI Limited', '7.05', '0.00', '300 mg', 'Gemfibrozil'), 
('23', 'Odazyth   250 mg', '005-0233-23', 'Capsule', 'ACI Limited', '25.08', '0.00', '250 mg', 'Azithromycin'), 
('24', 'Xeldrin   10 mg', '005-0386-67', 'Capsule', 'ACI Limited', '2.02', '0.00', '10 mg', 'Omeprazole'), 
('25', 'Xeldrin      40 mg', '005-0319-67', 'Capsule', 'ACI Limited', '8.02', '0.00', '40 mg', 'Omeprazole'), 
('26', 'Tendia   50 mg', '005-0463-65', 'Capsule', 'ACI Limited', '7.55', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('27', 'Mobifen  SR    100 mg', '005-0573-64', 'Capsule', 'ACI Limited', '3.02', '0.00', '100 mg', 'Diclofenac Sodium'), 
('28', 'Brodil  SR   8 mg', '005-05184', 'Capsule', 'ACI Limited', '2.42', '0.00', '8 mg', 'Salbutamol'), 
('29', 'Inever  SR    40 mg', '005-0600-23', 'Capsule', 'ACI Limited', '0.00', '0.00', '40 mg', 'Propranolol Hydrochloride'), 
('30', 'Teolex  CR   300 mg', '005-06374', 'Capsule', 'ACI Limited', '3.52', '0.00', '300 mg', 'Theophylline'), 
('31', 'Teolex   400 mg', '005-06384', 'Capsule', 'ACI Limited', '4.25', '0.00', '400 mg', 'Theophylline'), 
('32', 'Mobifen  SR    75 mg', '005-0632-64', 'Capsule', 'ACI Limited', '2.52', '0.00', '75 mg', 'Diclofenac Sodium'), 
('33', 'Ambroxol  SR   75 mg', '005-063-31', 'Capsule', 'ACI Limited', '0.00', '0.00', '75 mg', 'Ambroxol'), 
('34', 'Anaxyl   250 mg', '005-06459', 'Capsule', 'ACI Limited', '0.00', '0.00', '250 mg', 'Tranexamic Acid'), 
('35', 'Gabarol      75 mg', '005-0644-046', 'Capsule', 'ACI Limited', '16.11', '0.00', '75 mg', 'Pregabalin'), 
('36', 'Gabarol      100 mg', '005-0643-046', 'Capsule', 'ACI Limited', '22.15', '0.00', '100 mg', 'Pregabalin'), 
('37', 'Gabarol      150 mg', '005-0642-046', 'Capsule', 'ACI Limited', '30.20', '0.00', '150 mg', 'Pregabalin'), 
('38', 'Pandeflu   75 mg', '005-0641-32', 'Capsule', 'ACI Limited', '151.02', '0.00', '75 mg', 'Oseltamivir'), 
('39', 'Cefim-3 DS   400 mg', '005-0670-23', 'Capsule', 'ACI Limited', '50.34', '0.00', '400 mg', 'Cefixime'), 
('40', 'Anaxyl0   500 mg', '005-06739', 'Capsule', 'ACI Limited', '15.11', '0.00', '500 mg', 'Tranexamic Acid'), 
('41', 'Abaclor   250 mg', '005-0689-23', 'Capsule', 'ACI Limited', '21.14', '0.00', '250 mg', 'Cefaclor'), 
('42', 'Abaclor0   500 mg', '005-0691-23', 'Capsule', 'ACI Limited', '40.27', '0.00', '500 mg', 'Cefaclor'), 
('43', 'Sasolin   400 mcg', '005-07019', 'Capsule', 'ACI Limited', '10.07', '0.00', '400 mcg', 'Tamsulosin Hydrochloride'), 
('44', 'Daclin   150 mg', '005-0781-23', 'Capsule', 'ACI Limited', '8.02', '0.00', '150 mg', 'Clindamycin'), 
('45', 'Soritec   25 mg', '005-0776-71', 'Capsule', 'ACI Limited', '85.26', '0.00', '25 mg', 'Acitretin'), 
('46', 'Gabarol   50 mg', '005-0788-046', 'Capsule', 'ACI Limited', '12.04', '0.00', '50 mg', 'Pregabalin'), 
('47', 'Soritec   10 mg', '005-0800-71', 'Capsule', 'ACI Limited', '45.14', '0.00', '10 mg', 'Acitretin'), 
('48', 'Daclin   300 mg', '005-0816-23', 'Capsule', 'ACI Limited', '15.05', '0.00', '300 mg', 'Clindamycin'), 
('49', 'Tizabate   200 mg', '005-0820-61', 'Capsule', 'ACI Limited', '7.02', '0.00', '200 mg', 'Fenofibrate'), 
('50', 'Esomep   20 mg', '005-0848-067', 'Capsule', 'ACI Limited', '7.02', '0.00', '20 mg', 'Esomeprazole'), 
('51', 'Esomep   40 mg', '005-0849-067', 'Capsule', 'ACI Limited', '9.03', '0.00', '40 mg', 'Esomeprazole'), 
('52', 'Flamex SR   300 mg', '005-0850-64', 'Capsule', 'ACI Limited', '4.01', '0.00', '300 mg', 'Ibuprofen'), 
('53', 'Gabarol   25 mg', '005-0872-046', 'Capsule', 'ACI Limited', '8.02', '0.00', '25 mg', 'Pregabalin'), 
('54', 'Amantril   100 mg', '59322', 'Capsule', 'ACI Limited', '10.00', '0.00', '100 mg', 'Amantadine Hydrochloride'), 
('55', 'Radola   100 mg', '5426', 'Capsule', 'ACI Limited', '6.00', '0.00', '100 mg', 'Racecadrotil'), 
('56', 'Ornical   120 mg', '543', 'Capsule', 'ACI Limited', '55.00', '0.00', '120 mg', 'Orlistat'), 
('57', 'Insaid   25 mg', '00556-64', 'Capsule', 'ACI Limited', '1.00', '0.00', '25 mg', 'Indomethacin'), 
('58', 'Insaid SR   75 mg', '00557-64', 'Capsule', 'ACI Limited', '0.00', '0.00', '75 mg', 'Indomethacin'), 
('59', 'Cefteria   400 mg', '00581-23', 'Capsule', 'ACI Limited', '120.00', '0.00', '400 mg', 'Ceftibuten'), 
('60', 'Chrocee   200 mg', '00588-32', 'Capsule', 'ACI Limited', '35.00', '0.00', '200 mg', 'Ribavirin'), 
('61', 'Paricel   20 mg', '005116-67', 'Capsule', 'ACI Limited', '8.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('62', 'Myrox SR   75 mg', '005-0633-031', 'Capsule', 'ACI Limited', '5.04', '0.00', '75 mg', 'Ambroxol'), 
('63', 'Hexitane   1 %', '005-0003-71', 'Cream', 'ACI Limited', '90.00', '0.00', '1 %', 'Chlorhexidine Gluconate'), 
('64', 'Sibalyn   1 %', '005-0708-23', 'Cream', 'ACI Limited', '40.12', '0.00', '1 %', 'Silver Sulphadiazine'), 
('65', 'Oralon   1 %', '005-0140-71', 'Gel', 'ACI Limited', '55.17', '0.00', '1 %', 'Chlorhexidine Gluconate'), 
('66', 'Acipillin   2 gm', '005-0218-077', 'Injection', 'ACI Limited', '50.00', '0.00', '2 gm', 'Ampicillin'), 
('67', 'Avlomox   250 mg', '005-0183-023', 'Injection', 'ACI Limited', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('68', 'Avlomox   500 mg', '005-0184-23', 'Injection', 'ACI Limited', '32.10', '0.00', '500 mg', 'Amoxicillin'), 
('69', 'Water For Injection   5 ml', '005-0189-79', 'Injection', 'ACI Limited', '0.00', '0.00', '5 ml', 'Water For Injection'), 
('70', 'Thiopen  IV   1 gm', '005-0575', 'Injection', 'ACI Limited', '100.68', '0.00', '1 gm', 'Thiopentone Sodium'), 
('71', 'Thiopen  IV   500 mg', '005-0576', 'Injection', 'ACI Limited', '70.05', '0.00', '500 mg', 'Thiopentone Sodium'), 
('72', 'Odazyth  IV   500 mg', '005-0625-23', 'Injection', 'ACI Limited', '251.69', '0.00', '500 mg', 'Azithromycin'), 
('73', 'Acigan   vet   5 gm', '005-0326-077', 'Injection', 'ACI Limited', '0.00', '0.00', '5 gm', 'Gentamicin'), 
('74', 'Acimox Vet   1 gm', '593-0985-023', 'Injection', 'ACI Limited', '56.06', '0.00', '1 gm', 'Amoxicillin'), 
('75', 'Relacsn   68 %', '005-0300-60', 'Oral Solution', 'ACI Limited', '65.45', '0.00', '68 %', 'Lactulose'), 
('76', 'Acemox   30 %', '005-0324-077', 'Powder', 'ACI Limited', '267.25', '0.00', '30 %', 'Amoxicillin'), 
('77', 'Mycogard Vet Oral Powder   45 %', '593-0999-077', 'Powder', 'ACI Limited', '1200.00', '0.00', '45 %', 'Tiamulin Hydrogen Fumerate'), 
('78', 'Lacticon Dispersible Granules   10 gm', '005111-60', 'Powder', 'ACI Limited', '25.00', '0.00', '10 gm', 'Lactitol'), 
('79', 'Anaflex   250 mg', '005-0389-64', 'Suppository', 'ACI Limited', '0.00', '0.00', '250 mg', 'Naproxen'), 
('80', 'Anaflex   500 mg', '005-0390-64', 'Suppository', 'ACI Limited', '0.00', '0.00', '500 mg', 'Naproxen'), 
('81', 'Mobiefn   12.5 mg', '005-0387-64', 'Suppository', 'ACI Limited', '9.00', '0.00', '12.5 mg', 'Diclofenac Sodium'), 
('82', 'Mobifen      50 mg', '005-0388-64', 'Suppository', 'ACI Limited', '15.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('83', 'Xcel   250 mg', '005-0392-006', 'Suppository', 'ACI Limited', '5.00', '0.00', '250 mg', 'Paracetamol'), 
('84', 'Xcel   125 mg', '005-0391-006', 'Suppository', 'ACI Limited', '4.00', '0.00', '125 mg', 'Paracetamol'), 
('85', 'Xcel0   500 mg', '00544-006', 'Suppository', 'ACI Limited', '8.00', '0.00', '500 mg', 'Paracetamol'), 
('86', 'Mobifen   25 mg', '00545-64', 'Suppository', 'ACI Limited', '12.00', '0.00', '25 mg', 'Diclofenac Sodium'), 
('87', 'Sapotor.15 Suppository   1.15 gm', '00564-60', 'Suppository', 'ACI Limited', '3.00', '0.00', '1.15 gm', 'Glycerol'), 
('88', 'Sapotor.30 Suppository   2.3 gm', '00565-60', 'Suppository', 'ACI Limited', '5.00', '0.00', '2.3 gm', 'Glycerol'), 
('89', 'Acical   1250 mg', '005-0297-62', 'Tablet', 'ACI Limited', '4.01', '0.00', '1250 mg', 'Calcium Carbonate'), 
('90', 'Aciflox      200 mg', '005-0262-23', 'Tablet', 'ACI Limited', '12.00', '0.00', '200 mg', 'Sparfloxacin'), 
('91', 'Aciprin  CV    75 mg', '005-0278-26', 'Tablet', 'ACI Limited', '0.39', '0.00', '75 mg', 'Aspirin'), 
('92', 'Acira   4 mg', '005-0394-21', 'Tablet', 'ACI Limited', '0.30', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('93', 'Acitrin   10 mg', '005-0202-21', 'Tablet', 'ACI Limited', '3.01', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('94', 'Amotrex      200 mg', '005-0111-27', 'Tablet', 'ACI Limited', '0.69', '0.00', '200 mg', 'Metronidazole'), 
('95', 'Amotrex   400 mg', '005-0112-27', 'Tablet', 'ACI Limited', '1.27', '0.00', '400 mg', 'Metronidazole'), 
('96', 'Amotrex  DS   800 mg', '005-0375-27', 'Tablet', 'ACI Limited', '2.02', '0.00', '800 mg', 'Metronidazole'), 
('97', 'Anaflex   500 mg', '005-0145-64', 'Tablet', 'ACI Limited', '9.06', '0.00', '500 mg', 'Naproxen'), 
('98', 'Xcel   500 mg', '005-0071-006', 'Tablet', 'ACI Limited', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('99', 'Avloquin   250 mg', '005-0001-24', 'Tablet', 'ACI Limited', '1.22', '0.00', '250 mg', 'Chloroquine Phosphate'), 
('100', 'Buterol   10 mg', '005-03994', 'Tablet', 'ACI Limited', '1.51', '0.00', '10 mg', 'Bambuterol Hydrochloride'), 
('101', 'Buterol      20 mg', '005-04004', 'Tablet', 'ACI Limited', '3.02', '0.00', '20 mg', 'Bambuterol Hydrochloride'), 
('102', 'Brodil   2 mg', '005-01084', 'Tablet', 'ACI Limited', '0.26', '0.00', '2 mg', 'Salbutamol'), 
('103', 'Brodil   4 mg', '005-01094', 'Tablet', 'ACI Limited', '0.46', '0.00', '4 mg', 'Salbutamol'), 
('104', 'Colik   10 mg', '005-03631', 'Tablet', 'ACI Limited', '3.45', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('105', 'Cab      5 mg', '005-0251-022', 'Tablet', 'ACI Limited', '5.02', '0.00', '5 mg', 'Amlodipine'), 
('106', 'Canazole      150 mg', '005-0231', 'Tablet', 'ACI Limited', '22.15', '0.00', '150 mg', 'Fluconazole'), 
('107', 'Canazole      50 mg', '005-0230', 'Tablet', 'ACI Limited', '8.05', '0.00', '50 mg', 'Fluconazole'), 
('108', 'Cefdox      200 mg', '005-0433-23', 'Tablet', 'ACI Limited', '42.29', '0.00', '200 mg', 'Cefpodoxime'), 
('109', 'Celofen   100 mg', '005-0420-64', 'Tablet', 'ACI Limited', '4.01', '0.00', '100 mg', 'Aceclofenac'), 
('110', 'Ceplep      200 mg', '005-0358-046', 'Tablet', 'ACI Limited', '4.03', '0.00', '200 mg', 'Carbamazepine'), 
('111', 'Cerox A     250 mg', '005-0330-23', 'Tablet', 'ACI Limited', '25.17', '0.00', '250 mg', 'Cefuroxime'), 
('112', 'Cerox A   125 mg', '005-0329-23', 'Tablet', 'ACI Limited', '15.11', '0.00', '125 mg', 'Cefuroxime'), 
('113', 'Chear      25 mg', '005-02744', 'Tablet', 'ACI Limited', '3.02', '0.00', '25 mg', 'Sertraline'), 
('114', 'Chear      50 mg', '005-02674', 'Tablet', 'ACI Limited', '6.04', '0.00', '50 mg', 'Sertraline'), 
('115', 'Clorel      75 mg', '005-0316-26', 'Tablet', 'ACI Limited', '12.04', '0.00', '75 mg', 'Clopidogrel'), 
('116', 'Deslorin   5 mg', '005-0305-21', 'Tablet', 'ACI Limited', '2.51', '0.00', '5 mg', 'Desloratadine'), 
('117', 'Dexcor   .5 mg', '005-0354-72', 'Tablet', 'ACI Limited', '0.45', '0.00', '.5 mg', 'Dexamethasone'), 
('118', 'Drovin      40 mg', '005-03451', 'Tablet', 'ACI Limited', '1.77', '0.00', '40 mg', 'Drotaverine Hydrochloride'), 
('119', 'Esomep      40 mg', '005-0384-67', 'Tablet', 'ACI Limited', '8.02', '0.00', '40 mg', 'Esomeprazole'), 
('120', 'Esomep      20 mg', '005-0342-067', 'Tablet', 'ACI Limited', '5.02', '0.00', '20 mg', 'Esomeprazole'), 
('121', 'Etrax   40 mg', '005-0057-8', 'Tablet', 'ACI Limited', '1.00', '0.00', '40 mg', 'Levamisole'), 
('122', 'Ezolid   600 mg', '005-0397-023', 'Tablet', 'ACI Limited', '85.00', '0.00', '600 mg', 'Linezolid'), 
('123', 'Ezolid   400 mg', '005-0396-023', 'Tablet', 'ACI Limited', '60.00', '0.00', '400 mg', 'Linezolid'), 
('124', 'Flamex   400 mg', '005-0118-64', 'Tablet', 'ACI Limited', '1.43', '0.00', '400 mg', 'Ibuprofen'), 
('125', 'Flamex      200 mg', '005-0117-64', 'Tablet', 'ACI Limited', '0.00', '0.00', '200 mg', 'Ibuprofen'), 
('126', 'Floxabid   250 mg', '005-0132-23', 'Tablet', 'ACI Limited', '8.56', '0.00', '250 mg', 'Ciprofloxacin'), 
('127', 'Floxabid   500 mg', '005-0212-23', 'Tablet', 'ACI Limited', '15.05', '0.00', '500 mg', 'Ciprofloxacin'), 
('128', 'Floxabid   750 mg', '005-0351-23', 'Tablet', 'ACI Limited', '18.12', '0.00', '750 mg', 'Ciprofloxacin'), 
('129', 'Fluver   10 mg', '005-04307', 'Tablet', 'ACI Limited', '5.02', '0.00', '10 mg', 'Flunarizine'), 
('130', 'Fluver      5 mg', '005-04297', 'Tablet', 'ACI Limited', '3.51', '0.00', '5 mg', 'Flunarizine'), 
('131', 'Fulcinex   500 mg', '005-0062', 'Tablet', 'ACI Limited', '5.60', '0.00', '500 mg', 'Griseofulvin'), 
('132', 'Glimirid   1 mg', '005-0275', 'Tablet', 'ACI Limited', '4.51', '0.00', '1 mg', 'Glimepiride'), 
('133', 'Glimirid   2 mg', '005-0276', 'Tablet', 'ACI Limited', '8.02', '0.00', '2 mg', 'Glimepiride'), 
('134', 'Hypnoclone   7.5 mg', '005-0279-057', 'Tablet', 'ACI Limited', '4.03', '0.00', '7.5 mg', 'Zopiclone'), 
('135', 'Indever   10 mg', '005-0037-23', 'Tablet', 'ACI Limited', '0.51', '0.00', '10 mg', 'Propranolol Hydrochloride'), 
('136', 'Indever      40 mg', '005-0038-23', 'Tablet', 'ACI Limited', '1.50', '0.00', '40 mg', 'Propranolol Hydrochloride'), 
('137', 'Isart      150 mg', '005-0322-22', 'Tablet', 'ACI Limited', '9.06', '0.00', '150 mg', 'Irbesartan'), 
('138', 'Karvedil      25 mg', '005-0273-22', 'Tablet', 'ACI Limited', '8.05', '0.00', '25 mg', 'Carvedilol'), 
('139', 'Karvedil   12.5 mg', '005-0432-22', 'Tablet', 'ACI Limited', '4.03', '0.00', '12.5 mg', 'Carvedilol'), 
('140', 'Karvedil   6.25 mg', '005-0272-22', 'Tablet', 'ACI Limited', '3.02', '0.00', '6.25 mg', 'Carvedilol'), 
('141', 'Minolac   10 mg', '005-0355-064', 'Tablet', 'ACI Limited', '10.07', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('142', 'Ketron      50 mg', '005-0352-64', 'Tablet', 'ACI Limited', '3.52', '0.00', '50 mg', 'Ketoprofen'), 
('143', 'Leflox   500 mg', '005-0310-23', 'Tablet', 'ACI Limited', '15.11', '0.00', '500 mg', 'Levofloxacin'), 
('144', 'Rosatan      50 mg', '005-0346-022', 'Tablet', 'ACI Limited', '6.04', '0.00', '50 mg', 'Losartan Potassium'), 
('145', 'Lozide   80 mg', '005-0295', 'Tablet', 'ACI Limited', '7.02', '0.00', '80 mg', 'Gliclazide'), 
('146', 'Meflon   250 mg', '005-0435-24', 'Tablet', 'ACI Limited', '39.61', '0.00', '250 mg', 'Mefloquine'), 
('147', 'Metform   850 mg', '005-0293', 'Tablet', 'ACI Limited', '4.51', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('148', 'Metform   500 mg', '005-0294', 'Tablet', 'ACI Limited', '5.02', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('149', 'Mobifen      25 mg', '005-0137-64', 'Tablet', 'ACI Limited', '0.00', '0.00', '25 mg', 'Diclofenac Sodium'), 
('150', 'Mobifen      50 mg', '005-0138-64', 'Tablet', 'ACI Limited', '0.88', '0.00', '50 mg', 'Diclofenac Sodium'), 
('151', 'Moniten      20 mg', '005-0203', 'Tablet', 'ACI Limited', '1.42', '0.00', '20 mg', 'Isosorbide Mononitrate'), 
('152', 'Nortyl      25 mg', '005-03654', 'Tablet', 'ACI Limited', '0.00', '0.00', '25 mg', 'Nortriptyline'), 
('153', 'Novatac      20 mg', '005-01785', 'Tablet', 'ACI Limited', '2.27', '0.00', '20 mg', 'Famotidine'), 
('154', 'Novatac      40 mg', '005-01795', 'Tablet', 'ACI Limited', '4.13', '0.00', '40 mg', 'Famotidine'), 
('155', 'Nutrivit E     200 mg', '005-0156-78', 'Tablet', 'ACI Limited', '3.82', '0.00', '200 mg', 'Vitamin E'), 
('156', 'Nutrivit C     250 mg', '005-0155-78', 'Tablet', 'ACI Limited', '1.32', '0.00', '250 mg', 'Vitamin C'), 
('157', 'Odazyth   500 mg', '005-0257-23', 'Tablet', 'ACI Limited', '35.11', '0.00', '500 mg', 'Azithromycin'), 
('158', 'Omeflox   400 mg', '005-0368-23', 'Tablet', 'ACI Limited', '15.11', '0.00', '400 mg', 'Lomefloxacin'), 
('159', 'Osetron   8 mg', '005-03718', 'Tablet', 'ACI Limited', '10.07', '0.00', '8 mg', 'Ondansetron'), 
('160', 'Pantex      20 mg', '005-0341-67', 'Tablet', 'ACI Limited', '5.02', '0.00', '20 mg', 'Pantoprazole'), 
('161', 'Pantex   40 mg', '005-0377-67', 'Tablet', 'ACI Limited', '7.02', '0.00', '40 mg', 'Pantoprazole'), 
('162', 'Pevil   22.7 mg', '005-0359-21', 'Tablet', 'ACI Limited', '0.46', '0.00', '22.7 mg', 'Pheniramine Maleate'), 
('163', 'Progic      25 mg', '005-0373-21', 'Tablet', 'ACI Limited', '0.00', '0.00', '25 mg', 'Promethazine Hydrochloride'), 
('164', 'Prosma   1 mg', '005-0205-21', 'Tablet', 'ACI Limited', '2.01', '0.00', '1 mg', 'Ketotifen'), 
('165', 'Recol   10 mg', '005-0266-61', 'Tablet', 'ACI Limited', '10.07', '0.00', '10 mg', 'Simvastatin'), 
('166', 'Reversair   10 mg', '005-0315-044', 'Tablet', 'ACI Limited', '15.11', '0.00', '10 mg', 'Montelukast'), 
('167', 'Sedzam   10 mg', '005-03326', 'Tablet', 'ACI Limited', '2.82', '0.00', '10 mg', 'Clobazam'), 
('168', 'Sezol  DS   1 gm', '005-0236-27', 'Tablet', 'ACI Limited', '17.05', '0.00', '1 gm', 'Secnidazole'), 
('169', 'Sintel      200 mg', '005-0134-008', 'Tablet', 'ACI Limited', '0.00', '0.00', '200 mg', 'Albendazole'), 
('170', 'Sintel   400 mg', '005-0207-008', 'Tablet', 'ACI Limited', '5.02', '0.00', '400 mg', 'Albendazole'), 
('171', 'Stril      5 mg', '005-0248-22', 'Tablet', 'ACI Limited', '3.02', '0.00', '5 mg', 'Lisinopril'), 
('172', 'Stril   10 mg', '005-0249-22', 'Tablet', 'ACI Limited', '0.00', '0.00', '10 mg', 'Lisinopril'), 
('173', 'Tenoren      100 mg', '005-0056-22', 'Tablet', 'ACI Limited', '1.38', '0.00', '100 mg', 'Atenolol'), 
('174', 'Tenoren      50 mg', '005-0060-22', 'Tablet', 'ACI Limited', '0.77', '0.00', '50 mg', 'Atenolol'), 
('175', 'Tivit      100 mg', '005-0357-78', 'Tablet', 'ACI Limited', '0.75', '0.00', '100 mg', 'Thiamine Hydrochloride'), 
('176', 'Xantid      150 mg', '005-01265', 'Tablet', 'ACI Limited', '2.51', '0.00', '150 mg', 'Ranitidine'), 
('177', 'Xantid  HS   300 mg', '005-01315', 'Tablet', 'ACI Limited', '4.03', '0.00', '300 mg', 'Ranitidine'), 
('178', 'Xytrex   10 mg', '005-0277-28', 'Tablet', 'ACI Limited', '4.53', '0.00', '10 mg', 'Olanzapine'), 
('179', 'Zepam   3 mg', '005-03337', 'Tablet', 'ACI Limited', '5.02', '0.00', '3 mg', 'Bromazepam'), 
('180', 'Tynium   50 mg', '005-04721', 'Tablet', 'ACI Limited', '6.02', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('181', 'Anaflex  SR   500 mg', '005-0470-64', 'Tablet', 'ACI Limited', '14.09', '0.00', '500 mg', 'Naproxen'), 
('182', 'Diverin   10 mg', '005-04601', 'Tablet', 'ACI Limited', '2.02', '0.00', '10 mg', 'Dicycloverine Hydrochloride'), 
('183', 'Paricel      20 mg', '005-0286-67', 'Tablet', 'ACI Limited', '5.04', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('184', 'Tizadin   2 mg', '005-0311-70', 'Tablet', 'ACI Limited', '5.04', '0.00', '2 mg', 'Tizanidine'), 
('185', 'Lamitrin   50 mg', '005-0312-046', 'Tablet', 'ACI Limited', '18.05', '0.00', '50 mg', 'Lamotrigine'), 
('186', 'Atasin   10 mg', '005-0361-061', 'Tablet', 'ACI Limited', '10.07', '0.00', '10 mg', 'Atorvastatin'), 
('187', 'Vave   10 mg', '005-02898', 'Tablet', 'ACI Limited', '2.02', '0.00', '10 mg', 'Domperidone'), 
('188', 'Rosatan      25 mg', '005-0369-022', 'Tablet', 'ACI Limited', '3.52', '0.00', '25 mg', 'Losartan Potassium'), 
('189', 'Erythin   500 mg', '005-0446-23', 'Tablet', 'ACI Limited', '8.06', '0.00', '500 mg', 'Erythromycin'), 
('190', 'Inosit   500 mg', '005-0450', 'Tablet', 'ACI Limited', '5.04', '0.00', '500 mg', 'Inositol'), 
('191', 'Inosit   750 mg', '005-0451', 'Tablet', 'ACI Limited', '7.55', '0.00', '750 mg', 'Inositol'), 
('192', 'Skinabin   250 mg', '005-0281', 'Tablet', 'ACI Limited', '40.27', '0.00', '250 mg', 'Terbinafine'), 
('193', 'Solone      5 mg', '005-0458-72', 'Tablet', 'ACI Limited', '1.72', '0.00', '5 mg', 'Prednisolone'), 
('194', 'Solone      20 mg', '005-0459-72', 'Tablet', 'ACI Limited', '4.00', '0.00', '20 mg', 'Prednisolone'), 
('195', 'Demarin   600 mg', '005-0506-64', 'Tablet', 'ACI Limited', '7.05', '0.00', '600 mg', 'Oxaprozin'), 
('196', 'Rolage   60 mg', '005-05028', 'Tablet', 'ACI Limited', '10.07', '0.00', '60 mg', 'Raloxifene Hydrochloride'), 
('197', 'Diar   500 mg', '005-0578-27', 'Tablet', 'ACI Limited', '10.07', '0.00', '500 mg', 'Nitazoxanide'), 
('198', 'Canider   10 mg', '005-0579-22', 'Tablet', 'ACI Limited', '5.04', '0.00', '10 mg', 'Lercanidipine Hydrochloride'), 
('199', 'Coxia   90 mg', '005-0581-64', 'Tablet', 'ACI Limited', '12.09', '0.00', '90 mg', 'Etoricoxib'), 
('200', 'Coxia   60 mg', '005-0582-64', 'Tablet', 'ACI Limited', '7.05', '0.00', '60 mg', 'Etoricoxib'), 
('201', 'Abetis      20 mg', '005-0587-22', 'Tablet', 'ACI Limited', '8.05', '0.00', '20 mg', 'Olmesartan Medoxomil'), 
('202', 'Motoral      20 mg', '005-0590-64', 'Tablet', 'ACI Limited', '5.04', '0.00', '20 mg', 'Leflunomide'), 
('203', 'Motoral      100 mg', '005-0591-64', 'Tablet', 'ACI Limited', '20.13', '0.00', '100 mg', 'Leflunomide'), 
('204', 'Coxia20   120 mg', '005-0580-64', 'Tablet', 'ACI Limited', '14.09', '0.00', '120 mg', 'Etoricoxib'), 
('205', 'Abetis      40 mg', '005-0588-22', 'Tablet', 'ACI Limited', '15.11', '0.00', '40 mg', 'Olmesartan Medoxomil'), 
('206', 'Natrilex  SR +   1.5 mg', '005-04652', 'Tablet', 'ACI Limited', '8.86', '0.00', '1.5 mg', 'Indapamide'), 
('207', 'Meba   135 mg', '005-05521', 'Tablet', 'ACI Limited', '0.00', '0.00', '135 mg', 'Mebeverine Hydrochloride'), 
('208', 'Xcel   DISPERSABLE   120 mg', '005-0559-006', 'Tablet', 'ACI Limited', '1.28', '0.00', '120 mg', 'Paracetamol'), 
('209', 'Meflon   PLUS   250 mg', '005-0569-24', 'Tablet', 'ACI Limited', '0.00', '0.00', '250 mg', 'Mefloquine'), 
('210', 'Dicarmin      100 mg', '005-0543-8', 'Tablet', 'ACI Limited', '0.00', '0.00', '100 mg', 'Diethylcarbamazine Citrate'), 
('211', 'Tenoren      25 mg', '005-0524-22', 'Tablet', 'ACI Limited', '0.45', '0.00', '25 mg', 'Atenolol'), 
('212', 'Diverin   20 mg', '005-05251', 'Tablet', 'ACI Limited', '3.52', '0.00', '20 mg', 'Dicycloverine Hydrochloride'), 
('213', 'Brodil Levo   1 mg', '005-05314', 'Tablet', 'ACI Limited', '1.10', '0.00', '1 mg', 'Levosalbutamol'), 
('214', 'Brodil Levo   2 mg', '005-05324', 'Tablet', 'ACI Limited', '0.00', '0.00', '2 mg', 'Levosalbutamol'), 
('215', 'Flamex      200 mg', '005-0534-64', 'Tablet', 'ACI Limited', '0.88', '0.00', '200 mg', 'Dexibuprofen (S Ibuprofen)'), 
('216', 'Flamex0   300 mg', '005-0535-64', 'Tablet', 'ACI Limited', '0.00', '0.00', '300 mg', 'Dexibuprofen (S Ibuprofen)'), 
('217', 'Flamex  DX   400 mg', '005-0536-64', 'Tablet', 'ACI Limited', '5.04', '0.00', '400 mg', 'Dexibuprofen (S Ibuprofen)'), 
('218', 'Clonium   .5 mg', '005-0515-046', 'Tablet', 'ACI Limited', '4.01', '0.00', '.5 mg', 'Clonazepam'), 
('219', 'Clonium   2 mg', '005-0516-046', 'Tablet', 'ACI Limited', '6.02', '0.00', '2 mg', 'Clonazepam'), 
('220', 'Veratin   6 mg', '005-0505-8', 'Tablet', 'ACI Limited', '0.00', '0.00', '6 mg', 'Ivermectin'), 
('221', 'Probis   5 mg', '005-0493-22', 'Tablet', 'ACI Limited', '10.03', '0.00', '5 mg', 'Bisoprolol Hemifumarate'), 
('222', 'Alaclov   500 mg', '005-0495-32', 'Tablet', 'ACI Limited', '40.27', '0.00', '500 mg', 'Valacyclovir'), 
('223', 'Leflox   750 mg', '005-0599-23', 'Tablet', 'ACI Limited', '20.13', '0.00', '750 mg', 'Levofloxacin'), 
('224', 'Bipinor   2.5 mg', '005-0636-22', 'Tablet', 'ACI Limited', '5.04', '0.00', '2.5 mg', 'Nebivolol'), 
('225', 'Cerox A    500 mg', '005-0484-23', 'Tablet', 'ACI Limited', '45.31', '0.00', '500 mg', 'Cefuroxime'), 
('226', 'Progil      50 mg', '005-0486', 'Tablet', 'ACI Limited', '0.00', '0.00', '50 mg', 'Voriconazole'), 
('227', 'Phyton   .5 mg', '005-0487-78', 'Tablet', 'ACI Limited', '4.03', '0.00', '.5 mg', 'Mecobalamin'), 
('228', 'Acron   200 mcg', '005-0488-65', 'Tablet', 'ACI Limited', '10.07', '0.00', '200 mcg', 'Buprenorphine'), 
('229', 'Nortyl   10 mg', '005-03644', 'Tablet', 'ACI Limited', '0.00', '0.00', '10 mg', 'Nortriptyline'), 
('230', 'Oxicam      20 mg', '005-0539-64', 'Tablet', 'ACI Limited', '8.05', '0.00', '20 mg', 'Tanoxicam'), 
('231', 'Colik      20 mg', '005-05971', 'Tablet', 'ACI Limited', '6.72', '0.00', '20 mg', 'Hyoscine Butyl Bromide'), 
('232', 'Atasin      20 mg', '005-0611-061', 'Tablet', 'ACI Limited', '18.12', '0.00', '20 mg', 'Atorvastatin'), 
('233', 'Bipinor   5 mg', '005-0491-22', 'Tablet', 'ACI Limited', '8.05', '0.00', '5 mg', 'Nebivolol'), 
('234', 'Teviral   1 mg', '005-0623-32', 'Tablet', 'ACI Limited', '100.30', '0.00', '1 mg', 'Entecavir'), 
('235', 'Teviral   .5 mg', '005-0624-32', 'Tablet', 'ACI Limited', '48.32', '0.00', '.5 mg', 'Entecavir'), 
('236', 'Mastel  MR   10 mg', '005-0627-21', 'Tablet', 'ACI Limited', '6.52', '0.00', '10 mg', 'Mizolastine'), 
('237', 'Ketron D   25 mg', '005-0659-64', 'Tablet', 'ACI Limited', '4.03', '0.00', '25 mg', 'Dexketoprofen'), 
('238', 'Reversair      5 mg', '005-0658-044', 'Tablet', 'ACI Limited', '8.05', '0.00', '5 mg', 'Montelukast'), 
('239', 'Reversair   4 mg', '005-0657-044', 'Tablet', 'ACI Limited', '7.05', '0.00', '4 mg', 'Montelukast'), 
('240', 'Artica   10 mg', '005-0656-21', 'Tablet', 'ACI Limited', '1.25', '0.00', '10 mg', 'Hydroxyzine Hydrochloride'), 
('241', 'Artica   25 mg', '005-0655-21', 'Tablet', 'ACI Limited', '2.01', '0.00', '25 mg', 'Hydroxyzine Hydrochloride'), 
('242', 'Dispazinc Dispersible   20 mg', '005-0648-62', 'Tablet', 'ACI Limited', '2.01', '0.00', '20 mg', 'Zinc'), 
('243', 'Acuten   30 mg', '005-0640-006', 'Tablet', 'ACI Limited', '3.02', '0.00', '30 mg', 'Nefopam Hydrochloride'), 
('244', 'Diatag F/C   15 mg', '005-0664', 'Tablet', 'ACI Limited', '8.05', '0.00', '15 mg', 'Pioglitazone'), 
('245', 'Pactorin Retard   2.6 mg', '005-0669', 'Tablet', 'ACI Limited', '4.03', '0.00', '2.6 mg', 'Glyceryl Trinitrate'), 
('246', 'Alaron   10 mg', '005-0671-21', 'Tablet', 'ACI Limited', '2.50', '0.00', '10 mg', 'Loratadine'), 
('247', 'Remaquin   15 mg', '005-0674-24', 'Tablet', 'ACI Limited', '1.51', '0.00', '15 mg', 'Primaquine'), 
('248', 'Citazar0   1000 mg', '005-0682-046', 'Tablet', 'ACI Limited', '0.00', '0.00', '1000 mg', 'Levetiracetam'), 
('249', 'Citazar0   750 mg', '005-0681-046', 'Tablet', 'ACI Limited', '0.00', '0.00', '750 mg', 'Levetiracetam'), 
('250', 'Citazar0   500 mg', '005-0680-046', 'Tablet', 'ACI Limited', '25.17', '0.00', '500 mg', 'Levetiracetam'), 
('251', 'Citazar   250 mg', '005-0679-046', 'Tablet', 'ACI Limited', '15.11', '0.00', '250 mg', 'Levetiracetam'), 
('252', 'Abetis   10 mg', '005-0678-22', 'Tablet', 'ACI Limited', '5.04', '0.00', '10 mg', 'Olmesartan Medoxomil'), 
('253', 'Odazyth   250 mg', '005-0690-23', 'Tablet', 'ACI Limited', '0.00', '0.00', '250 mg', 'Azithromycin'), 
('254', 'Conart   1 mg', '005-06942', 'Tablet', 'ACI Limited', '5.02', '0.00', '1 mg', 'Bumetanide'), 
('255', 'Diaset   25 mg', '005-0703', 'Tablet', 'ACI Limited', '10.07', '0.00', '25 mg', 'Miglitol'), 
('256', 'Diaset   50 mg', '005-0704', 'Tablet', 'ACI Limited', '15.11', '0.00', '50 mg', 'Miglitol'), 
('257', 'Diaset   100 mg', '005-0705', 'Tablet', 'ACI Limited', '0.00', '0.00', '100 mg', 'Miglitol'), 
('258', 'Liorel   10 mg', '005-0706-70', 'Tablet', 'ACI Limited', '8.05', '0.00', '10 mg', 'Baclofen'), 
('259', 'Liorel   25 mg', '005-0707-70', 'Tablet', 'ACI Limited', '0.00', '0.00', '25 mg', 'Baclofen'), 
('260', 'Parixol   700 mcg', '005-0698-025', 'Tablet', 'ACI Limited', '0.00', '0.00', '700 mcg', 'Pramipexol'), 
('261', 'Parixol   180 mcg', '005-0699-025', 'Tablet', 'ACI Limited', '6.04', '0.00', '180 mcg', 'Pramipexol'), 
('262', 'Parixol   88 mcg', '005-0700-025', 'Tablet', 'ACI Limited', '3.01', '0.00', '88 mcg', 'Pramipexol'), 
('263', 'Liorel   5 mg', '005-0713-70', 'Tablet', 'ACI Limited', '4.53', '0.00', '5 mg', 'Baclofen'), 
('264', 'Remophos   667 mg', '005-0224-62', 'Tablet', 'ACI Limited', '6.02', '0.00', '667 mg', 'Calcium Acetate'), 
('265', 'Cartine   330 mg', '005-0718', 'Tablet', 'ACI Limited', '5.04', '0.00', '330 mg', 'Levocarnitine'), 
('266', 'Antial   4 mg', '005-0728-037', 'Tablet', 'ACI Limited', '12.09', '0.00', '4 mg', 'Galantamine'), 
('267', 'Antial   8 mg', '005-0729-037', 'Tablet', 'ACI Limited', '20.14', '0.00', '8 mg', 'Galantamine'), 
('268', 'Antial   12 mg', '005-0730-025', 'Tablet', 'ACI Limited', '30.20', '0.00', '12 mg', 'Galantamine'), 
('269', 'Chear   100 mg', '005-07314', 'Tablet', 'ACI Limited', '10.07', '0.00', '100 mg', 'Sertraline'), 
('270', 'Ritch   120 mg', '005-0732-21', 'Tablet', 'ACI Limited', '7.05', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('271', 'Ritch   180 mg', '005-0733-21', 'Tablet', 'ACI Limited', '9.06', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('272', 'Acitrin-L   5 mg', '005-0737-21', 'Tablet', 'ACI Limited', '3.01', '0.00', '5 mg', 'Levocetirizine Hydrochloride'), 
('273', 'Ritch   60 mg', '005-0744-21', 'Tablet', 'ACI Limited', '5.04', '0.00', '60 mg', 'Fexofenadine Hydrochloride'), 
('274', 'Sodival   200 mg', '005-07456', 'Tablet', 'ACI Limited', '2.52', '0.00', '200 mg', 'Sodium Valproate'), 
('275', 'Tyrodin   30 mg', '005-0739-62', 'Tablet', 'ACI Limited', '45.31', '0.00', '30 mg', 'Cinacalcet'), 
('276', 'Tyrodin   60 mg', '005-0740-62', 'Tablet', 'ACI Limited', '0.00', '0.00', '60 mg', 'Cinacalcet'), 
('277', 'Tyrodin   90 mg', '005-0741-62', 'Tablet', 'ACI Limited', '0.00', '0.00', '90 mg', 'Cinacalcet'), 
('278', 'Xytrex   5 mg', '005-0742-28', 'Tablet', 'ACI Limited', '2.52', '0.00', '5 mg', 'Olanzapine'), 
('279', 'Inclaud   100 mg', '005-0755-36', 'Tablet', 'ACI Limited', '10.00', '0.00', '100 mg', 'Cilostazol'), 
('280', 'Nutrivit C   500 mg', '005-0758-78', 'Tablet', 'ACI Limited', '9.03', '0.00', '500 mg', 'Vitamin C'), 
('281', 'Nutrivit C   1 gm', '005-0759-78', 'Tablet', 'ACI Limited', '12.04', '0.00', '1 gm', 'Vitamin C'), 
('282', 'Parotin   20 mg', '005-07614', 'Tablet', 'ACI Limited', '10.07', '0.00', '20 mg', 'Paroxetine'), 
('283', 'Parotin   10 mg', '005-07604', 'Tablet', 'ACI Limited', '6.04', '0.00', '10 mg', 'Paroxetine'), 
('284', 'Atasin   40 mg', '005-0764-061', 'Tablet', 'ACI Limited', '24.16', '0.00', '40 mg', 'Atorvastatin'), 
('285', 'Lamitrin   25 mg', '005-0767-046', 'Tablet', 'ACI Limited', '10.03', '0.00', '25 mg', 'Lamotrigine'), 
('286', 'Angilat   25 mg', '005-0778-22', 'Tablet', 'ACI Limited', '1.00', '0.00', '25 mg', 'Metoprolol Tartrate'), 
('287', 'Angilat   50 mg', '005-0777-22', 'Tablet', 'ACI Limited', '1.50', '0.00', '50 mg', 'Metoprolol Tartrate'), 
('288', 'Avintol   5 mg', '005-0780-36', 'Tablet', 'ACI Limited', '3.00', '0.00', '5 mg', 'Vinpocetine'), 
('289', 'Abixa   10 mg', '005-0779-037', 'Tablet', 'ACI Limited', '8.00', '0.00', '10 mg', 'Memantine Hydrochloride'), 
('290', 'Canazole   200 mg', '005-0792', 'Tablet', 'ACI Limited', '25.08', '0.00', '200 mg', 'Fluconazole'), 
('291', 'Xiety   .25 mg', '005-07937', 'Tablet', 'ACI Limited', '0.00', '0.00', '.25 mg', 'Alprazolam'), 
('292', 'Xiety   .5 mg', '005-07947', 'Tablet', 'ACI Limited', '0.00', '0.00', '.5 mg', 'Alprazolam'), 
('293', 'Dormilat   15 mg', '005-0802-057', 'Tablet', 'ACI Limited', '15.05', '0.00', '15 mg', 'Midazolam'), 
('294', 'Dormilat   7.5 mg', '005-0801-057', 'Tablet', 'ACI Limited', '8.02', '0.00', '7.5 mg', 'Midazolam'), 
('295', 'Febus   40 mg', '005-0809-76', 'Tablet', 'ACI Limited', '12.04', '0.00', '40 mg', 'Febuxostat'), 
('296', 'Febus   80 mg', '005-0810-76', 'Tablet', 'ACI Limited', '22.07', '0.00', '80 mg', 'Febuxostat'), 
('297', 'Abaclor 375 ER   375 mg', '005-0811-23', 'Tablet', 'ACI Limited', '30.09', '0.00', '375 mg', 'Cefaclor'), 
('298', 'Ritch Orodispersible   30 mg', '005-0812-21', 'Tablet', 'ACI Limited', '3.00', '0.00', '30 mg', 'Fexofenadine Hydrochloride'), 
('299', 'Glimirid   3 mg', '005-0817', 'Tablet', 'ACI Limited', '10.03', '0.00', '3 mg', 'Glimepiride'), 
('300', 'Glimirid   4 mg', '005-0828', 'Tablet', 'ACI Limited', '12.04', '0.00', '4 mg', 'Glimepiride'), 
('301', 'Tizabate   160 mg', '005-0819-61', 'Tablet', 'ACI Limited', '0.00', '0.00', '160 mg', 'Fenofibrate'), 
('302', 'Doxamil   25 mg', '005-0821-021', 'Tablet', 'ACI Limited', '2.01', '0.00', '25 mg', 'Doxylamine Succinate'), 
('303', 'Hemagrel   5 mg', '005-0822-26', 'Tablet', 'ACI Limited', '12.04', '0.00', '5 mg', 'Prasugrel'), 
('304', 'Hemagrel   10 mg', '005-0823-26', 'Tablet', 'ACI Limited', '20.06', '0.00', '10 mg', 'Prasugrel'), 
('305', 'Cefzil   250 mg', '005-0827-23', 'Tablet', 'ACI Limited', '0.00', '0.00', '250 mg', 'Cefprozil'), 
('306', 'Cefzil0   500 mg', '005-0828-23', 'Tablet', 'ACI Limited', '0.00', '0.00', '500 mg', 'Cefprozil'), 
('307', 'Compazine   5 mg', '005-08308', 'Tablet', 'ACI Limited', '0.00', '0.00', '5 mg', 'Prochlorperazine Maleate'), 
('308', 'Ritopar   10 mg', '005-08359', 'Tablet', 'ACI Limited', '8.00', '0.00', '10 mg', 'Ritodrine Hydrochloride'), 
('309', 'Atasin   80 mg', '005-0862-61', 'Tablet', 'ACI Limited', '40.12', '0.00', '80 mg', 'Atorvastatin'), 
('310', 'Anaxyl0   500 mg', '005-08689', 'Tablet', 'ACI Limited', '20.06', '0.00', '500 mg', 'Tranexamic Acid'), 
('311', 'Foviral   300 mg', '005-0870-32', 'Tablet', 'ACI Limited', '85.26', '0.00', '300 mg', 'Tenofovir Disoproxil Fumarate'), 
('312', 'Diamicron MR   60 mg', '005-0880', 'Tablet', 'ACI Limited', '18.05', '0.00', '60 mg', 'Gliclazide'), 
('313', 'Teolex SR  400 mg', '005-08834', 'Tablet', 'ACI Limited', '2.68', '0.00', '400 mg', 'Theophylline'), 
('314', 'Teolex SR   300 mg', '005-08844', 'Tablet', 'ACI Limited', '2.01', '0.00', '300 mg', 'Theophylline'), 
('315', 'Sodival CR   300 mg', '005-08986', 'Tablet', 'ACI Limited', '6.00', '0.00', '300 mg', 'Sodium Valproate'), 
('316', 'Sodival CR   500 mg', '005-08996', 'Tablet', 'ACI Limited', '10.00', '0.00', '500 mg', 'Sodium Valproate'), 
('317', 'Clonium   1 mg', '005-09006', 'Tablet', 'ACI Limited', '5.02', '0.00', '1 mg', 'Clonazepam'), 
('318', 'Amidron   100 mg', '005-0904-9', 'Tablet', 'ACI Limited', '5.00', '0.00', '100 mg', 'Amiodarone Hydrochloride'), 
('319', 'Amidron   200 mg', '005-0905-9', 'Tablet', 'ACI Limited', '10.00', '0.00', '200 mg', 'Amiodarone Hydrochloride'), 
('320', 'Movera   5 mg', '005-0908-39', 'Tablet', 'ACI Limited', '5.40', '0.00', '5 mg', 'Medroxyprogesterone Acetate'), 
('321', 'Movera   10 mg', '005-0909-039', 'Tablet', 'ACI Limited', '10.03', '0.00', '10 mg', 'Medroxyprogesterone Acetate'), 
('322', 'Menogia   5 mg', '005-0910-39', 'Tablet', 'ACI Limited', '5.00', '0.00', '5 mg', 'Norethisterone'), 
('323', 'e-Plan   750 mcg', '005-0912-039', 'Tablet', 'ACI Limited', '22.89', '0.00', '750 mcg', 'Levo Norgestrel'), 
('324', 'Tivion   2.5 mg', '005-09136', 'Tablet', 'ACI Limited', '20.00', '0.00', '2.5 mg', 'Tibolone'), 
('325', 'Throid   50 mcg', '005-0914-74', 'Tablet', 'ACI Limited', '1.35', '0.00', '50 mcg', 'Levothyroxine Sodium'), 
('326', 'Prelab   5 mg', '005-09159', 'Tablet', 'ACI Limited', '8.00', '0.00', '5 mg', 'Allystrenol'), 
('327', 'Litiam ER   400 mg', '005-0925-28', 'Tablet', 'ACI Limited', '5.02', '0.00', '400 mg', 'Lithium Carbonate'), 
('328', 'Rosetor   40 mg', '005-0932-61', 'Tablet', 'ACI Limited', '0.00', '0.00', '40 mg', 'Rosuvastatin'), 
('329', 'Adegra   25 mg', '005-0944-043', 'Tablet', 'ACI Limited', '20.06', '0.00', '25 mg', 'Sildenafil'), 
('330', 'Adegra   50 mg', '005-0945-043', 'Tablet', 'ACI Limited', '30.09', '0.00', '50 mg', 'Sildenafil'), 
('331', 'Adegra   100 mg', '005-0946-043', 'Tablet', 'ACI Limited', '50.15', '0.00', '100 mg', 'Sildenafil'), 
('332', 'Rosetor   20 mg', '005-0938-61', 'Tablet', 'ACI Limited', '0.00', '0.00', '20 mg', 'Rosuvastatin'), 
('333', 'Rosetor   10 mg', '005-0939-61', 'Tablet', 'ACI Limited', '18.05', '0.00', '10 mg', 'Rosuvastatin'), 
('334', 'Rosetor   5 mg', '005-0940-61', 'Tablet', 'ACI Limited', '10.03', '0.00', '5 mg', 'Rosuvastatin'), 
('335', 'Qmax   100 mg', '005-0941-28', 'Tablet', 'ACI Limited', '10.03', '0.00', '100 mg', 'Quetiapine'), 
('336', 'Qmax   25 mg', '005-0942-28', 'Tablet', 'ACI Limited', '3.01', '0.00', '25 mg', 'Quetiapine'), 
('337', 'Namitol   200 mg', '005-09547', 'Tablet', 'ACI Limited', '8.02', '0.00', '200 mg', 'Tolfenamic Acid'), 
('338', 'Probis   2.5 mg', '005-0955-22', 'Tablet', 'ACI Limited', '6.02', '0.00', '2.5 mg', 'Bisoprolol Hemifumarate'), 
('339', 'Ciaton   5 mg', '005-0959-043', 'Tablet', 'ACI Limited', '18.05', '0.00', '5 mg', 'Tadalafil'), 
('340', 'Ciaton   10 mg', '005-0960-043', 'Tablet', 'ACI Limited', '35.11', '0.00', '10 mg', 'Tadalafil'), 
('341', 'Ciaton   20 mg', '005-0961-043', 'Tablet', 'ACI Limited', '60.18', '0.00', '20 mg', 'Tadalafil'), 
('342', 'Teolex SR Tablet   200 mg', '005-09624', 'Tablet', 'ACI Limited', '1.50', '0.00', '200 mg', 'Theophylline'), 
('343', 'Avlocid M   400 mg', '005-0864-7', 'Tablet', 'ACI Limited', '0.00', '0.00', '400 mg', 'Magaldrate'), 
('344', 'Rapine F/C   15 mg', '005-09674', 'Tablet', 'ACI Limited', '8.00', '0.00', '15 mg', 'Mirtazapine'), 
('345', 'Rapine F/C   30 mg', '005-09684', 'Tablet', 'ACI Limited', '15.00', '0.00', '30 mg', 'Mirtazapine'), 
('346', 'Cefim   200 mg', '005-0970-23', 'Tablet', 'ACI Limited', '30.09', '0.00', '200 mg', 'Cefixime'), 
('347', 'Cefim-3 DS   400 mg', '005-0971-23', 'Tablet', 'ACI Limited', '50.15', '0.00', '400 mg', 'Cefixime'), 
('348', 'Acical Jr. Chewable Tablet   625 mg', '005-0972-62', 'Tablet', 'ACI Limited', '3.01', '0.00', '625 mg', 'Calcium Carbonate'), 
('349', 'Adegra   20 mg', '005-0980-043', 'Tablet', 'ACI Limited', '0.00', '0.00', '20 mg', 'Sildenafil'), 
('350', 'Diamicron MR   30 mg', '593-0466', 'Tablet', 'ACI Limited', '11.53', '0.00', '30 mg', 'Gliclazide'), 
('351', 'Somfen   5 mg', '593-09891', 'Tablet', 'ACI Limited', '0.00', '0.00', '5 mg', 'Solifenacin Succinate'), 
('352', 'Somfen   10 mg', '593-09901', 'Tablet', 'ACI Limited', '0.00', '0.00', '10 mg', 'Solifenacin Succinate'), 
('353', 'e-Plan Max   1.5 mg', '593-0993-039', 'Tablet', 'ACI Limited', '70.00', '0.00', '1.5 mg', 'Levo Norgestrel'), 
('354', 'Sitap   100 mg', '593-0995', 'Tablet', 'ACI Limited', '28.08', '0.00', '100 mg', 'Sitagliptin'), 
('355', 'Sitap   50 mg', '593-0994', 'Tablet', 'ACI Limited', '15.05', '0.00', '50 mg', 'Sitagliptin'), 
('356', 'Paricel   10 mg', '59305-67', 'Tablet', 'ACI Limited', '3.51', '0.00', '10 mg', 'Rabeprazole Sodium'), 
('357', 'Solone   10 mg', '59308-72', 'Tablet', 'ACI Limited', '2.07', '0.00', '10 mg', 'Prednisolone'), 
('358', 'Arinia   5 mg', '59309-28', 'Tablet', 'ACI Limited', '0.00', '0.00', '5 mg', 'Aripiprazole'), 
('359', 'Arinia   10 mg', '59310-28', 'Tablet', 'ACI Limited', '0.00', '0.00', '10 mg', 'Aripiprazole'), 
('360', 'Arinia   15 mg', '59311-28', 'Tablet', 'ACI Limited', '0.00', '0.00', '15 mg', 'Aripiprazole'), 
('361', 'Carbox   300 mg', '59312-046', 'Tablet', 'ACI Limited', '0.00', '0.00', '300 mg', 'Oxcarbazepine'), 
('362', 'Citalam   5 mg', '593144', 'Tablet', 'ACI Limited', '7.00', '0.00', '5 mg', 'Escitalopram'), 
('363', 'Citalam   10 mg', '593134', 'Tablet', 'ACI Limited', '12.00', '0.00', '10 mg', 'Escitalopram'), 
('364', 'Moxiflox   400 mg', '59318-23', 'Tablet', 'ACI Limited', '0.00', '0.00', '400 mg', 'Moxifloxacin'), 
('365', 'Risomax   1 mg', '59319-28', 'Tablet', 'ACI Limited', '3.00', '0.00', '1 mg', 'Risperidone'), 
('366', 'Risomax   2 mg', '59320-28', 'Tablet', 'ACI Limited', '5.00', '0.00', '2 mg', 'Risperidone'), 
('367', 'Risomax   4 mg', '59321-28', 'Tablet', 'ACI Limited', '9.00', '0.00', '4 mg', 'Risperidone'), 
('368', 'Carbox   150 mg', '59324-046', 'Tablet', 'ACI Limited', '0.00', '0.00', '150 mg', 'Oxcarbazepine'), 
('369', 'Rotacal   400 mg', '59325-62', 'Tablet', 'ACI Limited', '8.00', '0.00', '400 mg', 'Calcium Orotate'), 
('370', 'Lopenta   50 mg', '59328-065', 'Tablet', 'ACI Limited', '14.00', '0.00', '50 mg', 'Tapentadol'), 
('371', 'Lopenta   75 mg', '59329-065', 'Tablet', 'ACI Limited', '20.00', '0.00', '75 mg', 'Tapentadol'), 
('372', 'Tricalm   2 mg', '538', 'Tablet', 'ACI Limited', '5.00', '0.00', '2 mg', 'Trihexyphenidyl Hydrochloride'), 
('373', 'Acora   90 mg', '00548-26', 'Tablet', 'ACI Limited', '75.00', '0.00', '90 mg', 'Ticagrelor'), 
('374', 'Glitin   5 mg', '00547-015', 'Tablet', 'ACI Limited', '15.00', '0.00', '5 mg', 'Linagliptin'), 
('375', 'Rapine   7.5 mg', '5464', 'Tablet', 'ACI Limited', '6.00', '0.00', '7.5 mg', 'Mirtazapine'), 
('376', 'Defzort   6 mg', '00549-72', 'Tablet', 'ACI Limited', '8.00', '0.00', '6 mg', 'Deflazacort'), 
('377', 'Doximar   400 mg', '5504', 'Tablet', 'ACI Limited', '8.00', '0.00', '400 mg', 'Doxophylline'), 
('378', 'Bilicir   150 mg', '551', 'Tablet', 'ACI Limited', '11.00', '0.00', '150 mg', 'Ursodeoxycholic Acid'), 
('379', 'Bilicir   300 mg', '552', 'Tablet', 'ACI Limited', '20.00', '0.00', '300 mg', 'Ursodeoxycholic Acid'), 
('380', 'Henlix   200 mg', '00554-23', 'Tablet', 'ACI Limited', '25.00', '0.00', '200 mg', 'Rifaximin'), 
('381', 'Henlix   550 mg', '005-0105-23', 'Tablet', 'ACI Limited', '45.00', '0.00', '550 mg', 'Rifaximin'), 
('382', 'Adair   500 mcg', '5604', 'Tablet', 'ACI Limited', '15.00', '0.00', '500 mcg', 'Roflumilast'), 
('383', 'Loxetine   20 mg', '5614', 'Tablet', 'ACI Limited', '7.00', '0.00', '20 mg', 'Duloxetine'), 
('384', 'Loxetine   30 mg', '5624', 'Tablet', 'ACI Limited', '10.00', '0.00', '30 mg', 'Duloxetine'), 
('385', 'Largix   10 mg', '00566-21', 'Tablet', 'ACI Limited', '10.00', '0.00', '10 mg', 'Rupatadine'), 
('386', 'Ceftoren   200 mg', '00567-23', 'Tablet', 'ACI Limited', '150.00', '0.00', '200 mg', 'Cefditoren'), 
('387', 'Ebasten   10 mg', '00572-21', 'Tablet', 'ACI Limited', '6.00', '0.00', '10 mg', 'Ebastine'), 
('388', 'Daxetin   30 mg', '00573-014', 'Tablet', 'ACI Limited', '30.00', '0.00', '30 mg', 'Dapoxetine'), 
('389', 'Daxetin   60 mg', '00574-014', 'Tablet', 'ACI Limited', '50.00', '0.00', '60 mg', 'Dapoxetine'), 
('390', 'Tricalm   5 mg', '576', 'Tablet', 'ACI Limited', '10.00', '0.00', '5 mg', 'Trihexyphenidyl Hydrochloride'), 
('391', 'Sofomax   400 mg', '00585-32', 'Tablet', 'ACI Limited', '700.00', '0.00', '400 mg', 'Sofosbuvir'), 
('392', 'Rotacal Max   740 mg', '00586-62', 'Tablet', 'ACI Limited', '12.00', '0.00', '740 mg', 'Calcium Orotate'), 
('393', 'Anaglin   100 mg', '590', 'Tablet', 'ACI Limited', '0.00', '0.00', '100 mg', 'Canagliflozin'), 
('394', 'Doximar   200 mg', '5894', 'Tablet', 'ACI Limited', '6.00', '0.00', '200 mg', 'Doxophylline'), 
('395', 'Kofnix SR   50 mg', '005-0843-31', 'Tablet', 'ACI Limited', '0.00', '0.00', '50 mg', 'Butamirate Citrate'), 
('396', 'Aptin   50 mg', '593', 'Tablet', 'ACI Limited', '20.00', '0.00', '50 mg', 'Vildagliptin'), 
('397', 'Armoda   150 mg', '00598-01', 'Tablet', 'ACI Limited', '15.00', '0.00', '150 mg', 'Armodafinil'), 
('398', 'Armoda   250 mg', '00599-01', 'Tablet', 'ACI Limited', '25.00', '0.00', '250 mg', 'Armodafinil'), 
('399', 'Glycema   5 mg', '5101', 'Tablet', 'ACI Limited', '16.00', '0.00', '5 mg', 'Dapagliflozin'), 
('400', 'Arbitel   40 mg', '005107-022', 'Tablet', 'ACI Limited', '12.00', '0.00', '40 mg', 'Telmisartan'), 
('401', 'Arbitel   80 mg', '005108-022', 'Tablet', 'ACI Limited', '20.00', '0.00', '80 mg', 'Telmisartan'), 
('402', 'Rivaban   10 mg', '51092', 'Tablet', 'ACI Limited', '25.00', '0.00', '10 mg', 'Rivaroxaban'), 
('403', 'Rivaban   20 mg', '51102', 'Tablet', 'ACI Limited', '45.00', '0.00', '20 mg', 'Rivaroxaban'), 
('404', 'Arbitel   20 mg', '005128-022', 'Tablet', 'ACI Limited', '7.00', '0.00', '20 mg', 'Telmisartan'), 
('405', 'Glycema   10 mg', '5129', 'Tablet', 'ACI Limited', '30.00', '0.00', '10 mg', 'Dapagliflozin'), 
('406', 'Glupain   500 mg', '005-0362-064', 'Tablet', 'ACI Limited', '3.02', '0.00', '500 mg', 'Glucosamine'), 
('407', 'Defzort4   24 mg', '005145-072', 'Tablet', 'ACI Limited', '30.00', '0.00', '24 mg', 'Deflazacort'), 
('408', 'Corzil   40 mg', '005146-022', 'Tablet', 'ACI Limited', '0.00', '0.00', '40 mg', 'Azilsartan Medoxomil'), 
('409', 'Acitamol (Vet)   2 gm', '005-0949-077', 'Bolus', 'ACI Limited', '2.25', '0.00', '2 gm', 'Paracetamol'), 
('410', 'Prozin Vet   150 mg', '59300-077', 'Bolus', 'ACI Limited', '3.32', '0.00', '150 mg', 'Promethazine Hydrochloride'), 
('411', 'Acimetro-Vet   2 gm', '59301-077', 'Bolus', 'ACI Limited', '4.47', '0.00', '2 gm', 'Metronidazole'), 
('412', 'K-Pain Vet   400 mg', '59333-077', 'Bolus', 'ACI Limited', '10.00', '0.00', '400 mg', 'Ketoprofen'), 
('413', 'M-Pain Vet   100 mg', '59334-077', 'Bolus', 'ACI Limited', '6.01', '0.00', '100 mg', 'Meloxicam'), 
('414', 'Acivet Cipro   1 gm', '005114-077', 'Bolus', 'ACI Limited', '19.80', '0.00', '1 gm', 'Ciprofloxacin'), 
('415', 'Acinex (Vet)   900 mg', '005-0393-077', 'Bolus', 'ACI Limited', '0.00', '0.00', '900 mg', 'Triclabendazole'), 
('416', 'Aciphin  IM   1 gm', '005-0211-23', 'IM Injection', 'ACI Limited', '191.29', '0.00', '1 gm', 'Ceftriaxone'), 
('417', 'Aciphin  IM   500 mg', '005-0215-23', 'IM Injection', 'ACI Limited', '130.39', '0.00', '500 mg', 'Ceftriaxone'), 
('418', 'Aciphin  IM   250 mg', '005-0209-23', 'IM Injection', 'ACI Limited', '100.30', '0.00', '250 mg', 'Ceftriaxone'), 
('419', 'Aciphin  IV   500 mg', '005-0210-23', 'IV Injection', 'ACI Limited', '130.39', '0.00', '500 mg', 'Ceftriaxone'), 
('420', 'Aciphin  IV   250 mg', '005-0214-23', 'IV Injection', 'ACI Limited', '100.30', '0.00', '250 mg', 'Ceftriaxone'), 
('421', 'Aciphin  IV   1 gm', '005-0216-23', 'IV Injection', 'ACI Limited', '191.29', '0.00', '1 gm', 'Ceftriaxone'), 
('422', 'Aciphin  IV   2 gm', '005-0556-23', 'IV Injection', 'ACI Limited', '302.04', '0.00', '2 gm', 'Ceftriaxone'), 
('423', 'Repotyn   5 %', '005-0719-3', 'IV Infusion', 'ACI Limited', '352.38', '0.00', '5 %', 'Amino Acids (Essential)'), 
('424', 'Congesta   .025 %', '005-09292', 'Nasal Drops', 'ACI Limited', '0.00', '0.00', '.025 %', 'Oxymetazoline Hydrochloride'), 
('425', 'Congesta   .05 %', '005-09302', 'Nasal Drops', 'ACI Limited', '0.00', '0.00', '.05 %', 'Oxymetazoline Hydrochloride'), 
('426', 'Ambroxol HCl   Pellets   30 %', '005-0545-034', 'Pellets', 'ACI Limited', '0.00', '0.00', '30 %', 'Ambroxol Hydrochloride'), 
('427', 'Odazyth SR   2 gm', '005-0979-23', 'Powder For Suspension', 'ACI Limited', '250.75', '0.00', '2 gm', 'Azithromycin'), 
('428', 'Diclofenac Sodium   100 %', '005-0544-034', 'Raw Materials', 'ACI Limited', '0.00', '0.00', '100 %', 'Diclofenac Sodium'), 
('429', 'Ferrous Sulphate + Folic Acid   Pellets   62 %', '005-0441-034', 'Raw Materials', 'ACI Limited', '0.00', '0.00', '62 %', 'Ferrous Sulphate'), 
('430', 'Dermasim  VT   500 mg', '005-0290', 'Vaginal Tablet', 'ACI Limited', '60.41', '0.00', '500 mg', 'Clotrimazole'), 
('431', 'Ecoren  VT    150 mg', '005-0402', 'Vaginal Tablet', 'ACI Limited', '24.16', '0.00', '150 mg', 'Econazole Nitrate'), 
('432', 'Dermasim  VT    200 mg', '005-0628', 'Vaginal Tablet', 'ACI Limited', '20.14', '0.00', '200 mg', 'Clotrimazole'), 
('433', 'Prosma   .025 %', '005-04362', 'Eye Drops', 'ACI Limited', '95.65', '0.00', '.025 %', 'Ketotifen'), 
('434', 'Lotensin   .25 %', '005-05012', 'Eye Drops', 'ACI Limited', '0.00', '0.00', '.25 %', 'Timolol Maleate'), 
('435', 'Atier   .3 %', '005-05952', 'Eye Drops', 'ACI Limited', '65.45', '0.00', '.3 %', 'Hypromellose'), 
('436', 'Vave   10 mg', '005-07728', 'Dispersible Tablet', 'ACI Limited', '5.02', '0.00', '10 mg', 'Domperidone'), 
('437', 'Sintel DT   400 mg', '593-0983-008', 'Dispersible Tablet', 'ACI Limited', '6.02', '0.00', '400 mg', 'Albendazole'), 
('438', 'Steradin HFA   100 mcg', '005-07124', 'Inhalation Solution', 'ACI Limited', '271.84', '0.00', '100 mcg', 'Beclomethasone Dipropionate'), 
('439', 'Brodil Acucap   200 mcg', '005-08914', 'Inhalation Capsule', 'ACI Limited', '2.51', '0.00', '200 mcg', 'Salbutamol'), 
('440', 'Melonex20 Acucap   220 mcg', '005-08954', 'Inhalation Capsule', 'ACI Limited', '0.00', '0.00', '220 mcg', 'Mometasone Furoate'), 
('441', 'Melonex10 Acucap   110 mcg', '005-08964', 'Inhalation Capsule', 'ACI Limited', '0.00', '0.00', '110 mcg', 'Mometasone Furoate'), 
('442', 'Tendia ER   100 mg', '005-0695-65', 'Sr Capsule', 'ACI Limited', '14.09', '0.00', '100 mg', 'Tramadol Hydrochloride'), 
('443', 'Milk Aid   300 mg', '51061', 'Chewable Tablet', 'ACI Limited', '15.00', '0.00', '300 mg', 'Lactase'), 
('444', 'Metform  ER   1 gm', '005-0574', 'Xr Tablet', 'ACI Limited', '7.05', '0.00', '1 gm', 'Metformin Hydrochloride'), 
('445', 'Metform0   500 mg', '005-0789', 'Xr Tablet', 'ACI Limited', '0.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('446', 'Palimax ER   6 mg', '00596-28', 'Er Tablet', 'ACI Limited', '10.00', '0.00', '6 mg', 'Paliperidone'), 
('447', 'Palimax ER   1.5 mg', '005118-28', 'Er Tablet', 'ACI Limited', '4.00', '0.00', '1.5 mg', 'Paliperidone'), 
('448', 'Palimax ER   3 mg', '005119-28', 'Er Tablet', 'ACI Limited', '7.00', '0.00', '3 mg', 'Paliperidone'), 
('449', 'Miragon PR   25 mg', '005117-01', 'Er Tablet', 'ACI Limited', '30.00', '0.00', '25 mg', 'Mirabegron'), 
('450', 'Xcel ODT   500 mg', '005-0797-006', 'Orodispersible Tablet', 'ACI Limited', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('451', 'Acitrin   10 mg', '005-0807-21', 'Orodispersible Tablet', 'ACI Limited', '0.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('452', 'Osetron ODT   4 mg', '005-08858', 'Orodispersible Tablet', 'ACI Limited', '0.00', '0.00', '4 mg', 'Ondansetron'), 
('453', 'Floxabid  SR   1 gm', '005-0566-23', 'Sr Tablet', 'ACI Limited', '20.13', '0.00', '1 gm', 'Ciprofloxacin'), 
('454', 'Xeldrin      20 mg', '005-0489', 'Sr Tablet', 'ACI Limited', '4.03', '0.00', '20 mg', 'Omeprazole'), 
('455', 'A Clox   500 mg', '036-0086-23', 'Capsule', 'Acme Laboratories Ltd.', '5.98', '0.00', '500 mg', 'Cloxacillin'), 
('456', 'A Flox   250 mg', '036-0194-23', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Flucloxacillin'), 
('457', 'A Flox   500 mg', '036-0193-23', 'Capsule', 'Acme Laboratories Ltd.', '10.58', '0.00', '500 mg', 'Flucloxacillin'), 
('458', 'A Rifam      150 mg', '036-0180-30', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '150 mg', 'Rifampicin'), 
('459', 'A Rifam   450 mg', '036-0181-30', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '450 mg', 'Rifampicin'), 
('460', 'A Tetra   500 mg', '036-0236-23', 'Capsule', 'Acme Laboratories Ltd.', '3.39', '0.00', '500 mg', 'Tetracycline Hydrochloride'), 
('461', 'Acelex   250 mg', '036-0113-23', 'Capsule', 'Acme Laboratories Ltd.', '6.65', '0.00', '250 mg', 'Cephalexin'), 
('462', 'Acelex   500 mg', '036-0150-23', 'Capsule', 'Acme Laboratories Ltd.', '12.58', '0.00', '500 mg', 'Cephalexin'), 
('463', 'Acmecilin   250 mg', '036-0029-23', 'Capsule', 'Acme Laboratories Ltd.', '3.34', '0.00', '250 mg', 'Ampicillin'), 
('464', 'Cib      100 mg', '036-0273-064', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Celecoxib'), 
('465', 'Cib      200 mg', '036-0274-064', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Celecoxib'), 
('466', 'Doxy A     100 mg', '036-0115-23', 'Capsule', 'Acme Laboratories Ltd.', '2.20', '0.00', '100 mg', 'Doxycycline'), 
('467', 'Fix A     200 mg', '036-0268-23', 'Capsule', 'Acme Laboratories Ltd.', '30.20', '0.00', '200 mg', 'Cefixime'), 
('468', 'Lansodin   15 mg', '036-0281-67', 'Capsule', 'Acme Laboratories Ltd.', '3.52', '0.00', '15 mg', 'Lansoprazole'), 
('469', 'Lansodin   30 mg', '036-0282-67', 'Capsule', 'Acme Laboratories Ltd.', '6.04', '0.00', '30 mg', 'Lansoprazole'), 
('470', 'Lipidof      200 mg', '036-0372-61', 'Capsule', 'Acme Laboratories Ltd.', '7.04', '0.00', '200 mg', 'Fenofibrate'), 
('471', 'Lopamid   2 mg', '036-00856', 'Capsule', 'Acme Laboratories Ltd.', '1.00', '0.00', '2 mg', 'Loperamide'), 
('472', 'Moxilin   250 mg', '036-0030-023', 'Capsule', 'Acme Laboratories Ltd.', '3.62', '0.00', '250 mg', 'Amoxicillin'), 
('473', 'Moxilin   500 mg', '036-0245-23', 'Capsule', 'Acme Laboratories Ltd.', '6.77', '0.00', '500 mg', 'Amoxicillin'), 
('474', 'Oxecylin   250 mg', '036-0028-23', 'Capsule', 'Acme Laboratories Ltd.', '2.00', '0.00', '250 mg', 'Oxytetracycline'), 
('475', 'PPI      20 mg', '036-0141-67', 'Capsule', 'Acme Laboratories Ltd.', '5.01', '0.00', '20 mg', 'Omeprazole'), 
('476', 'Ppi      40 mg', '036-0242-67', 'Capsule', 'Acme Laboratories Ltd.', '8.03', '0.00', '40 mg', 'Omeprazole'), 
('477', 'Sefril   250 mg', '036-0097-023', 'Capsule', 'Acme Laboratories Ltd.', '8.03', '0.00', '250 mg', 'Cephradine'), 
('478', 'Sefril   500 mg', '036-0111-23', 'Capsule', 'Acme Laboratories Ltd.', '15.04', '0.00', '500 mg', 'Cephradine'), 
('479', 'Thenglate  TR   300 mg', '036-02354', 'Capsule', 'Acme Laboratories Ltd.', '2.94', '0.00', '300 mg', 'Theophylline'), 
('480', 'Twicef   500 mg', '036-0374-23', 'Capsule', 'Acme Laboratories Ltd.', '12.09', '0.00', '500 mg', 'Cefadroxil'), 
('481', 'Venaxin  SR    75 mg', '036-03944', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '75 mg', 'Venlafaxine'), 
('482', 'Azin   250 mg', '036-0164-23', 'Capsule', 'Acme Laboratories Ltd.', '25.08', '0.00', '250 mg', 'Azithromycin'), 
('483', 'Adinir0   300 mg', '036-0432-23', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '300 mg', 'Cefdinir'), 
('484', 'Maxima      20 mg', '036-0439-067', 'Capsule', 'Acme Laboratories Ltd.', '7.00', '0.00', '20 mg', 'Esomeprazole'), 
('485', 'Maxima      40 mg', '036-0440-067', 'Capsule', 'Acme Laboratories Ltd.', '9.03', '0.00', '40 mg', 'Esomeprazole'), 
('486', 'Fluconal      150 mg', '036-0441', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '150 mg', 'Fluconazole'), 
('487', 'Cecon  WSP   500 mg', '036-0309-78', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Vitamin C'), 
('488', 'Dolonil      50 mg', '036-0524-65', 'Capsule', 'Acme Laboratories Ltd.', '7.55', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('489', 'A Tetra   250 mg', '036-0528-23', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('490', 'Fix-A DS    400 mg', '036-0544-23', 'Capsule', 'Acme Laboratories Ltd.', '50.35', '0.00', '400 mg', 'Cefixime'), 
('491', 'Uropass   400 mcg', '036-05839', 'Capsule', 'Acme Laboratories Ltd.', '10.07', '0.00', '400 mcg', 'Tamsulosin Hydrochloride'), 
('492', 'Alclor0   500 mg', '036-0635-23', 'Capsule', 'Acme Laboratories Ltd.', '40.12', '0.00', '500 mg', 'Cefaclor'), 
('493', 'Lincocin   300 mg', '036-0680-23', 'Capsule', 'Acme Laboratories Ltd.', '15.04', '0.00', '300 mg', 'Clindamycin'), 
('494', 'Lincocin   150 mg', '036-0679-23', 'Capsule', 'Acme Laboratories Ltd.', '8.03', '0.00', '150 mg', 'Clindamycin'), 
('495', 'Neugalin   50 mg', '036-0714-046', 'Capsule', 'Acme Laboratories Ltd.', '11.03', '0.00', '50 mg', 'Pregabalin'), 
('496', 'Neugalin   75 mg', '036-0715-046', 'Capsule', 'Acme Laboratories Ltd.', '16.04', '0.00', '75 mg', 'Pregabalin'), 
('497', 'Neugalin   150 mg', '036-0716-046', 'Capsule', 'Acme Laboratories Ltd.', '30.10', '0.00', '150 mg', 'Pregabalin'), 
('498', 'Indo-A   25 mg', '036-0727-64', 'Capsule', 'Acme Laboratories Ltd.', '1.00', '0.00', '25 mg', 'Indomethacin'), 
('499', 'Lifil-E   200 mg', '036-0794-78', 'Capsule', 'Acme Laboratories Ltd.', '4.01', '0.00', '200 mg', 'Vitamin E'), 
('500', 'Lifil-E0   400 mg', '036-0795-78', 'Capsule', 'Acme Laboratories Ltd.', '6.01', '0.00', '400 mg', 'Vitamin E'), 
('501', 'Indo-A SR   75 mg', '036-0863-64', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '75 mg', 'Indomethacin'), 
('502', 'Caltril   .25 mcg', '036-0884-78', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '.25 mcg', 'Calcitriol'), 
('503', 'Codfil   300 mg', '036-0885', 'Capsule', 'Acme Laboratories Ltd.', '2.00', '0.00', '300 mg', 'Cod Liver Oil'), 
('504', 'Logibac0   400 mg', '036-0917-23', 'Capsule', 'Acme Laboratories Ltd.', '120.00', '0.00', '400 mg', 'Ceftibuten'), 
('505', 'Neugalin   25 mg', '036-0931-046', 'Capsule', 'Acme Laboratories Ltd.', '8.00', '0.00', '25 mg', 'Pregabalin'), 
('506', 'Burncare   1 %', '036-0757-23', 'Cream', 'Acme Laboratories Ltd.', '0.00', '0.00', '1 %', 'Silver Sulphadiazine'), 
('507', 'Oratics Oral Gel   200 mg', '036-0717-73', 'Gel', 'Acme Laboratories Ltd.', '40.12', '0.00', '200 mg', 'Benzocaine'), 
('508', 'Acme\'S Water For Injection   5 ml', '036-0130-79', 'Injection', 'Acme Laboratories Ltd.', '6.01', '0.00', '5 ml', 'Water For Injection'), 
('509', 'Moxilin   250 mg', '036-0131-023', 'Injection', 'Acme Laboratories Ltd.', '21.26', '0.00', '250 mg', 'Amoxicillin'), 
('510', 'Moxilin   500 mg', '036-0132-23', 'Injection', 'Acme Laboratories Ltd.', '33.70', '0.00', '500 mg', 'Amoxicillin'), 
('511', 'Azin   500 mg', '036-0551-23', 'Injection', 'Acme Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('512', 'Tulos   68 %', '036-0385-60', 'Oral Solution', 'Acme Laboratories Ltd.', '120.37', '0.00', '68 %', 'Lactulose'), 
('513', 'Ac Crop  WSP   100 %', '036-0304-077', 'Powder', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 %', 'Sodium Diacetate'), 
('514', 'Moxilin   15 %', '036-0312-077', 'Powder', 'Acme Laboratories Ltd.', '149.50', '0.00', '15 %', 'Amoxicillin'), 
('515', 'Peravet  WSP    100 %', '036-0305-077', 'Powder', 'Acme Laboratories Ltd.', '173.52', '0.00', '100 %', 'Piperazine'), 
('516', 'Scz   30 %', '036-0288-077', 'Powder', 'Acme Laboratories Ltd.', '0.00', '0.00', '30 %', 'Sulfaclozine'), 
('517', 'Stivet   500 Lac IU', '036-0251-077', 'Powder', 'Acme Laboratories Ltd.', '0.00', '0.00', '500 Lac IU', 'Colistin Sulphate'), 
('518', 'Sulpha   100 %', '036-0311-077', 'Powder', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 %', 'Sulphanilamide'), 
('519', 'Moxilin Vet   30 %', '036-0617-077', 'Powder', 'Acme Laboratories Ltd.', '0.00', '0.00', '30 %', 'Amoxicillin'), 
('520', 'Alin Vet   45 %', '036-0681-077', 'Powder', 'Acme Laboratories Ltd.', '0.00', '0.00', '45 %', 'Tiamulin Hydrogen Fumerate'), 
('521', 'Nigofon Vet   100 %', '036-0818-077', 'Powder', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 %', 'Trichlorfon'), 
('522', 'Zero Sachet   12 mg', '036-0924', 'Sachet', 'Acme Laboratories Ltd.', '0.00', '0.00', '12 mg', 'Sucralose'), 
('523', 'Cipro A   10 gm', '036-0313-077', 'Solution', 'Acme Laboratories Ltd.', '1057.11', '0.00', '10 gm', 'Ciprofloxacin'), 
('524', 'A Fenac   12.5 mg', '036-0323-64', 'Suppository', 'Acme Laboratories Ltd.', '8.07', '0.00', '12.5 mg', 'Diclofenac Sodium'), 
('525', 'A Fenac      50 mg', '036-0322-64', 'Suppository', 'Acme Laboratories Ltd.', '14.10', '0.00', '50 mg', 'Diclofenac Sodium'), 
('526', 'Dirozyl   500 mg', '036-0325-27', 'Suppository', 'Acme Laboratories Ltd.', '12.09', '0.00', '500 mg', 'Metronidazole'), 
('527', 'Don A   15 mg', '036-04128', 'Suppository', 'Acme Laboratories Ltd.', '5.03', '0.00', '15 mg', 'Domperidone'), 
('528', 'Fast   125 mg', '036-0321-006', 'Suppository', 'Acme Laboratories Ltd.', '4.03', '0.00', '125 mg', 'Paracetamol'), 
('529', 'Fast   250 mg', '036-0320-006', 'Suppository', 'Acme Laboratories Ltd.', '5.03', '0.00', '250 mg', 'Paracetamol'), 
('530', 'Indo A     100 mg', '036-0319-64', 'Suppository', 'Acme Laboratories Ltd.', '7.04', '0.00', '100 mg', 'Indomethacin'), 
('531', 'Keto A     100 mg', '036-0324-64', 'Suppository', 'Acme Laboratories Ltd.', '12.09', '0.00', '100 mg', 'Ketoprofen'), 
('532', 'Tycon   330 mg', '036-0408', 'Suppository', 'Acme Laboratories Ltd.', '60.40', '0.00', '330 mg', 'Tioconazole'), 
('533', 'Don A     30 mg', '036-04008', 'Suppository', 'Acme Laboratories Ltd.', '8.07', '0.00', '30 mg', 'Domperidone'), 
('534', 'Napro A    500 mg', '036-0362-64', 'Suppository', 'Acme Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Naproxen'), 
('535', 'Fast   500 mg', '036-0472-006', 'Suppository', 'Acme Laboratories Ltd.', '8.07', '0.00', '500 mg', 'Paracetamol'), 
('536', 'Periset   16 mg', '036-07848', 'Suppository', 'Acme Laboratories Ltd.', '0.00', '0.00', '16 mg', 'Ondansetron'), 
('537', 'Neotrax Vet   1 %', '036-0244-077', 'Syrup', 'Acme Laboratories Ltd.', '0.00', '0.00', '1 %', 'Levamisole'), 
('538', 'A B1      100 mg', '036-0159-78', 'Tablet', 'Acme Laboratories Ltd.', '0.75', '0.00', '100 mg', 'Thiamine Hydrochloride'), 
('539', 'A Cal   Chewable   625 mg', '036-0279-62', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '625 mg', 'Calcium Carbonate'), 
('540', 'A Cal   1250 mg', '036-0280-62', 'Tablet', 'Acme Laboratories Ltd.', '6.01', '0.00', '1250 mg', 'Calcium Carbonate'), 
('541', 'A Card      20 mg', '036-0298', 'Tablet', 'Acme Laboratories Ltd.', '1.43', '0.00', '20 mg', 'Isosorbide Mononitrate'), 
('542', 'A Card  SR    50 mg', '036-0300', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Isosorbide Mononitrate'), 
('543', 'A Fenac      25 mg', '036-0090-64', 'Tablet', 'Acme Laboratories Ltd.', '0.55', '0.00', '25 mg', 'Diclofenac Sodium'), 
('544', 'A Fenac      50 mg', '036-0116-64', 'Tablet', 'Acme Laboratories Ltd.', '0.84', '0.00', '50 mg', 'Diclofenac Sodium'), 
('545', 'A Fenac K     50 mg', '036-0206-64', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Diclofenac Potassium'), 
('546', 'A Spasm   5 mg', '036-01221', 'Tablet', 'Acme Laboratories Ltd.', '1.44', '0.00', '5 mg', 'Oxyphenonium Bromide'), 
('547', 'A Tetra   500 mg', '036-0182-23', 'Tablet', 'Acme Laboratories Ltd.', '2.30', '0.00', '500 mg', 'Tetracycline Hydrochloride'), 
('548', 'A Zyme   325 mg', '036-01541', 'Tablet', 'Acme Laboratories Ltd.', '3.51', '0.00', '325 mg', 'Pancreatin'), 
('549', 'Acemox   250 mg', '036-00692', 'Tablet', 'Acme Laboratories Ltd.', '2.00', '0.00', '250 mg', 'Acetazolamide'), 
('550', 'Amlopin   10 mg', '036-0170-022', 'Tablet', 'Acme Laboratories Ltd.', '7.02', '0.00', '10 mg', 'Amlodipine'), 
('551', 'Amlopin      5 mg', '036-0169-022', 'Tablet', 'Acme Laboratories Ltd.', '5.01', '0.00', '5 mg', 'Amlodipine'), 
('552', 'Azepam      5 mg', '036-0360-057', 'Tablet', 'Acme Laboratories Ltd.', '0.69', '0.00', '5 mg', 'Diazepam'), 
('553', 'Azin   500 mg', '036-0204-23', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('554', 'Azin   500 mg', '036-0239-23', 'Tablet', 'Acme Laboratories Ltd.', '35.11', '0.00', '500 mg', 'Azithromycin'), 
('555', 'Ben A    400 mg', '036-0173-008', 'Tablet', 'Acme Laboratories Ltd.', '5.01', '0.00', '400 mg', 'Albendazole'), 
('556', 'Cecon   250 mg', '036-0079-78', 'Tablet', 'Acme Laboratories Ltd.', '1.32', '0.00', '250 mg', 'Vitamin C'), 
('557', 'Cetizin   10 mg', '036-0205-21', 'Tablet', 'Acme Laboratories Ltd.', '3.01', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('558', 'Cinazin   15 mg', '036-0152-21', 'Tablet', 'Acme Laboratories Ltd.', '0.70', '0.00', '15 mg', 'Cinnarizine'), 
('559', 'Cinazin      25 mg', '036-0337-21', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '25 mg', 'Cinnarizine'), 
('560', 'Cipro A    500 mg', '036-0167-23', 'Tablet', 'Acme Laboratories Ltd.', '14.06', '0.00', '500 mg', 'Ciprofloxacin'), 
('561', 'Cipro A    750 mg', '036-0340-23', 'Tablet', 'Acme Laboratories Ltd.', '18.11', '0.00', '750 mg', 'Ciprofloxacin'), 
('562', 'Claricin   250 mg', '036-0190-23', 'Tablet', 'Acme Laboratories Ltd.', '25.17', '0.00', '250 mg', 'Clarithromycin'), 
('563', 'Claricin   500 mg', '036-0246-23', 'Tablet', 'Acme Laboratories Ltd.', '40.27', '0.00', '500 mg', 'Clarithromycin'), 
('564', 'Cosium   10 mg', '036-00896', 'Tablet', 'Acme Laboratories Ltd.', '3.52', '0.00', '10 mg', 'Clobazam'), 
('565', 'Dactus   2 mg', '036-0381', 'Tablet', 'Acme Laboratories Ltd.', '5.03', '0.00', '2 mg', 'Glimepiride'), 
('566', 'Daomin   500 mg', '036-0117', 'Tablet', 'Acme Laboratories Ltd.', '3.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('567', 'Daomin   850 mg', '036-0243', 'Tablet', 'Acme Laboratories Ltd.', '4.99', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('568', 'Diloxide   500 mg', '036-0093-27', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Diloxanide Furoate'), 
('569', 'Dirozyl      200 mg', '036-0091-27', 'Tablet', 'Acme Laboratories Ltd.', '0.67', '0.00', '200 mg', 'Metronidazole'), 
('570', 'Dirozyl   400 mg', '036-0051-27', 'Tablet', 'Acme Laboratories Ltd.', '1.27', '0.00', '400 mg', 'Metronidazole'), 
('571', 'Don A     10 mg', '036-02968', 'Tablet', 'Acme Laboratories Ltd.', '2.01', '0.00', '10 mg', 'Domperidone'), 
('572', 'Dot   40 mg', '036-03411', 'Tablet', 'Acme Laboratories Ltd.', '1.76', '0.00', '40 mg', 'Drotaverine Hydrochloride'), 
('573', 'E Tab      200 mg', '036-0174-78', 'Tablet', 'Acme Laboratories Ltd.', '3.27', '0.00', '200 mg', 'Vitamin E'), 
('574', 'Ecosprin0   300 mg', '036-0081-6', 'Tablet', 'Acme Laboratories Ltd.', '1.72', '0.00', '300 mg', 'Aspirin'), 
('575', 'Ecosprin      75 mg', '036-0151-26', 'Tablet', 'Acme Laboratories Ltd.', '0.63', '0.00', '75 mg', 'Aspirin'), 
('576', 'Electro K   600 mg', '036-0092-62', 'Tablet', 'Acme Laboratories Ltd.', '0.60', '0.00', '600 mg', 'Potassium Chloride'), 
('577', 'Erocin   250 mg', '036-0293-23', 'Tablet', 'Acme Laboratories Ltd.', '5.18', '0.00', '250 mg', 'Erythromycin'), 
('578', 'Erocin   500 mg', '036-0294-23', 'Tablet', 'Acme Laboratories Ltd.', '10.35', '0.00', '500 mg', 'Erythromycin'), 
('579', 'Famodin      20 mg', '036-01485', 'Tablet', 'Acme Laboratories Ltd.', '2.00', '0.00', '20 mg', 'Famotidine'), 
('580', 'Famodin      40 mg', '036-01495', 'Tablet', 'Acme Laboratories Ltd.', '4.01', '0.00', '40 mg', 'Famotidine'), 
('581', 'Fix A     200 mg', '036-0191-23', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Cefixime'), 
('582', 'Floxipar      200 mg', '036-0287-23', 'Tablet', 'Acme Laboratories Ltd.', '15.61', '0.00', '200 mg', 'Sparfloxacin'), 
('583', 'Fluconal      150 mg', '036-0257', 'Tablet', 'Acme Laboratories Ltd.', '22.15', '0.00', '150 mg', 'Fluconazole'), 
('584', 'Fluconal      50 mg', '036-0207', 'Tablet', 'Acme Laboratories Ltd.', '8.07', '0.00', '50 mg', 'Fluconazole'), 
('585', 'Gliclid   80 mg', '036-0260', 'Tablet', 'Acme Laboratories Ltd.', '7.02', '0.00', '80 mg', 'Gliclazide'), 
('586', 'Gluco A     100 mg', '036-0278', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Acarbose'), 
('587', 'Gluco A     50 mg', '036-0277', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Acarbose'), 
('588', 'Gluconil   5 mg', '036-0077', 'Tablet', 'Acme Laboratories Ltd.', '0.28', '0.00', '5 mg', 'Glibenclamide'), 
('589', 'Histalex   4 mg', '036-0123-21', 'Tablet', 'Acme Laboratories Ltd.', '0.30', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('590', 'Ketifen   1 mg', '036-0156-21', 'Tablet', 'Acme Laboratories Ltd.', '2.00', '0.00', '1 mg', 'Ketotifen'), 
('591', 'Keto A     100 mg', '036-0199-64', 'Tablet', 'Acme Laboratories Ltd.', '5.53', '0.00', '100 mg', 'Ketoprofen'), 
('592', 'Keto A     50 mg', '036-0200-64', 'Tablet', 'Acme Laboratories Ltd.', '3.52', '0.00', '50 mg', 'Ketoprofen'), 
('593', 'Lamid      100 mg', '036-0336-32', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Lamivudine'), 
('594', 'Leo   250 mg', '036-0379-23', 'Tablet', 'Acme Laboratories Ltd.', '8.07', '0.00', '250 mg', 'Levofloxacin'), 
('595', 'Leo   500 mg', '036-0373-23', 'Tablet', 'Acme Laboratories Ltd.', '15.10', '0.00', '500 mg', 'Levofloxacin'), 
('596', 'Lipril   10 mg', '036-0158-22', 'Tablet', 'Acme Laboratories Ltd.', '5.53', '0.00', '10 mg', 'Lisinopril'), 
('597', 'Lipril      5 mg', '036-0157-22', 'Tablet', 'Acme Laboratories Ltd.', '3.01', '0.00', '5 mg', 'Lisinopril'), 
('598', 'Losart      50 mg', '036-0335-022', 'Tablet', 'Acme Laboratories Ltd.', '8.03', '0.00', '50 mg', 'Losartan Potassium'), 
('599', 'Losart      25 mg', '036-0334-022', 'Tablet', 'Acme Laboratories Ltd.', '4.51', '0.00', '25 mg', 'Losartan Potassium'), 
('600', 'Mebolin   50 mg', '036-0104-21', 'Tablet', 'Acme Laboratories Ltd.', '2.01', '0.00', '50 mg', 'Mebhydrolin'), 
('601', 'Monas   10 mg', '036-0316-044', 'Tablet', 'Acme Laboratories Ltd.', '15.05', '0.00', '10 mg', 'Montelukast'), 
('602', 'Monas   4 mg', '036-0318-044', 'Tablet', 'Acme Laboratories Ltd.', '6.04', '0.00', '4 mg', 'Montelukast'), 
('603', 'Monas      5 mg', '036-0317-044', 'Tablet', 'Acme Laboratories Ltd.', '8.00', '0.00', '5 mg', 'Montelukast'), 
('604', 'Naligram   500 mg', '036-0074-23', 'Tablet', 'Acme Laboratories Ltd.', '4.89', '0.00', '500 mg', 'Nalidixic Acid'), 
('605', 'Napro A     250 mg', '036-0203-64', 'Tablet', 'Acme Laboratories Ltd.', '4.03', '0.00', '250 mg', 'Naproxen'), 
('606', 'Neo Trax   40 mg', '036-0027-8', 'Tablet', 'Acme Laboratories Ltd.', '0.43', '0.00', '40 mg', 'Levamisole'), 
('607', 'Nifin   10 mg', '036-0095-22', 'Tablet', 'Acme Laboratories Ltd.', '0.35', '0.00', '10 mg', 'Nifedipine'), 
('608', 'Nutramid   10 mg', '036-00718', 'Tablet', 'Acme Laboratories Ltd.', '0.35', '0.00', '10 mg', 'Metoclopramide Hydrochloride'), 
('609', 'Nystat   5 Lac Unit', '036-0118', 'Tablet', 'Acme Laboratories Ltd.', '6.27', '0.00', '5 Lac Unit', 'Nystatin'), 
('610', 'Nystat  VT   1 Lac Unit', '036-0140', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '1 Lac Unit', 'Nystatin'), 
('611', 'Orin   10 mg', '036-0259-21', 'Tablet', 'Acme Laboratories Ltd.', '3.01', '0.00', '10 mg', 'Loratadine'), 
('612', 'Osta   10 mg', '036-03338', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Alendronic Acid'), 
('613', 'Oxecone M  Chewable   400 mg', '036-0166-7', 'Tablet', 'Acme Laboratories Ltd.', '1.00', '0.00', '400 mg', 'Magaldrate'), 
('614', 'Pitam   800 mg', '036-0303', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '800 mg', 'Piracetam'), 
('615', 'Pivam      200 mg', '036-0365-23', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Pivmecillinam'), 
('616', 'Pizo A   500 mcg', '0.5-02627', 'Tablet', 'Acme Laboratories Ltd.', '3.01', '0.00', '500 mcg', 'Pizotifen'), 
('617', 'Pizo A   1.5 mg', '036-02927', 'Tablet', 'Acme Laboratories Ltd.', '7.04', '0.00', '1.5 mg', 'Pizotifen'), 
('618', 'Profen   400 mg', '036-0231-64', 'Tablet', 'Acme Laboratories Ltd.', '1.43', '0.00', '400 mg', 'Ibuprofen'), 
('619', 'Pronil  DS   1 gm', '036-0250-27', 'Tablet', 'Acme Laboratories Ltd.', '16.11', '0.00', '1 gm', 'Secnidazole'), 
('620', 'Pronil   500 mg', '036-0249-27', 'Tablet', 'Acme Laboratories Ltd.', '8.66', '0.00', '500 mg', 'Secnidazole'), 
('621', 'Ranidin      150 mg', '036-00655', 'Tablet', 'Acme Laboratories Ltd.', '2.51', '0.00', '150 mg', 'Ranitidine'), 
('622', 'Ranidin0   300 mg', '036-01455', 'Tablet', 'Acme Laboratories Ltd.', '4.03', '0.00', '300 mg', 'Ranitidine'), 
('623', 'Rizat   10 mg', '036-03837', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Rizatriptan'), 
('624', 'Rizat      5 mg', '036-03827', 'Tablet', 'Acme Laboratories Ltd.', '30.20', '0.00', '5 mg', 'Rizatriptan'), 
('625', 'Salmolin   4 mg', '036-00944', 'Tablet', 'Acme Laboratories Ltd.', '0.46', '0.00', '4 mg', 'Salbutamol'), 
('626', 'Simvatin   10 mg', '036-0238-61', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Simvastatin'), 
('627', 'Simvatin      20 mg', '036-0248-61', 'Tablet', 'Acme Laboratories Ltd.', '18.11', '0.00', '20 mg', 'Simvastatin'), 
('628', 'Steron   .5 mg', '036-0162-72', 'Tablet', 'Acme Laboratories Ltd.', '0.91', '0.00', '.5 mg', 'Dexamethasone'), 
('629', 'Sucrol   18 mg', '036-0134', 'Tablet', 'Acme Laboratories Ltd.', '0.69', '0.00', '18 mg', 'Aspartame'), 
('630', 'Tenil   3 mg', '036-02857', 'Tablet', 'Acme Laboratories Ltd.', '5.01', '0.00', '3 mg', 'Bromazepam'), 
('631', 'Tomide   2.5 mg', '036-04052', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '2.5 mg', 'Torasemide'), 
('632', 'Vertinil   5 mg', '036-03428', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Prochlorperazine Maleate'), 
('633', 'Win   5 mg', '036-02862', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Warfarin Sodium'), 
('634', 'Zafir      20 mg', '036-02894', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '20 mg', 'Zafirlukast'), 
('635', 'Fast   500 mg', '036-0042-006', 'Tablet', 'Acme Laboratories Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('636', 'Dulox   30 mg', '036-04604', 'Tablet', 'Acme Laboratories Ltd.', '10.07', '0.00', '30 mg', 'Duloxetine'), 
('637', 'Dulox      20 mg', '036-04594', 'Tablet', 'Acme Laboratories Ltd.', '7.04', '0.00', '20 mg', 'Duloxetine'), 
('638', 'Apitac   100 mg', '036-0464-64', 'Tablet', 'Acme Laboratories Ltd.', '4.01', '0.00', '100 mg', 'Aceclofenac'), 
('639', 'MB2   .5 mg', '036-0456-78', 'Tablet', 'Acme Laboratories Ltd.', '4.03', '0.00', '.5 mg', 'Mecobalamin'), 
('640', 'Carvipress      25 mg', '036-0465-22', 'Tablet', 'Acme Laboratories Ltd.', '8.07', '0.00', '25 mg', 'Carvedilol'), 
('641', 'Kidcal   625 mg', '036-0338-62', 'Tablet', 'Acme Laboratories Ltd.', '1.51', '0.00', '625 mg', 'Calcium Carbonate'), 
('642', 'Cipro A     250 mg', '036-0155-23', 'Tablet', 'Acme Laboratories Ltd.', '8.56', '0.00', '250 mg', 'Ciprofloxacin'), 
('643', 'Dactus   1 mg', '036-0380', 'Tablet', 'Acme Laboratories Ltd.', '3.01', '0.00', '1 mg', 'Glimepiride'), 
('644', 'Napro A    500 mg', '036-0291-64', 'Tablet', 'Acme Laboratories Ltd.', '7.04', '0.00', '500 mg', 'Naproxen'), 
('645', 'Carvipress   12.5 mg', '036-0453-22', 'Tablet', 'Acme Laboratories Ltd.', '5.03', '0.00', '12.5 mg', 'Carvedilol'), 
('646', 'Carvipress   6.25 mg', '036-0452-22', 'Tablet', 'Acme Laboratories Ltd.', '3.01', '0.00', '6.25 mg', 'Carvedilol'), 
('647', 'Cp      200 mg', '036-0448-23', 'Tablet', 'Acme Laboratories Ltd.', '42.29', '0.00', '200 mg', 'Cefpodoxime'), 
('648', 'Famicef   250 mg', '036-0450-23', 'Tablet', 'Acme Laboratories Ltd.', '25.17', '0.00', '250 mg', 'Cefuroxime'), 
('649', 'Leptic   .5 mg', '036-0461-046', 'Tablet', 'Acme Laboratories Ltd.', '3.01', '0.00', '.5 mg', 'Clonazepam'), 
('650', 'Leptic   2 mg', '036-0462-046', 'Tablet', 'Acme Laboratories Ltd.', '5.01', '0.00', '2 mg', 'Clonazepam'), 
('651', 'Dclot      75 mg', '036-0437-26', 'Tablet', 'Acme Laboratories Ltd.', '10.07', '0.00', '75 mg', 'Clopidogrel'), 
('652', 'Baby Zinc      20 mg', '036-0445-62', 'Tablet', 'Acme Laboratories Ltd.', '1.76', '0.00', '20 mg', 'Zinc'), 
('653', 'Mizolam      7.5 mg', '036-0444-057', 'Tablet', 'Acme Laboratories Ltd.', '8.07', '0.00', '7.5 mg', 'Midazolam'), 
('654', 'Thenglate  SR    250 mg', '036-04244', 'Tablet', 'Acme Laboratories Ltd.', '1.76', '0.00', '250 mg', 'Theophylline'), 
('655', 'Thenglate  SR   400 mg', '036-04254', 'Tablet', 'Acme Laboratories Ltd.', '2.69', '0.00', '400 mg', 'Theophylline'), 
('656', 'Uliv      150 mg', '036-0442', 'Tablet', 'Acme Laboratories Ltd.', '12.09', '0.00', '150 mg', 'Ursodeoxycholic Acid'), 
('657', 'Uliv0   300 mg', '036-0443', 'Tablet', 'Acme Laboratories Ltd.', '20.13', '0.00', '300 mg', 'Ursodeoxycholic Acid'), 
('658', 'Lipitor   10 mg', '036-0470-061', 'Tablet', 'Acme Laboratories Ltd.', '10.07', '0.00', '10 mg', 'Atorvastatin'), 
('659', 'Lipitor      20 mg', '036-0471-061', 'Tablet', 'Acme Laboratories Ltd.', '18.11', '0.00', '20 mg', 'Atorvastatin'), 
('660', 'Sizopra   10 mg', '036-0499-28', 'Tablet', 'Acme Laboratories Ltd.', '5.03', '0.00', '10 mg', 'Aripiprazole'), 
('661', 'Sizopra   15 mg', '15-0500-28', 'Tablet', 'Acme Laboratories Ltd.', '7.04', '0.00', '15 mg', 'Aripiprazole'), 
('662', 'Angist  SR   2.6 mg', '036-0501', 'Tablet', 'Acme Laboratories Ltd.', '4.03', '0.00', '2.6 mg', 'Glyceryl Trinitrate'), 
('663', 'Sono   1 mg', '036-0502-057', 'Tablet', 'Acme Laboratories Ltd.', '2.01', '0.00', '1 mg', 'Eszopiclone'), 
('664', 'Sono   2 mg', '036-0503-057', 'Tablet', 'Acme Laboratories Ltd.', '3.01', '0.00', '2 mg', 'Eszopiclone'), 
('665', 'A-Clam      50 mg', '036-0498-70', 'Tablet', 'Acme Laboratories Ltd.', '4.01', '0.00', '50 mg', 'Tolperisone Hydrochloride'), 
('666', 'Dolonil  SR    100 mg', '036-0523-65', 'Tablet', 'Acme Laboratories Ltd.', '25.08', '0.00', '100 mg', 'Tramadol Hydrochloride'), 
('667', 'Hycine   10 mg', '036-05251', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('668', 'A-Metrine   125 mcg', '036-05269', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '125 mcg', 'Methyl Ergometrine Maleate'), 
('669', 'A-Phyline      100 mg', '036-05274', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Aminophylline'), 
('670', 'Tracid   500 mg', '036-04829', 'Tablet', 'Acme Laboratories Ltd.', '15.10', '0.00', '500 mg', 'Tranexamic Acid'), 
('671', 'Tinium   50 mg', '036-04901', 'Tablet', 'Acme Laboratories Ltd.', '5.01', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('672', 'Winop   10 mg', '036-0479-064', 'Tablet', 'Acme Laboratories Ltd.', '10.07', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('673', 'Muterol   10 mg', '036-04924', 'Tablet', 'Acme Laboratories Ltd.', '1.51', '0.00', '10 mg', 'Bambuterol Hydrochloride'), 
('674', 'Muterol      20 mg', '036-04934', 'Tablet', 'Acme Laboratories Ltd.', '3.01', '0.00', '20 mg', 'Bambuterol Hydrochloride'), 
('675', 'Famicef   500 mg', '036-0513-23', 'Tablet', 'Acme Laboratories Ltd.', '45.29', '0.00', '500 mg', 'Cefuroxime'), 
('676', 'Leo   750 mg', '036-0468-23', 'Tablet', 'Acme Laboratories Ltd.', '20.13', '0.00', '750 mg', 'Levofloxacin'), 
('677', 'Zero   8 mg', '036-0536', 'Tablet', 'Acme Laboratories Ltd.', '1.00', '0.00', '8 mg', 'Sucralose'), 
('678', 'Carnitor   330 mg', '036-0538', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '330 mg', 'Levocarnitine'), 
('679', 'Diasis   500 mg', '036-0562-27', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Nitazoxanide'), 
('680', 'Akupen   30 mg', '036-0559-006', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '30 mg', 'Nefopam Hydrochloride'), 
('681', 'Orinex   5 mg', '036-0558-21', 'Tablet', 'Acme Laboratories Ltd.', '2.52', '0.00', '5 mg', 'Desloratadine'), 
('682', 'Protocid   40 mg', '036-0568-67', 'Tablet', 'Acme Laboratories Ltd.', '7.00', '0.00', '40 mg', 'Pantoprazole'), 
('683', 'Salmolin-L   1 mg', '036-05644', 'Tablet', 'Acme Laboratories Ltd.', '0.91', '0.00', '1 mg', 'Levosalbutamol'), 
('684', 'Salmolin-L   2 mg', '036-05654', 'Tablet', 'Acme Laboratories Ltd.', '1.70', '0.00', '2 mg', 'Levosalbutamol'), 
('685', 'Protocid   20 mg', '036-0567-67', 'Tablet', 'Acme Laboratories Ltd.', '4.01', '0.00', '20 mg', 'Pantoprazole'), 
('686', 'Dactus   3 mg', '036-0569', 'Tablet', 'Acme Laboratories Ltd.', '7.04', '0.00', '3 mg', 'Glimepiride'), 
('687', 'Pidus   15 mg', '036-0570', 'Tablet', 'Acme Laboratories Ltd.', '8.07', '0.00', '15 mg', 'Pioglitazone'), 
('688', 'Keto-D   25 mg', '036-0571-64', 'Tablet', 'Acme Laboratories Ltd.', '4.03', '0.00', '25 mg', 'Dex-Ketoprofen Trometamol'), 
('689', 'Lacitab   2 mg', '036-0574-22', 'Tablet', 'Acme Laboratories Ltd.', '15.00', '0.00', '2 mg', 'Lacidipine'), 
('690', 'Lactitab   4 mg', '036-0575-22', 'Tablet', 'Acme Laboratories Ltd.', '6.04', '0.00', '4 mg', 'Lacidipine'), 
('691', 'Unipril   2.5 mg', '036-0578-022', 'Tablet', 'Acme Laboratories Ltd.', '5.03', '0.00', '2.5 mg', 'Ramipril'), 
('692', 'Unipril   5 mg', '036-0579-022', 'Tablet', 'Acme Laboratories Ltd.', '8.07', '0.00', '5 mg', 'Ramipril'), 
('693', 'Angirid MR   35 mg', '036-0590', 'Tablet', 'Acme Laboratories Ltd.', '5.03', '0.00', '35 mg', 'Trimetazidine Dihydrochloride'), 
('694', 'Misoclear   200 mcg', '036-05919', 'Tablet', 'Acme Laboratories Ltd.', '15.04', '0.00', '200 mcg', 'Misoprostol'), 
('695', 'Thyrolar   25 mcg', '036-0594-74', 'Tablet', 'Acme Laboratories Ltd.', '0.70', '0.00', '25 mcg', 'Levothyroxine Sodium'), 
('696', 'Thyrolar   50 mcg', '036-0595-74', 'Tablet', 'Acme Laboratories Ltd.', '1.20', '0.00', '50 mcg', 'Levothyroxine Sodium'), 
('697', 'Thyrolar   100 mcg', '036-0596-74', 'Tablet', 'Acme Laboratories Ltd.', '2.31', '0.00', '100 mcg', 'Levothyroxine Sodium'), 
('698', 'Setorib   60 mg', '036-0599-64', 'Tablet', 'Acme Laboratories Ltd.', '7.04', '0.00', '60 mg', 'Etoricoxib'), 
('699', 'Setorib   90 mg', '036-0600-64', 'Tablet', 'Acme Laboratories Ltd.', '12.09', '0.00', '90 mg', 'Etoricoxib'), 
('700', 'Setorib   120 mg', '036-0601-64', 'Tablet', 'Acme Laboratories Ltd.', '14.10', '0.00', '120 mg', 'Etoricoxib'), 
('701', 'Liptor   40 mg', '036-0618-061', 'Tablet', 'Acme Laboratories Ltd.', '24.16', '0.00', '40 mg', 'Atorvastatin'), 
('702', 'Enocam   20 mg', '036-0623-64', 'Tablet', 'Acme Laboratories Ltd.', '8.03', '0.00', '20 mg', 'Tenoxicam'), 
('703', 'Sevel   400 mg', '036-0627-62', 'Tablet', 'Acme Laboratories Ltd.', '45.13', '0.00', '400 mg', 'Sevelamer Hydrochloride'), 
('704', 'Mega Joy   20 mg', '036-0628-043', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '20 mg', 'Tadalafil'), 
('705', 'Periset   8 mg', '036-06318', 'Tablet', 'Acme Laboratories Ltd.', '10.03', '0.00', '8 mg', 'Ondansetron'), 
('706', 'Bet-A   500 mcg', '036-0647-72', 'Tablet', 'Acme Laboratories Ltd.', '0.72', '0.00', '500 mcg', 'Betamethasone'), 
('707', 'Losart   100 mg', '036-0649-022', 'Tablet', 'Acme Laboratories Ltd.', '12.03', '0.00', '100 mg', 'Losartan Potassium'), 
('708', 'Rostab   20 mg', '036-0657-61', 'Tablet', 'Acme Laboratories Ltd.', '25.08', '0.00', '20 mg', 'Rosuvastatin'), 
('709', 'Rostab   10 mg', '036-0656-61', 'Tablet', 'Acme Laboratories Ltd.', '20.07', '0.00', '10 mg', 'Rosuvastatin'), 
('710', 'Betaone   50 mg', '036-0655-22', 'Tablet', 'Acme Laboratories Ltd.', '2.00', '0.00', '50 mg', 'Metoprolol Tartrate'), 
('711', 'Skelofen   10 mg', '036-0668-70', 'Tablet', 'Acme Laboratories Ltd.', '8.03', '0.00', '10 mg', 'Baclofen'), 
('712', 'Fluzin   10 mg', '036-06737', 'Tablet', 'Acme Laboratories Ltd.', '5.01', '0.00', '10 mg', 'Flunarizine'), 
('713', 'Fluzin   5 mg', '036-06727', 'Tablet', 'Acme Laboratories Ltd.', '3.01', '0.00', '5 mg', 'Flunarizine'), 
('714', 'Versil   4 mg', '036-0671-22', 'Tablet', 'Acme Laboratories Ltd.', '12.09', '0.00', '4 mg', 'Perindopril Erbumine'), 
('715', 'Gabon   300 mg', '036-0674-046', 'Tablet', 'Acme Laboratories Ltd.', '16.04', '0.00', '300 mg', 'Gabapentin'), 
('716', 'Janvia   50 mg', '036-0675', 'Tablet', 'Acme Laboratories Ltd.', '15.04', '0.00', '50 mg', 'Sitagliptin'), 
('717', 'Janvia   100 mg', '036-0676', 'Tablet', 'Acme Laboratories Ltd.', '28.08', '0.00', '100 mg', 'Sitagliptin'), 
('718', 'Etogesic SR   600 mg', '036-0692-64', 'Tablet', 'Acme Laboratories Ltd.', '15.04', '0.00', '600 mg', 'Etodolac'), 
('719', 'Betabis   2.5 mg', '036-0693-22', 'Tablet', 'Acme Laboratories Ltd.', '6.01', '0.00', '2.5 mg', 'Bisoprolol Hemifumarate'), 
('720', 'Betabis   5 mg', '036-0694-22', 'Tablet', 'Acme Laboratories Ltd.', '10.03', '0.00', '5 mg', 'Bisoprolol Hemifumarate'), 
('721', 'Prasugen   5 mg', '036-0695-26', 'Tablet', 'Acme Laboratories Ltd.', '12.03', '0.00', '5 mg', 'Prasugrel'), 
('722', 'Prasugen   10 mg', '036-0696-26', 'Tablet', 'Acme Laboratories Ltd.', '20.07', '0.00', '10 mg', 'Prasugrel'), 
('723', 'Alanil   120 mg', '036-0698-21', 'Tablet', 'Acme Laboratories Ltd.', '6.52', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('724', 'Alanil   180 mg', '036-0704-21', 'Tablet', 'Acme Laboratories Ltd.', '8.03', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('725', 'Picidin   5 mg', '036-0706-025', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Procyclidine Hydrochloride'), 
('726', 'Goustat   40 mg', '036-0705-76', 'Tablet', 'Acme Laboratories Ltd.', '12.03', '0.00', '40 mg', 'Febuxostat'), 
('727', 'Pavigard   2 mg', '036-0687-61', 'Tablet', 'Acme Laboratories Ltd.', '10.03', '0.00', '2 mg', 'Pitavastatin'), 
('728', 'Vildapin   50 mg', '036-0711', 'Tablet', 'Acme Laboratories Ltd.', '15.04', '0.00', '50 mg', 'Vildagliptin'), 
('729', 'Unipril   1.25 mg', '036-0718-022', 'Tablet', 'Acme Laboratories Ltd.', '2.51', '0.00', '1.25 mg', 'Ramipril'), 
('730', 'Skelofen   5 mg', '036-0719-70', 'Tablet', 'Acme Laboratories Ltd.', '4.51', '0.00', '5 mg', 'Baclofen'), 
('731', 'Megafil   5 mg', '036-0731-043', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Tadalafil'), 
('732', 'Elodep   5 mg', '036-07614', 'Tablet', 'Acme Laboratories Ltd.', '5.52', '0.00', '5 mg', 'Escitalopram'), 
('733', 'Elodep   10 mg', '036-07624', 'Tablet', 'Acme Laboratories Ltd.', '10.03', '0.00', '10 mg', 'Escitalopram'), 
('734', 'Orbas   20 mg', '036-0763-22', 'Tablet', 'Acme Laboratories Ltd.', '8.03', '0.00', '20 mg', 'Olmesartan Medoxomil'), 
('735', 'Orbas   40 mg', '036-0764-22', 'Tablet', 'Acme Laboratories Ltd.', '15.04', '0.00', '40 mg', 'Olmesartan Medoxomil'), 
('736', 'Lacosam   50 mg', '036-0765-013', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Lacosamide'), 
('737', 'Lacosam0   100 mg', '036-0766-013', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Lacosamide'), 
('738', 'Acivir   200 mg', '036-0768-32', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Acyclovir'), 
('739', 'Acivir0   400 mg', '036-0769-32', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '400 mg', 'Acyclovir'), 
('740', 'Vinpoton   5 mg', '036-0771-36', 'Tablet', 'Acme Laboratories Ltd.', '4.01', '0.00', '5 mg', 'Vinpocetine'), 
('741', 'Gliclid MR   30 mg', '036-0772', 'Tablet', 'Acme Laboratories Ltd.', '6.01', '0.00', '30 mg', 'Gliclazide'), 
('742', 'Sizomax   1 mg', '036-0773-28', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '1 mg', 'Risperidone'), 
('743', 'Sizomax   2 mg', '036-0774-28', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '2 mg', 'Risperidone'), 
('744', 'Sizomax   4 mg', '036-0775-28', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '4 mg', 'Risperidone'), 
('745', 'A-Meb   135 mg', '036-07501', 'Tablet', 'Acme Laboratories Ltd.', '6.01', '0.00', '135 mg', 'Mebeverine Hydrochloride'), 
('746', 'Rupastin   10 mg', '036-0751-21', 'Tablet', 'Acme Laboratories Ltd.', '10.03', '0.00', '10 mg', 'Rupatadine'), 
('747', 'Acmegra   25 mg', '036-0752-043', 'Tablet', 'Acme Laboratories Ltd.', '20.07', '0.00', '25 mg', 'Sildenafil'), 
('748', 'Acmegra   50 mg', '036-0753-043', 'Tablet', 'Acme Laboratories Ltd.', '30.10', '0.00', '50 mg', 'Sildenafil'), 
('749', 'Acmegra   100 mg', '036-0754-043', 'Tablet', 'Acme Laboratories Ltd.', '50.14', '0.00', '100 mg', 'Sildenafil'), 
('750', 'Misoclear   600 mcg', '036-07569', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '600 mcg', 'Misoprostol'), 
('751', 'Ecosprin   150 mg', '036-0781-26', 'Tablet', 'Acme Laboratories Ltd.', '0.92', '0.00', '150 mg', 'Aspirin'), 
('752', 'Valtin   80 mg', '036-0782-22', 'Tablet', 'Acme Laboratories Ltd.', '9.03', '0.00', '80 mg', 'Valsartan'), 
('753', 'Valtin   160 mg', '036-0783-22', 'Tablet', 'Acme Laboratories Ltd.', '16.04', '0.00', '160 mg', 'Valsartan'), 
('754', 'Floxigem   320 mg', '036-0785-23', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '320 mg', 'Gemefloxacin'), 
('755', 'Milast-A   500 mcg', '036-07904', 'Tablet', 'Acme Laboratories Ltd.', '15.04', '0.00', '500 mcg', 'Roflumilast'), 
('756', 'Mediprist   200 mg', '036-0797-049', 'Tablet', 'Acme Laboratories Ltd.', '280.84', '0.00', '200 mg', 'Mifepristone'), 
('757', 'Ecosprin   100 mg', '036-0796-26', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Aspirin'), 
('758', 'Trasin   2 mg', '036-0802-22', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '2 mg', 'Terazosin'), 
('759', 'Trasin   5 mg', '036-0803-22', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Terazosin'), 
('760', 'Rostab   5 mg', '036-0805-61', 'Tablet', 'Acme Laboratories Ltd.', '10.03', '0.00', '5 mg', 'Rosuvastatin'), 
('761', 'Ibsan   300 mg', '036-0806-22', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '300 mg', 'Irbesartan'), 
('762', 'Betaone   25 mg', '036-0808-22', 'Tablet', 'Acme Laboratories Ltd.', '1.51', '0.00', '25 mg', 'Metoprolol Tartrate'), 
('763', 'Aximin   200 mg', '036-0814-23', 'Tablet', 'Acme Laboratories Ltd.', '20.07', '0.00', '200 mg', 'Rifaximin'), 
('764', 'Aximin   550 mg', '036-0815-23', 'Tablet', 'Acme Laboratories Ltd.', '45.13', '0.00', '550 mg', 'Rifaximin'), 
('765', 'Maxima   20 mg', '036-0854-067', 'Tablet', 'Acme Laboratories Ltd.', '5.00', '0.00', '20 mg', 'Esomeprazole'), 
('766', 'Maxima   40 mg', '036-0855-67', 'Tablet', 'Acme Laboratories Ltd.', '8.00', '0.00', '40 mg', 'Esomeprazole'), 
('767', 'Rhitin   10 mg', '036-0857-21', 'Tablet', 'Acme Laboratories Ltd.', '6.00', '0.00', '10 mg', 'Ebastine'), 
('768', 'Lino   5 mg', '036-0865-015', 'Tablet', 'Acme Laboratories Ltd.', '15.00', '0.00', '5 mg', 'Linagliptin'), 
('769', 'Cubimox   400 mg', '036-0866-23', 'Tablet', 'Acme Laboratories Ltd.', '40.00', '0.00', '400 mg', 'Moxifloxacin'), 
('770', 'Defrol   1000 IU', '036-0868-78', 'Tablet', 'Acme Laboratories Ltd.', '2.00', '0.00', '1000 IU', 'Cholecalciferol (Vit. D3)'), 
('771', 'Salmolin   2 mg', '036-08794', 'Tablet', 'Acme Laboratories Ltd.', '0.26', '0.00', '2 mg', 'Salbutamol'), 
('772', 'Fenoxilin   250 mg', '036-0880-23', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Phenoxymethyl Penicillin'), 
('773', 'Lactocal   300 mg', '036-0881-62', 'Tablet', 'Acme Laboratories Ltd.', '0.30', '0.00', '300 mg', 'Calcium Lactate'), 
('774', 'Fezol   2.5 mg', '036-0886', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '2.5 mg', 'Letrozole'), 
('775', 'Tibofem   2.5 mg', '036-08876', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '2.5 mg', 'Tibolone'), 
('776', 'Zilsart   40 mg', '036-0888-', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '40 mg', 'Azilsartan Medoxomil'), 
('777', 'Zilsart   80 mg', '036-0889-', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '80 mg', 'Azilsartan Medoxomil'), 
('778', 'O-Cal   740 mg', '036-0890-62', 'Tablet', 'Acme Laboratories Ltd.', '10.00', '0.00', '740 mg', 'Calcium Orotate'), 
('779', 'Cortimax   6 mg', '036-0891-72', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '6 mg', 'Deflazacort'), 
('780', 'Sevel   800 mg', '036-0893', 'Tablet', 'Acme Laboratories Ltd.', '60.00', '0.00', '800 mg', 'Sevelamer (As Carbonate)'), 
('781', 'Dophylin   400 mg', '036-08944', 'Tablet', 'Acme Laboratories Ltd.', '8.00', '0.00', '400 mg', 'Doxophylline'), 
('782', 'Duocard   5 mg', '036-0908-22', 'Tablet', 'Acme Laboratories Ltd.', '7.00', '0.00', '5 mg', 'Cilnidipine'), 
('783', 'Duocard   10 mg', '036-0909-22', 'Tablet', 'Acme Laboratories Ltd.', '9.00', '0.00', '10 mg', 'Cilnidipine'), 
('784', 'Patron   .5 mg', '036-09148', 'Tablet', 'Acme Laboratories Ltd.', '20.00', '0.00', '.5 mg', 'Palonosetron'), 
('785', 'Dophylin   200 mg', '036-09324', 'Tablet', 'Acme Laboratories Ltd.', '5.00', '0.00', '200 mg', 'Doxophylline'), 
('786', 'Thyrolar   12.5 mcg', '036-0935-74', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '12.5 mcg', 'Levothyroxine Sodium'), 
('787', 'Thyrolar   75 mcg', '036-936-74', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '75 mcg', 'Levothyroxine Sodium'), 
('788', 'Solicare   5 mg', '036-09431', 'Tablet', 'Acme Laboratories Ltd.', '15.00', '0.00', '5 mg', 'Solifenacin Succinate'), 
('789', 'Solicare   10 mg', '036-09441', 'Tablet', 'Acme Laboratories Ltd.', '30.00', '0.00', '10 mg', 'Solifenacin Succinate'), 
('790', 'Benazole   600 mg', '036-0218-077', 'Bolus', 'Acme Laboratories Ltd.', '7.44', '0.00', '600 mg', 'Albendazole'), 
('791', 'Dirozyl   2 gm', '036-0419-077', 'Bolus', 'Acme Laboratories Ltd.', '0.00', '0.00', '2 gm', 'Metronidazole'), 
('792', 'Hexatin   1 gm', '036-0210-077', 'Bolus', 'Acme Laboratories Ltd.', '0.00', '0.00', '1 gm', 'Hexachlorophene'), 
('793', 'Levavet   600 mg', '036-0216-077', 'Bolus', 'Acme Laboratories Ltd.', '7.12', '0.00', '600 mg', 'Levamisole'), 
('794', 'Tetra   500 mg', '036-0219-077', 'Bolus', 'Acme Laboratories Ltd.', '3.01', '0.00', '500 mg', 'Oxytetracycline'), 
('795', 'Tetravet   1 gm', '036-0220-077', 'Bolus', 'Acme Laboratories Ltd.', '0.00', '0.00', '1 gm', 'Oxytetracycline'), 
('796', 'Fast Vet   2 gm', '036-0476-077', 'Bolus', 'Acme Laboratories Ltd.', '2.27', '0.00', '2 gm', 'Paracetamol'), 
('797', 'Sulfasol Vet   5 gm', '036-0475-077', 'Bolus', 'Acme Laboratories Ltd.', '12.03', '0.00', '5 gm', 'Sulphadimidine'), 
('798', 'Moxillin Vet   1 gm', '036-0653-077', 'Bolus', 'Acme Laboratories Ltd.', '10.03', '0.00', '1 gm', 'Amoxicillin'), 
('799', 'Steron Vet   10 mg', '036-0678-077', 'Bolus', 'Acme Laboratories Ltd.', '5.01', '0.00', '10 mg', 'Dexamethasone'), 
('800', 'Zis-Vet   200 mg', '036-0689-77', 'Bolus', 'Acme Laboratories Ltd.', '6.01', '0.00', '200 mg', 'Zinc'), 
('801', 'Met-Vet   100 mg', '036-0688-077', 'Bolus', 'Acme Laboratories Ltd.', '6.01', '0.00', '100 mg', 'Meloxicam'), 
('802', 'Keto-A Vet   400 mg', '036-0729-077', 'Bolus', 'Acme Laboratories Ltd.', '10.03', '0.00', '400 mg', 'Ketoprofen'), 
('803', 'Cipro-A Vet   750 mg', '036-0747-077', 'Bolus', 'Acme Laboratories Ltd.', '0.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('804', 'Cipro-A Vet0   1 gm', '036-0748-077', 'Bolus', 'Acme Laboratories Ltd.', '20.07', '0.00', '1 gm', 'Ciprofloxacin'), 
('805', 'Fenazol Vet   250 mg', '036-0816-077', 'Bolus', 'Acme Laboratories Ltd.', '5.76', '0.00', '250 mg', 'Fenbendazole'), 
('806', 'Phenadryl Vet   500 mg', '036-0874-', 'Bolus', 'Acme Laboratories Ltd.', '4.00', '0.00', '500 mg', 'Diphenhydramine Hydrochloride'), 
('807', 'A-Cold Vet   100 mg', '036-0921-077', 'Bolus', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Bromhexine Hydrochloride'), 
('808', 'Trizon  IM   250 mg', '036-0228-23', 'IM Injection', 'Acme Laboratories Ltd.', '100.30', '0.00', '250 mg', 'Ceftriaxone'), 
('809', 'Trizon  IV   1 gm', '036-0234-23', 'IV Injection', 'Acme Laboratories Ltd.', '143.97', '0.00', '1 gm', 'Ceftriaxone'), 
('810', 'Trizon  IV   2 gm', '036-0389-23', 'IV Injection', 'Acme Laboratories Ltd.', '261.77', '0.00', '2 gm', 'Ceftriaxone'), 
('811', 'Trizon  IV   500 mg', '036-0230-23', 'IV Injection', 'Acme Laboratories Ltd.', '130.39', '0.00', '500 mg', 'Ceftriaxone'), 
('812', 'Trizon  IV   250 mg', '036-0229-23', 'IV Injection', 'Acme Laboratories Ltd.', '100.30', '0.00', '250 mg', 'Ceftriaxone'), 
('813', 'Acmecilin   500 mg', '036-0125-23', 'IV/IM Injection', 'Acme Laboratories Ltd.', '27.32', '0.00', '500 mg', 'Ampicillin'), 
('814', 'Acmecilin   250 mg', '036-0124-23', 'IV/IM Injection', 'Acme Laboratories Ltd.', '19.43', '0.00', '250 mg', 'Ampicillin'), 
('815', 'Aminoplex   5 %', '036-0726-3', 'IV Infusion', 'Acme Laboratories Ltd.', '402.72', '0.00', '5 %', 'Amino Acids (Essential)'), 
('816', 'Azolin  NS   .05 %', '036-03462', 'Nasal Drops', 'Acme Laboratories Ltd.', '45.13', '0.00', '.05 %', 'Oxymetazoline Hydrochloride'), 
('817', 'Clotrim  VT    200 mg', '036-0532', 'Vaginal Tablet', 'Acme Laboratories Ltd.', '20.13', '0.00', '200 mg', 'Clotrimazole'), 
('818', 'Clotrim   200 mg', '036-0511', 'Vaginal Suppository', 'Acme Laboratories Ltd.', '20.13', '0.00', '200 mg', 'Clotrimazole'), 
('819', 'Ascon Inhalation Aer   100 mcg', '036-03684', 'Inhalation Solution', 'Acme Laboratories Ltd.', '270.81', '0.00', '100 mcg', 'Beclomethasone Dipropionate'), 
('820', 'Ascon   250 mcg', '036-04264', 'Inhalation Solution', 'Acme Laboratories Ltd.', '320.96', '0.00', '250 mcg', 'Beclomethasone Dipropionate'), 
('821', 'Beclod      200 mcg', '036-03274', 'Inhalation Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '200 mcg', 'Beclomethasone Dipropionate'), 
('822', 'Fluticon  DPI    100 mcg', '036-03314', 'Inhalation Capsule', 'Acme Laboratories Ltd.', '4.28', '0.00', '100 mcg', 'Fluticasone Propionate'), 
('823', 'Fluticon      50 mcg', '036-03304', 'Inhalation Capsule', 'Acme Laboratories Ltd.', '2.52', '0.00', '50 mcg', 'Fluticasone Propionate'), 
('824', 'Fluticon   500 mcg', '036-03994', 'Inhalation Capsule', 'Acme Laboratories Ltd.', '13.09', '0.00', '500 mcg', 'Fluticasone Propionate'), 
('825', 'Fluticon   250 mcg', '036-03984', 'Inhalation Capsule', 'Acme Laboratories Ltd.', '8.07', '0.00', '250 mcg', 'Fluticasone Propionate'), 
('826', 'Salmerol   25 mcg', '036-03924', 'Inhalation Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '25 mcg', 'Salmeterol'), 
('827', 'Salmolin      200 mcg', '036-03284', 'Inhalation Capsule', 'Acme Laboratories Ltd.', '2.51', '0.00', '200 mcg', 'Salbutamol'), 
('828', 'Salmolin      100 mcg', '036-03704', 'Inhalation Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 mcg', 'Salbutamol'), 
('829', 'Tropium   40 mcg', '036-03614', 'Inhalation Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '40 mcg', 'Ipratropium Bromide'), 
('830', 'Topium DPI   18 mcg', '036-04744', 'Inhalation Capsule', 'Acme Laboratories Ltd.', '5.03', '0.00', '18 mcg', 'Tiotropium'), 
('831', 'Indica DPI   75 mcg', '036-09134', 'Inhalation Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '75 mcg', 'Indacaterol'), 
('832', 'Darifen ER   7.5 mg', '036-06199', 'Pr Tablet', 'Acme Laboratories Ltd.', '22.07', '0.00', '7.5 mg', 'Darifenacin'), 
('833', 'Darifen ER   15 mg', '036-06209', 'Pr Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '15 mg', 'Darifenacin'), 
('834', 'Lactos   300 mg', '036-0899-', 'Chewable Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '300 mg', 'Lactase'), 
('835', 'Daomin   1 gm', '036-0612', 'Xr Tablet', 'Acme Laboratories Ltd.', '7.02', '0.00', '1 gm', 'Metformin Hydrochloride'), 
('836', 'Fast XR   665 mg', '036-0660-6', 'Xr Tablet', 'Acme Laboratories Ltd.', '1.51', '0.00', '665 mg', 'Paracetamol'), 
('837', 'Daomin XR   500 mg', '036-0702', 'Xr Tablet', 'Acme Laboratories Ltd.', '5.01', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('838', 'A Fenac  SR    100 mg', '036-0307-64', 'Sr Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('839', 'A Fenac  SR    100 mg', '036-0144-64', 'Sr Tablet', 'Acme Laboratories Ltd.', '3.01', '0.00', '100 mg', 'Diclofenac Sodium'), 
('840', 'PPI   20 mg', '364-0015-67', 'Capsule', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Omeprazole'), 
('841', 'PPI   40 mg', '364-0016-67', 'Capsule', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Omeprazole'), 
('842', 'Maxima   20 mg', '364-0017-067', 'Capsule', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Esomeprazole'), 
('843', 'Maxima   40 mg', '364-0018-067', 'Capsule', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Esomeprazole'), 
('844', 'Dolonil   50 mg', '364-0019-65', 'Capsule', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('845', 'Azin   250 mg', '364-0020-23', 'Capsule', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Azithromycin'), 
('846', 'Lifil-E   200 mg', '364-0062-78', 'Capsule', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Vitamin E'), 
('847', 'Lifil-E0   400 mg', '364-0063-78', 'Capsule', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Vitamin E'), 
('848', 'Don-A   10 mg', '364-00018', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Domperidone'), 
('849', 'Ranidin F/C   150 mg', '364-00025', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Ranitidine'), 
('850', 'Ranidin F/C   300 mg', '364-00035', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Ranitidine'), 
('851', 'Fast   500 mg', '364-0004-006', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('852', 'A-Cal   625 mg', '364-0006-62', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '625 mg', 'Calcium Carbonate'), 
('853', 'Cetizin   10 mg', '364-0007-21', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('854', 'Cipro-A   250 mg', '364-0008-23', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Ciprofloxacin'), 
('855', 'Cipro-A   500 mg', '364-0009-23', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('856', 'Cipro-A   750 mg', '364-0010-23', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('857', 'Azin   500 mg', '364-0011-23', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('858', 'Tenoloc   100 mg', '364-0012-22', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Atenolol'), 
('859', 'Tenoloc   50 mg', '364-0013-22', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Atenolol'), 
('860', 'A-Cal   1250 mg', '364-0014-62', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('861', 'Ecosprin   75 mg', '364-0025-26', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '75 mg', 'Aspirin'), 
('862', 'Ecosprin   300 mg', '364-0026-6', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Aspirin'), 
('863', 'Monas   4 mg', '364-0028-044', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '4 mg', 'Montelukast'), 
('864', 'Monas   5 mg', '364-0029-044', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Montelukast'), 
('865', 'Tinium   50 mg', '364-00271', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('866', 'Monas   10 mg', '364-0030-044', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Montelukast'), 
('867', 'Tenil   3 mg', '364-00327', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '3 mg', 'Bromazepam'), 
('868', 'A-Fenac   25 mg', '364-0033-64', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Diclofenac Sodium'), 
('869', 'A-Fenac   50 mg', '364-0034-64', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('870', 'A-Fenac K   50 mg', '364-0036-64', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Diclofenac Potassium'), 
('871', 'Apitac   100 mg', '364-0037-64', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Aceclofenac'), 
('872', 'Baby Zinc   20 mg', '364-0038-62', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Zinc'), 
('873', 'Napro-A   250 mg', '364-0039-64', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Naproxen'), 
('874', 'Napro-A   500 mg', '364-0040-64', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Naproxen'), 
('875', 'Amlopin   5 mg', '364-0041-022', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Amlodipine'), 
('876', 'Amlopin   10 mg', '364-0042-022', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Amlodipine'), 
('877', 'Winop   10 mg', '364-0046-064', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('878', 'Dolonil SR   100 mg', '364-0047-65', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Tramadol Hydrochloride'), 
('879', 'Tracid0   500 mg', '364-00489', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Tranexamic Acid'), 
('880', 'Dirozyl   200 mg', '364-0049-27', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Metronidazole'), 
('881', 'Dirozyl   400 mg', '364-0050-27', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('882', 'Fluconal   50 mg', '364-0051', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Fluconazole'), 
('883', 'Fluconal   150 mg', '364-0052', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Fluconazole'), 
('884', 'Cecon   250 mg', '364-0054-78', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Vitamin C'), 
('885', 'Leo   250 mg', '364-0056-23', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Levofloxacin'), 
('886', 'Leo0   500 mg', '364-0057-23', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Levofloxacin'), 
('887', 'Leo0   750 mg', '364-0058-23', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '750 mg', 'Levofloxacin'), 
('888', 'Nidozox   500 mg', '364-0060-27', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Nitazoxanide'), 
('889', 'Misoclear   200 mcg', '364-00619', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '200 mcg', 'Misoprostol'), 
('890', 'A-Fenac SR   100 mg', '364-0035-64', 'Sr Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('891', 'Disposible Syringe ml   10 ml', '280-00041', 'Syringe', 'Acmunio International Ltd.', '0.00', '0.00', '10 ml', 'Disposable Syringe'), 
('892', 'CADY AD Syringe   .5 ml', '280-00011', 'Syringe', 'Acmunio International Ltd.', '0.00', '0.00', '.5 ml', 'Disposable Syringe'), 
('893', 'BECKY 3 ml AD & RPF Syringe   3 ml', '280-00021', 'Syringe', 'Acmunio International Ltd.', '0.00', '0.00', '3 ml', 'Disposable Syringe'), 
('894', 'BECKY ml AD & RPF Syringe   5 ml', '280-00031', 'Syringe', 'Acmunio International Ltd.', '0.00', '0.00', '5 ml', 'Disposable Syringe'), 
('895', 'Cefatop   200 mg', '355-0069-23', 'Capsule', 'Active Fine Chemicals Ltd.', '0.00', '0.00', '200 mg', 'Cefixime'), 
('896', 'Cefufine   500 mg', '355-0066-23', 'Tablet', 'Active Fine Chemicals Ltd.', '0.00', '0.00', '500 mg', 'Cefuroxime'), 
('897', 'Cefufine   250 mg', '355-0067-23', 'Tablet', 'Active Fine Chemicals Ltd.', '0.00', '0.00', '250 mg', 'Cefuroxime'), 
('898', 'Maxtrol   20 mg', '355-0070-067', 'Tablet', 'Active Fine Chemicals Ltd.', '0.00', '0.00', '20 mg', 'Esomeprazole'), 
('899', 'Atofine   20 mg', '355-0071-061', 'Tablet', 'Active Fine Chemicals Ltd.', '0.00', '0.00', '20 mg', 'Atorvastatin'), 
('900', 'Atofine   10 mg', '355-0072-061', 'Tablet', 'Active Fine Chemicals Ltd.', '0.00', '0.00', '10 mg', 'Atorvastatin'), 
('901', 'Azifine   500 mg', '355-0074-23', 'Tablet', 'Active Fine Chemicals Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('902', 'Glorinta   90 mg', '355-0075-26', 'Tablet', 'Active Fine Chemicals Ltd.', '0.00', '0.00', '90 mg', 'Ticagrelor'), 
('903', 'Rosufine   10 mg', '355-0076-61', 'Tablet', 'Active Fine Chemicals Ltd.', '0.00', '0.00', '10 mg', 'Rosuvastatin'), 
('904', 'J Mox   250 mg', '084-0019-023', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '2.86', '0.00', '250 mg', 'Amoxicillin'), 
('905', 'Jefenac  TR    100 mg', '084-0043-64', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '3.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('906', 'J Mox   500 mg', '084-0039-23', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '5.71', '0.00', '500 mg', 'Amoxicillin'), 
('907', 'Jedine   250 mg', '084-0053-023', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Cephradine'), 
('908', 'Jedine   500 mg', '084-0054-23', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '12.50', '0.00', '500 mg', 'Cephradine'), 
('909', 'Omrazole      20 mg', '084-0058-67', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '4.50', '0.00', '20 mg', 'Omeprazole'), 
('910', 'Cefixime A     200 mg', '084-0077-23', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '25.00', '0.00', '200 mg', 'Cefixime'), 
('911', 'Somazole      20 mg', '084-0087-067', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '5.00', '0.00', '20 mg', 'Esomeprazole'), 
('912', 'Oxacol   500 mg', '084-0088-23', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '9.00', '0.00', '500 mg', 'Flucloxacillin'), 
('913', 'Trigal   50 mg', '084-0093', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '7.00', '0.00', '50 mg', 'Fluconazole'), 
('914', 'Trigal   150 mg', '084-0094', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '18.00', '0.00', '150 mg', 'Fluconazole'), 
('915', 'Mucovan   75 mg', '084-0106-31', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '75 mg', 'Ambroxol'), 
('916', 'Ultradol   50 mg', '084-0127-65', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '7.50', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('917', 'Omrazol   40 mg', '084-0128-67', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '7.00', '0.00', '40 mg', 'Omeprazole'), 
('918', 'Somazole   40 mg', '084-0133-067', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '8.00', '0.00', '40 mg', 'Esomeprazole'), 
('919', 'Ultradol   100 mg', '084-0171-65', 'Suppository', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Tramadol Hydrochloride'), 
('920', 'Neofenac   50 mg', '084-0146-064', 'Suppository', 'Ad-din Pharmaceuticals Ltd.', '12.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('921', 'Neofenac   12.5 mg', '084-0145-064', 'Suppository', 'Ad-din Pharmaceuticals Ltd.', '7.50', '0.00', '12.5 mg', 'Diclofenac Sodium'), 
('922', 'Feva   250 mg', '084-0143-006', 'Suppository', 'Ad-din Pharmaceuticals Ltd.', '5.00', '0.00', '250 mg', 'Paracetamol'), 
('923', 'Feva   125 mg', '084-0142-006', 'Suppository', 'Ad-din Pharmaceuticals Ltd.', '4.00', '0.00', '125 mg', 'Paracetamol'), 
('924', 'Aldaben  DS   400 mg', '084-0028-008', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '4.00', '0.00', '400 mg', 'Albendazole'), 
('925', 'Alerjess   4 mg', '084-0030-21', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.20', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('926', 'Ciproxen   250 mg', '084-0034-23', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '7.00', '0.00', '250 mg', 'Ciprofloxacin'), 
('927', 'Feva   500 mg', '084-0022-006', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.75', '0.00', '500 mg', 'Paracetamol'), 
('928', 'Metra   400 mg', '084-0029-27', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '1.05', '0.00', '400 mg', 'Metronidazole'), 
('929', 'Neofenac      50 mg', '084-0035-64', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.60', '0.00', '50 mg', 'Diclofenac Sodium'), 
('930', 'Ranitack      150 mg', '084-00365', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '1.50', '0.00', '150 mg', 'Ranitidine'), 
('931', 'Ciproxen   500 mg', '084-0038-23', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '14.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('932', 'Cirizin   10 mg', '084-0062-21', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '2.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('933', 'Gutset   10 mg', '084-00668', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '2.00', '0.00', '10 mg', 'Domperidone'), 
('934', 'Calcium A   1250 mg', '084-0068-62', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '2.50', '0.00', '1250 mg', 'Calcium Carbonate'), 
('935', 'Fleco   100 mg', '084-0069-64', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '2.50', '0.00', '100 mg', 'Aceclofenac'), 
('936', 'Adrest   3 mg', '084-00737', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '3 mg', 'Bromazepam'), 
('937', 'Clozepam   .5 mg', '084-0074-046', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '.5 mg', 'Clonazepam'), 
('938', 'Adapen   10 mg', '084-00801', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('939', 'Cladin   10 mg', '084-0081-21', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '2.25', '0.00', '10 mg', 'Loratadine'), 
('940', 'Aldaben      200 mg', '084--008', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Albendazole'), 
('941', 'Cevozin      5 mg', '084-0072-21', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '2.00', '0.00', '5 mg', 'Levocetirizine Hydrochloride'), 
('942', 'Adlorin      5 mg', '084-0070-21', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '2.50', '0.00', '5 mg', 'Desloratadine'), 
('943', 'Toperol   200 mg', '084-0089-78', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Vitamin E'), 
('944', 'Guamin   850 mg', '084-0090', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '3.00', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('945', 'Onevit   100 mg', '084-0091-78', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.74', '0.00', '100 mg', 'Thiamine Hydrochloride'), 
('946', 'Sugred   80 mg', '084-0102', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '6.00', '0.00', '80 mg', 'Gliclazide'), 
('947', 'Vinzam   500 mg', '084-0108-23', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '25.00', '0.00', '500 mg', 'Azithromycin'), 
('948', 'Lacor   10 mg', '084-0110-064', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '9.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('949', 'Aslic   75 mg', '084-0112-26', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '75 mg', 'Aspirin'), 
('950', 'Avidol   6.25 mg', '084-0113-22', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '3.00', '0.00', '6.25 mg', 'Carvedilol'), 
('951', 'Cartace   2.5 mg', '084-0114-022', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '4.60', '0.00', '2.5 mg', 'Ramipril'), 
('952', 'Clogrel   75 mg', '084-0115-26', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '9.00', '0.00', '75 mg', 'Clopidogrel'), 
('953', 'Nopidin   5 mg', '084-0116-022', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '3.00', '0.00', '5 mg', 'Amlodipine'), 
('954', 'Prolol   50 mg', '084-0117-22', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '1.30', '0.00', '50 mg', 'Metoprolol Tartrate'), 
('955', 'Ribomin   5 mg', '084-0118-79', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.23', '0.00', '5 mg', 'Riboflavin'), 
('956', 'Folate   5 mg', '084-01195', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.30', '0.00', '5 mg', 'Folic Acid'), 
('957', 'Relofen   10 mg', '084-0125-70', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '8.00', '0.00', '10 mg', 'Baclofen'), 
('958', 'Ultranax   500 mg', '084-0126-64', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '8.00', '0.00', '500 mg', 'Naproxen'), 
('959', 'Meczin   50 mg', '084-01298', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '2.50', '0.00', '50 mg', 'Meclizine Hydrochloride'), 
('960', 'Xofast   60 mg', '084-0131-21', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '3.50', '0.00', '60 mg', 'Fexofenadine Hydrochloride'), 
('961', 'Xofast   120 mg', '084-0132-21', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '6.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('962', 'Calonil   8 mg', '084-0162', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '1.00', '0.00', '8 mg', 'Sucralose'), 
('963', 'Pizobet   15 mg', '084-0137', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '15 mg', 'Pioglitazone'), 
('964', 'Vastor   10 mg', '084-0139-061', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '10.00', '0.00', '10 mg', 'Atorvastatin'), 
('965', 'Nixpan   20 mg', '084-0134-67', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '3.00', '0.00', '20 mg', 'Pantoprazole'), 
('966', 'Nixpan   40 mg', '084-0135-67', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '5.00', '0.00', '40 mg', 'Pantoprazole'), 
('967', 'Glaryl   1 mg', '084-0149', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '2.50', '0.00', '1 mg', 'Glimepiride'), 
('968', 'Glaryl   2 mg', '084-0150', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '4.00', '0.00', '2 mg', 'Glimepiride'), 
('969', 'D-Met   500 mg', '084-0163', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('970', 'Atonul   50 mg', '084-0164-22', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Atenolol'), 
('971', 'Carlos   50 mg', '084-0165-022', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Losartan Potassium'), 
('972', 'Aroxia   60 mg', '084-0095-64', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '6.00', '0.00', '60 mg', 'Etoricoxib'), 
('973', 'Aroxia   90 mg', '084-0096-64', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '8.00', '0.00', '90 mg', 'Etoricoxib'), 
('974', 'Aroxia   120 mg', '084-0097-64', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '10.00', '0.00', '120 mg', 'Etoricoxib'), 
('975', 'Quiva   500 mg', '084-0098-23', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '13.00', '0.00', '500 mg', 'Levofloxacin'), 
('976', 'Tium   50 mg', '084-00991', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '3.50', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('977', 'Proxa-A   500 mg', '084-0100-27', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '9.00', '0.00', '500 mg', 'Nitazoxanide'), 
('978', 'Adrazin   100 %', '367-0015-077', 'Powder', 'Advent Pharma Ltd.', '0.00', '0.00', '100 %', 'Piperazine'), 
('979', 'Adrizol   600 mg', '367-0001-077', 'Bolus', 'Advent Pharma Ltd.', '0.00', '0.00', '600 mg', 'Albendazole'), 
('980', 'Adzyl   2 gm', '367-0002-077', 'Bolus', 'Advent Pharma Ltd.', '0.00', '0.00', '2 gm', 'Metronidazole'), 
('981', 'AD-Tetra   500 mg', '367-0003-077', 'Bolus', 'Advent Pharma Ltd.', '0.00', '0.00', '500 mg', 'Oxytetracycline'), 
('982', 'Adcet   2 gm', '367-0004-077', 'Bolus', 'Advent Pharma Ltd.', '0.00', '0.00', '2 gm', 'Paracetamol'), 
('983', 'Adprozin   150 mg', '367-0005-077', 'Bolus', 'Advent Pharma Ltd.', '0.00', '0.00', '150 mg', 'Promethazine Hydrochloride'), 
('984', 'Almolin Vet   30 %', '294-0006-077', 'Powder', 'Al-Madina Pharmaceuticals Ltd.', '235.83', '0.00', '30 %', 'Amoxicillin'), 
('985', 'Altetra   20 %', '294-0010-077', 'Powder', 'Al-Madina Pharmaceuticals Ltd.', '382.44', '0.00', '20 %', 'Oxytetracycline'), 
('986', 'Alcocci Pow Vet   30 %', '294-0019-077', 'Powder', 'Al-Madina Pharmaceuticals Ltd.', '40.62', '0.00', '30 %', 'Sulfaclozine'), 
('987', 'Alvasol   30 %', '294-0034-077', 'Powder', 'Al-Madina Pharmaceuticals Ltd.', '140.95', '0.00', '30 %', 'Levamisole'), 
('988', 'CS-Vet Plus Powder   500 Lac IU', '294-0060-077', 'Powder', 'Al-Madina Pharmaceuticals Ltd.', '710.00', '0.00', '500 Lac IU', 'Colistin Sulphate'), 
('989', 'Alcipro   Solution   10 gm', '294-0007-077', 'Solution', 'Al-Madina Pharmaceuticals Ltd.', '233.71', '0.00', '10 gm', 'Ciprofloxacin'), 
('990', 'Altetra   500 mg', '294-0009-077', 'Bolus', 'Al-Madina Pharmaceuticals Ltd.', '3.01', '0.00', '500 mg', 'Oxytetracycline'), 
('991', 'Wormfree   600 mg', '294-0014-077', 'Bolus', 'Al-Madina Pharmaceuticals Ltd.', '7.28', '0.00', '600 mg', 'Albendazole'), 
('992', 'Promethazine   150 mg', '294-0023-077', 'Bolus', 'Al-Madina Pharmaceuticals Ltd.', '3.34', '0.00', '150 mg', 'Promethazine Hydrochloride'), 
('993', 'Amovet   2 gm', '294-0025-077', 'Bolus', 'Al-Madina Pharmaceuticals Ltd.', '4.24', '0.00', '2 gm', 'Metronidazole'), 
('994', 'Alcipro   750 mg', '294-0035-077', 'Bolus', 'Al-Madina Pharmaceuticals Ltd.', '20.01', '0.00', '750 mg', 'Ciprofloxacin'), 
('995', 'Al-molin Vet   500 mg', '294-0021-077', 'Bolus', 'Al-Madina Pharmaceuticals Ltd.', '6.04', '0.00', '500 mg', 'Amoxicillin'), 
('996', 'Mexicam Bolus (Vet)   100 mg', '294-0047-077', 'Bolus', 'Al-Madina Pharmaceuticals Ltd.', '6.00', '0.00', '100 mg', 'Meloxicam'), 
('997', 'Antifever Bolus (Vet)   2 gm', '294-0029-077', 'Bolus', 'Al-Madina Pharmaceuticals Ltd.', '2.27', '0.00', '2 gm', 'Paracetamol'), 
('998', 'Sulmidine Bolus (Vet)   5 gm', '294-0031-077', 'Bolus', 'Al-Madina Pharmaceuticals Ltd.', '8.06', '0.00', '5 gm', 'Sulphadimidine'), 
('999', 'Albutil   2 mg', '096-00376', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '2 mg', 'Loperamide'), 
('1000', 'Mimox   250 mg', '096-0036-023', 'Capsule', 'Albion Laboratories Ltd.', '3.54', '0.00', '250 mg', 'Amoxicillin'), 
('1001', 'Amicap   250 mg', '096-0035-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Ampicillin'), 
('1002', 'Cefradine   500 mg', '096-0065-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Cephradine'), 
('1003', 'Cephalexin   250 mg', '096-0066-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Cephalexin'), 
('1004', 'Mardox      100 mg', '096-0011-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Doxycycline'), 
('1005', 'Moxatid   250 mg', '096-0005-023', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('1006', 'Moxatid   500 mg', '096-0004-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('1007', 'Lotil   20 mg', '096-0067-67', 'Capsule', 'Albion Laboratories Ltd.', '2.95', '0.00', '20 mg', 'Omeprazole'), 
('1008', 'Tetracap   250 mg', '096-0034-23', 'Capsule', 'Albion Laboratories Ltd.', '0.80', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('1009', 'Albulil      100 mg', '096-0037-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Doxycycline'), 
('1010', 'Azithron   500 mg', '096-0103-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('1011', 'Lanzopra   15 mg', '096-0117-67', 'Capsule', 'Albion Laboratories Ltd.', '3.50', '0.00', '15 mg', 'Lansoprazole'), 
('1012', 'Fluconazole   50 mg', '096-0127', 'Capsule', 'Albion Laboratories Ltd.', '4.00', '0.00', '50 mg', 'Fluconazole'), 
('1013', 'Fluconazole   150 mg', '096-0126', 'Capsule', 'Albion Laboratories Ltd.', '22.00', '0.00', '150 mg', 'Fluconazole'), 
('1014', 'Lanzopra   30 mg', '096-0139-67', 'Capsule', 'Albion Laboratories Ltd.', '6.00', '0.00', '30 mg', 'Lansoprazole'), 
('1015', 'Cefpodoxime   100 mg', '096-0191-23', 'Capsule', 'Albion Laboratories Ltd.', '22.00', '0.00', '100 mg', 'Cefpodoxime'), 
('1016', 'Cefiac0   400 mg', '096-0143-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '400 mg', 'Cefixime'), 
('1017', 'Cepox   200 mg', '096-0148-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Cefpodoxime'), 
('1018', 'Fluoxetine   20 mg', '096-01984', 'Capsule', 'Albion Laboratories Ltd.', '2.58', '0.00', '20 mg', 'Fluoxetine'), 
('1019', 'Flurazepam   30 mg', '096-0260-057', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '30 mg', 'Flurazepam'), 
('1020', 'Esofour   20 mg', '096-0153-067', 'Capsule', 'Albion Laboratories Ltd.', '6.50', '0.00', '20 mg', 'Esomeprazole'), 
('1021', 'Pregabid   100 mg', '096-0298-046', 'Capsule', 'Albion Laboratories Ltd.', '22.00', '0.00', '100 mg', 'Pregabalin'), 
('1022', 'Pregabid   75 mg', '096-0299-046', 'Capsule', 'Albion Laboratories Ltd.', '16.07', '0.00', '75 mg', 'Pregabalin'), 
('1023', 'Cefiac   200 mg', '096-0120-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Cefixime'), 
('1024', 'Pregabid   50 mg', '096-0324-046', 'Capsule', 'Albion Laboratories Ltd.', '11.00', '0.00', '50 mg', 'Pregabalin'), 
('1025', 'Cloxacillin DS   500 mg', '096-0060-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Cloxacillin'), 
('1026', 'Alfux   250 mg', '096-0061-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Flucloxacillin'), 
('1027', 'Pregabid   25 mg', '096-0366-046', 'Capsule', 'Albion Laboratories Ltd.', '7.50', '0.00', '25 mg', 'Pregabalin'), 
('1028', 'Indomethacin SR   75 mg', '096-0376-64', 'Capsule', 'Albion Laboratories Ltd.', '3.52', '0.00', '75 mg', 'Indomethacin'), 
('1029', 'Lowet   120 mg', '096-0382', 'Capsule', 'Albion Laboratories Ltd.', '55.00', '0.00', '120 mg', 'Orlistat'), 
('1030', 'Enofab   200 mg', '096-0391-61', 'Capsule', 'Albion Laboratories Ltd.', '7.00', '0.00', '200 mg', 'Fenofibrate'), 
('1031', 'Esofour   40 mg', '096-0399-067', 'Capsule', 'Albion Laboratories Ltd.', '9.00', '0.00', '40 mg', 'Esomeprazole'), 
('1032', 'Indomethacin   25 mg', '096-0113-64', 'Capsule', 'Albion Laboratories Ltd.', '0.60', '0.00', '25 mg', 'Indomethacin'), 
('1033', 'Burn Free   1 %', '096-0287-23', 'Cream', 'Albion Laboratories Ltd.', '35.00', '0.00', '1 %', 'Silver Sulphadiazine'), 
('1034', 'Veelac   68 %', '096-0042-60', 'Oral Solution', 'Albion Laboratories Ltd.', '0.00', '0.00', '68 %', 'Lactulose'), 
('1035', 'Sulphanilamide Vet   100 %', '096-0190-077', 'Powder', 'Albion Laboratories Ltd.', '0.00', '0.00', '100 %', 'Sulphanilamide'), 
('1036', 'Al-Lev Vet   30 %', '096-0205-077', 'Powder', 'Albion Laboratories Ltd.', '0.00', '0.00', '30 %', 'Levamisole'), 
('1037', 'Albi   30 %', '096-0270-07', 'Powder', 'Albion Laboratories Ltd.', '0.00', '0.00', '30 %', 'Sulfaclozine'), 
('1038', 'Amolium Vet   20 %', '096-0272-077', 'Powder', 'Albion Laboratories Ltd.', '196.10', '0.00', '20 %', 'Amprolium'), 
('1039', 'Nagavon Plus (Vet)   100 %', '096-0284-077', 'Powder', 'Albion Laboratories Ltd.', '35.00', '0.00', '100 %', 'Trichlorfon'), 
('1040', 'Mimox Vet   15 %', '096-0288-077', 'Powder', 'Albion Laboratories Ltd.', '0.00', '0.00', '15 %', 'Amoxicillin'), 
('1041', 'Mimox Powder Vet   30 %', '096-0315-077', 'Powder', 'Albion Laboratories Ltd.', '0.00', '0.00', '30 %', 'Amoxicillin'), 
('1042', 'tiamulin-Al Vet   45 %', '096-0318-077', 'Powder', 'Albion Laboratories Ltd.', '0.00', '0.00', '45 %', 'Tiamulin Hydrogen Fumerate'), 
('1043', 'Albi-Tasty Ispaghul   3.5 gm', '096-0266-60', 'Sachet', 'Albion Laboratories Ltd.', '4.00', '0.00', '3.5 gm', 'Ispaghula Husk'), 
('1044', 'Ciprofloxacin   500 mg', '096-0012-23', 'Tablet', 'Albion Laboratories Ltd.', '14.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('1045', 'Ciprofloxacin   250 mg', '096-0013-23', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Ciprofloxacin'), 
('1046', 'Eryth   250 mg', '096-0007-23', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Erythromycin'), 
('1047', 'Eryth   500 mg', '096-0006-23', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Erythromycin'), 
('1048', 'Vitamin C     250 mg', '096-0053-78', 'Tablet', 'Albion Laboratories Ltd.', '0.82', '0.00', '250 mg', 'Vitamin C'), 
('1049', 'Boncal   1250 mg', '096-0018-62', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('1050', 'Ranitidine   150 mg', '096-00925', 'Tablet', 'Albion Laboratories Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('1051', 'Rycin K   250 mg', '096-0090-23', 'Tablet', 'Albion Laboratories Ltd.', '1.54', '0.00', '250 mg', 'Phenoxymethyl Penicillin'), 
('1052', 'Griscofalvin   500 mg', '096-0089-23', 'Tablet', 'Albion Laboratories Ltd.', '5.56', '0.00', '500 mg', 'Phenoxymethyl Penicillin'), 
('1053', 'Domp   10 mg', '096-00938', 'Tablet', 'Albion Laboratories Ltd.', '2.00', '0.00', '10 mg', 'Domperidone'), 
('1054', 'Alflam0   400 mg', '096-0091-64', 'Tablet', 'Albion Laboratories Ltd.', '1.42', '0.00', '400 mg', 'Ibuprofen'), 
('1055', 'Albiquin   300 mg', '096-0102-24', 'Tablet', 'Albion Laboratories Ltd.', '6.40', '0.00', '300 mg', 'Quinine Sulphate'), 
('1056', 'Albendazole-DS   400 mg', '096-0105-008', 'Tablet', 'Albion Laboratories Ltd.', '4.00', '0.00', '400 mg', 'Albendazole'), 
('1057', 'Aceclofenac   100 mg', '096-0108-64', 'Tablet', 'Albion Laboratories Ltd.', '2.50', '0.00', '100 mg', 'Aceclofenac'), 
('1058', 'Polyvit   200 mg', '096-0109-78', 'Tablet', 'Albion Laboratories Ltd.', '4.00', '0.00', '200 mg', 'Vitamin E'), 
('1059', 'Altapan   10 mg', '096-01151', 'Tablet', 'Albion Laboratories Ltd.', '1.83', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('1060', 'Nitram   5 mg', '096-0116-057', 'Tablet', 'Albion Laboratories Ltd.', '0.69', '0.00', '5 mg', 'Nitrazepam'), 
('1061', 'Pantoprazole   40 mg', '096-0128-67', 'Tablet', 'Albion Laboratories Ltd.', '5.00', '0.00', '40 mg', 'Pantoprazole'), 
('1062', 'Pantoprazole   20 mg', '096-0129-67', 'Tablet', 'Albion Laboratories Ltd.', '3.00', '0.00', '20 mg', 'Pantoprazole'), 
('1063', 'Atenolol   50 mg', '096-0130-22', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Atenolol'), 
('1064', 'Atenolol   100 mg', '096-0131-22', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Atenolol'), 
('1065', 'Losartan   25 mg', '096-0132-022', 'Tablet', 'Albion Laboratories Ltd.', '4.00', '0.00', '25 mg', 'Losartan Potassium'), 
('1066', 'Tanpot   50 mg', '096-0133-022', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Losartan Potassium'), 
('1067', 'Korac   10 mg', '096-0134-064', 'Tablet', 'Albion Laboratories Ltd.', '10.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('1068', 'Salbutamol   2 mg', '096-01354', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '2 mg', 'Salbutamol'), 
('1069', 'Salbutamol   4 mg', '096-01364', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '4 mg', 'Salbutamol'), 
('1070', 'Propranolol   10 mg', '096-0137-23', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Propranolol Hydrochloride'), 
('1071', 'Propranolol   40 mg', '096-0138-23', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '40 mg', 'Propranolol Hydrochloride'), 
('1072', 'Famotidine   20 mg', '096-01445', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '20 mg', 'Famotidine'), 
('1073', 'Famotidine   40 mg', '096-01455', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '40 mg', 'Famotidine'), 
('1074', 'Zium   10 mg', '096-01466', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Clobazam'), 
('1075', 'Ketoprofen   50 mg', '096-0147-64', 'Tablet', 'Albion Laboratories Ltd.', '3.50', '0.00', '50 mg', 'Ketoprofen'), 
('1076', 'Naproxen   500 mg', '096-0149-64', 'Tablet', 'Albion Laboratories Ltd.', '6.89', '0.00', '500 mg', 'Naproxen'), 
('1077', 'Naproxen   250 mg', '096-0150-64', 'Tablet', 'Albion Laboratories Ltd.', '4.00', '0.00', '250 mg', 'Naproxen'), 
('1078', 'Ketoprofen   100 mg', '096-0151-64', 'Tablet', 'Albion Laboratories Ltd.', '6.00', '0.00', '100 mg', 'Ketoprofen'), 
('1079', 'Aexidal   50 mg', '096-0152-21', 'Tablet', 'Albion Laboratories Ltd.', '2.00', '0.00', '50 mg', 'Mebhydrolin'), 
('1080', 'Etoricoxib   90 mg', '096-0164-64', 'Tablet', 'Albion Laboratories Ltd.', '12.00', '0.00', '90 mg', 'Etoricoxib'), 
('1081', 'Etoricoxib   60 mg', '096-0165-64', 'Tablet', 'Albion Laboratories Ltd.', '7.00', '0.00', '60 mg', 'Etoricoxib'), 
('1082', 'Rabeprazole   20 mg', '096-0166-67', 'Tablet', 'Albion Laboratories Ltd.', '5.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('1083', 'Amofast   10 mg', '096-0168-022', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Amlodipine'), 
('1084', 'Glibenol   5 mg', '096-0171', 'Tablet', 'Albion Laboratories Ltd.', '0.30', '0.00', '5 mg', 'Glibenclamide'), 
('1085', 'M-Fort   500 mg', '096-0172', 'Tablet', 'Albion Laboratories Ltd.', '3.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('1086', 'Losartan   100 mg', '096-0173-022', 'Tablet', 'Albion Laboratories Ltd.', '10.00', '0.00', '100 mg', 'Losartan Potassium'), 
('1087', 'Diltiazem   30 mg', '096-0174-22', 'Tablet', 'Albion Laboratories Ltd.', '2.00', '0.00', '30 mg', 'Diltiazem Hydrochloride'), 
('1088', 'Diltiazem   60 mg', '096-0175-22', 'Tablet', 'Albion Laboratories Ltd.', '3.80', '0.00', '60 mg', 'Diltiazem Hydrochloride'), 
('1089', 'Allerge   120 mg', '096-0176-21', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('1090', 'Allerge   180 mg', '096-0177-21', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('1091', 'Brom   3 mg', '096-01787', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '3 mg', 'Bromazepam'), 
('1092', 'Etoricoxib   120 mg', '096-0179-64', 'Tablet', 'Albion Laboratories Ltd.', '14.00', '0.00', '120 mg', 'Etoricoxib'), 
('1093', 'Altovas   10 mg', '096-0180-061', 'Tablet', 'Albion Laboratories Ltd.', '10.00', '0.00', '10 mg', 'Atorvastatin'), 
('1094', 'Altovas   20 mg', '096-0181-061', 'Tablet', 'Albion Laboratories Ltd.', '18.00', '0.00', '20 mg', 'Atorvastatin'), 
('1095', 'Cefuxim   250 mg', '096-0182-23', 'Tablet', 'Albion Laboratories Ltd.', '7.00', '0.00', '250 mg', 'Cefuroxime'), 
('1096', 'Cefuxim   500 mg', '096-0183-23', 'Tablet', 'Albion Laboratories Ltd.', '45.00', '0.00', '500 mg', 'Cefuroxime'), 
('1097', 'Reptylin   10 mg', '096-01844', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Amitriptyline Hydrochloride'), 
('1098', 'Reptylin   25 mg', '096-01854', 'Tablet', 'Albion Laboratories Ltd.', '1.00', '0.00', '25 mg', 'Amitriptyline Hydrochloride'), 
('1099', 'Alprazol   .25 mg', '096-01867', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '.25 mg', 'Alprazolam'), 
('1100', 'M-Fort   850 mg', '096-0187', 'Tablet', 'Albion Laboratories Ltd.', '5.00', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('1101', 'Desloratadine   5 mg', '096-0196-21', 'Tablet', 'Albion Laboratories Ltd.', '2.50', '0.00', '5 mg', 'Desloratadine'), 
('1102', 'Albipen   10 mg', '096-0197-70', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Baclofen'), 
('1103', 'Alprazole   .5 mg', '096-01997', 'Tablet', 'Albion Laboratories Ltd.', '2.00', '0.00', '.5 mg', 'Alprazolam'), 
('1104', 'Haloperidol   5 mg', '096-0200-28', 'Tablet', 'Albion Laboratories Ltd.', '1.00', '0.00', '5 mg', 'Haloperidol'), 
('1105', 'Clonazepam   .5 mg', '096-0201-046', 'Tablet', 'Albion Laboratories Ltd.', '2.00', '0.00', '.5 mg', 'Clonazepam'), 
('1106', 'Cinnarizine   15 mg', '096-0202-21', 'Tablet', 'Albion Laboratories Ltd.', '1.00', '0.00', '15 mg', 'Cinnarizine'), 
('1107', 'Nifedipine   10 mg', '096-0203-22', 'Tablet', 'Albion Laboratories Ltd.', '0.34', '0.00', '10 mg', 'Nifedipine'), 
('1108', 'Gabapentin   300 mg', '096-0208-046', 'Tablet', 'Albion Laboratories Ltd.', '16.00', '0.00', '300 mg', 'Gabapentin'), 
('1109', 'Clonazepam   2 mg', '096-0210-046', 'Tablet', 'Albion Laboratories Ltd.', '4.00', '0.00', '2 mg', 'Clonazepam'), 
('1110', 'Glimepiride   1 mg', '096-0211', 'Tablet', 'Albion Laboratories Ltd.', '3.00', '0.00', '1 mg', 'Glimepiride'), 
('1111', 'Mebeverine   135 mg', '096-02121', 'Tablet', 'Albion Laboratories Ltd.', '6.00', '0.00', '135 mg', 'Mebeverine Hydrochloride'), 
('1112', 'Frusemide   40 mg', '096-02132', 'Tablet', 'Albion Laboratories Ltd.', '0.53', '0.00', '40 mg', 'Frusemide'), 
('1113', 'Azithromycin   500 mg', '096-0214-23', 'Tablet', 'Albion Laboratories Ltd.', '30.00', '0.00', '500 mg', 'Azithromycin'), 
('1114', 'Aspirin   75 mg', '096-0224-26', 'Tablet', 'Albion Laboratories Ltd.', '0.50', '0.00', '75 mg', 'Aspirin'), 
('1115', 'Gabapentin   600 mg', '096-0225-046', 'Tablet', 'Albion Laboratories Ltd.', '30.00', '0.00', '600 mg', 'Gabapentin'), 
('1116', 'Lorazepam   1 mg', '096-02267', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '1 mg', 'Lorazepam'), 
('1117', 'Aspirin   300 mg', '096-0227-6', 'Tablet', 'Albion Laboratories Ltd.', '1.07', '0.00', '300 mg', 'Aspirin'), 
('1118', 'Terbinafine   250 mg', '096-0228', 'Tablet', 'Albion Laboratories Ltd.', '50.00', '0.00', '250 mg', 'Terbinafine'), 
('1119', 'Enalapril   5 mg', '096-0229-22', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Enalapril Maleate'), 
('1120', 'Enalapril   10 mg', '096-0230-22', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Enalapril Maleate'), 
('1121', 'Bisacodyl   5 mg', '096-0232-60', 'Tablet', 'Albion Laboratories Ltd.', '0.70', '0.00', '5 mg', 'Bisacodyl'), 
('1122', 'Glimepiride   2 mg', '096-0233', 'Tablet', 'Albion Laboratories Ltd.', '5.01', '0.00', '2 mg', 'Glimepiride'), 
('1123', 'Phenobarbital   30 mg', '096-0234-046', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '30 mg', 'Phenobarbitone'), 
('1124', 'Phenobarbital   60 mg', '096-0235-046', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '60 mg', 'Phenobarbitone'), 
('1125', 'Metronidazole   200 mg', '096-0257-27', 'Tablet', 'Albion Laboratories Ltd.', '0.67', '0.00', '200 mg', 'Metronidazole'), 
('1126', 'Vitamin B1   100 mg', '096-0258-78', 'Tablet', 'Albion Laboratories Ltd.', '0.74', '0.00', '100 mg', 'Thiamine Hydrochloride'), 
('1127', 'Phenobarbital   15 mg', '096-0262-046', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '15 mg', 'Phenobarbitone'), 
('1128', 'Captopril   25 mg', '096-0263-22', 'Tablet', 'Albion Laboratories Ltd.', '3.00', '0.00', '25 mg', 'Captopril'), 
('1129', 'Simvastatin   10 mg', '096-0265-61', 'Tablet', 'Albion Laboratories Ltd.', '15.00', '0.00', '10 mg', 'Simvastatin'), 
('1130', 'Verapamil   80 mg', '096-0267-22', 'Tablet', 'Albion Laboratories Ltd.', '3.00', '0.00', '80 mg', 'Verapamil Hydrochloride'), 
('1131', 'Dexibuprofen   300 mg', '096-0269-64', 'Tablet', 'Albion Laboratories Ltd.', '4.00', '0.00', '300 mg', 'Dexibuprofen (S Ibuprofen)'), 
('1132', 'Esofour   20 mg', '096-0157-067', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '20 mg', 'Esomeprazole'), 
('1133', 'Esofour   40 mg', '096-0274-67', 'Tablet', 'Albion Laboratories Ltd.', '7.00', '0.00', '40 mg', 'Esomeprazole'), 
('1134', 'Altason   5 mg', '096-0276-72', 'Tablet', 'Albion Laboratories Ltd.', '1.14', '0.00', '5 mg', 'Prednisolone'), 
('1135', 'Altason   10 mg', '096-0277-72', 'Tablet', 'Albion Laboratories Ltd.', '2.07', '0.00', '10 mg', 'Prednisolone'), 
('1136', 'Altason   20 mg', '096-0278-72', 'Tablet', 'Albion Laboratories Ltd.', '3.73', '0.00', '20 mg', 'Prednisolone'), 
('1137', 'Dexamethasone   .5 mg', '096-0279-72', 'Tablet', 'Albion Laboratories Ltd.', '1.00', '0.00', '.5 mg', 'Dexamethasone'), 
('1138', 'Trazapin   15 mg', '096-02974', 'Tablet', 'Albion Laboratories Ltd.', '8.00', '0.00', '15 mg', 'Mirtazapine'), 
('1139', 'Amofast   5 mg', '096-0162-022', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Amlodipine'), 
('1140', 'Monkon   4 mg', '096-0301-044', 'Tablet', 'Albion Laboratories Ltd.', '7.00', '0.00', '4 mg', 'Montelukast'), 
('1141', 'Sparfloxacin   200 mg', '096-0302-23', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Sparfloxacin'), 
('1142', 'Epram   5 mg', '096-03064', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Escitalopram'), 
('1143', 'Rozavas   10 mg', '096-0307-61', 'Tablet', 'Albion Laboratories Ltd.', '18.00', '0.00', '10 mg', 'Rosuvastatin'), 
('1144', 'Tadalafil   20 mg', '096-0309-043', 'Tablet', 'Albion Laboratories Ltd.', '60.00', '0.00', '20 mg', 'Tadalafil'), 
('1145', 'Powergra   50 mg', '096-0310-043', 'Tablet', 'Albion Laboratories Ltd.', '30.00', '0.00', '50 mg', 'Sildenafil'), 
('1146', 'Powergra   100 mg', '096-0311-043', 'Tablet', 'Albion Laboratories Ltd.', '50.00', '0.00', '100 mg', 'Sildenafil'), 
('1147', 'Cilmox0   500 mg', '096-0102-23', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('1148', 'Cilmox   250 mg', '096-0101-23', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('1149', 'Epival   200 mg', '096-03196', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Sodium Valproate'), 
('1150', 'Clozapin   25 mg', '096-03204', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '25 mg', 'Clozapine'), 
('1151', 'Lithium SR   400 mg', '096-0321-28', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '400 mg', 'Lithium Carbonate'), 
('1152', 'Livacor   300 mg', '096-0322', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '300 mg', 'Ursodeoxycholic Acid'), 
('1153', 'Rislock   2 mg', '096-0323-28', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '2 mg', 'Risperidone'), 
('1154', 'Glirol   80 mg', '096-0160', 'Tablet', 'Albion Laboratories Ltd.', '6.00', '0.00', '80 mg', 'Gliclazide'), 
('1155', 'Diazepam   5 mg', '096-0163-057', 'Tablet', 'Albion Laboratories Ltd.', '0.69', '0.00', '5 mg', 'Diazepam'), 
('1156', 'Rozavas   5 mg', '096-0325-61', 'Tablet', 'Albion Laboratories Ltd.', '8.00', '0.00', '5 mg', 'Rosuvastatin'), 
('1157', 'Epram   10 mg', '096-03264', 'Tablet', 'Albion Laboratories Ltd.', '10.00', '0.00', '10 mg', 'Escitalopram'), 
('1158', 'Olme   40 mg', '096-0327-22', 'Tablet', 'Albion Laboratories Ltd.', '15.00', '0.00', '40 mg', 'Olmesartan Medoxomil'), 
('1159', 'Olme   20 mg', '096-0328-22', 'Tablet', 'Albion Laboratories Ltd.', '8.00', '0.00', '20 mg', 'Olmesartan Medoxomil'), 
('1160', 'Livacor   150 mg', '096-0329', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '150 mg', 'Ursodeoxycholic Acid'), 
('1161', 'Rislock   4 mg', '096-0331-28', 'Tablet', 'Albion Laboratories Ltd.', '9.00', '0.00', '4 mg', 'Risperidone'), 
('1162', 'Olanza   10 mg', '096-0333-28', 'Tablet', 'Albion Laboratories Ltd.', '4.52', '0.00', '10 mg', 'Olanzapine'), 
('1163', 'Quetinil   100 mg', '096-0334-28', 'Tablet', 'Albion Laboratories Ltd.', '10.50', '0.00', '100 mg', 'Quetiapine'), 
('1164', 'Sertlin   50 mg', '096-03354', 'Tablet', 'Albion Laboratories Ltd.', '6.00', '0.00', '50 mg', 'Sertraline'), 
('1165', 'Rislock   1 mg', '096-0337-28', 'Tablet', 'Albion Laboratories Ltd.', '3.00', '0.00', '1 mg', 'Risperidone'), 
('1166', 'Epival Chrono CR   300 mg', '096-03386', 'Tablet', 'Albion Laboratories Ltd.', '7.00', '0.00', '300 mg', 'Sodium Valproate'), 
('1167', 'Epival Chrono0 CR   500 mg', '096-03396', 'Tablet', 'Albion Laboratories Ltd.', '11.00', '0.00', '500 mg', 'Sodium Valproate'), 
('1168', 'Clozapin   100 mg', '096-03424', 'Tablet', 'Albion Laboratories Ltd.', '9.55', '0.00', '100 mg', 'Clozapine'), 
('1169', 'Osteonil   150 mg', '096-0347-048', 'Tablet', 'Albion Laboratories Ltd.', '1500.00', '0.00', '150 mg', 'Ibandronic Acid'), 
('1170', 'Olme   10 mg', '096-0348-22', 'Tablet', 'Albion Laboratories Ltd.', '5.00', '0.00', '10 mg', 'Olmesartan Medoxomil'), 
('1171', 'Monkon   10 mg', '096-0349-044', 'Tablet', 'Albion Laboratories Ltd.', '15.05', '0.00', '10 mg', 'Montelukast'), 
('1172', 'Sertlin   25 mg', '096-03504', 'Tablet', 'Albion Laboratories Ltd.', '3.00', '0.00', '25 mg', 'Sertraline'), 
('1173', 'Sertlin0   100 mg', '096-03514', 'Tablet', 'Albion Laboratories Ltd.', '10.00', '0.00', '100 mg', 'Sertraline'), 
('1174', 'Quetinil   25 mg', '096-0352-28', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '25 mg', 'Quetiapine'), 
('1175', 'Olanza   5 mg', '096-0353-28', 'Tablet', 'Albion Laboratories Ltd.', '2.55', '0.00', '5 mg', 'Olanzapine'), 
('1176', 'Plator   75 mg', '096-0355-26', 'Tablet', 'Albion Laboratories Ltd.', '9.00', '0.00', '75 mg', 'Clopidogrel'), 
('1177', 'Reclevus0 F. C   50 mg', '096-0363', 'Tablet', 'Albion Laboratories Ltd.', '17.50', '0.00', '50 mg', 'Vildagliptin'), 
('1178', 'Monkon   5 mg', '096-0367-044', 'Tablet', 'Albion Laboratories Ltd.', '8.00', '0.00', '5 mg', 'Montelukast'), 
('1179', 'Isolol   2.5 mg', '096-0368-22', 'Tablet', 'Albion Laboratories Ltd.', '6.02', '0.00', '2.5 mg', 'Bisoprolol Hemifumarate'), 
('1180', 'Isolol F.C   5 mg', '096-0369-22', 'Tablet', 'Albion Laboratories Ltd.', '10.00', '0.00', '5 mg', 'Bisoprolol Hemifumarate'), 
('1181', 'Inco SR   1.5 mg', '096-03702', 'Tablet', 'Albion Laboratories Ltd.', '5.00', '0.00', '1.5 mg', 'Indapamide'), 
('1182', 'Bpcare   80 mg', '096-0371-22', 'Tablet', 'Albion Laboratories Ltd.', '10.00', '0.00', '80 mg', 'Valsartan'), 
('1183', 'Felo   5 mg', '096-0372-70', 'Tablet', 'Albion Laboratories Ltd.', '4.52', '0.00', '5 mg', 'Baclofen'), 
('1184', 'Bpcare   160 mg', '096-0373-22', 'Tablet', 'Albion Laboratories Ltd.', '17.50', '0.00', '160 mg', 'Valsartan'), 
('1185', 'Floxtat   40 mg', '096-0379-76', 'Tablet', 'Albion Laboratories Ltd.', '12.00', '0.00', '40 mg', 'Febuxostat'), 
('1186', 'N-Aspa   40 mg', '096-01541', 'Tablet', 'Albion Laboratories Ltd.', '1.81', '0.00', '40 mg', 'Drotaverine Hydrochloride'), 
('1187', 'Trazapin   30 mg', '096-03854', 'Tablet', 'Albion Laboratories Ltd.', '15.00', '0.00', '30 mg', 'Mirtazapine'), 
('1188', 'Cetirizine Tablet   10 mg', '096-0094-21', 'Tablet', 'Albion Laboratories Ltd.', '2.50', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('1189', 'Trazapin   7.5 mg', '096-03884', 'Tablet', 'Albion Laboratories Ltd.', '6.00', '0.00', '7.5 mg', 'Mirtazapine'), 
('1190', 'Antevir   .5 mg', '096-0392-32', 'Tablet', 'Albion Laboratories Ltd.', '45.00', '0.00', '.5 mg', 'Entecavir'), 
('1191', 'Oxipine   300 mg', '096-0393-046', 'Tablet', 'Albion Laboratories Ltd.', '11.00', '0.00', '300 mg', 'Oxcarbazepine'), 
('1192', 'Albizox   500 mg', '096-0396-27', 'Tablet', 'Albion Laboratories Ltd.', '9.00', '0.00', '500 mg', 'Nitazoxanide'), 
('1193', 'Tysul   50 mg', '096-0411-011', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('1194', 'Para-AL Vet   2 gm', '096-0188-077', 'Bolus', 'Albion Laboratories Ltd.', '2.25', '0.00', '2 gm', 'Paracetamol'), 
('1195', 'Oxytetracin   500 mg', '096-0189-077', 'Bolus', 'Albion Laboratories Ltd.', '3.00', '0.00', '500 mg', 'Oxytetracycline'), 
('1196', 'Bendol-Al   600 mg', '096-0192-077', 'Bolus', 'Albion Laboratories Ltd.', '0.00', '0.00', '600 mg', 'Albendazole'), 
('1197', 'AL-Lev Vet   600 mg', '096-0194-077', 'Bolus', 'Albion Laboratories Ltd.', '0.00', '0.00', '600 mg', 'Levamisole'), 
('1198', 'Al-Metro   2 gm', '096-0206-077', 'Bolus', 'Albion Laboratories Ltd.', '0.00', '0.00', '2 gm', 'Metronidazole'), 
('1199', 'Ciptec-Al Vet   750 mg', '096-0221-077', 'Bolus', 'Albion Laboratories Ltd.', '0.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('1200', 'Fenbendazole   250 mg', '096-0238-077', 'Bolus', 'Albion Laboratories Ltd.', '5.75', '0.00', '250 mg', 'Fenbendazole'), 
('1201', 'Dexason-Vet   10 mg', '096-0295-077', 'Bolus', 'Albion Laboratories Ltd.', '4.38', '0.00', '10 mg', 'Dexamethasone'), 
('1202', 'Meloxicam Vet   100 mg', '096-0296-077', 'Bolus', 'Albion Laboratories Ltd.', '6.00', '0.00', '100 mg', 'Meloxicam'), 
('1203', 'Prom-Al Vet   150 mg', '096-0340-077', 'Bolus', 'Albion Laboratories Ltd.', '3.32', '0.00', '150 mg', 'Promethazine Hydrochloride'), 
('1204', 'Ciptec-Al Vet   1 gm', '096-0341-077', 'Bolus', 'Albion Laboratories Ltd.', '20.08', '0.00', '1 gm', 'Ciprofloxacin'), 
('1205', 'Mimox Vet   500 mg', '096-0357-077', 'Bolus', 'Albion Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('1206', 'AL-KETO VET   400 mg', '096-0375-077', 'Bolus', 'Albion Laboratories Ltd.', '9.00', '0.00', '400 mg', 'Ketoprofen'), 
('1207', 'Sulnid (Vet)   5 gm', '096-0378-077', 'Bolus', 'Albion Laboratories Ltd.', '9.68', '0.00', '5 gm', 'Sulphadimidine'), 
('1208', 'Forticef gm IM   1 gm', '096-0401-23', 'IM Injection', 'Albion Laboratories Ltd.', '0.00', '0.00', '1 gm', 'Ceftriaxone'), 
('1209', 'Forticef gm IV   1 gm', '096-0404-23', 'IV Injection', 'Albion Laboratories Ltd.', '0.00', '0.00', '1 gm', 'Ceftriaxone'), 
('1210', 'M-Fort XR   500 mg', '096-0215', 'Xr Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('1211', 'Staflu   500 mg', '272-0079-23', 'Capsule', 'Alco Pharma Limited', '10.57', '0.00', '500 mg', 'Flucloxacillin'), 
('1212', 'Cepdoxim      100 mg', '272-0086-23', 'Capsule', 'Alco Pharma Limited', '20.06', '0.00', '100 mg', 'Cefpodoxime'), 
('1213', 'Coxib      100 mg', '272-0053-064', 'Capsule', 'Alco Pharma Limited', '4.06', '0.00', '100 mg', 'Celecoxib'), 
('1214', 'Coxib      200 mg', '272-0052-064', 'Capsule', 'Alco Pharma Limited', '7.07', '0.00', '200 mg', 'Celecoxib'), 
('1215', 'Darma      150 mg', '272-0126', 'Capsule', 'Alco Pharma Limited', '8.02', '0.00', '150 mg', 'Fluconazole'), 
('1216', 'Derma      50 mg', '272-0125', 'Capsule', 'Alco Pharma Limited', '0.00', '0.00', '50 mg', 'Fluconazole'), 
('1217', 'Doxcline      100 mg', '272-0128-23', 'Capsule', 'Alco Pharma Limited', '2.01', '0.00', '100 mg', 'Doxycycline'), 
('1218', 'Staflu   250 mg', '272-0049-23', 'Capsule', 'Alco Pharma Limited', '5.79', '0.00', '250 mg', 'Flucloxacillin'), 
('1219', 'Lanopra   15 mg', '272-0058-67', 'Capsule', 'Alco Pharma Limited', '0.00', '0.00', '15 mg', 'Lansoprazole'), 
('1220', 'Lanopra   30 mg', '272-0059-67', 'Capsule', 'Alco Pharma Limited', '0.00', '0.00', '30 mg', 'Lansoprazole'), 
('1221', 'Omepra      20 mg', '272-0047-67', 'Capsule', 'Alco Pharma Limited', '4.01', '0.00', '20 mg', 'Omeprazole'), 
('1222', 'Omepra      40 mg', '272-0048-67', 'Capsule', 'Alco Pharma Limited', '7.02', '0.00', '40 mg', 'Omeprazole'), 
('1223', 'Pendol      50 mg', '272-0113-65', 'Capsule', 'Alco Pharma Limited', '6.02', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('1224', 'Proladin  TR    100 mg', '272-0045-64', 'Capsule', 'Alco Pharma Limited', '3.01', '0.00', '100 mg', 'Diclofenac Sodium'), 
('1225', 'Esopra   20 mg', '272-0240-067', 'Capsule', 'Alco Pharma Limited', '6.02', '0.00', '20 mg', 'Esomeprazole'), 
('1226', 'Esopra   40 mg', '272-0241-067', 'Capsule', 'Alco Pharma Limited', '9.03', '0.00', '40 mg', 'Esomeprazole'), 
('1227', 'Oticef   250 mg', '272-0256-23', 'Capsule', 'Alco Pharma Limited', '0.00', '0.00', '250 mg', 'Cefaclor'), 
('1228', 'Oticef   500 mg', '272-0257-23', 'Capsule', 'Alco Pharma Limited', '40.12', '0.00', '500 mg', 'Cefaclor'), 
('1229', 'Desopra   30 mg', '272-0269-67', 'Capsule', 'Alco Pharma Limited', '10.00', '0.00', '30 mg', 'Dexlansoprazole'), 
('1230', 'Maxclin   300 mg', '272-0271-23', 'Capsule', 'Alco Pharma Limited', '15.00', '0.00', '300 mg', 'Clindamycin'), 
('1231', 'Maxclin   150 mg', '272-0270-23', 'Capsule', 'Alco Pharma Limited', '8.00', '0.00', '150 mg', 'Clindamycin'), 
('1232', 'Acipra   20 mg', '272-0280-067', 'Capsule', 'Alco Pharma Limited', '0.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('1233', 'Dazine   1 %', '272-0042-23', 'Cream', 'Alco Pharma Limited', '50.15', '0.00', '1 %', 'Silver Sulphadiazine'), 
('1234', 'Water for Injection   10 ml', '272-0254-79', 'Injection', 'Alco Pharma Limited', '0.00', '0.00', '10 ml', 'Water For Injection'), 
('1235', 'Leaxe   68 %', '272-0211-60', 'Oral Solution', 'Alco Pharma Limited', '140.42', '0.00', '68 %', 'Lactulose'), 
('1236', 'Aclo   100 mg', '272-0109-64', 'Tablet', 'Alco Pharma Limited', '3.01', '0.00', '100 mg', 'Aceclofenac'), 
('1237', 'Alagra   120 mg', '272-0100-21', 'Tablet', 'Alco Pharma Limited', '6.02', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('1238', 'Alagra   30 mg', '272-0099-21', 'Tablet', 'Alco Pharma Limited', '3.01', '0.00', '30 mg', 'Fexofenadine Hydrochloride'), 
('1239', 'Alagra   180 mg', '272-0101-21', 'Tablet', 'Alco Pharma Limited', '8.53', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('1240', 'Aloquin   300 mg', '272-0074-24', 'Tablet', 'Alco Pharma Limited', '3.41', '0.00', '300 mg', 'Quinine Sulphate'), 
('1241', 'Amdin   10 mg', '272-0133-022', 'Tablet', 'Alco Pharma Limited', '6.02', '0.00', '10 mg', 'Amlodipine'), 
('1242', 'Amdin      5 mg', '272-0132-022', 'Tablet', 'Alco Pharma Limited', '4.01', '0.00', '5 mg', 'Amlodipine'), 
('1243', 'Atovin   10 mg', '272-0091-061', 'Tablet', 'Alco Pharma Limited', '10.03', '0.00', '10 mg', 'Atorvastatin'), 
('1244', 'Axetil   125 mg', '272-0111-23', 'Tablet', 'Alco Pharma Limited', '12.04', '0.00', '125 mg', 'Cefuroxime'), 
('1245', 'Axetil   250 mg', '272-0110-23', 'Tablet', 'Alco Pharma Limited', '25.08', '0.00', '250 mg', 'Cefuroxime'), 
('1246', 'B One      100 mg', '272-0127-78', 'Tablet', 'Alco Pharma Limited', '0.74', '0.00', '100 mg', 'Thiamine Hydrochloride'), 
('1247', 'Brolyt   8 mg', '272-0083-031', 'Tablet', 'Alco Pharma Limited', '1.00', '0.00', '8 mg', 'Bromhexine Hydrochloride'), 
('1248', 'Brozep   3 mg', '272-01317', 'Tablet', 'Alco Pharma Limited', '5.00', '0.00', '3 mg', 'Bromazepam'), 
('1249', 'Butastat   10 mg', '272-00011', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('1250', 'Calmi0   1250 mg', '272-0051-62', 'Tablet', 'Alco Pharma Limited', '4.01', '0.00', '1250 mg', 'Calcium Carbonate'), 
('1251', 'Cardilock      50 mg', '272-0002-22', 'Tablet', 'Alco Pharma Limited', '0.77', '0.00', '50 mg', 'Atenolol'), 
('1252', 'Chuben DS   400 mg', '272-0032-008', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '400 mg', 'Albendazole'), 
('1253', 'Derfin   250 mg', '272-0103', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '250 mg', 'Terbinafine'), 
('1254', 'Diaprid   80 mg', '272-0084', 'Tablet', 'Alco Pharma Limited', '6.02', '0.00', '80 mg', 'Gliclazide'), 
('1255', 'Diben      5 mg', '272-0081', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '5 mg', 'Glibenclamide'), 
('1256', 'Dompi   10 mg', '272-00768', 'Tablet', 'Alco Pharma Limited', '2.01', '0.00', '10 mg', 'Domperidone'), 
('1257', 'Ery   500 mg', '272-0097-23', 'Tablet', 'Alco Pharma Limited', '10.33', '0.00', '500 mg', 'Erythromycin'), 
('1258', 'Ery   250 mg', '272-0071-23', 'Tablet', 'Alco Pharma Limited', '5.17', '0.00', '250 mg', 'Erythromycin'), 
('1259', 'Esopra      20 mg', '272-0104-067', 'Tablet', 'Alco Pharma Limited', '4.01', '0.00', '20 mg', 'Esomeprazole'), 
('1260', 'Hyquin   200 mg', '272-0085-24', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '200 mg', 'Hydroxychloroquine Sulphate'), 
('1261', 'Lamidin   100 mg', '272-0063-32', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '100 mg', 'Lamivudine'), 
('1262', 'Leflu      20 mg', '272-0094-64', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '20 mg', 'Leflunomide'), 
('1263', 'Leflu      100 mg', '272-0095-64', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '100 mg', 'Leflunomide'), 
('1264', 'Leoflox   250 mg', '272-0105-23', 'Tablet', 'Alco Pharma Limited', '7.02', '0.00', '250 mg', 'Levofloxacin'), 
('1265', 'Leoflox   500 mg', '272-0075-23', 'Tablet', 'Alco Pharma Limited', '15.05', '0.00', '500 mg', 'Levofloxacin'), 
('1266', 'Losa      50 mg', '272-0055-022', 'Tablet', 'Alco Pharma Limited', '6.02', '0.00', '50 mg', 'Losartan Potassium'), 
('1267', 'Losa      25 mg', '272-0106-022', 'Tablet', 'Alco Pharma Limited', '3.51', '0.00', '25 mg', 'Losartan Potassium'), 
('1268', 'Metmin   850 mg', '272-0080', 'Tablet', 'Alco Pharma Limited', '4.01', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('1269', 'Mokast   10 mg', '272-0090-044', 'Tablet', 'Alco Pharma Limited', '10.03', '0.00', '10 mg', 'Montelukast'), 
('1270', 'Nidraj   10 mg', '272-01367', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '10 mg', 'Zolpidem Tartrate'), 
('1271', 'Noler   10 mg', '272-0033-21', 'Tablet', 'Alco Pharma Limited', '2.51', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('1272', 'Ordex   .5 mg', '272-0129-72', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '.5 mg', 'Dexamethasone'), 
('1273', 'Pantopra      20 mg', '272-0069-67', 'Tablet', 'Alco Pharma Limited', '3.01', '0.00', '20 mg', 'Pantoprazole'), 
('1274', 'Pantopra      40 mg', '272-0070-67', 'Tablet', 'Alco Pharma Limited', '5.02', '0.00', '40 mg', 'Pantoprazole'), 
('1275', 'Piolit   15 mg', '272-0089', 'Tablet', 'Alco Pharma Limited', '8.02', '0.00', '15 mg', 'Pioglitazone'), 
('1276', 'Repaglid   2 mg', '272-0088-015', 'Tablet', 'Alco Pharma Limited', '5.02', '0.00', '2 mg', 'Repaglinide'), 
('1277', 'Repaglid   1 mg', '272-0087-015', 'Tablet', 'Alco Pharma Limited', '3.01', '0.00', '1 mg', 'Repaglinide'), 
('1278', 'Roxcin      150 mg', '272-0067-23', 'Tablet', 'Alco Pharma Limited', '7.02', '0.00', '150 mg', 'Roxithromycin'), 
('1279', 'Dumaflox   750 mg', '272-0066-23', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('1280', 'Sparflox      200 mg', '272-0054-23', 'Tablet', 'Alco Pharma Limited', '16.05', '0.00', '200 mg', 'Sparfloxacin'), 
('1281', 'Leflu   10 mg', '272-0093-64', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '10 mg', 'Leflunomide'), 
('1282', 'Arinet   50 mg', '272-0174-24', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '50 mg', 'Artesunate'), 
('1283', 'Sunil   100 mg', '272-0173-64', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '100 mg', 'Sulindac'), 
('1284', 'Ecox   60 mg', '272-0167-64', 'Tablet', 'Alco Pharma Limited', '7.02', '0.00', '60 mg', 'Etoricoxib'), 
('1285', 'Ecox   90 mg', '272-0168-64', 'Tablet', 'Alco Pharma Limited', '12.04', '0.00', '90 mg', 'Etoricoxib'), 
('1286', 'Zinex   250 mg', '272-0149-23', 'Tablet', 'Alco Pharma Limited', '20.06', '0.00', '250 mg', 'Azithromycin'), 
('1287', 'Zinex   500 mg', '272-0150-23', 'Tablet', 'Alco Pharma Limited', '30.09', '0.00', '500 mg', 'Azithromycin'), 
('1288', 'Erycin   250 mg', '272--23', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '250 mg', 'Erythromycin'), 
('1289', 'Clopidol      75 mg', '272-0162-26', 'Tablet', 'Alco Pharma Limited', '10.03', '0.00', '75 mg', 'Clopidogrel'), 
('1290', 'Aloran   5 mg', '272-0123-21', 'Tablet', 'Alco Pharma Limited', '2.51', '0.00', '5 mg', 'Desloratadine'), 
('1291', 'Flampen   400 mg', '272-0143-64', 'Tablet', 'Alco Pharma Limited', '1.30', '0.00', '400 mg', 'Ibuprofen'), 
('1292', 'Linezol   400 mg', '272--023', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '400 mg', 'Linezolid'), 
('1293', 'Linezol   600 mg', '272--023', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '600 mg', 'Linezolid'), 
('1294', 'Roxcin0   300 mg', '272-0068-23', 'Tablet', 'Alco Pharma Limited', '14.04', '0.00', '300 mg', 'Roxithromycin'), 
('1295', 'Zalukast      20 mg', '272-00924', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '20 mg', 'Zafirlukast'), 
('1296', 'Malaquin0   300 mg', '272-0074-24', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '300 mg', 'Quinine Sulphate'), 
('1297', 'Napren   250 mg', '272-0158-64', 'Tablet', 'Alco Pharma Limited', '5.02', '0.00', '250 mg', 'Naproxen'), 
('1298', 'Brolyt   4 mg', '272-0082-031', 'Tablet', 'Alco Pharma Limited', '0.70', '0.00', '4 mg', 'Bromhexine Hydrochloride'), 
('1299', 'Levocet   5 mg', '272-0114-21', 'Tablet', 'Alco Pharma Limited', '2.01', '0.00', '5 mg', 'Levocetirizine Hydrochloride'), 
('1300', 'Ornizol   500 mg', '272--27', 'Tablet', 'Alco Pharma Limited', '6.02', '0.00', '500 mg', 'Ornidazole'), 
('1301', 'Emulyt   30 mg', '272-0190-31', 'Tablet', 'Alco Pharma Limited', '1.76', '0.00', '30 mg', 'Ambroxol'), 
('1302', 'Dip0      200 mg', '272-0177-64', 'Tablet', 'Alco Pharma Limited', '3.01', '0.00', '200 mg', 'Dexibuprofen (S Ibuprofen)'), 
('1303', 'Dip0   400 mg', '272-0178-64', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '400 mg', 'Dexibuprofen (S Ibuprofen)'), 
('1304', 'Dirin   10 mg', '272-01831', 'Tablet', 'Alco Pharma Limited', '2.01', '0.00', '10 mg', 'Dicycloverine Hydrochloride'), 
('1305', 'Eprin      75 mg', '272-0187-26', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '75 mg', 'Aspirin'), 
('1306', 'Gipid   1 mg', '272-0141', 'Tablet', 'Alco Pharma Limited', '3.01', '0.00', '1 mg', 'Glimepiride'), 
('1307', 'Gipid   2 mg', '272-0142', 'Tablet', 'Alco Pharma Limited', '5.02', '0.00', '2 mg', 'Glimepiride'), 
('1308', 'Lebrod   1 mg', '272-01944', 'Tablet', 'Alco Pharma Limited', '0.75', '0.00', '1 mg', 'Levosalbutamol'), 
('1309', 'Lebrod   2 mg', '272-01954', 'Tablet', 'Alco Pharma Limited', '1.40', '0.00', '2 mg', 'Levosalbutamol'), 
('1310', 'Zenc  DT    20 mg', '272-0206-62', 'Tablet', 'Alco Pharma Limited', '1.75', '0.00', '20 mg', 'Zinc'), 
('1311', 'Adnix   500 mg', '272-0204-27', 'Tablet', 'Alco Pharma Limited', '10.03', '0.00', '500 mg', 'Nitazoxanide'), 
('1312', 'Tolec   10 mg', '272-0210-064', 'Tablet', 'Alco Pharma Limited', '10.03', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('1313', 'Tiemo   50 mg', '272-02121', 'Tablet', 'Alco Pharma Limited', '4.01', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('1314', 'Nic   2 mg', '272-0213-37', 'Tablet', 'Alco Pharma Limited', '5.02', '0.00', '2 mg', 'Nicotine'), 
('1315', 'Alagra   60 mg', '272-0216-21', 'Tablet', 'Alco Pharma Limited', '3.51', '0.00', '60 mg', 'Fexofenadine Hydrochloride'), 
('1316', 'Ecox   120 mg', '272-0226-64', 'Tablet', 'Alco Pharma Limited', '14.04', '0.00', '120 mg', 'Etoricoxib'), 
('1317', 'Napren0   500 mg', '272-0228-64', 'Tablet', 'Alco Pharma Limited', '9.03', '0.00', '500 mg', 'Naproxen'), 
('1318', 'Epizam.5   .5 mg', '272-0232-046', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '.5 mg', 'Clonazepam'), 
('1319', 'X-cite   50 mg', '272-0233-043', 'Tablet', 'Alco Pharma Limited', '3.09', '0.00', '50 mg', 'Sildenafil'), 
('1320', 'Viev   10 mg', '272-0234-043', 'Tablet', 'Alco Pharma Limited', '35.11', '0.00', '10 mg', 'Tadalafil'), 
('1321', 'Vertig   5 mg', '272-02357', 'Tablet', 'Alco Pharma Limited', '3.51', '0.00', '5 mg', 'Flunarizine'), 
('1322', 'Vertig   10 mg', '272-02367', 'Tablet', 'Alco Pharma Limited', '5.02', '0.00', '10 mg', 'Flunarizine'), 
('1323', 'X-Cite   100 mg', '272-0238-043', 'Tablet', 'Alco Pharma Limited', '50.15', '0.00', '100 mg', 'Sildenafil'), 
('1324', 'Viev   20 mg', '272-0239-043', 'Tablet', 'Alco Pharma Limited', '50.15', '0.00', '20 mg', 'Tadalafil'), 
('1325', 'Geminy 320   320 mg', '272-0237-23', 'Tablet', 'Alco Pharma Limited', '60.00', '0.00', '320 mg', 'Gemefloxacin'), 
('1326', 'Emiset   4 mg', '272-02618', 'Tablet', 'Alco Pharma Limited', '5.00', '0.00', '4 mg', 'Ondansetron'), 
('1327', 'Emiset 8   8 mg', '272-02628', 'Tablet', 'Alco Pharma Limited', '10.00', '0.00', '8 mg', 'Ondansetron'), 
('1328', 'Epizam   1 mg', '272-02676', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '1 mg', 'Clonazepam'), 
('1329', 'Epizam   2 mg', '272-0268-046', 'Tablet', 'Alco Pharma Limited', '6.00', '0.00', '2 mg', 'Clonazepam'), 
('1330', 'Rosvin   10 mg', '272-0265-61', 'Tablet', 'Alco Pharma Limited', '20.00', '0.00', '10 mg', 'Rosuvastatin'), 
('1331', 'Gluvil   50 mg', '272-0264', 'Tablet', 'Alco Pharma Limited', '20.00', '0.00', '50 mg', 'Vildagliptin'), 
('1332', 'Rupaler   10 mg', '272-0266-21', 'Tablet', 'Alco Pharma Limited', '10.00', '0.00', '10 mg', 'Rupatadine'), 
('1333', 'Moxiflox0   400 mg', '272-0121-23', 'Tablet', 'Alco Pharma Limited', '50.15', '0.00', '400 mg', 'Moxifloxacin'), 
('1334', 'Rosvin   5 mg', '272-0272-61', 'Tablet', 'Alco Pharma Limited', '10.00', '0.00', '5 mg', 'Rosuvastatin'), 
('1335', 'Tosma   1 mg', '272-0278-21', 'Tablet', 'Alco Pharma Limited', '2.00', '0.00', '1 mg', 'Ketotifen'), 
('1336', 'Metmin0 SR   500 mg', '272-0281-015', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('1337', 'Infecef IM   250 mg', '272-0243-23', 'IM Injection', 'Alco Pharma Limited', '100.30', '0.00', '250 mg', 'Ceftriaxone'), 
('1338', 'Infecef0 IM   500 mg', '272-0244-23', 'IM Injection', 'Alco Pharma Limited', '130.39', '0.00', '500 mg', 'Ceftriaxone'), 
('1339', 'Infecef gm IM   1 gm', '272-0245-23', 'IM Injection', 'Alco Pharma Limited', '190.57', '0.00', '1 gm', 'Ceftriaxone'), 
('1340', 'Infecef IV   250 mg', '272-0246-23', 'IV Injection', 'Alco Pharma Limited', '100.30', '0.00', '250 mg', 'Ceftriaxone'), 
('1341', 'Infecef0 IV   500 mg', '272-0247-23', 'IV Injection', 'Alco Pharma Limited', '130.39', '0.00', '500 mg', 'Ceftriaxone'), 
('1342', 'Infecef gm IV   1 gm', '272-0248-23', 'IV Injection', 'Alco Pharma Limited', '190.57', '0.00', '1 gm', 'Ceftriaxone'), 
('1343', 'Infecef gm IV   2 gm', '272-0249-23', 'IV Injection', 'Alco Pharma Limited', '300.90', '0.00', '2 gm', 'Ceftriaxone'), 
('1344', 'Esiguard   20 mg', '373-0009-067', 'Capsule', 'Allied Pharmaceuticals Ltd.', '7.00', '0.00', '20 mg', 'Esomeprazole'), 
('1345', 'Omixen   20 mg', '373-0015-67', 'Capsule', 'Allied Pharmaceuticals Ltd.', '5.00', '0.00', '20 mg', 'Omeprazole'), 
('1346', 'Alfixim   200 mg', '373-0018-23', 'Capsule', 'Allied Pharmaceuticals Ltd.', '35.00', '0.00', '200 mg', 'Cefixime'), 
('1347', 'Alfixim0   400 mg', '373-0019-23', 'Capsule', 'Allied Pharmaceuticals Ltd.', '50.00', '0.00', '400 mg', 'Cefixime'), 
('1348', 'Alfradin0   500 mg', '373-0021-23', 'Capsule', 'Allied Pharmaceuticals Ltd.', '12.50', '0.00', '500 mg', 'Cephradine'), 
('1349', 'Voltex SR   100 mg', '373-0024-64', 'Capsule', 'Allied Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('1350', 'Alcefen   100 mg', '373-0001-64', 'Tablet', 'Allied Pharmaceuticals Ltd.', '4.00', '0.00', '100 mg', 'Aceclofenac'), 
('1351', 'Zylomax0   500 mg', '373-0003-23', 'Tablet', 'Allied Pharmaceuticals Ltd.', '35.00', '0.00', '500 mg', 'Azithromycin'), 
('1352', 'Albafen   10 mg', '373-0004-70', 'Tablet', 'Allied Pharmaceuticals Ltd.', '8.00', '0.00', '10 mg', 'Baclofen'), 
('1353', 'Bactiflox0   500 mg', '373-0006-23', 'Tablet', 'Allied Pharmaceuticals Ltd.', '14.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('1354', 'Bactiflox   250 mg', '373-0007-23', 'Tablet', 'Allied Pharmaceuticals Ltd.', '8.00', '0.00', '250 mg', 'Ciprofloxacin'), 
('1355', 'Dompidox   10 mg', '373-00088', 'Tablet', 'Allied Pharmaceuticals Ltd.', '2.00', '0.00', '10 mg', 'Domperidone'), 
('1356', 'Fexotis   120 mg', '373-0010-21', 'Tablet', 'Allied Pharmaceuticals Ltd.', '7.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('1357', 'Altorec   10 mg', '373-0011-064', 'Tablet', 'Allied Pharmaceuticals Ltd.', '10.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('1358', 'Levolied0   500 mg', '373-0012-23', 'Tablet', 'Allied Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Levofloxacin'), 
('1359', 'Alproxen0   500 mg', '373-0013-64', 'Tablet', 'Allied Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Naproxen'), 
('1360', 'Alproxen   250 mg', '373-0014-64', 'Tablet', 'Allied Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Naproxen'), 
('1361', 'Ranlied   150 mg', '373-00175', 'Tablet', 'Allied Pharmaceuticals Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('1362', 'Reokast   4 mg', '373-0025-044', 'Chewable Tablet', 'Allied Pharmaceuticals Ltd.', '0.00', '0.00', '4 mg', 'Montelukast'), 
('1363', 'Aluctin   15 mg', '192-0108-057', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '15 mg', 'Flurazepam'), 
('1364', 'Aluctin   30 mg', '192-0055-057', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '3.55', '0.00', '30 mg', 'Flurazepam'), 
('1365', 'Ambeeclox   500 mg', '192-0042-23', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Cloxacillin'), 
('1366', 'Ambeexin   250 mg', '192-0027-023', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '3.55', '0.00', '250 mg', 'Amoxicillin'), 
('1367', 'Doxilin      100 mg', '192-0035-23', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '2.13', '0.00', '100 mg', 'Doxycycline'), 
('1368', 'Fluxin   250 mg', '192-0093-23', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '5.59', '0.00', '250 mg', 'Flucloxacillin'), 
('1369', 'Fluxin   500 mg', '192-0125-23', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '10.04', '0.00', '500 mg', 'Flucloxacillin'), 
('1370', 'Lap   30 mg', '192-0116-67', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '5.01', '0.00', '30 mg', 'Lansoprazole'), 
('1371', 'Mycef   500 mg', '192-0098-23', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '12.54', '0.00', '500 mg', 'Cephradine'), 
('1372', 'Mycin50   450 mg', '192-0045-30', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '450 mg', 'Rifampicin'), 
('1373', 'Tetram   250 mg', '192-0033-23', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '1.33', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('1374', 'Semicillin   250 mg', '192-0001-23', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Ampicillin'), 
('1375', 'Tricef M     200 mg', '192-0133-23', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Cefixime'), 
('1376', 'Mycin      150 mg', '192-0041-30', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Rifampicin'), 
('1377', 'Om      20 mg', '192-0139-67', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '3.02', '0.00', '20 mg', 'Omeprazole'), 
('1378', 'Om      40 mg', '192-0140-67', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '5.01', '0.00', '40 mg', 'Omeprazole'), 
('1379', 'Act   500 mg', '192-0020-006', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('1380', 'Adipin   10 mg', '192-0105-022', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Amlodipine'), 
('1381', 'Adorex   10 mg', '192-01098', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Domperidone'), 
('1382', 'Afuvin   500 mg', '192-0054', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '5.32', '0.00', '500 mg', 'Griseofulvin'), 
('1383', 'Ametrol  DS   800 mg', '192-0119-27', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '800 mg', 'Metronidazole'), 
('1384', 'Aminophylline      100 mg', '192-00134', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.38', '0.00', '100 mg', 'Aminophylline'), 
('1385', 'Anetol      100 mg', '192-0057-22', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Atenolol'), 
('1386', 'Anetol      50 mg', '192-0068-22', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Atenolol'), 
('1387', 'Antac      150 mg', '192-00585', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '1.51', '0.00', '150 mg', 'Ranitidine'), 
('1388', 'Broncolin   2 mg', '192-00524', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '2 mg', 'Salbutamol'), 
('1389', 'Broncolin   4 mg', '192-00534', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '4 mg', 'Salbutamol'), 
('1390', 'C Bon   250 mg', '192-0084-78', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Vitamin C'), 
('1391', 'Calcitate   300 mg', '192-0080-62', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.29', '0.00', '300 mg', 'Calcium Lactate'), 
('1392', 'Capril      25 mg', '192-0069-22', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Captopril'), 
('1393', 'Capril      50 mg', '192-0070-22', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Captopril'), 
('1394', 'Actizen   10 mg', '192-0107-21', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '2.03', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('1395', 'Diphedan   100 mg', '192-0017-046', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '2.01', '0.00', '100 mg', 'Phenytoin Sodium'), 
('1396', 'Dopaflex   500 mg', '192-0024-22', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Methyldopa'), 
('1397', 'Dopegyt   250 mg', '192-0012-22', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '3.09', '0.00', '250 mg', 'Methyldopa'), 
('1398', 'Ephedrine   30 mg', '192-0011', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '30 mg', 'Ephedrine Hydrochloride'), 
('1399', 'Famotac      20 mg', '192-00675', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Famotidine'), 
('1400', 'Famotac      40 mg', '192-00665', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Famotidine'), 
('1401', 'Folac   5 mg', '192-00215', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.24', '0.00', '5 mg', 'Folic Acid'), 
('1402', 'Hiflox   500 mg', '192-0072-23', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '8.70', '0.00', '500 mg', 'Ciprofloxacin'), 
('1403', 'Hiflox   750 mg', '192-0124-23', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '12.05', '0.00', '750 mg', 'Ciprofloxacin'), 
('1404', 'Hitflam      50 mg', '192-0071-64', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.84', '0.00', '50 mg', 'Diclofenac Sodium'), 
('1405', 'Cerenin   5 mg', '192-0106-36', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '3.55', '0.00', '5 mg', 'Vinpocetine'), 
('1406', 'Klion      200 mg', '192-0037-27', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Metronidazole'), 
('1407', 'Klion   400 mg', '192-0038-27', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('1408', 'Koal   300 mg', '192-00837', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Activated Charcoal'), 
('1409', 'Lopa.5   2.5 mg', '192-01047', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '2.5 mg', 'Lorazepam'), 
('1410', 'Lotas      50 mg', '192-0117-022', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '5.69', '0.00', '50 mg', 'Losartan Potassium'), 
('1411', 'Lovatin      20 mg', '192-0088-61', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Lovastatin'), 
('1412', 'Lovatin      40 mg', '192-0089-61', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Lovastatin'), 
('1413', 'MI   30 mg', '192-0103-22', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '30 mg', 'Diltiazem Hydrochloride'), 
('1414', 'Nalidex   500 mg', '192-0036-23', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '4.07', '0.00', '500 mg', 'Nalidixic Acid'), 
('1415', 'Naproxin   250 mg', '192-0050-64', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '4.26', '0.00', '250 mg', 'Naproxen'), 
('1416', 'Naproxin   500 mg', '192-0100-64', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '6.92', '0.00', '500 mg', 'Naproxen'), 
('1417', 'No Spa   40 mg', '192-00191', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '1.82', '0.00', '40 mg', 'Drotaverine Hydrochloride'), 
('1418', 'Noctin   5 mg', '192-0082-057', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.69', '0.00', '5 mg', 'Nitrazepam'), 
('1419', 'Nop.5   2.5 mg', '192-0090-22', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '2.5 mg', 'Lisinopril'), 
('1420', 'Nop      5 mg', '192-0091-22', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '3.55', '0.00', '5 mg', 'Lisinopril'), 
('1421', 'Perol      5 mg', '192-0097-28', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.51', '0.00', '5 mg', 'Haloperidol'), 
('1422', 'Prednisolone      5 mg', '192-0002-72', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.67', '0.00', '5 mg', 'Prednisolone'), 
('1423', 'Rem   3 mg', '192-01217', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '2.01', '0.00', '3 mg', 'Bromazepam'), 
('1424', 'Seduxen      5 mg', '192-0007-057', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.23', '0.00', '5 mg', 'Diazepam'), 
('1425', 'Sinumid   10 mg', '192-00511', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('1426', 'Sural   400 mg', '192-0003-30', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '1.66', '0.00', '400 mg', 'Ethambutol'), 
('1427', 'Syche      50 mg', '192-01154', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Sertraline'), 
('1428', 'Triben  DS   400 mg', '192-0062-008', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '3.35', '0.00', '400 mg', 'Albendazole'), 
('1429', 'Triben      200 mg', '192-0063-008', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Albendazole'), 
('1430', 'Trofurit      40 mg', '192-00052', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.53', '0.00', '40 mg', 'Frusemide'), 
('1431', 'Verospiron   25 mg', '192-00042', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '5.01', '0.00', '25 mg', 'Spironolactone'), 
('1432', 'A Rox      150 mg', '192-0136-23', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '6.53', '0.00', '150 mg', 'Roxithromycin'), 
('1433', 'A Rox0   300 mg', '192-0135-23', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '11.04', '0.00', '300 mg', 'Roxithromycin'), 
('1434', 'Ampine   10 mg', '192-0056-22', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Nifedipine'), 
('1435', 'Delagil   250 mg', '192-0026-24', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Chloroquine Phosphate'), 
('1436', 'Hiflox   250 mg', '192-0073-23', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Ciprofloxacin'), 
('1437', 'Gilemal   5 mg', '192-0018', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Glibenclamide'), 
('1438', 'Lexlo   500 mg', '192-0137-23', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '13.05', '0.00', '500 mg', 'Levofloxacin'), 
('1439', 'Mespa   135 mg', '192-01441', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '6.02', '0.00', '135 mg', 'Mebeverine Hydrochloride'), 
('1440', 'Tindurin   25 mg', '192-0014-24', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Pyrimethamine'), 
('1441', 'Sulphadimidine   500 mg', '192-0022-023', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Sulphadimidine'), 
('1442', 'Nomigra      50 mg', '192-01287', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Sumatriptan'), 
('1443', 'Nomigran      100 mg', '192-01297', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '45.17', '0.00', '100 mg', 'Sumatriptan'), 
('1444', 'Myzid   250 mg', '192-0167-23', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Azithromycin'), 
('1445', 'Myzid   500 mg', '192-0168-23', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('1446', 'Arolak   10 mg', '192-0159-064', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '10.04', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('1447', 'Amason0 mcg   .5 mg', '192-0162-72', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.47', '0.00', '.5 mg', 'Dexamethasone'), 
('1448', 'Lexlo   250 mg', '192-0155-23', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '8.03', '0.00', '250 mg', 'Levofloxacin'), 
('1449', 'Ambeecal   1250 mg', '192-0153-62', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '2.01', '0.00', '1250 mg', 'Calcium Carbonate'), 
('1450', 'Morphine Sulphate   15 mg', '192-0150-65', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '15 mg', 'Morphine Sulphate'), 
('1451', 'Hitflam  SR    100 mg', '192-0092-64', 'Sr Tablet', 'Ambee Pharmaceuticals Ltd.', '3.50', '0.00', '100 mg', 'Diclofenac Sodium'), 
('1452', 'Hiflox XR   1 gm', '192-0170-23', 'Sr Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '1 gm', 'Ciprofloxacin'), 
('1453', 'Belocef   250 mg', '028-0036-023', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Cephradine'), 
('1454', 'Belocef   500 mg', '028-0037-23', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Cephradine'), 
('1455', 'Gen - 3      200 mg', '028-0077-23', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Cefixime'), 
('1456', 'Clocef   250 mg', '028-0082-23', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Cefaclor'), 
('1457', 'Clocef   500 mg', '028-0087-23', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Cefaclor'), 
('1458', 'Healer      20 mg', '028-0097-67', 'Capsule', 'Amico Laboratories Ltd.', '4.00', '0.00', '20 mg', 'Omeprazole'), 
('1459', 'Monaclox F     250 mg', '028-0059-23', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Flucloxacillin'), 
('1460', 'Monadox      100 mg', '028-0038-23', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Doxycycline'), 
('1461', 'Monamox   500 mg', '028-0080-23', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('1462', 'Monamox   250 mg', '028-0055-023', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('1463', 'Monatrex   250 mg', '028-0053-23', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('1464', 'Monatrex  DS   500 mg', '028-0064-23', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Tetracycline Hydrochloride'), 
('1465', 'Novarin  SR   100 mg', '028-0085-64', 'Capsule', 'Amico Laboratories Ltd.', '2.50', '0.00', '100 mg', 'Diclofenac Sodium'), 
('1466', 'Tramadol      50 mg', '028-0118-65', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('1467', 'Lansopril   15 mg', '028-0094-67', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '15 mg', 'Lansoprazole'), 
('1468', 'Lansopril   30 mg', '028-0091-67', 'Capsule', 'Amico Laboratories Ltd.', '5.50', '0.00', '30 mg', 'Lansoprazole'), 
('1469', 'Monaclox-F   500 mg', '028-0095-23', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Flucloxacillin'), 
('1470', 'Prazia   20 mg', '028-0209-067', 'Capsule', 'Amico Laboratories Ltd.', '7.00', '0.00', '20 mg', 'Esomeprazole'), 
('1471', 'Prazia   40 mg', '028-0210-067', 'Capsule', 'Amico Laboratories Ltd.', '10.00', '0.00', '40 mg', 'Esomeprazole'), 
('1472', 'Candid0   50 mg', '028-0211', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Fluconazole'), 
('1473', 'Candid   150 mg', '028-0212', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '150 mg', 'Fluconazole'), 
('1474', 'Amiflox   250 mg', '028-0058-23', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Ciprofloxacin'), 
('1475', 'Amiflox   500 mg', '028-0060-23', 'Tablet', 'Amico Laboratories Ltd.', '10.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('1476', 'Amipril      25 mg', '028-0069-22', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '25 mg', 'Captopril'), 
('1477', 'Amipril      50 mg', '028-0070-22', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Captopril'), 
('1478', 'Azix   500 mg', '028-0079-23', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('1479', 'Clarimycin   500 mg', '028-0090-23', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Clarithromycin'), 
('1480', 'Dyzin   10 mg', '028-0084-21', 'Tablet', 'Amico Laboratories Ltd.', '2.75', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('1481', 'Gliden   5 mg', '028-0061', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Glibenclamide'), 
('1482', 'Licazide   80 mg', '028-0076', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '80 mg', 'Gliclazide'), 
('1483', 'Hepadin      100 mg', '028-0106-32', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Lamivudine'), 
('1484', 'Ketofun   200 mg', '028-0041', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Ketoconazole'), 
('1485', 'Levin   500 mg', '028-0100-23', 'Tablet', 'Amico Laboratories Ltd.', '14.00', '0.00', '500 mg', 'Levofloxacin'), 
('1486', 'Lodin   10 mg', '028-0075-21', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Loratadine'), 
('1487', 'Losaron      50 mg', '028-0113-022', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Losartan Potassium'), 
('1488', 'Mecozol   400 mg', '028-0033-27', 'Tablet', 'Amico Laboratories Ltd.', '1.00', '0.00', '400 mg', 'Metronidazole'), 
('1489', 'Oracal   1250 mg', '028-0105-62', 'Tablet', 'Amico Laboratories Ltd.', '2.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('1490', 'Panzol      20 mg', '028-0103-67', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '20 mg', 'Pantoprazole'), 
('1491', 'Panzol      40 mg', '028-0104-67', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '40 mg', 'Pantoprazole'), 
('1492', 'Para   500 mg', '028-0021-006', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('1493', 'Pheramin   4 mg', '028-0024-21', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('1494', 'Rocky      150 mg', '028-0101-23', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '150 mg', 'Roxithromycin'), 
('1495', 'Rocky0   300 mg', '028-0102-23', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '300 mg', 'Roxithromycin'), 
('1496', 'Sedapen      5 mg', '028-0022-057', 'Tablet', 'Amico Laboratories Ltd.', '0.69', '0.00', '5 mg', 'Diazepam'), 
('1497', 'Suvic   250 mg', '028-0034-78', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Vitamin C'), 
('1498', 'Tocomin      200 mg', '028-0116-78', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Vitamin E'), 
('1499', 'Vastin   10 mg', '028-0096-61', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Simvastatin'), 
('1500', 'Xepadon   10 mg', '028-01148', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Domperidone'), 
('1501', 'Zoben   400 mg', '028-0042-008', 'Tablet', 'Amico Laboratories Ltd.', '4.50', '0.00', '400 mg', 'Albendazole'), 
('1502', 'Zorep      150 mg', '028-00395', 'Tablet', 'Amico Laboratories Ltd.', '1.50', '0.00', '150 mg', 'Ranitidine'), 
('1503', 'Relaxium.   3 mg', '028-01267', 'Tablet', 'Amico Laboratories Ltd.', '4.00', '0.00', '3 mg', 'Bromazepam'), 
('1504', 'Penjoin   500 mg', '028-0132-64', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Glucosamine'), 
('1505', 'Suvic   250 mg', '028-0133-78', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Vitamin C'), 
('1506', 'Isonil   5 mg', '028-00471', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Oxyphenonium Bromide'), 
('1507', 'Novarin      50 mg', '028-0044-64', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('1508', 'Panflox      200 mg', '028-0099-23', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Sparfloxacin'), 
('1509', 'Ribiflavine   5 mg', '028-0027-79', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Riboflavin'), 
('1510', 'Relaxium   5 mg', '028-0028-60', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Bisacodyl'), 
('1511', 'Amiflox   750 mg', '028-0098-23', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('1512', 'Naproxen   500 mg', '028-0135-64', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Naproxen'), 
('1513', 'Candid      50 mg', '028-0161', 'Tablet', 'Amico Laboratories Ltd.', '8.00', '0.00', '50 mg', 'Fluconazole'), 
('1514', 'Candid      150 mg', '028-0162', 'Tablet', 'Amico Laboratories Ltd.', '22.00', '0.00', '150 mg', 'Fluconazole'), 
('1515', 'Baclofen   10 mg', '028-0165-70', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Baclofen'), 
('1516', 'Ruzmet0   500 mg', '028-0168', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('1517', 'Clonazepam.5   .5 mg', '028-0171-046', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '.5 mg', 'Clonazepam'), 
('1518', 'Clonazepam   2 mg', '028-0172-046', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '2 mg', 'Clonazepam'), 
('1519', 'Hybut   10 mg', '028-01731', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('1520', 'Troy   10 mg', '028-0174-064', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('1521', 'Midaben   7.5 mg', '028-0177-057', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '7.5 mg', 'Midazolam'), 
('1522', 'Halazone   7.5 mg', '028-0177', 'Tablet', 'Amico Laboratories Ltd.', '1.00', '0.00', '7.5 mg', 'Halazone'), 
('1523', 'Halazone   15 mg', '028-0178', 'Tablet', 'Amico Laboratories Ltd.', '1.70', '0.00', '15 mg', 'Halazone'), 
('1524', 'Prazia   20 mg', '028-0180-067', 'Tablet', 'Amico Laboratories Ltd.', '5.00', '0.00', '20 mg', 'Esomeprazole'), 
('1525', 'Prazia   40 mg', '028-0181-67', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '40 mg', 'Esomeprazole'), 
('1526', 'Erixin   500 mg', '028-0184-23', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Erythromycin'), 
('1527', 'Mebendazole   100 mg', '028-0185-8', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Mebendazole'), 
('1528', 'Salbutamol   4 mg', '028-01864', 'Tablet', 'Amico Laboratories Ltd.', '0.46', '0.00', '4 mg', 'Salbutamol'), 
('1529', 'Ibuprofen   400 mg', '028-0187-64', 'Tablet', 'Amico Laboratories Ltd.', '1.43', '0.00', '400 mg', 'Ibuprofen'), 
('1530', 'Clofenta   100 mg', '028-0122-64', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Aceclofenac'), 
('1531', 'Amikast   5 mg', '028-0194-044', 'Tablet', 'Amico Laboratories Ltd.', '8.00', '0.00', '5 mg', 'Montelukast'), 
('1532', 'Amikast   10 mg', '028-0195-044', 'Tablet', 'Amico Laboratories Ltd.', '15.00', '0.00', '10 mg', 'Montelukast'), 
('1533', 'Atenolol   50 mg', '028-0192-22', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Atenolol'), 
('1534', 'Atenolol   100 mg', '028-0193-22', 'Tablet', 'Amico Laboratories Ltd.', '1.38', '0.00', '100 mg', 'Atenolol'), 
('1535', 'Carbamazepine   100 mg', '028-0198-046', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Carbamazepine'), 
('1536', 'Carbamazepine   200 mg', '028-0197-046', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Carbamazepine'), 
('1537', 'Folic Acid   5 mg', '028-01985', 'Tablet', 'Amico Laboratories Ltd.', '0.34', '0.00', '5 mg', 'Folic Acid'), 
('1538', 'Amifex   60 mg', '028-0200-21', 'Tablet', 'Amico Laboratories Ltd.', '3.50', '0.00', '60 mg', 'Fexofenadine Hydrochloride'), 
('1539', 'Amifex   120 mg', '028-0201-21', 'Tablet', 'Amico Laboratories Ltd.', '7.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('1540', 'Ketotifen   1 mg', '028-0202-21', 'Tablet', 'Amico Laboratories Ltd.', '2.50', '0.00', '1 mg', 'Ketotifen'), 
('1541', 'Misoprostol   200 mcg', '028-02039', 'Tablet', 'Amico Laboratories Ltd.', '15.00', '0.00', '200 mcg', 'Misoprostol'), 
('1542', 'Zn   20 mg', '028-0208-62', 'Tablet', 'Amico Laboratories Ltd.', '2.00', '0.00', '20 mg', 'Zinc'), 
('1543', 'AmiClean Tab.   7.5 mg', '028-02137', 'Tablet', 'Amico Laboratories Ltd.', '0.60', '0.00', '7.5 mg', 'Sodium Thiosulfate'), 
('1544', 'AmiClean Tab.   15 mg', '028-02147', 'Tablet', 'Amico Laboratories Ltd.', '0.95', '0.00', '15 mg', 'Sodium Thiosulfate'), 
('1545', 'Carbamazine   100 mg', '028-0215-8', 'Tablet', 'Amico Laboratories Ltd.', '1.30', '0.00', '100 mg', 'Diethylcarbamazine Citrate'), 
('1546', 'Lepath   250 mg', '028-0158-23', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Cefuroxime'), 
('1547', 'AmiCoxib   90 mg', '028-0219-64', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '90 mg', 'Etoricoxib'), 
('1548', 'AmiCoxib   120 mg', '028-0220-64', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '120 mg', 'Etoricoxib'), 
('1549', 'Sidor   50 mg', '028-0221-043', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Sildenafil'), 
('1550', 'Sidor Plus   100 mg', '028-0222-043', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Sildenafil'), 
('1551', 'Novarin  SR    100 mg', '028-0074-64', 'Sr Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('1552', 'Omelet   20 mg', '246-0010-67', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '5.02', '0.00', '20 mg', 'Omeprazole'), 
('1553', 'Flucolet   50 mg', '246-0013', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '8.03', '0.00', '50 mg', 'Fluconazole'), 
('1554', 'Esomo   20 mg', '246-0023-067', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '6.02', '0.00', '20 mg', 'Esomeprazole'), 
('1555', 'Esomo   40 mg', '246-0024-067', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '8.03', '0.00', '40 mg', 'Esomeprazole'), 
('1556', 'Amzith   250 mg', '246-0027-23', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '20.06', '0.00', '250 mg', 'Azithromycin'), 
('1557', 'Flucolet   150 mg', '246-0028', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '20.06', '0.00', '150 mg', 'Fluconazole'), 
('1558', 'Omelet   40 mg', '246-0030-67', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '7.02', '0.00', '40 mg', 'Omeprazole'), 
('1559', 'DFC TR   100 mg', '246-0032-64', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '2.51', '0.00', '100 mg', 'Diclofenac Sodium'), 
('1560', 'Amucef0   400 mg', '246-0048-23', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '50.15', '0.00', '400 mg', 'Cefixime'), 
('1561', 'Amucef   200 mg', '246-0049-23', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '30.10', '0.00', '200 mg', 'Cefixime'), 
('1562', 'Amfrad0   500 mg', '246-0051-23', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '12.54', '0.00', '500 mg', 'Cephradine'), 
('1563', 'Amfrad   250 mg', '246-0052-023', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '6.52', '0.00', '250 mg', 'Cephradine'), 
('1564', 'Burndel   1 %', '246-0055-23', 'Cream', 'Amulet Pharmaceuticals Ltd.', '40.00', '0.00', '1 %', 'Silver Sulphadiazine'), 
('1565', 'WFI   1 ml', '246-0073-79', 'Injection', 'Amulet Pharmaceuticals Ltd.', '0.00', '0.00', '1 ml', 'Water For Injection'), 
('1566', 'Hemolac   68 %', '246-0006-60', 'Oral Solution', 'Amulet Pharmaceuticals Ltd.', '0.00', '0.00', '68 %', 'Lactulose'), 
('1567', 'Amzith0   500 mg', '246-0007-23', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '35.11', '0.00', '500 mg', 'Azithromycin'), 
('1568', 'Amuran   150 mg', '246-00095', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('1569', 'Flocip0   500 mg', '246-0014-23', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '14.05', '0.00', '500 mg', 'Ciprofloxacin'), 
('1570', 'Xofedin   120 mg', '246-0017-21', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '6.52', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('1571', 'Xofedin80   180 mg', '246-0018-21', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '8.03', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('1572', 'DFC   50 mg', '246-0031-64', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '0.60', '0.00', '50 mg', 'Diclofenac Sodium'), 
('1573', 'Toro   10 mg', '246-0033-064', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '10.03', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('1574', 'Setir   10 mg', '246-0034-21', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '2.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('1575', 'Tempanil   500 mg', '246-0038-006', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('1576', 'Desolet   5 mg', '246-0040-21', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '2.51', '0.00', '5 mg', 'Desloratadine'), 
('1577', 'Montilet   10 mg', '246-0041-044', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '15.05', '0.00', '10 mg', 'Montelukast'), 
('1578', 'Nitalet   500 mg', '246-0042-27', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '10.03', '0.00', '500 mg', 'Nitazoxanide'), 
('1579', 'Coxetori   60 mg', '246-0043-64', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '7.02', '0.00', '60 mg', 'Etoricoxib'), 
('1580', 'Coxetpro   120 mg', '246-0044-64', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '14.05', '0.00', '120 mg', 'Etoricoxib'), 
('1581', 'Axefur0   500 mg', '246-0045-23', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '45.13', '0.00', '500 mg', 'Cefuroxime'), 
('1582', 'SMR Tablet   10 mg', '246-0054-70', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '8.03', '0.00', '10 mg', 'Baclofen'), 
('1583', 'Timofet   50 mg', '246-00571', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '6.02', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('1584', 'Rheunil   100 mg', '246-0016-64', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '3.01', '0.00', '100 mg', 'Aceclofenac'), 
('1585', 'Cefilet0 IM   500 mg', '246-0065-23', 'IM Injection', 'Amulet Pharmaceuticals Ltd.', '130.00', '0.00', '500 mg', 'Ceftriaxone'), 
('1586', 'Cefilet gm IM   1 gm', '246-0066-23', 'IM Injection', 'Amulet Pharmaceuticals Ltd.', '190.00', '0.00', '1 gm', 'Ceftriaxone'), 
('1587', 'Cefilet gm IV   1 gm', '246-0067-23', 'IV Injection', 'Amulet Pharmaceuticals Ltd.', '190.00', '0.00', '1 gm', 'Ceftriaxone'), 
('1588', 'Cefilet gm IV   2 gm', '246-0068-23', 'IV Injection', 'Amulet Pharmaceuticals Ltd.', '300.00', '0.00', '2 gm', 'Ceftriaxone'), 
('1589', 'Tetracycline   250 mg', '135-0038-23', 'Capsule', 'APC Pharma Limited', '1.00', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('1590', 'Pemox   500 mg', '135-0052-23', 'Capsule', 'APC Pharma Limited', '6.00', '0.00', '500 mg', 'Amoxicillin'), 
('1591', 'Flutec   250 mg', '135-0060-23', 'Capsule', 'APC Pharma Limited', '5.75', '0.00', '250 mg', 'Flucloxacillin'), 
('1592', 'Flutec   500 mg', '135-0057-23', 'Capsule', 'APC Pharma Limited', '0.00', '0.00', '500 mg', 'Flucloxacillin'), 
('1593', 'Omeprazole      20 mg', '135-0058-67', 'Capsule', 'APC Pharma Limited', '2.50', '0.00', '20 mg', 'Omeprazole'), 
('1594', 'Penac  TR   100 mg', '135-0064-64', 'Capsule', 'APC Pharma Limited', '3.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('1595', 'Seftec0   500 mg', '135-0084-23', 'Capsule', 'APC Pharma Limited', '12.50', '0.00', '500 mg', 'Cephradine'), 
('1596', 'Cloxacillin0   500 mg', '135-0086-23', 'Capsule', 'APC Pharma Limited', '5.50', '0.00', '500 mg', 'Cloxacillin'), 
('1597', 'Cefesta   200 mg', '135-0088-23', 'Capsule', 'APC Pharma Limited', '0.00', '0.00', '200 mg', 'Cefixime'), 
('1598', 'Trogi   2.6 mg', '135-0094', 'Capsule', 'APC Pharma Limited', '0.00', '0.00', '2.6 mg', 'Glyceryl Trinitrate'), 
('1599', 'Apicon   50 mg', '135-0101', 'Capsule', 'APC Pharma Limited', '0.00', '0.00', '50 mg', 'Fluconazole'), 
('1600', 'Comfort   68 %', '135-0079-60', 'Oral Solution', 'APC Pharma Limited', '72.00', '0.00', '68 %', 'Lactulose'), 
('1601', 'Apetryl   400 mg', '135-0027-27', 'Tablet', 'APC Pharma Limited', '0.75', '0.00', '400 mg', 'Metronidazole'), 
('1602', 'Ibuprofen   400 mg', '135-0048-64', 'Tablet', 'APC Pharma Limited', '1.00', '0.00', '400 mg', 'Ibuprofen'), 
('1603', 'Penac      50 mg', '135-0043-64', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('1604', 'Penamin   4 mg', '135-0047-21', 'Tablet', 'APC Pharma Limited', '0.20', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('1605', 'Phenoxymethyl   250 mg', '135-0050-23', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '250 mg', 'Phenoxymethyl Penicillin'), 
('1606', 'Ranitec      150 mg', '135-00425', 'Tablet', 'APC Pharma Limited', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('1607', 'Domstal   10 mg', '135-00568', 'Tablet', 'APC Pharma Limited', '2.00', '0.00', '10 mg', 'Domperidone'), 
('1608', 'Cetrizine   10 mg', '135-0055-21', 'Tablet', 'APC Pharma Limited', '2.50', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('1609', 'Griseofulvin   500 mg', '135-0059', 'Tablet', 'APC Pharma Limited', '5.50', '0.00', '500 mg', 'Griseofulvin'), 
('1610', 'Orange C     250 mg', '135-0061-78', 'Tablet', 'APC Pharma Limited', '0.82', '0.00', '250 mg', 'Vitamin C'), 
('1611', 'Ciprotec   500 mg', '135-0041-23', 'Tablet', 'APC Pharma Limited', '8.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('1612', 'Ambuterol   10 mg', '135-00674', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '10 mg', 'Bambuterol Hydrochloride'), 
('1613', 'Calcium   1250 mg', '135-0070-62', 'Tablet', 'APC Pharma Limited', '2.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('1614', 'Furotec   500 mg', '135-0073-23', 'Tablet', 'APC Pharma Limited', '45.00', '0.00', '500 mg', 'Cefuroxime'), 
('1615', 'Noworm   400 mg', '135-0076-008', 'Tablet', 'APC Pharma Limited', '3.30', '0.00', '400 mg', 'Albendazole'), 
('1616', 'Zeocin   500 mg', '135--23', 'Tablet', 'APC Pharma Limited', '30.00', '0.00', '500 mg', 'Azithromycin'), 
('1617', 'Tablet Penac-AC   100 mg', '135-0087-64', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '100 mg', 'Aceclofenac'), 
('1618', 'Prozide   80 mg', '135-0092', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '80 mg', 'Gliclazide'), 
('1619', 'Apcard   50 mg', '135-0093-22', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '50 mg', 'Atenolol'), 
('1620', 'Metofin   850 mg', '135-0096', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('1621', 'Dexamethasone   .5 mg', '135-0099-72', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '.5 mg', 'Dexamethasone'), 
('1622', 'Apilac   10 mg', '135-0102-064', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('1623', 'Slaken   10 mg', '135-0103-70', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '10 mg', 'Baclofen'), 
('1624', 'Vastas   10 mg', '135-0104-061', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '10 mg', 'Atorvastatin'), 
('1625', 'Vastas   20 mg', '135-0105-061', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '20 mg', 'Atorvastatin'), 
('1626', 'Topracid   20 mg', '135-0107-67', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '20 mg', 'Pantoprazole'), 
('1627', 'Topracid   40 mg', '135-0108-67', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '40 mg', 'Pantoprazole'), 
('1628', 'Esomepra   20 mg', '135-0109-067', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '20 mg', 'Esomeprazole'), 
('1629', 'Esomepra   40 mg', '135-0110-67', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '40 mg', 'Esomeprazole'), 
('1630', 'Omeprazole   20 mg', '135-0082-67', 'Sached Powder', 'APC Pharma Limited', '0.00', '0.00', '20 mg', 'Omeprazole'), 
('1631', 'Aphrin   500 mg', '170-0043-23', 'Capsule', 'Apex Pharmaceuticals Ltd.', '12.00', '0.00', '500 mg', 'Cephradine'), 
('1632', 'Apoxy   500 mg', '170-0047-23', 'Capsule', 'Apex Pharmaceuticals Ltd.', '6.73', '0.00', '500 mg', 'Amoxicillin'), 
('1633', 'Aspra      20 mg', '170-0041-67', 'Capsule', 'Apex Pharmaceuticals Ltd.', '4.00', '0.00', '20 mg', 'Omeprazole'), 
('1634', 'Dix  TR    100 mg', '170-0068-64', 'Capsule', 'Apex Pharmaceuticals Ltd.', '2.53', '0.00', '100 mg', 'Diclofenac Sodium'), 
('1635', 'Luf   250 mg', '170-0055-23', 'Capsule', 'Apex Pharmaceuticals Ltd.', '5.50', '0.00', '250 mg', 'Flucloxacillin'), 
('1636', 'Luff   500 mg', '170-0056-23', 'Capsule', 'Apex Pharmaceuticals Ltd.', '10.00', '0.00', '500 mg', 'Flucloxacillin'), 
('1637', 'Apoxy   250 mg', '170-0033-023', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('1638', 'Tera   250 mg', '170-0028-23', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('1639', 'Rindocin   25 mg', '170-0034-64', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Indomethacin'), 
('1640', 'Texit      200 mg', '170-0061-23', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Cefixime'), 
('1641', 'Trol      50 mg', '170-0062-65', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('1642', 'Zolen      50 mg', '170-0039', 'Capsule', 'Apex Pharmaceuticals Ltd.', '8.00', '0.00', '50 mg', 'Fluconazole'), 
('1643', 'Zolen      150 mg', '170-0040', 'Capsule', 'Apex Pharmaceuticals Ltd.', '18.00', '0.00', '150 mg', 'Fluconazole'), 
('1644', 'Apdox      100 mg', '170-0053-23', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Doxycycline'), 
('1645', 'Cepoxid      100 mg', '170-0121-23', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Cefpodoxime'), 
('1646', 'Adnor   75 mg', '170-01764', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '75 mg', 'Doxepin'), 
('1647', 'Aspra   40 mg', '170-0178-67', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Omeprazole'), 
('1648', 'Texit0   400 mg', '170-0182-23', 'Capsule', 'Apex Pharmaceuticals Ltd.', '50.00', '0.00', '400 mg', 'Cefixime'), 
('1649', 'Hemostop   500 mg', '170-01839', 'Capsule', 'Apex Pharmaceuticals Ltd.', '15.00', '0.00', '500 mg', 'Tranexamic Acid'), 
('1650', 'Tamsol   400 mcg', '170-01979', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '400 mcg', 'Tamsulosin Hydrochloride'), 
('1651', 'Nexe   20 mg', '170-0246-067', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Esomeprazole'), 
('1652', 'Rabegend   20 mg', '170-0259-67', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('1653', 'Nervolin   50 mg', '170-0269-046', 'Capsule', 'Apex Pharmaceuticals Ltd.', '12.00', '0.00', '50 mg', 'Pregabalin'), 
('1654', 'Nervolin   75 mg', '170-0270-046', 'Capsule', 'Apex Pharmaceuticals Ltd.', '16.00', '0.00', '75 mg', 'Pregabalin'), 
('1655', 'Water for Injection   1 ml', '170-0171-79', 'Injection', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '1 ml', 'Water For Injection'), 
('1656', 'Polycol   17 gm', '170-0073-60', 'Powder', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '17 gm', 'Poly Ethylene Glycol 3350'), 
('1657', 'Apocal   Chewable   625 mg', '170-0057-62', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '625 mg', 'Calcium Carbonate'), 
('1658', 'Montelon   4 mg', '170-0066-044', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '4 mg', 'Montelukast'), 
('1659', 'Montelon   10 mg', '170-0067-044', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Montelukast'), 
('1660', 'Preform   850 mg', '170-0042', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('1661', 'Pril.5   2.5 mg', '170-0071-022', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '2.5 mg', 'Ramipril'), 
('1662', 'Rhythm   250 mg', '170-0063-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Erythromycin'), 
('1663', 'Rhythm   500 mg', '170-0064-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Erythromycin'), 
('1664', 'Ribazole   400 mg', '170-0026-27', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('1665', 'Til   125 mg', '170-0058-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '125 mg', 'Cefuroxime'), 
('1666', 'Til   250 mg', '170-0059-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Cefuroxime'), 
('1667', 'Nexe      20 mg', '170-0088-067', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Esomeprazole'), 
('1668', 'Metle Tab   500 mg', '170-0089', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('1669', 'Vocet   5 mg', '170-0090-21', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Levocetirizine Hydrochloride'), 
('1670', 'Lequin   250 mg', '170-0091-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Levofloxacin'), 
('1671', 'Lequin   500 mg', '170-0092-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Levofloxacin'), 
('1672', 'Lox   500 mg', '170-0038-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '14.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('1673', 'Ranpex   150 mg', '170-00485', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Ranitidine'), 
('1674', 'Apzol   400 mg', '170-0050-008', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Albendazole'), 
('1675', 'Apeclo   100 mg', '170-0051-64', 'Tablet', 'Apex Pharmaceuticals Ltd.', '1.50', '0.00', '100 mg', 'Aceclofenac'), 
('1676', 'Apocal   1250 mg', '170-0052-62', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('1677', 'Pril      5 mg', '170-0072-022', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Ramipril'), 
('1678', 'Apexid      200 mg', '170-0074-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Pivmecillinam'), 
('1679', 'Nel   600 mg', '170-0075-023', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '600 mg', 'Linezolid'), 
('1680', 'Nel   400 mg', '170-0076-023', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Linezolid'), 
('1681', 'Delot   5 mg', '170-0077-21', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Desloratadine'), 
('1682', 'Losarpex   50 mg', '170-0078-022', 'Tablet', 'Apex Pharmaceuticals Ltd.', '8.00', '0.00', '50 mg', 'Losartan Potassium'), 
('1683', 'Losarpex   25 mg', '170-0079-022', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Losartan Potassium'), 
('1684', 'Fixgut   10 mg', '170-00808', 'Tablet', 'Apex Pharmaceuticals Ltd.', '2.00', '0.00', '10 mg', 'Domperidone'), 
('1685', 'Tamol   500 mg', '170-0096-006', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('1686', 'A S A0   300 mg', '170-0097-6', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Aspirin'), 
('1687', 'A.S.A  CV    75 mg', '170-0098-26', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '75 mg', 'Aspirin'), 
('1688', 'Acorex   30 mg', '170-0105-31', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '30 mg', 'Ambroxol'), 
('1689', 'Azinil   250 mg', '170-0106-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Azithromycin'), 
('1690', 'Azinil   500 mg', '170-0107-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '30.00', '0.00', '500 mg', 'Azithromycin'), 
('1691', 'Diacon   80 mg', '170-0109', 'Tablet', 'Apex Pharmaceuticals Ltd.', '7.00', '0.00', '80 mg', 'Gliclazide'), 
('1692', 'Dexbru      200 mg', '170-0141-64', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Dexibuprofen (S Ibuprofen)'), 
('1693', 'Progend0   500 mg', '170-0144-64', 'Tablet', 'Apex Pharmaceuticals Ltd.', '8.00', '0.00', '500 mg', 'Naproxen'), 
('1694', 'Zipol      20 mg', '170-0114-62', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Zinc'), 
('1695', 'Cepoxid      200 mg', '170-0122-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '41.00', '0.00', '200 mg', 'Cefpodoxime'), 
('1696', 'Winspa   10 mg', '170-01251', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Dicycloverine Hydrochloride'), 
('1697', 'Eszo   1 mg', '170-0127-057', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '1 mg', 'Eszopiclone'), 
('1698', 'Eszo   2 mg', '170-0128-057', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '2 mg', 'Eszopiclone'), 
('1699', 'Lesal   1 mg', '170-01294', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '1 mg', 'Levosalbutamol'), 
('1700', 'Lesal   2 mg', '170-01304', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '2 mg', 'Levosalbutamol'), 
('1701', 'Zilcef   250 mg', '170-0138-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Cefprozil'), 
('1702', 'Zilcef00   500 mg', '170-0139-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Cefprozil'), 
('1703', 'Dexbru0   300 mg', '170-0142-64', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Dexibuprofen (S Ibuprofen)'), 
('1704', 'Dexbru0   400 mg', '170-0143-64', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Dexibuprofen (S Ibuprofen)'), 
('1705', 'Mcard      5 mg', '170-0145-022', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Amlodipine'), 
('1706', 'Niazid   500 mg', '170-0147-27', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Nitazoxanide'), 
('1707', 'Tenamic   200 mg', '170-01497', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Tolfenamic Acid'), 
('1708', 'Ranul      150 mg', '170-01355', 'Tablet', 'Apex Pharmaceuticals Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('1709', 'Flunarin      5 mg', '170-01507', 'Tablet', 'Apex Pharmaceuticals Ltd.', '3.00', '0.00', '5 mg', 'Flunarizine'), 
('1710', 'Flunarin   10 mg', '170-01517', 'Tablet', 'Apex Pharmaceuticals Ltd.', '4.00', '0.00', '10 mg', 'Flunarizine'), 
('1711', 'Kflam   10 mg', '170-0153-064', 'Tablet', 'Apex Pharmaceuticals Ltd.', '7.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('1712', 'Lox   750 mg', '170-0154-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('1713', 'Pantol      20 mg', '170-0156-67', 'Tablet', 'Apex Pharmaceuticals Ltd.', '4.50', '0.00', '20 mg', 'Pantoprazole'), 
('1714', 'Eflam   90 mg', '170-0160-64', 'Tablet', 'Apex Pharmaceuticals Ltd.', '12.00', '0.00', '90 mg', 'Etoricoxib'), 
('1715', 'Eflam   60 mg', '170-0159-64', 'Tablet', 'Apex Pharmaceuticals Ltd.', '7.00', '0.00', '60 mg', 'Etoricoxib'), 
('1716', 'Bacspa   10 mg', '170-0161-70', 'Tablet', 'Apex Pharmaceuticals Ltd.', '7.00', '0.00', '10 mg', 'Baclofen'), 
('1717', 'Ketronil0   50 mg', '170-0180-64', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Ketoprofen'), 
('1718', 'Ketronil0   100 mg', '170-0181-64', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Ketoprofen'), 
('1719', 'Texicam   20 mg', '170-0184-64', 'Tablet', 'Apex Pharmaceuticals Ltd.', '8.00', '0.00', '20 mg', 'Tenoxicam'), 
('1720', 'Pantrol   40 mg', '170-0187-67', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Pantoprazole'), 
('1721', 'Visnor   50 mg', '170-01881', 'Tablet', 'Apex Pharmaceuticals Ltd.', '4.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('1722', 'Zonil   500 mcg', '170-01927', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '500 mcg', 'Pizotifen'), 
('1723', 'Zonil-TS   1.5 mg', '170-01937', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '1.5 mg', 'Pizotifen'), 
('1724', 'Rabeloc   20 mg', '170-0196-67', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('1725', 'Zapitor   10 mg', '170-0198-061', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Atorvastatin'), 
('1726', 'Nervo2   .5 mg', '170-0199-78', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '.5 mg', 'Mecobalamin'), 
('1727', 'Ascorbic   250 mg', '170-0208-78', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Vitamin C'), 
('1728', 'Sopnil   7.5 mg', '170-0238-057', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '7.5 mg', 'Midazolam'), 
('1729', 'Clonapex   2 mg', '170-0239-046', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '2 mg', 'Clonazepam'), 
('1730', 'Lexopam   3 mg', '170-02407', 'Tablet', 'Apex Pharmaceuticals Ltd.', '3.00', '0.00', '3 mg', 'Bromazepam'), 
('1731', 'Zapitor   20 mg', '170-0241-061', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Atorvastatin'), 
('1732', 'Nexe   40 mg', '170-0242-67', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Esomeprazole'), 
('1733', 'Bacspa   5 mg', '170-0243-70', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Baclofen'), 
('1734', 'Alafree20   120 mg', '170-0247-21', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('1735', 'Alafree80   180 mg', '170-0248-21', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('1736', 'Supergra0   50 mg', '170-0250-043', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Sildenafil'), 
('1737', 'Gemifix   320 mg', '170-0253-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '320 mg', 'Gemefloxacin'), 
('1738', 'Clonapex.5   .5 mg', '170-0254-046', 'Tablet', 'Apex Pharmaceuticals Ltd.', '5.00', '0.00', '.5 mg', 'Clonazepam'), 
('1739', 'Adnor 3   3 mg', '170-0257-', 'Tablet', 'Apex Pharmaceuticals Ltd.', '5.00', '0.00', '3 mg', 'Doxepin'), 
('1740', 'Xiva   400 mg', '170-02604', 'Tablet', 'Apex Pharmaceuticals Ltd.', '10.01', '0.00', '400 mg', 'Doxophylline'), 
('1741', 'Bomifix 8   8 mg', '170-02758', 'Tablet', 'Apex Pharmaceuticals Ltd.', '10.00', '0.00', '8 mg', 'Ondansetron'), 
('1742', 'Lerupa   10 mg', '170-0282-021', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Rupatadine'), 
('1743', 'Osovastmg   10 mg', '170-0283-061', 'Tablet', 'Apex Pharmaceuticals Ltd.', '20.00', '0.00', '10 mg', 'Rosuvastatin'), 
('1744', 'Cidogrel   75 mg', '170-0281-026', 'Tablet', 'Apex Pharmaceuticals Ltd.', '12.00', '0.00', '75 mg', 'Clopidogrel'), 
('1745', 'Xoricard   20 mg', '170-0280-022', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Olmesartan Medoxomil'), 
('1746', 'Nohist   10 mg', '170-0278-021', 'Tablet', 'Apex Pharmaceuticals Ltd.', '3.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('1747', 'Xisrol   5 mg', '170-0279-022', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Bisoprolol Hemifumarate'), 
('1748', 'Keptrix IV   1 gm', '170-0164-23', 'IV Injection', 'Apex Pharmaceuticals Ltd.', '185.00', '0.00', '1 gm', 'Ceftriaxone'), 
('1749', 'Keptrex IV   500 mg', '170-0165-23', 'IV Injection', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Ceftriaxone'), 
('1750', 'Keptrix IV   250 mg', '170-0166-23', 'IV Injection', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Ceftriaxone'), 
('1751', 'Keptrix G   2 gm', '170-0189-23', 'IV Injection', 'Apex Pharmaceuticals Ltd.', '290.00', '0.00', '2 gm', 'Ceftriaxone'), 
('1752', 'Flurom   .1 %', '170-02052', 'Eye Drops', 'Apex Pharmaceuticals Ltd.', '80.00', '0.00', '.1 %', 'Fluorometholone'), 
('1753', 'Aljen   .025 %', '170-02142', 'Eye Drops', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '.025 %', 'Ketotifen'), 
('1754', 'Timolol.5%   .5 %', '170-02192', 'Eye Drops', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '.5 %', 'Timolol Maleate'), 
('1755', 'Protix   10 mg', '170-01348', 'Dispersible Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Domperidone'), 
('1756', 'A-One XR   665 mg', '170-0274-6', 'Xr Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '665 mg', 'Paracetamol'), 
('1757', 'Metle   500 mg', '170-0271', 'Xr Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('1758', 'Apeclo SR   200 mg', '170-0252-64', 'Er Tablet', 'Apex Pharmaceuticals Ltd.', '5.00', '0.00', '200 mg', 'Aceclofenac'), 
('1759', 'Aspra  SR    20 mg', '170-0113', 'Sr Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Omeprazole'), 
('1760', 'Apcilin   250 mg', '076-0035-23', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Ampicillin'), 
('1761', 'Apimox   500 mg', '076-0060-23', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('1762', 'Apimox   250 mg', '076-0037-023', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '2.83', '0.00', '250 mg', 'Amoxicillin'), 
('1763', 'Asef   500 mg', '076-0051-23', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Cephalexin'), 
('1764', 'Atron   250 mg', '076-0018-23', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '1.16', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('1765', 'Cloxa   500 mg', '076-0038-23', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '5.71', '0.00', '500 mg', 'Cloxacillin'), 
('1766', 'Doxa      100 mg', '076-0052-23', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Doxycycline'), 
('1767', 'Hk      20 mg', '076-0062-67', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '5.00', '0.00', '20 mg', 'Omeprazole'), 
('1768', 'Hk      40 mg', '076-0063-67', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '0.00', '0.00', '40 mg', 'Omeprazole'), 
('1769', 'Sofa   250 mg', '076-0061-23', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Flucloxacillin'), 
('1770', 'Acefra   500 mg', '076--23', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Cephradine'), 
('1771', 'Apiclox   250 mg', '076-0016-23', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '2.53', '0.00', '250 mg', 'Chloramphenicol'), 
('1772', 'AX-3   200 mg', '076-0088-23', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Cefixime'), 
('1773', 'Esmepra   20 mg', '076-0096-067', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '6.50', '0.00', '20 mg', 'Esomeprazole'), 
('1774', 'Conazole   50 mg', '076-0080', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '8.00', '0.00', '50 mg', 'Fluconazole'), 
('1775', 'Sofa0   500 mg', '076-0078-23', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Flucloxacillin'), 
('1776', 'Diclo-TR   100 mg', '076-0082-64', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '3.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('1777', 'Alert   10 mg', '076-0058-21', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '2.73', '0.00', '10 mg', 'Loratadine'), 
('1778', 'Aminol      100 mg', '076-0036-22', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Atenolol'), 
('1779', 'Apigamon   500 mg', '076-0042-23', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '3.95', '0.00', '500 mg', 'Nalidixic Acid'), 
('1780', 'Aspirin0   300 mg', '076-0028-6', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '0.00', '0.00', '300 mg', 'Aspirin'), 
('1781', 'Cipro   500 mg', '076-0046-23', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '10.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('1782', 'Diclo      50 mg', '076-0045-64', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '0.40', '0.00', '50 mg', 'Diclofenac Sodium'), 
('1783', 'H2      150 mg', '076-00445', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('1784', 'Histin   4 mg', '076-0029-21', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '0.21', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('1785', 'Hylac   10 mg', '076-00261', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '1.81', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('1786', 'Ibuflam   400 mg', '076-0050-64', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '1.11', '0.00', '400 mg', 'Ibuprofen'), 
('1787', 'Promel   500 mg', '076-0027-006', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '0.53', '0.00', '500 mg', 'Paracetamol'), 
('1788', 'Promex      100 mg', '076-0031-8', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '0.71', '0.00', '100 mg', 'Mebendazole'), 
('1789', 'Protopa      20 mg', '076-0059-67', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '4.00', '0.00', '20 mg', 'Pantoprazole'), 
('1790', 'Spardon      200 mg', '076-0076-23', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '16.00', '0.00', '200 mg', 'Sparfloxacin'), 
('1791', 'Apzyl   400 mg', '076-0029-27', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '1.07', '0.00', '400 mg', 'Metronidazole'), 
('1792', 'Apozyth   500 mg', '076-0086-23', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '33.33', '0.00', '500 mg', 'Azithromycin'), 
('1793', 'Apoket   10 mg', '076-0091-064', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '10.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('1794', 'Aptofen   1 mg', '076-0092-21', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '2.00', '0.00', '1 mg', 'Ketotifen'), 
('1795', 'Apedom   10 mg', '076-00688', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '2.00', '0.00', '10 mg', 'Domperidone'), 
('1796', 'Acflam   100 mg', '076-0074-64', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '4.00', '0.00', '100 mg', 'Aceclofenac'), 
('1797', 'Levodon   500 mg', '076-0081-23', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '15.00', '0.00', '500 mg', 'Levofloxacin'), 
('1798', 'Calfeed   1250 mg', '076-0070-62', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '2.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('1799', 'Albezole   400 mg', '076-0057-008', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '3.80', '0.00', '400 mg', 'Albendazole'), 
('1800', 'Afix      200 mg', '143-0129-23', 'Capsule', 'Aristopharma Limited', '35.00', '0.00', '200 mg', 'Cefixime'), 
('1801', 'Anticol   15 mg', '143-0127-67', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '15 mg', 'Lansoprazole'), 
('1802', 'Anzo   30 mg', '143-0128-67', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '30 mg', 'Lansoprazole'), 
('1803', 'Aristocef   250 mg', '143-0033-23', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '250 mg', 'Cephalexin'), 
('1804', 'Aristocef   500 mg', '143-0043-23', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '500 mg', 'Cephalexin'), 
('1805', 'Aristodox      100 mg', '143-0048-23', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '100 mg', 'Doxycycline'), 
('1806', 'Aristomox   500 mg', '143-0114-23', 'Capsule', 'Aristopharma Limited', '6.75', '0.00', '500 mg', 'Amoxicillin'), 
('1807', 'Aristomox   250 mg', '143-0024-023', 'Capsule', 'Aristopharma Limited', '3.50', '0.00', '250 mg', 'Amoxicillin'), 
('1808', 'Erdon  TR    100 mg', '143-0095-64', 'Capsule', 'Aristopharma Limited', '3.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('1809', 'Arovan      40 mg', '143-0227-22', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '40 mg', 'Valsartan'), 
('1810', 'Arovan   80 mg', '143-0228-22', 'Capsule', 'Aristopharma Limited', '10.00', '0.00', '80 mg', 'Valsartan'), 
('1811', 'Az   250 mg', '143-0112-23', 'Capsule', 'Aristopharma Limited', '25.00', '0.00', '250 mg', 'Azithromycin'), 
('1812', 'Az   500 mg', '143-0135-23', 'Capsule', 'Aristopharma Limited', '35.00', '0.00', '500 mg', 'Azithromycin'), 
('1813', 'Diflu      50 mg', '143-0140', 'Capsule', 'Aristopharma Limited', '8.00', '0.00', '50 mg', 'Fluconazole'), 
('1814', 'Diflu      150 mg', '143-0141', 'Capsule', 'Aristopharma Limited', '22.00', '0.00', '150 mg', 'Fluconazole'), 
('1815', 'Extracef   250 mg', '143-0104-023', 'Capsule', 'Aristopharma Limited', '6.50', '0.00', '250 mg', 'Cephradine'), 
('1816', 'Extracef   500 mg', '143-0105-23', 'Capsule', 'Aristopharma Limited', '15.00', '0.00', '500 mg', 'Cephradine'), 
('1817', 'Gemfil   300 mg', '143-0237-61', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '300 mg', 'Gemfibrozil'), 
('1818', 'Nitrocard  SR .6   2.6 mg', '143-0235', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '2.6 mg', 'Glyceryl Trinitrate'), 
('1819', 'Omep   10 mg', '143-0134-67', 'Capsule', 'Aristopharma Limited', '2.00', '0.00', '10 mg', 'Omeprazole'), 
('1820', 'Omep      20 mg', '143-0119-67', 'Capsule', 'Aristopharma Limited', '5.00', '0.00', '20 mg', 'Omeprazole'), 
('1821', 'Omep      40 mg', '143-0126-67', 'Capsule', 'Aristopharma Limited', '8.00', '0.00', '40 mg', 'Omeprazole'), 
('1822', 'Reumacap   25 mg', '143-0021-64', 'Capsule', 'Aristopharma Limited', '1.00', '0.00', '25 mg', 'Indomethacin'), 
('1823', 'Reumacap  SR   75 mg', '143-0240-64', 'Capsule', 'Aristopharma Limited', '4.00', '0.00', '75 mg', 'Indomethacin'), 
('1824', 'Stafoxin   250 mg', '143-0058-23', 'Capsule', 'Aristopharma Limited', '5.50', '0.00', '250 mg', 'Flucloxacillin'), 
('1825', 'Stafoxin   500 mg', '143-0115-23', 'Capsule', 'Aristopharma Limited', '10.00', '0.00', '500 mg', 'Flucloxacillin'), 
('1826', 'Taxetil      200 mg', '143-0276-23', 'Capsule', 'Aristopharma Limited', '40.00', '0.00', '200 mg', 'Cefpodoxime'), 
('1827', 'Taxetil      100 mg', '143-0164-23', 'Capsule', 'Aristopharma Limited', '22.00', '0.00', '100 mg', 'Cefpodoxime'), 
('1828', 'Tetracycline   250 mg', '143-0070-23', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('1829', 'Tetracycline0   500 mg', '143-0073-23', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '500 mg', 'Tetracycline Hydrochloride'), 
('1830', 'Tramacap      50 mg', '143-0122-65', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('1831', 'Hemostat   500 mg', '143-03589', 'Capsule', 'Aristopharma Limited', '20.00', '0.00', '500 mg', 'Tranexamic Acid'), 
('1832', 'Tigicon      200 mg', '143-0360-61', 'Capsule', 'Aristopharma Limited', '7.00', '0.00', '200 mg', 'Fenofibrate'), 
('1833', 'Afix   400 mg', '143-0367-23', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '400 mg', 'Cefixime'), 
('1834', 'Nimodol0   300 mg', '143-0378-64', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '300 mg', 'Etodolac'), 
('1835', 'Emep E/C   20 mg', '143-0406-067', 'Capsule', 'Aristopharma Limited', '7.00', '0.00', '20 mg', 'Esomeprazole'), 
('1836', 'Emep E/C   40 mg', '143-0407-067', 'Capsule', 'Aristopharma Limited', '9.00', '0.00', '40 mg', 'Esomeprazole'), 
('1837', 'Neurovan   75 mg', '143-0425-046', 'Capsule', 'Aristopharma Limited', '16.00', '0.00', '75 mg', 'Pregabalin'), 
('1838', 'Neurovan   150 mg', '143-0426-046', 'Capsule', 'Aristopharma Limited', '30.00', '0.00', '150 mg', 'Pregabalin'), 
('1839', 'Antiflu   75 mg', '143-0427-32', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '75 mg', 'Oseltamivir'), 
('1840', 'Antiflu5   45 mg', '143-0432-32', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '45 mg', 'Oseltamivir'), 
('1841', 'Diflu   200 mg', '143-0445', 'Capsule', 'Aristopharma Limited', '25.00', '0.00', '200 mg', 'Fluconazole'), 
('1842', 'Clinex   300 mg', '143-0457-23', 'Capsule', 'Aristopharma Limited', '15.00', '0.00', '300 mg', 'Clindamycin'), 
('1843', 'Prostanil MR   400 mcg', '143-04669', 'Capsule', 'Aristopharma Limited', '10.00', '0.00', '400 mcg', 'Tamsulosin Hydrochloride'), 
('1844', 'Neurovan   50 mg', '143-0492-046', 'Capsule', 'Aristopharma Limited', '12.00', '0.00', '50 mg', 'Pregabalin'), 
('1845', 'Clinex   150 mg', '143-0530-23', 'Capsule', 'Aristopharma Limited', '8.00', '0.00', '150 mg', 'Clindamycin'), 
('1846', 'Siloflo   4 mg', '143-06299', 'Capsule', 'Aristopharma Limited', '8.00', '0.00', '4 mg', 'Silodosin'), 
('1847', 'Siloflo 8   8 mg', '143-06309', 'Capsule', 'Aristopharma Limited', '15.00', '0.00', '8 mg', 'Silodosin'), 
('1848', 'Neurovan   25 mg', '143-0633-046', 'Capsule', 'Aristopharma Limited', '8.00', '0.00', '25 mg', 'Pregabalin'), 
('1849', 'Silvadazin%   1 %', '143-0091-23', 'Cream', 'Aristopharma Limited', '45.00', '0.00', '1 %', 'Silver Sulphadiazine'), 
('1850', 'Water For Injection   10 ml', '143-0205-79', 'Injection', 'Aristopharma Limited', '4.90', '0.00', '10 ml', 'Water For Injection'), 
('1851', 'Water For Injection   5 ml', '143-0204-79', 'Injection', 'Aristopharma Limited', '3.32', '0.00', '5 ml', 'Water For Injection'), 
('1852', 'Water for Injection   2 ml', '143-0503-79', 'Injection', 'Aristopharma Limited', '0.00', '0.00', '2 ml', 'Water For Injection'), 
('1853', 'Avolac   Oral   68 %', '143-0071-60', 'Oral Solution', 'Aristopharma Limited', '140.00', '0.00', '68 %', 'Lactulose'), 
('1854', 'Xpa25   125 mg', '143-0480-006', 'Suppository', 'Aristopharma Limited', '5.00', '0.00', '125 mg', 'Paracetamol'), 
('1855', 'Xpa   250 mg', '143-0481-006', 'Suppository', 'Aristopharma Limited', '6.00', '0.00', '250 mg', 'Paracetamol'), 
('1856', 'Xpa0   500 mg', '143-0482-006', 'Suppository', 'Aristopharma Limited', '9.00', '0.00', '500 mg', 'Paracetamol'), 
('1857', 'Apuldon   15 mg', '143-04838', 'Suppository', 'Aristopharma Limited', '6.00', '0.00', '15 mg', 'Domperidone'), 
('1858', 'Apuldon   30 mg', '143-04848', 'Suppository', 'Aristopharma Limited', '9.00', '0.00', '30 mg', 'Domperidone'), 
('1859', 'Reumacid   100 mg', '143-0485-64', 'Suppository', 'Aristopharma Limited', '9.00', '0.00', '100 mg', 'Indomethacin'), 
('1860', 'Tramacid   100 mg', '143-0486-65', 'Suppository', 'Aristopharma Limited', '15.00', '0.00', '100 mg', 'Tramadol Hydrochloride'), 
('1861', 'Erdon   50 mg', '143-0487-64', 'Suppository', 'Aristopharma Limited', '15.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('1862', 'Apulset   16 mg', '143-05998', 'Suppository', 'Aristopharma Limited', '15.00', '0.00', '16 mg', 'Ondansetron'), 
('1863', 'A Mycin   250 mg', '143-0061-23', 'Tablet', 'Aristopharma Limited', '5.15', '0.00', '250 mg', 'Erythromycin'), 
('1864', 'A Mycin   500 mg', '143-0078-23', 'Tablet', 'Aristopharma Limited', '9.00', '0.00', '500 mg', 'Erythromycin'), 
('1865', 'Abentel   400 mg', '143-0080-008', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '400 mg', 'Albendazole'), 
('1866', 'Acliz   50 mg', '143-02248', 'Tablet', 'Aristopharma Limited', '2.50', '0.00', '50 mg', 'Meclizine Hydrochloride'), 
('1867', 'Actine      5 mg', '143-0233', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '5 mg', 'Glipizide'), 
('1868', 'Agoxin   250 mcg', '143-0232-35', 'Tablet', 'Aristopharma Limited', '1.09', '0.00', '250 mcg', 'Digoxin'), 
('1869', 'Alexid      200 mg', '143-0184-23', 'Tablet', 'Aristopharma Limited', '15.00', '0.00', '200 mg', 'Pivmecillinam'), 
('1870', 'Alfa E     200 mg', '143-0108-78', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '200 mg', 'Vitamin E'), 
('1871', 'Ametil   5 mg', '143-00308', 'Tablet', 'Aristopharma Limited', '0.46', '0.00', '5 mg', 'Prochlorperazine Maleate'), 
('1872', 'Aplet      100 mg', '143-0256-36', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '100 mg', 'Cilostazol'), 
('1873', 'Aplet      50 mg', '143-0255-36', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '50 mg', 'Cilostazol'), 
('1874', 'Aprocin   250 mg', '143-0049-23', 'Tablet', 'Aristopharma Limited', '8.50', '0.00', '250 mg', 'Ciprofloxacin'), 
('1875', 'Aprocin   500 mg', '143-0079-23', 'Tablet', 'Aristopharma Limited', '15.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('1876', 'Aprozil   500 mg', '143-0283-23', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '500 mg', 'Cefprozil'), 
('1877', 'Apuldon   10 mg', '143-01478', 'Tablet', 'Aristopharma Limited', '2.50', '0.00', '10 mg', 'Domperidone'), 
('1878', 'Arotril   .5 mg', '143-0210-046', 'Tablet', 'Aristopharma Limited', '4.00', '0.00', '.5 mg', 'Clonazepam'), 
('1879', 'Arotril   2 mg', '143-0209-046', 'Tablet', 'Aristopharma Limited', '6.00', '0.00', '2 mg', 'Clonazepam'), 
('1880', 'Aspin      75 mg', '143-0067-26', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '75 mg', 'Aspirin'), 
('1881', 'Axim   125 mg', '143-0156-23', 'Tablet', 'Aristopharma Limited', '15.00', '0.00', '125 mg', 'Cefuroxime'), 
('1882', 'Axim   250 mg', '143-0157-23', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '250 mg', 'Cefuroxime'), 
('1883', 'Calbon   1250 mg', '143-0133-62', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('1884', 'Calcitab   300 mg', '143-0057-62', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '300 mg', 'Calcium Lactate'), 
('1885', 'Caljuven   Chewable   625 mg', '143-0146-62', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '625 mg', 'Calcium Carbonate'), 
('1886', 'Carmaz      200 mg', '143-0236-046', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '200 mg', 'Carbamazepine'), 
('1887', 'Clovul      50 mg', '143-02183', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '50 mg', 'Clomiphene Citrate'), 
('1888', 'Contine  CR    250 mg', '143-02114', 'Tablet', 'Aristopharma Limited', '1.77', '0.00', '250 mg', 'Theophylline'), 
('1889', 'Contine  CR   400 mg', '143-02124', 'Tablet', 'Aristopharma Limited', '2.98', '0.00', '400 mg', 'Theophylline'), 
('1890', 'Emep      20 mg', '143-0261-067', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '20 mg', 'Esomeprazole'), 
('1891', 'Evalin      5 mg', '143-0015-057', 'Tablet', 'Aristopharma Limited', '0.68', '0.00', '5 mg', 'Diazepam'), 
('1892', 'Fusidate   250 mg', '143-0159-23', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '250 mg', 'Sodium Fusidate'), 
('1893', 'Giran6   16 mg', '143-0222-22', 'Tablet', 'Aristopharma Limited', '11.00', '0.00', '16 mg', 'Candesartan Cilexetil'), 
('1894', 'Giran   8 mg', '143-0221-22', 'Tablet', 'Aristopharma Limited', '6.00', '0.00', '8 mg', 'Candesartan Cilexetil'), 
('1895', 'Glucomet   850 mg', '143-0111', 'Tablet', 'Aristopharma Limited', '6.00', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('1896', 'Glucomet  XR   500 mg', '143-0282', 'Tablet', 'Aristopharma Limited', '6.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('1897', 'Glucomet   500 mg', '143-0039', 'Tablet', 'Aristopharma Limited', '4.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('1898', 'Gluconor   1 mg', '143-0253', 'Tablet', 'Aristopharma Limited', '4.50', '0.00', '1 mg', 'Glimepiride'), 
('1899', 'Gluconor   2 mg', '143-0254', 'Tablet', 'Aristopharma Limited', '8.00', '0.00', '2 mg', 'Glimepiride'), 
('1900', 'Glucozid   80 mg', '143-0107', 'Tablet', 'Aristopharma Limited', '7.00', '0.00', '80 mg', 'Gliclazide'), 
('1901', 'Glucozon   15 mg', '143-0163', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '15 mg', 'Pioglitazone'), 
('1902', 'ISM      20 mg', '143-0077', 'Tablet', 'Aristopharma Limited', '1.20', '0.00', '20 mg', 'Isosorbide Mononitrate'), 
('1903', 'Lomeflox   400 mg', '143-0100-23', 'Tablet', 'Aristopharma Limited', '15.00', '0.00', '400 mg', 'Lomefloxacin'), 
('1904', 'TCL R     20 mg', '143-0155-061', 'Tablet', 'Aristopharma Limited', '18.00', '0.00', '20 mg', 'Atorvastatin'), 
('1905', 'Loradin   10 mg', '143-0125-21', 'Tablet', 'Aristopharma Limited', '3.00', '0.00', '10 mg', 'Loratadine'), 
('1906', 'Lumeran      150 mg', '143-00275', 'Tablet', 'Aristopharma Limited', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('1907', 'Lumeran0   300 mg', '143-00535', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '300 mg', 'Ranitidine'), 
('1908', 'Malarium   250 mg', '143-0239-24', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '250 mg', 'Mefloquine'), 
('1909', 'Mecol   .5 mg', '143-0262-78', 'Tablet', 'Aristopharma Limited', '4.00', '0.00', '.5 mg', 'Mecobalamin'), 
('1910', 'Mervan   100 mg', '143-0217-64', 'Tablet', 'Aristopharma Limited', '4.00', '0.00', '100 mg', 'Aceclofenac'), 
('1911', 'Metrodol   400 mg', '143-0220-27', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('1912', 'Musclex      50 mg', '143-0270-70', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '50 mg', 'Tolperisone Hydrochloride'), 
('1913', 'Nalix   500 mg', '143-0082-23', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '500 mg', 'Nalidixic Acid'), 
('1914', 'Napro   250 mg', '143-0056-64', 'Tablet', 'Aristopharma Limited', '4.20', '0.00', '250 mg', 'Naproxen'), 
('1915', 'Napro   500 mg', '143-0072-64', 'Tablet', 'Aristopharma Limited', '7.00', '0.00', '500 mg', 'Naproxen'), 
('1916', 'Nezox   400 mg', '143-0229-023', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '400 mg', 'Linezolid'), 
('1917', 'Nezox   600 mg', '143-0250-023', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '600 mg', 'Linezolid'), 
('1918', 'Nitrocard  SR .6   2.6 mg', '143-0274', 'Tablet', 'Aristopharma Limited', '4.00', '0.00', '2.6 mg', 'Glyceryl Trinitrate'), 
('1919', 'Norp   2 mg', '143-0257-22', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '2 mg', 'Lacidipine'), 
('1920', 'Norp   4 mg', '143-0258-22', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '4 mg', 'Lacidipine'), 
('1921', 'Notens   3 mg', '143-02197', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '3 mg', 'Bromazepam'), 
('1922', 'Omniflox      200 mg', '143-0110-23', 'Tablet', 'Aristopharma Limited', '18.00', '0.00', '200 mg', 'Sparfloxacin'), 
('1923', 'Optimox   400 mg', '143-0247-23', 'Tablet', 'Aristopharma Limited', '40.00', '0.00', '400 mg', 'Moxifloxacin'), 
('1924', 'Oradol   10 mg', '143-0120-064', 'Tablet', 'Aristopharma Limited', '10.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('1925', 'Osartan      50 mg', '143-0143-022', 'Tablet', 'Aristopharma Limited', '8.00', '0.00', '50 mg', 'Losartan Potassium'), 
('1926', 'Ovel   500 mg', '143-0260-23', 'Tablet', 'Aristopharma Limited', '15.00', '0.00', '500 mg', 'Levofloxacin'), 
('1927', 'Pinor   25 mg', '143-02234', 'Tablet', 'Aristopharma Limited', '4.00', '0.00', '25 mg', 'Imipramine Hydrochloride'), 
('1928', 'Proton P     40 mg', '143-0151-67', 'Tablet', 'Aristopharma Limited', '7.00', '0.00', '40 mg', 'Pantoprazole'), 
('1929', 'Proton P     20 mg', '143-0183-67', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '20 mg', 'Pantoprazole'), 
('1930', 'Rehaf   5 mg', '143-0249-21', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '5 mg', 'Levocetirizine Hydrochloride'), 
('1931', 'Rhinil   10 mg', '143-0096-21', 'Tablet', 'Aristopharma Limited', '3.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('1932', 'Soval      200 mg', '143-02266', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '200 mg', 'Sodium Valproate'), 
('1933', 'Stafen   1 mg', '143-0051-21', 'Tablet', 'Aristopharma Limited', '2.00', '0.00', '1 mg', 'Ketotifen'), 
('1934', 'TCL   10 mg', '143-0154-061', 'Tablet', 'Aristopharma Limited', '10.00', '0.00', '10 mg', 'Atorvastatin'), 
('1935', 'Xpa   500 mg', '143-0016-006', 'Tablet', 'Aristopharma Limited', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('1936', 'Tenocard      50 mg', '143-0040-22', 'Tablet', 'Aristopharma Limited', '0.75', '0.00', '50 mg', 'Atenolol'), 
('1937', 'Terbifin   250 mg', '143-0149', 'Tablet', 'Aristopharma Limited', '50.00', '0.00', '250 mg', 'Terbinafine'), 
('1938', 'Thiobion      100 mg', '143-0065-78', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '100 mg', 'Thiamine Hydrochloride'), 
('1939', 'VC   250 mg', '143-0068-78', 'Tablet', 'Aristopharma Limited', '1.30', '0.00', '250 mg', 'Vitamin C'), 
('1940', 'Vinton      5 mg', '143-0074-36', 'Tablet', 'Aristopharma Limited', '4.00', '0.00', '5 mg', 'Vinpocetine'), 
('1941', 'Zincin   15 mg', '143-0052-21', 'Tablet', 'Aristopharma Limited', '1.00', '0.00', '15 mg', 'Cinnarizine'), 
('1942', 'Zofen   500 mcg', '143-01217', 'Tablet', 'Aristopharma Limited', '3.10', '0.00', '500 mcg', 'Pizotifen'), 
('1943', 'Zofen  TS   1.5 mg', '143-01367', 'Tablet', 'Aristopharma Limited', '7.20', '0.00', '1.5 mg', 'Pizotifen'), 
('1944', 'Axim   500 mg', '143-0296-23', 'Tablet', 'Aristopharma Limited', '45.00', '0.00', '500 mg', 'Cefuroxime'), 
('1945', 'Oralzin      20 mg', '143-0287-62', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '20 mg', 'Zinc'), 
('1946', 'Veralgin   50 mg', '143-03071', 'Tablet', 'Aristopharma Limited', '6.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('1947', 'Osartan      25 mg', '143-0334-022', 'Tablet', 'Aristopharma Limited', '4.50', '0.00', '25 mg', 'Losartan Potassium'), 
('1948', 'Athorel      75 mg', '143-0337-26', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '75 mg', 'Clopidogrel'), 
('1949', 'Ivactin   3 mg', '143-0325-8', 'Tablet', 'Aristopharma Limited', '6.00', '0.00', '3 mg', 'Ivermectin'), 
('1950', 'Sleepil   1 mg', '143-0344-057', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '1 mg', 'Eszopiclone'), 
('1951', 'Sleepil   2 mg', '143-0345-057', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '2 mg', 'Eszopiclone'), 
('1952', 'Nitoxin   500 mg', '143-0336-27', 'Tablet', 'Aristopharma Limited', '10.00', '0.00', '500 mg', 'Nitazoxanide'), 
('1953', 'Metacard  MR   35 mg', '143-0338', 'Tablet', 'Aristopharma Limited', '6.00', '0.00', '35 mg', 'Trimetazidine Dihydrochloride'), 
('1954', 'Asmolex L   1 mg', '143-03414', 'Tablet', 'Aristopharma Limited', '0.80', '0.00', '1 mg', 'Levosalbutamol'), 
('1955', 'Asmolex L   2 mg', '143-03424', 'Tablet', 'Aristopharma Limited', '1.50', '0.00', '2 mg', 'Levosalbutamol'), 
('1956', 'Az   250 mg', '143-0371-23', 'Tablet', 'Aristopharma Limited', '25.00', '0.00', '250 mg', 'Azithromycin'), 
('1957', 'Az   500 mg', '143-0372-23', 'Tablet', 'Aristopharma Limited', '35.00', '0.00', '500 mg', 'Azithromycin'), 
('1958', 'Nimodol  SR    600 mg', '143-0379-64', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '600 mg', 'Etodolac'), 
('1959', 'Reumazin   500 mg', '143-0388-64', 'Tablet', 'Aristopharma Limited', '5.20', '0.00', '500 mg', 'Sulfasalazine'), 
('1960', 'Baclovan   10 mg', '143-0389-70', 'Tablet', 'Aristopharma Limited', '8.00', '0.00', '10 mg', 'Baclofen'), 
('1961', 'Vazlepe   500 mg', '143-0390-64', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '500 mg', 'Glucosamine'), 
('1962', 'Aprocin0   750 mg', '143-0392-23', 'Tablet', 'Aristopharma Limited', '18.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('1963', 'Ramilok   2.5 mg', '143-0395-022', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '2.5 mg', 'Ramipril'), 
('1964', 'Ramilok   5 mg', '143-0396-022', 'Tablet', 'Aristopharma Limited', '8.00', '0.00', '5 mg', 'Ramipril'), 
('1965', 'Xicotil F/C   20 mg', '143-0397-64', 'Tablet', 'Aristopharma Limited', '8.00', '0.00', '20 mg', 'Tenoxicam'), 
('1966', 'Xelix SR   1.5 mg', '143-03982', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '1.5 mg', 'Indapamide'), 
('1967', 'Ancor F/C   2.5 mg', '143-0399-22', 'Tablet', 'Aristopharma Limited', '6.00', '0.00', '2.5 mg', 'Bisoprolol Hemifumarate'), 
('1968', 'Ancor F/C   5 mg', '143-0400-22', 'Tablet', 'Aristopharma Limited', '10.00', '0.00', '5 mg', 'Bisoprolol Hemifumarate'), 
('1969', 'Afix   200 mg', '143-0401-23', 'Tablet', 'Aristopharma Limited', '35.00', '0.00', '200 mg', 'Cefixime'), 
('1970', 'Afix0   400 mg', '143-0402-23', 'Tablet', 'Aristopharma Limited', '50.00', '0.00', '400 mg', 'Cefixime'), 
('1971', 'Rabe   20 mg', '143-0405-67', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('1972', 'Epalres F/C   50 mg', '143-0410-76', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '50 mg', 'Epalrestat'), 
('1973', 'Axofen   60 mg', '143-0411-21', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '60 mg', 'Fexofenadine Hydrochloride'), 
('1974', 'Axofen   120 mg', '143-0412-21', 'Tablet', 'Aristopharma Limited', '7.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('1975', 'Axofen80   180 mg', '143-0413-21', 'Tablet', 'Aristopharma Limited', '9.00', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('1976', 'Ruvastin   5 mg', '143-0417-61', 'Tablet', 'Aristopharma Limited', '10.00', '0.00', '5 mg', 'Rosuvastatin'), 
('1977', 'Ruvastin   10 mg', '143-0418-61', 'Tablet', 'Aristopharma Limited', '20.00', '0.00', '10 mg', 'Rosuvastatin'), 
('1978', 'Montril   4 mg', '143-0419-044', 'Tablet', 'Aristopharma Limited', '7.00', '0.00', '4 mg', 'Montelukast'), 
('1979', 'Montril   5 mg', '143-0420-044', 'Tablet', 'Aristopharma Limited', '8.00', '0.00', '5 mg', 'Montelukast'), 
('1980', 'Montril   10 mg', '143-0421-044', 'Tablet', 'Aristopharma Limited', '15.00', '0.00', '10 mg', 'Montelukast'), 
('1981', 'Etovan   60 mg', '143-0428-64', 'Tablet', 'Aristopharma Limited', '7.00', '0.00', '60 mg', 'Etoricoxib'), 
('1982', 'Etovan   90 mg', '143-0429-64', 'Tablet', 'Aristopharma Limited', '12.00', '0.00', '90 mg', 'Etoricoxib'), 
('1983', 'Etovan   120 mg', '143-0430-64', 'Tablet', 'Aristopharma Limited', '14.00', '0.00', '120 mg', 'Etoricoxib'), 
('1984', 'Pilogen   5 mg', '143-0431-37', 'Tablet', 'Aristopharma Limited', '10.00', '0.00', '5 mg', 'Pilocarpine Hydrochloride'), 
('1985', 'Xolam.5 XR   .5 mg', '143-04427', 'Tablet', 'Aristopharma Limited', '2.00', '0.00', '.5 mg', 'Alprazolam'), 
('1986', 'Ancor   10 mg', '143-0444-22', 'Tablet', 'Aristopharma Limited', '16.00', '0.00', '10 mg', 'Bisoprolol Hemifumarate'), 
('1987', 'Tecavir.5   .5 mg', '143-0447-32', 'Tablet', 'Aristopharma Limited', '48.00', '0.00', '.5 mg', 'Entecavir'), 
('1988', 'Tecavir   1 mg', '143-0448-32', 'Tablet', 'Aristopharma Limited', '90.00', '0.00', '1 mg', 'Entecavir'), 
('1989', 'Ivacard   5 mg', '143-0449', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '5 mg', 'Ivabradine'), 
('1990', 'Ivacard   7.5 mg', '143-0450', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '7.5 mg', 'Ivabradine'), 
('1991', 'Dormax   7.5 mg', '143-0455-057', 'Tablet', 'Aristopharma Limited', '10.00', '0.00', '7.5 mg', 'Midazolam'), 
('1992', 'Betacard   50 mg', '143-0467-22', 'Tablet', 'Aristopharma Limited', '2.00', '0.00', '50 mg', 'Metoprolol Tartrate'), 
('1993', 'Cortisol   5 mg', '143-0494-72', 'Tablet', 'Aristopharma Limited', '1.70', '0.00', '5 mg', 'Prednisolone'), 
('1994', 'Cortisol   10 mg', '143-0495-72', 'Tablet', 'Aristopharma Limited', '3.20', '0.00', '10 mg', 'Prednisolone'), 
('1995', 'Cortisol   20 mg', '143-0496-72', 'Tablet', 'Aristopharma Limited', '6.25', '0.00', '20 mg', 'Prednisolone'), 
('1996', 'Piramax   800 mg', '143-0504', 'Tablet', 'Aristopharma Limited', '6.00', '0.00', '800 mg', 'Piracetam'), 
('1997', 'Contine0 CR   200 mg', '143-05084', 'Tablet', 'Aristopharma Limited', '1.60', '0.00', '200 mg', 'Theophylline'), 
('1998', 'Contine CR   300 mg', '143-05094', 'Tablet', 'Aristopharma Limited', '2.35', '0.00', '300 mg', 'Theophylline'), 
('1999', 'Solifen   5 mg', '143-05121', 'Tablet', 'Aristopharma Limited', '20.00', '0.00', '5 mg', 'Solifenacin Succinate'), 
('2000', 'Febux   40 mg', '143-0513-76', 'Tablet', 'Aristopharma Limited', '12.00', '0.00', '40 mg', 'Febuxostat'), 
('2001', 'Febux   80 mg', '143-0514-76', 'Tablet', 'Aristopharma Limited', '22.00', '0.00', '80 mg', 'Febuxostat'), 
('2002', 'Arotril   1 mg', '143-05226', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '1 mg', 'Clonazepam'), 
('2003', 'Rupa   10 mg', '143-0525-21', 'Tablet', 'Aristopharma Limited', '10.00', '0.00', '10 mg', 'Rupatadine'), 
('2004', 'Pitavas   2 mg', '143-0526-61', 'Tablet', 'Aristopharma Limited', '10.00', '0.00', '2 mg', 'Pitavastatin'), 
('2005', 'Prasucard   5 mg', '143-0535-26', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '5 mg', 'Prasugrel'), 
('2006', 'Prasucard   10 mg', '143-0536-26', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '10 mg', 'Prasugrel'), 
('2007', 'Gluvan   50 mg', '143-0537', 'Tablet', 'Aristopharma Limited', '20.00', '0.00', '50 mg', 'Vildagliptin'), 
('2008', 'Lodipin   10 mg', '143-0539-022', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '10 mg', 'Amlodipine'), 
('2009', 'Tenvira   300 mg', '143-0557-32', 'Tablet', 'Aristopharma Limited', '85.00', '0.00', '300 mg', 'Tenofovir Disoproxil Fumarate'), 
('2010', 'Hepaximin   200 mg', '143-0560-23', 'Tablet', 'Aristopharma Limited', '20.00', '0.00', '200 mg', 'Rifaximin'), 
('2011', 'Hepaximin50   550 mg', '143-0561-23', 'Tablet', 'Aristopharma Limited', '45.00', '0.00', '550 mg', 'Rifaximin'), 
('2012', 'V-Gra   100 mg', '143-0570-043', 'Tablet', 'Aristopharma Limited', '50.00', '0.00', '100 mg', 'Sildenafil'), 
('2013', 'V-Gra   50 mg', '143-0571-043', 'Tablet', 'Aristopharma Limited', '30.00', '0.00', '50 mg', 'Sildenafil'), 
('2014', 'V-Gra   25 mg', '143-0572-043', 'Tablet', 'Aristopharma Limited', '16.00', '0.00', '25 mg', 'Sildenafil'), 
('2015', 'Pawar   20 mg', '143-0573-043', 'Tablet', 'Aristopharma Limited', '60.00', '0.00', '20 mg', 'Tadalafil'), 
('2016', 'Pawar   10 mg', '143-0574-043', 'Tablet', 'Aristopharma Limited', '35.00', '0.00', '10 mg', 'Tadalafil'), 
('2017', 'Pawar   5 mg', '143-0575-043', 'Tablet', 'Aristopharma Limited', '18.00', '0.00', '5 mg', 'Tadalafil'), 
('2018', 'Arolast   500 mcg', '143-05764', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '500 mcg', 'Roflumilast'), 
('2019', 'Linaglip   5 mg', '143-0592-015', 'Tablet', 'Aristopharma Limited', '20.00', '0.00', '5 mg', 'Linagliptin'), 
('2020', 'Ibandron   150 mg', '143-0593-048', 'Tablet', 'Aristopharma Limited', '1200.00', '0.00', '150 mg', 'Ibandronic Acid'), 
('2021', 'Apulset   4 mg', '143-05958', 'Tablet', 'Aristopharma Limited', '6.00', '0.00', '4 mg', 'Ondansetron'), 
('2022', 'Apulset 8   8 mg', '143-05968', 'Tablet', 'Aristopharma Limited', '10.00', '0.00', '8 mg', 'Ondansetron'), 
('2023', 'Aromatin   1 mg', '143-0607', 'Tablet', 'Aristopharma Limited', '50.00', '0.00', '1 mg', 'Anastrozol'), 
('2024', 'Thormon   50 mcg', '143-0610-74', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '50 mcg', 'Levothyroxine Sodium'), 
('2025', 'Lorenzo   2.5 mg', '143-0611', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '2.5 mg', 'Letrozole'), 
('2026', 'Docopa   400 mg', '143-06124', 'Tablet', 'Aristopharma Limited', '8.00', '0.00', '400 mg', 'Doxophylline'), 
('2027', 'Flacort   6 mg', '143-0621-72', 'Tablet', 'Aristopharma Limited', '8.00', '0.00', '6 mg', 'Deflazacort'), 
('2028', 'Presulock   20 mg', '143-0623-22', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '20 mg', 'Olmesartan Medoxomil'), 
('2029', 'Docopa   200 mg', '143-06324', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '200 mg', 'Doxophylline'), 
('2030', 'Sofo-C   400 mg', '143-0634-32', 'Tablet', 'Aristopharma Limited', '600.00', '0.00', '400 mg', 'Sofosbuvir'), 
('2031', 'Maxineb   2.5 mg', '143-0637-22', 'Tablet', 'Aristopharma Limited', '7.00', '0.00', '2.5 mg', 'Nebivolol'), 
('2032', 'Maxineb   5 mg', '143-0638-22', 'Tablet', 'Aristopharma Limited', '10.00', '0.00', '5 mg', 'Nebivolol'), 
('2033', 'Azistar   40 mg', '143-0639-22', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '40 mg', 'Azilsartan Medoxomil'), 
('2034', 'Azistar   80 mg', '143-0640-22', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '80 mg', 'Azilsartan Medoxomil'), 
('2035', 'Ticacard   90 mg', '143-0641-26', 'Tablet', 'Aristopharma Limited', '75.00', '0.00', '90 mg', 'Ticagrelor'), 
('2036', 'Beclovan   5 mg', '143-0644-70', 'Tablet', 'Aristopharma Limited', '5.50', '0.00', '5 mg', 'Baclofen'), 
('2037', 'Sonexa   4 mg', '143-0651-72', 'Tablet', 'Aristopharma Limited', '11.00', '0.00', '4 mg', 'Dexamethasone'), 
('2038', 'Apetiz   160 mg', '143-06526', 'Tablet', 'Aristopharma Limited', '90.00', '0.00', '160 mg', 'Megestrol Acetate'), 
('2039', 'Acyvir   200 mg', '143-0659-32', 'Tablet', 'Aristopharma Limited', '14.00', '0.00', '200 mg', 'Acyclovir'), 
('2040', 'Acyvir0   400 mg', '143-0660-32', 'Tablet', 'Aristopharma Limited', '22.00', '0.00', '400 mg', 'Acyclovir'), 
('2041', 'TCL-R   40 mg', '143-0665-061', 'Tablet', 'Aristopharma Limited', '24.00', '0.00', '40 mg', 'Atorvastatin'), 
('2042', 'Axon  IM   1 gm', '143-0190-23', 'IM Injection', 'Aristopharma Limited', '0.00', '0.00', '1 gm', 'Ceftriaxone'), 
('2043', 'Axon  IM  mg   250 mg', '143-0186-23', 'IM Injection', 'Aristopharma Limited', '0.00', '0.00', '250 mg', 'Ceftriaxone'), 
('2044', 'Axon  IM   500 mg', '143-0188-23', 'IM Injection', 'Aristopharma Limited', '0.00', '0.00', '500 mg', 'Ceftriaxone'), 
('2045', 'Axon  IV   1 gm', '143-0191-23', 'IV Injection', 'Aristopharma Limited', '0.00', '0.00', '1 gm', 'Ceftriaxone'), 
('2046', 'Axon  IV  mg   250 mg', '143-0187-23', 'IV Injection', 'Aristopharma Limited', '0.00', '0.00', '250 mg', 'Ceftriaxone'), 
('2047', 'Axon  IV   500 mg', '143-0189-23', 'IV Injection', 'Aristopharma Limited', '0.00', '0.00', '500 mg', 'Ceftriaxone'), 
('2048', 'Axon  IV  gm   2 gm', '143-0297-23', 'IV Injection', 'Aristopharma Limited', '0.00', '0.00', '2 gm', 'Ceftriaxone'), 
('2049', 'Afrin .05%   .05 %', '143-02252', 'Nasal Drops', 'Aristopharma Limited', '45.00', '0.00', '.05 %', 'Oxymetazoline Hydrochloride'), 
('2050', 'Afrin .025%   .025 %', '143-02862', 'Nasal Drops', 'Aristopharma Limited', '40.00', '0.00', '.025 %', 'Oxymetazoline Hydrochloride'), 
('2051', 'Afm   .1 %', '143-01672', 'Eye Drops', 'Aristopharma Limited', '0.00', '0.00', '.1 %', 'Fluorometholone'), 
('2052', 'Aristomol%   .25 %', '143-01712', 'Eye Drops', 'Aristopharma Limited', '55.00', '0.00', '.25 %', 'Timolol Maleate'), 
('2053', 'Aristomol%   .5 %', '143-01722', 'Eye Drops', 'Aristopharma Limited', '70.00', '0.00', '.5 %', 'Timolol Maleate'), 
('2054', 'Stafen .025%   .025 %', '143-03022', 'Eye Drops', 'Aristopharma Limited', '100.00', '0.00', '.025 %', 'Ketotifen'), 
('2055', 'Beclocort HFA   100 mcg', '143-04784', 'Inhalation Solution', 'Aristopharma Limited', '245.00', '0.00', '100 mcg', 'Beclomethasone Dipropionate'), 
('2056', 'Laczyme   300 mg', '143-0619-', 'Chewable Tablet', 'Aristopharma Limited', '15.00', '0.00', '300 mg', 'Lactase'), 
('2057', 'Glucomet  XR   750 mg', '143-0263', 'Xr Tablet', 'Aristopharma Limited', '8.00', '0.00', '750 mg', 'Metformin Hydrochloride'), 
('2058', 'Xolam XR   1 mg', '143-04437', 'Xr Tablet', 'Aristopharma Limited', '4.00', '0.00', '1 mg', 'Alprazolam'), 
('2059', 'Xpa XR   665 mg', '143-0446-6', 'Xr Tablet', 'Aristopharma Limited', '1.50', '0.00', '665 mg', 'Paracetamol'), 
('2060', 'Betacard XR   50 mg', '143-0468-22', 'Xr Tablet', 'Aristopharma Limited', '0.00', '0.00', '50 mg', 'Metoprolol Tartrate'), 
('2061', 'Mervan SR   200 mg', '143-0609-64', 'Er Tablet', 'Aristopharma Limited', '0.00', '0.00', '200 mg', 'Aceclofenac'), 
('2062', 'Omep      20 mg', '143-0324', 'Sr Tablet', 'Aristopharma Limited', '0.00', '0.00', '20 mg', 'Omeprazole'), 
('2063', 'Mesagut   400 mg', '143-0650-64', 'Dr Tablet', 'Aristopharma Limited', '7.60', '0.00', '400 mg', 'Mesalamine'), 
('2064', 'Afix   200 mg', '378-0003-23', 'Capsule', 'Aristopharma Limited, Gazipur', '35.00', '0.00', '200 mg', 'Cefixime'), 
('2065', 'Afix0   400 mg', '378-0004-23', 'Capsule', 'Aristopharma Limited, Gazipur', '50.00', '0.00', '400 mg', 'Cefixime'), 
('2066', 'Aristocef   250 mg', '378-0007-23', 'Capsule', 'Aristopharma Limited, Gazipur', '6.50', '0.00', '250 mg', 'Cephalexin'), 
('2067', 'Aristocef0   500 mg', '378-0008-23', 'Capsule', 'Aristopharma Limited, Gazipur', '15.00', '0.00', '500 mg', 'Cephalexin'), 
('2068', 'Extracef   250 mg', '378-0013-023', 'Capsule', 'Aristopharma Limited, Gazipur', '0.00', '0.00', '250 mg', 'Cephradine'), 
('2069', 'Extracef0   500 mg', '378-0014-23', 'Capsule', 'Aristopharma Limited, Gazipur', '0.00', '0.00', '500 mg', 'Cephradine'), 
('2070', 'Taxetil   100 mg', '378-0042-23', 'Capsule', 'Aristopharma Limited, Gazipur', '22.00', '0.00', '100 mg', 'Cefpodoxime'), 
('2071', 'Taxetil   200 mg', '378-0043-23', 'Capsule', 'Aristopharma Limited, Gazipur', '40.00', '0.00', '200 mg', 'Cefpodoxime'), 
('2072', 'Orbuten   400 mg', '378-0052-023', 'Capsule', 'Aristopharma Limited, Gazipur', '0.00', '0.00', '400 mg', 'Ceftibuten'), 
('2073', 'Afix   200 mg', '378-0001-23', 'Tablet', 'Aristopharma Limited, Gazipur', '35.00', '0.00', '200 mg', 'Cefixime'), 
('2074', 'Afix0   400 mg', '378-0002-23', 'Tablet', 'Aristopharma Limited, Gazipur', '50.00', '0.00', '400 mg', 'Cefixime'), 
('2075', 'Axim25   125 mg', '378-0021-23', 'Tablet', 'Aristopharma Limited, Gazipur', '15.00', '0.00', '125 mg', 'Cefuroxime'), 
('2076', 'Axim   250 mg', '378-0022-23', 'Tablet', 'Aristopharma Limited, Gazipur', '25.00', '0.00', '250 mg', 'Cefuroxime'), 
('2077', 'Axim0   500 mg', '378-0023-23', 'Tablet', 'Aristopharma Limited, Gazipur', '45.00', '0.00', '500 mg', 'Cefuroxime'), 
('2078', 'Aprozil   500 mg', '378-0028-23', 'Tablet', 'Aristopharma Limited, Gazipur', '0.00', '0.00', '500 mg', 'Cefprozil'), 
('2079', 'Axon IM   250 mg', '378-0031-23', 'IM Injection', 'Aristopharma Limited, Gazipur', '100.00', '0.00', '250 mg', 'Ceftriaxone'), 
('2080', 'Axon0 IM   500 mg', '378-0033-23', 'IM Injection', 'Aristopharma Limited, Gazipur', '130.00', '0.00', '500 mg', 'Ceftriaxone'), 
('2081', 'Axon gm IM   1 gm', '378-0035-23', 'IM Injection', 'Aristopharma Limited, Gazipur', '200.00', '0.00', '1 gm', 'Ceftriaxone'), 
('2082', 'Axon IV   250 mg', '378-0030-23', 'IV Injection', 'Aristopharma Limited, Gazipur', '100.00', '0.00', '250 mg', 'Ceftriaxone'), 
('2083', 'Axon0 IV   500 mg', '378-0032-23', 'IV Injection', 'Aristopharma Limited, Gazipur', '130.00', '0.00', '500 mg', 'Ceftriaxone'), 
('2084', 'Axon gm IV   2 gm', '378-0036-23', 'IV Injection', 'Aristopharma Limited, Gazipur', '300.00', '0.00', '2 gm', 'Ceftriaxone'), 
('2085', 'Ceftazim   250 mg', '378-001-23', 'IV/IM Injection', 'Aristopharma Limited, Gazipur', '0.00', '0.00', '250 mg', 'Ceftriaxone'), 
('2086', 'Afixime      200 mg', '023-0095-23', 'Capsule', 'Asiatic Laboratories Ltd.', '30.00', '0.00', '200 mg', 'Cefixime'), 
('2087', 'Asidox      100 mg', '023-0052-23', 'Capsule', 'Asiatic Laboratories Ltd.', '2.00', '0.00', '100 mg', 'Doxycycline'), 
('2088', 'Clox F     250 mg', '023-0064-23', 'Capsule', 'Asiatic Laboratories Ltd.', '5.00', '0.00', '250 mg', 'Flucloxacillin'), 
('2089', 'Clox F    500 mg', '023-0069-23', 'Capsule', 'Asiatic Laboratories Ltd.', '10.00', '0.00', '500 mg', 'Flucloxacillin'), 
('2090', 'Indocap   25 mg', '023-0047-64', 'Capsule', 'Asiatic Laboratories Ltd.', '0.60', '0.00', '25 mg', 'Indomethacin'), 
('2091', 'Licef   500 mg', '023-0081-23', 'Capsule', 'Asiatic Laboratories Ltd.', '13.96', '0.00', '500 mg', 'Cefadroxil'), 
('2092', 'Locopain  TR    100 mg', '023-0057-64', 'Capsule', 'Asiatic Laboratories Ltd.', '3.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('2093', 'Loxyl   500 mg', '023-0055-23', 'Capsule', 'Asiatic Laboratories Ltd.', '6.76', '0.00', '500 mg', 'Amoxicillin'), 
('2094', 'Loxyl   250 mg', '023-0053-023', 'Capsule', 'Asiatic Laboratories Ltd.', '3.61', '0.00', '250 mg', 'Amoxicillin'), 
('2095', 'O      20 mg', '023-0084-67', 'Capsule', 'Asiatic Laboratories Ltd.', '5.00', '0.00', '20 mg', 'Omeprazole'), 
('2096', 'O -      40 mg', '023-0085-67', 'Capsule', 'Asiatic Laboratories Ltd.', '7.00', '0.00', '40 mg', 'Omeprazole'), 
('2097', 'Tetramycin   250 mg', '023-0037-23', 'Capsule', 'Asiatic Laboratories Ltd.', '1.30', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('2098', 'Vecef   500 mg', '023-0077-23', 'Capsule', 'Asiatic Laboratories Ltd.', '12.50', '0.00', '500 mg', 'Cephradine'), 
('2099', 'Cefipod   100 mg', '023-0198-23', 'Capsule', 'Asiatic Laboratories Ltd.', '14.00', '0.00', '100 mg', 'Cefpodoxime'), 
('2100', 'Cefipod   200 mg', '023-0199-23', 'Capsule', 'Asiatic Laboratories Ltd.', '25.00', '0.00', '200 mg', 'Cefpodoxime'), 
('2101', 'Afixim0   400 mg', '023-0196-23', 'Capsule', 'Asiatic Laboratories Ltd.', '50.00', '0.00', '400 mg', 'Cefixime'), 
('2102', 'Dermicon   50 mg', '023-0236', 'Capsule', 'Asiatic Laboratories Ltd.', '8.00', '0.00', '50 mg', 'Fluconazole'), 
('2103', 'Dermicon   150 mg', '023-0237', 'Capsule', 'Asiatic Laboratories Ltd.', '22.00', '0.00', '150 mg', 'Fluconazole'), 
('2104', 'Asibalin   50 mg', '023-0280-046', 'Capsule', 'Asiatic Laboratories Ltd.', '12.00', '0.00', '50 mg', 'Pregabalin'), 
('2105', 'Asibalin   75 mg', '023-0281-046', 'Capsule', 'Asiatic Laboratories Ltd.', '16.00', '0.00', '75 mg', 'Pregabalin'), 
('2106', 'Ceftiten0   400 mg', '023-0292-23', 'Capsule', 'Asiatic Laboratories Ltd.', '120.00', '0.00', '400 mg', 'Ceftibuten'), 
('2107', 'Asiclin   150 mg', '023-0241-23', 'Capsule', 'Asiatic Laboratories Ltd.', '8.00', '0.00', '150 mg', 'Clindamycin'), 
('2108', 'Asiclin   300 mg', '023-0242-23', 'Capsule', 'Asiatic Laboratories Ltd.', '15.00', '0.00', '300 mg', 'Clindamycin'), 
('2109', 'Asibalin25   25 mg', '023-0313-046', 'Capsule', 'Asiatic Laboratories Ltd.', '0.00', '0.00', '25 mg', 'Pregabalin'), 
('2110', 'Asilac   68 %', '023-0107-60', 'Oral Solution', 'Asiatic Laboratories Ltd.', '120.00', '0.00', '68 %', 'Lactulose'), 
('2111', 'Anaflam   400 mg', '023-0056-64', 'Tablet', 'Asiatic Laboratories Ltd.', '1.43', '0.00', '400 mg', 'Ibuprofen'), 
('2112', 'Aceptin-R   150 mg', '023-00595', 'Tablet', 'Asiatic Laboratories Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('2113', 'Asipan      20 mg', '023-01001', 'Tablet', 'Asiatic Laboratories Ltd.', '3.00', '0.00', '20 mg', 'Hyoscine Butyl Bromide'), 
('2114', 'Asitrol   10 mg', '023-0058-21', 'Tablet', 'Asiatic Laboratories Ltd.', '2.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('2115', 'Asul   4 mg', '023-00984', 'Tablet', 'Asiatic Laboratories Ltd.', '0.34', '0.00', '4 mg', 'Salbutamol'), 
('2116', 'Calfor   1250 mg', '023-0068-62', 'Tablet', 'Asiatic Laboratories Ltd.', '2.50', '0.00', '1250 mg', 'Calcium Carbonate'), 
('2117', 'Ceroxime   125 mg', '023-0102-23', 'Tablet', 'Asiatic Laboratories Ltd.', '15.00', '0.00', '125 mg', 'Cefuroxime'), 
('2118', 'Ceroxime   250 mg', '023-0103-23', 'Tablet', 'Asiatic Laboratories Ltd.', '25.00', '0.00', '250 mg', 'Cefuroxime'), 
('2119', 'Cip   500 mg', '023-0062-23', 'Tablet', 'Asiatic Laboratories Ltd.', '14.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('2120', 'Cip   750 mg', '023-0063-23', 'Tablet', 'Asiatic Laboratories Ltd.', '18.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('2121', 'Clarex   5 mg', '023-0105-21', 'Tablet', 'Asiatic Laboratories Ltd.', '2.50', '0.00', '5 mg', 'Desloratadine'), 
('2122', 'Eso      20 mg', '023-0110-067', 'Tablet', 'Asiatic Laboratories Ltd.', '5.00', '0.00', '20 mg', 'Esomeprazole'), 
('2123', 'Lerex   5 mg', '023-0106-21', 'Tablet', 'Asiatic Laboratories Ltd.', '2.00', '0.00', '5 mg', 'Levocetirizine Hydrochloride'), 
('2124', 'Liam   10 mg', '023-0109-044', 'Tablet', 'Asiatic Laboratories Ltd.', '10.00', '0.00', '10 mg', 'Montelukast'), 
('2125', 'Locopain      50 mg', '023-0060-64', 'Tablet', 'Asiatic Laboratories Ltd.', '0.40', '0.00', '50 mg', 'Diclofenac Sodium'), 
('2126', 'Macas   500 mg', '023-0087-23', 'Tablet', 'Asiatic Laboratories Ltd.', '8.12', '0.00', '500 mg', 'Erythromycin'), 
('2127', 'P -      20 mg', '023-0093-67', 'Tablet', 'Asiatic Laboratories Ltd.', '4.00', '0.00', '20 mg', 'Pantoprazole'), 
('2128', 'P -      40 mg', '023-0094-67', 'Tablet', 'Asiatic Laboratories Ltd.', '6.00', '0.00', '40 mg', 'Pantoprazole'), 
('2129', 'Roxacine      150 mg', '023-0071-23', 'Tablet', 'Asiatic Laboratories Ltd.', '7.00', '0.00', '150 mg', 'Roxithromycin'), 
('2130', 'Roxacine0   300 mg', '023-0070-23', 'Tablet', 'Asiatic Laboratories Ltd.', '14.00', '0.00', '300 mg', 'Roxithromycin'), 
('2131', 'Starzyl      200 mg', '023-0033-27', 'Tablet', 'Asiatic Laboratories Ltd.', '0.66', '0.00', '200 mg', 'Metronidazole'), 
('2132', 'Strazyl   400 mg', '023-0048-27', 'Tablet', 'Asiatic Laboratories Ltd.', '1.02', '0.00', '400 mg', 'Metronidazole'), 
('2133', 'Tempol   500 mg', '023-0016-006', 'Tablet', 'Asiatic Laboratories Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('2134', 'Ulsec     1 gm', '023-0076-7', 'Tablet', 'Asiatic Laboratories Ltd.', '4.00', '0.00', '1 gm', 'Sucralfate'), 
('2135', 'V Cillin      200 mg', '023-0117-23', 'Tablet', 'Asiatic Laboratories Ltd.', '12.00', '0.00', '200 mg', 'Pivmecillinam'), 
('2136', 'Asiben   400 mg', '023-0119-008', 'Tablet', 'Asiatic Laboratories Ltd.', '3.80', '0.00', '400 mg', 'Albendazole'), 
('2137', 'Asaf      200 mg', '023-0075-23', 'Tablet', 'Asiatic Laboratories Ltd.', '18.75', '0.00', '200 mg', 'Sparfloxacin'), 
('2138', 'Atidon   10 mg', '023-00898', 'Tablet', 'Asiatic Laboratories Ltd.', '2.00', '0.00', '10 mg', 'Domperidone'), 
('2139', 'Diout   850 mg', '023-0092', 'Tablet', 'Asiatic Laboratories Ltd.', '2.25', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('2140', 'Ena   100 mg', '023-0090-64', 'Tablet', 'Asiatic Laboratories Ltd.', '3.00', '0.00', '100 mg', 'Aceclofenac'), 
('2141', 'Gle   80 mg', '023-0091', 'Tablet', 'Asiatic Laboratories Ltd.', '11.00', '0.00', '80 mg', 'Gliclazide'), 
('2142', 'Asilee   500 mg', '023-0072-23', 'Tablet', 'Asiatic Laboratories Ltd.', '15.00', '0.00', '500 mg', 'Levofloxacin'), 
('2143', 'Alpam   .25 mg', '023-01357', 'Tablet', 'Asiatic Laboratories Ltd.', '1.00', '0.00', '.25 mg', 'Alprazolam'), 
('2144', 'Alpam   .5 mg', '023-01367', 'Tablet', 'Asiatic Laboratories Ltd.', '2.00', '0.00', '.5 mg', 'Alprazolam'), 
('2145', 'Lexnil   3 mg', '023-01377', 'Tablet', 'Asiatic Laboratories Ltd.', '4.00', '0.00', '3 mg', 'Bromazepam'), 
('2146', 'Asizith   250 mg', '023-0160-23', 'Tablet', 'Asiatic Laboratories Ltd.', '20.00', '0.00', '250 mg', 'Azithromycin'), 
('2147', 'Asizith   500 mg', '023-0161-23', 'Tablet', 'Asiatic Laboratories Ltd.', '35.00', '0.00', '500 mg', 'Azithromycin'), 
('2148', 'Meclizine   50 mg', '023-01678', 'Tablet', 'Asiatic Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Meclizine Hydrochloride'), 
('2149', 'Coflyt   8 mg', '023-0169-031', 'Tablet', 'Asiatic Laboratories Ltd.', '0.00', '0.00', '8 mg', 'Bromhexine Hydrochloride'), 
('2150', 'Ceroxime   500 mg', '023-0172-23', 'Tablet', 'Asiatic Laboratories Ltd.', '45.00', '0.00', '500 mg', 'Cefuroxime'), 
('2151', 'Pairox   250 mg', '023-0178-64', 'Tablet', 'Asiatic Laboratories Ltd.', '5.00', '0.00', '250 mg', 'Naproxen'), 
('2152', 'Pairox0   500 mg', '023-0179-64', 'Tablet', 'Asiatic Laboratories Ltd.', '8.00', '0.00', '500 mg', 'Naproxen'), 
('2153', 'Ritoxib   60 mg', '023-0182-64', 'Tablet', 'Asiatic Laboratories Ltd.', '7.00', '0.00', '60 mg', 'Etoricoxib'), 
('2154', 'Ritoxib   90 mg', '023-0183-64', 'Tablet', 'Asiatic Laboratories Ltd.', '12.00', '0.00', '90 mg', 'Etoricoxib'), 
('2155', 'Ritoxib20   120 mg', '023-0184-64', 'Tablet', 'Asiatic Laboratories Ltd.', '14.00', '0.00', '120 mg', 'Etoricoxib'), 
('2156', 'Fendex      200 mg', '023-0185-64', 'Tablet', 'Asiatic Laboratories Ltd.', '3.00', '0.00', '200 mg', 'Dexibuprofen (S Ibuprofen)'), 
('2157', 'Fendex0   300 mg', '023-0186-64', 'Tablet', 'Asiatic Laboratories Ltd.', '4.00', '0.00', '300 mg', 'Dexibuprofen (S Ibuprofen)'), 
('2158', 'Fendex   400 mg', '023-0187-64', 'Tablet', 'Asiatic Laboratories Ltd.', '5.00', '0.00', '400 mg', 'Dexibuprofen (S Ibuprofen)'), 
('2159', 'Surpime   10 mg', '023-0192-064', 'Tablet', 'Asiatic Laboratories Ltd.', '10.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('2160', 'Calpress   5 mg', '023-0209-022', 'Tablet', 'Asiatic Laboratories Ltd.', '5.00', '0.00', '5 mg', 'Amlodipine'), 
('2161', 'Calpress   10 mg', '023-0210-022', 'Tablet', 'Asiatic Laboratories Ltd.', '7.00', '0.00', '10 mg', 'Amlodipine'), 
('2162', 'Atebit   50 mg', '023-0211-22', 'Tablet', 'Asiatic Laboratories Ltd.', '0.77', '0.00', '50 mg', 'Atenolol'), 
('2163', 'Atebit   100 mg', '023-0212-22', 'Tablet', 'Asiatic Laboratories Ltd.', '1.38', '0.00', '100 mg', 'Atenolol'), 
('2164', 'Arbium   25 mg', '023-0215-022', 'Tablet', 'Asiatic Laboratories Ltd.', '3.50', '0.00', '25 mg', 'Losartan Potassium'), 
('2165', 'Arbium   50 mg', '023-0216-022', 'Tablet', 'Asiatic Laboratories Ltd.', '8.00', '0.00', '50 mg', 'Losartan Potassium'), 
('2166', 'Arbium   100 mg', '023-0217-022', 'Tablet', 'Asiatic Laboratories Ltd.', '12.00', '0.00', '100 mg', 'Losartan Potassium'), 
('2167', 'Pericard   4 mg', '023-0223-22', 'Tablet', 'Asiatic Laboratories Ltd.', '12.00', '0.00', '4 mg', 'Perindopril Erbumine'), 
('2168', 'Pericard   2 mg', '023-0224-22', 'Tablet', 'Asiatic Laboratories Ltd.', '7.00', '0.00', '2 mg', 'Perindopril Erbumine'), 
('2169', 'Atonor   10 mg', '023-0228-061', 'Tablet', 'Asiatic Laboratories Ltd.', '10.00', '0.00', '10 mg', 'Atorvastatin'), 
('2170', 'Atonor   20 mg', '023-0229-061', 'Tablet', 'Asiatic Laboratories Ltd.', '18.00', '0.00', '20 mg', 'Atorvastatin'), 
('2171', 'Xofena80   180 mg', '023-0233-21', 'Tablet', 'Asiatic Laboratories Ltd.', '9.00', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('2172', 'Xofena   120 mg', '023-0232-21', 'Tablet', 'Asiatic Laboratories Ltd.', '7.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('2173', 'Xofena   60 mg', '023-0231-21', 'Tablet', 'Asiatic Laboratories Ltd.', '5.00', '0.00', '60 mg', 'Fexofenadine Hydrochloride'), 
('2174', 'Rosunor   10 mg', '023-0268-61', 'Tablet', 'Asiatic Laboratories Ltd.', '20.00', '0.00', '10 mg', 'Rosuvastatin'), 
('2175', 'Resfree   2 mg', '023-02694', 'Tablet', 'Asiatic Laboratories Ltd.', '1.70', '0.00', '2 mg', 'Levosalbutamol'), 
('2176', 'Resfree   1 mg', '023-02704', 'Tablet', 'Asiatic Laboratories Ltd.', '0.90', '0.00', '1 mg', 'Levosalbutamol'), 
('2177', 'Clogfree   75 mg', '023-0277-26', 'Tablet', 'Asiatic Laboratories Ltd.', '12.00', '0.00', '75 mg', 'Clopidogrel'), 
('2178', 'Rosunor   5 mg', '023-0278-61', 'Tablet', 'Asiatic Laboratories Ltd.', '10.00', '0.00', '5 mg', 'Rosuvastatin'), 
('2179', 'R   20 mg', '023-0279-67', 'Tablet', 'Asiatic Laboratories Ltd.', '5.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('2180', 'Nebivas   5 mg', '023-0282-22', 'Tablet', 'Asiatic Laboratories Ltd.', '10.00', '0.00', '5 mg', 'Nebivolol'), 
('2181', 'Nebivas   2.5 mg', '023-0283-22', 'Tablet', 'Asiatic Laboratories Ltd.', '5.00', '0.00', '2.5 mg', 'Nebivolol'), 
('2182', 'Asiflocin   320 mg', '023-0291-23', 'Tablet', 'Asiatic Laboratories Ltd.', '65.00', '0.00', '320 mg', 'Gemefloxacin'), 
('2183', 'Doxinex   200 mg', '023-03024', 'Tablet', 'Asiatic Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Doxophylline'), 
('2184', 'Sypam   2 mg', '023-0266-046', 'Tablet', 'Asiatic Laboratories Ltd.', '10.00', '0.00', '2 mg', 'Clonazepam'), 
('2185', 'Sypam.5   .5 mg', '023-0265-046', 'Tablet', 'Asiatic Laboratories Ltd.', '6.00', '0.00', '.5 mg', 'Clonazepam'), 
('2186', 'Sedoz   7.5 mg', '023-0264-057', 'Tablet', 'Asiatic Laboratories Ltd.', '9.50', '0.00', '7.5 mg', 'Midazolam'), 
('2187', 'Xibast   10 mg', '023-0263-21', 'Tablet', 'Asiatic Laboratories Ltd.', '6.00', '0.00', '10 mg', 'Ebastine'), 
('2188', 'Eso   40 mg', '023-0262-67', 'Tablet', 'Asiatic Laboratories Ltd.', '8.00', '0.00', '40 mg', 'Esomeprazole'), 
('2189', 'Onlit   4 mg', '023-0306-018', 'Tablet', 'Asiatic Laboratories Ltd.', '0.00', '0.00', '4 mg', 'Ondansetron'), 
('2190', 'Onlit 8   8 mg', '023-0309-018', 'Tablet', 'Asiatic Laboratories Ltd.', '0.00', '0.00', '8 mg', 'Ondansetron'), 
('2191', 'Morphine   10 mg', '023-0310-065', 'Tablet', 'Asiatic Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Morphine Sulphate'), 
('2192', 'Floximox   400 mg', '023-0311-023', 'Tablet', 'Asiatic Laboratories Ltd.', '0.00', '0.00', '400 mg', 'Moxifloxacin'), 
('2193', 'Tivonum   50 mg', '023-0312-011', 'Tablet', 'Asiatic Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('2194', 'NTZ   500 mg', '023-0314-027', 'Tablet', 'Asiatic Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Nitazoxanide'), 
('2195', 'Asixone IM   250 mg', '023-0249-23', 'IM Injection', 'Asiatic Laboratories Ltd.', '100.00', '0.00', '250 mg', 'Ceftriaxone'), 
('2196', 'Asixone0 IM   500 mg', '023-0247-23', 'IM Injection', 'Asiatic Laboratories Ltd.', '130.00', '0.00', '500 mg', 'Ceftriaxone'), 
('2197', 'Asixone gm IM   1 gm', '023-0245-23', 'IM Injection', 'Asiatic Laboratories Ltd.', '190.00', '0.00', '1 gm', 'Ceftriaxone'), 
('2198', 'Asixone IV   2 gm', '023-0275-23', 'IV Injection', 'Asiatic Laboratories Ltd.', '300.00', '0.00', '2 gm', 'Ceftriaxone'), 
('2199', 'Asixone   250 mg', '023-0250-23', 'IV Injection', 'Asiatic Laboratories Ltd.', '100.00', '0.00', '250 mg', 'Ceftriaxone'), 
('2200', 'Asixone0 IV   500 mg', '023-0248-23', 'IV Injection', 'Asiatic Laboratories Ltd.', '130.00', '0.00', '500 mg', 'Ceftriaxone'), 
('2201', 'Asixone gm IV   1 gm', '023-0246-23', 'IV Injection', 'Asiatic Laboratories Ltd.', '190.00', '0.00', '1 gm', 'Ceftriaxone'), 
('2202', 'Confree   .05 %', '023-02072', 'Nasal Drops', 'Asiatic Laboratories Ltd.', '45.00', '0.00', '.05 %', 'Oxymetazoline Hydrochloride'), 
('2203', 'Confree   .025 %', '023-02082', 'Nasal Drops', 'Asiatic Laboratories Ltd.', '40.00', '0.00', '.025 %', 'Oxymetazoline Hydrochloride'), 
('2204', 'Asipine%   1 %', '023-01282', 'Eye Drops', 'Asiatic Laboratories Ltd.', '80.00', '0.00', '1 %', 'Pilocarpine Hydrochloride'), 
('2205', 'Asinol%   .5 %', '023-01292', 'Eye Drops', 'Asiatic Laboratories Ltd.', '67.00', '0.00', '.5 %', 'Timolol Maleate'), 
('2206', 'Ocutear .3%   .3 %', '023-01762', 'Eye Drops', 'Asiatic Laboratories Ltd.', '65.00', '0.00', '.3 %', 'Hypromellose'), 
('2207', 'Ocutif .025%   .025 %', '023-01892', 'Eye Drops', 'Asiatic Laboratories Ltd.', '95.00', '0.00', '.025 %', 'Ketotifen'), 
('2208', 'Flurosia   .1 %', '023-02382', 'Eye Drops', 'Asiatic Laboratories Ltd.', '100.00', '0.00', '.1 %', 'Fluorometholone'), 
('2209', 'Liam   5 mg', '023-0271-044', 'Chewable Tablet', 'Asiatic Laboratories Ltd.', '8.00', '0.00', '5 mg', 'Montelukast'), 
('2210', 'Fluc   250 mg', '326-0004-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '5.50', '0.00', '250 mg', 'Flucloxacillin'), 
('2211', 'Lexin   250 mg', '326-0018-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Cephalexin'), 
('2212', 'Lexin   500 mg', '326-0019-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Cephalexin'), 
('2213', 'Mox   250 mg', '326-0012-023', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '3.60', '0.00', '250 mg', 'Amoxicillin'), 
('2214', 'Mox   500 mg', '326-0013-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '6.00', '0.00', '500 mg', 'Amoxicillin'), 
('2215', 'Sefty   250 mg', '326-0038-023', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Cephradine'), 
('2216', 'Sefty   500 mg', '326-0039-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Cephradine'), 
('2217', 'Tyclox   500 mg', '326-0023-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '5.95', '0.00', '500 mg', 'Cloxacillin'), 
('2218', 'Ometor   20 mg', '326-0036-67', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '4.00', '0.00', '20 mg', 'Omeprazole'), 
('2219', 'Ometor   40 mg', '326-0037-67', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '8.00', '0.00', '40 mg', 'Omeprazole'), 
('2220', 'Azithro   250 mg', '326-0046-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '20.00', '0.00', '250 mg', 'Azithromycin'), 
('2221', 'Dox P     100 mg', '326-0032-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '2.20', '0.00', '100 mg', 'Doxycycline'), 
('2222', 'Fluc   500 mg', '326-0028-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '10.00', '0.00', '500 mg', 'Flucloxacillin'), 
('2223', 'C-3   200 mg', '326-0053-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '35.00', '0.00', '200 mg', 'Cefixime'), 
('2224', 'Moov  SR    100 mg', '326-0048-64', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '2.50', '0.00', '100 mg', 'Diclofenac Sodium'), 
('2225', 'Flufun   50 mg', '326-0079', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '8.00', '0.00', '50 mg', 'Fluconazole'), 
('2226', 'Flufun   150 mg', '326-0078', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '22.00', '0.00', '150 mg', 'Fluconazole'), 
('2227', 'Clindacap   300 mg', '326-0121-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '15.00', '0.00', '300 mg', 'Clindamycin'), 
('2228', 'Clindacap   150 mg', '326-0120-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '8.00', '0.00', '150 mg', 'Clindamycin'), 
('2229', 'Pegamax   75 mg', '326-0119-046', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '16.00', '0.00', '75 mg', 'Pregabalin'), 
('2230', 'Pegamax   50 mg', '326-0118-046', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '11.00', '0.00', '50 mg', 'Pregabalin'), 
('2231', 'Esoz   40 mg', '326-0129-067', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '8.00', '0.00', '40 mg', 'Esomeprazole'), 
('2232', 'Esoz   20 mg', '326-0132-067', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '7.00', '0.00', '20 mg', 'Esomeprazole'), 
('2233', 'C   400 mg', '326-0135-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '50.00', '0.00', '400 mg', 'Cefixime'), 
('2234', 'Water for Injection   10 ml', '326-0083-79', 'Injection', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '10 ml', 'Water For Injection'), 
('2235', 'Gly   400 mg', '326-0015-27', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '1.14', '0.00', '400 mg', 'Metronidazole'), 
('2236', 'Reliv   500 mg', '326-0001-006', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('2237', 'Moov      50 mg', '326-0021-64', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.88', '0.00', '50 mg', 'Diclofenac Sodium'), 
('2238', 'Ciflocin0   500 mg', '326-0009-23', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '12.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('2239', 'Prozium   10 mg', '326-00036', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Clobazam'), 
('2240', 'Tyflam   400 mg', '326-0033-64', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '1.43', '0.00', '400 mg', 'Ibuprofen'), 
('2241', 'Tymin   4 mg', '326-0008-21', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.20', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('2242', 'Astac   150 mg', '326-00175', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('2243', 'Cetriz   10 mg', '326-0005-21', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '2.50', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('2244', 'Verben   400 mg', '326-0027-008', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '4.00', '0.00', '400 mg', 'Albendazole'), 
('2245', 'Zopi   7.5 mg', '326-0043-057', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '7.5 mg', 'Zopiclone'), 
('2246', 'Calcibo   1250 mg', '326-0030-62', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '3.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('2247', 'Domperon   10 mg', '326-00348', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '2.00', '0.00', '10 mg', 'Domperidone'), 
('224